/* Include the autoconf-generated configuration header.  */
#include "autoconf.h"

/* If true, send the responsible person mail if they haven't analyzed
   a PR within the desired response time (use at_pr).  */
extern int flag_notify;

/* If true, send a reply to the person who submitted the bug, telling
   them the PR number and other information.  */
extern int flag_ack;

/* The submitter-id to be used when a PR comes in either
   without one, or with a bogus id.  An alternative to "unknown" might be
   "net", if you anticipate getting lots of reports from the Net.  */
extern char* def_subm;

/* Every email message has one or more `Received:' headers to tell you
   how a message got from the sender to the recipient.  Define this to
   be TRUE if you want GNATS to preserve all of those `Received:' headers.
   If you tend not to use the information, define it to be FALSE so GNATS
   will only keep the first `Received:' header.  */
extern int keep_rec;

/* Mail everything to the GNATS administrator. */
#define DEBUG_MODE 0		/* default value */
extern int debug_mode;

extern char *gnats_root;		/* Top of GNATS tree */
extern char *gnats_addr;		/* Address to send bugs to */

/* Address of the person to receive all problem reports which do not
   have a valid category (aka, they go into `pending'), or other related
   problems.  */
extern char *gnats_admin;

/* Defining values for business hours */
extern int bday_start, bday_end, bweek_start, bweek_end;

/* Mailing program */
#ifndef BIN_MAIL
#define BIN_MAIL "/bin/mail"
#endif
#ifndef MAIL_AGENT
#define MAIL_AGENT "/usr/lib/sendmail -oi -t"
#endif
#undef USE_BIN_MAIL

extern char *mail_agent;

/* Default size of char arrays.  */
#define STR_MAX 255


/* These files are currently live under GNATS_ADM.  */

/* Ordered list of possible states, with optional brief descriptions.  */
#define STATES "/states"

/* Ordered list of possible classes, with optional brief descriptions.  */
#define CLASSES "/classes"

/* List of possible categories, with notification information.  */
#define CATEGORIES "/categories"

/* List of submitters (e.g., members of a team, sites on the net, customers,
   etc.) which can send in bug reports via send-pr.  */
#define SUBMITTERS "/submitters"

/* List of names (and possibly email addresses) for the different people
   responsible for a given PR.  `responsible' is somewhat of a misnomer, since
   the person responsible may well be a local user.  But the name stuck.  */
#define RESPONSIBLE_FILE  "/responsible"

/* File used to provide fast lookups on certain fields.  */
#define INDEX "/index"

/* List of the access allowed for the GNATS daemon.  */
#define ACCESS_FILE		"gnatsd.conf"

/* Pathnames of GNATS-specific commands and tools.  */
extern char *bindir;

/* GNATS config file for list-config.  */
#define CONFIG "/config"
