# Copyright (C) 1999, 2000, 2001 Milan Zamazal
#
# COPYRIGHT NOTICE
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.


"""Configuration.


"""

__author__  = "Milan Zamazal <pdm@zamazal.org>"
__version__ = "$Id: config.py,v 1.12 2001/04/15 07:25:26 pdm Exp $"
__copyright__ = "GNU General Public License, version 2"


# Directory containing gnats2w DTML templates
TEMPLATE_DIR = '/usr/share/gnats2w/templates'

# GNATS database directory
# If it is an empty string, GNATS default is used.
# Otherwise, typical value can be something like '/var/lib/gnats/gnats-db'.
GNATS_DIR = ''

# GNATS internal programs directory
GNATS_PRG_DIR = '/usr/lib/gnats'

# Site to submit bugs to
SITE = 'localsite'

# E-mail of the administrator
ADMIN_MAIL = 'gnats-admin@localhost'

# Command to send a mail given on standard input
MAIL = '/usr/lib/sendmail -oi -t'
# For qmail users:
# MAIL = '/usr/sbin/qmail-inject'

# Host URL, including protocol and port number (if needed)
HOST_URL = 'http://localhost'

# Base URL for static HTML documents, it must be a full pointer to `index.html'
BASE_URL = 'http://localhost/gnats2w/index.html'

# Default language code
LANGUAGE = ''

# Path to the directory with language dictionaries
DICTIONARY_DIR = '/usr/share/gnats2w/lang'

# Path to the local language directory
DICTIONARY_DIR_LOCAL = '/usr/local/share/gnats2w/lang/local'

# Default problem category
DEFAULT_CATEGORY = 'test'

# Function to generate the local part of the index page
LOCAL_INDEX_FUNCTION = None

# Whether to set confidentiality of new reports automatically (wrt. category)
AUTO_CONFIDENTIAL = 0

# Visibility flags
DISPLAY_CONFIDENTIAL = 1
DISPLAY_ORGANIZATION = 1
DISPLAY_IDREQUEST = 1


def init ():
    """Init things possibly causing circular module dependencies.
    """
    # Gnats object for communication with GNATS; use
    #  GNATS = gnats.Gnats3 ()
    # if you use GNATS 3.113.
    global GNATS
    import gnats
    GNATS = gnats.Gnats ()
    # Access class instance
    global ACCESS
    from access import Access
    ACCESS = Access ()
    # Load local configuration if any
    try:
        execfile ('config', globals ())
    except:
        pass
