'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) panedwindow.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS panedwindow iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
panedwindow \- Create and manipulate a paned window widget
.SH SYNOPSIS
\fBpanedwindow\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- panedwindow
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBcursor\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-height\fR
.fi
.IP
Specifies the overall height of the paned window in any of the forms 
acceptable to \fBTk_GetPixels\fR.  The default is 10 pixels.
.LP
.nf
Name:	\fBorient\fR
Class:	\fBOrient\fR
Command-Line Switch:	\fB-orient\fR
.fi
.IP
Specifies the orientation of the separators: \fBvertical\fR or 
\fBhorizontal\fR.  The default is horizontal.
.LP
.nf
Name:	\fBsashBorderWidth\fR
Class:	\fBBorderWidth\fR
Command-Line Switch:	\fB-sashborderwidth\fR
.fi
.IP
Specifies a value indicating the width of the 3-D border to draw 
around the outside of the sash in any of the forms acceptable to 
\fBTk_GetPixels\fR.  The default is 2 pixels.
.LP
.nf
Name:	\fBsashCursor\fR
Class:	\fBCursor\fR
Command-Line Switch:	\fB-sashcursor\fR
.fi
.IP
Specifies the type of cursor to be displayed in the sash.  The default
is crosshair.
.LP
.nf
Name:	\fBsashHeight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB-sashheight\fR
.fi
.IP
Specifies the height of the sash in any of the forms acceptable to 
\fBTk_GetPixels\fR.  The default is 10 pixels.
.LP
.nf
Name:	\fBsashIndent\fR
Class:	\fBSashIndent\fR
Command-Line Switch 	\fBsashindent\fR
.fi
.IP
Specifies the placement of the sash along the panes in any of the forms 
acceptable to \fBTk_GetPixels\fR.  A positive
value causes the sash to be offset from the near (left/top) side
of the pane, and a negative value causes the sash to be offset from
the far (right/bottom) side.  If the offset is greater than the 
width, then the sash is placed flush against the side.  The
default is -10 pixels.
.LP
.nf
Name:	\fBsashWidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-sashwidth\fR
.fi
.IP
Specifies the width of the sash in any of the forms acceptable to 
\fBTk_GetPixels\fR.  The default is 10 pixels.
.LP
.nf
Name:	\fBthickness\fR
Class:	\fBThickness\fR
Command-Line Switch:	\fB-thickness\fR
.fi
.IP
Specifies the thickness of the separators in any of the forms acceptable to 
\fBTk_GetPixels\fR.  The default is 3 pixels.
.LP
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB-width\fR
.fi
.IP
Specifies the overall width of the paned window in any of the forms 
acceptable to \fBTk_GetPixels\fR.  The default is 10 pixels.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBpanedwindow\fR command creates a multiple paned window widget 
capable of orienting the panes
either vertically or horizontally.  Each pane is itself a frame acting
as a child site for other widgets.  The border separating each pane 
contains a sash which allows user positioning of the panes relative to
one another.  

.SH "METHODS"
.PP
The \fBpanedwindow\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  
.PP
Many of the widget commands for the \fBpanedwindow\fR take as one argument an
indicator of which pane of the paned window to operate on.  These indicators
are called \fIindexes\fR and allow reference and manipulation of panes 
regardless of their current map state.  Paned window indexes may be 
specified in any of the following forms:
.TP 12
\fInumber\fR
Specifies the pane numerically, where 0 corresponds to the nearest 
(top/left-most) pane of the paned window. 
.TP 12
\fBend\fR
Indicates the farthest (bottom/right-most) pane of the paned window.
.TP 12
\fIpattern\fR
If the index doesn't satisfy one of the above forms then this
form is used.  \fIPattern\fR is pattern-matched against the tag of
each pane in the panedwindow, in order from left/top to right/left,
until a matching entry is found.  The rules of \fBTcl_StringMatch\fR
are used.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBadd\fR \fItag\fR ?\fIoption value option value\fR?
Adds a new pane to the paned window on the far side (right/bottom).  The 
following options may be specified:
.RS
.TP
\fB-margin\fR \fIvalue\fR
Specifies the border distance between the pane and pane contents is any of
the forms acceptable to \fBTk_GetPixels\fR.  The default is 8 pixels.
.TP
\fB-minimum\fR \fIvalue\fR
Specifies the minimum size that a pane's contents may reach not
inclusive of twice the margin in any of the forms acceptable to 
\fBTk_GetPixels\fR.  The default is 10 pixels.

The \fBadd\fR method returns the path name of the pane.
.RE
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBpanedwindow\fR
command.
.TP
\fIpathName \fBchildsite\fR ?\fIindex\fR?
Returns a list of the child site path names or a specific child site given 
an index.  The list is constructed from the near side (left/top) to the far 
side (right/bottom).
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBpanedwindow\fR
command.
.TP
\fIpathName \fBdelete\fR \fIindex\fR
Deletes a specified pane given an \fIindex\fR.
.TP
\fIpathName \fBfraction\fR \fIpercentage\fR \fIpercentage\fR ?\fIpercentage percentage ...\fR?
Sets the visible percentage of the panes.  Specifies a set of
percentages which are applied to the visible panes from the near side
(left/top).  The number of percentages must be equal to the current number
of visible (mapped) panes and add up to 100.
.TP
\fIpathName \fBhide\fR \fIindex\fR
Changes the visiblity of the specified pane, allowing a previously displayed
pane to be visually removed rather than deleted.
.TP
\fIpathName \fBindex\fR \fIindex\fR
Returns the numerical index corresponding to index.
.TP
\fIpathName \fBinsert \fIindex\fR \fItag\fR ?\fIoption value option value ...\fR?
Same as the \fBadd\fR command except that it inserts the new
pane just before the one given by \fIindex\fR, instead of appending
to the end of the panedwindow.  The \fIoption\fR, and \fIvalue\fR
arguments have the same interpretation as for the \fBadd\fR widget
command.  
.TP
\fIpathName \fBpaneconfigure\fR \fIindex\fR ?\fIoptions\fR?
This command is similar to the \fBconfigure\fR command, except that
it applies to the options for an individual pane, whereas \fBconfigure\fR
applies to the options for the paned window as a whole.
\fIOptions\fR may have any of the values accepted by the \fBadd\fR
widget command.  If \fIoptions\fR are specified, options are modified
as indicated in the command and the command returns an empty string.
If no \fIoptions\fR are specified, returns a list describing
the current options for entry \fIindex\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).
.TP
\fIpathName \fBreset\fR
Redisplays the pane window using default percentages.
.TP
\fIpathName \fBshow\fR \fIindex\fR
Changes the visiblity of the specified pane, allowing a previously hidden
pane to be displayed.

.SH "NOTES"
.IP
Dynamic changing of the margin and or minimum options to values which
make the current configuration invalid will block subsequent sash
movement until the fractions are modified via the fraction method.
For example a panedwindow is created with three panes and the minimum
and margin options are at their default settings.  Next the user moves
the sashes to compact the panes to one side.  Now, if the minimum is
increased on the most compressed pane via the paneconfigure method to 
a large enough value, then sash movement is blocked
until the fractions are adjusted.  This situation is unusual and under
normal operation of the panedwindow, this problem will never occur.
.LP

.SH EXAMPLE
.DS
 panedwindow .pw -width 300 -height 300 
 .pw add top
 .pw add middle -margin 10
 .pw add bottom -margin 10 -minimum 10

 pack .pw -fill both -expand yes

 foreach pane [.pw childSite] {
    button $pane.b -text $pane -relief raised -borderwidth 2
    pack $pane.b -fill both -expand yes
 }

 .pw fraction 50 30 20
 .pw paneconfigure 0 -minimum 20
 .pw paneconfigure bottom -margin 15
.DE
.SH ACKNOWLEDGEMENTS:
.LP
Jay Schmidgall
.IP
1994 - Base logic posted to comp.lang.tcl
.LP
Joe Hidebrand <hildjj@fuentez.com>
.IP
07/25/94 - Posted first multipane version to comp.lang.tcl
.LP
.IP
07/28/94 - Added support for vertical panes
.LP
Ken Copeland <ken@hilco.com>
.IP
09/28/95 - Smoothed out the sash movement and added squeezable panes.
.LP
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
panedwindow, widget
