/*
To compile: cc -Ae -g -o attach_rtc -lpthread attach_rtc.c
To run: attach_rtc
*/

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <pthread.h>

#define TRUE 1
#define FALSE 0
#define N_THREADS 3
#define MAX_LOCAL_VAL 40
#define OUTER_LOOP_COUNT 3

/* Check the results of thread-local storage. */
int thread_local_val[ N_THREADS ];

/* Routine for each thread to run, does nothing. */
void *spin( vp )
    void * vp;
{
   void * ll;
   int i, cnt = 0;

   for (i=0; i < 1000000; i++)
       cnt += i;
   ll = malloc(i*100);

   return ((void *)NULL);
}

void
do_pass( pass )
    int pass;
{
    int i, err;
    pthread_t t[ N_THREADS ];

    for( i = 0; i < N_THREADS; i++ ) {
        err = pthread_create( &t[i], NULL, spin, (void *)i );
        if( err != 0 ) {
            printf( "pthread_create error (err=%d) for thread %d\n", err, i );
        }
    }

    for( i = 0; i < N_THREADS; i++ ) {
        err = pthread_join(t[i], NULL );
        if( err != 0 ) {
            printf( "pthread_join error for thread %d\n", i );
        }
    }
}

void
do_it()
{
    int i;
    
    for( i = 0; i < OUTER_LOOP_COUNT; i++ )
        do_pass( i );
}

volatile int wait_here = 1;

main()
{
   char* ll;
   (void) alarm(60);
   /*__rtc_init_leaks(4);*/
   ll = malloc (21);
   ll = malloc (20);
   ll = malloc (10);
   do_it();
   
   while(wait_here);
   ll = malloc (20);
   ll = malloc (10);
   return(0);
}
