C Example from HP Fortran/9000 programmer's reference manual

      PROGRAM STACK_EXAMPLE
      CALL PUSH(10)
      CALL PUSH(15)
      CALL POP(I)
      CALL POP(J)
      PRINT *, "I = ", I
      PRINT *, "J = ", J
      END PROGRAM STACK_EXAMPLE

      SUBROUTINE MANIPULATE_STACK
        IMPLICIT NONE
        INTEGER SIZE, TOP, VALUE
        PARAMETER (SIZE = 5)
        INTEGER STACK(SIZE)
        SAVE STACK, TOP
        DATA TOP /0/

C PUSH VALUE ONTO THE STACK
      ENTRY PUSH (VALUE)
        IF (TOP .EQ. SIZE) STOP 'STACK OVERFLOW'
        TOP = TOP + 1
        STACK(TOP) = VALUE
        RETURN

C POP THE TOP OF THE STACK AND PLACE IN VALUE
      ENTRY POP (VALUE)
        IF (TOP .EQ. 0) STOP 'STACK UNDERFLOW'
        VALUE = STACK(TOP)
        TOP = TOP - 1
        RETURN
      
      END SUBROUTINE MANIPULATE_STACK
