#include "MLCG.h"
//
//	SEED_TABLE_SIZE must be a power of 2
//


#define SEED_TABLE_SIZE 32

static long seedTable[SEED_TABLE_SIZE] = {
0xbdcc47e5, 0x54aea45d, 0xec0df859, 0xda84637b,
0xc8c6cb4f, 0x35574b01, 0x28260b7d, 0x0d07fdbf,
0x9faaeeb0, 0x613dd169, 0x5ce2d818, 0x85b9e706,
0xab2469db, 0xda02b0dc, 0x45c60d6e, 0xffe49d10,
0x7224fea3, 0xf9684fc9, 0xfc7ee074, 0x326ce92a,
0x366d13b5, 0x17aaa731, 0xeb83a675, 0x7781cb32,
0x4ec7c92d, 0x7f187521, 0x2cf346b4, 0xad13310f,
0xb89cff2b, 0x12164de1, 0xa865168d, 0x32b56cdf
};

void MLCG::reset()
{
    //
    //	Most people pick stupid seed numbers that don't have enough
    //	bits. In this case, if they pick a small seed number, we
    //	map that to a specific seed.
    //
    if (initialSeedOne < 0) {
	initialSeedOne = (initialSeedOne + 2147483561);
	initialSeedOne = (initialSeedOne < 0) ? -initialSeedOne : initialSeedOne;
    }

    if (initialSeedTwo < 0) {
	initialSeedTwo = (initialSeedTwo + 2147483561);
	initialSeedTwo = (initialSeedTwo < 0) ? -initialSeedTwo : initialSeedTwo;
    }

    if (initialSeedOne > -1 && initialSeedOne < SEED_TABLE_SIZE) {
	seedOne = seedTable[initialSeedOne];
    } else {
	seedOne = initialSeedOne ^ seedTable[initialSeedOne & (SEED_TABLE_SIZE-1)];
    }

    if (initialSeedTwo > -1 && initialSeedTwo < SEED_TABLE_SIZE) {
	seedTwo = seedTable[initialSeedTwo];
    } else {
	seedTwo = initialSeedTwo ^ seedTable[initialSeedTwo & (SEED_TABLE_SIZE-1)];
    }

    seedOne = (seedOne % 2147483561) + 1;
    seedTwo = (seedTwo % 2147483397) + 1;
}

unsigned long MLCG::asLong()
{
    long k = seedOne % 53668;

    seedOne = 40014 * (seedOne-k * 53668) - k * 12211;
    if (seedOne < 0) {
	seedOne += 2147483563;
    }

    k = seedTwo % 52774;
    seedTwo = 40692 * (seedTwo - k * 52774) - k * 3791;
    if (seedTwo < 0) {
	seedTwo += 2147483399;
    }

    long z = seedOne - seedTwo;
    if (z < 1) {
	z += 2147483562;
    }
    return( (unsigned long) z);
}
