/*
 a test/demo of BitSets & BitVecs
*/

#include <BitSet.h>
#include <BitVec.h>

BitSet_test()
{
  cout << "BitSet tests:\n";

  BitSet a = 0;
  cout << "a = " << a << "\n";

  BitSet b = 1024;
  cout << "b = " << b << "\n";

  BitSet c = atoBitSet("1010101010101010101010101010101010101010");
  cout << "c = " << c << "\n";

  BitSet d = atoBitSet("0011001100110011001100110011001100110011");
  cout << "d = " << d << "\n";

  BitSet e = atoBitSet("1111000011110000111100001111000011110000");
  cout << "e = " << e << "\n";

  BitSet u = ~a;
  cout << "u = ~a = " << u << "\n";

  BitSet g = ~e;
  cout << "g = ~e = " << g << "\n";

  cout << "~c = " << (~c) << "\n";
  cout << "c & d = " << (c & d) << "\n";
  cout << "c | d = " << (c | d) << "\n";
  cout << "c - d = " << (c - d) << "\n";
  cout << "c ^ d = " << (c ^ d) << "\n";

  BitSet f = b;
  cout << "f = b = " << f << "\n";
  cout << "f &= c = " << (f &= c) << "\n";
  cout << "f |= d = " << (f |= d) << "\n";
  cout << "f -= e = " << (f -= e) << "\n";
  cout << "f ^= u = " << (f ^= u) << "\n";
  
  cout << "c == d = " << (c == d) << "\n";
  cout << "c != d = " << (c != d) << "\n";
  cout << "c <  d = " << (c <  d) << "\n";
  cout << "c <= d = " << (c <= d) << "\n";
  cout << "c >  d = " << (c >  d) << "\n";
  cout << "c >= d = " << (c >= d) << "\n";

  for (int p = 0; p < 5; ++p)
    cout << "c.test(" << p << ") =" << c.test(p) << "\n";

  BitSet h = d;
  cout << "h = d\n:" << h << "\n";
  h.set(0);
  cout << "h.set(0):\n" << h << "\n";

  cout << "d == h = " << (d == h) << "\n";
  cout << "d != h = " << (d != h) << "\n";
  cout << "d <  h = " << (d <  h) << "\n";
  cout << "d <= h = " << (d <= h) << "\n";
  cout << "d >  h = " << (d >  h) << "\n";
  cout << "d >= h = " << (d >= h) << "\n";

  h.set(65);
  cout << "h.set(65):\n" << h << "\n";
  h.clear(2);
  cout << "h.clear(2):\n" << h << "\n";
  h.invert(11,20);
  cout << "h.invert(11,20):\n" << h << "\n";
  h.set(21,30);
  cout << "h.set(21,30):\n" << h << "\n";
  h.clear(31,40);
  cout << "h.clear(31, 40):\n" << h << "\n";
  cout << "h.test(0,5) = " << h.test(0, 5) << "\n";
  cout << "h.test(31,40) = " << h.test(31, 40) << "\n";

  cout << "set bits in e:\n";
  for (p = e.first(); p >= 0; p = e.next(p))
    cout << p << " ";
  cout << "\n";
  cout << "e.count()= " << e.count() << "\n";
  cout << "e.count(0)= " << e.count(0) << "\n";

  cout << "clear bits in g (reverse order):\n";
  for (p = g.last(0); p >= 0; p = g.previous(p, 0))
    cout << p << " ";
  cout << "\n";
  cout << "g.count()= " << g.count() << "\n";
  cout << "g.count(0)= " << g.count(0) << "\n";

  cout << "\nEnd of test.\n";
}

BitVec_test()
{
  cout << "BitVec tests:\n";

  BitVec a(40);
  cout << "a = " << a << "\n";

  BitVec b(40);
  b[9] = 1;
  cout << "b = " << b << "\n";

  BitVec c = atoBitVec("1010101010101010101010101010101010101010");
  cout << "c = " << c << "\n";

  BitVec d = atoBitVec("0011001100110011001100110011001100110011");
  cout << "d = " << d << "\n";

  BitVec e = atoBitVec("1111000011110000111100001111000011110000");
  cout << "e = " << e << "\n";

  BitVec u = ~a;
  cout << "u = ~a = " << u << "\n";

  BitVec g = ~e;
  cout << "g = ~e = " << g << "\n";

  cout << "~c = " << (~c) << "\n";
  cout << "c & d = " << (c & d) << "\n";
  cout << "c | d = " << (c | d) << "\n";
  cout << "c - d = " << (c - d) << "\n";
  cout << "c ^ d = " << (c ^ d) << "\n";

  BitVec f = b;
  cout << "f = b = " << f << "\n";
  cout << "f &= c = " << (f &= c) << "\n";
  cout << "f |= d = " << (f |= d) << "\n";
  cout << "f -= e = " << (f -= e) << "\n";
  cout << "f ^= u = " << (f ^= u) << "\n";
  
  cout << "c == d = " << (c == d) << "\n";
  cout << "c != d = " << (c != d) << "\n";
  cout << "c <  d = " << (c <  d) << "\n";
  cout << "c <= d = " << (c <= d) << "\n";
  cout << "c >  d = " << (c >  d) << "\n";
  cout << "c >= d = " << (c >= d) << "\n";

  for (int p = 0; p < 5; ++p)
    cout << "c[" << p << "] =" << int(c[p]) << "\n";

  BitVec h = d;
  cout << "h = d:\n" << h << "\n";
  h[0] = 1;
  cout << "h[0] = 1:\n" << h << "\n";

  cout << "d == h = " << (d == h) << "\n";
  cout << "d != h = " << (d != h) << "\n";
  cout << "d <  h = " << (d <  h) << "\n";
  cout << "d <= h = " << (d <= h) << "\n";
  cout << "d >  h = " << (d >  h) << "\n";
  cout << "d >= h = " << (d >= h) << "\n";

  cout << "e.count()= " << e.count() << "\n";
  cout << "e.count(0)= " << e.count(0) << "\n";
  cout << "g.count()= " << g.count() << "\n";
  cout << "g.count(0)= " << g.count(0) << "\n";
}

main()
{
  BitSet_test();
  BitVec_test();
  cout << "\nEnd of test.\n";
}
