/*
 test/demo of AVL tree classes
*/

#include <stream.h>
#include "intintAVLSet.h"
#include "intintAVLAssoc.h"

int my_compare(int a, int b)
{
  return a - b;
}

void printint(int x)
{
  cout << x << " ";
}



void printAVLAssoc(intintAVLAssoc& h)
{
  cout << "count = " << h.count() << ", contents:\n";
  for (intintAVLAssocTrav p(h); p; p.advance())
    cout << "(" << p.key() << ", " << p.get() << ")";
  cout << "\n";
}

void printintAVLSet(intintAVLSet& l)
{
  l.apply(printint);
  cout << "\n";
}


void some_ints(intintAVLSet& a, int lo, int hi)
{
  for (int i = hi; i >= lo; --i)
    a.add(i);
}

void some_rands(intintAVLSet& a, int n)
{
  while (n-- > 0)
    a.add((int)rand() % 50);
}

main()
{
  intintAVLSet::item_item_comparison_function = my_compare;
  intintAVLSet::key_item_comparison_function = my_compare;
  intintAVLAssoc::key_key_comparison_function = my_compare;
  int i;

  cout << "using AVLSet tree of ints\n";
  intintAVLSet a; some_ints(a, 1, 20);
  intintAVLSet b; some_ints(b, 11, 30);
  intintAVLSet c; some_rands(c, 20);
  intintAVLSet d; some_rands(d, 20);
  
  cout << "a        ="; printintAVLSet(a);
  cout << "b        ="; printintAVLSet(b);
  cout << "c        ="; printintAVLSet(c);
  cout << "d        ="; printintAVLSet(d);
  intintAVLSet f = a;
  cout << "f = a    ="; printintAVLSet(f);

  cout << "a.contains(5)= " << a.contains(5) << "\n";
  cout << "a.del(5) ="; a.del(5); printintAVLSet(a);

  intintAVLSet e;
  cout << "e        ="; printintAVLSet(e);
  e |= a;
  cout << "e |= a   ="; printintAVLSet(e);
  e &= b;
  cout << "e &= b   ="; printintAVLSet(e);
  e -= c;
  cout << "e -= c   ="; printintAVLSet(e);
  e ^= d;
  cout << "e ^= d   ="; printintAVLSet(e);
  cout << "deleting elements of e from f, one-by-one...\n";
  for (intintAVLSetTrav ep(e); ep; ep.advance())
    f.del(ep.get());
  cout << "f        ="; printintAVLSet(f);
  e.destructive_union(a);
  cout << "after e.destructive_union(a):\n";
  cout << "e        ="; printintAVLSet(e);
  cout << "a        ="; printintAVLSet(a);

  cout << "b via reverse order traverser:\n";
  for (intintAVLSetTrav bp(b, -1); bp; bp.advance(-1))
    cout << bp.get() << ", ";
  cout << "\n";


  intintAVLAssoc t;
  cout << "\nusing intintAVLAssoc t...\n";
  printAVLAssoc(t);
  t[1000] = 1000;
  cout << "after t[1000] = 1000, t[1000] = " << t[1000] << "\n";
  printAVLAssoc(t);
  cout << "t.contains(1000) = " << t.contains(1000) << "\n";
  cout << "t.contains(2000) = " << t.contains(2000) << "\n";
  cout << "t[2000] = " << t[2000] << "\n";
  cout << "inserting...\n";
  for (i = 0; i < 10; ++i)
  {
    int key = rand() % 100;
    int cont = rand() % 100 + 500;
    cout << "(" << key << ", " << cont << ")";
    t[key] = cont;
  }
  cout << "\n";
  printAVLAssoc(t);
  t.del(1000);
  cout << "after t.del(1000), t.contains(1000) = " << t.contains(1000) << "\n";
  printAVLAssoc(t);
  t.clear();
  cout << "after t.clear()\n";
  printAVLAssoc(t);

  cout << "\nEnd of test\n";
}
