/*
 test/demo of CHash  classes
*/

#include <stream.h>
#include "intintCHashSet.h"
#include "intintCHashAssoc.h"

int my_eq(int a, int b)
{
  return a == b;
}

void printint(int x)
{
  cout << x << " ";
}



void printCHashAssoc(intintCHashAssoc& h)
{
  cout << "count = " << h.count() << ", contents:\n";
  for (intintCHashAssocTrav p(h); p; p.advance())
    cout << "(" << p.key() << ", " << p.get() << ")";
  cout << "\n";
}

void printintCHashSet(intintCHashSet& l)
{
  l.apply(printint);
  cout << "\n";
}


void some_ints(intintCHashSet& a, int lo, int hi)
{
  for (int i = hi; i >= lo; --i)
    a.add(i);
}

void some_rands(intintCHashSet& a, int n)
{
  while (n-- > 0)
    a.add((int)rand() % 50);
}

main()
{
  intintCHashSet::item_item_equality_function = my_eq;
  intintCHashSet::key_item_equality_function = my_eq;
  intintCHashSet::key_hash_function = multiplicativehash;
  intintCHashSet::item_hash_function = multiplicativehash;
  intintCHashAssoc::key_hash_function = multiplicativehash;
  intintCHashAssoc::key_key_equality_function = my_eq;
  int i;

  cout << "using CHashSet  of ints\n";
  intintCHashSet a(50); some_ints(a, 1, 20);
  intintCHashSet b(50); some_ints(b, 11, 30);
  intintCHashSet c(50); some_rands(c, 20);
  intintCHashSet d(50); some_rands(d, 20);
  
  cout << "a        ="; printintCHashSet(a);
  cout << "b        ="; printintCHashSet(b);
  cout << "c        ="; printintCHashSet(c);
  cout << "d        ="; printintCHashSet(d);
  intintCHashSet f(a);
  cout << "f = a    ="; printintCHashSet(f);

  cout << "a.contains(5)= " << a.contains(5) << "\n";
  cout << "a.del(5) ="; a.del(5); printintCHashSet(a);

  intintCHashSet e(50);
  cout << "e        ="; printintCHashSet(e);
  e |= a;
  cout << "e |= a   ="; printintCHashSet(e);
  e &= b;
  cout << "e &= b   ="; printintCHashSet(e);
  e -= c;
  cout << "e -= c   ="; printintCHashSet(e);
  e ^= d;
  cout << "e ^= d   ="; printintCHashSet(e);
  cout << "deleting elements of e from f, one-by-one...\n";
  for (intintCHashSetTrav ep(e); ep; ep.advance())
    f.del(ep.get());
  cout << "f        ="; printintCHashSet(f);

  cout << "b via traverser:\n";
  for (intintCHashSetTrav bp(b); bp; bp.advance())
    cout << bp.get() << ", ";
  cout << "\n";


  intintCHashAssoc t(50);
  cout << "\nusing intintCHashAssoc t...\n";
  printCHashAssoc(t);
  t[1000] = 1000;
  cout << "after t[1000] = 1000, t[1000] = " << t[1000] << "\n";
  printCHashAssoc(t);
  cout << "t.contains(1000) = " << t.contains(1000) << "\n";
  cout << "t.contains(2000) = " << t.contains(2000) << "\n";
  cout << "t[2000] = " << t[2000] << "\n";
  cout << "inserting...\n";
  for (i = 0; i < 10; ++i)
  {
    int key = rand() % 100;
    int cont = rand() % 100 + 500;
    cout << "(" << key << ", " << cont << ")";
    t[key] = cont;
  }
  cout << "\n";
  printCHashAssoc(t);
  t.del(1000);
  cout << "after t.del(1000), t.contains(1000) = " << t.contains(1000) << "\n";
  printCHashAssoc(t);
  t.clear();
  cout << "after t.clear()\n";
  printCHashAssoc(t);

  cout << "\nEnd of test\n";
}
