#include "MLCG.h"
//
//	SEED_TABLE_SIZE must be a power of 2
//


#define SEED_TABLE_SIZE 32

static long seedTable[SEED_TABLE_SIZE] = {
0xbdcc47e5, 0x54aea45d, 0xec0df859, 0xda84637b,
0xc8c6cb4f, 0x35574b01, 0x28260b7d, 0x0d07fdbf,
0x9faaeeb0, 0x613dd169, 0x5ce2d818, 0x85b9e706,
0xab2469db, 0xda02b0dc, 0x45c60d6e, 0xffe49d10,
0x7224fea3, 0xf9684fc9, 0xfc7ee074, 0x326ce92a,
0x366d13b5, 0x17aaa731, 0xeb83a675, 0x7781cb32,
0x4ec7c92d, 0x7f187521, 0x2cf346b4, 0xad13310f,
0xb89cff2b, 0x12164de1, 0xa865168d, 0x32b56cdf
};

MLCG::MLCG(long seed1, long seed2)
{
    //
    //	Most people pick stupid seed numbers that don't have enough
    //	bits. In this case, if they pick a small seed number, we
    //	map that to a specific seed.
    //
    if (seed1 < 0) {
	seed1 = (seed1 + 2147483561);
	seed1 = (seed1 < 0) ? -seed1 : seed1;
    }

    if (seed2 < 0) {
	seed2 = (seed2 + 2147483561);
	seed2 = (seed2 < 0) ? -seed2 : seed2;
    }

    if (seed1 > -1 && seed1 < SEED_TABLE_SIZE) {
	s1 = seedTable[seed1];
    } else {
	s1 = seed1 ^ seedTable[seed1 & (SEED_TABLE_SIZE-1)];
    }

    if (seed2 > -1 && seed2 < SEED_TABLE_SIZE) {
	s2 = seedTable[seed2];
    } else {
	s2 = seed2 ^ seedTable[seed2 & (SEED_TABLE_SIZE-1)];
    }

    s1 = (s1 % 2147483561) + 1;
    s2 = (s2 % 2147483397) + 1;
}

unsigned long MLCG::asLong()
{
    long k = s1 % 53668;

    s1 = 40014 * (s1-k * 53668) - k * 12211;
    if (s1 < 0) {
	s1 += 2147483563;
    }

    k = s2 % 52774;
    s2 = 40692 * (s2 - k * 52774) - k * 3791;
    if (s2 < 0) {
	s2 += 2147483399;
    }

    long z = s1 - s2;
    if (z < 1) {
	z += 2147483562;
    }
    return( (unsigned long) z);
}
