/*
 another test file for Integer class
 */

#include <Integer.h>
#include <std.h>
#include "test5.h"

/* Define a memoization for class `Integer'.
   The initialization argument list for the constructor is `(int size)'.
   The bodies of the constructor taking that argument list,
   and the destructor are also given in this macro.  */
DEFINE_MEMOIZATION (Integer,
		    (int size),
		    {
		      if (size < 0)
			{
			  cerr << "table size < 0 not allowed, aborting...\n";
			  exit (-1);
			}
		      sz = size;
		      start = 0;
		      finish = 0;
		      table = new MemoizedIntegerElem [sz];
		    },
		    {
		      if (start) delete [sz] table;
		      else delete [finish] table;
		      delete table;
		    });

/* Give the implementation of the memoization.

   In this implementation, the memization table is just
   a circular buffer of some fixed size.  */
DEFINE_ADD (Integer, E,
	    {
	      if (finish == sz)
		{
		  start = 1;
		  finish = 0;
		}
	      else if (start)
		{
		  start++;
		  if (start == sz)
		    start = 0;
		}

	      if (finish < sz)
		table[finish++] = E;

	      return &E;
	    });

DEFINE_REMOVE (Integer, E, { &E/* does nothing, except uses it. */; });

DEFINE_INDEXOF (Integer, int, E,
		{
		  int i;

		  if (start)
		    {
		      for (int i = 0; i < sz; i++)
			{
			  if (table[i] == E)
			    return i;
			}
		    }
		  else
		    {
		      for (int i = 0; i < finish; i++)
			{
			  if (table[i] == E)
			    return i;
			}
		    }
		  return -1;
		});

DEFINE_AT (Integer, int, i, { return table[i]; });

DEFINE_MEMOIZED_CLASS (Integer,
		       {
		       public:
			 // wrappers
			 DEFINE_WRAPPER_1 (Integer);

			 // functions to be wrapped
			 Integer factorial (Integer n);
			 Integer fibonacci (Integer n);
		       });

DEFINE_MEMOIZED_FUNCTION (Integer, factorial, (Integer n),
  {
    Integer f = 1;
    while (n > 0)
      {
	f *= n;
	--n;
      }
    return f;
  });

DEFINE_MEMOIZED_FUNCTION (Integer, fibonacci, (Integer n),
  {
    if (n <= 0)
      return 0;
    else
      {
	Integer f = 1;
	Integer prev = 0;
	while (n > 1)
	  {
	    Integer tmp = f;
	    f += prev;
	    prev = tmp;
	    --n;
	  }
	return f;
      }
  });

main (int argc, char *argv[])
{
  int n;
  int size = (argc == 2 ? atoi (argv[1]) : 10);

  MEMOIZED_TABLE (Integer, m, (size));

  printf ("memoizing with table size %d\n", size);
  while (1)
    {
      cout << "Number: ";
      cin >> n;
      if (n <= 0)
	{
	  cout << "bye!\n";
	  break;
	}
      cout << n << "! = " << m.factorial (n) << "\n";
    }
}
