//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that virtual function tables are generated and used
// even for struct's/classes which have no explicit constructors.

int base_func_member_1_called = 0;
int derived_func_member_1_called = 0;

struct base {
	virtual void func_member_1 ()
	{
		base_func_member_1_called++;
	}
};

struct derived : public base {
	virtual void func_member_1 ()
	{
		derived_func_member_1_called++;
	}

	virtual void func_member_2 ()
	{
	}
};

base* bp1;
base* bp2;

int main ()
{
	bp1 = new base;
	bp2 = new derived;

	bp1->func_member_1 ();
	bp2->func_member_1 ();
	//printf ("%d %d\n",
	//	base_func_member_1_called,
	//	derived_func_member_1_called);
	return 0;
}
