//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that a named const integer object cannot be used in contexts
// which require a compile-time constant integer value unless the given
// named const has actually been defined with a value prior to the point
// of use.
//
// Cases:
//	array length specifications
//	bitfield length specifications

extern const int k2;				// forward declaration
const int k4 = 4;
const int k8 = k2*k4;				// OK - dynamic initialization

int global_variable = k2+k4+k8;			// OK - dynamic initialization

char global_array1[k2];				// ERROR
char global_array2[k4];				// OK
char global_array3[k8];				// ERROR

struct base
{
	char member_array1[k2];			// ERROR
	char member_array2[k4];			// OK
	char member_array3[k8];			// ERROR

	unsigned int	f1:k2;			// ERROR
	unsigned int	f2:k4;			// OK
	unsigned int	f3:k8;			// ERROR
};

base global_base_object;

int main ()
{
	base local_base_object;
	char local_array1[k2];			// ERROR
	char local_array1[k4];			// OK
	char local_array1[k8];			// ERROR

	local_array1[0] = 'x';
	local_array2[0] = 'x';
	local_array3[0] = 'x';
	local_base_object.member_array2[1] = 'x';
	return 0;
}

const int k2 = 2;				// finally ...
