//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that multi-level inlining can be done with class methods,
// in particular, when one of the methods has local variables.
//
// This causes a segfault on the 88k compiler 1.32.0.5

struct base {
	inline int base_method()
	{
		return 0;
	}
};

struct derived : public base {
	derived () {}

	inline void derived_method ()
	{
		int cur_entry = 0;
		cur_entry = cur_entry;
		this->base_method();
	};
};

int main ()
{
	derived ht;

	ht.derived_method();
	return 0;
}
