/* Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <string.h>
#include <stddef.h>

int
wmemcmp (const wchar_t *s1, const wchar_t *s2, size_t n)
{
  wint_t c1;
  wint_t c2;

  while (n-- > 0)
    {
      c1 = (wint_t) s1[0];
      c2 = (wint_t) s2[0];
      if (c1 - c2 != 0)
	return c1 - c2;
      ++s1;
      ++s2;
    }

  return 0;
}
