#ifndef _G_unistd_h
#define _G_unistd_h 1

#include <_G_config.h>

extern "C" {

#if _G_HAVE_UNISTD
#define execl __hide_execl
#define execlp __hide_execlp
#define execle __hide_execle
#define chmod __hide_chmod
#ifdef _AIX
// AIX's unistd.h define int rename (const char *old, const char *new).
// This is not legal ANSI.  It causes a C++ syntax error (because of 'new').
#define new __new
#endif
#include_next <unistd.h>
#ifdef _AIX
#undef new
#endif
#undef execl
#undef execle
#undef execlp
#undef chmod
#else
#ifndef SEEK_SET
#define SEEK_SET        0
#define SEEK_CUR        1
#define SEEK_END        2
#endif

#ifndef F_OK
#define F_OK            0
#endif
#ifndef X_OK
#define X_OK            1
#endif
#ifndef W_OK
#define W_OK            2
#endif
#ifndef R_K
#define R_OK            4
#endif
#endif

#ifdef __GNUG__
extern void volatile _exit(int);
#else
void _exit(int);
#endif

extern unsigned alarm _G_ARGS((unsigned));
extern int      brk _G_ARGS((void*));
extern int      chdir _G_ARGS((const char*));
extern int      chmod  _G_ARGS((const char*, _G_mode_t));
extern int      chown _G_ARGS((const char*, _G_uid_t, _G_gid_t));
extern int      close _G_ARGS((int));
extern char*    crypt _G_ARGS((const char*, const char*));
extern int      dup _G_ARGS((int));
extern int      dup2 _G_ARGS((int, int));
extern char*    encrypt _G_ARGS((char*, int));
extern int      execl _G_ARGS((const char*, const char *, ...));
extern int      execle _G_ARGS((const char*, const char *, ...));
extern int      execlp _G_ARGS((const char*, const char*, ...));
extern int      exect _G_ARGS((const char*,  const char**,  char**));
extern int      execv _G_ARGS((const char*,  const char**));
extern int      execve _G_ARGS((const char*, const char**, char**));
extern int      execvp _G_ARGS((const char*,  const char**));
extern int      fchown _G_ARGS((int, _G_uid_t, _G_gid_t));
extern _G_pid_t fork _G_ARGS((void));
extern int      fsync _G_ARGS((int));
extern int      ftruncate _G_ARGS((int, unsigned long));
extern char*    getcwd _G_ARGS((char*, int));
extern int      getdomainname _G_ARGS((char*, int));
extern int      getdtablesize _G_ARGS((void));
extern int      getgroups _G_ARGS((int, _G_gid_t*));
extern _G_uid_t geteuid _G_ARGS((void));
extern _G_gid_t getegid _G_ARGS((void));
extern _G_gid_t getgid _G_ARGS((void));
extern long     gethostid _G_ARGS((void));
extern int      gethostname _G_ARGS((char*, int));
extern _G_pid_t getpgrp _G_ARGS((...));
extern _G_pid_t getpid _G_ARGS((void));
extern _G_pid_t getppid _G_ARGS((void));
extern char*    getlogin _G_ARGS((void));
extern char*    getpass _G_ARGS((const char*));
extern _G_uid_t getuid _G_ARGS((void));
extern int      ioctl _G_ARGS((/* int, int, void* */));
extern int      isatty _G_ARGS((int));
extern int      link _G_ARGS((const char*, const char*));
extern int      mkstemp _G_ARGS((char*));
extern char*    mktemp _G_ARGS((char*));
extern int      nice _G_ARGS((int));
extern int      pause _G_ARGS((void));
extern int      pipe _G_ARGS((int*));
extern int      readlink _G_ARGS((const char*, char*, int));
extern int      rename _G_ARGS((const char*, const char*));
extern int      rmdir _G_ARGS((const char*)); 
extern void*    sbrk _G_ARGS((int)); 
extern int      syscall _G_ARGS((int, ...));
extern int      setgid _G_ARGS((_G_gid_t));
extern int      sethostname _G_ARGS((const char*, int));
extern int      setpgrp _G_ARGS((...));
extern int      setregid _G_ARGS((int, int));
extern int      setreuid _G_ARGS((int, int));
extern int      setuid _G_ARGS((_G_uid_t));
extern unsigned sleep _G_ARGS((unsigned));
extern void     swab _G_ARGS((void*, void*, int));
extern int      symlink _G_ARGS((const char*, const char*));
extern int      truncate _G_ARGS((const char*, unsigned long));
extern char*    ttyname _G_ARGS((int));
extern int      ttyslot _G_ARGS((void));
//extern int   umask _G_ARGS((int)); /* commented out for now; wrong for SunOs4.1 */
extern int      unlink _G_ARGS((const char*));
extern int      vfork _G_ARGS((void));
extern int      vadvise _G_ARGS((int));
extern int      vhangup _G_ARGS((void));
extern _G_off_t lseek _G_ARGS((int, long, int));
extern int      read _G_ARGS((int, void*, _G_size_t));
extern int      write _G_ARGS((int, const void*, _G_size_t));
extern int      access _G_ARGS((const char*, int));
#ifndef hpux
extern int      flock _G_ARGS((int, int));
#endif

}

#endif
