// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Particle test 4: SpatialLayout, MPRemoteDynamic Attrib, 
//                  RM + MP RemoteBrick Field
//-----------------------------------------------------------------------------

#include "particle_tests.h"


//-----------------------------------------------------------------------------
// The main routine for this test code
//-----------------------------------------------------------------------------

int main(int argc, char *argv[])
{
  // Initialize POOMA and output stream, using Tester class

  startParticleTest(argc, argv, 
    "SpatialLayout: A=MPRemoteDynamic, F=RM+MPRemoteBrick");

  // Typedefs for what we are simulating here.

  typedef MultiPatch< DynamicTag, Remote<Dynamic> >    AttrEngineTag_t;
  typedef MultiPatch< GridTag, Remote<Brick> >         FieldEngineTag_t;
  typedef RectilinearMesh<2>                           Mesh_t;
  typedef Vert                                         Centering_t;

  typedef DiscreteGeometry<Centering_t,Mesh_t>         Geometry_t;
  typedef Field<Geometry_t,double,FieldEngineTag_t>    Field_t;
  typedef Field_t::Layout_t                            FieldLayout_t;
  typedef SpatialLayout<Geometry_t,FieldLayout_t>      ParLayout_t;
  typedef TestParTraits<AttrEngineTag_t,ParLayout_t>   ParTraits_t;
  typedef ParLayout_t::PointType_t                     PointType_t;

  // Specify the mesh parameters.

  Interval<2> meshDomain(12, 24);
  PointType_t meshOrigin(1.0, 2.0);
  PointType_t meshSpacing(0.5, 0.5);

  // Create a Mesh and Geometry.

  Mesh_t mesh(meshDomain, meshOrigin, meshSpacing);
  Geometry_t geometry(mesh);

  // Let things catch up

  Pooma::blockAndEvaluate();

  // The size of the mesh.

  Region<2,double> box;
  for (int d=0; d < 2; ++d)
    box[d] = Region<1>(meshOrigin(d),
		       meshOrigin(d) + 0.5 * (meshDomain[d].length() - 1));

  // Create a FieldLayout object.  We don't actually need a Field in
  // this example, though, just the layout.

  Loc<2> blocks(3, 4);
  FieldLayout_t flayout(geometry.physicalDomain(), blocks,DistributedTag());

  // Create a particle layout object.

  ParLayout_t layout(geometry, flayout);

  // Create a Particles object, using our special subclass.

  TestParticles<ParTraits_t> P(layout);

  // Run the tests.

  runParticleTest(P, box);

  // Return resulting error code and exit

  return 
    endParticleTest("SpatialLayout: A=MPRemoteDynamic, F=RM+MPRemoteBrick");
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: particle_test4.cpp,v $   $Author: luchini $
// $Revision: 1.10 $   $Date: 2000/06/07 06:42:33 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
