// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// UniformGridLayout test: Create and use UniformGridLayout objects
//-----------------------------------------------------------------------------


#include "Pooma/Pooma.h"
#include "Pooma/Domains.h"
#include "Pooma/UMPArrays.h"
#include "Partition/ContextMapper.h"
#include "Partition/SpatialPartition.h"
#include "Partition/DistributedMapper.h"
#include "Utilities/Tester.h"
#include <iostream>
#include <iterator>


int main(int argc, char *argv[]) 
{

  // Initialize POOMA and output stream, using Tester class

  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);
  tester.out() << argv[0] << ": Testing default constructors & assignment." 
               << std::endl;
  tester.out() << "----------------------------------------" << std::endl;


  Interval<1> I1(0,999);
  Interval<2> I2(I1,I1);
  
  GuardLayers<2> gl(2);
  Loc<2> blocks(5,5);
  
  UniformGridPartition<2> partition(blocks, gl, gl);
  
  UniformGridLayout<2> tgl(I2, partition, DistributedTag());
  
  tester.out() << "Here's the original layout:\n" 
               << tgl << std::endl;

  UniformGridLayout<2> tgl2;
  
  tester.out() << "Here's an empty layout:\n" 
               << tgl2 << std::endl;

  tgl2 = tgl;
  
  tester.out() << "Here's the second layout after assignment:\n" 
               << tgl2 << std::endl;

  Interval<1> IV1a(500,900);
  Interval<1> IV1b(600,700);
  Interval<2> IV2(IV1a,IV1b);
  
  UniformGridLayoutView<2,2> tglv(tgl,IV2);
  
  tester.out() << "Here's a non-slice view of the original layout:\n"
               << tglv << std::endl;
  
  UniformGridLayoutView<2,2> tglv2(tgl2,IV2);

  tester.out() << "Here's the same view of the second layout:\n"
               << tglv2 << std::endl;

  UniformGridLayoutView<2,2> tglv0;
  
  tester.out() << "Here's an empty view (default constructed):\n"
               << tglv0 << std::endl;
               
  tglv0 = tglv2;
  
  tester.out() << "Here's the last layout after assignment from the second view:\n"
               << tglv0 << std::endl;
  
  
  SliceRange<2,1> S1(I2,IV1a,400);
  
  UniformGridLayoutView<1,2> tgls1(tgl, S1);
  
  tester.out() << "Here's a slice view:\n"
               << tgls1 << std::endl;
  
  UniformGridLayoutView<1,2> tgls0;
  
  tgls0 = tgls1;
  
  tester.out() << "Here's the default constructed slice after assignment:\n"
               << tgls0 << std::endl;
  
  
  tester.out() << "-------------------------------------------" << std::endl;
  int retval = tester.results("UniformGridLayout Test 2");
  Pooma::finalize();
  return retval;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ugl_test2.cpp,v $   $Author: jac $
// $Revision: 1.1 $   $Date: 2000/06/23 03:57:38 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
