// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_GENERATED_CONFIG_H
#define POOMA_GENERATED_CONFIG_H


#define POOMA_YES                           1
#define POOMA_NO                            0
#define POOMA_TRUE                          true
#define POOMA_FALSE                         false
#define POOMA_SUITE                         "INTEL"
#define POOMA_ARCH_TYPE                     "intel"
#define POOMA_COMP_TYPE                     "CC"
#define POOMA_MAJOR_VERSION                 2
#define POOMA_MINOR_VERSION                 2
#define POOMA_PATCH_LEVEL                   0
#define POOMA_VERSION_STRING                "POOMA 2.2.0"
#define POOMA_VERSION_NUM_STRING            "2.2.0"
#define POOMA_CONFIGURE_ARGS                ""
#define POOMA_BUILD_DATE                    "Fri Oct 29 10:00:00 MDT 1999"
#define POOMA_BUILD_USER                    "julianc"
#define POOMA_BUILD_HOST                    "opium"
#define POOMA_PREINSTANTIATE                POOMA_NO
#define POOMA_PRINTDEBUG                    POOMA_NO
#define POOMA_NO_TEMPLATED_COMPLEX          POOMA_NO
#define POOMA_NO_STD_COMPLEX                POOMA_NO
#define POOMA_NONSTANDARD_ITERATOR          POOMA_YES
#define POOMA_THREADS                       POOMA_NO
#define POOMA_SMARTS_SCHEDULER_SERIALASYNC  POOMA_NO
#define POOMA_SCHEDULER_NAME                "stub scheduler"
#define POOMA_REORDER_ITERATES              POOMA_NO
#define POOMA_PROFILE                       POOMA_NO
#define POOMA_INSURE                        POOMA_NO
#define POOMA_LUX                           POOMA_NO
#define POOMA_EXCEPTIONS                    POOMA_NO
#define POOMA_NO_STRINGSTREAM               POOMA_NO
#define POOMA_MISSING_IOMANIPS              POOMA_NO
#define POOMA_NO_TEMPLATE_FRIENDS           POOMA_NO
#define POOMA_NO_RESTRICT                   POOMA_NO
#define POOMA_NO_OSTREAM_ITERATOR_1ARG      POOMA_NO
#define POOMA_NO_PLACEMENT_DELETE           POOMA_NO
#define POOMA_SMALL_DIM_SPECIALIZATIONS     POOMA_NO
#define POOMA_NO_DEPENDENT_TEMPLATE_ARGS    POOMA_NO
#define POOMA_BRAIN_DAMAGED_MICROSOFT_LIB   POOMA_YES
#define POOMA_PAWS                          POOMA_NO
#define POOMA_HDF5                          POOMA_NO
#define POOMA_HAS_O_BINARY_OPEN_MODE        POOMA_NO
#define POOMA_NO_STD_IOSBASE                POOMA_NO
#define POOMA_INC_SYS_STAT_H_FOR_FILE_MODES POOMA_YES
#define POOMA_CHEETAH                       POOMA_NO

#ifndef POOMA_DEFAULT_FLOAT_TYPE
#define POOMA_DEFAULT_FLOAT_TYPE            double
#endif

#ifndef POOMA_DEFAULT_ELEMENT_TYPE
#define POOMA_DEFAULT_ELEMENT_TYPE          POOMA_DEFAULT_FLOAT_TYPE
#endif

#ifndef POOMA_DEFAULT_POSITION_TYPE
#define POOMA_DEFAULT_POSITION_TYPE         POOMA_DEFAULT_FLOAT_TYPE
#endif

#ifndef POOMA_DEFAULT_ENGINE_TYPE
#define POOMA_DEFAULT_ENGINE_TYPE           Brick
#endif

#ifndef POOMA_BOUNDS_CHECK
#define POOMA_BOUNDS_CHECK                  POOMA_NO
#endif

#ifndef POOMA_BOUNDS_CHECK_DEFAULT
#define POOMA_BOUNDS_CHECK_DEFAULT          POOMA_FALSE
#endif

#ifndef POOMA_DEFAULT_SMARTS_HARDINIT
#define POOMA_DEFAULT_SMARTS_HARDINIT       POOMA_FALSE
#endif

#ifndef POOMA_DEFAULT_SMARTS_HARDRUN
#define POOMA_DEFAULT_SMARTS_HARDRUN        POOMA_FALSE
#endif

#ifndef POOMA_DEFAULT_SMARTS_LOCKTHREADS
#define POOMA_DEFAULT_SMARTS_LOCKTHREADS    POOMA_FALSE
#endif

#ifndef POOMA_DEFAULT_BLOCKING_EXPRESSIONS
#define POOMA_DEFAULT_BLOCKING_EXPRESSIONS  POOMA_TRUE
#endif

#endif


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: PoomaConfiguration.h,v $   $Author: luchini $
// $Revision: 1.22 $   $Date: 2000/05/05 07:44:55 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
