// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_TINY_UNARY_VECTOR_OP_H
#define POOMA_TINY_UNARY_VECTOR_OP_H

//-----------------------------------------------------------------------------
// Class: UnaryVectorEngine
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Overview:
// An engine class for representing the sum, product etc between two
// Vectors.  This is used as part of evaluating expressions.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
//-----------------------------------------------------------------------------

template<class V1, class Op>
class UnaryVectorOp
{
};


template<int D, class T, class V1, class Op>
class VectorEngine<D,T,UnaryVectorOp<V1,Op> >
{

public:
 
  //----------------------------------------------------------------------
  // Typedefs
  //----------------------------------------------------------------------

  // Export the input types.
  enum { dimensions=2 };
  typedef T Element_t;
  typedef UnaryVectorOp<V1,Op> EngineTag_t;

  // Return types for accessor functions.
  typedef T ConstElementRef_t;
  typedef T ElementRef_t;

  // Record the type of the current class.
  typedef VectorEngine<D,T, UnaryVectorOp<V1,Op> > This_t;


  //----------------------------------------------------------------------
  // Constructors and Destructor

  // Construct from two Vectors and on operator tag.
  VectorEngine(const V1& v1, Op op)
    : v1_m(v1), op_m(op) {}

  // Construct from two Vectors and let the op tag contruct itself.
  VectorEngine(const V1& v1)
    : v1_m(v1) {}

  // Copy ctor just copies the references.
  VectorEngine(const This_t& x)
    : v1_m(x.v1_m), op_m(x.op_m) {}

  // Let the engine destroy itself.
  ~VectorEngine() {}

#if !POOMA_NO_TEMPLATE_FRIENDS
  template<int DD,class TT, class EE, int I>
    friend struct VectorEngineElem;

private:
#endif

  const V1& v1_m;
  Op op_m;
};

//-----------------------------------------------------------------------------
//
// Specializaton of TensorElem for UnaryTensorOp
// Compile time lookup for unary operators.
//
//-----------------------------------------------------------------------------

template<int D, class T, class V1, class Op, int I>
struct VectorEngineElem<D,T,UnaryVectorOp<V1,Op>, I>
{
  typedef VectorEngine<D,T,UnaryVectorOp<V1,Op> > V;
  typedef typename VectorElem<V1,I>::Element_t T1;
  typedef typename UnaryReturn<T1,Op>::Type_t Element_t;
  typedef Element_t ElementRef_t;
  typedef Element_t ConstElementRef_t;
  static Element_t get(const V& x) 
    { 
      return Op()(VectorElem<V1,I>::get(x.v1_m));
    }
};


#endif

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: UnaryVectorOp.h,v $   $Author: swhaney $
// $Revision: 1.8 $   $Date: 2000/03/07 13:18:15 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
