// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Classes:
//   NullDomain
//   ErrorDomain
// Functions:
//   contains(NullDomain, D)
//-----------------------------------------------------------------------------

#ifndef POOMA_DOMAIN_NULLDOMAIN_H
#define POOMA_DOMAIN_NULLDOMAIN_H

//-----------------------------------------------------------------------------
// NullDomain and ErrorDomain are special "domains". ErrorDomains result when
// someone tries an incorrect domain calculation. NullDomain means a domain
// with nothing in it.
//-----------------------------------------------------------------------------

struct ErrorDomain
{
  ErrorDomain() {}
  ErrorDomain(const ErrorDomain&) {}
};

struct NullDomain
{
  NullDomain() {}
  NullDomain(const NullDomain&) {}
};

// The null-domain is contained by every domain.

template<class D>
bool contains(const NullDomain &, const D &)
{
  return true;
}

#endif // POOMA_DOMAIN_NULLDOMAIN_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: NullDomain.h,v $   $Author: swhaney $
// $Revision: 1.1 $   $Date: 2000/06/21 00:12:33 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
