// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// BCond<Field<Geom, T, EngineTag>, ComponentBC<N, Category> > 
// template definitions.
//-----------------------------------------------------------------------------

// Include files.

#include "Utilities/PAssert.h"

//-----------------------------------------------------------------------------
// BCond<Field<Geom, T, EngineTag>, ComponentBC<N, Category> >()
// 
// Constructor.
//-----------------------------------------------------------------------------

template<class Geom, class T, class EngineTag, int N, class Category>
BCond<Field<Geom, T, EngineTag>, ComponentBC<N, Category> >::
BCond(const Field<Geom, T, EngineTag> &f, const ComponentBC<N, Category> &bc)
  : Base_t(f), bc_m(bc), bcItem_m(NULL)
{
  // We need to create the actual boundary condition we will apply.
  
  create(f.comp(bc_m.comp()), bc_m.category());
}


//-----------------------------------------------------------------------------
// void applyBoundaryCondition()
// 
// The apply method for this boundary condition. (Kind of self-describing.)
//-----------------------------------------------------------------------------

template<class Geom, class T, class EngineTag, int N, class Category>
void BCond<Field<Geom, T, EngineTag>, ComponentBC<N, Category> >::
applyBoundaryCondition()
{
  PAssert(bcItem_m != NULL);
  bcItem_m->applyBoundaryCondition();
}


//-----------------------------------------------------------------------------
// Base_t *retarget()
// 
// This boundary condition's retarget function.
//-----------------------------------------------------------------------------

template<class Geom, class T, class EngineTag, int N, class Category>
FieldBCondBase< Field<Geom, T, EngineTag> > *
BCond<Field<Geom, T, EngineTag>, ComponentBC<N, Category> >::
retarget(const Field<Geom, T, EngineTag> &f) const
{
  return new This_t(f, bc_m);
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ComponentBC.cpp,v $   $Author: swhaney $
// $Revision: 1.3 $   $Date: 2000/03/07 13:16:11 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
