// This file is part of the program FRYSK.
//
// Copyright 2006, Red Hat Inc.
//
// FRYSK is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// FRYSK is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with FRYSK; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
// 
// In addition, as a special exception, Red Hat, Inc. gives You the
// additional right to link the code of FRYSK with code not covered
// under the GNU General Public License ("Non-GPL Code") and to
// distribute linked combinations including the two, subject to the
// limitations in this paragraph. Non-GPL Code permitted under this
// exception must only link to the code of FRYSK through those well
// defined interfaces identified in the file named EXCEPTION found in
// the source code files (the "Approved Interfaces"). The files of
// Non-GPL Code may instantiate templates or use macros or inline
// functions from the Approved Interfaces without causing the
// resulting work to be covered by the GNU General Public
// License. Only Red Hat, Inc. may make changes or additions to the
// list of Approved Interfaces. You must obey the GNU General Public
// License in all respects for all of the FRYSK code and other code
// used in conjunction with FRYSK except the Non-GPL Code covered by
// this exception. If you modify this file, you may extend this
// exception to your version of the file, but you are not obligated to
// do so. If you do not wish to provide this exception without
// modification, you must delete this exception statement from your
// version and license this file solely under the GPL without
// exception.

/*
 * frysk-imports/tests/frysk3231
 */

#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include <alloca.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ptrace.h>
#include <unistd.h>
#include <linux/unistd.h>
#include <linux/ptrace.h>

volatile pid_t pid;
  
void
timeout (int sig)
{
  fprintf (stderr, "test timeout, aborting\n");
  ptrace (PTRACE_DETACH, pid, NULL, NULL);
  kill (pid, SIGKILL);
  exit (1);
}

int
main (int ac, char * av[])
{
  fprintf (stderr, "Create a detached child\n");
  pid = fork ();
  switch (pid)
    {
    case -1: // Foobar
      {
	perror ("fork");
	exit (1);
      }
    case 0: // Child; sleeps until attach
      {
	int timeout = 5;
	do
	  timeout -= sleep (timeout);
	while (timeout > 0);
	exit (1);
      }
    default: // Parent
      {
	fprintf (stderr, "Set up abort cleanup\n");
	signal (SIGALRM, timeout);
	alarm (1);	

	fprintf (stderr, "Attach to child and wait for the stop\n");
	if (ptrace (PTRACE_ATTACH, pid, NULL, NULL) < 0)
	  {
	    perror ("ptrace -- for attach");
	    exit (1);
	  }
	if (waitpid (pid, NULL,  __WALL) < 0)
	  {
	    perror ("waitpid -- for attach");
	    exit (1);
	  }

	fprintf (stderr, "Detach from child with a SIGKILL\n");
	if (ptrace (PTRACE_DETACH, pid, NULL, (void *)SIGKILL) < 0)
	  {
	    perror ("ptrace -- for detach with SIGKILL");
	    exit (1);
	  }

	fprintf (stderr, "Wait for the child's death\n");
	if (waitpid (pid, NULL,  __WALL) < -1)
	  {
	    perror ("waitpid -- for detached SIGKILLed child");
	    exit (1);
	  }
      }
    }
  return 0;
}
