//=================================================================
//
//        strcat1.c
//
//        Testcase for C library strcat()
//
//=================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//=================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     ctarpy, jlarmour
// Contributors:  
// Date:          2000-04-30
// Description:   Contains testcode for C library strcat() function
//
//
//####DESCRIPTIONEND####

// INCLUDES

#include <pkgconf/isoinfra.h>
#include <string.h>
#include <cyg/infra/testcase.h>


// FUNCTIONS

// Functions to avoid having to use libc strings

static int my_strcmp(const char *s1, const char *s2)
{
    for ( ; *s1 == *s2 ; s1++,s2++ )
    {
        if ( *s1 == '\0' )
            break;
    } // for

    return (*s1 - *s2);
} // my_strcmp()


static char *my_strcpy(char *s1, const char *s2)
{
    while (*s2 != '\0') {
        *(s1++) = *(s2++);
    }
    *s1 = '\0';

    return s1; 
} // my_strcpy()


#if CYGINT_ISO_MAIN_STARTUP
int main( int argc, char *argv[] )
#else
void cyg_user_start(void)
#endif
{
    char x[300];
    char y[300];
    char *ret;

    CYG_TEST_INIT();

    CYG_TEST_INFO("Starting tests from testcase " __FILE__ " for C library "
                  "strcat() function");
    CYG_TEST_INFO("This testcase provides simple basic tests");

    // Check 1
    my_strcpy(x, "One ring to rule them all.");
    my_strcpy(y, "One ring to find them.");
    ret = strcat(x, y);
    if ( my_strcmp(x, "One ring to rule them all.One ring to find them.")==0 ) 
        CYG_TEST_PASS("Simple concatenation");
    else 
        CYG_TEST_FAIL("Simple concatenation");
    // Check return val
    CYG_TEST_PASS_FAIL( ( ret == x ), "Simple concatenation return value" );


    // Check 2
    my_strcpy(x, "One ring to bring them all,");
    my_strcpy(y, "");
    ret = strcat(x, y);
    if ( my_strcmp(x, "One ring to bring them all,")==0 ) 
        CYG_TEST_PASS("Concatenation of empty string");
    else 
        CYG_TEST_FAIL("Concatenation of empty string");
    // Check return val
    CYG_TEST_PASS_FAIL( ( ret == x ),
                        "Concatenation of empty string return value" );


    // Check 3
    my_strcpy(x, "and in the darkness bind them");
    my_strcpy(y, "");
    ret = strcat(y, x);
    if ( my_strcmp(x, "and in the darkness bind them")==0 ) 
        CYG_TEST_PASS("Concatenation to empty string");
    else 
        CYG_TEST_FAIL("Concatenation to empty string");
    // Check return val
    CYG_TEST_PASS_FAIL( ( ret == y ),
                        "Concatenation to empty string return value" );

//    CYG_TEST_NA("Testing is not applicable to this configuration");

    CYG_TEST_FINISH("Finished tests from testcase " __FILE__ " for C library "
                    "strcat() function");
} // main()


// EOF strcat1.c
