#ifndef CYGONCE_LIBM_TANH_H
#define CYGONCE_LIBM_TANH_H
//===========================================================================
//
//      tanh.h
//
//      Test vectors for testing of tanh() math library function
//
//===========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       #include "vectors/tanh.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define TANH_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t tanh_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1074853420u, 2506787616u, 1090024059u, 3619148316u, 1072692378u, 1014448409u, 0, TANH_TOLERANCE, 0},
{ 2, 3220250806u, 3176730980u, 1051524793u, 2993920299u, 3219735748u, 2718182253u, 0, TANH_TOLERANCE, 0},
{ 3, 3226028315u, 2725707538u, 3232101343u, 2346810316u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 4, 1078922874u, 2088062470u, 3201242716u, 420891118u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 5, 3221200677u, 2636405208u, 1100049309u, 471635570u, 3220097871u, 3599209765u, 0, TANH_TOLERANCE, 0},
{ 6, 1077828855u, 1746012320u, 1054478713u, 3333988501u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 7, 1066827528u, 183014794u, 3202039382u, 2016785810u, 1066827290u, 3880063380u, 0, TANH_TOLERANCE, 0},
{ 8, 3219777490u, 2688957927u, 1046089230u, 2709029994u, 3219483454u, 1125363282u, 0, TANH_TOLERANCE, 0},
{ 9, 1070330066u, 624574473u, 1045840574u, 3473266330u, 1070301526u, 862781689u, 0, TANH_TOLERANCE, 0},
{ 10, 3217502754u, 1605286142u, 1068931671u, 4233776869u, 3217486329u, 2145582745u, 0, TANH_TOLERANCE, 0},
{ 11, 1069780594u, 1857607719u, 3222889559u, 3417070006u, 1069770714u, 401076752u, 0, TANH_TOLERANCE, 0},
{ 12, 1081579891u, 3981151660u, 1088899021u, 1332651746u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 13, 1075860838u, 3824988054u, 1066856791u, 2070129652u, 1072693247u, 2842765918u, 0, TANH_TOLERANCE, 0},
{ 14, 3218045550u, 1372884064u, 1080833116u, 3229926662u, 3218004944u, 604169930u, 0, TANH_TOLERANCE, 0},
{ 15, 1078097861u, 3217805330u, 3191644264u, 2014578707u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 16, 1080267391u, 265058758u, 3239903247u, 1630600647u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 17, 1073221381u, 1946677669u, 3198462609u, 926009897u, 1072495714u, 2851802077u, 0, TANH_TOLERANCE, 0},
{ 18, 1073178875u, 2271884183u, 3203741999u, 2118617783u, 1072479881u, 1907835069u, 0, TANH_TOLERANCE, 0},
{ 19, 3214772053u, 213658772u, 3249401130u, 314151656u, 3214771516u, 3554579438u, 0, TANH_TOLERANCE, 0},
{ 20, 3228946464u, 1564829925u, 3197817016u, 497230814u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 21, 3219408362u, 2075329122u, 3231746400u, 169900577u, 3219255158u, 2089286575u, 0, TANH_TOLERANCE, 0},
{ 22, 1067674434u, 541549344u, 1096608669u, 3119070100u, 1067673824u, 1035028173u, 0, TANH_TOLERANCE, 0},
{ 23, 1075989871u, 567496114u, 1045286891u, 1969998540u, 1072693247u, 4092220034u, 0, TANH_TOLERANCE, 0},
{ 24, 1069985379u, 1299369769u, 1049342524u, 4167404066u, 1069970014u, 3629210634u, 0, TANH_TOLERANCE, 0},
{ 25, 3218302829u, 3348930841u, 1078472138u, 358457347u, 3218265246u, 746156169u, 0, TANH_TOLERANCE, 0},
{ 26, 1073166449u, 2192461366u, 1099527247u, 3184735642u, 1072475030u, 1439194248u, 0, TANH_TOLERANCE, 0},
{ 27, 1068590412u, 331696577u, 3189610016u, 793242270u, 1068588660u, 2611487107u, 0, TANH_TOLERANCE, 0},
{ 28, 3229460262u, 2322696981u, 1083791358u, 3020766674u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 29, 1066922273u, 252085215u, 3214426435u, 4139068910u, 1066921987u, 890588541u, 0, TANH_TOLERANCE, 0},
{ 30, 3221457149u, 105589263u, 1056316170u, 261630827u, 3220145390u, 1744926257u, 0, TANH_TOLERANCE, 0},
{ 31, 1082047584u, 428765703u, 3251828686u, 2009972239u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 32, 1079693651u, 3517376586u, 3240257920u, 3304487302u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 33, 3224100728u, 237004814u, 3237899261u, 3364008659u, 3220176895u, 4294953152u, 0, TANH_TOLERANCE, 0},
{ 34, 3214121920u, 472004928u, 3226869477u, 1186387580u, 3214121763u, 282713899u, 0, TANH_TOLERANCE, 0},
{ 35, 1068906914u, 4085763910u, 1106394906u, 2684738273u, 1068903266u, 2272328782u, 0, TANH_TOLERANCE, 0},
{ 36, 1069636551u, 2055490142u, 3231581370u, 3879040079u, 1069629628u, 2119989659u, 0, TANH_TOLERANCE, 0},
{ 37, 3213093895u, 3725731239u, 1061652681u, 591292963u, 3213093854u, 2954887285u, 0, TANH_TOLERANCE, 0},
{ 38, 3221869253u, 1147041027u, 3215417793u, 624695933u, 3220170315u, 2960779403u, 0, TANH_TOLERANCE, 0},
{ 39, 3217587110u, 705725219u, 3238067573u, 1116238321u, 3217567824u, 4085004597u, 0, TANH_TOLERANCE, 0},
{ 40, 3217852848u, 7287411u, 1045917232u, 116067742u, 3217822463u, 1655616480u, 0, TANH_TOLERANCE, 0},
{ 41, 3226423734u, 3604989074u, 1066381836u, 545298780u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 42, 3221178088u, 1681476121u, 1060345752u, 3553822398u, 3220094461u, 32790421u, 0, TANH_TOLERANCE, 0},
{ 43, 1080811562u, 3410480388u, 1052460275u, 1660607230u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 44, 1077682533u, 1494984673u, 3196647153u, 287894723u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 45, 1068516615u, 644548665u, 1081948134u, 2442134629u, 1068515181u, 4013422768u, 0, TANH_TOLERANCE, 0},
{ 46, 1077068335u, 2312530895u, 3221584595u, 3379665576u, 1072693247u, 4294967295u, 0, TANH_TOLERANCE, 0},
{ 47, 1079308159u, 3018463866u, 1086226574u, 404012923u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 48, 1071024755u, 1710279345u, 3251401196u, 3528946000u, 1070966559u, 4188915943u, 0, TANH_TOLERANCE, 0},
{ 49, 1070973535u, 2164450219u, 1083520023u, 3312018966u, 1070921017u, 98347496u, 0, TANH_TOLERANCE, 0},
{ 50, 1069831588u, 2648986431u, 1050330591u, 1474376550u, 1069820489u, 3042456577u, 0, TANH_TOLERANCE, 0},
{ 51, 3214344972u, 1839068700u, 1077406406u, 3013052171u, 3214344718u, 2604353982u, 0, TANH_TOLERANCE, 0},
{ 52, 1066416574u, 772102380u, 3220729740u, 4219039958u, 1066416485u, 838919666u, 0, TANH_TOLERANCE, 0},
{ 53, 3223180765u, 3058618779u, 1046304788u, 3338676024u, 3220176894u, 2606621599u, 0, TANH_TOLERANCE, 0},
{ 54, 1067949353u, 506286854u, 1094907481u, 2217000199u, 1067948256u, 3256716313u, 0, TANH_TOLERANCE, 0},
{ 55, 1076136854u, 1147428263u, 1065432625u, 3034786717u, 1072693247u, 4273443146u, 0, TANH_TOLERANCE, 0},
{ 56, 1075725296u, 2844125311u, 1082985198u, 2561492677u, 1072693246u, 3764088074u, 0, TANH_TOLERANCE, 0},
{ 57, 3218876948u, 704542600u, 3222902057u, 2762779203u, 3218766355u, 4000984321u, 0, TANH_TOLERANCE, 0},
{ 58, 3215409254u, 184131949u, 3249723525u, 1667366082u, 3215408207u, 1529188018u, 0, TANH_TOLERANCE, 0},
{ 59, 3221512446u, 3904224140u, 1067056698u, 2942159914u, 3220151345u, 2904148002u, 0, TANH_TOLERANCE, 0},
{ 60, 1080713919u, 426114282u, 3209056785u, 1083606355u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 61, 1082048697u, 3774123863u, 1106787580u, 2722107965u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 62, 1077519332u, 1377734762u, 1104232051u, 2377063483u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 63, 1072526287u, 1029739074u, 1105467109u, 3062201018u, 1072118796u, 4118103516u, 0, TANH_TOLERANCE, 0},
{ 64, 3225304413u, 773857656u, 3214251949u, 335833884u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 65, 3216856098u, 1473865960u, 1103073830u, 4000427507u, 3216847733u, 232123791u, 0, TANH_TOLERANCE, 0},
{ 66, 1081165135u, 4242092620u, 1067009473u, 14539161u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 67, 3214536170u, 1732245037u, 1101371955u, 1533536108u, 3214535807u, 1315557254u, 0, TANH_TOLERANCE, 0},
{ 68, 3228182475u, 1833841275u, 1099430098u, 4144145552u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 69, 3227493247u, 935007012u, 3188865420u, 604442938u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 70, 3217389013u, 2211464602u, 1046255144u, 1635910526u, 3217375982u, 600658720u, 0, TANH_TOLERANCE, 0},
{ 71, 1074725689u, 2549219008u, 3231633258u, 3733639385u, 1072691447u, 3387741538u, 0, TANH_TOLERANCE, 0},
{ 72, 1075803633u, 1819374372u, 3202219056u, 2617077637u, 1072693247u, 1640287018u, 0, TANH_TOLERANCE, 0},
{ 73, 1078616640u, 546465680u, 1048653554u, 532401530u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 74, 1066591187u, 2759019783u, 3221570188u, 3554409630u, 1066591047u, 1006540637u, 0, TANH_TOLERANCE, 0},
{ 75, 3219222738u, 2527221960u, 1099107978u, 2696971136u, 3219114815u, 1376096383u, 0, TANH_TOLERANCE, 0},
{ 76, 1079332208u, 173134582u, 1087299442u, 2877794600u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 77, 1076963290u, 547642046u, 3197285510u, 3521286127u, 1072693247u, 4294967273u, 0, TANH_TOLERANCE, 0},
{ 78, 1073812126u, 1231582831u, 1090971734u, 1653446832u, 1072635309u, 2989295u, 0, TANH_TOLERANCE, 0},
{ 79, 1070779719u, 3762182190u, 3252967851u, 2615360375u, 1070745453u, 2070604370u, 0, TANH_TOLERANCE, 0},
{ 80, 3216563063u, 2588067350u, 3206610957u, 3551059728u, 3216557963u, 801826211u, 0, TANH_TOLERANCE, 0},
{ 81, 3217464616u, 845263327u, 1073415902u, 1749010288u, 3217449387u, 250805u, 0, TANH_TOLERANCE, 0},
{ 82, 3217110706u, 3092685191u, 3190678390u, 2872219490u, 3217103954u, 3350331893u, 0, TANH_TOLERANCE, 0},
{ 83, 3220412207u, 4107255722u, 3205337291u, 3069068345u, 3219843345u, 256047763u, 0, TANH_TOLERANCE, 0},
{ 84, 3227213641u, 2294867524u, 3216653996u, 2860384670u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 85, 3214297870u, 2265437201u, 3240198679u, 1234948614u, 3214297639u, 3221872192u, 0, TANH_TOLERANCE, 0},
{ 86, 3219505657u, 1186945904u, 3251167793u, 1896750851u, 3219320152u, 2185885166u, 0, TANH_TOLERANCE, 0},
{ 87, 1075284022u, 3686084548u, 1079286273u, 3309277689u, 1072693215u, 1875502271u, 0, TANH_TOLERANCE, 0},
{ 88, 3221379088u, 3006860614u, 3231412671u, 2504194724u, 3220134572u, 2680984865u, 0, TANH_TOLERANCE, 0},
{ 89, 3224614924u, 1948717780u, 1048317852u, 3791803982u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 90, 1070636471u, 4272034420u, 3192982124u, 1526175922u, 1070612646u, 3951514323u, 0, TANH_TOLERANCE, 0},
{ 91, 3226943458u, 4108948538u, 1104691287u, 640541190u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 92, 3217743177u, 3259274853u, 1082507103u, 3677038020u, 3217717774u, 2850529195u, 0, TANH_TOLERANCE, 0},
{ 93, 1076841042u, 3781708548u, 1096584871u, 1207386447u, 1072693247u, 4294966832u, 0, TANH_TOLERANCE, 0},
{ 94, 3213861096u, 3011191657u, 1103798670u, 1096124830u, 3213860931u, 3971208009u, 0, TANH_TOLERANCE, 0},
{ 95, 1071623631u, 2540404725u, 3240157452u, 4122845725u, 1071469194u, 1505927985u, 0, TANH_TOLERANCE, 0},
{ 96, 1076303678u, 311336721u, 3214382367u, 4212533768u, 1072693247u, 4293279124u, 0, TANH_TOLERANCE, 0},
{ 97, 1067916643u, 1769686293u, 3240200923u, 3538602249u, 1067915615u, 325439970u, 0, TANH_TOLERANCE, 0},
{ 98, 1075081821u, 508056696u, 1103793878u, 776520138u, 1072693095u, 3017783498u, 0, TANH_TOLERANCE, 0},
{ 99, 1080890481u, 4064962760u, 1077424413u, 819766631u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 100, 1074178362u, 2112385259u, 3227593179u, 1187058516u, 1072678768u, 381693332u, 0, TANH_TOLERANCE, 0},
{ 101, 1076003603u, 2514398118u, 1076579751u, 870169764u, 1072693247u, 4130548044u, 0, TANH_TOLERANCE, 0},
{ 102, 3227977024u, 1190259653u, 1069112254u, 3417249840u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 103, 3214634603u, 3467757357u, 3215075200u, 2168175352u, 3214634173u, 3865851572u, 0, TANH_TOLERANCE, 0},
{ 104, 3226011647u, 1508888184u, 1060430241u, 3524949092u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 105, 3215238675u, 166402802u, 3237198975u, 3572369260u, 3215237941u, 3647655500u, 0, TANH_TOLERANCE, 0},
{ 106, 1075575366u, 2441536203u, 3202753937u, 3658194573u, 1072693244u, 2031976466u, 0, TANH_TOLERANCE, 0},
{ 107, 1070781516u, 2479742828u, 1062342831u, 4214154303u, 1070747103u, 1801754207u, 0, TANH_TOLERANCE, 0},
{ 108, 1076105338u, 426896765u, 1066474375u, 2201754442u, 1072693247u, 4260151399u, 0, TANH_TOLERANCE, 0},
{ 109, 3214503389u, 2055773734u, 3239267288u, 291396537u, 3214503046u, 4246773790u, 0, TANH_TOLERANCE, 0},
{ 110, 3224385121u, 874125203u, 3210508124u, 4091098764u, 3220176895u, 4294967147u, 0, TANH_TOLERANCE, 0},
{ 111, 1072007482u, 120488169u, 3241241441u, 1985269424u, 1071827020u, 3308157325u, 0, TANH_TOLERANCE, 0},
{ 112, 3218073746u, 2243036871u, 3243941101u, 740033495u, 3218031479u, 4064057836u, 0, TANH_TOLERANCE, 0},
{ 113, 3218862090u, 1176656356u, 1074261978u, 3588756231u, 3218754022u, 3974936801u, 0, TANH_TOLERANCE, 0},
{ 114, 3228699543u, 3037249392u, 1061635587u, 1173102190u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 115, 3224626669u, 2882725208u, 1071440059u, 69225090u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 116, 3218954930u, 272319256u, 1072073912u, 2493997123u, 3218830490u, 2787918817u, 0, TANH_TOLERANCE, 0},
{ 117, 1070303098u, 188610379u, 3232757923u, 2209647371u, 1070275785u, 2868756030u, 0, TANH_TOLERANCE, 0},
{ 118, 3225224181u, 1990439193u, 1078073146u, 622849962u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 119, 1069718653u, 756052458u, 1081649113u, 2247475162u, 1069710129u, 3490933881u, 0, TANH_TOLERANCE, 0},
{ 120, 1071060248u, 3878055211u, 3222407050u, 2979438623u, 1070997900u, 1162556570u, 0, TANH_TOLERANCE, 0},
{ 121, 3214165365u, 2676398686u, 1105124431u, 3631096636u, 3214165192u, 464247846u, 0, TANH_TOLERANCE, 0},
{ 122, 1071370846u, 1697791764u, 3198136112u, 2299842819u, 1071264055u, 4133345906u, 0, TANH_TOLERANCE, 0},
{ 123, 1074939040u, 1931502677u, 3215264397u, 3016456382u, 1072692795u, 1553366917u, 0, TANH_TOLERANCE, 0},
{ 124, 1073302002u, 343404215u, 1061072607u, 4266232536u, 1072522724u, 3704959248u, 0, TANH_TOLERANCE, 0},
{ 125, 3225502196u, 4140316002u, 1082896196u, 868256971u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 126, 1074374234u, 1864139509u, 3187675097u, 3084482407u, 1072686376u, 1962441622u, 0, TANH_TOLERANCE, 0},
{ 127, 3220191323u, 2427162817u, 3234748208u, 2715105792u, 3219688914u, 3013850408u, 0, TANH_TOLERANCE, 0},
{ 128, 1070891968u, 3943389284u, 1046724025u, 3626825684u, 1070847739u, 3439563777u, 0, TANH_TOLERANCE, 0},
{ 129, 1067443098u, 967350972u, 1093012318u, 448002663u, 1067442422u, 3845472712u, 0, TANH_TOLERANCE, 0},
{ 130, 3228777187u, 105058217u, 1069733884u, 171786224u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 131, 3213731756u, 2863482262u, 3204997271u, 877784425u, 3213731620u, 3648045742u, 0, TANH_TOLERANCE, 0},
{ 132, 3216260801u, 2801782962u, 3213604117u, 762347195u, 3216258042u, 2678983680u, 0, TANH_TOLERANCE, 0},
{ 133, 3224049543u, 2317950339u, 3246333414u, 2135700283u, 3220176895u, 4294936411u, 0, TANH_TOLERANCE, 0},
{ 134, 1069099309u, 4171919805u, 1082858682u, 2180920863u, 1069094020u, 3820197062u, 0, TANH_TOLERANCE, 0},
{ 135, 3221197660u, 1918836931u, 1083603224u, 3137821660u, 3220097424u, 1722624890u, 0, TANH_TOLERANCE, 0},
{ 136, 1081882778u, 3456203663u, 3235600523u, 2335688936u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 137, 1066396570u, 4170235262u, 1051824459u, 521583737u, 1066396401u, 2543673130u, 0, TANH_TOLERANCE, 0},
{ 138, 1075056847u, 1296623194u, 3250673860u, 2442872540u, 1072693063u, 3166683353u, 0, TANH_TOLERANCE, 0},
{ 139, 1071121461u, 289979405u, 1049514449u, 3865737145u, 1071051518u, 2290983565u, 0, TANH_TOLERANCE, 0},
{ 140, 1074250368u, 3699090239u, 1054539840u, 3259249360u, 1072682236u, 3608691743u, 0, TANH_TOLERANCE, 0},
{ 141, 1079640884u, 1619819023u, 1045993352u, 1022642459u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 142, 1075141548u, 19455098u, 3229182089u, 2096003654u, 1072693151u, 1888247792u, 0, TANH_TOLERANCE, 0},
{ 143, 1074200784u, 3803689997u, 1071630912u, 2263729518u, 1072679951u, 1586915304u, 0, TANH_TOLERANCE, 0},
{ 144, 1080385741u, 2816837387u, 1063422305u, 2597606398u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 145, 1072245897u, 3680967506u, 1040201163u, 179224723u, 1071972935u, 363515293u, 0, TANH_TOLERANCE, 0},
{ 146, 3213795591u, 978126928u, 1101553990u, 4047893399u, 3213795441u, 2507481145u, 0, TANH_TOLERANCE, 0},
{ 147, 3221273469u, 4059818629u, 1042678728u, 3640293589u, 3220113888u, 3437106909u, 0, TANH_TOLERANCE, 0},
{ 148, 3228541096u, 3383497159u, 1070002807u, 1527313008u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 149, 3216339167u, 2599946514u, 1104170406u, 2738675352u, 3216335891u, 1051626081u, 0, TANH_TOLERANCE, 0},
{ 150, 1081115375u, 3616571377u, 1060859316u, 1130603218u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 151, 1073931644u, 3859211180u, 1067940450u, 1744531824u, 1072656336u, 429068867u, 0, TANH_TOLERANCE, 0},
{ 152, 1065900012u, 1958025850u, 3236511256u, 2472176453u, 1065899937u, 1394244149u, 0, TANH_TOLERANCE, 0},
{ 153, 3223669905u, 182132862u, 3250520938u, 3924356991u, 3220176895u, 4284838839u, 0, TANH_TOLERANCE, 0},
{ 154, 3224210428u, 35632886u, 3209806504u, 1453402523u, 3220176895u, 4294964644u, 0, TANH_TOLERANCE, 0},
{ 155, 1076182070u, 743225214u, 3202890678u, 142917400u, 1072693247u, 4284170650u, 0, TANH_TOLERANCE, 0},
{ 156, 1075442096u, 1472665012u, 3203138231u, 256588219u, 1072693238u, 1077098108u, 0, TANH_TOLERANCE, 0},
{ 157, 1079253522u, 1062927000u, 1061134072u, 931677439u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 158, 1069912068u, 2320910576u, 1055663370u, 288059864u, 1069898851u, 1531188271u, 0, TANH_TOLERANCE, 0},
{ 159, 1075812365u, 1448349062u, 3199478070u, 3454027134u, 1072693247u, 1811377479u, 0, TANH_TOLERANCE, 0},
{ 160, 3224875886u, 4215445172u, 3196654963u, 2231888973u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 161, 3227757863u, 40413554u, 3232578253u, 983832844u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 162, 3221624382u, 3995725873u, 1050082319u, 777231627u, 3220160190u, 46615835u, 0, TANH_TOLERANCE, 0},
{ 163, 1066152450u, 672789828u, 3253385962u, 2982787335u, 1066152333u, 1814400134u, 0, TANH_TOLERANCE, 0},
{ 164, 1072585179u, 2075971825u, 1070166500u, 4034633931u, 1072146078u, 896769727u, 0, TANH_TOLERANCE, 0},
{ 165, 3218434785u, 1018222907u, 3244621407u, 3090050495u, 3218384633u, 3394350018u, 0, TANH_TOLERANCE, 0},
{ 166, 1071875189u, 937732557u, 3200798890u, 2557898276u, 1071737093u, 3916098959u, 0, TANH_TOLERANCE, 0},
{ 167, 1075196588u, 130346162u, 3223590310u, 275568693u, 1072693184u, 2361710702u, 0, TANH_TOLERANCE, 0},
{ 168, 1065967541u, 3807416441u, 1075961161u, 3706820266u, 1065967456u, 3459855166u, 0, TANH_TOLERANCE, 0},
{ 169, 3219244733u, 1710131411u, 1078123323u, 1900790503u, 3219138047u, 3814235172u, 0, TANH_TOLERANCE, 0},
{ 170, 3226236449u, 3420420033u, 3210844787u, 588423066u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 171, 1067509906u, 1160162008u, 3246307879u, 4265764460u, 1067509503u, 2601735024u, 0, TANH_TOLERANCE, 0},
{ 172, 1080523338u, 366653268u, 3188814424u, 466059202u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 173, 3222433435u, 1325936170u, 3221436876u, 680097612u, 3220176478u, 4252589573u, 0, TANH_TOLERANCE, 0},
{ 174, 3225711052u, 1827735934u, 3200554324u, 2875599271u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 175, 3213050498u, 3117037091u, 3239246636u, 15838845u, 3213050461u, 2222620939u, 0, TANH_TOLERANCE, 0},
{ 176, 1067702644u, 749718883u, 3223587064u, 1523766569u, 1067701992u, 3622799087u, 0, TANH_TOLERANCE, 0},
{ 177, 1066853747u, 1966536294u, 3250158026u, 699164258u, 1066853497u, 1898707226u, 0, TANH_TOLERANCE, 0},
{ 178, 1079174067u, 3759049394u, 1106085272u, 1183789499u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 179, 1074910167u, 1970107747u, 1095245453u, 2308233883u, 1072692683u, 3577819256u, 0, TANH_TOLERANCE, 0},
{ 180, 1076367836u, 1491017852u, 1041444355u, 1723375725u, 1072693247u, 4294333058u, 0, TANH_TOLERANCE, 0},
{ 181, 3219775798u, 1141349287u, 1097465301u, 3403438584u, 3219482519u, 2595676565u, 0, TANH_TOLERANCE, 0},
{ 182, 3224280452u, 1711085243u, 3250239076u, 1377484108u, 3220176895u, 4294966385u, 0, TANH_TOLERANCE, 0},
{ 183, 1079510651u, 2880275004u, 1084039594u, 1611394950u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 184, 3224784251u, 2626629370u, 1063771493u, 1499080813u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 185, 1068862751u, 3936262414u, 1103919063u, 3175668759u, 1068859424u, 3440133182u, 0, TANH_TOLERANCE, 0},
{ 186, 3217418903u, 1270950554u, 3194616071u, 3680565379u, 3217405029u, 3952562788u, 0, TANH_TOLERANCE, 0},
{ 187, 3217585407u, 1066985223u, 3221613219u, 4089383168u, 3217566182u, 3374525206u, 0, TANH_TOLERANCE, 0},
{ 188, 3220204567u, 4017329311u, 3208334452u, 1667591498u, 3219699702u, 2508843272u, 0, TANH_TOLERANCE, 0},
{ 189, 1077678397u, 3154656624u, 1061894279u, 3886344038u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 190, 1068478737u, 977586119u, 3209762784u, 953839852u, 1068476088u, 3411453719u, 0, TANH_TOLERANCE, 0},
{ 191, 1081896575u, 143071571u, 3206165386u, 913097445u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 192, 3213634128u, 1371169579u, 1057079837u, 2594818628u, 3213634011u, 4114428713u, 0, TANH_TOLERANCE, 0},
{ 193, 3228724664u, 2259342224u, 3217432469u, 1824221478u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 194, 3227960407u, 1576604497u, 1079368611u, 185078728u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 195, 3221679427u, 444800035u, 3243343143u, 1734989302u, 3220163343u, 3657733008u, 0, TANH_TOLERANCE, 0},
{ 196, 1072748883u, 130452005u, 1041548088u, 2158433515u, 1072238149u, 3617271211u, 0, TANH_TOLERANCE, 0},
{ 197, 3225258784u, 1941318385u, 1045807374u, 792193370u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 198, 3225716754u, 1299392207u, 3212131720u, 3205732280u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 199, 1079824436u, 3035093505u, 1052187689u, 3287702190u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 200, 3227801892u, 2160225215u, 1102624859u, 836655570u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 201, 1079946410u, 3360816360u, 3246176356u, 172860634u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 202, 1073092940u, 146831910u, 1051558014u, 2340722078u, 1072444136u, 1759342658u, 0, TANH_TOLERANCE, 0},
{ 203, 3224124895u, 1603798153u, 3207725532u, 1099413093u, 3220176895u, 4294957514u, 0, TANH_TOLERANCE, 0},
{ 204, 3227804010u, 2429340443u, 3190303581u, 3223770005u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 205, 1073785807u, 955542166u, 3230415151u, 275583938u, 1072629283u, 1074678205u, 0, TANH_TOLERANCE, 0},
{ 206, 1078291818u, 513397822u, 1090646554u, 2089321329u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 207, 3214141396u, 2782073372u, 1046063872u, 4023829068u, 3214141232u, 1525062828u, 0, TANH_TOLERANCE, 0},
{ 208, 1079690454u, 3242223094u, 3194111199u, 4264674108u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 209, 3225927909u, 3506346169u, 1047020885u, 1742757458u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 210, 3214684573u, 1265459564u, 3193450280u, 3650514880u, 3214684106u, 2321174768u, 0, TANH_TOLERANCE, 0},
{ 211, 1075464434u, 1525260440u, 3235452527u, 2612331392u, 1072693239u, 3343303113u, 0, TANH_TOLERANCE, 0},
{ 212, 3227697400u, 1263613754u, 3219096387u, 635677201u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 213, 3217806423u, 4140947288u, 3200792376u, 2013265346u, 3217778219u, 1500451800u, 0, TANH_TOLERANCE, 0},
{ 214, 3227954296u, 1912759945u, 3237045253u, 1351396825u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 215, 3228282218u, 1001433078u, 3206926643u, 2741676659u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 216, 1075680726u, 1088945233u, 1085095743u, 3986114865u, 1072693246u, 1809567207u, 0, TANH_TOLERANCE, 0},
{ 217, 3219928361u, 831239754u, 1099828675u, 3071308141u, 3219562775u, 3422341860u, 0, TANH_TOLERANCE, 0},
{ 218, 3222688769u, 3473592372u, 1102759382u, 1309576357u, 3220176836u, 2359199832u, 0, TANH_TOLERANCE, 0},
{ 219, 3229166610u, 2042340367u, 1091945628u, 2062772374u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 220, 3214688631u, 1840632537u, 1096533424u, 807510337u, 3214688161u, 2546146924u, 0, TANH_TOLERANCE, 0},
{ 221, 3224111690u, 144814872u, 3212698915u, 2282965697u, 3220176895u, 4294955331u, 0, TANH_TOLERANCE, 0},
{ 222, 1073333582u, 2552499583u, 3229111426u, 1470130815u, 1072532310u, 2637908577u, 0, TANH_TOLERANCE, 0},
{ 223, 3227364425u, 2858583811u, 1089760910u, 6360994u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 224, 3215042145u, 1614537194u, 1075198900u, 4088705365u, 3215041687u, 1726146854u, 0, TANH_TOLERANCE, 0},
{ 225, 3228918974u, 3545570051u, 1065221325u, 1629217700u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 226, 1072744324u, 1813392963u, 3235313361u, 3772501596u, 1072234610u, 661468199u, 0, TANH_TOLERANCE, 0},
{ 227, 3215677054u, 2406734491u, 1042055360u, 89226663u, 3215675353u, 3862932932u, 0, TANH_TOLERANCE, 0},
{ 228, 3214625449u, 1618759139u, 3194723421u, 3888234802u, 3214625026u, 10619074u, 0, TANH_TOLERANCE, 0},
{ 229, 1068988736u, 3590035633u, 3212424262u, 2892456615u, 1068984439u, 3719711940u, 0, TANH_TOLERANCE, 0},
{ 230, 3213011732u, 2431246964u, 3241512456u, 183850734u, 3213011698u, 2928537796u, 0, TANH_TOLERANCE, 0},
{ 231, 1076918189u, 3088319870u, 3211544311u, 862225364u, 1072693247u, 4294967206u, 0, TANH_TOLERANCE, 0},
{ 232, 3224808904u, 3495352775u, 1058576726u, 596957268u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 233, 1066476292u, 1839214511u, 3205004060u, 1923240983u, 1066476187u, 2556221634u, 0, TANH_TOLERANCE, 0},
{ 234, 1069608200u, 739619702u, 3223356436u, 2689885273u, 1069601779u, 2957113876u, 0, TANH_TOLERANCE, 0},
{ 235, 3216053611u, 2143376228u, 1098306332u, 3760236188u, 3216051952u, 2092758873u, 0, TANH_TOLERANCE, 0},
{ 236, 1074621795u, 671680995u, 1091262633u, 2315535361u, 1072690572u, 3470829674u, 0, TANH_TOLERANCE, 0},
{ 237, 3219408869u, 2493598049u, 3194927008u, 1689107592u, 3219255506u, 1019995372u, 0, TANH_TOLERANCE, 0},
{ 238, 3213058631u, 1578976988u, 1066368383u, 2117279163u, 3213058593u, 1870641139u, 0, TANH_TOLERANCE, 0},
{ 239, 3221939535u, 3425290087u, 1098487295u, 1263412017u, 3220171861u, 1494771509u, 0, TANH_TOLERANCE, 0},
{ 240, 3217869948u, 3635396812u, 1070999426u, 3965655689u, 3217838734u, 1233391676u, 0, TANH_TOLERANCE, 0},
{ 241, 1069633530u, 2183973116u, 1101098363u, 1118613350u, 1069626662u, 1134433172u, 0, TANH_TOLERANCE, 0},
{ 242, 3221946089u, 199516350u, 1078368488u, 164621458u, 3220171985u, 2155767731u, 0, TANH_TOLERANCE, 0},
{ 243, 3212871842u, 3570940805u, 3230316437u, 3596080877u, 3212871819u, 1253083702u, 0, TANH_TOLERANCE, 0},
{ 244, 3217646749u, 980880313u, 1079833442u, 884465057u, 3217625256u, 410689042u, 0, TANH_TOLERANCE, 0},
{ 245, 1080054180u, 2558179220u, 1052873711u, 1233598120u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 246, 1067038165u, 1909994277u, 1085015978u, 2991527452u, 1067037811u, 2026092876u, 0, TANH_TOLERANCE, 0},
{ 247, 1070292444u, 1680290941u, 1074309900u, 2943870846u, 1070265607u, 1158571911u, 0, TANH_TOLERANCE, 0},
{ 248, 1069981892u, 1451927357u, 3228615456u, 1502585517u, 1069966634u, 3731947704u, 0, TANH_TOLERANCE, 0},
{ 249, 3224677615u, 751136990u, 3230392165u, 3493275472u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 250, 1079491599u, 1209623292u, 3238056647u, 979495322u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 251, 3228404200u, 1717672108u, 1048120593u, 531240316u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 252, 1068854987u, 3548721654u, 1086112947u, 3391817224u, 1068851715u, 761198005u, 0, TANH_TOLERANCE, 0},
{ 253, 1074691123u, 2758195125u, 1100880260u, 2028440924u, 1072691194u, 767085901u, 0, TANH_TOLERANCE, 0},
{ 254, 1076883861u, 2750123373u, 3232200256u, 1086294931u, 1072693247u, 4294967055u, 0, TANH_TOLERANCE, 0},
{ 255, 1065978768u, 2986160931u, 1076097908u, 2540046258u, 1065978681u, 3777549083u, 0, TANH_TOLERANCE, 0},
{ 256, 3224990842u, 451471221u, 1064816262u, 4187644495u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 257, 1080585860u, 2439500162u, 1065280276u, 1979490284u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 258, 1065581656u, 2283342035u, 1078398157u, 1345997553u, 1065581617u, 4289095703u, 0, TANH_TOLERANCE, 0},
{ 259, 3219540804u, 179066662u, 1103272172u, 1217337578u, 3219342777u, 584216337u, 0, TANH_TOLERANCE, 0},
{ 260, 3218902409u, 3779303391u, 3210023352u, 3115946280u, 3218787406u, 3376448869u, 0, TANH_TOLERANCE, 0},
{ 261, 3213961394u, 286247089u, 1085153597u, 713645369u, 3213961288u, 3547746481u, 0, TANH_TOLERANCE, 0},
{ 262, 1077941860u, 1468283899u, 1042831668u, 2022736418u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 263, 1076847649u, 3305564080u, 1065483445u, 482392433u, 1072693247u, 4294966877u, 0, TANH_TOLERANCE, 0},
{ 264, 3216375871u, 2256346551u, 3222430705u, 2071674991u, 3216372332u, 768731038u, 0, TANH_TOLERANCE, 0},
{ 265, 3216607607u, 2295269094u, 1084451053u, 2773103941u, 3216602078u, 1439428617u, 0, TANH_TOLERANCE, 0},
{ 266, 1075028218u, 1482721827u, 1092243422u, 3125409590u, 1072693018u, 3260391029u, 0, TANH_TOLERANCE, 0},
{ 267, 3221065973u, 1381740563u, 1071545057u, 2918235653u, 3220075282u, 1703589823u, 0, TANH_TOLERANCE, 0},
{ 268, 3226133060u, 1105857967u, 3241990046u, 2703723225u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 269, 1066084243u, 174689677u, 1079333374u, 3947057014u, 1066084138u, 3270329839u, 0, TANH_TOLERANCE, 0},
{ 270, 1077878947u, 2023082423u, 3242081486u, 1169047927u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 271, 1070817355u, 3742487766u, 1043425732u, 194972788u, 1070779930u, 515450847u, 0, TANH_TOLERANCE, 0},
{ 272, 3220083283u, 2136071361u, 3211529757u, 993675115u, 3219636252u, 1007735063u, 0, TANH_TOLERANCE, 0},
{ 273, 3219954837u, 210772141u, 3241441539u, 580731413u, 3219575893u, 3207362503u, 0, TANH_TOLERANCE, 0},
{ 274, 1078111773u, 1751560711u, 1074522705u, 180987057u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 275, 1071997471u, 2552236599u, 1088658621u, 2112468655u, 1071820440u, 2818435747u, 0, TANH_TOLERANCE, 0},
{ 276, 3213407865u, 1578223762u, 3224596567u, 2456166162u, 3213407786u, 3283589150u, 0, TANH_TOLERANCE, 0},
{ 277, 1070041301u, 2110924310u, 1086207177u, 3161208323u, 1070024153u, 713852193u, 0, TANH_TOLERANCE, 0},
{ 278, 3223474786u, 2352173188u, 1079361728u, 4070222179u, 3220176895u, 4096103338u, 0, TANH_TOLERANCE, 0},
{ 279, 1080041384u, 2481562701u, 1090937016u, 3809489716u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 280, 3215877019u, 330905705u, 1086260896u, 90264431u, 3215874683u, 2935392842u, 0, TANH_TOLERANCE, 0},
{ 281, 1065895785u, 4162008079u, 3194387916u, 759522153u, 1065895711u, 1860972907u, 0, TANH_TOLERANCE, 0},
{ 282, 1075772157u, 1839697482u, 3216442625u, 2211508949u, 1072693247u, 919725479u, 0, TANH_TOLERANCE, 0},
{ 283, 3227787115u, 3736863454u, 1063475914u, 3150741666u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 284, 1070223067u, 4200269406u, 3236646101u, 1061812176u, 1070199193u, 3353234231u, 0, TANH_TOLERANCE, 0},
{ 285, 1074975099u, 106027290u, 3234978297u, 2245237549u, 1072692904u, 926646345u, 0, TANH_TOLERANCE, 0},
{ 286, 3228109966u, 2132131375u, 3250483427u, 3449276437u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 287, 1077854442u, 2334440944u, 1105423490u, 4004336184u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 288, 3220869856u, 4090088208u, 1042030013u, 3898658299u, 3220030793u, 1280038209u, 0, TANH_TOLERANCE, 0},
{ 289, 3217345248u, 2272831437u, 3253082595u, 2639188641u, 3217333388u, 615613079u, 0, TANH_TOLERANCE, 0},
{ 290, 1069446748u, 1856594168u, 3189515294u, 4101853676u, 1069437378u, 4022174950u, 0, TANH_TOLERANCE, 0},
{ 291, 1073915260u, 2211699255u, 3195060344u, 3865018604u, 1072653977u, 3088241704u, 0, TANH_TOLERANCE, 0},
{ 292, 3227038370u, 996259334u, 3241496889u, 3782673116u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 293, 1080256379u, 3840380763u, 1048674041u, 550040067u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 294, 3229399497u, 95874100u, 3237232828u, 2645647822u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 295, 1065685736u, 3441419500u, 3252367038u, 876710419u, 1065685688u, 249926735u, 0, TANH_TOLERANCE, 0},
{ 296, 3226010640u, 2560836004u, 3199616543u, 1180840586u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 297, 3221602966u, 2218230392u, 3227485787u, 3947214579u, 3220158774u, 97536700u, 0, TANH_TOLERANCE, 0},
{ 298, 1075345350u, 1447312532u, 1081476588u, 780366847u, 1072693227u, 2597730715u, 0, TANH_TOLERANCE, 0},
{ 299, 1073618219u, 2842113832u, 3216156731u, 225159029u, 1072598206u, 38725043u, 0, TANH_TOLERANCE, 0},
{ 300, 1079242825u, 1601981129u, 3234628869u, 2236538344u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 301, 1076784916u, 2194185737u, 3242362684u, 87913366u, 1072693247u, 4294966204u, 0, TANH_TOLERANCE, 0},
{ 302, 3215861096u, 1346862963u, 1077836259u, 3604666660u, 3215858816u, 1876833276u, 0, TANH_TOLERANCE, 0},
{ 303, 3218547435u, 3115209742u, 1099332326u, 1325101950u, 3218484663u, 109142900u, 0, TANH_TOLERANCE, 0},
{ 304, 3221400314u, 3889223100u, 1053247613u, 3371396923u, 3220137833u, 3785105086u, 0, TANH_TOLERANCE, 0},
{ 305, 3220477868u, 4163120793u, 1075022670u, 1387631215u, 3219879827u, 2620319036u, 0, TANH_TOLERANCE, 0},
{ 306, 3218064691u, 1532426189u, 1063168268u, 3397022615u, 3218022962u, 3163394182u, 0, TANH_TOLERANCE, 0},
{ 307, 3216761961u, 89324166u, 1079206060u, 3429424710u, 3216754762u, 163055010u, 0, TANH_TOLERANCE, 0},
{ 308, 3214345198u, 747591401u, 1072238381u, 2803213904u, 3214344944u, 1023319056u, 0, TANH_TOLERANCE, 0},
{ 309, 1078530868u, 271904221u, 1044258318u, 1858545114u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 310, 3222826034u, 314958082u, 3249912496u, 2966213175u, 3220176875u, 594125926u, 0, TANH_TOLERANCE, 0},
{ 311, 3215005206u, 3119528953u, 3217179014u, 2908718240u, 3215004791u, 983594337u, 0, TANH_TOLERANCE, 0},
{ 312, 3226738936u, 2018361566u, 1100926600u, 3985805054u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 313, 1073278308u, 409584884u, 3239758947u, 755795129u, 1072515176u, 1543239858u, 0, TANH_TOLERANCE, 0},
{ 314, 1074723870u, 1819156379u, 3251342302u, 2982669005u, 1072691435u, 1108211960u, 0, TANH_TOLERANCE, 0},
{ 315, 1080591913u, 2080534280u, 3188254060u, 449171797u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 316, 1079179684u, 168744837u, 3214950009u, 1322217822u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 317, 3229061076u, 3250487255u, 1062120700u, 1876195180u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 318, 3223197752u, 1336400247u, 1098057903u, 3314079581u, 3220176894u, 3333899270u, 0, TANH_TOLERANCE, 0},
{ 319, 3216261732u, 265025555u, 1063854282u, 3779482256u, 3216258967u, 1006784628u, 0, TANH_TOLERANCE, 0},
{ 320, 1072543381u, 887044257u, 1054789618u, 2732056261u, 1072126831u, 1641554481u, 0, TANH_TOLERANCE, 0},
{ 321, 1067932534u, 4027115185u, 3191764868u, 2940199511u, 1067931473u, 3932768465u, 0, TANH_TOLERANCE, 0},
{ 322, 3216131643u, 2875684421u, 3227459837u, 2251967570u, 3216129613u, 2392090637u, 0, TANH_TOLERANCE, 0},
{ 323, 1071633020u, 284173546u, 3238823679u, 3557800647u, 1071476604u, 1926910603u, 0, TANH_TOLERANCE, 0},
{ 324, 1080487040u, 3147771266u, 3220110464u, 2933364246u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 325, 1071144616u, 3366183281u, 3234870843u, 537442654u, 1071071656u, 3460153791u, 0, TANH_TOLERANCE, 0},
{ 326, 3227341572u, 2529029548u, 3249882819u, 3781513577u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 327, 3219727810u, 1080845539u, 3206760016u, 911778687u, 3219455595u, 167462708u, 0, TANH_TOLERANCE, 0},
{ 328, 3213971132u, 469586759u, 1091830022u, 3080528840u, 3213971024u, 477322961u, 0, TANH_TOLERANCE, 0},
{ 329, 1075006224u, 2863108169u, 3225605506u, 2508274250u, 1072692976u, 3779254893u, 0, TANH_TOLERANCE, 0},
{ 330, 3218167016u, 4080017377u, 3206492941u, 1470284690u, 3218140041u, 2231611050u, 0, TANH_TOLERANCE, 0},
{ 331, 3217606150u, 3867917386u, 1102054928u, 3504746045u, 3217586177u, 3491769570u, 0, TANH_TOLERANCE, 0},
{ 332, 1070813735u, 2962134101u, 3244741577u, 3390537350u, 1070776621u, 2796934313u, 0, TANH_TOLERANCE, 0},
{ 333, 1077716053u, 1702237980u, 1071598971u, 1102587474u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 334, 3216601606u, 2180218657u, 3211592260u, 1206527853u, 3216596136u, 1797664468u, 0, TANH_TOLERANCE, 0},
{ 335, 3215959112u, 394130786u, 3242511482u, 2437699868u, 3215956476u, 632716331u, 0, TANH_TOLERANCE, 0},
{ 336, 1066257155u, 849581558u, 3252006507u, 2008614943u, 1066257017u, 2040632549u, 0, TANH_TOLERANCE, 0},
{ 337, 3218528622u, 3128971673u, 3249137531u, 2773583059u, 3218468083u, 2682372564u, 0, TANH_TOLERANCE, 0},
{ 338, 1076641258u, 590727700u, 3248651761u, 2183878539u, 1072693247u, 4294957516u, 0, TANH_TOLERANCE, 0},
{ 339, 1080127109u, 820687580u, 3208143496u, 1402434664u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 340, 3229222163u, 1873709254u, 3245167989u, 44275991u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 341, 3213786001u, 1174874204u, 3208263730u, 2360372288u, 3213785853u, 3281597952u, 0, TANH_TOLERANCE, 0},
{ 342, 1081834580u, 937573440u, 3208953761u, 211240241u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 343, 3226771718u, 2469774991u, 1043117070u, 3380071805u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 344, 1069655378u, 442507560u, 3254252803u, 3257889649u, 1069648107u, 1967517320u, 0, TANH_TOLERANCE, 0},
{ 345, 1071996248u, 1854921625u, 1049810168u, 2729627545u, 1071819634u, 511546235u, 0, TANH_TOLERANCE, 0},
{ 346, 3229546805u, 4001809575u, 3240128649u, 278261523u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 347, 1077787510u, 1793907966u, 3238955714u, 398859249u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 348, 3216681187u, 2511916952u, 3219195283u, 1697158299u, 3216674898u, 3492920521u, 0, TANH_TOLERANCE, 0},
{ 349, 1073131276u, 3230931724u, 3243897690u, 3508781585u, 1072460728u, 72385801u, 0, TANH_TOLERANCE, 0},
{ 350, 1081827510u, 1674254897u, 1046547577u, 217148561u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 351, 3218603986u, 3275604304u, 3194840159u, 2991205850u, 3218534188u, 1895030450u, 0, TANH_TOLERANCE, 0},
{ 352, 3214123743u, 3509997278u, 3248888030u, 3897986511u, 3214123586u, 445233222u, 0, TANH_TOLERANCE, 0},
{ 353, 1067105379u, 2156824613u, 1042295665u, 1239257646u, 1067104981u, 1993936574u, 0, TANH_TOLERANCE, 0},
{ 354, 3219555541u, 1073153314u, 3250031627u, 2567234990u, 3219352129u, 655772150u, 0, TANH_TOLERANCE, 0},
{ 355, 3213662084u, 4261696995u, 3197784432u, 323702024u, 3213661963u, 1132254523u, 0, TANH_TOLERANCE, 0},
{ 356, 3226913781u, 4075177615u, 3202791065u, 1919006082u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 357, 3225638525u, 386429966u, 1086504491u, 3698826164u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 358, 1075181462u, 1681986446u, 3194985869u, 3072950140u, 1072693176u, 3387376968u, 0, TANH_TOLERANCE, 0},
{ 359, 3220457661u, 3719038997u, 1055433962u, 3331415058u, 3219869011u, 1568398620u, 0, TANH_TOLERANCE, 0},
{ 360, 1070186897u, 2420250111u, 3238002206u, 1928661079u, 1070164479u, 752957556u, 0, TANH_TOLERANCE, 0},
{ 361, 1075622754u, 3679866727u, 3227386672u, 1273835792u, 1072693245u, 2332877410u, 0, TANH_TOLERANCE, 0},
{ 362, 1065739986u, 2682092368u, 3234222284u, 1325425811u, 1065739931u, 3904488205u, 0, TANH_TOLERANCE, 0},
{ 363, 1068895525u, 4175172697u, 3208346191u, 2130706153u, 1068891962u, 1281742233u, 0, TANH_TOLERANCE, 0},
{ 364, 1078458136u, 1200784450u, 1083605096u, 1248595607u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 365, 3219133743u, 1897285171u, 3251296075u, 944966123u, 3218977948u, 629861953u, 0, TANH_TOLERANCE, 0},
{ 366, 3225642610u, 2270747330u, 3230692631u, 422503284u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 367, 1076780005u, 2857564741u, 1075647403u, 3308906709u, 1072693247u, 4294966119u, 0, TANH_TOLERANCE, 0},
{ 368, 3216058010u, 1380066948u, 3232612906u, 2613634294u, 3216056331u, 3013519241u, 0, TANH_TOLERANCE, 0},
{ 369, 1071230888u, 4022784584u, 1060483857u, 3264056381u, 1071145971u, 252615328u, 0, TANH_TOLERANCE, 0},
{ 370, 1066657500u, 1778509100u, 3213146285u, 2665833973u, 1066657336u, 924195788u, 0, TANH_TOLERANCE, 0},
{ 371, 3219873028u, 1859175955u, 1079949560u, 4258450607u, 3219534594u, 2888810065u, 0, TANH_TOLERANCE, 0},
{ 372, 1067151756u, 4128020197u, 1076266146u, 4122840980u, 1067151326u, 2056919845u, 0, TANH_TOLERANCE, 0},
{ 373, 3214154683u, 2454653987u, 3229487005u, 2977478685u, 3214154514u, 893387246u, 0, TANH_TOLERANCE, 0},
{ 374, 3229439235u, 1355181872u, 1095308770u, 436846481u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 375, 3227730934u, 2592856453u, 3247825559u, 3195234082u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 376, 3222118023u, 3554670043u, 1091621009u, 3321236467u, 3220174346u, 370328545u, 0, TANH_TOLERANCE, 0},
{ 377, 1072158561u, 1936670355u, 1095715713u, 2958468553u, 1071921876u, 3097295899u, 0, TANH_TOLERANCE, 0},
{ 378, 3214311205u, 2960339502u, 1098808013u, 1044068983u, 3214310968u, 2300984713u, 0, TANH_TOLERANCE, 0},
{ 379, 3215565553u, 4093388677u, 1095478112u, 1735930261u, 3215564151u, 1155295820u, 0, TANH_TOLERANCE, 0},
{ 380, 1078457390u, 1807398746u, 3195743135u, 4261616162u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 381, 3218731378u, 3250576797u, 1059002384u, 3043079652u, 3218643992u, 3185278812u, 0, TANH_TOLERANCE, 0},
{ 382, 1072352837u, 666051428u, 3208765404u, 1912684117u, 1072031760u, 472268081u, 0, TANH_TOLERANCE, 0},
{ 383, 1081467324u, 1949030179u, 1096388934u, 896459246u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 384, 1068980717u, 622499767u, 1066707637u, 1490260486u, 1068976486u, 3778455976u, 0, TANH_TOLERANCE, 0},
{ 385, 1081522669u, 1490616165u, 3251242436u, 795675736u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 386, 1075701016u, 3662877092u, 3234317146u, 3200513112u, 1072693246u, 2781992228u, 0, TANH_TOLERANCE, 0},
{ 387, 1076748754u, 1356101968u, 3236536816u, 3062844611u, 1072693247u, 4294965399u, 0, TANH_TOLERANCE, 0},
{ 388, 3220971216u, 2284484846u, 3219498359u, 3240896015u, 3220055734u, 2376612227u, 0, TANH_TOLERANCE, 0},
{ 389, 3225273929u, 494503287u, 1092811254u, 142673998u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 390, 3229057244u, 3394882641u, 3225306538u, 364852125u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 391, 3222116035u, 193885269u, 1088149839u, 1359805831u, 3220174326u, 2917860536u, 0, TANH_TOLERANCE, 0},
{ 392, 3216213422u, 592580907u, 3199560872u, 3086438952u, 3216210947u, 3529159780u, 0, TANH_TOLERANCE, 0},
{ 393, 1070004424u, 1778008540u, 1049064687u, 73581647u, 1069988466u, 3796959165u, 0, TANH_TOLERANCE, 0},
{ 394, 3227859230u, 233240285u, 1081923320u, 2710903921u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 395, 1072659495u, 3719878805u, 1079866720u, 3615458228u, 1072178925u, 119062963u, 0, TANH_TOLERANCE, 0},
{ 396, 3221194724u, 3647632375u, 3247225271u, 3839959621u, 3220096986u, 2905242185u, 0, TANH_TOLERANCE, 0},
{ 397, 1081381000u, 2232210456u, 3235434773u, 224271737u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 398, 3213975204u, 2134662911u, 3190390590u, 4239009051u, 3213975095u, 1423693863u, 0, TANH_TOLERANCE, 0},
{ 399, 1075283265u, 2305279897u, 1077668039u, 1854523320u, 1072693215u, 1065080987u, 0, TANH_TOLERANCE, 0},
{ 400, 3220912835u, 538224650u, 3206153057u, 1379649610u, 3220041922u, 806488060u, 0, TANH_TOLERANCE, 0},
{ 401, 3215284875u, 3683897920u, 3244167599u, 3647579469u, 3215284065u, 70286255u, 0, TANH_TOLERANCE, 0},
{ 402, 1077698021u, 2694093608u, 1042775347u, 598406111u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 403, 3218975424u, 872706833u, 1084802480u, 2200602798u, 3218847178u, 243292267u, 0, TANH_TOLERANCE, 0},
{ 404, 1065408269u, 904146293u, 1060867322u, 1729685598u, 1065408244u, 1452405291u, 0, TANH_TOLERANCE, 0},
{ 405, 3214569338u, 1894173462u, 3232800651u, 191960416u, 3214568953u, 2872441934u, 0, TANH_TOLERANCE, 0},
{ 406, 1078642431u, 3521028551u, 1054522089u, 3287274359u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 407, 1079658324u, 959640601u, 3201578263u, 4136915018u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 408, 1071345483u, 1553716379u, 1106027987u, 984725765u, 1071242888u, 3562407504u, 0, TANH_TOLERANCE, 0},
{ 409, 3226249729u, 2287646644u, 3240329321u, 2276183378u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 410, 1072403478u, 3940225170u, 3199544434u, 997572161u, 1072058226u, 449217216u, 0, TANH_TOLERANCE, 0},
{ 411, 3219059817u, 36116288u, 3206886566u, 4196602670u, 3218915148u, 4193878759u, 0, TANH_TOLERANCE, 0},
{ 412, 3225967213u, 3550227562u, 3207257983u, 2747744117u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 413, 1081167454u, 507130047u, 1048359321u, 3229888373u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 414, 3221948202u, 2210969014u, 1081031001u, 1946786091u, 3220172024u, 3807901675u, 0, TANH_TOLERANCE, 0},
{ 415, 3224772654u, 4059150589u, 3189759234u, 1177045799u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 416, 1078423548u, 2664812822u, 1050343198u, 2034180320u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 417, 3220070573u, 1175750283u, 3235559706u, 1424491340u, 3219630517u, 3733141581u, 0, TANH_TOLERANCE, 0},
{ 418, 3219147073u, 1630036121u, 3231972785u, 3195479448u, 3218998802u, 3328603128u, 0, TANH_TOLERANCE, 0},
{ 419, 1077846963u, 2527029044u, 1046927050u, 4000723255u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 420, 1076820069u, 3335703647u, 3237349676u, 3869440059u, 1072693247u, 4294966657u, 0, TANH_TOLERANCE, 0},
{ 421, 1078850936u, 3888398377u, 3196041693u, 1290567220u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 422, 1071921950u, 3242451480u, 3248384948u, 707431021u, 1071769613u, 2378538733u, 0, TANH_TOLERANCE, 0},
{ 423, 1075890477u, 2739665123u, 1060777905u, 1733073225u, 1072693247u, 3371085153u, 0, TANH_TOLERANCE, 0},
{ 424, 1075371333u, 1297274853u, 3208848704u, 3341639139u, 1072693231u, 1169620284u, 0, TANH_TOLERANCE, 0},
{ 425, 1066493885u, 2228057309u, 1084318902u, 1317851136u, 1066493775u, 2928536763u, 0, TANH_TOLERANCE, 0},
{ 426, 1077769567u, 270039934u, 3241414679u, 3063626339u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 427, 3220226926u, 83062251u, 3211262173u, 2659016437u, 3219717442u, 1020636511u, 0, TANH_TOLERANCE, 0},
{ 428, 1080015246u, 3833539373u, 3206667189u, 1567476111u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 429, 3217777984u, 2382776852u, 3249232579u, 1546622468u, 3217751063u, 1818212801u, 0, TANH_TOLERANCE, 0},
{ 430, 1076099255u, 1714300821u, 1104130938u, 4167591598u, 1072693247u, 4256765263u, 0, TANH_TOLERANCE, 0},
{ 431, 1067869976u, 2798720100u, 1086978789u, 449990704u, 1067869040u, 1755411038u, 0, TANH_TOLERANCE, 0},
{ 432, 3223858383u, 4039516226u, 3244344107u, 4272932619u, 3220176895u, 4294396436u, 0, TANH_TOLERANCE, 0},
{ 433, 3221659865u, 1683007544u, 1091105663u, 3805494321u, 3220162297u, 2272405765u, 0, TANH_TOLERANCE, 0},
{ 434, 3220852948u, 2072627412u, 1094383324u, 3394151662u, 3220026176u, 3047210052u, 0, TANH_TOLERANCE, 0},
{ 435, 3220570024u, 1120106427u, 3223631624u, 3404608264u, 3219924834u, 2913979229u, 0, TANH_TOLERANCE, 0},
{ 436, 1078985629u, 559918757u, 3205077053u, 908100198u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 437, 1065746590u, 2026673913u, 3244833635u, 2844573214u, 1065746534u, 4285564648u, 0, TANH_TOLERANCE, 0},
{ 438, 3229401435u, 3946837259u, 3234993796u, 3850406820u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 439, 1070062721u, 3139330994u, 1046133568u, 1539650690u, 1070044855u, 2726435592u, 0, TANH_TOLERANCE, 0},
{ 440, 3225171164u, 1554593884u, 3228899878u, 2813752562u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 441, 1069087916u, 3804703138u, 1072931071u, 2053677923u, 1069082736u, 1742473058u, 0, TANH_TOLERANCE, 0},
{ 442, 3227038507u, 289355864u, 1078453818u, 2143066338u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 443, 3216522792u, 2157691971u, 1106629150u, 110806409u, 3216518060u, 864673819u, 0, TANH_TOLERANCE, 0},
{ 444, 1075865563u, 3570399481u, 1085637605u, 180265334u, 1072693247u, 2943779940u, 0, TANH_TOLERANCE, 0},
{ 445, 3216708822u, 558779875u, 3202046748u, 2338464653u, 3216702231u, 506759401u, 0, TANH_TOLERANCE, 0},
{ 446, 1066676984u, 1703969219u, 3229797258u, 1417521063u, 1066676812u, 3133190950u, 0, TANH_TOLERANCE, 0},
{ 447, 3225199349u, 3917440951u, 1051668894u, 3736066983u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 448, 1071043536u, 3106613409u, 1066627453u, 2735392257u, 1070983166u, 1045266683u, 0, TANH_TOLERANCE, 0},
{ 449, 1071956828u, 2229777605u, 1065061963u, 2405869925u, 1071793347u, 502078975u, 0, TANH_TOLERANCE, 0},
{ 450, 3225831741u, 3967957902u, 1057416138u, 3459188071u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 451, 1071784938u, 3699016825u, 3249713090u, 796144848u, 1071672076u, 2579985767u, 0, TANH_TOLERANCE, 0},
{ 452, 3222524940u, 3285165564u, 3211948811u, 401510871u, 3220176688u, 2239026903u, 0, TANH_TOLERANCE, 0},
{ 453, 1078529018u, 634857910u, 3199607513u, 914218057u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 454, 1076403304u, 2030735578u, 3233855943u, 965677531u, 1072693247u, 4294598139u, 0, TANH_TOLERANCE, 0},
{ 455, 1075362511u, 3957229084u, 1051050470u, 3123776651u, 1072693230u, 462899214u, 0, TANH_TOLERANCE, 0},
{ 456, 3221863333u, 162122081u, 3239376395u, 108064594u, 3220170165u, 2709210009u, 0, TANH_TOLERANCE, 0},
{ 457, 3224688874u, 869031839u, 3225020876u, 1344301606u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 458, 3219676354u, 946696117u, 3231825228u, 1700703647u, 3219425812u, 3436958511u, 0, TANH_TOLERANCE, 0},
{ 459, 1074444299u, 3394168074u, 1076939786u, 1666995668u, 1072687986u, 368182188u, 0, TANH_TOLERANCE, 0},
{ 460, 3218211979u, 2488789804u, 3238508333u, 1506943664u, 3218181741u, 3093576615u, 0, TANH_TOLERANCE, 0},
{ 461, 1072788663u, 3844072288u, 3202592279u, 2630019853u, 1072268032u, 509834618u, 0, TANH_TOLERANCE, 0},
{ 462, 3220983118u, 1244307192u, 3191297711u, 2540916692u, 3220058377u, 802394392u, 0, TANH_TOLERANCE, 0},
{ 463, 3215791332u, 2871645739u, 3239081581u, 1440249115u, 3215789285u, 2945497557u, 0, TANH_TOLERANCE, 0},
{ 464, 1072544937u, 1231934926u, 3236746788u, 603977748u, 1072127558u, 148852321u, 0, TANH_TOLERANCE, 0},
{ 465, 3214324057u, 2386312545u, 1063169277u, 2715234268u, 3214323814u, 630831394u, 0, TANH_TOLERANCE, 0},
{ 466, 1077317658u, 915867083u, 1046790892u, 3347417612u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 467, 1081866940u, 3553288373u, 1065698616u, 2906680663u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 468, 1066477746u, 2342364630u, 1051356723u, 4019093203u, 1066477641u, 1308319496u, 0, TANH_TOLERANCE, 0},
{ 469, 3216897802u, 2911548084u, 1105282515u, 2476735795u, 3216888883u, 64033488u, 0, TANH_TOLERANCE, 0},
{ 470, 1068298564u, 1836216409u, 1101062307u, 2519592554u, 1068296546u, 2859116598u, 0, TANH_TOLERANCE, 0},
{ 471, 1073323889u, 1235369496u, 3222946447u, 668087854u, 1072529424u, 3194090941u, 0, TANH_TOLERANCE, 0},
{ 472, 3217991780u, 2981820811u, 1059838516u, 2845580478u, 3217954221u, 4200696890u, 0, TANH_TOLERANCE, 0},
{ 473, 3214902934u, 1565550570u, 3217165795u, 4162017137u, 3214902281u, 3653946900u, 0, TANH_TOLERANCE, 0},
{ 474, 3224668466u, 2808968027u, 1055630096u, 1782326814u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 475, 1069305614u, 1492622658u, 3216653077u, 3972512122u, 1069298089u, 134736289u, 0, TANH_TOLERANCE, 0},
{ 476, 3222171679u, 2722693603u, 3227814791u, 3169731970u, 3220174817u, 3531603680u, 0, TANH_TOLERANCE, 0},
{ 477, 3221052359u, 899763203u, 3207606001u, 2804747833u, 3220072675u, 2906226549u, 0, TANH_TOLERANCE, 0},
{ 478, 3223330293u, 3789058912u, 3228095081u, 4135937628u, 3220176895u, 2491612513u, 0, TANH_TOLERANCE, 0},
{ 479, 1069636566u, 1682808307u, 3206960335u, 232877759u, 1069629643u, 583610000u, 0, TANH_TOLERANCE, 0},
{ 480, 3226362846u, 2851963139u, 3246852961u, 2590862592u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 481, 1074908950u, 2422232642u, 3234779662u, 290458310u, 1072692678u, 2454695928u, 0, TANH_TOLERANCE, 0},
{ 482, 3219059686u, 1082582386u, 1075605675u, 2602133689u, 3218915044u, 2576723185u, 0, TANH_TOLERANCE, 0},
{ 483, 3226187123u, 1789635787u, 1059414278u, 1048286093u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 484, 1079456174u, 231339448u, 1055573265u, 504907415u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 485, 1071600069u, 1153251200u, 3204617090u, 1772013857u, 1071450530u, 982900350u, 0, TANH_TOLERANCE, 0},
{ 486, 1080676687u, 1082898276u, 3212089272u, 1449080862u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 487, 1076571101u, 3177299045u, 1058862813u, 809400815u, 1072693247u, 4294938769u, 0, TANH_TOLERANCE, 0},
{ 488, 3223514518u, 1924429710u, 1056464743u, 3349283177u, 3220176895u, 4186509591u, 0, TANH_TOLERANCE, 0},
{ 489, 3226599023u, 42238036u, 1042379500u, 2113559863u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 490, 1071052699u, 3304403230u, 3217556703u, 58952646u, 1070991249u, 3007091220u, 0, TANH_TOLERANCE, 0},
{ 491, 3218960986u, 1645486982u, 3224301095u, 3636267471u, 3218835429u, 1446891056u, 0, TANH_TOLERANCE, 0},
{ 492, 1071150617u, 619402181u, 3235208235u, 557360557u, 1071076862u, 548691099u, 0, TANH_TOLERANCE, 0},
{ 493, 3225655482u, 110029735u, 1046937383u, 984375729u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 494, 3213613986u, 4063688092u, 3203235744u, 1049950343u, 3213613874u, 1513497013u, 0, TANH_TOLERANCE, 0},
{ 495, 1070739227u, 650996069u, 1054971928u, 3953359826u, 1070708162u, 851578057u, 0, TANH_TOLERANCE, 0},
{ 496, 3222861501u, 66926332u, 1090561839u, 1379780888u, 3220176880u, 360882482u, 0, TANH_TOLERANCE, 0},
{ 497, 3224016123u, 2803378256u, 1086057989u, 498534626u, 3220176895u, 4294915866u, 0, TANH_TOLERANCE, 0},
{ 498, 1076327097u, 2846400785u, 1047142525u, 1375153550u, 1072693247u, 4293786378u, 0, TANH_TOLERANCE, 0},
{ 499, 1066601297u, 2869128958u, 1070972315u, 4246440273u, 1066601153u, 3402349456u, 0, TANH_TOLERANCE, 0},
{ 500, 1067561146u, 3112381207u, 1044430965u, 3981604561u, 1067560685u, 2566534493u, 0, TANH_TOLERANCE, 0},
{ 501, 3223914965u, 243303420u, 1093735824u, 1575581926u, 3220176895u, 4294726540u, 0, TANH_TOLERANCE, 0},
{ 502, 3225506509u, 3218865041u, 3204803496u, 3840388050u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 503, 1067289799u, 336846959u, 1052664471u, 3798336786u, 1067289261u, 2993180106u, 0, TANH_TOLERANCE, 0},
{ 504, 1068537148u, 3639240976u, 1081202165u, 1844741676u, 1068535631u, 1373601135u, 0, TANH_TOLERANCE, 0},
{ 505, 3218196249u, 717293069u, 3211534283u, 582401011u, 3218167180u, 496380559u, 0, TANH_TOLERANCE, 0},
{ 506, 3228893840u, 3766248610u, 3196520332u, 1174437546u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 507, 1076091194u, 756959182u, 3204099341u, 1581804034u, 1072693247u, 4251765017u, 0, TANH_TOLERANCE, 0},
{ 508, 3217340780u, 3560686300u, 3220980617u, 4277975772u, 3217329035u, 3938865978u, 0, TANH_TOLERANCE, 0},
{ 509, 3218294684u, 2598148853u, 3217622194u, 3460421008u, 3218257801u, 3777429081u, 0, TANH_TOLERANCE, 0},
{ 510, 1071963704u, 136600515u, 3209934920u, 3340653128u, 1071797973u, 383375267u, 0, TANH_TOLERANCE, 0},
{ 511, 1078994518u, 1045480938u, 3251354609u, 4133432965u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 512, 1077967943u, 1630207738u, 3239996829u, 2393354808u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 513, 3213694690u, 3739770117u, 1059520750u, 3959551225u, 3213694562u, 2906185574u, 0, TANH_TOLERANCE, 0},
{ 514, 3223390473u, 1498861716u, 1091297147u, 847410798u, 3220176895u, 3575048625u, 0, TANH_TOLERANCE, 0},
{ 515, 1073516688u, 983275314u, 3232538664u, 2244973629u, 1072578453u, 1729614224u, 0, TANH_TOLERANCE, 0},
{ 516, 1069529329u, 2353103845u, 3235718771u, 2978889966u, 1069518753u, 2585637409u, 0, TANH_TOLERANCE, 0},
{ 517, 3229337896u, 1546972125u, 3249076079u, 1987349196u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 518, 3225636601u, 2769161072u, 1075207126u, 292616282u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 519, 3215440938u, 36855311u, 1052128202u, 1479039342u, 3215439824u, 3021602545u, 0, TANH_TOLERANCE, 0},
{ 520, 1076417021u, 2027463605u, 1066023013u, 3369686340u, 1072693247u, 4294667855u, 0, TANH_TOLERANCE, 0},
{ 521, 3215678541u, 3808681655u, 1054161346u, 1821773119u, 3215676836u, 4252330285u, 0, TANH_TOLERANCE, 0},
{ 522, 1065851752u, 3175490326u, 3226879970u, 845687760u, 1065851684u, 952657342u, 0, TANH_TOLERANCE, 0},
{ 523, 1065371665u, 3124482451u, 3242748377u, 3259417226u, 1065371643u, 1068152155u, 0, TANH_TOLERANCE, 0},
{ 524, 1067265791u, 2751606436u, 3236210939u, 3923142740u, 1067265273u, 4267448991u, 0, TANH_TOLERANCE, 0},
{ 525, 1079966097u, 2016872044u, 3228408064u, 4201274408u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 526, 3215077894u, 1019916843u, 3219974785u, 1977881787u, 3215077392u, 2106531914u, 0, TANH_TOLERANCE, 0},
{ 527, 3215207392u, 2060433318u, 1075872515u, 366073725u, 3215206708u, 4083368175u, 0, TANH_TOLERANCE, 0},
{ 528, 3213200653u, 1098469906u, 1082900695u, 2349346832u, 3213200601u, 543684019u, 0, TANH_TOLERANCE, 0},
{ 529, 3218363315u, 3011196295u, 3252479932u, 2459281672u, 3218320258u, 2654661612u, 0, TANH_TOLERANCE, 0},
{ 530, 3221334323u, 2843222682u, 1089275809u, 298982001u, 3220126785u, 2833806156u, 0, TANH_TOLERANCE, 0},
{ 531, 1080766178u, 914741728u, 3203468059u, 2833809843u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 532, 3225229542u, 1274901962u, 3241535845u, 3759113509u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 533, 3227042074u, 2134927252u, 3253802671u, 3013731444u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 534, 1080326973u, 2230655177u, 3254510616u, 1249674366u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 535, 1071359861u, 717357389u, 1083533731u, 3746683362u, 1071254900u, 3631908499u, 0, TANH_TOLERANCE, 0},
{ 536, 3220064570u, 834976849u, 3217357661u, 2465861779u, 3219627791u, 2471657761u, 0, TANH_TOLERANCE, 0},
{ 537, 1066627637u, 1385714428u, 1053358395u, 3007113740u, 1066627484u, 622695525u, 0, TANH_TOLERANCE, 0},
{ 538, 1068353711u, 599268545u, 3201368210u, 2309854744u, 1068351512u, 1648394891u, 0, TANH_TOLERANCE, 0},
{ 539, 1073100182u, 2840234388u, 3232496515u, 333365983u, 1072447353u, 2876664628u, 0, TANH_TOLERANCE, 0},
{ 540, 1066894301u, 3136078996u, 3194520860u, 2650572904u, 1066894030u, 3836763203u, 0, TANH_TOLERANCE, 0},
{ 541, 3224250507u, 2405805086u, 3251640319u, 324233833u, 3220176895u, 4294965857u, 0, TANH_TOLERANCE, 0},
{ 542, 1081533322u, 2589598340u, 3254677807u, 952438812u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 543, 3213232021u, 1922837702u, 3216892718u, 3535907549u, 3213231965u, 3296837648u, 0, TANH_TOLERANCE, 0},
{ 544, 3226838652u, 261447440u, 3209805849u, 1150571079u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 545, 1079028016u, 4026487528u, 1073152064u, 27340691u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 546, 3222832236u, 338765118u, 1086225786u, 3207238249u, 3220176876u, 440058419u, 0, TANH_TOLERANCE, 0},
{ 547, 3215057071u, 1085283176u, 3187775111u, 1601194210u, 3215056595u, 1400160228u, 0, TANH_TOLERANCE, 0},
{ 548, 1078937261u, 3031712790u, 3252307859u, 170666844u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 549, 3220959383u, 3148395674u, 1041913758u, 3306391490u, 3220053050u, 2562078751u, 0, TANH_TOLERANCE, 0},
{ 550, 3217005710u, 2205233857u, 3208100078u, 3993195511u, 3216995244u, 2747014119u, 0, TANH_TOLERANCE, 0},
{ 551, 1071893912u, 4282766727u, 1072820377u, 1874778218u, 1071750211u, 660651612u, 0, TANH_TOLERANCE, 0},
{ 552, 3218173124u, 2920860798u, 3218070226u, 3104066154u, 3218145720u, 693930883u, 0, TANH_TOLERANCE, 0},
{ 553, 3217533263u, 969991373u, 3250596895u, 1734386152u, 3217515838u, 2631270782u, 0, TANH_TOLERANCE, 0},
{ 554, 3226332906u, 1218740205u, 3239802737u, 2610078504u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 555, 3217565578u, 1485218325u, 3220870240u, 3591664613u, 3217547052u, 140249651u, 0, TANH_TOLERANCE, 0},
{ 556, 3216754207u, 690157417u, 3190850619u, 4192347699u, 3216747099u, 499816119u, 0, TANH_TOLERANCE, 0},
{ 557, 1079276594u, 4009839784u, 1079670252u, 394167192u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 558, 3225122053u, 961532417u, 1092588071u, 2923790239u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 559, 3216462003u, 4174125604u, 1050682630u, 2169701868u, 3216457793u, 919186931u, 0, TANH_TOLERANCE, 0},
{ 560, 3227363835u, 4146748230u, 1087373950u, 2481478351u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 561, 1073842138u, 3984715440u, 1050421618u, 2446142566u, 1072641499u, 1791854957u, 0, TANH_TOLERANCE, 0},
{ 562, 1076832374u, 936290150u, 1100614426u, 3625806370u, 1072693247u, 4294966767u, 0, TANH_TOLERANCE, 0},
{ 563, 1080913584u, 1866615265u, 3215651428u, 2337013350u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 564, 3229081054u, 712227971u, 1106004723u, 973148499u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 565, 3223796743u, 3409813738u, 3244817008u, 1933503498u, 3220176895u, 4293505094u, 0, TANH_TOLERANCE, 0},
{ 566, 1075749429u, 3180389060u, 3228735703u, 83422217u, 1072693247u, 280657473u, 0, TANH_TOLERANCE, 0},
{ 567, 1074732996u, 556972671u, 3204582372u, 841555801u, 1072691497u, 1078894527u, 0, TANH_TOLERANCE, 0},
{ 568, 1072864873u, 4189151332u, 1080874032u, 706326922u, 1072320445u, 3126467056u, 0, TANH_TOLERANCE, 0},
{ 569, 1079374091u, 198291836u, 1057281892u, 2188836928u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 570, 1074946267u, 1219449298u, 3228734687u, 3504562743u, 1072692819u, 2750855966u, 0, TANH_TOLERANCE, 0},
{ 571, 3217153376u, 1776099219u, 1094316777u, 4188083896u, 3217145833u, 645707833u, 0, TANH_TOLERANCE, 0},
{ 572, 3214817228u, 2614400266u, 1073750227u, 3003203347u, 3214816653u, 4118899096u, 0, TANH_TOLERANCE, 0},
{ 573, 3219225558u, 2959351406u, 1105603716u, 311851587u, 3219119060u, 3153940070u, 0, TANH_TOLERANCE, 0},
{ 574, 1076155826u, 865443613u, 1097532516u, 3622237781u, 1072693247u, 4278853323u, 0, TANH_TOLERANCE, 0},
{ 575, 3223398058u, 447506102u, 3195759295u, 3603669725u, 3220176895u, 3653727122u, 0, TANH_TOLERANCE, 0},
{ 576, 1079015805u, 3934398273u, 1040996422u, 2968621268u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 577, 3215614193u, 784208771u, 1088764788u, 2182296421u, 3215612665u, 879108182u, 0, TANH_TOLERANCE, 0},
{ 578, 3228409347u, 1527590526u, 3206961556u, 2823164069u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 579, 3225109795u, 3876699591u, 3207481130u, 4028148535u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 580, 1076236154u, 2164249756u, 1059857743u, 1785169952u, 1072693247u, 4290237064u, 0, TANH_TOLERANCE, 0},
{ 581, 1078172521u, 2079273665u, 1080303860u, 625760474u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 582, 3222291804u, 3636214836u, 1068367620u, 2932621925u, 3220175667u, 2559685817u, 0, TANH_TOLERANCE, 0},
{ 583, 1066015468u, 4274131512u, 1047707755u, 92550763u, 1066015376u, 1477695260u, 0, TANH_TOLERANCE, 0},
{ 584, 3215599337u, 2648933384u, 1084603503u, 3534304873u, 3215597848u, 2856479001u, 0, TANH_TOLERANCE, 0},
{ 585, 1070854691u, 3216750767u, 3191088629u, 547482628u, 1070813952u, 2964537256u, 0, TANH_TOLERANCE, 0},
{ 586, 1070521958u, 1420360746u, 1080063101u, 1690029499u, 1070483630u, 3376375773u, 0, TANH_TOLERANCE, 0},
{ 587, 3223563908u, 1908572179u, 1080112083u, 1228319033u, 3220176895u, 4243921216u, 0, TANH_TOLERANCE, 0},
{ 588, 1067032546u, 500312015u, 3212368508u, 3864619086u, 1067032195u, 2888994469u, 0, TANH_TOLERANCE, 0},
{ 589, 3221335610u, 4211343447u, 1087492676u, 4272583781u, 3220127028u, 929411503u, 0, TANH_TOLERANCE, 0},
{ 590, 1080518026u, 2382118000u, 1042665328u, 567154882u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 591, 1069547778u, 1435344339u, 3216303171u, 2275988178u, 1069537173u, 3641349188u, 0, TANH_TOLERANCE, 0},
{ 592, 3219781499u, 3403659753u, 3218043030u, 1926480488u, 3219485664u, 1805105515u, 0, TANH_TOLERANCE, 0},
{ 593, 1074743231u, 1198845185u, 3225556149u, 1130089684u, 1072691564u, 1130724028u, 0, TANH_TOLERANCE, 0},
{ 594, 3221614466u, 2183928090u, 1048403956u, 963834821u, 3220159548u, 2632844817u, 0, TANH_TOLERANCE, 0},
{ 595, 1080701440u, 2120625396u, 1041006976u, 2137548527u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 596, 1080355870u, 586700956u, 1059670521u, 303891699u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 597, 3221091650u, 2509132460u, 1102827530u, 2205707903u, 3220080026u, 3892042078u, 0, TANH_TOLERANCE, 0},
{ 598, 3217443509u, 1229308263u, 3209170414u, 4206576047u, 3217428916u, 1972214507u, 0, TANH_TOLERANCE, 0},
{ 599, 3221979137u, 4078010749u, 3199236456u, 733478972u, 3220172566u, 2325284033u, 0, TANH_TOLERANCE, 0},
{ 600, 3215538376u, 4277541051u, 3199806921u, 397102023u, 3215537041u, 1038730987u, 0, TANH_TOLERANCE, 0},
{ 601, 3214849381u, 900999594u, 3234720188u, 2530214248u, 3214848778u, 517726932u, 0, TANH_TOLERANCE, 0},
{ 602, 1074446396u, 4000609478u, 1096577064u, 4148592328u, 1072688027u, 4126215607u, 0, TANH_TOLERANCE, 0},
{ 603, 1067542452u, 2154187873u, 3224392607u, 3957250362u, 1067542013u, 1359750955u, 0, TANH_TOLERANCE, 0},
{ 604, 3221316336u, 2867079200u, 1101870326u, 921212001u, 3220123272u, 596464385u, 0, TANH_TOLERANCE, 0},
{ 605, 3223784706u, 674547716u, 1063216239u, 3929755226u, 3220176895u, 4293210269u, 0, TANH_TOLERANCE, 0},
{ 606, 3225735787u, 3158182449u, 1043794244u, 3259056345u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 607, 3225242320u, 3002823940u, 1059511739u, 2832435794u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 608, 3220450550u, 2196511929u, 1049973941u, 3672092877u, 3219865119u, 1534045465u, 0, TANH_TOLERANCE, 0},
{ 609, 1068263848u, 3655292191u, 1086438127u, 3567072906u, 1068261939u, 3330397833u, 0, TANH_TOLERANCE, 0},
{ 610, 3227458308u, 1617573614u, 3201863123u, 3090723732u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 611, 3223764196u, 679893506u, 3211547753u, 824081024u, 3220176895u, 4292564626u, 0, TANH_TOLERANCE, 0},
{ 612, 1076947613u, 2285242807u, 1084999409u, 2221731406u, 1072693247u, 4294967260u, 0, TANH_TOLERANCE, 0},
{ 613, 3217219424u, 1935990727u, 1088822246u, 1058156518u, 3217210539u, 673583441u, 0, TANH_TOLERANCE, 0},
{ 614, 1080819070u, 521023584u, 1059186903u, 4245163857u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 615, 1081871044u, 2312887617u, 3191771354u, 1885370807u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 616, 3228836567u, 1796441468u, 1100030327u, 2772711004u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 617, 3216859732u, 2095685003u, 1077984448u, 2100773742u, 3216851319u, 3546547663u, 0, TANH_TOLERANCE, 0},
{ 618, 3213926140u, 2892538035u, 1042396334u, 4162200338u, 3213926045u, 98121596u, 0, TANH_TOLERANCE, 0},
{ 619, 3226997111u, 2177698116u, 3227557177u, 150832500u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 620, 3213582312u, 607966734u, 3236250630u, 4164600559u, 3213582205u, 1317441634u, 0, TANH_TOLERANCE, 0},
{ 621, 3219535540u, 2830122967u, 1046096700u, 3713346883u, 3219339417u, 3473358335u, 0, TANH_TOLERANCE, 0},
{ 622, 3224615051u, 2314640506u, 3203696416u, 3276228872u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 623, 3219203763u, 469331883u, 3249037349u, 2999233437u, 3219086102u, 85688925u, 0, TANH_TOLERANCE, 0},
{ 624, 1079556219u, 560886625u, 1091899487u, 748795120u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 625, 1067712650u, 2958421324u, 1092569414u, 3235243477u, 1067711984u, 933574582u, 0, TANH_TOLERANCE, 0},
{ 626, 3213998017u, 3221475559u, 1043038304u, 915608434u, 3213997901u, 3819757689u, 0, TANH_TOLERANCE, 0},
{ 627, 1073294682u, 3007808652u, 3216682290u, 2531019474u, 1072520426u, 1456133354u, 0, TANH_TOLERANCE, 0},
{ 628, 3226300359u, 1767658578u, 3237045269u, 2313128318u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 629, 3219006500u, 1926845182u, 1066835624u, 1783256828u, 3218872347u, 1882092066u, 0, TANH_TOLERANCE, 0},
{ 630, 1065741453u, 90378038u, 1057168870u, 164358218u, 1065741398u, 591806547u, 0, TANH_TOLERANCE, 0},
{ 631, 1081693348u, 1610524680u, 1085283851u, 2903496007u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 632, 1075489858u, 4274321404u, 3202913591u, 720121831u, 1072693241u, 979506729u, 0, TANH_TOLERANCE, 0},
{ 633, 1067982472u, 2034778236u, 1071133763u, 1413236391u, 1067981304u, 1075351172u, 0, TANH_TOLERANCE, 0},
{ 634, 1067840244u, 1489112261u, 1076691395u, 348210906u, 1067839363u, 3489382366u, 0, TANH_TOLERANCE, 0},
{ 635, 3217229677u, 2797651324u, 3224410527u, 2374818327u, 3217220570u, 3663838511u, 0, TANH_TOLERANCE, 0},
{ 636, 1077801496u, 1823161666u, 3197810695u, 3119680047u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 637, 1072218792u, 3420950657u, 1087084743u, 2136638961u, 1071957381u, 4227318367u, 0, TANH_TOLERANCE, 0},
{ 638, 1073047952u, 3554566429u, 1062907717u, 2736702589u, 1072423253u, 3954224834u, 0, TANH_TOLERANCE, 0},
{ 639, 3227062875u, 2928437580u, 3187765027u, 1393427873u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 640, 3218738745u, 189447067u, 1051643315u, 828663513u, 3218650265u, 2565529360u, 0, TANH_TOLERANCE, 0},
{ 641, 1068042509u, 2852350928u, 1045683757u, 673354280u, 1068041203u, 1273807154u, 0, TANH_TOLERANCE, 0},
{ 642, 1065966397u, 3589563265u, 3248741629u, 812657927u, 1065966312u, 3995661865u, 0, TANH_TOLERANCE, 0},
{ 643, 3213679498u, 1766416701u, 1100392103u, 2185373290u, 3213679373u, 1105851242u, 0, TANH_TOLERANCE, 0},
{ 644, 3220275389u, 3763582673u, 3191965790u, 388374829u, 3219753918u, 630121662u, 0, TANH_TOLERANCE, 0},
{ 645, 1075440832u, 1187403069u, 1075300235u, 336640304u, 1072693238u, 671323862u, 0, TANH_TOLERANCE, 0},
{ 646, 1081906155u, 1718795752u, 3243118752u, 683369237u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 647, 3218132129u, 1863545307u, 1069449477u, 3418627399u, 3218107521u, 2978760047u, 0, TANH_TOLERANCE, 0},
{ 648, 1072747022u, 3295607249u, 1068878592u, 1633297809u, 1072236708u, 1219129914u, 0, TANH_TOLERANCE, 0},
{ 649, 1070481463u, 2585980994u, 3236670483u, 1286750688u, 1070445359u, 1671965836u, 0, TANH_TOLERANCE, 0},
{ 650, 1067128553u, 15816845u, 3233249283u, 2491924775u, 1067128138u, 4149105436u, 0, TANH_TOLERANCE, 0},
{ 651, 1065481693u, 1051983351u, 1049180786u, 1474421917u, 1065481663u, 304342688u, 0, TANH_TOLERANCE, 0},
{ 652, 3216978165u, 2003816032u, 1086050104u, 668090487u, 3216968109u, 3936271285u, 0, TANH_TOLERANCE, 0},
{ 653, 1068284677u, 3671484625u, 1067020039u, 430024694u, 1068282704u, 213223715u, 0, TANH_TOLERANCE, 0},
{ 654, 1072639990u, 3991830201u, 3207808714u, 1021245839u, 1072170471u, 4236962281u, 0, TANH_TOLERANCE, 0},
{ 655, 1071534423u, 4255801807u, 3207681716u, 1926756877u, 1071398029u, 3730360966u, 0, TANH_TOLERANCE, 0},
{ 656, 1067869425u, 4167786896u, 1077097744u, 1775517981u, 1067868490u, 3350202937u, 0, TANH_TOLERANCE, 0},
{ 657, 1076164794u, 3187518564u, 1082437406u, 944672491u, 1072693247u, 4280914270u, 0, TANH_TOLERANCE, 0},
{ 658, 1068240650u, 953085192u, 3227310828u, 3459155777u, 1068238811u, 2397589293u, 0, TANH_TOLERANCE, 0},
{ 659, 1072648234u, 1908555460u, 1073640207u, 260441967u, 1072174059u, 6166727u, 0, TANH_TOLERANCE, 0},
{ 660, 1072462486u, 250762477u, 1072582645u, 2886742039u, 1072087959u, 2719323898u, 0, TANH_TOLERANCE, 0},
{ 661, 3228885910u, 786180031u, 3197734769u, 2788918312u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 662, 3225074643u, 2055912467u, 3244244909u, 1394142937u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 663, 1072758713u, 91984146u, 3222252812u, 4126276047u, 1072245701u, 402520945u, 0, TANH_TOLERANCE, 0},
{ 664, 1075048683u, 3942715706u, 3239316352u, 410676547u, 1072693051u, 3851512815u, 0, TANH_TOLERANCE, 0},
{ 665, 3215335062u, 86296211u, 1085850694u, 649202596u, 3215334160u, 3540055039u, 0, TANH_TOLERANCE, 0},
{ 666, 3226492024u, 3069064472u, 3237358008u, 23209276u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 667, 1074943832u, 1867297860u, 1072956607u, 2513414118u, 1072692811u, 2618045138u, 0, TANH_TOLERANCE, 0},
{ 668, 3228513251u, 3171788768u, 3235208783u, 162138697u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 669, 1075436999u, 1245110700u, 1081653954u, 2584994077u, 1072693237u, 3711677726u, 0, TANH_TOLERANCE, 0},
{ 670, 3226635752u, 3347226587u, 1058962932u, 2291943376u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 671, 1070433398u, 966940828u, 1060726420u, 2798041096u, 1070399821u, 3118560199u, 0, TANH_TOLERANCE, 0},
{ 672, 1072793759u, 2487340727u, 3223786370u, 4105954991u, 1072271731u, 2389258654u, 0, TANH_TOLERANCE, 0},
{ 673, 3228193553u, 1671039260u, 1086395032u, 3745833360u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 674, 1069661709u, 651714217u, 1047070645u, 2130549237u, 1069654319u, 221802056u, 0, TANH_TOLERANCE, 0},
{ 675, 3217601491u, 1423000172u, 3247822717u, 1551488170u, 3217581688u, 181509837u, 0, TANH_TOLERANCE, 0},
{ 676, 3216277371u, 921077236u, 3213332351u, 1431049019u, 3216274507u, 3009781141u, 0, TANH_TOLERANCE, 0},
{ 677, 1071704599u, 655715547u, 3190985373u, 1527556471u, 1071578785u, 2205486276u, 0, TANH_TOLERANCE, 0},
{ 678, 3222412099u, 4110878657u, 3251297180u, 879739345u, 3220176405u, 1214346782u, 0, TANH_TOLERANCE, 0},
{ 679, 1076367578u, 2623955764u, 1093699897u, 1216444475u, 1072693247u, 4294330559u, 0, TANH_TOLERANCE, 0},
{ 680, 1078274115u, 107442539u, 3239767031u, 1149813329u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 681, 3224008056u, 1761361082u, 3226030205u, 1121849716u, 3220176895u, 4294909129u, 0, TANH_TOLERANCE, 0},
{ 682, 3226455627u, 2534144722u, 1044223733u, 3512285706u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 683, 3218137533u, 4073670723u, 1050729852u, 3034818849u, 3218112568u, 2667121844u, 0, TANH_TOLERANCE, 0},
{ 684, 1081013054u, 1421423503u, 1060278048u, 1397153092u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 685, 3220567557u, 1649206019u, 1104525577u, 1267104290u, 3219923717u, 2769521020u, 0, TANH_TOLERANCE, 0},
{ 686, 3213419345u, 3775270392u, 1040251850u, 68667319u, 3213419265u, 2545621795u, 0, TANH_TOLERANCE, 0},
{ 687, 3216913812u, 3099226694u, 3254103006u, 4020102648u, 3216904673u, 4012492726u, 0, TANH_TOLERANCE, 0},
{ 688, 3216271776u, 3718441177u, 3215643451u, 4032951536u, 3216268948u, 3943411919u, 0, TANH_TOLERANCE, 0},
{ 689, 1066151467u, 508048351u, 3210196713u, 1707937896u, 1066151350u, 2449381217u, 0, TANH_TOLERANCE, 0},
{ 690, 3215388843u, 2784738160u, 1073435430u, 1109346010u, 3215387838u, 1879123550u, 0, TANH_TOLERANCE, 0},
{ 691, 3222579562u, 3331916473u, 3238794568u, 2707019594u, 3220176759u, 980840063u, 0, TANH_TOLERANCE, 0},
{ 692, 1078502606u, 3093165197u, 1072894805u, 2853215019u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 693, 3219727867u, 2135797997u, 1048399559u, 2941926126u, 3219455627u, 2769844582u, 0, TANH_TOLERANCE, 0},
{ 694, 1067305348u, 2083412145u, 3249335391u, 507212448u, 1067304798u, 248712640u, 0, TANH_TOLERANCE, 0},
{ 695, 1074315175u, 4270176401u, 3246546709u, 3288753319u, 1072684643u, 2903274486u, 0, TANH_TOLERANCE, 0},
{ 696, 3228009919u, 3692175292u, 3197271515u, 3989064196u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 697, 3228623066u, 3111924274u, 1066772558u, 59281695u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 698, 1071878215u, 2135245466u, 3208804313u, 3846547392u, 1071739222u, 3014085290u, 0, TANH_TOLERANCE, 0},
{ 699, 1079149171u, 972051266u, 3222814246u, 3539700586u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 700, 3216597418u, 330951080u, 1079189813u, 583922384u, 3216591988u, 4271149752u, 0, TANH_TOLERANCE, 0},
{ 701, 1077057180u, 1711944085u, 1104170032u, 643991456u, 1072693247u, 4294967295u, 0, TANH_TOLERANCE, 0},
{ 702, 3224992365u, 2072550721u, 3250147641u, 4280263530u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 703, 3213944226u, 1566376352u, 1067251433u, 72984588u, 3213944125u, 3738816808u, 0, TANH_TOLERANCE, 0},
{ 704, 1079547929u, 3103043079u, 1045853123u, 410067497u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 705, 3219818221u, 1910366299u, 1081770885u, 634683073u, 3219505645u, 2911026815u, 0, TANH_TOLERANCE, 0},
{ 706, 1075239232u, 2226525875u, 3224149290u, 2126302825u, 1072693202u, 736485286u, 0, TANH_TOLERANCE, 0},
{ 707, 1073150247u, 1383818978u, 3193885723u, 1220372650u, 1072468548u, 1453165635u, 0, TANH_TOLERANCE, 0},
{ 708, 1071725823u, 1953339096u, 1077176252u, 1476516558u, 1071611118u, 3094019794u, 0, TANH_TOLERANCE, 0},
{ 709, 1072383456u, 1306277326u, 1079089150u, 4093716191u, 1072047867u, 2345709570u, 0, TANH_TOLERANCE, 0},
{ 710, 3223711603u, 51750045u, 3242913901u, 4256866157u, 3220176895u, 4289606629u, 0, TANH_TOLERANCE, 0},
{ 711, 3213959335u, 2163853087u, 3232053146u, 2962422808u, 3213959230u, 3607978116u, 0, TANH_TOLERANCE, 0},
{ 712, 1074468369u, 1618388148u, 3233154824u, 3711953164u, 1072688447u, 772390444u, 0, TANH_TOLERANCE, 0},
{ 713, 3227993634u, 357108214u, 3202294604u, 2306775262u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 714, 3216584150u, 2571356437u, 3249064063u, 2394851808u, 3216578850u, 265180082u, 0, TANH_TOLERANCE, 0},
{ 715, 3224196635u, 4273880094u, 1103698617u, 3578832032u, 3220176895u, 4294964023u, 0, TANH_TOLERANCE, 0},
{ 716, 3223989517u, 2091068742u, 3228270226u, 3980489730u, 3220176895u, 4294890111u, 0, TANH_TOLERANCE, 0},
{ 717, 3222725296u, 2772307714u, 1051008486u, 32546576u, 3220176851u, 36562416u, 0, TANH_TOLERANCE, 0},
{ 718, 3225500575u, 2143788498u, 3195498043u, 3630119231u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 719, 3215410151u, 2527385594u, 3240503648u, 3482095012u, 3215409103u, 223410783u, 0, TANH_TOLERANCE, 0},
{ 720, 3226440159u, 2690097362u, 1068598730u, 2360266862u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 721, 1070392205u, 2673272949u, 1082639557u, 522449749u, 1070360701u, 382258917u, 0, TANH_TOLERANCE, 0},
{ 722, 1081355475u, 3596379400u, 3242016775u, 2002293002u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 723, 1080565288u, 4113224369u, 3222122439u, 2152316893u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 724, 3220796716u, 31662602u, 1047721249u, 1747087514u, 3220009792u, 1786415707u, 0, TANH_TOLERANCE, 0},
{ 725, 3228443661u, 2489659568u, 1097051253u, 277506957u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 726, 3213421930u, 3850162281u, 3213841942u, 438724093u, 3213421850u, 978459012u, 0, TANH_TOLERANCE, 0},
{ 727, 1079663895u, 2431814052u, 1075518084u, 2672434118u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 728, 3227434095u, 391606792u, 1048184750u, 4168944276u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 729, 3227869472u, 457529672u, 3201090276u, 72407935u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 730, 3220817871u, 3954981400u, 1052053242u, 2411049585u, 3220016147u, 3511268541u, 0, TANH_TOLERANCE, 0},
{ 731, 1076742907u, 485456950u, 1088415093u, 1655397424u, 1072693247u, 4294965222u, 0, TANH_TOLERANCE, 0},
{ 732, 3215011644u, 1551748070u, 3236871640u, 1329701152u, 3215011221u, 2829038109u, 0, TANH_TOLERANCE, 0},
{ 733, 3221493394u, 3099222537u, 1104984570u, 4293792842u, 3220149432u, 808086103u, 0, TANH_TOLERANCE, 0},
{ 734, 3216532617u, 3603065260u, 3197735968u, 2402359253u, 3216527797u, 1764416133u, 0, TANH_TOLERANCE, 0},
{ 735, 3215601800u, 3961208159u, 3219057584u, 2340553876u, 3215600305u, 2344462802u, 0, TANH_TOLERANCE, 0},
{ 736, 1073833333u, 4014841779u, 3197672877u, 3697233334u, 1072639754u, 1246670554u, 0, TANH_TOLERANCE, 0},
{ 737, 3219567113u, 1403876392u, 3254028950u, 921363393u, 3219359416u, 4132459186u, 0, TANH_TOLERANCE, 0},
{ 738, 1082085982u, 1862576361u, 3194031708u, 2476290925u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 739, 1067487560u, 1454212851u, 1088378861u, 3400401866u, 1067487181u, 2318239370u, 0, TANH_TOLERANCE, 0},
{ 740, 1074406809u, 552676385u, 3188635745u, 3778112968u, 1072687178u, 1070255472u, 0, TANH_TOLERANCE, 0},
{ 741, 3219555010u, 1199568671u, 3225679997u, 46947405u, 3219351793u, 2517024871u, 0, TANH_TOLERANCE, 0},
{ 742, 1074539809u, 2596231448u, 3253943728u, 2219151748u, 1072689591u, 1666921402u, 0, TANH_TOLERANCE, 0},
{ 743, 1071769915u, 4119719558u, 3222036299u, 1275474618u, 1071660967u, 2845583729u, 0, TANH_TOLERANCE, 0},
{ 744, 3226277175u, 3347296825u, 1101507910u, 1254014794u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 745, 1076779960u, 673775040u, 1070743626u, 244126093u, 1072693247u, 4294966118u, 0, TANH_TOLERANCE, 0},
{ 746, 3216831338u, 1832066983u, 1051358028u, 3262483417u, 3216823291u, 840194706u, 0, TANH_TOLERANCE, 0},
{ 747, 1074413872u, 3962610501u, 3198598777u, 849269178u, 1072687339u, 1695789171u, 0, TANH_TOLERANCE, 0},
{ 748, 3224988140u, 2497516122u, 3254374111u, 2821429629u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 749, 1074139136u, 2805941787u, 3217785843u, 779131141u, 1072676440u, 1089483228u, 0, TANH_TOLERANCE, 0},
{ 750, 3222714382u, 723423605u, 1084533420u, 627282213u, 3220176847u, 436675031u, 0, TANH_TOLERANCE, 0},
{ 751, 3220141984u, 4292778869u, 1078101071u, 1676860147u, 3219662074u, 436286370u, 0, TANH_TOLERANCE, 0},
{ 752, 1074191350u, 3528118587u, 3194648564u, 2363260897u, 1072679465u, 3158136682u, 0, TANH_TOLERANCE, 0},
{ 753, 3214917975u, 1307010018u, 1061248120u, 1468743108u, 3214917308u, 1887206257u, 0, TANH_TOLERANCE, 0},
{ 754, 3227708771u, 107905661u, 3226089788u, 1943427674u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 755, 3213396365u, 760006940u, 1054265604u, 1749976597u, 3213396288u, 1015782970u, 0, TANH_TOLERANCE, 0},
{ 756, 3225190472u, 2787503556u, 1081282610u, 1195841206u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 757, 3213822252u, 545462045u, 3208381743u, 1981311808u, 3213822096u, 1895015686u, 0, TANH_TOLERANCE, 0},
{ 758, 1070669320u, 3657978397u, 1104463616u, 3501253426u, 1070643315u, 3340057444u, 0, TANH_TOLERANCE, 0},
{ 759, 1067709649u, 1804177501u, 3210693633u, 3606766729u, 1067708987u, 2207822296u, 0, TANH_TOLERANCE, 0},
{ 760, 1074759727u, 1336278526u, 1043741618u, 3165279431u, 1072691666u, 3920633442u, 0, TANH_TOLERANCE, 0},
{ 761, 1069103403u, 1599382075u, 1058018527u, 4212580517u, 1069098074u, 3887268780u, 0, TANH_TOLERANCE, 0},
{ 762, 3217988086u, 3007589929u, 3202026547u, 2792028313u, 3217950731u, 2952417810u, 0, TANH_TOLERANCE, 0},
{ 763, 3228965522u, 1866066996u, 1060329048u, 3727175322u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 764, 3215193859u, 150890940u, 1056025306u, 3082724735u, 3215193196u, 1187099324u, 0, TANH_TOLERANCE, 0},
{ 765, 1071446123u, 80400395u, 1093584426u, 3478941315u, 1071326261u, 48805005u, 0, TANH_TOLERANCE, 0},
{ 766, 3228571942u, 4050954182u, 3219263194u, 2537475930u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 767, 1071133327u, 2881752155u, 3212589299u, 2559651278u, 1071061848u, 3503400932u, 0, TANH_TOLERANCE, 0},
{ 768, 3228044784u, 440309030u, 3214267461u, 3788040806u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 769, 1080553671u, 918813144u, 3208535698u, 1607035904u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 770, 1066254699u, 2497054124u, 1089139147u, 2549609010u, 1066254562u, 1621993583u, 0, TANH_TOLERANCE, 0},
{ 771, 1066960585u, 790219083u, 1054657139u, 2797979479u, 1066960277u, 3785521302u, 0, TANH_TOLERANCE, 0},
{ 772, 1070364312u, 1149462078u, 1095765205u, 3879963182u, 1070334162u, 791933143u, 0, TANH_TOLERANCE, 0},
{ 773, 3216361301u, 2684353926u, 3205212854u, 1732474928u, 3216357868u, 1244044034u, 0, TANH_TOLERANCE, 0},
{ 774, 1079508325u, 2742237025u, 1051317716u, 3386396147u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 775, 1071619594u, 3408320912u, 1103071166u, 4233059513u, 1071466003u, 2250109031u, 0, TANH_TOLERANCE, 0},
{ 776, 1071155004u, 1077495917u, 1088399968u, 433115118u, 1071080664u, 2213941110u, 0, TANH_TOLERANCE, 0},
{ 777, 3217130484u, 841366493u, 1051716814u, 4121125128u, 3217123372u, 2948102763u, 0, TANH_TOLERANCE, 0},
{ 778, 1070923540u, 321857207u, 1089128010u, 1149988239u, 1070876210u, 287366057u, 0, TANH_TOLERANCE, 0},
{ 779, 3226668295u, 799866606u, 3197637091u, 3924438208u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 780, 3213082986u, 2002049816u, 1077053447u, 2240354761u, 3213082946u, 1332721886u, 0, TANH_TOLERANCE, 0},
{ 781, 3222714827u, 478939968u, 1097035749u, 1066716440u, 3220176847u, 1148390538u, 0, TANH_TOLERANCE, 0},
{ 782, 3224085033u, 1653104725u, 1088548129u, 81977716u, 3220176895u, 4294949325u, 0, TANH_TOLERANCE, 0},
{ 783, 3215735644u, 3899475018u, 3189694084u, 3330093036u, 3215733772u, 108014255u, 0, TANH_TOLERANCE, 0},
{ 784, 1077778247u, 2612450289u, 1079065127u, 603380842u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 785, 1080713847u, 3962735564u, 1101570429u, 1372490825u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 786, 1069486080u, 1479841439u, 1059312257u, 541504905u, 1069476148u, 1330025412u, 0, TANH_TOLERANCE, 0},
{ 787, 1075516450u, 2626148789u, 1057571099u, 4121656076u, 1072693242u, 2025230023u, 0, TANH_TOLERANCE, 0},
{ 788, 1075321933u, 1902560314u, 1043130231u, 3557671562u, 1072693223u, 2642910265u, 0, TANH_TOLERANCE, 0},
{ 789, 3214801292u, 41779312u, 1081626342u, 831171823u, 3214800731u, 509784550u, 0, TANH_TOLERANCE, 0},
{ 790, 1069665436u, 1393168821u, 1066457405u, 1381616968u, 1069657975u, 1271360986u, 0, TANH_TOLERANCE, 0},
{ 791, 1073386717u, 3756584649u, 3222267229u, 1423157432u, 1072547282u, 502039030u, 0, TANH_TOLERANCE, 0},
{ 792, 3229269850u, 1894912556u, 1042426694u, 155024547u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 793, 3214327880u, 35164295u, 3203391785u, 1037041084u, 3214327634u, 3083858517u, 0, TANH_TOLERANCE, 0},
{ 794, 1076388871u, 3957875950u, 3232195211u, 1590756436u, 1072693247u, 4294507195u, 0, TANH_TOLERANCE, 0},
{ 795, 1071990050u, 1447585080u, 1071279485u, 1107922438u, 1071815538u, 3161902907u, 0, TANH_TOLERANCE, 0},
{ 796, 1067224038u, 981897615u, 1051856116u, 430357614u, 1067223553u, 3187978985u, 0, TANH_TOLERANCE, 0},
{ 797, 3222281335u, 395145384u, 3219821938u, 50586510u, 3220175565u, 2064559548u, 0, TANH_TOLERANCE, 0},
{ 798, 1072921640u, 750827797u, 1082862669u, 230466783u, 1072355622u, 1074964933u, 0, TANH_TOLERANCE, 0},
{ 799, 1077231635u, 1365083575u, 3204848310u, 1700831722u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 800, 3220187542u, 344241827u, 1071538935u, 2715566077u, 3219685795u, 4089371904u, 0, TANH_TOLERANCE, 0},
{ 801, 3227659912u, 4069301823u, 3193208760u, 2949125229u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 802, 1081211291u, 3585711710u, 1065801594u, 2302229267u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 803, 3214041900u, 709803845u, 1048741487u, 2296910194u, 3214041770u, 2865692980u, 0, TANH_TOLERANCE, 0},
{ 804, 3214252299u, 744421179u, 1069302001u, 2659232829u, 3214252089u, 1383114050u, 0, TANH_TOLERANCE, 0},
{ 805, 1078155904u, 1799949903u, 3192522886u, 4212149209u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 806, 3217642838u, 145234164u, 3250614064u, 912384201u, 3217621494u, 2301037676u, 0, TANH_TOLERANCE, 0},
{ 807, 3225830600u, 2784620507u, 1102812948u, 3531481022u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 808, 3229139567u, 383952592u, 3205659905u, 3633194728u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 809, 3216059164u, 3792395543u, 1070072378u, 3864816376u, 3216057481u, 392473577u, 0, TANH_TOLERANCE, 0},
{ 810, 3217899185u, 2115553675u, 1066288499u, 3538377867u, 3217866517u, 4139851017u, 0, TANH_TOLERANCE, 0},
{ 811, 3229006513u, 1230026762u, 1090719723u, 440819880u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 812, 3214518020u, 2991290482u, 1096886719u, 1097971167u, 3214517669u, 464087563u, 0, TANH_TOLERANCE, 0},
{ 813, 1077465688u, 1098035020u, 3230900504u, 1479059095u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 814, 3229036868u, 1719428427u, 3188631907u, 3707377409u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 815, 1068964805u, 3748932896u, 1084908557u, 1325384361u, 1068960705u, 3897061665u, 0, TANH_TOLERANCE, 0},
{ 816, 1076315468u, 3979168763u, 1057455255u, 2454615952u, 1072693247u, 4293557095u, 0, TANH_TOLERANCE, 0},
{ 817, 1068835624u, 1449164578u, 1056960316u, 1654931641u, 1068832484u, 4023712312u, 0, TANH_TOLERANCE, 0},
{ 818, 1073536162u, 2120487381u, 3226298974u, 2364226633u, 1072582528u, 2771358353u, 0, TANH_TOLERANCE, 0},
{ 819, 1074022852u, 1074268944u, 1065730444u, 280016852u, 1072667115u, 442967526u, 0, TANH_TOLERANCE, 0},
{ 820, 3216036896u, 3315127889u, 3236295594u, 2900924954u, 3216035310u, 3763110972u, 0, TANH_TOLERANCE, 0},
{ 821, 3215300259u, 2246037502u, 1049691002u, 1496066550u, 3215299421u, 2831592142u, 0, TANH_TOLERANCE, 0},
{ 822, 3213978379u, 4191285446u, 3217936236u, 2382392789u, 3213978269u, 3840860417u, 0, TANH_TOLERANCE, 0},
{ 823, 1078153244u, 640099844u, 1042152237u, 2064279383u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 824, 1075719134u, 3468560824u, 1093251038u, 310958750u, 1072693246u, 3531801958u, 0, TANH_TOLERANCE, 0},
{ 825, 1080011184u, 1413568905u, 1100941106u, 1627289946u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 826, 3213569646u, 3797143370u, 3195497539u, 3843275034u, 3213569542u, 1270881281u, 0, TANH_TOLERANCE, 0},
{ 827, 3229008721u, 2806642640u, 3201943068u, 2515980718u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 828, 1077440132u, 632580632u, 1078673506u, 3259601317u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 829, 3216709215u, 3309678799u, 1049337078u, 3056787074u, 3216702620u, 1653632981u, 0, TANH_TOLERANCE, 0},
{ 830, 3221495289u, 2341164249u, 1080834967u, 2810890005u, 3220149628u, 3005879799u, 0, TANH_TOLERANCE, 0},
{ 831, 1072262554u, 932124675u, 1093915797u, 662682630u, 1071982362u, 3057316859u, 0, TANH_TOLERANCE, 0},
{ 832, 3228258571u, 1367996113u, 3251723684u, 2974064663u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 833, 1074987851u, 323437999u, 1090499064u, 901457511u, 1072692936u, 364088582u, 0, TANH_TOLERANCE, 0},
{ 834, 3225293116u, 4184941840u, 3196770014u, 2458988443u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 835, 1077132524u, 2023065054u, 3211994098u, 2734612965u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 836, 1071414726u, 3679267365u, 3237728785u, 1699558211u, 1071300429u, 3732495732u, 0, TANH_TOLERANCE, 0},
{ 837, 1077593250u, 1826799031u, 1078709629u, 3986905229u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 838, 1068572425u, 351061688u, 3194386466u, 4105857588u, 1068570755u, 499330562u, 0, TANH_TOLERANCE, 0},
{ 839, 1068808070u, 1365244058u, 1064457319u, 1452191426u, 1068805114u, 1012629484u, 0, TANH_TOLERANCE, 0},
{ 840, 1071462417u, 2463030625u, 3215975031u, 3773488326u, 1071339602u, 4185089979u, 0, TANH_TOLERANCE, 0},
{ 841, 3229256575u, 752664055u, 1065110394u, 1835931663u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 842, 1077559328u, 3496172149u, 1089617208u, 109068701u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 843, 3215960879u, 1636966254u, 1086098766u, 2016598298u, 3215958236u, 2999409352u, 0, TANH_TOLERANCE, 0},
{ 844, 1067708534u, 3551516956u, 1097969102u, 1317953425u, 1067707874u, 2624410332u, 0, TANH_TOLERANCE, 0},
{ 845, 3223540761u, 2977627788u, 1045339018u, 516058480u, 3220176895u, 4222297914u, 0, TANH_TOLERANCE, 0},
{ 846, 3224825666u, 3901731263u, 3189566462u, 32272932u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 847, 1074136068u, 1956025297u, 3246628529u, 3840733905u, 1072676243u, 765228757u, 0, TANH_TOLERANCE, 0},
{ 848, 1080943668u, 561057891u, 3198494340u, 4271027193u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 849, 3228909825u, 692989850u, 3242630588u, 2492225971u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 850, 3218062309u, 3439913962u, 1067477011u, 2973333638u, 3218020721u, 3960544974u, 0, TANH_TOLERANCE, 0},
{ 851, 3219236869u, 877613377u, 1044917899u, 809672798u, 3219132175u, 1311516534u, 0, TANH_TOLERANCE, 0},
{ 852, 3222171454u, 905426932u, 1046417457u, 1086320855u, 3220174816u, 151676798u, 0, TANH_TOLERANCE, 0},
{ 853, 3227472261u, 2645567288u, 1051258339u, 557182478u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 854, 3216640862u, 186287752u, 1061342054u, 4054003419u, 3216634997u, 2519513944u, 0, TANH_TOLERANCE, 0},
{ 855, 1079440881u, 3506889716u, 3243866036u, 519056371u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 856, 1065722725u, 2171898436u, 3246911982u, 1091500784u, 1065722672u, 3180746426u, 0, TANH_TOLERANCE, 0},
{ 857, 3226870457u, 368493885u, 3222871893u, 1419055230u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 858, 1078319084u, 2010971245u, 3188804530u, 1518695799u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 859, 3218009421u, 1239207795u, 1040192984u, 2199481342u, 3217970879u, 3474753941u, 0, TANH_TOLERANCE, 0},
{ 860, 3218318669u, 4264613432u, 3203460972u, 3558930895u, 3218279698u, 4197303057u, 0, TANH_TOLERANCE, 0},
{ 861, 1068125075u, 3772748958u, 3227667376u, 309688336u, 1068123562u, 1489711826u, 0, TANH_TOLERANCE, 0},
{ 862, 3223403009u, 1077949160u, 1075769893u, 2405271377u, 3220176895u, 3700387119u, 0, TANH_TOLERANCE, 0},
{ 863, 1078203664u, 3751608506u, 3232278094u, 930375071u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 864, 3215394369u, 1518334131u, 3205247482u, 791756713u, 3215393353u, 103206669u, 0, TANH_TOLERANCE, 0},
{ 865, 1067240397u, 2825203170u, 3245054001u, 1822981827u, 1067239900u, 1515673819u, 0, TANH_TOLERANCE, 0},
{ 866, 1080093419u, 514474738u, 1089072073u, 3300845441u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 867, 3219536978u, 247369460u, 3197320093u, 687450958u, 3219340336u, 978352660u, 0, TANH_TOLERANCE, 0},
{ 868, 1081092750u, 2722237629u, 1058272368u, 90602316u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 869, 3217535619u, 1845900544u, 3231520830u, 3389751458u, 3217518115u, 4229139541u, 0, TANH_TOLERANCE, 0},
{ 870, 3227612301u, 737689911u, 3195377751u, 3462616966u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 871, 3221441232u, 3620285831u, 1055501023u, 2708056059u, 3220143434u, 3921561u, 0, TANH_TOLERANCE, 0},
{ 872, 3220513572u, 4073430285u, 1056206159u, 172017902u, 3219898084u, 1973970623u, 0, TANH_TOLERANCE, 0},
{ 873, 3219161094u, 2799176222u, 1052706894u, 4083892667u, 3219020605u, 733511961u, 0, TANH_TOLERANCE, 0},
{ 874, 3216959621u, 1562351330u, 1069705601u, 1247765260u, 3216949835u, 4127746042u, 0, TANH_TOLERANCE, 0},
{ 875, 3224328691u, 51853475u, 3189080201u, 2783553144u, 3220176895u, 4294966860u, 0, TANH_TOLERANCE, 0},
{ 876, 3220502929u, 3851781549u, 3241598113u, 514064046u, 3219892754u, 382488881u, 0, TANH_TOLERANCE, 0},
{ 877, 1080123021u, 934745487u, 3248182437u, 2798581921u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 878, 3219373949u, 2948648757u, 3232177250u, 4278702895u, 3219231339u, 732036294u, 0, TANH_TOLERANCE, 0},
{ 879, 1073534300u, 4259101461u, 1061606772u, 84229920u, 1072582145u, 1140039901u, 0, TANH_TOLERANCE, 0},
{ 880, 3215901351u, 3891230598u, 1095924595u, 3049217547u, 3215898929u, 4061131300u, 0, TANH_TOLERANCE, 0},
{ 881, 1074207325u, 3806018919u, 3243191216u, 280177341u, 1072680278u, 119798727u, 0, TANH_TOLERANCE, 0},
{ 882, 1070061714u, 3900344258u, 1063647809u, 4206745890u, 1070043882u, 4225813589u, 0, TANH_TOLERANCE, 0},
{ 883, 3222464456u, 2126253040u, 3207248026u, 808507485u, 3220176566u, 3729330534u, 0, TANH_TOLERANCE, 0},
{ 884, 1076653133u, 3465685634u, 3230391053u, 3754958214u, 1072693247u, 4294959137u, 0, TANH_TOLERANCE, 0},
{ 885, 1080840988u, 461094531u, 1101110393u, 1316091396u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 886, 1071271770u, 4197635149u, 1091873113u, 1240127141u, 1071180785u, 300469245u, 0, TANH_TOLERANCE, 0},
{ 887, 1074333893u, 118603800u, 1105304898u, 4291425557u, 1072685235u, 2023333141u, 0, TANH_TOLERANCE, 0},
{ 888, 3219720621u, 3744663425u, 3212482771u, 953662066u, 3219451491u, 1728510743u, 0, TANH_TOLERANCE, 0},
{ 889, 1076782697u, 3564196690u, 3228101916u, 904305212u, 1072693247u, 4294966166u, 0, TANH_TOLERANCE, 0},
{ 890, 1067207479u, 3566257266u, 3235138829u, 2734275140u, 1067207008u, 396173854u, 0, TANH_TOLERANCE, 0},
{ 891, 3227171261u, 606044282u, 3241318094u, 2446416887u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 892, 1065744532u, 2336116589u, 3197594053u, 2296925138u, 1065744477u, 1318672729u, 0, TANH_TOLERANCE, 0},
{ 893, 1070101995u, 907670625u, 3240769036u, 1827119006u, 1070082762u, 1452920190u, 0, TANH_TOLERANCE, 0},
{ 894, 1066487279u, 2818710946u, 3246059905u, 553394170u, 1066487171u, 3077210550u, 0, TANH_TOLERANCE, 0},
{ 895, 3213621342u, 4099522736u, 3232742168u, 3718083858u, 3213621228u, 4270652673u, 0, TANH_TOLERANCE, 0},
{ 896, 1078739788u, 1059279404u, 1080245336u, 175941677u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 897, 1082121019u, 1650862428u, 1061816101u, 1723201723u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 898, 3226429902u, 2462163405u, 3218946201u, 3876535372u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 899, 1076004278u, 495844137u, 1073721460u, 772777946u, 1072693247u, 4132231651u, 0, TANH_TOLERANCE, 0},
{ 900, 1068143970u, 458757721u, 3245680321u, 3609892707u, 1068142406u, 1203906592u, 0, TANH_TOLERANCE, 0},
{ 901, 3214254476u, 2533012202u, 1079980803u, 3592268374u, 3214254265u, 3301236168u, 0, TANH_TOLERANCE, 0},
{ 902, 3216996268u, 4108274117u, 1063045844u, 571992389u, 3216985944u, 4098370140u, 0, TANH_TOLERANCE, 0},
{ 903, 1077984359u, 3541110973u, 1096296754u, 3118427427u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 904, 3213902987u, 1213941007u, 1105433735u, 2172963370u, 3213902897u, 2586721683u, 0, TANH_TOLERANCE, 0},
{ 905, 1079027567u, 272190288u, 1095452370u, 4026581530u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 906, 1079855269u, 2843638672u, 1100510986u, 3190536898u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 907, 1076417062u, 2014317727u, 3247389683u, 2428462015u, 1072693247u, 4294668042u, 0, TANH_TOLERANCE, 0},
{ 908, 1078248077u, 688442200u, 1047852515u, 3035186380u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 909, 1074567060u, 1010095511u, 3221288076u, 405287991u, 1072689952u, 558226479u, 0, TANH_TOLERANCE, 0},
{ 910, 3229225943u, 2983070435u, 1089546472u, 2907918480u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 911, 1076696665u, 81928569u, 1056007286u, 2740556321u, 1072693247u, 4294963097u, 0, TANH_TOLERANCE, 0},
{ 912, 1066276691u, 2076689028u, 1081558619u, 3039159031u, 1066276549u, 2514845407u, 0, TANH_TOLERANCE, 0},
{ 913, 1067230382u, 1376882094u, 3211003208u, 1296286481u, 1067229892u, 3821406691u, 0, TANH_TOLERANCE, 0},
{ 914, 1074871434u, 744133164u, 3200943494u, 955832216u, 1072692489u, 3864723433u, 0, TANH_TOLERANCE, 0},
{ 915, 3223144598u, 176522478u, 1069999908u, 2891249491u, 3220176894u, 705332519u, 0, TANH_TOLERANCE, 0},
{ 916, 1065584698u, 3685851715u, 3187829932u, 2363997529u, 1065584660u, 211014232u, 0, TANH_TOLERANCE, 0},
{ 917, 1065409879u, 3974431579u, 1052505165u, 2589067816u, 1065409854u, 4054288065u, 0, TANH_TOLERANCE, 0},
{ 918, 3213516885u, 3819109588u, 1048561488u, 969143351u, 3213516790u, 1379942954u, 0, TANH_TOLERANCE, 0},
{ 919, 1073687973u, 4246896124u, 1104584799u, 1940097860u, 1072609810u, 1441804246u, 0, TANH_TOLERANCE, 0},
{ 920, 1066912836u, 2228686199u, 3220231833u, 777624847u, 1066912555u, 3407343459u, 0, TANH_TOLERANCE, 0},
{ 921, 3224127274u, 4189906558u, 3203004203u, 854242364u, 3220176895u, 4294957863u, 0, TANH_TOLERANCE, 0},
{ 922, 1081890311u, 4089051094u, 3227282692u, 2693170723u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 923, 1066855127u, 1278581412u, 3239296746u, 1774588717u, 1066854876u, 2541069805u, 0, TANH_TOLERANCE, 0},
{ 924, 3221324110u, 1794845306u, 1104879344u, 4135865182u, 3220124819u, 2264282728u, 0, TANH_TOLERANCE, 0},
{ 925, 1081283231u, 754938390u, 1061291430u, 2010786993u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 926, 1073581409u, 2034303731u, 3240176537u, 314147356u, 1072591461u, 214940394u, 0, TANH_TOLERANCE, 0},
{ 927, 3224109162u, 567588900u, 3195452230u, 1421366017u, 3220176895u, 4294954860u, 0, TANH_TOLERANCE, 0},
{ 928, 3221944027u, 2708717091u, 1071975971u, 1364590470u, 3220171946u, 3353839435u, 0, TANH_TOLERANCE, 0},
{ 929, 3229068611u, 3461956134u, 3207820115u, 1605709634u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 930, 1071594452u, 1497124553u, 1051715442u, 916736957u, 1071446066u, 3751200891u, 0, TANH_TOLERANCE, 0},
{ 931, 1070002699u, 834914365u, 1064667143u, 2839166298u, 1069986795u, 4288384363u, 0, TANH_TOLERANCE, 0},
{ 932, 1069862861u, 2139295776u, 1062816721u, 914592523u, 1069850968u, 1656920492u, 0, TANH_TOLERANCE, 0},
{ 933, 3213754179u, 851569132u, 1058503154u, 1399378677u, 3213754038u, 2687975447u, 0, TANH_TOLERANCE, 0},
{ 934, 3224100513u, 3897202342u, 3245382590u, 246600375u, 3220176895u, 4294953106u, 0, TANH_TOLERANCE, 0},
{ 935, 3222314580u, 3620429520u, 1055627557u, 229305u, 3220175863u, 2092509791u, 0, TANH_TOLERANCE, 0},
{ 936, 1076618801u, 3641997865u, 3206673888u, 93720614u, 1072693247u, 4294953519u, 0, TANH_TOLERANCE, 0},
{ 937, 3222565555u, 32766320u, 1062084905u, 3668443038u, 3220176743u, 3446256579u, 0, TANH_TOLERANCE, 0},
{ 938, 3222250420u, 2039713492u, 3248699388u, 1346210821u, 3220175356u, 3537038166u, 0, TANH_TOLERANCE, 0},
{ 939, 1078369952u, 1335820726u, 3191756860u, 1808427032u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 940, 1070879947u, 650692001u, 1103515670u, 2253348763u, 1070836863u, 2862482944u, 0, TANH_TOLERANCE, 0},
{ 941, 3213415283u, 2372623300u, 3210185343u, 3200572848u, 3213415203u, 3712949820u, 0, TANH_TOLERANCE, 0},
{ 942, 1080873125u, 762317532u, 3194595095u, 3192607437u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 943, 1070651309u, 217775356u, 3232827087u, 2969367386u, 1070626514u, 2747666722u, 0, TANH_TOLERANCE, 0},
{ 944, 1069755463u, 3621353969u, 1077994795u, 3873976266u, 1069746150u, 163612163u, 0, TANH_TOLERANCE, 0},
{ 945, 1078719075u, 268372152u, 3221764390u, 3216978962u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 946, 3227563243u, 142942404u, 1075322987u, 1746449109u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 947, 1081986200u, 496534875u, 3254522293u, 2532372502u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 948, 3228205445u, 2999955409u, 3222793392u, 1868977643u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 949, 1074319042u, 3353193428u, 3218469191u, 3326244297u, 1072684769u, 1756315237u, 0, TANH_TOLERANCE, 0},
{ 950, 1072413103u, 73646871u, 3231442171u, 3711510104u, 1072063156u, 1138124218u, 0, TANH_TOLERANCE, 0},
{ 951, 1077900612u, 218135177u, 3198908856u, 3082199105u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 952, 1072262784u, 1061628117u, 3248859043u, 86776158u, 1071982492u, 946844398u, 0, TANH_TOLERANCE, 0},
{ 953, 3217921858u, 938869114u, 1087911145u, 2416710759u, 3217888034u, 157440628u, 0, TANH_TOLERANCE, 0},
{ 954, 1079848192u, 2970853959u, 3239543429u, 1887505029u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 955, 3225145875u, 1337895935u, 1076463812u, 1172733328u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 956, 1068014296u, 1469010822u, 3229583535u, 551399515u, 1068013056u, 745955852u, 0, TANH_TOLERANCE, 0},
{ 957, 1074118123u, 1849711538u, 1049053713u, 1744276190u, 1072675043u, 2479863773u, 0, TANH_TOLERANCE, 0},
{ 958, 3226410140u, 2976596113u, 3192137295u, 3033242648u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 959, 1079824113u, 876810930u, 3197470945u, 2571587447u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 960, 3226042170u, 4007797282u, 3225853845u, 4069319648u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 961, 1067202926u, 3840538373u, 1043189552u, 3668774580u, 1067202458u, 2670505126u, 0, TANH_TOLERANCE, 0},
{ 962, 3220757432u, 200857661u, 3229758439u, 3359367736u, 3219997347u, 873171144u, 0, TANH_TOLERANCE, 0},
{ 963, 3227826349u, 111868139u, 3227902082u, 2366064003u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 964, 1066215262u, 3510904416u, 3222131653u, 3822770497u, 1066215133u, 3308089664u, 0, TANH_TOLERANCE, 0},
{ 965, 3226947075u, 789151814u, 1099269239u, 2958956055u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 966, 1076290712u, 722163228u, 1105524559u, 1534462169u, 1072693247u, 4292909799u, 0, TANH_TOLERANCE, 0},
{ 967, 1066509006u, 2207037106u, 3208952465u, 1231254630u, 1066508892u, 1078364023u, 0, TANH_TOLERANCE, 0},
{ 968, 3215709852u, 3838689849u, 3198769679u, 1302617170u, 3215708057u, 808607773u, 0, TANH_TOLERANCE, 0},
{ 969, 1076501722u, 2527556476u, 3240373426u, 124352692u, 1072693247u, 4294885069u, 0, TANH_TOLERANCE, 0},
{ 970, 3215269445u, 3502371499u, 1043411944u, 4190072016u, 3215268661u, 2097129318u, 0, TANH_TOLERANCE, 0},
{ 971, 1070967598u, 1798470077u, 3200116917u, 3421833729u, 1070915714u, 623414423u, 0, TANH_TOLERANCE, 0},
{ 972, 3214486476u, 3653237931u, 3204255012u, 3683870669u, 3214486144u, 2924063688u, 0, TANH_TOLERANCE, 0},
{ 973, 1069317222u, 376530104u, 1073853547u, 565755892u, 1069309555u, 442847759u, 0, TANH_TOLERANCE, 0},
{ 974, 3226775211u, 558292492u, 1051772749u, 4267873474u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 975, 3221626981u, 509637100u, 3212030069u, 215050379u, 3220160354u, 521049736u, 0, TANH_TOLERANCE, 0},
{ 976, 1078425613u, 3571665665u, 3188628584u, 757824767u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 977, 3220042217u, 998858159u, 1063077962u, 436029885u, 3219617538u, 1003022105u, 0, TANH_TOLERANCE, 0},
{ 978, 3217481301u, 996300405u, 3193842624u, 80548098u, 3217465556u, 1091661181u, 0, TANH_TOLERANCE, 0},
{ 979, 3222557384u, 3876129407u, 3215332180u, 2226970413u, 3220176734u, 59833828u, 0, TANH_TOLERANCE, 0},
{ 980, 3225026041u, 200013509u, 3224552716u, 414878724u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 981, 3224325637u, 309319541u, 1048979765u, 1261662434u, 3220176895u, 4294966839u, 0, TANH_TOLERANCE, 0},
{ 982, 1077718303u, 4062255924u, 3224274128u, 4289485681u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},
{ 983, 3224601748u, 1611969213u, 1053890378u, 3774617276u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 984, 1075169883u, 1752164782u, 3239587974u, 612223386u, 1072693170u, 909326654u, 0, TANH_TOLERANCE, 0},
{ 985, 1065663030u, 2024044989u, 1074932678u, 3259111307u, 1065662984u, 399148943u, 0, TANH_TOLERANCE, 0},
{ 986, 1068936158u, 2564965629u, 1093571065u, 169360454u, 1068932286u, 1946243873u, 0, TANH_TOLERANCE, 0},
{ 987, 1077016178u, 1860101737u, 3191222372u, 1676437468u, 1072693247u, 4294967291u, 0, TANH_TOLERANCE, 0},
{ 988, 1070288728u, 588387057u, 3192103292u, 2495288012u, 1070262055u, 2204208977u, 0, TANH_TOLERANCE, 0},
{ 989, 3214127225u, 659070058u, 1073095700u, 1393632068u, 3214127066u, 672489002u, 0, TANH_TOLERANCE, 0},
{ 990, 3220828991u, 4276187829u, 3217553330u, 1868253275u, 3220019394u, 2922613580u, 0, TANH_TOLERANCE, 0},
{ 991, 3222171696u, 2085481575u, 3215994784u, 800910002u, 3220174817u, 4105080085u, 0, TANH_TOLERANCE, 0},
{ 992, 1069517748u, 1950570756u, 3200582211u, 941022151u, 1069507347u, 2421477801u, 0, TANH_TOLERANCE, 0},
{ 993, 1070113280u, 2075610870u, 3250142022u, 3605152103u, 1070093642u, 2347649094u, 0, TANH_TOLERANCE, 0},
{ 994, 3216567890u, 3792931748u, 3204857863u, 804393211u, 3216562745u, 455243881u, 0, TANH_TOLERANCE, 0},
{ 995, 3229529122u, 3430071177u, 3226288311u, 3652522729u, 3220176896u, 0u, 0, TANH_TOLERANCE, 0},
{ 996, 3215994766u, 236884699u, 3227874605u, 2193269825u, 3215993354u, 3732743523u, 0, TANH_TOLERANCE, 0},
{ 997, 1071228049u, 2744231849u, 1046186036u, 771053722u, 1071143543u, 2181158284u, 0, TANH_TOLERANCE, 0},
{ 998, 1076656004u, 3000189819u, 1096500901u, 2057239777u, 1072693247u, 4294959487u, 0, TANH_TOLERANCE, 0},
{ 999, 1078106941u, 205759408u, 3244643377u, 2702292618u, 1072693248u, 0u, 0, TANH_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_TANH_H multiple inclusion protection

// EOF tanh.h
