//=================================================================
//
//        X10.h
//
//        X10 class
//
//=================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
// 
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
// 
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998, 1999 Cygnus Solutions.
// All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//=================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     sdf
// Contributors:  sdf
// Date:          1999-04-01
// Description:   Class to drive the X10 controller. This header file is host-independent.
// Usage:
//
//####DESCRIPTIONEND####
#include "eCosTestSerial.h"

class CX10 {
public:
	CX10(const char *pszPort);
	virtual ~CX10();
	bool Power(bool bOn,char cControl1,char cControl2,int &nErr);	// Perform a reset on this port, with these control chars
	bool Ok(){return m_Serial.Ok();}
    enum ErrType {X10_OK,X10_ILLEGAL_DEVICE_CODE,X10_ILLEGAL_HOUSE_CODE,X10_NO_REPLY, X10_BAD_CHECKSUM, X10_BAD_ACK, X10_UNKNOWN_ERROR};
    static const char *Image[1+X10_UNKNOWN_ERROR];
protected:
    CeCosTestSerial m_Serial;
	bool PutChar (unsigned char c);
	bool GetChar (unsigned char &c);
	bool ReceiveIPS();
    bool SetClock();
	bool Open();
	bool Close();
	const char *m_pszPort;
	void *m_hCom;
    bool Send( char c1, char c2,int &nErr);	// Send it these bytes and verify the returned checksum
};
