//=============================================================================
//
//      hal_diag.c
//
//      HAL diagnostic output code
//
//=============================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
// 
// The Original Code is eCos - Embedded Cygnus Operating System, released
// October 31, 1998.
// 
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//=============================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   proven
// Contributors:proven
// Date:        1998-10-05
// Purpose:     HAL diagnostic output
// Description: Implementations of HAL diagnostic output support.
//
//####DESCRIPTIONEND####
//
//=============================================================================

#include <pkgconf/hal.h>

#include <cyg/infra/cyg_type.h>         // base types

#include <cyg/hal/hal_diag.h>

//-----------------------------------------------------------------------------


#	define	SERIAL_COM1	(0x3F8)
#	define	SERIAL_COM2	(0x2F8)

#	define	TBR			(0x00)
#	define	RBR			(0x00)
#	define	IER			(0x01)
#	define	LCR			(0x03)
#	define	MCR			(0x04)
#	define	LSR			(0x05)
#	define	DLL			(0x00)
#	define	DLH			(0x01)
#	define	FCR			(0x02)

/* Configuration for 38400 baud, N81. */
#	define	BAUD_LOW	(3)
#if 0
/* Configuration for 19200 baud, N81. */
#	undef	BAUD_LOW
#	define	BAUD_LOW	(6)
/* Configuration for 9600 baud, N81. */
#	undef	BAUD_LOW
#	define	BAUD_LOW	(12)
#endif
#	define	BAUD_HIGH	(0)
#	define	WM_N81		(3)



int com1 ;


void hal_diag_init(void)
{
	com1 = SERIAL_COM1 ;

/* Initialize the serial port: don't send interrupts; don't go into test mode. */
	pc_outb(com1 + IER, 0);
	pc_outb(com1 + IER, 0);
	pc_outb(com1 + MCR, 0) ;

/* Configure the baud rate & word mode. */
	pc_outb(com1 + LCR, 0x80) ;
	pc_outb(com1 + DLL, BAUD_LOW);
	pc_outb(com1 + DLH, BAUD_HIGH);
	pc_outb(com1 + LCR, WM_N81) ;
}


/* Send out a character via debugger output. */
void hal_diag_write_char(char __c)
{
	int x;

	do
	{	x = pc_inb(com1 + LSR) ;
	} while (!(x & 0x60)) ;

	pc_outb(com1 + TBR, __c) ;
}




/* read and return a single char */
void hal_diag_read_char(char *c)
{
	int x;

	do
	{	x = pc_inb(com1 + LSR) ;
	} while (!(x & 0x01)) ;

	c[0] = pc_inb(com1 + RBR) ;
}

//-----------------------------------------------------------------------------
// End of hal_diag.c

