//==========================================================================
//
//      evmcan_ints.c
//
//      HAL interrupt support code for ARM EVMCAN / EASYCAN
//
//==========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
//
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
//
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    Eric MINIERE
//   based on Europe Technologies library code
// Contributors: Eric MINIERE
// Date:         2001-07-17
// Purpose:      HAL board support
// Description:  Implementations of HAL timer
//
//####DESCRIPTIONEND####
//
//===========================================================================*/
/* TODO in the future: Hardware Interrupt Vectoring

   The EASYCAN has an 8-level priority, individually maskable,
   vectored interrupt controller. This feature substantially
   reduces the software and real time overhead in handling
   internal and external interrupts.

   ecos currently uses its own interrupt handlers. Modify ecos
   so that certain interrupts can be handled directly with no
   context switching.
*/
#include <pkgconf/hal.h>

#include <cyg/infra/cyg_type.h>         // base types
#include <cyg/infra/cyg_trac.h>         // tracing macros
#include <cyg/infra/cyg_ass.h>          // assertion macros

#include <cyg/hal/hal_io.h>             // IO macros
#include <cyg/hal/hal_arch.h>           // Register state info
#include <cyg/hal/hal_intr.h>           // necessary?

// Advanced Interrupt controller registers

/* Interrupt Controller Structure Definition */


/* Interrupt Sources Definition */


typedef struct
{
   cyg_uint32    AIC_SMR[32] ;       /* Source Mode Register */
   cyg_uint32    AIC_SVR[32] ;       /* Source Vector Register */
   cyg_uint32    AIC_IVR ;           /* Interrupt Vector Register */
   cyg_uint32    AIC_FVR ;           /* FIQ Vector Register */
   cyg_uint32    AIC_ISR ;           /* Interrupt Status Register */
   cyg_uint32    AIC_IPR ;           /* Interrupt Pending Register */
   cyg_uint32    AIC_IMR ;           /* Interrupt Mask Register */
   cyg_uint32    AIC_CISR ;          /* Core Interrupt Status Register */
   cyg_uint32    reserved0 ;
   cyg_uint32    reserved1 ;
   cyg_uint32    AIC_IECR ;          /* Interrupt Enable Command Register */
   cyg_uint32    AIC_IDCR ;          /* Interrupt Disable Command Register */
   cyg_uint32    AIC_ICCR ;          /* Interrupt Clear Command Register */
   cyg_uint32    AIC_ISCR ;          /* Interrupt Set Command Register */
   cyg_uint32    AIC_EOICR ;         /* End of Interrupt Command Register */
   cyg_uint32    AIC_SPU ;         /* End of Interrupt Command Register */
}
EASYCAN_RTOAIC_REGS;

/* Interrupt Source Mode Registers */

#define LevelSensitive              (0<<5) /* Source Type Definition */
#define EdgeTriggered               (1<<5)
#define LowLevel                    (0<<5)
#define NegativeEdge                (1<<5)
#define HighLevel                   (2<<5)
#define PositiveEdge                (3<<5)

#define SRCTYPE                     (3<<5)
#define PRIOR                       (7<<0)

/* Interrupt Status Register */
#define IRQID                       0x1F

/* Interrupt Core Status Register */
#define NFIQ                        (1<<0)
#define NIRQ                        (1<<1)

#define RTOAIC_BASE            ((EASYCAN_RTOAIC_REGS *) 0xFFFFF000 )

volatile EASYCAN_RTOAIC_REGS *RTOAIC = RTOAIC_BASE;


void no_handler_irq ( void )
{
   /* This is a dummy function and should never be called as ecos is handling interrupts
          on its own */
   //diag_printf("Interrupt: Error, kernel exception handler error\n");
   /* Loop forever */
   //for (;;) ;
}

void hal_hardware_init(void)
{
   // Any hardware/platform initialization that needs to be done.
   int      irq_id ;

   /* Disable all interrupts */
   RTOAIC->AIC_IDCR = 0xFFFFFFFF ;
   /* Clear all interrupts */
   RTOAIC->AIC_ICCR = 0xFFFFFFFF ;


   for ( irq_id = 0 ; irq_id < 8 ; irq_id ++ )
   {
      /* Unstack a level by writting in AIC_EOICR */
      /* Value written has no effect */
      RTOAIC->AIC_EOICR = irq_id ;
   }

   /* For each interrupt source */
   for ( irq_id = 1 ; irq_id < 32 ; irq_id ++ )
   {
      //* Priority is lowest
      RTOAIC->AIC_SMR[irq_id] = LevelSensitive;
      //* Interrupt routine is undefined
      RTOAIC->AIC_SVR[irq_id] = (cyg_uint32) no_handler_irq ;
   }

   // Set up eCos/ROM interfaces
   hal_if_init();
}

//
// This routine is called to respond to a hardware interrupt (IRQ).  It
// should interrogate the hardware and return the IRQ vector number.

int hal_IRQ_handler(void)
{
   register cyg_uint32 vector;

   vector = RTOAIC->AIC_IVR;  // Acknowledge interrupt (Reads as 0)
   vector = RTOAIC->AIC_ISR;  // Read interrupt vector

   return vector;
}

//
// Interrupt control
//

void hal_interrupt_mask(int vector)
{
   register cyg_uint32 mask = (1<<vector);

   //    if (vector < 32)
   {
      RTOAIC->AIC_IDCR = mask;   /* Mask interrupt */
      RTOAIC->AIC_ICCR = mask;   /* Clear interrupt */
   }
}

#if 0
   void hal_interrupt_status(void)
   {
      int irq_status, irq_enable, timer_status, timer_value, timer_load;
   }
#endif

void hal_interrupt_unmask(int vector)
{
   register cyg_uint32 mask = (1<<vector);

   RTOAIC->AIC_ICCR = mask;   /* Clear status interrupt */
   RTOAIC->AIC_IECR = mask;   /* Enable interrupt */
}

void hal_interrupt_acknowledge(int vector)
{
   register cyg_uint32 mask = (1<<vector);

   RTOAIC->AIC_ICCR = mask;   /* Clear interrupt */
   /* Unstack a level by writting in AIC_EOICR */
   /* Value written has no effect */
   RTOAIC->AIC_EOICR = 0xFFFFFFFF;
}

void hal_interrupt_configure(int vector, int level, int up)
{
   cyg_uint32 temp;

   temp = ( RTOAIC->AIC_SMR[vector] & 0x7);       // force priority  1
   RTOAIC->AIC_SMR[vector] = temp | (level ? LevelSensitive : EdgeTriggered) | (up ? HighLevel : LowLevel);   // Setup levels and edges
}

void hal_interrupt_set_level(int vector, int level)
{
   cyg_uint32 temp;

   temp = ( RTOAIC->AIC_SMR[vector] & 0xf0);         // force priority  1
   RTOAIC->AIC_SMR[vector] = temp | level;  // Setup levels and edges
}

void hal_show_IRQ(int vector, int data, int handler)
{
}

/*---------------------------------------------------------------------------*/
/* End of hal_misc.c */
