/* where-clause.c generated by valac 0.38.8, the Vala compiler
 * generated from where-clause.vala, do not modify */

/* where-clause.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_WHERE_CLAUSE (zeitgeist_where_clause_get_type ())
#define ZEITGEIST_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClause))
#define ZEITGEIST_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))
#define ZEITGEIST_IS_WHERE_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_IS_WHERE_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_WHERE_CLAUSE))
#define ZEITGEIST_WHERE_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClauseClass))

typedef struct _ZeitgeistWhereClause ZeitgeistWhereClause;
typedef struct _ZeitgeistWhereClauseClass ZeitgeistWhereClauseClass;
typedef struct _ZeitgeistWhereClausePrivate ZeitgeistWhereClausePrivate;

#define ZEITGEIST_WHERE_CLAUSE_TYPE_TYPE (zeitgeist_where_clause_type_get_type ())
enum  {
	ZEITGEIST_WHERE_CLAUSE_0_PROPERTY,
	ZEITGEIST_WHERE_CLAUSE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_where_clause_properties[ZEITGEIST_WHERE_CLAUSE_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistWhereClause {
	GObject parent_instance;
	ZeitgeistWhereClausePrivate * priv;
};

struct _ZeitgeistWhereClauseClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZEITGEIST_WHERE_CLAUSE_TYPE_AND,
	ZEITGEIST_WHERE_CLAUSE_TYPE_OR
} ZeitgeistWhereClauseType;

struct _ZeitgeistWhereClausePrivate {
	ZeitgeistWhereClauseType clause_type;
	gboolean negated;
	GPtrArray* conditions;
	GPtrArray* arguments;
	gboolean is_simple;
};


static gpointer zeitgeist_where_clause_parent_class = NULL;
static gchar** zeitgeist_where_clause_RELATION_SIGNS;
static gint zeitgeist_where_clause_RELATION_SIGNS_length1;
static gchar** zeitgeist_where_clause_RELATION_SIGNS = NULL;
static gint zeitgeist_where_clause_RELATION_SIGNS_length1 = 0;
static gint _zeitgeist_where_clause_RELATION_SIGNS_size_ = 0;

GType zeitgeist_where_clause_get_type (void) G_GNUC_CONST;
GType zeitgeist_where_clause_type_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_WHERE_CLAUSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClausePrivate))
ZeitgeistWhereClause* zeitgeist_where_clause_new (ZeitgeistWhereClauseType type, gboolean negate);
ZeitgeistWhereClause* zeitgeist_where_clause_construct (GType object_type, ZeitgeistWhereClauseType type, gboolean negate);
static void _g_free0_ (gpointer var);
gint zeitgeist_where_clause_get_conditions_length (ZeitgeistWhereClause* self);
gboolean zeitgeist_where_clause_has_non_timestamp_condition (ZeitgeistWhereClause* self);
void zeitgeist_where_clause_add (ZeitgeistWhereClause* self, const gchar* condition, const gchar* argument);
void zeitgeist_where_clause_add_with_array (ZeitgeistWhereClause* self, const gchar* condition, GPtrArray* args);
static gchar* zeitgeist_where_clause_get_search_table_for_column (const gchar* column);
void zeitgeist_where_clause_add_match_condition (ZeitgeistWhereClause* self, const gchar* column, gint val, gboolean negation);
void zeitgeist_where_clause_add_text_condition_subquery (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation);
void zeitgeist_where_clause_add_text_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation);
void zeitgeist_where_clause_add_wildcard_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* needle, gboolean negation);
static gchar* zeitgeist_where_clause_optimize_glob (const gchar* column, const gchar* table, GPtrArray* * args);
void zeitgeist_where_clause_extend (ZeitgeistWhereClause* self, ZeitgeistWhereClause* clause);
gboolean zeitgeist_where_clause_is_empty (ZeitgeistWhereClause* self);
gchar* zeitgeist_where_clause_get_sql_conditions (ZeitgeistWhereClause* self);
gboolean zeitgeist_where_clause_get_is_simple (ZeitgeistWhereClause* self);
gboolean zeitgeist_where_clause_may_have_results (ZeitgeistWhereClause* self);
void zeitgeist_where_clause_set_is_simple (ZeitgeistWhereClause* self, gboolean simple);
static gpointer* zeitgeist_where_clause_generic_array_to_unowned_array (ZeitgeistWhereClause* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GPtrArray* gptrarr, int* result_length1);
static gpointer* _vala_array_dup1 (gpointer* self, int length, GBoxedCopyFunc t_dup_func);
GPtrArray* zeitgeist_where_clause_get_bind_arguments (ZeitgeistWhereClause* self);
gchar* zeitgeist_where_clause_get_right_boundary (const gchar* text);
static void zeitgeist_where_clause_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType zeitgeist_where_clause_type_get_type (void) {
	static volatile gsize zeitgeist_where_clause_type_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_where_clause_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_WHERE_CLAUSE_TYPE_AND, "ZEITGEIST_WHERE_CLAUSE_TYPE_AND", "and"}, {ZEITGEIST_WHERE_CLAUSE_TYPE_OR, "ZEITGEIST_WHERE_CLAUSE_TYPE_OR", "or"}, {0, NULL, NULL}};
		GType zeitgeist_where_clause_type_type_id;
		zeitgeist_where_clause_type_type_id = g_enum_register_static ("ZeitgeistWhereClauseType", values);
		g_once_init_leave (&zeitgeist_where_clause_type_type_id__volatile, zeitgeist_where_clause_type_type_id);
	}
	return zeitgeist_where_clause_type_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


ZeitgeistWhereClause* zeitgeist_where_clause_construct (GType object_type, ZeitgeistWhereClauseType type, gboolean negate) {
	ZeitgeistWhereClause * self = NULL;
	ZeitgeistWhereClauseType _tmp0_;
	gboolean _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	self = (ZeitgeistWhereClause*) g_object_new (object_type, NULL);
	_tmp0_ = type;
	self->priv->clause_type = _tmp0_;
	_tmp1_ = negate;
	self->priv->negated = _tmp1_;
	self->priv->is_simple = TRUE;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->conditions);
	self->priv->conditions = _tmp2_;
	_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->arguments);
	self->priv->arguments = _tmp3_;
	return self;
}


ZeitgeistWhereClause* zeitgeist_where_clause_new (ZeitgeistWhereClauseType type, gboolean negate) {
	return zeitgeist_where_clause_construct (ZEITGEIST_TYPE_WHERE_CLAUSE, type, negate);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


gint zeitgeist_where_clause_get_conditions_length (ZeitgeistWhereClause* self) {
	gint result = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean zeitgeist_where_clause_has_non_timestamp_condition (ZeitgeistWhereClause* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				gboolean _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->conditions;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->conditions;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = g_str_has_prefix ((const gchar*) _tmp8_, "timestamp");
				if (!_tmp9_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


void zeitgeist_where_clause_add (ZeitgeistWhereClause* self, const gchar* condition, const gchar* argument) {
	GPtrArray* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (condition != NULL);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = condition;
	_tmp2_ = g_strdup (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
	_tmp3_ = argument;
	if (_tmp3_ != NULL) {
		GPtrArray* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->arguments;
		_tmp5_ = argument;
		_tmp6_ = g_strdup (_tmp5_);
		g_ptr_array_add (_tmp4_, _tmp6_);
	}
}


void zeitgeist_where_clause_add_with_array (ZeitgeistWhereClause* self, const gchar* condition, GPtrArray* args) {
	GPtrArray* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (condition != NULL);
	g_return_if_fail (args != NULL);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = condition;
	_tmp2_ = g_strdup (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				GPtrArray* _tmp9_;
				GPtrArray* _tmp10_;
				gint _tmp11_;
				gconstpointer _tmp12_;
				gchar* _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = args;
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = self->priv->arguments;
				_tmp10_ = args;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				_tmp13_ = g_strdup ((const gchar*) _tmp12_);
				g_ptr_array_add (_tmp9_, _tmp13_);
			}
		}
	}
}


static gchar* zeitgeist_where_clause_get_search_table_for_column (const gchar* column) {
	gchar* result = NULL;
	gchar* search_table = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	g_return_val_if_fail (column != NULL, NULL);
	_tmp0_ = column;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("origin")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("subj_origin"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("subj_origin_current"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("subj_id"))))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("subj_id_current"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("uri");
				_g_free0 (search_table);
				search_table = _tmp4_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("subj_mimetype")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("mimetype");
				_g_free0 (search_table);
				search_table = _tmp5_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("subj_text_id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("text");
				_g_free0 (search_table);
				search_table = _tmp6_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("subj_storage_id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("storage");
				_g_free0 (search_table);
				search_table = _tmp7_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = column;
				_tmp9_ = g_strdup (_tmp8_);
				_g_free0 (search_table);
				search_table = _tmp9_;
				break;
			}
		}
	}
	result = search_table;
	return result;
}


void zeitgeist_where_clause_add_match_condition (ZeitgeistWhereClause* self, const gchar* column, gint val, gboolean negation) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* sql = NULL;
	const gchar* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	_tmp1_ = negation;
	if (_tmp1_) {
		_tmp0_ = "!";
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = column;
	_tmp3_ = val;
	_tmp4_ = g_strdup_printf ("%s %s= %d", _tmp2_, _tmp0_, _tmp3_);
	sql = _tmp4_;
	zeitgeist_where_clause_add (self, sql, NULL);
	_g_free0 (sql);
}


void zeitgeist_where_clause_add_text_condition_subquery (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation) {
	gchar* search_table = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gchar* sql = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = column;
	_tmp1_ = zeitgeist_where_clause_get_search_table_for_column (_tmp0_);
	search_table = _tmp1_;
	_tmp3_ = negation;
	if (_tmp3_) {
		_tmp2_ = "!";
	} else {
		_tmp2_ = "";
	}
	_tmp4_ = column;
	_tmp5_ = search_table;
	_tmp6_ = g_strdup_printf ("%s %s= (SELECT id FROM %s WHERE value = ?)", _tmp4_, _tmp2_, _tmp5_);
	sql = _tmp6_;
	_tmp7_ = val;
	zeitgeist_where_clause_add (self, sql, _tmp7_);
	self->priv->is_simple = FALSE;
	_g_free0 (sql);
	_g_free0 (search_table);
}


void zeitgeist_where_clause_add_text_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* val, gboolean negation) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gchar* sql = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	g_return_if_fail (val != NULL);
	_tmp1_ = negation;
	if (_tmp1_) {
		_tmp0_ = "!";
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = column;
	_tmp3_ = g_strdup_printf ("%s %s= ?", _tmp2_, _tmp0_);
	sql = _tmp3_;
	_tmp4_ = val;
	zeitgeist_where_clause_add (self, sql, _tmp4_);
	_g_free0 (sql);
}


void zeitgeist_where_clause_add_wildcard_condition (ZeitgeistWhereClause* self, const gchar* column, const gchar* needle, gboolean negation) {
	gchar* search_table = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GPtrArray* values = NULL;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* optimized_glob = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* sql = NULL;
	gboolean _tmp8_;
	const gchar* _tmp16_;
	GPtrArray* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	g_return_if_fail (needle != NULL);
	_tmp0_ = column;
	_tmp1_ = zeitgeist_where_clause_get_search_table_for_column (_tmp0_);
	search_table = _tmp1_;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	values = _tmp2_;
	_tmp3_ = values;
	_tmp4_ = needle;
	_tmp5_ = g_strdup (_tmp4_);
	g_ptr_array_add (_tmp3_, _tmp5_);
	_tmp6_ = search_table;
	_tmp7_ = zeitgeist_where_clause_optimize_glob ("id", _tmp6_, &values);
	optimized_glob = _tmp7_;
	_tmp8_ = negation;
	if (!_tmp8_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = column;
		_tmp10_ = optimized_glob;
		_tmp11_ = g_strdup_printf ("%s IN (%s)", _tmp9_, _tmp10_);
		_g_free0 (sql);
		sql = _tmp11_;
	} else {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = column;
		_tmp13_ = optimized_glob;
		_tmp14_ = column;
		_tmp15_ = g_strdup_printf ("(%s NOT IN (%s) OR %s is NULL)", _tmp12_, _tmp13_, _tmp14_);
		_g_free0 (sql);
		sql = _tmp15_;
	}
	_tmp16_ = sql;
	_tmp17_ = values;
	zeitgeist_where_clause_add_with_array (self, _tmp16_, _tmp17_);
	self->priv->is_simple = FALSE;
	_g_free0 (sql);
	_g_free0 (optimized_glob);
	_g_ptr_array_unref0 (values);
	_g_free0 (search_table);
}


void zeitgeist_where_clause_extend (ZeitgeistWhereClause* self, ZeitgeistWhereClause* clause) {
	ZeitgeistWhereClause* _tmp0_;
	gboolean _tmp1_;
	gchar* sql = NULL;
	ZeitgeistWhereClause* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ZeitgeistWhereClause* _tmp5_;
	GPtrArray* _tmp6_;
	ZeitgeistWhereClause* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clause != NULL);
	_tmp0_ = clause;
	_tmp1_ = zeitgeist_where_clause_is_empty (_tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = clause;
	_tmp3_ = zeitgeist_where_clause_get_sql_conditions (_tmp2_);
	sql = _tmp3_;
	_tmp4_ = sql;
	_tmp5_ = clause;
	_tmp6_ = _tmp5_->priv->arguments;
	zeitgeist_where_clause_add_with_array (self, _tmp4_, _tmp6_);
	_tmp7_ = clause;
	_tmp8_ = zeitgeist_where_clause_get_is_simple (_tmp7_);
	self->priv->is_simple = _tmp8_;
	_g_free0 (sql);
}


gboolean zeitgeist_where_clause_is_empty (ZeitgeistWhereClause* self) {
	gboolean result = FALSE;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}


gboolean zeitgeist_where_clause_may_have_results (ZeitgeistWhereClause* self) {
	gboolean result = FALSE;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}


gboolean zeitgeist_where_clause_get_is_simple (ZeitgeistWhereClause* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->is_simple;
	result = _tmp0_;
	return result;
}


void zeitgeist_where_clause_set_is_simple (ZeitgeistWhereClause* self, gboolean simple) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = simple;
	self->priv->is_simple = _tmp0_;
}


/**
         * This is dangerous. Only use it if you're made full of awesome.
         */
static gpointer* _vala_array_dup1 (gpointer* self, int length, GBoxedCopyFunc t_dup_func) {
	gpointer* result;
	int i;
	result = g_new0 (gpointer, length);
	for (i = 0; i < length; i++) {
		gpointer _tmp0_;
		_tmp0_ = ((self[i] != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) self[i]) : ((gpointer) self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gpointer* zeitgeist_where_clause_generic_array_to_unowned_array (ZeitgeistWhereClause* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GPtrArray* gptrarr, int* result_length1) {
	gpointer* result = NULL;
	glong* pointers = NULL;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	glong* _tmp3_;
	gint pointers_length1;
	gint _pointers_size_;
	GPtrArray* _tmp4_;
	gpointer* _tmp5_;
	gint _tmp5__length1;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gpointer* _tmp9_;
	gint _tmp9__length1;
	gpointer* _tmp10_;
	gint _tmp10__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gptrarr != NULL, NULL);
	_tmp0_ = gptrarr;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (glong, _tmp2_);
	pointers = _tmp3_;
	pointers_length1 = _tmp2_;
	_pointers_size_ = pointers_length1;
	_tmp4_ = gptrarr;
	_tmp5_ = _tmp4_->pdata;
	_tmp5__length1 = (gint) _tmp4_->len;
	_tmp6_ = gptrarr;
	_tmp7_ = g_ptr_array_get_length (_tmp6_);
	_tmp8_ = _tmp7_;
	memcpy (pointers, (void*) _tmp5_, (gsize) (_tmp8_ * sizeof (void*)));
	_tmp9_ = (((gpointer*) pointers) != NULL) ? _vala_array_dup1 ((gpointer*) pointers, pointers_length1, t_dup_func) : ((gpointer) ((gpointer*) pointers));
	_tmp9__length1 = pointers_length1;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	pointers = (g_free (pointers), NULL);
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp2_ = str_array;
	_tmp2__length1 = str_array_length1;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		if (_tmp4__length1 > 0) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = str_array;
			_tmp6__length1 = str_array_length1;
			if (_tmp6__length1 == -1) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				_tmp7_ = str_array;
				_tmp7__length1 = str_array_length1;
				_tmp8_ = _tmp7_[0];
				_tmp5_ = _tmp8_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp3_ = _tmp5_;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gchar* zeitgeist_where_clause_get_sql_conditions (ZeitgeistWhereClause* self) {
	gchar* result = NULL;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gchar* negation_sign = NULL;
	gchar* _tmp5_;
	gchar* relation_sign = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ZeitgeistWhereClauseType _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* conditions_string = NULL;
	const gchar* _tmp17_;
	GPtrArray* _tmp18_;
	gint _tmp19_;
	gpointer* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ > 0, "conditions.length > 0");
	_tmp4_ = self->priv->negated;
	if (_tmp4_) {
		_tmp3_ = "NOT ";
	} else {
		_tmp3_ = "";
	}
	_tmp5_ = g_strdup (_tmp3_);
	negation_sign = _tmp5_;
	_tmp6_ = zeitgeist_where_clause_RELATION_SIGNS;
	_tmp6__length1 = zeitgeist_where_clause_RELATION_SIGNS_length1;
	_tmp7_ = self->priv->clause_type;
	_tmp8_ = _tmp6_[_tmp7_];
	_tmp9_ = g_strdup (_tmp8_);
	relation_sign = _tmp9_;
	_tmp10_ = self->priv->conditions;
	_tmp11_ = g_ptr_array_get_length (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 1) {
		const gchar* _tmp13_;
		GPtrArray* _tmp14_;
		gconstpointer _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = negation_sign;
		_tmp14_ = self->priv->conditions;
		_tmp15_ = g_ptr_array_index (_tmp14_, (guint) 0);
		_tmp16_ = g_strdup_printf ("%s%s", _tmp13_, (const gchar*) _tmp15_);
		result = _tmp16_;
		_g_free0 (relation_sign);
		_g_free0 (negation_sign);
		return result;
	}
	_tmp17_ = relation_sign;
	_tmp18_ = self->priv->conditions;
	_tmp20_ = zeitgeist_where_clause_generic_array_to_unowned_array (self, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp18_, &_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _tmp19_;
	_tmp22_ = _vala_g_strjoinv (_tmp17_, _tmp21_, _tmp19_);
	_tmp23_ = _tmp22_;
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	conditions_string = _tmp23_;
	_tmp24_ = negation_sign;
	_tmp25_ = conditions_string;
	_tmp26_ = g_strdup_printf ("%s(%s)", _tmp24_, _tmp25_);
	result = _tmp26_;
	_g_free0 (conditions_string);
	_g_free0 (relation_sign);
	_g_free0 (negation_sign);
	return result;
}


GPtrArray* zeitgeist_where_clause_get_bind_arguments (ZeitgeistWhereClause* self) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->arguments;
	result = _tmp0_;
	return result;
}


/**
         * Return an optimized version of the GLOB statement as described in
         * http://www.sqlite.org/optoverview.html "4.0 The LIKE optimization".
         */
static gchar* zeitgeist_where_clause_optimize_glob (const gchar* column, const gchar* table, GPtrArray* * args) {
	gchar* result = NULL;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* sql = NULL;
	gchar* prefix = NULL;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_val_if_fail (column != NULL, NULL);
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (*args != NULL, NULL);
	_tmp0_ = *args;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_val_if_fail (_tmp2_ == 1, "args.length == 1", NULL);
	_tmp3_ = *args;
	_tmp4_ = g_ptr_array_index (_tmp3_, (guint) 0);
	_tmp5_ = g_strdup ((const gchar*) _tmp4_);
	prefix = _tmp5_;
	_tmp6_ = prefix;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = column;
		_tmp8_ = table;
		_tmp9_ = g_strdup_printf ("SELECT %s FROM %s", _tmp7_, _tmp8_);
		_g_free0 (sql);
		sql = _tmp9_;
	} else {
		if (FALSE) {
		} else {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			GPtrArray* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = column;
			_tmp11_ = table;
			_tmp12_ = g_strdup_printf ("SELECT %s FROM %s WHERE (value >= ? AND value < ?)", _tmp10_, _tmp11_);
			_g_free0 (sql);
			sql = _tmp12_;
			_tmp13_ = *args;
			_tmp14_ = prefix;
			_tmp15_ = zeitgeist_where_clause_get_right_boundary (_tmp14_);
			g_ptr_array_add (_tmp13_, _tmp15_);
		}
	}
	result = sql;
	_g_free0 (prefix);
	return result;
}


/**
         * Return the smallest string which is greater than the given `text`.
         */
static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* zeitgeist_where_clause_get_right_boundary (const gchar* text) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint len = 0;
	const gchar* _tmp7_;
	gint _tmp8_;
	gunichar charpoint = 0U;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gunichar _tmp13_;
	gchar* head = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_;
	gunichar _tmp19_;
	const gchar* _tmp22_;
	GString* _tmp23_;
	GString* _tmp24_;
	gunichar _tmp25_;
	GString* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		GString* _tmp1_;
		GString* _tmp2_;
		GString* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = g_string_new ("");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_string_append_unichar (_tmp2_, (gunichar) 0x10ffff);
		_tmp4_ = _tmp3_->str;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_string_free0 (_tmp2_);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = text;
	_tmp8_ = g_utf8_strlen (_tmp7_, (gssize) -1);
	len = _tmp8_ - 1;
	_tmp9_ = text;
	_tmp10_ = text;
	_tmp11_ = len;
	_tmp12_ = string_index_of_nth_char (_tmp10_, (glong) _tmp11_);
	_tmp13_ = string_get_char (_tmp9_, (glong) _tmp12_);
	charpoint = _tmp13_;
	_tmp14_ = text;
	_tmp15_ = text;
	_tmp16_ = len;
	_tmp17_ = string_index_of_nth_char (_tmp15_, (glong) _tmp16_);
	_tmp18_ = string_substring (_tmp14_, (glong) 0, (glong) _tmp17_);
	head = _tmp18_;
	_tmp19_ = charpoint;
	if (_tmp19_ == ((gunichar) 0x10ffff)) {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = head;
		_tmp21_ = zeitgeist_where_clause_get_right_boundary (_tmp20_);
		result = _tmp21_;
		_g_free0 (head);
		return result;
	}
	_tmp22_ = head;
	_tmp23_ = g_string_new ("");
	_tmp24_ = _tmp23_;
	_tmp25_ = charpoint;
	_tmp26_ = g_string_append_unichar (_tmp24_, _tmp25_ + 1);
	_tmp27_ = _tmp26_->str;
	_tmp28_ = g_strconcat (_tmp22_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_g_string_free0 (_tmp24_);
	result = _tmp29_;
	_g_free0 (head);
	return result;
}


static void zeitgeist_where_clause_class_init (ZeitgeistWhereClauseClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	zeitgeist_where_clause_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistWhereClausePrivate));
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_where_clause_finalize;
	_tmp0_ = g_strdup (" AND ");
	_tmp1_ = g_strdup (" OR ");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	zeitgeist_where_clause_RELATION_SIGNS = _tmp2_;
	zeitgeist_where_clause_RELATION_SIGNS_length1 = 2;
}


static void zeitgeist_where_clause_instance_init (ZeitgeistWhereClause * self) {
	self->priv = ZEITGEIST_WHERE_CLAUSE_GET_PRIVATE (self);
}


static void zeitgeist_where_clause_finalize (GObject * obj) {
	ZeitgeistWhereClause * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClause);
	_g_ptr_array_unref0 (self->priv->conditions);
	_g_ptr_array_unref0 (self->priv->arguments);
	G_OBJECT_CLASS (zeitgeist_where_clause_parent_class)->finalize (obj);
}


/**
     * This class provides a convenient representation a SQL `WHERE' clause,
     * composed of a set of conditions joined together.
     *
     * The relation between conditions can be either of type *AND* or *OR*, but
     * not both. To create more complex clauses, use several `WhereClause`
     * instances and joining them together using `extend`.
     *
     * Instances of this class can then be used to obtain a line of SQL code and
     * a list of arguments, for use with SQLite 3.
     */
GType zeitgeist_where_clause_get_type (void) {
	static volatile gsize zeitgeist_where_clause_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_where_clause_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistWhereClauseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_where_clause_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistWhereClause), 0, (GInstanceInitFunc) zeitgeist_where_clause_instance_init, NULL };
		GType zeitgeist_where_clause_type_id;
		zeitgeist_where_clause_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistWhereClause", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_where_clause_type_id__volatile, zeitgeist_where_clause_type_id);
	}
	return zeitgeist_where_clause_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



