# The PEP 484 type hints stub file for the Qt3DRender module.
#
# Generated by SIP 4.19.3
#
# Copyright (c) 2017 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt3D.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5 import Qt3DCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class Qt3DRender(sip.simplewrapper):

    class QAbstractFunctor(sip.simplewrapper):

        def __init__(self) -> None: ...

        def id(self) -> sip.voidptr: ...

    class QAbstractLight(Qt3DCore.QComponent):

        class Type(int): ...
        PointLight = ... # type: 'QAbstractLight.Type'
        DirectionalLight = ... # type: 'QAbstractLight.Type'
        SpotLight = ... # type: 'QAbstractLight.Type'

        def intensityChanged(self, intensity: float) -> None: ...
        def colorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def setIntensity(self, intensity: float) -> None: ...
        def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def intensity(self) -> float: ...
        def color(self) -> QtGui.QColor: ...
        def type(self) -> 'QAbstractLight.Type': ...

    class QAbstractTexture(Qt3DCore.QNode):

        class ComparisonMode(int): ...
        CompareRefToTexture = ... # type: 'QAbstractTexture.ComparisonMode'
        CompareNone = ... # type: 'QAbstractTexture.ComparisonMode'

        class ComparisonFunction(int): ...
        CompareLessEqual = ... # type: 'QAbstractTexture.ComparisonFunction'
        CompareGreaterEqual = ... # type: 'QAbstractTexture.ComparisonFunction'
        CompareLess = ... # type: 'QAbstractTexture.ComparisonFunction'
        CompareGreater = ... # type: 'QAbstractTexture.ComparisonFunction'
        CompareEqual = ... # type: 'QAbstractTexture.ComparisonFunction'
        CommpareNotEqual = ... # type: 'QAbstractTexture.ComparisonFunction'
        CompareAlways = ... # type: 'QAbstractTexture.ComparisonFunction'
        CompareNever = ... # type: 'QAbstractTexture.ComparisonFunction'

        class CubeMapFace(int): ...
        CubeMapPositiveX = ... # type: 'QAbstractTexture.CubeMapFace'
        CubeMapNegativeX = ... # type: 'QAbstractTexture.CubeMapFace'
        CubeMapPositiveY = ... # type: 'QAbstractTexture.CubeMapFace'
        CubeMapNegativeY = ... # type: 'QAbstractTexture.CubeMapFace'
        CubeMapPositiveZ = ... # type: 'QAbstractTexture.CubeMapFace'
        CubeMapNegativeZ = ... # type: 'QAbstractTexture.CubeMapFace'
        AllFaces = ... # type: 'QAbstractTexture.CubeMapFace'

        class Filter(int): ...
        Nearest = ... # type: 'QAbstractTexture.Filter'
        Linear = ... # type: 'QAbstractTexture.Filter'
        NearestMipMapNearest = ... # type: 'QAbstractTexture.Filter'
        NearestMipMapLinear = ... # type: 'QAbstractTexture.Filter'
        LinearMipMapNearest = ... # type: 'QAbstractTexture.Filter'
        LinearMipMapLinear = ... # type: 'QAbstractTexture.Filter'

        class TextureFormat(int): ...
        NoFormat = ... # type: 'QAbstractTexture.TextureFormat'
        Automatic = ... # type: 'QAbstractTexture.TextureFormat'
        R8_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RG8_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGB8_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA8_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        R16_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RG16_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGB16_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA16_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        R8_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RG8_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGB8_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA8_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        R16_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RG16_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGB16_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA16_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        R8U = ... # type: 'QAbstractTexture.TextureFormat'
        RG8U = ... # type: 'QAbstractTexture.TextureFormat'
        RGB8U = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA8U = ... # type: 'QAbstractTexture.TextureFormat'
        R16U = ... # type: 'QAbstractTexture.TextureFormat'
        RG16U = ... # type: 'QAbstractTexture.TextureFormat'
        RGB16U = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA16U = ... # type: 'QAbstractTexture.TextureFormat'
        R32U = ... # type: 'QAbstractTexture.TextureFormat'
        RG32U = ... # type: 'QAbstractTexture.TextureFormat'
        RGB32U = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA32U = ... # type: 'QAbstractTexture.TextureFormat'
        R8I = ... # type: 'QAbstractTexture.TextureFormat'
        RG8I = ... # type: 'QAbstractTexture.TextureFormat'
        RGB8I = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA8I = ... # type: 'QAbstractTexture.TextureFormat'
        R16I = ... # type: 'QAbstractTexture.TextureFormat'
        RG16I = ... # type: 'QAbstractTexture.TextureFormat'
        RGB16I = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA16I = ... # type: 'QAbstractTexture.TextureFormat'
        R32I = ... # type: 'QAbstractTexture.TextureFormat'
        RG32I = ... # type: 'QAbstractTexture.TextureFormat'
        RGB32I = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA32I = ... # type: 'QAbstractTexture.TextureFormat'
        R16F = ... # type: 'QAbstractTexture.TextureFormat'
        RG16F = ... # type: 'QAbstractTexture.TextureFormat'
        RGB16F = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA16F = ... # type: 'QAbstractTexture.TextureFormat'
        R32F = ... # type: 'QAbstractTexture.TextureFormat'
        RG32F = ... # type: 'QAbstractTexture.TextureFormat'
        RGB32F = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA32F = ... # type: 'QAbstractTexture.TextureFormat'
        RGB9E5 = ... # type: 'QAbstractTexture.TextureFormat'
        RG11B10F = ... # type: 'QAbstractTexture.TextureFormat'
        RG3B2 = ... # type: 'QAbstractTexture.TextureFormat'
        R5G6B5 = ... # type: 'QAbstractTexture.TextureFormat'
        RGB5A1 = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA4 = ... # type: 'QAbstractTexture.TextureFormat'
        RGB10A2 = ... # type: 'QAbstractTexture.TextureFormat'
        D16 = ... # type: 'QAbstractTexture.TextureFormat'
        D24 = ... # type: 'QAbstractTexture.TextureFormat'
        D24S8 = ... # type: 'QAbstractTexture.TextureFormat'
        D32 = ... # type: 'QAbstractTexture.TextureFormat'
        D32F = ... # type: 'QAbstractTexture.TextureFormat'
        D32FS8X24 = ... # type: 'QAbstractTexture.TextureFormat'
        RGB_DXT1 = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA_DXT1 = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA_DXT3 = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA_DXT5 = ... # type: 'QAbstractTexture.TextureFormat'
        R_ATI1N_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        R_ATI1N_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RG_ATI2N_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RG_ATI2N_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGB_BP_UNSIGNED_FLOAT = ... # type: 'QAbstractTexture.TextureFormat'
        RGB_BP_SIGNED_FLOAT = ... # type: 'QAbstractTexture.TextureFormat'
        RGB_BP_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        R11_EAC_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        R11_EAC_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RG11_EAC_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RG11_EAC_SNorm = ... # type: 'QAbstractTexture.TextureFormat'
        RGB8_ETC2 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB8_ETC2 = ... # type: 'QAbstractTexture.TextureFormat'
        RGB8_PunchThrough_Alpha1_ETC2 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB8_PunchThrough_Alpha1_ETC2 = ... # type: 'QAbstractTexture.TextureFormat'
        RGBA8_ETC2_EAC = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB8_Alpha8_ETC2_EAC = ... # type: 'QAbstractTexture.TextureFormat'
        RGB8_ETC1 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB8 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB8_Alpha8 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB_DXT1 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB_Alpha_DXT1 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB_Alpha_DXT3 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB_Alpha_DXT5 = ... # type: 'QAbstractTexture.TextureFormat'
        SRGB_BP_UNorm = ... # type: 'QAbstractTexture.TextureFormat'
        DepthFormat = ... # type: 'QAbstractTexture.TextureFormat'
        AlphaFormat = ... # type: 'QAbstractTexture.TextureFormat'
        RGBFormat = ... # type: 'QAbstractTexture.TextureFormat'
        RGBAFormat = ... # type: 'QAbstractTexture.TextureFormat'
        LuminanceFormat = ... # type: 'QAbstractTexture.TextureFormat'
        LuminanceAlphaFormat = ... # type: 'QAbstractTexture.TextureFormat'

        class Target(int): ...
        TargetAutomatic = ... # type: 'QAbstractTexture.Target'
        Target1D = ... # type: 'QAbstractTexture.Target'
        Target1DArray = ... # type: 'QAbstractTexture.Target'
        Target2D = ... # type: 'QAbstractTexture.Target'
        Target2DArray = ... # type: 'QAbstractTexture.Target'
        Target3D = ... # type: 'QAbstractTexture.Target'
        TargetCubeMap = ... # type: 'QAbstractTexture.Target'
        TargetCubeMapArray = ... # type: 'QAbstractTexture.Target'
        Target2DMultisample = ... # type: 'QAbstractTexture.Target'
        Target2DMultisampleArray = ... # type: 'QAbstractTexture.Target'
        TargetRectangle = ... # type: 'QAbstractTexture.Target'
        TargetBuffer = ... # type: 'QAbstractTexture.Target'

        class Status(int): ...
        None = ... # type: 'QAbstractTexture.Status'
        Loading = ... # type: 'QAbstractTexture.Status'
        Ready = ... # type: 'QAbstractTexture.Status'
        Error = ... # type: 'QAbstractTexture.Status'

        @typing.overload
        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...
        @typing.overload
        def __init__(self, target: 'QAbstractTexture.Target', parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def setStatus(self, status: 'QAbstractTexture.Status') -> None: ...
        def samplesChanged(self, samples: int) -> None: ...
        def layersChanged(self, layers: int) -> None: ...
        def comparisonModeChanged(self, comparisonMode: 'QAbstractTexture.ComparisonMode') -> None: ...
        def comparisonFunctionChanged(self, comparisonFunction: 'QAbstractTexture.ComparisonFunction') -> None: ...
        def maximumAnisotropyChanged(self, maximumAnisotropy: float) -> None: ...
        def minificationFilterChanged(self, minificationFilter: 'QAbstractTexture.Filter') -> None: ...
        def magnificationFilterChanged(self, magnificationFilter: 'QAbstractTexture.Filter') -> None: ...
        def depthChanged(self, depth: int) -> None: ...
        def heightChanged(self, height: int) -> None: ...
        def widthChanged(self, width: int) -> None: ...
        def generateMipMapsChanged(self, generateMipMaps: bool) -> None: ...
        def statusChanged(self, status: 'QAbstractTexture.Status') -> None: ...
        def formatChanged(self, format: 'QAbstractTexture.TextureFormat') -> None: ...
        def setSamples(self, samples: int) -> None: ...
        def setLayers(self, layers: int) -> None: ...
        def setComparisonMode(self, mode: 'QAbstractTexture.ComparisonMode') -> None: ...
        def setComparisonFunction(self, function: 'QAbstractTexture.ComparisonFunction') -> None: ...
        def setMaximumAnisotropy(self, anisotropy: float) -> None: ...
        def setMagnificationFilter(self, f: 'QAbstractTexture.Filter') -> None: ...
        def setMinificationFilter(self, f: 'QAbstractTexture.Filter') -> None: ...
        def setDepth(self, depth: int) -> None: ...
        def setHeight(self, height: int) -> None: ...
        def setWidth(self, width: int) -> None: ...
        def setGenerateMipMaps(self, gen: bool) -> None: ...
        def setFormat(self, format: 'QAbstractTexture.TextureFormat') -> None: ...
        def dataGenerator(self) -> typing.Any: ...
        def samples(self) -> int: ...
        def layers(self) -> int: ...
        def depth(self) -> int: ...
        def height(self) -> int: ...
        def width(self) -> int: ...
        def comparisonMode(self) -> 'QAbstractTexture.ComparisonMode': ...
        def comparisonFunction(self) -> 'QAbstractTexture.ComparisonFunction': ...
        def maximumAnisotropy(self) -> float: ...
        def magnificationFilter(self) -> 'QAbstractTexture.Filter': ...
        def minificationFilter(self) -> 'QAbstractTexture.Filter': ...
        def setSize(self, width: int, height: int = ..., depth: int = ...) -> None: ...
        def wrapMode(self) -> 'QTextureWrapMode': ...
        def setWrapMode(self, wrapMode: 'QTextureWrapMode') -> None: ...
        def textureImages(self) -> typing.Any: ...
        def removeTextureImage(self, textureImage: 'QAbstractTextureImage') -> None: ...
        def addTextureImage(self, textureImage: 'QAbstractTextureImage') -> None: ...
        def status(self) -> 'QAbstractTexture.Status': ...
        def generateMipMaps(self) -> bool: ...
        def format(self) -> 'QAbstractTexture.TextureFormat': ...
        def target(self) -> 'QAbstractTexture.Target': ...

    class QAbstractTextureImage(Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def dataGenerator(self) -> typing.Any: ...
        def notifyDataGeneratorChanged(self) -> None: ...
        def faceChanged(self, face: 'QAbstractTexture.CubeMapFace') -> None: ...
        def layerChanged(self, layer: int) -> None: ...
        def mipLevelChanged(self, mipLevel: int) -> None: ...
        def setFace(self, face: 'QAbstractTexture.CubeMapFace') -> None: ...
        def setLayer(self, layer: int) -> None: ...
        def setMipLevel(self, level: int) -> None: ...
        def face(self) -> 'QAbstractTexture.CubeMapFace': ...
        def layer(self) -> int: ...
        def mipLevel(self) -> int: ...

    class QRenderState(Qt3DCore.QNode): ...

    class QAlphaCoverage('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QAlphaTest('QRenderState'):

        class AlphaFunction(int): ...
        Never = ... # type: 'QAlphaTest.AlphaFunction'
        Always = ... # type: 'QAlphaTest.AlphaFunction'
        Less = ... # type: 'QAlphaTest.AlphaFunction'
        LessOrEqual = ... # type: 'QAlphaTest.AlphaFunction'
        Equal = ... # type: 'QAlphaTest.AlphaFunction'
        GreaterOrEqual = ... # type: 'QAlphaTest.AlphaFunction'
        Greater = ... # type: 'QAlphaTest.AlphaFunction'
        NotEqual = ... # type: 'QAlphaTest.AlphaFunction'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def referenceValueChanged(self, referenceValue: float) -> None: ...
        def alphaFunctionChanged(self, alphaFunction: 'QAlphaTest.AlphaFunction') -> None: ...
        def setReferenceValue(self, referenceValue: float) -> None: ...
        def setAlphaFunction(self, alphaFunction: 'QAlphaTest.AlphaFunction') -> None: ...
        def referenceValue(self) -> float: ...
        def alphaFunction(self) -> 'QAlphaTest.AlphaFunction': ...

    class QAttribute(Qt3DCore.QNode):

        class VertexBaseType(int): ...
        Byte = ... # type: 'QAttribute.VertexBaseType'
        UnsignedByte = ... # type: 'QAttribute.VertexBaseType'
        Short = ... # type: 'QAttribute.VertexBaseType'
        UnsignedShort = ... # type: 'QAttribute.VertexBaseType'
        Int = ... # type: 'QAttribute.VertexBaseType'
        UnsignedInt = ... # type: 'QAttribute.VertexBaseType'
        HalfFloat = ... # type: 'QAttribute.VertexBaseType'
        Float = ... # type: 'QAttribute.VertexBaseType'
        Double = ... # type: 'QAttribute.VertexBaseType'

        class AttributeType(int): ...
        VertexAttribute = ... # type: 'QAttribute.AttributeType'
        IndexAttribute = ... # type: 'QAttribute.AttributeType'
        DrawIndirectAttribute = ... # type: 'QAttribute.AttributeType'

        @typing.overload
        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...
        @typing.overload
        def __init__(self, buf: 'QBuffer', vertexBaseType: 'QAttribute.VertexBaseType', vertexSize: int, count: int, offset: int = ..., stride: int = ..., parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...
        @typing.overload
        def __init__(self, buf: 'QBuffer', name: str, vertexBaseType: 'QAttribute.VertexBaseType', vertexSize: int, count: int, offset: int = ..., stride: int = ..., parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def vertexSizeChanged(self, vertexSize: int) -> None: ...
        def vertexBaseTypeChanged(self, vertexBaseType: 'QAttribute.VertexBaseType') -> None: ...
        def attributeTypeChanged(self, attributeType: 'QAttribute.AttributeType') -> None: ...
        def divisorChanged(self, divisor: int) -> None: ...
        def byteOffsetChanged(self, byteOffset: int) -> None: ...
        def byteStrideChanged(self, byteStride: int) -> None: ...
        def countChanged(self, count: int) -> None: ...
        def dataSizeChanged(self, vertexSize: int) -> None: ...
        def dataTypeChanged(self, vertexBaseType: 'QAttribute.VertexBaseType') -> None: ...
        def nameChanged(self, name: str) -> None: ...
        def bufferChanged(self, buffer: 'QBuffer') -> None: ...
        def setVertexSize(self, size: int) -> None: ...
        def setVertexBaseType(self, type: 'QAttribute.VertexBaseType') -> None: ...
        def setAttributeType(self, attributeType: 'QAttribute.AttributeType') -> None: ...
        def setDivisor(self, divisor: int) -> None: ...
        def setByteOffset(self, byteOffset: int) -> None: ...
        def setByteStride(self, byteStride: int) -> None: ...
        def setCount(self, count: int) -> None: ...
        def setDataSize(self, size: int) -> None: ...
        def setDataType(self, type: 'QAttribute.VertexBaseType') -> None: ...
        def setName(self, name: str) -> None: ...
        def setBuffer(self, buffer: 'QBuffer') -> None: ...
        @staticmethod
        def defaultTangentAttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinateAttributeName() -> str: ...
        @staticmethod
        def defaultColorAttributeName() -> str: ...
        @staticmethod
        def defaultNormalAttributeName() -> str: ...
        @staticmethod
        def defaultPositionAttributeName() -> str: ...
        def attributeType(self) -> 'QAttribute.AttributeType': ...
        def divisor(self) -> int: ...
        def byteOffset(self) -> int: ...
        def byteStride(self) -> int: ...
        def count(self) -> int: ...
        def vertexSize(self) -> int: ...
        def vertexBaseType(self) -> 'QAttribute.VertexBaseType': ...
        def name(self) -> str: ...
        def buffer(self) -> 'QBuffer': ...

    class QBlendEquation('QRenderState'):

        class BlendFunction(int): ...
        Add = ... # type: 'QBlendEquation.BlendFunction'
        Subtract = ... # type: 'QBlendEquation.BlendFunction'
        ReverseSubtract = ... # type: 'QBlendEquation.BlendFunction'
        Min = ... # type: 'QBlendEquation.BlendFunction'
        Max = ... # type: 'QBlendEquation.BlendFunction'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def blendFunctionChanged(self, blendFunction: 'QBlendEquation.BlendFunction') -> None: ...
        def setBlendFunction(self, blendFunction: 'QBlendEquation.BlendFunction') -> None: ...
        def blendFunction(self) -> 'QBlendEquation.BlendFunction': ...

    class QBlendEquationArguments('QRenderState'):

        class Blending(int): ...
        Zero = ... # type: 'QBlendEquationArguments.Blending'
        One = ... # type: 'QBlendEquationArguments.Blending'
        SourceColor = ... # type: 'QBlendEquationArguments.Blending'
        SourceAlpha = ... # type: 'QBlendEquationArguments.Blending'
        Source1Alpha = ... # type: 'QBlendEquationArguments.Blending'
        Source1Color = ... # type: 'QBlendEquationArguments.Blending'
        DestinationColor = ... # type: 'QBlendEquationArguments.Blending'
        DestinationAlpha = ... # type: 'QBlendEquationArguments.Blending'
        SourceAlphaSaturate = ... # type: 'QBlendEquationArguments.Blending'
        ConstantColor = ... # type: 'QBlendEquationArguments.Blending'
        ConstantAlpha = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusSourceColor = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusSourceAlpha = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusDestinationAlpha = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusDestinationColor = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusConstantColor = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusConstantAlpha = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusSource1Alpha = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusSource1Color0 = ... # type: 'QBlendEquationArguments.Blending'
        OneMinusSource1Color = ... # type: 'QBlendEquationArguments.Blending'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def bufferIndexChanged(self, index: int) -> None: ...
        def destinationRgbaChanged(self, destinationRgba: 'QBlendEquationArguments.Blending') -> None: ...
        def sourceRgbaChanged(self, sourceRgba: 'QBlendEquationArguments.Blending') -> None: ...
        def destinationAlphaChanged(self, destinationAlpha: 'QBlendEquationArguments.Blending') -> None: ...
        def destinationRgbChanged(self, destinationRgb: 'QBlendEquationArguments.Blending') -> None: ...
        def sourceAlphaChanged(self, sourceAlpha: 'QBlendEquationArguments.Blending') -> None: ...
        def sourceRgbChanged(self, sourceRgb: 'QBlendEquationArguments.Blending') -> None: ...
        def setBufferIndex(self, index: int) -> None: ...
        def setDestinationRgba(self, destinationRgba: 'QBlendEquationArguments.Blending') -> None: ...
        def setSourceRgba(self, sourceRgba: 'QBlendEquationArguments.Blending') -> None: ...
        def setDestinationAlpha(self, destinationAlpha: 'QBlendEquationArguments.Blending') -> None: ...
        def setSourceAlpha(self, sourceAlpha: 'QBlendEquationArguments.Blending') -> None: ...
        def setDestinationRgb(self, destinationRgb: 'QBlendEquationArguments.Blending') -> None: ...
        def setSourceRgb(self, sourceRgb: 'QBlendEquationArguments.Blending') -> None: ...
        def bufferIndex(self) -> int: ...
        def destinationAlpha(self) -> 'QBlendEquationArguments.Blending': ...
        def sourceAlpha(self) -> 'QBlendEquationArguments.Blending': ...
        def destinationRgb(self) -> 'QBlendEquationArguments.Blending': ...
        def sourceRgb(self) -> 'QBlendEquationArguments.Blending': ...

    class QBuffer(Qt3DCore.QNode):

        class AccessType(int): ...
        Write = ... # type: 'QBuffer.AccessType'
        Read = ... # type: 'QBuffer.AccessType'
        ReadWrite = ... # type: 'QBuffer.AccessType'

        class UsageType(int): ...
        StreamDraw = ... # type: 'QBuffer.UsageType'
        StreamRead = ... # type: 'QBuffer.UsageType'
        StreamCopy = ... # type: 'QBuffer.UsageType'
        StaticDraw = ... # type: 'QBuffer.UsageType'
        StaticRead = ... # type: 'QBuffer.UsageType'
        StaticCopy = ... # type: 'QBuffer.UsageType'
        DynamicDraw = ... # type: 'QBuffer.UsageType'
        DynamicRead = ... # type: 'QBuffer.UsageType'
        DynamicCopy = ... # type: 'QBuffer.UsageType'

        class BufferType(int): ...
        VertexBuffer = ... # type: 'QBuffer.BufferType'
        IndexBuffer = ... # type: 'QBuffer.BufferType'
        PixelPackBuffer = ... # type: 'QBuffer.BufferType'
        PixelUnpackBuffer = ... # type: 'QBuffer.BufferType'
        UniformBuffer = ... # type: 'QBuffer.BufferType'
        ShaderStorageBuffer = ... # type: 'QBuffer.BufferType'
        DrawIndirectBuffer = ... # type: 'QBuffer.BufferType'

        def __init__(self, type: 'QBuffer.BufferType' = ..., parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def dataAvailable(self) -> None: ...
        def accessTypeChanged(self, access: 'QBuffer.AccessType') -> None: ...
        def setAccessType(self, access: 'QBuffer.AccessType') -> None: ...
        def accessType(self) -> 'QBuffer.AccessType': ...
        def updateData(self, offset: int, bytes: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def sceneChangeEvent(self, change: typing.Any) -> None: ...
        def syncDataChanged(self, syncData: bool) -> None: ...
        def usageChanged(self, usage: 'QBuffer.UsageType') -> None: ...
        def typeChanged(self, type: 'QBuffer.BufferType') -> None: ...
        def dataChanged(self, bytes: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def setSyncData(self, syncData: bool) -> None: ...
        def setUsage(self, usage: 'QBuffer.UsageType') -> None: ...
        def setType(self, type: 'QBuffer.BufferType') -> None: ...
        def dataGenerator(self) -> typing.Any: ...
        def setDataGenerator(self, functor: typing.Any) -> None: ...
        def data(self) -> QtCore.QByteArray: ...
        def setData(self, bytes: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def isSyncData(self) -> bool: ...
        def type(self) -> 'QBuffer.BufferType': ...
        def usage(self) -> 'QBuffer.UsageType': ...

    class QBufferDataGenerator('QAbstractFunctor'):

        def __call__(self) -> QtCore.QByteArray: ...

    class QCamera(Qt3DCore.QEntity):

        class CameraTranslationOption(int): ...
        TranslateViewCenter = ... # type: 'QCamera.CameraTranslationOption'
        DontTranslateViewCenter = ... # type: 'QCamera.CameraTranslationOption'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def exposureChanged(self, exposure: float) -> None: ...
        def setExposure(self, exposure: float) -> None: ...
        def exposure(self) -> float: ...
        def viewMatrixChanged(self) -> None: ...
        def viewVectorChanged(self, viewVector: QtGui.QVector3D) -> None: ...
        def viewCenterChanged(self, viewCenter: QtGui.QVector3D) -> None: ...
        def upVectorChanged(self, upVector: QtGui.QVector3D) -> None: ...
        def positionChanged(self, position: QtGui.QVector3D) -> None: ...
        def projectionMatrixChanged(self, projectionMatrix: QtGui.QMatrix4x4) -> None: ...
        def topChanged(self, top: float) -> None: ...
        def bottomChanged(self, bottom: float) -> None: ...
        def rightChanged(self, right: float) -> None: ...
        def leftChanged(self, left: float) -> None: ...
        def aspectRatioChanged(self, aspectRatio: float) -> None: ...
        def fieldOfViewChanged(self, fieldOfView: float) -> None: ...
        def farPlaneChanged(self, farPlane: float) -> None: ...
        def nearPlaneChanged(self, nearPlane: float) -> None: ...
        def projectionTypeChanged(self, projectionType: 'QCameraLens.ProjectionType') -> None: ...
        def setViewCenter(self, viewCenter: QtGui.QVector3D) -> None: ...
        def setUpVector(self, upVector: QtGui.QVector3D) -> None: ...
        def setPosition(self, position: QtGui.QVector3D) -> None: ...
        def setProjectionMatrix(self, projectionMatrix: QtGui.QMatrix4x4) -> None: ...
        def setTop(self, top: float) -> None: ...
        def setBottom(self, bottom: float) -> None: ...
        def setRight(self, right: float) -> None: ...
        def setLeft(self, left: float) -> None: ...
        def setAspectRatio(self, aspectRatio: float) -> None: ...
        def setFieldOfView(self, fieldOfView: float) -> None: ...
        def setFarPlane(self, farPlane: float) -> None: ...
        def setNearPlane(self, nearPlane: float) -> None: ...
        def setProjectionType(self, type: 'QCameraLens.ProjectionType') -> None: ...
        def viewMatrix(self) -> QtGui.QMatrix4x4: ...
        def viewVector(self) -> QtGui.QVector3D: ...
        def viewCenter(self) -> QtGui.QVector3D: ...
        def upVector(self) -> QtGui.QVector3D: ...
        def position(self) -> QtGui.QVector3D: ...
        def projectionMatrix(self) -> QtGui.QMatrix4x4: ...
        def top(self) -> float: ...
        def bottom(self) -> float: ...
        def right(self) -> float: ...
        def left(self) -> float: ...
        def aspectRatio(self) -> float: ...
        def fieldOfView(self) -> float: ...
        def farPlane(self) -> float: ...
        def nearPlane(self) -> float: ...
        def projectionType(self) -> 'QCameraLens.ProjectionType': ...
        def rotateAboutViewCenter(self, q: QtGui.QQuaternion) -> None: ...
        def rotate(self, q: QtGui.QQuaternion) -> None: ...
        def rollAboutViewCenter(self, angle: float) -> None: ...
        @typing.overload
        def panAboutViewCenter(self, angle: float) -> None: ...
        @typing.overload
        def panAboutViewCenter(self, angle: float, axis: QtGui.QVector3D) -> None: ...
        def tiltAboutViewCenter(self, angle: float) -> None: ...
        def roll(self, angle: float) -> None: ...
        @typing.overload
        def pan(self, angle: float) -> None: ...
        @typing.overload
        def pan(self, angle: float, axis: QtGui.QVector3D) -> None: ...
        def tilt(self, angle: float) -> None: ...
        def translateWorld(self, vWorld: QtGui.QVector3D, option: 'QCamera.CameraTranslationOption' = ...) -> None: ...
        def translate(self, vLocal: QtGui.QVector3D, option: 'QCamera.CameraTranslationOption' = ...) -> None: ...
        def rotation(self, angle: float, axis: QtGui.QVector3D) -> QtGui.QQuaternion: ...
        def rollRotation(self, angle: float) -> QtGui.QQuaternion: ...
        def panRotation(self, angle: float) -> QtGui.QQuaternion: ...
        def tiltRotation(self, angle: float) -> QtGui.QQuaternion: ...
        def transform(self) -> Qt3DCore.QTransform: ...
        def lens(self) -> 'QCameraLens': ...

    class QCameraLens(Qt3DCore.QComponent):

        class ProjectionType(int): ...
        OrthographicProjection = ... # type: 'QCameraLens.ProjectionType'
        PerspectiveProjection = ... # type: 'QCameraLens.ProjectionType'
        FrustumProjection = ... # type: 'QCameraLens.ProjectionType'
        CustomProjection = ... # type: 'QCameraLens.ProjectionType'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def exposureChanged(self, exposure: float) -> None: ...
        def setExposure(self, exposure: float) -> None: ...
        def exposure(self) -> float: ...
        def projectionMatrixChanged(self, projectionMatrix: QtGui.QMatrix4x4) -> None: ...
        def topChanged(self, top: float) -> None: ...
        def bottomChanged(self, bottom: float) -> None: ...
        def rightChanged(self, right: float) -> None: ...
        def leftChanged(self, left: float) -> None: ...
        def aspectRatioChanged(self, aspectRatio: float) -> None: ...
        def fieldOfViewChanged(self, fieldOfView: float) -> None: ...
        def farPlaneChanged(self, farPlane: float) -> None: ...
        def nearPlaneChanged(self, nearPlane: float) -> None: ...
        def projectionTypeChanged(self, projectionType: 'QCameraLens.ProjectionType') -> None: ...
        def setProjectionMatrix(self, projectionMatrix: QtGui.QMatrix4x4) -> None: ...
        def setTop(self, top: float) -> None: ...
        def setBottom(self, bottom: float) -> None: ...
        def setRight(self, right: float) -> None: ...
        def setLeft(self, left: float) -> None: ...
        def setAspectRatio(self, aspectRatio: float) -> None: ...
        def setFieldOfView(self, fieldOfView: float) -> None: ...
        def setFarPlane(self, farPlane: float) -> None: ...
        def setNearPlane(self, nearPlane: float) -> None: ...
        def setProjectionType(self, projectionType: 'QCameraLens.ProjectionType') -> None: ...
        def setPerspectiveProjection(self, fieldOfView: float, aspect: float, nearPlane: float, farPlane: float) -> None: ...
        def setFrustumProjection(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
        def setOrthographicProjection(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
        def projectionMatrix(self) -> QtGui.QMatrix4x4: ...
        def top(self) -> float: ...
        def bottom(self) -> float: ...
        def right(self) -> float: ...
        def left(self) -> float: ...
        def aspectRatio(self) -> float: ...
        def fieldOfView(self) -> float: ...
        def farPlane(self) -> float: ...
        def nearPlane(self) -> float: ...
        def projectionType(self) -> 'QCameraLens.ProjectionType': ...

    class QFrameGraphNode(Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def parentFrameGraphNode(self) -> 'QFrameGraphNode': ...

    class QCameraSelector('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def cameraChanged(self, camera: Qt3DCore.QEntity) -> None: ...
        def setCamera(self, camera: Qt3DCore.QEntity) -> None: ...
        def camera(self) -> Qt3DCore.QEntity: ...

    class QClearBuffers('QFrameGraphNode'):

        class BufferType(int): ...
        None = ... # type: 'QClearBuffers.BufferType'
        ColorBuffer = ... # type: 'QClearBuffers.BufferType'
        DepthBuffer = ... # type: 'QClearBuffers.BufferType'
        StencilBuffer = ... # type: 'QClearBuffers.BufferType'
        DepthStencilBuffer = ... # type: 'QClearBuffers.BufferType'
        ColorDepthBuffer = ... # type: 'QClearBuffers.BufferType'
        ColorDepthStencilBuffer = ... # type: 'QClearBuffers.BufferType'
        AllBuffers = ... # type: 'QClearBuffers.BufferType'

        class BufferTypeFlags(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QClearBuffers.BufferTypeFlags', 'QClearBuffers.BufferType']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QClearBuffers.BufferTypeFlags') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QClearBuffers.BufferTypeFlags': ...
            def __int__(self) -> int: ...

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def colorBufferChanged(self, buffer: 'QRenderTargetOutput') -> None: ...
        def clearStencilValueChanged(self, clearStencilValue: int) -> None: ...
        def clearDepthValueChanged(self, clearDepthValue: float) -> None: ...
        def clearColorChanged(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def buffersChanged(self, buffers: 'QClearBuffers.BufferType') -> None: ...
        def setColorBuffer(self, buffer: 'QRenderTargetOutput') -> None: ...
        def setClearStencilValue(self, clearStencilValue: int) -> None: ...
        def setClearDepthValue(self, clearDepthValue: float) -> None: ...
        def setClearColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
        def setBuffers(self, buffers: 'QClearBuffers.BufferType') -> None: ...
        def colorBuffer(self) -> 'QRenderTargetOutput': ...
        def clearStencilValue(self) -> int: ...
        def clearDepthValue(self) -> float: ...
        def clearColor(self) -> QtGui.QColor: ...
        def buffers(self) -> 'QClearBuffers.BufferType': ...

    class QClipPlane('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def distanceChanged(self, distance: float) -> None: ...
        def normalChanged(self, normal: QtGui.QVector3D) -> None: ...
        def planeIndexChanged(self, planeIndex: int) -> None: ...
        def setDistance(self, a0: float) -> None: ...
        def setNormal(self, a0: QtGui.QVector3D) -> None: ...
        def setPlaneIndex(self, a0: int) -> None: ...
        def distance(self) -> float: ...
        def normal(self) -> QtGui.QVector3D: ...
        def planeIndex(self) -> int: ...

    class QComputeCommand(Qt3DCore.QComponent):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def workGroupZChanged(self) -> None: ...
        def workGroupYChanged(self) -> None: ...
        def workGroupXChanged(self) -> None: ...
        def setWorkGroupZ(self, workGroupZ: int) -> None: ...
        def setWorkGroupY(self, workGroupY: int) -> None: ...
        def setWorkGroupX(self, workGroupX: int) -> None: ...
        def workGroupZ(self) -> int: ...
        def workGroupY(self) -> int: ...
        def workGroupX(self) -> int: ...

    class QColorMask('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def alphaMaskedChanged(self, alphaMasked: bool) -> None: ...
        def blueMaskedChanged(self, blueMasked: bool) -> None: ...
        def greenMaskedChanged(self, greenMasked: bool) -> None: ...
        def redMaskedChanged(self, redMasked: bool) -> None: ...
        def setAlphaMasked(self, alphaMasked: bool) -> None: ...
        def setBlueMasked(self, blueMasked: bool) -> None: ...
        def setGreenMasked(self, greenMasked: bool) -> None: ...
        def setRedMasked(self, redMasked: bool) -> None: ...
        def isAlphaMasked(self) -> bool: ...
        def isBlueMasked(self) -> bool: ...
        def isGreenMasked(self) -> bool: ...
        def isRedMasked(self) -> bool: ...

    class QCullFace('QRenderState'):

        class CullingMode(int): ...
        NoCulling = ... # type: 'QCullFace.CullingMode'
        Front = ... # type: 'QCullFace.CullingMode'
        Back = ... # type: 'QCullFace.CullingMode'
        FrontAndBack = ... # type: 'QCullFace.CullingMode'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def modeChanged(self, mode: 'QCullFace.CullingMode') -> None: ...
        def setMode(self, mode: 'QCullFace.CullingMode') -> None: ...
        def mode(self) -> 'QCullFace.CullingMode': ...

    class QDepthTest('QRenderState'):

        class DepthFunction(int): ...
        Never = ... # type: 'QDepthTest.DepthFunction'
        Always = ... # type: 'QDepthTest.DepthFunction'
        Less = ... # type: 'QDepthTest.DepthFunction'
        LessOrEqual = ... # type: 'QDepthTest.DepthFunction'
        Equal = ... # type: 'QDepthTest.DepthFunction'
        GreaterOrEqual = ... # type: 'QDepthTest.DepthFunction'
        Greater = ... # type: 'QDepthTest.DepthFunction'
        NotEqual = ... # type: 'QDepthTest.DepthFunction'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def depthFunctionChanged(self, depthFunction: 'QDepthTest.DepthFunction') -> None: ...
        def setDepthFunction(self, depthFunction: 'QDepthTest.DepthFunction') -> None: ...
        def depthFunction(self) -> 'QDepthTest.DepthFunction': ...

    class QDirectionalLight('QAbstractLight'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def worldDirectionChanged(self, worldDirection: QtGui.QVector3D) -> None: ...
        def setWorldDirection(self, worldDirection: QtGui.QVector3D) -> None: ...
        def worldDirection(self) -> QtGui.QVector3D: ...

    class QDispatchCompute('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def workGroupZChanged(self) -> None: ...
        def workGroupYChanged(self) -> None: ...
        def workGroupXChanged(self) -> None: ...
        def setWorkGroupZ(self, workGroupZ: int) -> None: ...
        def setWorkGroupY(self, workGroupY: int) -> None: ...
        def setWorkGroupX(self, workGroupX: int) -> None: ...
        def workGroupZ(self) -> int: ...
        def workGroupY(self) -> int: ...
        def workGroupX(self) -> int: ...

    class QDithering('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QEffect(Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def techniques(self) -> typing.Any: ...
        def removeTechnique(self, t: 'QTechnique') -> None: ...
        def addTechnique(self, t: 'QTechnique') -> None: ...
        def parameters(self) -> typing.Any: ...
        def removeParameter(self, parameter: 'QParameter') -> None: ...
        def addParameter(self, parameter: 'QParameter') -> None: ...

    class QEnvironmentLight(Qt3DCore.QComponent):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def specularChanged(self, environmentSpecular: 'QAbstractTexture') -> None: ...
        def irradianceChanged(self, environmentIrradiance: 'QAbstractTexture') -> None: ...
        def setSpecular(self, specular: 'QAbstractTexture') -> None: ...
        def setIrradiance(self, irradiance: 'QAbstractTexture') -> None: ...
        def specular(self) -> 'QAbstractTexture': ...
        def irradiance(self) -> 'QAbstractTexture': ...

    class QFilterKey(Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def valueChanged(self, value: typing.Any) -> None: ...
        def nameChanged(self, name: str) -> None: ...
        def setName(self, customType: str) -> None: ...
        def setValue(self, value: typing.Any) -> None: ...
        def name(self) -> str: ...
        def value(self) -> typing.Any: ...

    class QFrontFace('QRenderState'):

        class WindingDirection(int): ...
        ClockWise = ... # type: 'QFrontFace.WindingDirection'
        CounterClockWise = ... # type: 'QFrontFace.WindingDirection'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def directionChanged(self, direction: 'QFrontFace.WindingDirection') -> None: ...
        def setDirection(self, direction: 'QFrontFace.WindingDirection') -> None: ...
        def direction(self) -> 'QFrontFace.WindingDirection': ...

    class QFrustumCulling('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QGeometry(Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def boundingVolumePositionAttributeChanged(self, boundingVolumePositionAttribute: 'QAttribute') -> None: ...
        def setBoundingVolumePositionAttribute(self, boundingVolumePositionAttribute: 'QAttribute') -> None: ...
        def boundingVolumePositionAttribute(self) -> 'QAttribute': ...
        def removeAttribute(self, attribute: 'QAttribute') -> None: ...
        def addAttribute(self, attribute: 'QAttribute') -> None: ...
        def attributes(self) -> typing.Any: ...

    class QGeometryFactory('QAbstractFunctor'):

        def __call__(self) -> 'QGeometry': ...

    class QGeometryRenderer(Qt3DCore.QComponent):

        class PrimitiveType(int): ...
        Points = ... # type: 'QGeometryRenderer.PrimitiveType'
        Lines = ... # type: 'QGeometryRenderer.PrimitiveType'
        LineLoop = ... # type: 'QGeometryRenderer.PrimitiveType'
        LineStrip = ... # type: 'QGeometryRenderer.PrimitiveType'
        Triangles = ... # type: 'QGeometryRenderer.PrimitiveType'
        TriangleStrip = ... # type: 'QGeometryRenderer.PrimitiveType'
        TriangleFan = ... # type: 'QGeometryRenderer.PrimitiveType'
        LinesAdjacency = ... # type: 'QGeometryRenderer.PrimitiveType'
        TrianglesAdjacency = ... # type: 'QGeometryRenderer.PrimitiveType'
        LineStripAdjacency = ... # type: 'QGeometryRenderer.PrimitiveType'
        TriangleStripAdjacency = ... # type: 'QGeometryRenderer.PrimitiveType'
        Patches = ... # type: 'QGeometryRenderer.PrimitiveType'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def sceneChangeEvent(self, change: typing.Any) -> None: ...
        def primitiveTypeChanged(self, primitiveType: 'QGeometryRenderer.PrimitiveType') -> None: ...
        def geometryChanged(self, geometry: 'QGeometry') -> None: ...
        def primitiveRestartEnabledChanged(self, primitiveRestartEnabled: bool) -> None: ...
        def verticesPerPatchChanged(self, verticesPerPatch: int) -> None: ...
        def restartIndexValueChanged(self, restartIndexValue: int) -> None: ...
        def firstVertexChanged(self, firstVertex: int) -> None: ...
        def firstInstanceChanged(self, firstInstance: int) -> None: ...
        def indexOffsetChanged(self, indexOffset: int) -> None: ...
        def vertexCountChanged(self, vertexCount: int) -> None: ...
        def instanceCountChanged(self, instanceCount: int) -> None: ...
        def setPrimitiveType(self, primitiveType: 'QGeometryRenderer.PrimitiveType') -> None: ...
        def setGeometry(self, geometry: 'QGeometry') -> None: ...
        def setPrimitiveRestartEnabled(self, enabled: bool) -> None: ...
        def setVerticesPerPatch(self, verticesPerPatch: int) -> None: ...
        def setRestartIndexValue(self, index: int) -> None: ...
        def setFirstVertex(self, firstVertex: int) -> None: ...
        def setFirstInstance(self, firstInstance: int) -> None: ...
        def setIndexOffset(self, indexOffset: int) -> None: ...
        def setVertexCount(self, vertexCount: int) -> None: ...
        def setInstanceCount(self, instanceCount: int) -> None: ...
        def setGeometryFactory(self, factory: typing.Any) -> None: ...
        def geometryFactory(self) -> typing.Any: ...
        def primitiveType(self) -> 'QGeometryRenderer.PrimitiveType': ...
        def geometry(self) -> 'QGeometry': ...
        def primitiveRestartEnabled(self) -> bool: ...
        def verticesPerPatch(self) -> int: ...
        def restartIndexValue(self) -> int: ...
        def firstVertex(self) -> int: ...
        def firstInstance(self) -> int: ...
        def indexOffset(self) -> int: ...
        def vertexCount(self) -> int: ...
        def instanceCount(self) -> int: ...

    class QGraphicsApiFilter(QtCore.QObject):

        class OpenGLProfile(int): ...
        NoProfile = ... # type: 'QGraphicsApiFilter.OpenGLProfile'
        CoreProfile = ... # type: 'QGraphicsApiFilter.OpenGLProfile'
        CompatibilityProfile = ... # type: 'QGraphicsApiFilter.OpenGLProfile'

        class Api(int): ...
        OpenGLES = ... # type: 'QGraphicsApiFilter.Api'
        OpenGL = ... # type: 'QGraphicsApiFilter.Api'

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def graphicsApiFilterChanged(self) -> None: ...
        def vendorChanged(self, vendor: str) -> None: ...
        def extensionsChanged(self, extensions: typing.Iterable[str]) -> None: ...
        def majorVersionChanged(self, majorVersion: int) -> None: ...
        def minorVersionChanged(self, minorVersion: int) -> None: ...
        def profileChanged(self, profile: 'QGraphicsApiFilter.OpenGLProfile') -> None: ...
        def apiChanged(self, api: 'QGraphicsApiFilter.Api') -> None: ...
        def setVendor(self, vendor: str) -> None: ...
        def setExtensions(self, extensions: typing.Iterable[str]) -> None: ...
        def setMajorVersion(self, majorVersion: int) -> None: ...
        def setMinorVersion(self, minorVersion: int) -> None: ...
        def setProfile(self, profile: 'QGraphicsApiFilter.OpenGLProfile') -> None: ...
        def setApi(self, api: 'QGraphicsApiFilter.Api') -> None: ...
        def vendor(self) -> str: ...
        def extensions(self) -> typing.List[str]: ...
        def majorVersion(self) -> int: ...
        def minorVersion(self) -> int: ...
        def profile(self) -> 'QGraphicsApiFilter.OpenGLProfile': ...
        def api(self) -> 'QGraphicsApiFilter.Api': ...

    class QLayer(Qt3DCore.QComponent):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QLayerFilter('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def layers(self) -> typing.Any: ...
        def removeLayer(self, layer: 'QLayer') -> None: ...
        def addLayer(self, layer: 'QLayer') -> None: ...

    class QLevelOfDetail(Qt3DCore.QComponent):

        class ThresholdType(int): ...
        DistanceToCameraThreshold = ... # type: 'QLevelOfDetail.ThresholdType'
        ProjectedScreenPixelSizeThreshold = ... # type: 'QLevelOfDetail.ThresholdType'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def sceneChangeEvent(self, change: typing.Any) -> None: ...
        def volumeOverrideChanged(self, volumeOverride: 'QLevelOfDetailBoundingSphere') -> None: ...
        def thresholdsChanged(self, thresholds: typing.Iterable[float]) -> None: ...
        def thresholdTypeChanged(self, thresholdType: 'QLevelOfDetail.ThresholdType') -> None: ...
        def currentIndexChanged(self, currentIndex: int) -> None: ...
        def cameraChanged(self, camera: 'QCamera') -> None: ...
        def setVolumeOverride(self, volumeOverride: 'QLevelOfDetailBoundingSphere') -> None: ...
        def setThresholds(self, thresholds: typing.Iterable[float]) -> None: ...
        def setThresholdType(self, thresholdType: 'QLevelOfDetail.ThresholdType') -> None: ...
        def setCurrentIndex(self, currentIndex: int) -> None: ...
        def setCamera(self, camera: 'QCamera') -> None: ...
        def createBoundingSphere(self, center: QtGui.QVector3D, radius: float) -> 'QLevelOfDetailBoundingSphere': ...
        def volumeOverride(self) -> 'QLevelOfDetailBoundingSphere': ...
        def thresholds(self) -> typing.List[float]: ...
        def thresholdType(self) -> 'QLevelOfDetail.ThresholdType': ...
        def currentIndex(self) -> int: ...
        def camera(self) -> 'QCamera': ...

    class QLevelOfDetailBoundingSphere(sip.simplewrapper):

        @typing.overload
        def __init__(self, center: QtGui.QVector3D = ..., radius: float = ...) -> None: ...
        @typing.overload
        def __init__(self, other: 'QLevelOfDetailBoundingSphere') -> None: ...

        def isEmpty(self) -> bool: ...
        def radius(self) -> float: ...
        def center(self) -> QtGui.QVector3D: ...

    class QLevelOfDetailSwitch('QLevelOfDetail'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def sceneChangeEvent(self, change: typing.Any) -> None: ...

    class QMaterial(Qt3DCore.QComponent):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def effectChanged(self, effect: 'QEffect') -> None: ...
        def setEffect(self, effect: 'QEffect') -> None: ...
        def parameters(self) -> typing.List['QParameter']: ...
        def removeParameter(self, parameter: 'QParameter') -> None: ...
        def addParameter(self, parameter: 'QParameter') -> None: ...
        def effect(self) -> 'QEffect': ...

    class QMemoryBarrier('QFrameGraphNode'):

        class Operation(int): ...
        None = ... # type: 'QMemoryBarrier.Operation'
        VertexAttributeArray = ... # type: 'QMemoryBarrier.Operation'
        ElementArray = ... # type: 'QMemoryBarrier.Operation'
        Uniform = ... # type: 'QMemoryBarrier.Operation'
        TextureFetch = ... # type: 'QMemoryBarrier.Operation'
        ShaderImageAccess = ... # type: 'QMemoryBarrier.Operation'
        Command = ... # type: 'QMemoryBarrier.Operation'
        PixelBuffer = ... # type: 'QMemoryBarrier.Operation'
        TextureUpdate = ... # type: 'QMemoryBarrier.Operation'
        BufferUpdate = ... # type: 'QMemoryBarrier.Operation'
        FrameBuffer = ... # type: 'QMemoryBarrier.Operation'
        TransformFeedback = ... # type: 'QMemoryBarrier.Operation'
        AtomicCounter = ... # type: 'QMemoryBarrier.Operation'
        ShaderStorage = ... # type: 'QMemoryBarrier.Operation'
        QueryBuffer = ... # type: 'QMemoryBarrier.Operation'
        All = ... # type: 'QMemoryBarrier.Operation'

        class Operations(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QMemoryBarrier.Operations', 'QMemoryBarrier.Operation']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QMemoryBarrier.Operations') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QMemoryBarrier.Operations': ...
            def __int__(self) -> int: ...

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def waitOperationsChanged(self, barrierTypes: typing.Union['QMemoryBarrier.Operations', 'QMemoryBarrier.Operation']) -> None: ...
        def setWaitOperations(self, operations: typing.Union['QMemoryBarrier.Operations', 'QMemoryBarrier.Operation']) -> None: ...
        def waitOperations(self) -> 'QMemoryBarrier.Operations': ...

    class QMesh('QGeometryRenderer'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def meshNameChanged(self, meshName: str) -> None: ...
        def sourceChanged(self, source: QtCore.QUrl) -> None: ...
        def setMeshName(self, meshName: str) -> None: ...
        def setSource(self, source: QtCore.QUrl) -> None: ...
        def meshName(self) -> str: ...
        def source(self) -> QtCore.QUrl: ...

    class QMultiSampleAntiAliasing('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QNoDepthMask('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QNoDraw('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QObjectPicker(Qt3DCore.QComponent):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def sceneChangeEvent(self, change: typing.Any) -> None: ...
        def containsMouseChanged(self, containsMouse: bool) -> None: ...
        def pressedChanged(self, pressed: bool) -> None: ...
        def dragEnabledChanged(self, dragEnabled: bool) -> None: ...
        def hoverEnabledChanged(self, hoverEnabled: bool) -> None: ...
        def exited(self) -> None: ...
        def entered(self) -> None: ...
        def moved(self, pick: 'QPickEvent') -> None: ...
        def clicked(self, pick: 'QPickEvent') -> None: ...
        def released(self, pick: 'QPickEvent') -> None: ...
        def pressed(self, pick: 'QPickEvent') -> None: ...
        def setDragEnabled(self, dragEnabled: bool) -> None: ...
        def setHoverEnabled(self, hoverEnabled: bool) -> None: ...
        def isPressed(self) -> bool: ...
        def containsMouse(self) -> bool: ...
        def isDragEnabled(self) -> bool: ...
        def isHoverEnabled(self) -> bool: ...

    class QPaintedTextureImage('QAbstractTextureImage'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def paint(self, painter: QtGui.QPainter) -> None: ...
        def sizeChanged(self, size: QtCore.QSize) -> None: ...
        def heightChanged(self, w: int) -> None: ...
        def widthChanged(self, w: int) -> None: ...
        def setSize(self, size: QtCore.QSize) -> None: ...
        def setHeight(self, h: int) -> None: ...
        def setWidth(self, w: int) -> None: ...
        def update(self, rect: QtCore.QRect = ...) -> None: ...
        def size(self) -> QtCore.QSize: ...
        def height(self) -> int: ...
        def width(self) -> int: ...

    class QParameter(Qt3DCore.QNode):

        @typing.overload
        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...
        @typing.overload
        def __init__(self, name: str, value: typing.Any, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...
        @typing.overload
        def __init__(self, name: str, texture: 'QAbstractTexture', parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def nameChanged(self, name: str) -> None: ...
        def valueChanged(self, value: typing.Any) -> None: ...
        def setValue(self, dv: typing.Any) -> None: ...
        def setName(self, name: str) -> None: ...
        def value(self) -> typing.Any: ...
        def name(self) -> str: ...

    class QPickEvent(QtCore.QObject):

        class Modifiers(int): ...
        NoModifier = ... # type: 'QPickEvent.Modifiers'
        ShiftModifier = ... # type: 'QPickEvent.Modifiers'
        ControlModifier = ... # type: 'QPickEvent.Modifiers'
        AltModifier = ... # type: 'QPickEvent.Modifiers'
        MetaModifier = ... # type: 'QPickEvent.Modifiers'
        KeypadModifier = ... # type: 'QPickEvent.Modifiers'

        class Buttons(int): ...
        LeftButton = ... # type: 'QPickEvent.Buttons'
        RightButton = ... # type: 'QPickEvent.Buttons'
        MiddleButton = ... # type: 'QPickEvent.Buttons'
        BackButton = ... # type: 'QPickEvent.Buttons'
        NoButton = ... # type: 'QPickEvent.Buttons'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, position: typing.Union[QtCore.QPointF, QtCore.QPoint], worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float) -> None: ...
        @typing.overload
        def __init__(self, position: typing.Union[QtCore.QPointF, QtCore.QPoint], worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float, button: 'QPickEvent.Buttons', buttons: int, modifiers: int) -> None: ...

        def modifiers(self) -> int: ...
        def buttons(self) -> int: ...
        def button(self) -> 'QPickEvent.Buttons': ...
        def acceptedChanged(self, accepted: bool) -> None: ...
        def setAccepted(self, accepted: bool) -> None: ...
        def localIntersection(self) -> QtGui.QVector3D: ...
        def worldIntersection(self) -> QtGui.QVector3D: ...
        def distance(self) -> float: ...
        def position(self) -> QtCore.QPointF: ...
        def isAccepted(self) -> bool: ...

    class QPickingSettings(Qt3DCore.QNode):

        class FaceOrientationPickingMode(int): ...
        FrontFace = ... # type: 'QPickingSettings.FaceOrientationPickingMode'
        BackFace = ... # type: 'QPickingSettings.FaceOrientationPickingMode'
        FrontAndBackFace = ... # type: 'QPickingSettings.FaceOrientationPickingMode'

        class PickResultMode(int): ...
        NearestPick = ... # type: 'QPickingSettings.PickResultMode'
        AllPicks = ... # type: 'QPickingSettings.PickResultMode'

        class PickMethod(int): ...
        BoundingVolumePicking = ... # type: 'QPickingSettings.PickMethod'
        TrianglePicking = ... # type: 'QPickingSettings.PickMethod'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def faceOrientationPickingModeChanged(self, faceOrientationPickingMode: 'QPickingSettings.FaceOrientationPickingMode') -> None: ...
        def setFaceOrientationPickingMode(self, faceOrientationPickingMode: 'QPickingSettings.FaceOrientationPickingMode') -> None: ...
        def faceOrientationPickingMode(self) -> 'QPickingSettings.FaceOrientationPickingMode': ...
        def pickResultModeChanged(self, pickResult: 'QPickingSettings.PickResultMode') -> None: ...
        def pickMethodChanged(self, pickMethod: 'QPickingSettings.PickMethod') -> None: ...
        def setPickResultMode(self, pickResultMode: 'QPickingSettings.PickResultMode') -> None: ...
        def setPickMethod(self, pickMethod: 'QPickingSettings.PickMethod') -> None: ...
        def pickResultMode(self) -> 'QPickingSettings.PickResultMode': ...
        def pickMethod(self) -> 'QPickingSettings.PickMethod': ...

    class QPickTriangleEvent('QPickEvent'):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, position: typing.Union[QtCore.QPointF, QtCore.QPoint], worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float, triangleIndex: int, vertex1Index: int, vertex2Index: int, vertex3Index: int) -> None: ...
        @typing.overload
        def __init__(self, position: typing.Union[QtCore.QPointF, QtCore.QPoint], worldIntersection: QtGui.QVector3D, localIntersection: QtGui.QVector3D, distance: float, triangleIndex: int, vertex1Index: int, vertex2Index: int, vertex3Index: int, button: 'QPickEvent.Buttons', buttons: int, modifiers: int, uvw: QtGui.QVector3D) -> None: ...

        def uvw(self) -> QtGui.QVector3D: ...
        def vertex3Index(self) -> int: ...
        def vertex2Index(self) -> int: ...
        def vertex1Index(self) -> int: ...
        def triangleIndex(self) -> int: ...

    class QPointLight('QAbstractLight'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def quadraticAttenuationChanged(self, quadraticAttenuation: float) -> None: ...
        def linearAttenuationChanged(self, linearAttenuation: float) -> None: ...
        def constantAttenuationChanged(self, constantAttenuation: float) -> None: ...
        def setQuadraticAttenuation(self, value: float) -> None: ...
        def setLinearAttenuation(self, value: float) -> None: ...
        def setConstantAttenuation(self, value: float) -> None: ...
        def quadraticAttenuation(self) -> float: ...
        def linearAttenuation(self) -> float: ...
        def constantAttenuation(self) -> float: ...

    class QPointSize('QRenderState'):

        class SizeMode(int): ...
        Fixed = ... # type: 'QPointSize.SizeMode'
        Programmable = ... # type: 'QPointSize.SizeMode'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def valueChanged(self, value: float) -> None: ...
        def sizeModeChanged(self, sizeMode: 'QPointSize.SizeMode') -> None: ...
        def setValue(self, value: float) -> None: ...
        def setSizeMode(self, sizeMode: 'QPointSize.SizeMode') -> None: ...
        def value(self) -> float: ...
        def sizeMode(self) -> 'QPointSize.SizeMode': ...

    class QPolygonOffset('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def depthStepsChanged(self, depthSteps: float) -> None: ...
        def scaleFactorChanged(self, scaleFactor: float) -> None: ...
        def setDepthSteps(self, depthSteps: float) -> None: ...
        def setScaleFactor(self, scaleFactor: float) -> None: ...
        def depthSteps(self) -> float: ...
        def scaleFactor(self) -> float: ...

    class Render(sip.simplewrapper): ...

    class QRenderAspect(Qt3DCore.QAbstractAspect):

        class RenderType(int): ...
        Synchronous = ... # type: 'QRenderAspect.RenderType'
        Threaded = ... # type: 'QRenderAspect.RenderType'

        @typing.overload
        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, type: 'QRenderAspect.RenderType', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    class QRenderCaptureReply(QtCore.QObject):

        def completed(self) -> None: ...
        def saveImage(self, fileName: str) -> bool: ...
        def completeChanged(self, isComplete: bool) -> None: ...
        def saveToFile(self, fileName: str) -> None: ...
        def isComplete(self) -> bool: ...
        def captureId(self) -> int: ...
        def image(self) -> QtGui.QImage: ...

    class QRenderCapture('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def sceneChangeEvent(self, change: typing.Any) -> None: ...
        @typing.overload
        def requestCapture(self, captureId: int) -> 'QRenderCaptureReply': ...
        @typing.overload
        def requestCapture(self) -> 'QRenderCaptureReply': ...

    class QRenderPass(Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def shaderProgramChanged(self, shaderProgram: 'QShaderProgram') -> None: ...
        def setShaderProgram(self, shaderProgram: 'QShaderProgram') -> None: ...
        def parameters(self) -> typing.List['QParameter']: ...
        def removeParameter(self, p: 'QParameter') -> None: ...
        def addParameter(self, p: 'QParameter') -> None: ...
        def renderStates(self) -> typing.Any: ...
        def removeRenderState(self, state: 'QRenderState') -> None: ...
        def addRenderState(self, state: 'QRenderState') -> None: ...
        def filterKeys(self) -> typing.Any: ...
        def removeFilterKey(self, filterKey: 'QFilterKey') -> None: ...
        def addFilterKey(self, filterKey: 'QFilterKey') -> None: ...
        def shaderProgram(self) -> 'QShaderProgram': ...

    class QRenderPassFilter('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def parameters(self) -> typing.List['QParameter']: ...
        def removeParameter(self, parameter: 'QParameter') -> None: ...
        def addParameter(self, parameter: 'QParameter') -> None: ...
        def removeMatch(self, filterKey: 'QFilterKey') -> None: ...
        def addMatch(self, filterKey: 'QFilterKey') -> None: ...
        def matchAny(self) -> typing.List['QFilterKey']: ...

    class QRenderSettings(Qt3DCore.QComponent):

        class RenderPolicy(int): ...
        OnDemand = ... # type: 'QRenderSettings.RenderPolicy'
        Always = ... # type: 'QRenderSettings.RenderPolicy'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def renderPolicyChanged(self, renderPolicy: 'QRenderSettings.RenderPolicy') -> None: ...
        def activeFrameGraphChanged(self, activeFrameGraph: 'QFrameGraphNode') -> None: ...
        def setRenderPolicy(self, renderPolicy: 'QRenderSettings.RenderPolicy') -> None: ...
        def setActiveFrameGraph(self, activeFrameGraph: 'QFrameGraphNode') -> None: ...
        def renderPolicy(self) -> 'QRenderSettings.RenderPolicy': ...
        def activeFrameGraph(self) -> 'QFrameGraphNode': ...
        def pickingSettings(self) -> 'QPickingSettings': ...

    class QRenderStateSet('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def renderStates(self) -> typing.List['QRenderState']: ...
        def removeRenderState(self, state: 'QRenderState') -> None: ...
        def addRenderState(self, state: 'QRenderState') -> None: ...

    class QRenderSurfaceSelector('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def surfacePixelRatioChanged(self, ratio: float) -> None: ...
        def externalRenderTargetSizeChanged(self, size: QtCore.QSize) -> None: ...
        def surfaceChanged(self, surface: QtCore.QObject) -> None: ...
        def setSurfacePixelRatio(self, ratio: float) -> None: ...
        def setSurface(self, surfaceObject: QtCore.QObject) -> None: ...
        def setExternalRenderTargetSize(self, size: QtCore.QSize) -> None: ...
        def surfacePixelRatio(self) -> float: ...
        def externalRenderTargetSize(self) -> QtCore.QSize: ...
        def surface(self) -> QtCore.QObject: ...

    class QRenderTarget(Qt3DCore.QComponent):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def outputs(self) -> typing.Any: ...
        def removeOutput(self, output: 'QRenderTargetOutput') -> None: ...
        def addOutput(self, output: 'QRenderTargetOutput') -> None: ...

    class QRenderTargetOutput(Qt3DCore.QNode):

        class AttachmentPoint(int): ...
        Color0 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color1 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color2 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color3 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color4 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color5 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color6 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color7 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color8 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color9 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color10 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color11 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color12 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color13 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color14 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Color15 = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Depth = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        Stencil = ... # type: 'QRenderTargetOutput.AttachmentPoint'
        DepthStencil = ... # type: 'QRenderTargetOutput.AttachmentPoint'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def faceChanged(self, face: 'QAbstractTexture.CubeMapFace') -> None: ...
        def layerChanged(self, layer: int) -> None: ...
        def mipLevelChanged(self, mipLevel: int) -> None: ...
        def textureChanged(self, texture: 'QAbstractTexture') -> None: ...
        def attachmentPointChanged(self, attachmentPoint: 'QRenderTargetOutput.AttachmentPoint') -> None: ...
        def setFace(self, face: 'QAbstractTexture.CubeMapFace') -> None: ...
        def setLayer(self, layer: int) -> None: ...
        def setMipLevel(self, level: int) -> None: ...
        def setTexture(self, texture: 'QAbstractTexture') -> None: ...
        def setAttachmentPoint(self, attachmentPoint: 'QRenderTargetOutput.AttachmentPoint') -> None: ...
        def face(self) -> 'QAbstractTexture.CubeMapFace': ...
        def layer(self) -> int: ...
        def mipLevel(self) -> int: ...
        def texture(self) -> 'QAbstractTexture': ...
        def attachmentPoint(self) -> 'QRenderTargetOutput.AttachmentPoint': ...

    class QRenderTargetSelector('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def targetChanged(self, target: 'QRenderTarget') -> None: ...
        def setTarget(self, target: 'QRenderTarget') -> None: ...
        def target(self) -> 'QRenderTarget': ...
        def outputs(self) -> typing.List[QRenderTargetOutput.AttachmentPoint]: ...

    class QSceneLoader(Qt3DCore.QComponent):

        class ComponentType(int): ...
        UnknownComponent = ... # type: 'QSceneLoader.ComponentType'
        GeometryRendererComponent = ... # type: 'QSceneLoader.ComponentType'
        TransformComponent = ... # type: 'QSceneLoader.ComponentType'
        MaterialComponent = ... # type: 'QSceneLoader.ComponentType'
        LightComponent = ... # type: 'QSceneLoader.ComponentType'
        CameraLensComponent = ... # type: 'QSceneLoader.ComponentType'

        class Status(int): ...
        None = ... # type: 'QSceneLoader.Status'
        Loading = ... # type: 'QSceneLoader.Status'
        Ready = ... # type: 'QSceneLoader.Status'
        Error = ... # type: 'QSceneLoader.Status'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def component(self, entityName: str, componentType: 'QSceneLoader.ComponentType') -> Qt3DCore.QComponent: ...
        def entityNames(self) -> typing.List[str]: ...
        def entity(self, entityName: str) -> Qt3DCore.QEntity: ...
        def statusChanged(self, status: 'QSceneLoader.Status') -> None: ...
        def sourceChanged(self, source: QtCore.QUrl) -> None: ...
        def setSource(self, arg: QtCore.QUrl) -> None: ...
        def status(self) -> 'QSceneLoader.Status': ...
        def source(self) -> QtCore.QUrl: ...
        def sceneChangeEvent(self, change: typing.Any) -> None: ...

    class QScissorTest('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def heightChanged(self, height: int) -> None: ...
        def widthChanged(self, width: int) -> None: ...
        def bottomChanged(self, bottom: int) -> None: ...
        def leftChanged(self, left: int) -> None: ...
        def setHeight(self, height: int) -> None: ...
        def setWidth(self, width: int) -> None: ...
        def setBottom(self, bottom: int) -> None: ...
        def setLeft(self, left: int) -> None: ...
        def height(self) -> int: ...
        def width(self) -> int: ...
        def bottom(self) -> int: ...
        def left(self) -> int: ...

    class QSeamlessCubemap('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class PropertyReaderInterface(sip.simplewrapper):

        def readProperty(self, v: typing.Any) -> typing.Any: ...

    class QShaderData(Qt3DCore.QComponent):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def event(self, event: QtCore.QEvent) -> bool: ...
        def propertyReader(self) -> typing.Any: ...

    class QShaderProgram(Qt3DCore.QNode):

        class Status(int): ...
        NotReady = ... # type: 'QShaderProgram.Status'
        Ready = ... # type: 'QShaderProgram.Status'
        Error = ... # type: 'QShaderProgram.Status'

        class ShaderType(int): ...
        Vertex = ... # type: 'QShaderProgram.ShaderType'
        Fragment = ... # type: 'QShaderProgram.ShaderType'
        TessellationControl = ... # type: 'QShaderProgram.ShaderType'
        TessellationEvaluation = ... # type: 'QShaderProgram.ShaderType'
        Geometry = ... # type: 'QShaderProgram.ShaderType'
        Compute = ... # type: 'QShaderProgram.ShaderType'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def sceneChangeEvent(self, change: typing.Any) -> None: ...
        def statusChanged(self, status: 'QShaderProgram.Status') -> None: ...
        def logChanged(self, log: str) -> None: ...
        def status(self) -> 'QShaderProgram.Status': ...
        def log(self) -> str: ...
        def computeShaderCodeChanged(self, computeShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def fragmentShaderCodeChanged(self, fragmentShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def geometryShaderCodeChanged(self, geometryShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def tessellationEvaluationShaderCodeChanged(self, tessellationEvaluationShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def tessellationControlShaderCodeChanged(self, tessellationControlShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def vertexShaderCodeChanged(self, vertexShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def setComputeShaderCode(self, computeShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def setFragmentShaderCode(self, fragmentShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def setGeometryShaderCode(self, geometryShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def setTessellationEvaluationShaderCode(self, tessellationEvaluationShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def setTessellationControlShaderCode(self, tessellationControlShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def setVertexShaderCode(self, vertexShaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        @staticmethod
        def loadSource(sourceUrl: QtCore.QUrl) -> QtCore.QByteArray: ...
        def shaderCode(self, type: 'QShaderProgram.ShaderType') -> QtCore.QByteArray: ...
        def setShaderCode(self, type: 'QShaderProgram.ShaderType', shaderCode: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def computeShaderCode(self) -> QtCore.QByteArray: ...
        def fragmentShaderCode(self) -> QtCore.QByteArray: ...
        def geometryShaderCode(self) -> QtCore.QByteArray: ...
        def tessellationEvaluationShaderCode(self) -> QtCore.QByteArray: ...
        def tessellationControlShaderCode(self) -> QtCore.QByteArray: ...
        def vertexShaderCode(self) -> QtCore.QByteArray: ...

    class QSortPolicy('QFrameGraphNode'):

        class SortType(int): ...
        StateChangeCost = ... # type: 'QSortPolicy.SortType'
        BackToFront = ... # type: 'QSortPolicy.SortType'
        Material = ... # type: 'QSortPolicy.SortType'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        @typing.overload
        def sortTypesChanged(self, sortTypes: typing.Iterable[QSortPolicy.SortType]) -> None: ...
        @typing.overload
        def sortTypesChanged(self, sortTypes: typing.Iterable[int]) -> None: ...
        @typing.overload
        def setSortTypes(self, sortTypes: typing.Iterable[QSortPolicy.SortType]) -> None: ...
        @typing.overload
        def setSortTypes(self, sortTypesInt: typing.Iterable[int]) -> None: ...
        def sortTypesInt(self) -> typing.List[int]: ...
        def sortTypes(self) -> typing.List[QSortPolicy.SortType]: ...

    class QSpotLight('QAbstractLight'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def cutOffAngleChanged(self, cutOffAngle: float) -> None: ...
        def localDirectionChanged(self, localDirection: QtGui.QVector3D) -> None: ...
        def quadraticAttenuationChanged(self, quadraticAttenuation: float) -> None: ...
        def linearAttenuationChanged(self, linearAttenuation: float) -> None: ...
        def constantAttenuationChanged(self, constantAttenuation: float) -> None: ...
        def setCutOffAngle(self, cutOffAngle: float) -> None: ...
        def setLocalDirection(self, localDirection: QtGui.QVector3D) -> None: ...
        def setQuadraticAttenuation(self, value: float) -> None: ...
        def setLinearAttenuation(self, value: float) -> None: ...
        def setConstantAttenuation(self, value: float) -> None: ...
        def quadraticAttenuation(self) -> float: ...
        def linearAttenuation(self) -> float: ...
        def constantAttenuation(self) -> float: ...
        def cutOffAngle(self) -> float: ...
        def localDirection(self) -> QtGui.QVector3D: ...

    class QStencilMask('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def backOutputMaskChanged(self, backOutputMask: int) -> None: ...
        def frontOutputMaskChanged(self, frontOutputMask: int) -> None: ...
        def setBackOutputMask(self, backOutputMask: int) -> None: ...
        def setFrontOutputMask(self, frontOutputMask: int) -> None: ...
        def backOutputMask(self) -> int: ...
        def frontOutputMask(self) -> int: ...

    class QStencilOperation('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def back(self) -> 'QStencilOperationArguments': ...
        def front(self) -> 'QStencilOperationArguments': ...

    class QStencilOperationArguments(QtCore.QObject):

        class Operation(int): ...
        Zero = ... # type: 'QStencilOperationArguments.Operation'
        Keep = ... # type: 'QStencilOperationArguments.Operation'
        Replace = ... # type: 'QStencilOperationArguments.Operation'
        Increment = ... # type: 'QStencilOperationArguments.Operation'
        Decrement = ... # type: 'QStencilOperationArguments.Operation'
        IncrementWrap = ... # type: 'QStencilOperationArguments.Operation'
        DecrementWrap = ... # type: 'QStencilOperationArguments.Operation'
        Invert = ... # type: 'QStencilOperationArguments.Operation'

        class FaceMode(int): ...
        Front = ... # type: 'QStencilOperationArguments.FaceMode'
        Back = ... # type: 'QStencilOperationArguments.FaceMode'
        FrontAndBack = ... # type: 'QStencilOperationArguments.FaceMode'

        def faceModeChanged(self, faceMode: 'QStencilOperationArguments.FaceMode') -> None: ...
        def allTestsPassOperationChanged(self, stencilDepthPass: 'QStencilOperationArguments.Operation') -> None: ...
        def depthTestFailureOperationChanged(self, depthFail: 'QStencilOperationArguments.Operation') -> None: ...
        def stencilTestFailureOperationChanged(self, stencilFail: 'QStencilOperationArguments.Operation') -> None: ...
        def setAllTestsPassOperation(self, operation: 'QStencilOperationArguments.Operation') -> None: ...
        def setDepthTestFailureOperation(self, operation: 'QStencilOperationArguments.Operation') -> None: ...
        def setStencilTestFailureOperation(self, operation: 'QStencilOperationArguments.Operation') -> None: ...
        def allTestsPassOperation(self) -> 'QStencilOperationArguments.Operation': ...
        def depthTestFailureOperation(self) -> 'QStencilOperationArguments.Operation': ...
        def stencilTestFailureOperation(self) -> 'QStencilOperationArguments.Operation': ...
        def faceMode(self) -> 'QStencilOperationArguments.FaceMode': ...

    class QStencilTest('QRenderState'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def back(self) -> 'QStencilTestArguments': ...
        def front(self) -> 'QStencilTestArguments': ...

    class QStencilTestArguments(QtCore.QObject):

        class StencilFunction(int): ...
        Never = ... # type: 'QStencilTestArguments.StencilFunction'
        Always = ... # type: 'QStencilTestArguments.StencilFunction'
        Less = ... # type: 'QStencilTestArguments.StencilFunction'
        LessOrEqual = ... # type: 'QStencilTestArguments.StencilFunction'
        Equal = ... # type: 'QStencilTestArguments.StencilFunction'
        GreaterOrEqual = ... # type: 'QStencilTestArguments.StencilFunction'
        Greater = ... # type: 'QStencilTestArguments.StencilFunction'
        NotEqual = ... # type: 'QStencilTestArguments.StencilFunction'

        class StencilFaceMode(int): ...
        Front = ... # type: 'QStencilTestArguments.StencilFaceMode'
        Back = ... # type: 'QStencilTestArguments.StencilFaceMode'
        FrontAndBack = ... # type: 'QStencilTestArguments.StencilFaceMode'

        def faceModeChanged(self, faceMode: 'QStencilTestArguments.StencilFaceMode') -> None: ...
        def referenceValueChanged(self, referenceValue: int) -> None: ...
        def stencilFunctionChanged(self, stencilFunction: 'QStencilTestArguments.StencilFunction') -> None: ...
        def comparisonMaskChanged(self, comparisonMask: int) -> None: ...
        def setStencilFunction(self, stencilFunction: 'QStencilTestArguments.StencilFunction') -> None: ...
        def setReferenceValue(self, referenceValue: int) -> None: ...
        def setComparisonMask(self, comparisonMask: int) -> None: ...
        def faceMode(self) -> 'QStencilTestArguments.StencilFaceMode': ...
        def stencilFunction(self) -> 'QStencilTestArguments.StencilFunction': ...
        def referenceValue(self) -> int: ...
        def comparisonMask(self) -> int: ...

    class QTechnique(Qt3DCore.QNode):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def graphicsApiFilter(self) -> 'QGraphicsApiFilter': ...
        def renderPasses(self) -> typing.Any: ...
        def removeRenderPass(self, pass_: 'QRenderPass') -> None: ...
        def addRenderPass(self, pass_: 'QRenderPass') -> None: ...
        def parameters(self) -> typing.List['QParameter']: ...
        def removeParameter(self, p: 'QParameter') -> None: ...
        def addParameter(self, p: 'QParameter') -> None: ...
        def filterKeys(self) -> typing.List['QFilterKey']: ...
        def removeFilterKey(self, filterKey: 'QFilterKey') -> None: ...
        def addFilterKey(self, filterKey: 'QFilterKey') -> None: ...

    class QTechniqueFilter('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def parameters(self) -> typing.List['QParameter']: ...
        def removeParameter(self, p: 'QParameter') -> None: ...
        def addParameter(self, p: 'QParameter') -> None: ...
        def removeMatch(self, filterKey: 'QFilterKey') -> None: ...
        def addMatch(self, filterKey: 'QFilterKey') -> None: ...
        def matchAll(self) -> typing.List['QFilterKey']: ...

    class QTexture1D('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTexture1DArray('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTexture2D('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTexture2DArray('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTexture3D('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTextureCubeMap('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTextureCubeMapArray('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTexture2DMultisample('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTexture2DMultisampleArray('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTextureRectangle('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTextureBuffer('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

    class QTextureLoader('QAbstractTexture'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def mirroredChanged(self, mirrored: bool) -> None: ...
        def setMirrored(self, mirrored: bool) -> None: ...
        def isMirrored(self) -> bool: ...
        def sourceChanged(self, source: QtCore.QUrl) -> None: ...
        def setSource(self, source: QtCore.QUrl) -> None: ...
        def source(self) -> QtCore.QUrl: ...

    class QTextureData(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextureData') -> None: ...

        def addImageData(self, imageData: typing.Any) -> None: ...
        def imageData(self) -> typing.List[QTextureImageData]: ...
        def setComparisonMode(self, comparisonMode: 'QAbstractTexture.ComparisonMode') -> None: ...
        def comparisonMode(self) -> 'QAbstractTexture.ComparisonMode': ...
        def setComparisonFunction(self, comparisonFunction: 'QAbstractTexture.ComparisonFunction') -> None: ...
        def comparisonFunction(self) -> 'QAbstractTexture.ComparisonFunction': ...
        def setWrapModeZ(self, wrapModeZ: 'QTextureWrapMode.WrapMode') -> None: ...
        def wrapModeZ(self) -> 'QTextureWrapMode.WrapMode': ...
        def setWrapModeY(self, wrapModeY: 'QTextureWrapMode.WrapMode') -> None: ...
        def wrapModeY(self) -> 'QTextureWrapMode.WrapMode': ...
        def setWrapModeX(self, wrapModeX: 'QTextureWrapMode.WrapMode') -> None: ...
        def wrapModeX(self) -> 'QTextureWrapMode.WrapMode': ...
        def setMagnificationFilter(self, filter: 'QAbstractTexture.Filter') -> None: ...
        def magnificationFilter(self) -> 'QAbstractTexture.Filter': ...
        def setMinificationFilter(self, filter: 'QAbstractTexture.Filter') -> None: ...
        def minificationFilter(self) -> 'QAbstractTexture.Filter': ...
        def setMaximumAnisotropy(self, maximumAnisotropy: float) -> None: ...
        def maximumAnisotropy(self) -> float: ...
        def setAutoMipMapGenerationEnabled(self, isAutoMipMapGenerationEnabled: bool) -> None: ...
        def isAutoMipMapGenerationEnabled(self) -> bool: ...
        def setLayers(self, layers: int) -> None: ...
        def layers(self) -> int: ...
        def setDepth(self, depth: int) -> None: ...
        def depth(self) -> int: ...
        def setHeight(self, height: int) -> None: ...
        def height(self) -> int: ...
        def setWidth(self, width: int) -> None: ...
        def width(self) -> int: ...
        def setFormat(self, a0: 'QAbstractTexture.TextureFormat') -> None: ...
        def format(self) -> 'QAbstractTexture.TextureFormat': ...
        def setTarget(self, target: 'QAbstractTexture.Target') -> None: ...
        def target(self) -> 'QAbstractTexture.Target': ...

    class QTextureGenerator('QAbstractFunctor'):

        def __call__(self) -> typing.Any: ...

    class QTextureImage('QAbstractTextureImage'):

        class Status(int): ...
        None = ... # type: 'QTextureImage.Status'
        Loading = ... # type: 'QTextureImage.Status'
        Ready = ... # type: 'QTextureImage.Status'
        Error = ... # type: 'QTextureImage.Status'

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def mirroredChanged(self, mirrored: bool) -> None: ...
        def setMirrored(self, mirrored: bool) -> None: ...
        def isMirrored(self) -> bool: ...
        def setStatus(self, status: 'QTextureImage.Status') -> None: ...
        def sceneChangeEvent(self, change: typing.Any) -> None: ...
        def statusChanged(self, status: 'QTextureImage.Status') -> None: ...
        def sourceChanged(self, source: QtCore.QUrl) -> None: ...
        def setSource(self, source: QtCore.QUrl) -> None: ...
        def status(self) -> 'QTextureImage.Status': ...
        def source(self) -> QtCore.QUrl: ...

    class QTextureImageData(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextureImageData') -> None: ...

        def data(self, layer: int = ..., face: int = ..., mipmapLevel: int = ...) -> QtCore.QByteArray: ...
        def setData(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray], blockSize: int, isCompressed: bool = ...) -> None: ...
        def setImage(self, a0: QtGui.QImage) -> None: ...
        def setPixelType(self, pixelType: QtGui.QOpenGLTexture.PixelType) -> None: ...
        def setPixelFormat(self, pixelFormat: QtGui.QOpenGLTexture.PixelFormat) -> None: ...
        def setFormat(self, format: QtGui.QOpenGLTexture.TextureFormat) -> None: ...
        def setTarget(self, target: QtGui.QOpenGLTexture.Target) -> None: ...
        def pixelType(self) -> QtGui.QOpenGLTexture.PixelType: ...
        def pixelFormat(self) -> QtGui.QOpenGLTexture.PixelFormat: ...
        def format(self) -> QtGui.QOpenGLTexture.TextureFormat: ...
        def target(self) -> QtGui.QOpenGLTexture.Target: ...
        def setFaces(self, faces: int) -> None: ...
        def setMipLevels(self, mipLevels: int) -> None: ...
        def setLayers(self, layers: int) -> None: ...
        def setDepth(self, depth: int) -> None: ...
        def setHeight(self, height: int) -> None: ...
        def setWidth(self, width: int) -> None: ...
        def faces(self) -> int: ...
        def mipLevels(self) -> int: ...
        def layers(self) -> int: ...
        def depth(self) -> int: ...
        def height(self) -> int: ...
        def width(self) -> int: ...
        def isCompressed(self) -> bool: ...
        def cleanup(self) -> None: ...

    class QTextureImageDataGenerator('QAbstractFunctor'):

        def __call__(self) -> typing.Any: ...

    class QTextureWrapMode(QtCore.QObject):

        class WrapMode(int): ...
        Repeat = ... # type: 'QTextureWrapMode.WrapMode'
        MirroredRepeat = ... # type: 'QTextureWrapMode.WrapMode'
        ClampToEdge = ... # type: 'QTextureWrapMode.WrapMode'
        ClampToBorder = ... # type: 'QTextureWrapMode.WrapMode'

        @typing.overload
        def __init__(self, wrapMode: 'QTextureWrapMode.WrapMode' = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
        @typing.overload
        def __init__(self, x: 'QTextureWrapMode.WrapMode', y: 'QTextureWrapMode.WrapMode', z: 'QTextureWrapMode.WrapMode', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def zChanged(self, z: 'QTextureWrapMode.WrapMode') -> None: ...
        def yChanged(self, y: 'QTextureWrapMode.WrapMode') -> None: ...
        def xChanged(self, x: 'QTextureWrapMode.WrapMode') -> None: ...
        def setZ(self, z: 'QTextureWrapMode.WrapMode') -> None: ...
        def setY(self, y: 'QTextureWrapMode.WrapMode') -> None: ...
        def setX(self, x: 'QTextureWrapMode.WrapMode') -> None: ...
        def z(self) -> 'QTextureWrapMode.WrapMode': ...
        def y(self) -> 'QTextureWrapMode.WrapMode': ...
        def x(self) -> 'QTextureWrapMode.WrapMode': ...

    class QViewport('QFrameGraphNode'):

        def __init__(self, parent: typing.Optional[Qt3DCore.QNode] = ...) -> None: ...

        def gammaChanged(self, gamma: float) -> None: ...
        def setGamma(self, gamma: float) -> None: ...
        def gamma(self) -> float: ...
        def normalizedRectChanged(self, normalizedRect: QtCore.QRectF) -> None: ...
        def setNormalizedRect(self, normalizedRect: QtCore.QRectF) -> None: ...
        def normalizedRect(self) -> QtCore.QRectF: ...
