#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   Issue #350 is still open: on Windows, the code here causes it to link
   with PYTHON36.DLL (for example) instead of PYTHON3.DLL.  A fix was
   attempted in 164e526a5515 and 14ce6985e1c3, but reverted: virtualenv
   does not make PYTHON3.DLL available, and so the "correctly" compiled
   version would not run inside a virtualenv.  We will re-apply the fix
   after virtualenv has been fixed for some time.  For explanation, see
   issue #355.  For a workaround if you want PYTHON3.DLL and don't worry
   about virtualenv, see issue #350.  See also 'py_limited_api' in
   setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  include <pyconfig.h>
#  if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG)
#    define Py_LIMITED_API
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <sodium.h>
/* Copyright 2020 Donald Stufft and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef SODIUM_LIBRARY_MINIMAL
static const int PYNACL_HAS_CRYPTO_CORE_ED25519 = 0;

size_t (*crypto_core_ed25519_bytes)() = NULL;
size_t (*crypto_core_ed25519_scalarbytes)(void) = NULL;
size_t (*crypto_core_ed25519_nonreducedscalarbytes)(void) = NULL;

int (*crypto_core_ed25519_is_valid_point)(const unsigned char *) = NULL;
int (*crypto_core_ed25519_add)(unsigned char *, const unsigned char *, const unsigned char *) = NULL;
int (*crypto_core_ed25519_sub)(unsigned char *, const unsigned char *, const unsigned char *) = NULL;

int (*crypto_core_ed25519_scalar_invert)(unsigned char *, const unsigned char *) = NULL;
void (*crypto_core_ed25519_scalar_negate)(unsigned char *, const unsigned char *) = NULL;
void (*crypto_core_ed25519_scalar_complement)(unsigned char *, const unsigned char *) = NULL;
void (*crypto_core_ed25519_scalar_add)(unsigned char *, const unsigned char *,
                                       const unsigned char *) = NULL;
void (*crypto_core_ed25519_scalar_sub)(unsigned char *, const unsigned char *,
                                       const unsigned char *) = NULL;
void (*crypto_core_ed25519_scalar_mul)(unsigned char *, const unsigned char *,
                                       const unsigned char *) = NULL;
void (*crypto_core_ed25519_scalar_reduce)(unsigned char *, const unsigned char *) = NULL;
#else
static const int PYNACL_HAS_CRYPTO_CORE_ED25519 = 1;
#endif

/* Copyright 2020 Donald Stufft and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef SODIUM_LIBRARY_MINIMAL
static const int PYNACL_HAS_CRYPTO_PWHASH_SCRYPTSALSA208SHA256 = 0;

size_t (*crypto_pwhash_scryptsalsa208sha256_saltbytes)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_strbytes)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_bytes_min)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_bytes_max)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_passwd_min)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_passwd_max)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_opslimit_min)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_opslimit_max)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_memlimit_min)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_memlimit_max)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_opslimit_interactive)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_memlimit_interactive)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive)(void) = NULL;
size_t (*crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive)(void) = NULL;

const char *(*crypto_pwhash_scryptsalsa208sha256_strprefix)(void) = NULL;

int (*crypto_pwhash_scryptsalsa208sha256_ll)(const uint8_t * const,
                                              size_t,
                                              const uint8_t *,
                                              size_t,
                                              uint64_t, uint32_t, uint32_t,
                                              uint8_t *, size_t) = NULL;

/* #define crypto_pwhash_scryptsalsa208sha256_STRBYTES 102 */
int (*crypto_pwhash_scryptsalsa208sha256_str)(char [102],
                                               const char * const,
                                               unsigned long long,
                                               unsigned long long,
                                               size_t) = NULL;

int (*crypto_pwhash_scryptsalsa208sha256_str_verify)(const char [102],
                                                      const char * const,
                                                      unsigned long long) = NULL;
#else
static const int PYNACL_HAS_CRYPTO_PWHASH_SCRYPTSALSA208SHA256 = 1;
#endif

/* Copyright 2020 Donald Stufft and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef SODIUM_LIBRARY_MINIMAL
static const int PYNACL_HAS_CRYPTO_SCALARMULT_ED25519 = 0;

size_t (*crypto_scalarmult_ed25519_bytes)() = NULL;
size_t (*crypto_scalarmult_ed25519_scalarbytes)() = NULL;

int (*crypto_scalarmult_ed25519)(unsigned char *, const unsigned char *, const unsigned char *) = NULL;
int (*crypto_scalarmult_ed25519_base)(unsigned char *, const unsigned char *) = NULL;
int (*crypto_scalarmult_ed25519_noclamp)(unsigned char *, const unsigned char *,
                                         const unsigned char *) = NULL;
int (*crypto_scalarmult_ed25519_base_noclamp)(unsigned char *, const unsigned char *) = NULL;
#else
static const int PYNACL_HAS_CRYPTO_SCALARMULT_ED25519 = 1;
#endif

/* Copyright 2020 Donald Stufft and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef SODIUM_LIBRARY_MINIMAL
static const int PYNACL_HAS_CRYPTO_SHORTHASH_SIPHASHX24 = 0;

size_t (*crypto_shorthash_siphashx24_bytes)() = NULL;
size_t (*crypto_shorthash_siphashx24_keybytes)() = NULL;

int (*crypto_shorthash_siphashx24)(unsigned char *, const unsigned char *,
                                   unsigned long long, const unsigned char *) = NULL;
#else
static const int PYNACL_HAS_CRYPTO_SHORTHASH_SIPHASHX24 = 1;
#endif


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // char const *()(void)
/*  1 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(char *, char const *, unsigned long long, unsigned long long, size_t)
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 263), // char *
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 263), // char const *
/*  5 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12), // unsigned long long
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/*  7 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(char *, char const *, unsigned long long, unsigned long long, size_t, int)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 11 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 12 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 13 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 15 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(char const *, char const *, unsigned long long)
/* 18 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 20 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(char const *, unsigned long long, size_t)
/* 23 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 24 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 25 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(size_t *, unsigned char *, size_t, size_t, size_t)
/* 28 */ _CFFI_OP(_CFFI_OP_POINTER, 7), // size_t *
/* 29 */ _CFFI_OP(_CFFI_OP_POINTER, 195), // unsigned char *
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 31 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 32 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(size_t *, unsigned char const *, size_t, size_t)
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 36 */ _CFFI_OP(_CFFI_OP_POINTER, 195), // unsigned char const *
/* 37 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 38 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(uint8_t const *, size_t, uint8_t const *, size_t, uint64_t, uint32_t, uint32_t, uint8_t *, size_t)
/* 41 */ _CFFI_OP(_CFFI_OP_POINTER, 264), // uint8_t const *
/* 42 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 44 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 45 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 46 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 47 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 264), // uint8_t *
/* 49 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, size_t, unsigned char const *, unsigned long long, unsigned char const *, size_t, unsigned char const *, unsigned char const *)
/* 52 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 53 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 55 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 57 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char *)
/* 62 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 63 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char *, unsigned char const *)
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char *, unsigned char const *, unsigned char const *, unsigned char const *)
/* 71 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 72 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *)
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned char const *)
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned long long)
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 89 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned long long, unsigned char const *)
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 94 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned long long, unsigned char const *, unsigned char const *)
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 100 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned long long, unsigned char const *, unsigned char const *, unsigned char const *)
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 107 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned long long *, unsigned char *, unsigned char const *, unsigned long long, unsigned char const *, unsigned long long, unsigned char const *, unsigned char const *)
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 114 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // unsigned long long *
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 117 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 118 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 119 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned long long *, unsigned char const *, unsigned long long, unsigned char const *)
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 114),
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 127 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned long long *, unsigned char const *, unsigned long long, unsigned char const *, unsigned long long, unsigned char const *, unsigned char const *, unsigned char const *)
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 114),
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 134 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 136 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 137 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 139 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned long long, char const *, unsigned long long, unsigned char const *, unsigned long long, size_t, int)
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 143 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 144 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 145 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 147 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 148 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 149 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char const *)
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *)
/* 155 */ _CFFI_OP(_CFFI_OP_POINTER, 265), // void *
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 157 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, size_t)
/* 158 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 159 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char *, size_t)
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 163 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 165 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char *, unsigned char const *)
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 169 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char *, unsigned long long *, unsigned char *, unsigned char const *, unsigned long long, unsigned char const *, unsigned long long)
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 114),
/* 175 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 177 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 179 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char *, unsigned long long *, unsigned char const *)
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 114),
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char *, unsigned long long *, unsigned char const *, unsigned long long, unsigned char const *, unsigned long long, unsigned char)
/* 188 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 114),
/* 191 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 192 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 193 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 194 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 195 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char const *, size_t, size_t, unsigned char const *, unsigned char const *)
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 199 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 201 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char const *, unsigned char const *)
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 207 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char const *, unsigned long long)
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 212 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 213 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void const *, void const *, size_t)
/* 216 */ _CFFI_OP(_CFFI_OP_POINTER, 265), // void const *
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 216),
/* 218 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void)
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // size_t()(void)
/* 223 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 224 */ _CFFI_OP(_CFFI_OP_FUNCTION, 195), // unsigned char()(void)
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(unsigned char *)
/* 227 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 228 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 229 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(unsigned char *, size_t)
/* 230 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 231 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(unsigned char *, unsigned char *, size_t)
/* 234 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 236 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(unsigned char *, unsigned char const *)
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 240 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 242 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(unsigned char *, unsigned char const *, unsigned char const *)
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 244 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 245 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 246 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(unsigned char *, unsigned long long)
/* 248 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 249 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 250 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(void *)
/* 252 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 253 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(void *, size_t)
/* 255 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 256 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 257 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 258 */ _CFFI_OP(_CFFI_OP_FUNCTION, 265), // void()(void *, size_t, unsigned char const *)
/* 259 */ _CFFI_OP(_CFFI_OP_NOOP, 155),
/* 260 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 261 */ _CFFI_OP(_CFFI_OP_NOOP, 36),
/* 262 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 263 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 264 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 265 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_PYNACL_HAS_CRYPTO_CORE_ED25519(unsigned long long *o)
{
  int n = (PYNACL_HAS_CRYPTO_CORE_ED25519) <= 0;
  *o = (unsigned long long)((PYNACL_HAS_CRYPTO_CORE_ED25519) | 0);  /* check that PYNACL_HAS_CRYPTO_CORE_ED25519 is an integer */
  return n;
}

static int _cffi_const_PYNACL_HAS_CRYPTO_PWHASH_SCRYPTSALSA208SHA256(unsigned long long *o)
{
  int n = (PYNACL_HAS_CRYPTO_PWHASH_SCRYPTSALSA208SHA256) <= 0;
  *o = (unsigned long long)((PYNACL_HAS_CRYPTO_PWHASH_SCRYPTSALSA208SHA256) | 0);  /* check that PYNACL_HAS_CRYPTO_PWHASH_SCRYPTSALSA208SHA256 is an integer */
  return n;
}

static int _cffi_const_PYNACL_HAS_CRYPTO_SCALARMULT_ED25519(unsigned long long *o)
{
  int n = (PYNACL_HAS_CRYPTO_SCALARMULT_ED25519) <= 0;
  *o = (unsigned long long)((PYNACL_HAS_CRYPTO_SCALARMULT_ED25519) | 0);  /* check that PYNACL_HAS_CRYPTO_SCALARMULT_ED25519 is an integer */
  return n;
}

static int _cffi_const_PYNACL_HAS_CRYPTO_SHORTHASH_SIPHASHX24(unsigned long long *o)
{
  int n = (PYNACL_HAS_CRYPTO_SHORTHASH_SIPHASHX24) <= 0;
  *o = (unsigned long long)((PYNACL_HAS_CRYPTO_SHORTHASH_SIPHASHX24) | 0);  /* check that PYNACL_HAS_CRYPTO_SHORTHASH_SIPHASHX24 is an integer */
  return n;
}

static size_t _cffi_d_crypto_aead_chacha20poly1305_abytes(void)
{
  return crypto_aead_chacha20poly1305_abytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_abytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_abytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_abytes _cffi_d_crypto_aead_chacha20poly1305_abytes
#endif

static int _cffi_d_crypto_aead_chacha20poly1305_decrypt(unsigned char * x0, unsigned long long * x1, unsigned char * x2, unsigned char const * x3, unsigned long long x4, unsigned char const * x5, unsigned long long x6, unsigned char const * x7, unsigned char const * x8)
{
  return crypto_aead_chacha20poly1305_decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_decrypt(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char * x2;
  unsigned char const * x3;
  unsigned long long x4;
  unsigned char const * x5;
  unsigned long long x6;
  unsigned char const * x7;
  unsigned char const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "crypto_aead_chacha20poly1305_decrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned long long);
  if (x4 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, unsigned long long);
  if (x6 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_decrypt _cffi_d_crypto_aead_chacha20poly1305_decrypt
#endif

static int _cffi_d_crypto_aead_chacha20poly1305_encrypt(unsigned char * x0, unsigned long long * x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4, unsigned long long x5, unsigned char const * x6, unsigned char const * x7, unsigned char const * x8)
{
  return crypto_aead_chacha20poly1305_encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_encrypt(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  unsigned long long x5;
  unsigned char const * x6;
  unsigned char const * x7;
  unsigned char const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "crypto_aead_chacha20poly1305_encrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned long long);
  if (x5 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_encrypt _cffi_d_crypto_aead_chacha20poly1305_encrypt
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_ietf_abytes(void)
{
  return crypto_aead_chacha20poly1305_ietf_abytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_ietf_abytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_ietf_abytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_ietf_abytes _cffi_d_crypto_aead_chacha20poly1305_ietf_abytes
#endif

static int _cffi_d_crypto_aead_chacha20poly1305_ietf_decrypt(unsigned char * x0, unsigned long long * x1, unsigned char * x2, unsigned char const * x3, unsigned long long x4, unsigned char const * x5, unsigned long long x6, unsigned char const * x7, unsigned char const * x8)
{
  return crypto_aead_chacha20poly1305_ietf_decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_ietf_decrypt(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char * x2;
  unsigned char const * x3;
  unsigned long long x4;
  unsigned char const * x5;
  unsigned long long x6;
  unsigned char const * x7;
  unsigned char const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "crypto_aead_chacha20poly1305_ietf_decrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned long long);
  if (x4 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, unsigned long long);
  if (x6 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_ietf_decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_ietf_decrypt _cffi_d_crypto_aead_chacha20poly1305_ietf_decrypt
#endif

static int _cffi_d_crypto_aead_chacha20poly1305_ietf_encrypt(unsigned char * x0, unsigned long long * x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4, unsigned long long x5, unsigned char const * x6, unsigned char const * x7, unsigned char const * x8)
{
  return crypto_aead_chacha20poly1305_ietf_encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_ietf_encrypt(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  unsigned long long x5;
  unsigned char const * x6;
  unsigned char const * x7;
  unsigned char const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "crypto_aead_chacha20poly1305_ietf_encrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned long long);
  if (x5 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_ietf_encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_ietf_encrypt _cffi_d_crypto_aead_chacha20poly1305_ietf_encrypt
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_ietf_keybytes(void)
{
  return crypto_aead_chacha20poly1305_ietf_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_ietf_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_ietf_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_ietf_keybytes _cffi_d_crypto_aead_chacha20poly1305_ietf_keybytes
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_ietf_messagebytes_max(void)
{
  return crypto_aead_chacha20poly1305_ietf_messagebytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_ietf_messagebytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_ietf_messagebytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_ietf_messagebytes_max _cffi_d_crypto_aead_chacha20poly1305_ietf_messagebytes_max
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_ietf_npubbytes(void)
{
  return crypto_aead_chacha20poly1305_ietf_npubbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_ietf_npubbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_ietf_npubbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_ietf_npubbytes _cffi_d_crypto_aead_chacha20poly1305_ietf_npubbytes
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_ietf_nsecbytes(void)
{
  return crypto_aead_chacha20poly1305_ietf_nsecbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_ietf_nsecbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_ietf_nsecbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_ietf_nsecbytes _cffi_d_crypto_aead_chacha20poly1305_ietf_nsecbytes
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_keybytes(void)
{
  return crypto_aead_chacha20poly1305_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_keybytes _cffi_d_crypto_aead_chacha20poly1305_keybytes
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_messagebytes_max(void)
{
  return crypto_aead_chacha20poly1305_messagebytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_messagebytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_messagebytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_messagebytes_max _cffi_d_crypto_aead_chacha20poly1305_messagebytes_max
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_npubbytes(void)
{
  return crypto_aead_chacha20poly1305_npubbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_npubbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_npubbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_npubbytes _cffi_d_crypto_aead_chacha20poly1305_npubbytes
#endif

static size_t _cffi_d_crypto_aead_chacha20poly1305_nsecbytes(void)
{
  return crypto_aead_chacha20poly1305_nsecbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_chacha20poly1305_nsecbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_chacha20poly1305_nsecbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_chacha20poly1305_nsecbytes _cffi_d_crypto_aead_chacha20poly1305_nsecbytes
#endif

static size_t _cffi_d_crypto_aead_xchacha20poly1305_ietf_abytes(void)
{
  return crypto_aead_xchacha20poly1305_ietf_abytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_xchacha20poly1305_ietf_abytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_xchacha20poly1305_ietf_abytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_xchacha20poly1305_ietf_abytes _cffi_d_crypto_aead_xchacha20poly1305_ietf_abytes
#endif

static int _cffi_d_crypto_aead_xchacha20poly1305_ietf_decrypt(unsigned char * x0, unsigned long long * x1, unsigned char * x2, unsigned char const * x3, unsigned long long x4, unsigned char const * x5, unsigned long long x6, unsigned char const * x7, unsigned char const * x8)
{
  return crypto_aead_xchacha20poly1305_ietf_decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_xchacha20poly1305_ietf_decrypt(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char * x2;
  unsigned char const * x3;
  unsigned long long x4;
  unsigned char const * x5;
  unsigned long long x6;
  unsigned char const * x7;
  unsigned char const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "crypto_aead_xchacha20poly1305_ietf_decrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned long long);
  if (x4 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, unsigned long long);
  if (x6 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_xchacha20poly1305_ietf_decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_xchacha20poly1305_ietf_decrypt _cffi_d_crypto_aead_xchacha20poly1305_ietf_decrypt
#endif

static int _cffi_d_crypto_aead_xchacha20poly1305_ietf_encrypt(unsigned char * x0, unsigned long long * x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4, unsigned long long x5, unsigned char const * x6, unsigned char const * x7, unsigned char const * x8)
{
  return crypto_aead_xchacha20poly1305_ietf_encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_xchacha20poly1305_ietf_encrypt(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  unsigned long long x5;
  unsigned char const * x6;
  unsigned char const * x7;
  unsigned char const * x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "crypto_aead_xchacha20poly1305_ietf_encrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned long long);
  if (x5 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg8, (char **)&x8);
  if (datasize != 0) {
    x8 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg8, (char **)&x8,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_xchacha20poly1305_ietf_encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_xchacha20poly1305_ietf_encrypt _cffi_d_crypto_aead_xchacha20poly1305_ietf_encrypt
#endif

static size_t _cffi_d_crypto_aead_xchacha20poly1305_ietf_keybytes(void)
{
  return crypto_aead_xchacha20poly1305_ietf_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_xchacha20poly1305_ietf_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_xchacha20poly1305_ietf_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_xchacha20poly1305_ietf_keybytes _cffi_d_crypto_aead_xchacha20poly1305_ietf_keybytes
#endif

static size_t _cffi_d_crypto_aead_xchacha20poly1305_ietf_messagebytes_max(void)
{
  return crypto_aead_xchacha20poly1305_ietf_messagebytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_xchacha20poly1305_ietf_messagebytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_xchacha20poly1305_ietf_messagebytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_xchacha20poly1305_ietf_messagebytes_max _cffi_d_crypto_aead_xchacha20poly1305_ietf_messagebytes_max
#endif

static size_t _cffi_d_crypto_aead_xchacha20poly1305_ietf_npubbytes(void)
{
  return crypto_aead_xchacha20poly1305_ietf_npubbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_xchacha20poly1305_ietf_npubbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_xchacha20poly1305_ietf_npubbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_xchacha20poly1305_ietf_npubbytes _cffi_d_crypto_aead_xchacha20poly1305_ietf_npubbytes
#endif

static size_t _cffi_d_crypto_aead_xchacha20poly1305_ietf_nsecbytes(void)
{
  return crypto_aead_xchacha20poly1305_ietf_nsecbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_aead_xchacha20poly1305_ietf_nsecbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_aead_xchacha20poly1305_ietf_nsecbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_aead_xchacha20poly1305_ietf_nsecbytes _cffi_d_crypto_aead_xchacha20poly1305_ietf_nsecbytes
#endif

static int _cffi_d_crypto_box(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4, unsigned char const * x5)
{
  return crypto_box(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  unsigned char const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "crypto_box", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box _cffi_d_crypto_box
#endif

static int _cffi_d_crypto_box_afternm(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_box_afternm(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_afternm(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_box_afternm", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_afternm(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_afternm _cffi_d_crypto_box_afternm
#endif

static int _cffi_d_crypto_box_beforenm(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_box_beforenm(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_beforenm(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_box_beforenm", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_beforenm(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_beforenm _cffi_d_crypto_box_beforenm
#endif

static size_t _cffi_d_crypto_box_beforenmbytes(void)
{
  return crypto_box_beforenmbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_beforenmbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_beforenmbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_beforenmbytes _cffi_d_crypto_box_beforenmbytes
#endif

static size_t _cffi_d_crypto_box_boxzerobytes(void)
{
  return crypto_box_boxzerobytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_boxzerobytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_boxzerobytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_boxzerobytes _cffi_d_crypto_box_boxzerobytes
#endif

static int _cffi_d_crypto_box_keypair(unsigned char * x0, unsigned char * x1)
{
  return crypto_box_keypair(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_box_keypair", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_keypair(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_keypair _cffi_d_crypto_box_keypair
#endif

static size_t _cffi_d_crypto_box_noncebytes(void)
{
  return crypto_box_noncebytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_noncebytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_noncebytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_noncebytes _cffi_d_crypto_box_noncebytes
#endif

static int _cffi_d_crypto_box_open(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4, unsigned char const * x5)
{
  return crypto_box_open(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_open(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  unsigned char const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "crypto_box_open", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_open(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_open _cffi_d_crypto_box_open
#endif

static int _cffi_d_crypto_box_open_afternm(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_box_open_afternm(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_open_afternm(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_box_open_afternm", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_open_afternm(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_open_afternm _cffi_d_crypto_box_open_afternm
#endif

static size_t _cffi_d_crypto_box_publickeybytes(void)
{
  return crypto_box_publickeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_publickeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_publickeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_publickeybytes _cffi_d_crypto_box_publickeybytes
#endif

static int _cffi_d_crypto_box_seal(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3)
{
  return crypto_box_seal(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_seal(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "crypto_box_seal", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_seal(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_seal _cffi_d_crypto_box_seal
#endif

static int _cffi_d_crypto_box_seal_open(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_box_seal_open(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_seal_open(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_box_seal_open", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_seal_open(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_seal_open _cffi_d_crypto_box_seal_open
#endif

static size_t _cffi_d_crypto_box_sealbytes(void)
{
  return crypto_box_sealbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_sealbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_sealbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_sealbytes _cffi_d_crypto_box_sealbytes
#endif

static size_t _cffi_d_crypto_box_secretkeybytes(void)
{
  return crypto_box_secretkeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_secretkeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_secretkeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_secretkeybytes _cffi_d_crypto_box_secretkeybytes
#endif

static int _cffi_d_crypto_box_seed_keypair(unsigned char * x0, unsigned char * x1, unsigned char const * x2)
{
  return crypto_box_seed_keypair(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_seed_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_box_seed_keypair", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_seed_keypair(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_seed_keypair _cffi_d_crypto_box_seed_keypair
#endif

static size_t _cffi_d_crypto_box_seedbytes(void)
{
  return crypto_box_seedbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_seedbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_seedbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_seedbytes _cffi_d_crypto_box_seedbytes
#endif

static size_t _cffi_d_crypto_box_zerobytes(void)
{
  return crypto_box_zerobytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_zerobytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_zerobytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_box_zerobytes _cffi_d_crypto_box_zerobytes
#endif

static int _cffi_d_crypto_core_ed25519_add(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_core_ed25519_add(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_add(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_add", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_core_ed25519_add(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_core_ed25519_add _cffi_d_crypto_core_ed25519_add
#endif

static size_t _cffi_d_crypto_core_ed25519_bytes(void)
{
  return crypto_core_ed25519_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_core_ed25519_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_core_ed25519_bytes _cffi_d_crypto_core_ed25519_bytes
#endif

static int _cffi_d_crypto_core_ed25519_is_valid_point(unsigned char const * x0)
{
  return crypto_core_ed25519_is_valid_point(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_is_valid_point(PyObject *self, PyObject *arg0)
{
  unsigned char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_core_ed25519_is_valid_point(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_core_ed25519_is_valid_point _cffi_d_crypto_core_ed25519_is_valid_point
#endif

static size_t _cffi_d_crypto_core_ed25519_nonreducedscalarbytes(void)
{
  return crypto_core_ed25519_nonreducedscalarbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_nonreducedscalarbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_core_ed25519_nonreducedscalarbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_core_ed25519_nonreducedscalarbytes _cffi_d_crypto_core_ed25519_nonreducedscalarbytes
#endif

static void _cffi_d_crypto_core_ed25519_scalar_add(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  crypto_core_ed25519_scalar_add(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_scalar_add(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_scalar_add", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { crypto_core_ed25519_scalar_add(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_crypto_core_ed25519_scalar_add _cffi_d_crypto_core_ed25519_scalar_add
#endif

static void _cffi_d_crypto_core_ed25519_scalar_complement(unsigned char * x0, unsigned char const * x1)
{
  crypto_core_ed25519_scalar_complement(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_scalar_complement(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_scalar_complement", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { crypto_core_ed25519_scalar_complement(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_crypto_core_ed25519_scalar_complement _cffi_d_crypto_core_ed25519_scalar_complement
#endif

static int _cffi_d_crypto_core_ed25519_scalar_invert(unsigned char * x0, unsigned char const * x1)
{
  return crypto_core_ed25519_scalar_invert(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_scalar_invert(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_scalar_invert", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_core_ed25519_scalar_invert(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_core_ed25519_scalar_invert _cffi_d_crypto_core_ed25519_scalar_invert
#endif

static void _cffi_d_crypto_core_ed25519_scalar_mul(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  crypto_core_ed25519_scalar_mul(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_scalar_mul(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_scalar_mul", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { crypto_core_ed25519_scalar_mul(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_crypto_core_ed25519_scalar_mul _cffi_d_crypto_core_ed25519_scalar_mul
#endif

static void _cffi_d_crypto_core_ed25519_scalar_negate(unsigned char * x0, unsigned char const * x1)
{
  crypto_core_ed25519_scalar_negate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_scalar_negate(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_scalar_negate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { crypto_core_ed25519_scalar_negate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_crypto_core_ed25519_scalar_negate _cffi_d_crypto_core_ed25519_scalar_negate
#endif

static void _cffi_d_crypto_core_ed25519_scalar_reduce(unsigned char * x0, unsigned char const * x1)
{
  crypto_core_ed25519_scalar_reduce(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_scalar_reduce(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_scalar_reduce", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { crypto_core_ed25519_scalar_reduce(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_crypto_core_ed25519_scalar_reduce _cffi_d_crypto_core_ed25519_scalar_reduce
#endif

static void _cffi_d_crypto_core_ed25519_scalar_sub(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  crypto_core_ed25519_scalar_sub(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_scalar_sub(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_scalar_sub", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { crypto_core_ed25519_scalar_sub(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_crypto_core_ed25519_scalar_sub _cffi_d_crypto_core_ed25519_scalar_sub
#endif

static size_t _cffi_d_crypto_core_ed25519_scalarbytes(void)
{
  return crypto_core_ed25519_scalarbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_scalarbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_core_ed25519_scalarbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_core_ed25519_scalarbytes _cffi_d_crypto_core_ed25519_scalarbytes
#endif

static int _cffi_d_crypto_core_ed25519_sub(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_core_ed25519_sub(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_core_ed25519_sub(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_core_ed25519_sub", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_core_ed25519_sub(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_core_ed25519_sub _cffi_d_crypto_core_ed25519_sub
#endif

static size_t _cffi_d_crypto_generichash_blake2b_bytes(void)
{
  return crypto_generichash_blake2b_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_bytes _cffi_d_crypto_generichash_blake2b_bytes
#endif

static size_t _cffi_d_crypto_generichash_blake2b_bytes_max(void)
{
  return crypto_generichash_blake2b_bytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_bytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_bytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_bytes_max _cffi_d_crypto_generichash_blake2b_bytes_max
#endif

static size_t _cffi_d_crypto_generichash_blake2b_bytes_min(void)
{
  return crypto_generichash_blake2b_bytes_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_bytes_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_bytes_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_bytes_min _cffi_d_crypto_generichash_blake2b_bytes_min
#endif

static int _cffi_d_crypto_generichash_blake2b_final(void * x0, unsigned char * x1, size_t x2)
{
  return crypto_generichash_blake2b_final(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_final(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_generichash_blake2b_final", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_final(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_final _cffi_d_crypto_generichash_blake2b_final
#endif

static int _cffi_d_crypto_generichash_blake2b_init_salt_personal(void * x0, unsigned char const * x1, size_t x2, size_t x3, unsigned char const * x4, unsigned char const * x5)
{
  return crypto_generichash_blake2b_init_salt_personal(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_init_salt_personal(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char const * x1;
  size_t x2;
  size_t x3;
  unsigned char const * x4;
  unsigned char const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "crypto_generichash_blake2b_init_salt_personal", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_init_salt_personal(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_init_salt_personal _cffi_d_crypto_generichash_blake2b_init_salt_personal
#endif

static size_t _cffi_d_crypto_generichash_blake2b_keybytes(void)
{
  return crypto_generichash_blake2b_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_keybytes _cffi_d_crypto_generichash_blake2b_keybytes
#endif

static size_t _cffi_d_crypto_generichash_blake2b_keybytes_max(void)
{
  return crypto_generichash_blake2b_keybytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_keybytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_keybytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_keybytes_max _cffi_d_crypto_generichash_blake2b_keybytes_max
#endif

static size_t _cffi_d_crypto_generichash_blake2b_keybytes_min(void)
{
  return crypto_generichash_blake2b_keybytes_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_keybytes_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_keybytes_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_keybytes_min _cffi_d_crypto_generichash_blake2b_keybytes_min
#endif

static size_t _cffi_d_crypto_generichash_blake2b_personalbytes(void)
{
  return crypto_generichash_blake2b_personalbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_personalbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_personalbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_personalbytes _cffi_d_crypto_generichash_blake2b_personalbytes
#endif

static int _cffi_d_crypto_generichash_blake2b_salt_personal(unsigned char * x0, size_t x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4, size_t x5, unsigned char const * x6, unsigned char const * x7)
{
  return crypto_generichash_blake2b_salt_personal(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_salt_personal(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  size_t x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  size_t x5;
  unsigned char const * x6;
  unsigned char const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "crypto_generichash_blake2b_salt_personal", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_salt_personal(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_salt_personal _cffi_d_crypto_generichash_blake2b_salt_personal
#endif

static size_t _cffi_d_crypto_generichash_blake2b_saltbytes(void)
{
  return crypto_generichash_blake2b_saltbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_saltbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_saltbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_saltbytes _cffi_d_crypto_generichash_blake2b_saltbytes
#endif

static int _cffi_d_crypto_generichash_blake2b_update(void * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_generichash_blake2b_update(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_update(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_generichash_blake2b_update", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_update(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_blake2b_update _cffi_d_crypto_generichash_blake2b_update
#endif

static size_t _cffi_d_crypto_generichash_statebytes(void)
{
  return crypto_generichash_statebytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_statebytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_statebytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_generichash_statebytes _cffi_d_crypto_generichash_statebytes
#endif

static int _cffi_d_crypto_hash(unsigned char * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_hash(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_hash", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_hash _cffi_d_crypto_hash
#endif

static int _cffi_d_crypto_hash_sha256(unsigned char * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_hash_sha256(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash_sha256(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_hash_sha256", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash_sha256(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_hash_sha256 _cffi_d_crypto_hash_sha256
#endif

static size_t _cffi_d_crypto_hash_sha256_bytes(void)
{
  return crypto_hash_sha256_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash_sha256_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash_sha256_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_hash_sha256_bytes _cffi_d_crypto_hash_sha256_bytes
#endif

static int _cffi_d_crypto_hash_sha512(unsigned char * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_hash_sha512(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash_sha512(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_hash_sha512", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash_sha512(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_hash_sha512 _cffi_d_crypto_hash_sha512
#endif

static size_t _cffi_d_crypto_hash_sha512_bytes(void)
{
  return crypto_hash_sha512_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash_sha512_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash_sha512_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_hash_sha512_bytes _cffi_d_crypto_hash_sha512_bytes
#endif

static int _cffi_d_crypto_kx_client_session_keys(unsigned char * x0, unsigned char * x1, unsigned char const * x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_kx_client_session_keys(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_kx_client_session_keys(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  unsigned char const * x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_kx_client_session_keys", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_kx_client_session_keys(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_kx_client_session_keys _cffi_d_crypto_kx_client_session_keys
#endif

static int _cffi_d_crypto_kx_keypair(unsigned char * x0, unsigned char * x1)
{
  return crypto_kx_keypair(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_kx_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_kx_keypair", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_kx_keypair(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_kx_keypair _cffi_d_crypto_kx_keypair
#endif

static size_t _cffi_d_crypto_kx_publickeybytes(void)
{
  return crypto_kx_publickeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_kx_publickeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_kx_publickeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_kx_publickeybytes _cffi_d_crypto_kx_publickeybytes
#endif

static size_t _cffi_d_crypto_kx_secretkeybytes(void)
{
  return crypto_kx_secretkeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_kx_secretkeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_kx_secretkeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_kx_secretkeybytes _cffi_d_crypto_kx_secretkeybytes
#endif

static int _cffi_d_crypto_kx_seed_keypair(unsigned char * x0, unsigned char * x1, unsigned char const * x2)
{
  return crypto_kx_seed_keypair(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_kx_seed_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_kx_seed_keypair", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_kx_seed_keypair(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_kx_seed_keypair _cffi_d_crypto_kx_seed_keypair
#endif

static size_t _cffi_d_crypto_kx_seedbytes(void)
{
  return crypto_kx_seedbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_kx_seedbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_kx_seedbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_kx_seedbytes _cffi_d_crypto_kx_seedbytes
#endif

static int _cffi_d_crypto_kx_server_session_keys(unsigned char * x0, unsigned char * x1, unsigned char const * x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_kx_server_session_keys(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_kx_server_session_keys(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  unsigned char const * x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_kx_server_session_keys", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_kx_server_session_keys(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_kx_server_session_keys _cffi_d_crypto_kx_server_session_keys
#endif

static size_t _cffi_d_crypto_kx_sessionkeybytes(void)
{
  return crypto_kx_sessionkeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_kx_sessionkeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_kx_sessionkeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_kx_sessionkeybytes _cffi_d_crypto_kx_sessionkeybytes
#endif

static int _cffi_d_crypto_pwhash(unsigned char * x0, unsigned long long x1, char const * x2, unsigned long long x3, unsigned char const * x4, unsigned long long x5, size_t x6, int x7)
{
  return crypto_pwhash(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long x1;
  char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  unsigned long long x5;
  size_t x6;
  int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned long long);
  if (x5 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash _cffi_d_crypto_pwhash
#endif

static int _cffi_d_crypto_pwhash_alg_argon2i13(void)
{
  return crypto_pwhash_alg_argon2i13();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_alg_argon2i13(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_alg_argon2i13(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_alg_argon2i13 _cffi_d_crypto_pwhash_alg_argon2i13
#endif

static int _cffi_d_crypto_pwhash_alg_argon2id13(void)
{
  return crypto_pwhash_alg_argon2id13();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_alg_argon2id13(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_alg_argon2id13(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_alg_argon2id13 _cffi_d_crypto_pwhash_alg_argon2id13
#endif

static int _cffi_d_crypto_pwhash_alg_default(void)
{
  return crypto_pwhash_alg_default();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_alg_default(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_alg_default(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_alg_default _cffi_d_crypto_pwhash_alg_default
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_interactive(void)
{
  return crypto_pwhash_argon2i_memlimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_interactive _cffi_d_crypto_pwhash_argon2i_memlimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_max(void)
{
  return crypto_pwhash_argon2i_memlimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_max _cffi_d_crypto_pwhash_argon2i_memlimit_max
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_min(void)
{
  return crypto_pwhash_argon2i_memlimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_min _cffi_d_crypto_pwhash_argon2i_memlimit_min
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_moderate(void)
{
  return crypto_pwhash_argon2i_memlimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_moderate _cffi_d_crypto_pwhash_argon2i_memlimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_sensitive(void)
{
  return crypto_pwhash_argon2i_memlimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_sensitive _cffi_d_crypto_pwhash_argon2i_memlimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_interactive(void)
{
  return crypto_pwhash_argon2i_opslimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_interactive _cffi_d_crypto_pwhash_argon2i_opslimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_max(void)
{
  return crypto_pwhash_argon2i_opslimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_max _cffi_d_crypto_pwhash_argon2i_opslimit_max
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_min(void)
{
  return crypto_pwhash_argon2i_opslimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_min _cffi_d_crypto_pwhash_argon2i_opslimit_min
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_moderate(void)
{
  return crypto_pwhash_argon2i_opslimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_moderate _cffi_d_crypto_pwhash_argon2i_opslimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_sensitive(void)
{
  return crypto_pwhash_argon2i_opslimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_sensitive _cffi_d_crypto_pwhash_argon2i_opslimit_sensitive
#endif

static char const * _cffi_d_crypto_pwhash_argon2i_strprefix(void)
{
  return crypto_pwhash_argon2i_strprefix();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_strprefix(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_strprefix(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_strprefix _cffi_d_crypto_pwhash_argon2i_strprefix
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_interactive(void)
{
  return crypto_pwhash_argon2id_memlimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_interactive _cffi_d_crypto_pwhash_argon2id_memlimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_max(void)
{
  return crypto_pwhash_argon2id_memlimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_max _cffi_d_crypto_pwhash_argon2id_memlimit_max
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_min(void)
{
  return crypto_pwhash_argon2id_memlimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_min _cffi_d_crypto_pwhash_argon2id_memlimit_min
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_moderate(void)
{
  return crypto_pwhash_argon2id_memlimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_moderate _cffi_d_crypto_pwhash_argon2id_memlimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_sensitive(void)
{
  return crypto_pwhash_argon2id_memlimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_sensitive _cffi_d_crypto_pwhash_argon2id_memlimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_interactive(void)
{
  return crypto_pwhash_argon2id_opslimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_interactive _cffi_d_crypto_pwhash_argon2id_opslimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_max(void)
{
  return crypto_pwhash_argon2id_opslimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_max _cffi_d_crypto_pwhash_argon2id_opslimit_max
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_min(void)
{
  return crypto_pwhash_argon2id_opslimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_min _cffi_d_crypto_pwhash_argon2id_opslimit_min
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_moderate(void)
{
  return crypto_pwhash_argon2id_opslimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_moderate _cffi_d_crypto_pwhash_argon2id_opslimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_sensitive(void)
{
  return crypto_pwhash_argon2id_opslimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_sensitive _cffi_d_crypto_pwhash_argon2id_opslimit_sensitive
#endif

static char const * _cffi_d_crypto_pwhash_argon2id_strprefix(void)
{
  return crypto_pwhash_argon2id_strprefix();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_strprefix(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_strprefix(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_strprefix _cffi_d_crypto_pwhash_argon2id_strprefix
#endif

static size_t _cffi_d_crypto_pwhash_bytes_max(void)
{
  return crypto_pwhash_bytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_bytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_bytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_bytes_max _cffi_d_crypto_pwhash_bytes_max
#endif

static size_t _cffi_d_crypto_pwhash_bytes_min(void)
{
  return crypto_pwhash_bytes_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_bytes_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_bytes_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_bytes_min _cffi_d_crypto_pwhash_bytes_min
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_interactive(void)
{
  return crypto_pwhash_memlimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_interactive _cffi_d_crypto_pwhash_memlimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_max(void)
{
  return crypto_pwhash_memlimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_max _cffi_d_crypto_pwhash_memlimit_max
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_min(void)
{
  return crypto_pwhash_memlimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_min _cffi_d_crypto_pwhash_memlimit_min
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_moderate(void)
{
  return crypto_pwhash_memlimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_moderate _cffi_d_crypto_pwhash_memlimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_sensitive(void)
{
  return crypto_pwhash_memlimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_sensitive _cffi_d_crypto_pwhash_memlimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_interactive(void)
{
  return crypto_pwhash_opslimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_interactive _cffi_d_crypto_pwhash_opslimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_max(void)
{
  return crypto_pwhash_opslimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_max _cffi_d_crypto_pwhash_opslimit_max
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_min(void)
{
  return crypto_pwhash_opslimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_min _cffi_d_crypto_pwhash_opslimit_min
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_moderate(void)
{
  return crypto_pwhash_opslimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_moderate _cffi_d_crypto_pwhash_opslimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_sensitive(void)
{
  return crypto_pwhash_opslimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_sensitive _cffi_d_crypto_pwhash_opslimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_passwd_max(void)
{
  return crypto_pwhash_passwd_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_passwd_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_passwd_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_passwd_max _cffi_d_crypto_pwhash_passwd_max
#endif

static size_t _cffi_d_crypto_pwhash_passwd_min(void)
{
  return crypto_pwhash_passwd_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_passwd_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_passwd_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_passwd_min _cffi_d_crypto_pwhash_passwd_min
#endif

static size_t _cffi_d_crypto_pwhash_saltbytes(void)
{
  return crypto_pwhash_saltbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_saltbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_saltbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_saltbytes _cffi_d_crypto_pwhash_saltbytes
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_max(void)
{
  return crypto_pwhash_scryptsalsa208sha256_bytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_bytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_max _cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_max
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_min(void)
{
  return crypto_pwhash_scryptsalsa208sha256_bytes_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_bytes_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_min _cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_min
#endif

static int _cffi_d_crypto_pwhash_scryptsalsa208sha256_ll(uint8_t const * x0, size_t x1, uint8_t const * x2, size_t x3, uint64_t x4, uint32_t x5, uint32_t x6, uint8_t * x7, size_t x8)
{
  return crypto_pwhash_scryptsalsa208sha256_ll(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_ll(PyObject *self, PyObject *args)
{
  uint8_t const * x0;
  size_t x1;
  uint8_t const * x2;
  size_t x3;
  uint64_t x4;
  uint32_t x5;
  uint32_t x6;
  uint8_t * x7;
  size_t x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_scryptsalsa208sha256_ll", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(41), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x8 = _cffi_to_c_int(arg8, size_t);
  if (x8 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_ll(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_ll _cffi_d_crypto_pwhash_scryptsalsa208sha256_ll
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive(void)
{
  return crypto_pwhash_scryptsalsa208sha256_memlimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_memlimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_max(void)
{
  return crypto_pwhash_scryptsalsa208sha256_memlimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_memlimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_max _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_max
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_min(void)
{
  return crypto_pwhash_scryptsalsa208sha256_memlimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_memlimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_min _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_min
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive(void)
{
  return crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive(void)
{
  return crypto_pwhash_scryptsalsa208sha256_opslimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_opslimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_max(void)
{
  return crypto_pwhash_scryptsalsa208sha256_opslimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_opslimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_max _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_max
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_min(void)
{
  return crypto_pwhash_scryptsalsa208sha256_opslimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_opslimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_min _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_min
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive(void)
{
  return crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_max(void)
{
  return crypto_pwhash_scryptsalsa208sha256_passwd_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_passwd_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_max _cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_max
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_min(void)
{
  return crypto_pwhash_scryptsalsa208sha256_passwd_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_min(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_passwd_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_min _cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_min
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_saltbytes(void)
{
  return crypto_pwhash_scryptsalsa208sha256_saltbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_saltbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_saltbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_saltbytes _cffi_d_crypto_pwhash_scryptsalsa208sha256_saltbytes
#endif

static int _cffi_d_crypto_pwhash_scryptsalsa208sha256_str(char * x0, char const * x1, unsigned long long x2, unsigned long long x3, size_t x4)
{
  return crypto_pwhash_scryptsalsa208sha256_str(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_str(PyObject *self, PyObject *args)
{
  char * x0;
  char const * x1;
  unsigned long long x2;
  unsigned long long x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_scryptsalsa208sha256_str", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_str(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_str _cffi_d_crypto_pwhash_scryptsalsa208sha256_str
#endif

static int _cffi_d_crypto_pwhash_scryptsalsa208sha256_str_verify(char const * x0, char const * x1, unsigned long long x2)
{
  return crypto_pwhash_scryptsalsa208sha256_str_verify(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_str_verify(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_scryptsalsa208sha256_str_verify", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_str_verify(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_str_verify _cffi_d_crypto_pwhash_scryptsalsa208sha256_str_verify
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_strbytes(void)
{
  return crypto_pwhash_scryptsalsa208sha256_strbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_strbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_strbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_strbytes _cffi_d_crypto_pwhash_scryptsalsa208sha256_strbytes
#endif

static char const * _cffi_d_crypto_pwhash_scryptsalsa208sha256_strprefix(void)
{
  return crypto_pwhash_scryptsalsa208sha256_strprefix();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_strprefix(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_strprefix(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(4));
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_strprefix _cffi_d_crypto_pwhash_scryptsalsa208sha256_strprefix
#endif

static int _cffi_d_crypto_pwhash_str_alg(char * x0, char const * x1, unsigned long long x2, unsigned long long x3, size_t x4, int x5)
{
  return crypto_pwhash_str_alg(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_str_alg(PyObject *self, PyObject *args)
{
  char * x0;
  char const * x1;
  unsigned long long x2;
  unsigned long long x3;
  size_t x4;
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_str_alg", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_str_alg(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_str_alg _cffi_d_crypto_pwhash_str_alg
#endif

static int _cffi_d_crypto_pwhash_str_needs_rehash(char const * x0, unsigned long long x1, size_t x2)
{
  return crypto_pwhash_str_needs_rehash(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_str_needs_rehash(PyObject *self, PyObject *args)
{
  char const * x0;
  unsigned long long x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_str_needs_rehash", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_str_needs_rehash(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_str_needs_rehash _cffi_d_crypto_pwhash_str_needs_rehash
#endif

static int _cffi_d_crypto_pwhash_str_verify(char const * x0, char const * x1, unsigned long long x2)
{
  return crypto_pwhash_str_verify(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_str_verify(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_str_verify", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_str_verify(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_str_verify _cffi_d_crypto_pwhash_str_verify
#endif

static size_t _cffi_d_crypto_pwhash_strbytes(void)
{
  return crypto_pwhash_strbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_strbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_strbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_pwhash_strbytes _cffi_d_crypto_pwhash_strbytes
#endif

static int _cffi_d_crypto_scalarmult(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_scalarmult(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_scalarmult", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult _cffi_d_crypto_scalarmult
#endif

static int _cffi_d_crypto_scalarmult_base(unsigned char * x0, unsigned char const * x1)
{
  return crypto_scalarmult_base(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_base(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_scalarmult_base", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_base(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_base _cffi_d_crypto_scalarmult_base
#endif

static size_t _cffi_d_crypto_scalarmult_bytes(void)
{
  return crypto_scalarmult_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_bytes _cffi_d_crypto_scalarmult_bytes
#endif

static int _cffi_d_crypto_scalarmult_ed25519(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_scalarmult_ed25519(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_ed25519(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_scalarmult_ed25519", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_ed25519(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_ed25519 _cffi_d_crypto_scalarmult_ed25519
#endif

static int _cffi_d_crypto_scalarmult_ed25519_base(unsigned char * x0, unsigned char const * x1)
{
  return crypto_scalarmult_ed25519_base(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_ed25519_base(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_scalarmult_ed25519_base", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_ed25519_base(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_ed25519_base _cffi_d_crypto_scalarmult_ed25519_base
#endif

static int _cffi_d_crypto_scalarmult_ed25519_base_noclamp(unsigned char * x0, unsigned char const * x1)
{
  return crypto_scalarmult_ed25519_base_noclamp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_ed25519_base_noclamp(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_scalarmult_ed25519_base_noclamp", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_ed25519_base_noclamp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_ed25519_base_noclamp _cffi_d_crypto_scalarmult_ed25519_base_noclamp
#endif

static size_t _cffi_d_crypto_scalarmult_ed25519_bytes(void)
{
  return crypto_scalarmult_ed25519_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_ed25519_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_ed25519_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_ed25519_bytes _cffi_d_crypto_scalarmult_ed25519_bytes
#endif

static int _cffi_d_crypto_scalarmult_ed25519_noclamp(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_scalarmult_ed25519_noclamp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_ed25519_noclamp(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_scalarmult_ed25519_noclamp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_ed25519_noclamp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_ed25519_noclamp _cffi_d_crypto_scalarmult_ed25519_noclamp
#endif

static size_t _cffi_d_crypto_scalarmult_ed25519_scalarbytes(void)
{
  return crypto_scalarmult_ed25519_scalarbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_ed25519_scalarbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_ed25519_scalarbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_ed25519_scalarbytes _cffi_d_crypto_scalarmult_ed25519_scalarbytes
#endif

static size_t _cffi_d_crypto_scalarmult_scalarbytes(void)
{
  return crypto_scalarmult_scalarbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_scalarbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_scalarbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_scalarmult_scalarbytes _cffi_d_crypto_scalarmult_scalarbytes
#endif

static int _cffi_d_crypto_secretbox(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_secretbox(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_secretbox", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretbox _cffi_d_crypto_secretbox
#endif

static size_t _cffi_d_crypto_secretbox_boxzerobytes(void)
{
  return crypto_secretbox_boxzerobytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_boxzerobytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_boxzerobytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretbox_boxzerobytes _cffi_d_crypto_secretbox_boxzerobytes
#endif

static size_t _cffi_d_crypto_secretbox_keybytes(void)
{
  return crypto_secretbox_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretbox_keybytes _cffi_d_crypto_secretbox_keybytes
#endif

static size_t _cffi_d_crypto_secretbox_macbytes(void)
{
  return crypto_secretbox_macbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_macbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_macbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretbox_macbytes _cffi_d_crypto_secretbox_macbytes
#endif

static size_t _cffi_d_crypto_secretbox_messagebytes_max(void)
{
  return crypto_secretbox_messagebytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_messagebytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_messagebytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretbox_messagebytes_max _cffi_d_crypto_secretbox_messagebytes_max
#endif

static size_t _cffi_d_crypto_secretbox_noncebytes(void)
{
  return crypto_secretbox_noncebytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_noncebytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_noncebytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretbox_noncebytes _cffi_d_crypto_secretbox_noncebytes
#endif

static int _cffi_d_crypto_secretbox_open(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_secretbox_open(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_open(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_secretbox_open", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_open(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretbox_open _cffi_d_crypto_secretbox_open
#endif

static size_t _cffi_d_crypto_secretbox_zerobytes(void)
{
  return crypto_secretbox_zerobytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_zerobytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_zerobytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretbox_zerobytes _cffi_d_crypto_secretbox_zerobytes
#endif

static size_t _cffi_d_crypto_secretstream_xchacha20poly1305_abytes(void)
{
  return crypto_secretstream_xchacha20poly1305_abytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_abytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_abytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_abytes _cffi_d_crypto_secretstream_xchacha20poly1305_abytes
#endif

static size_t _cffi_d_crypto_secretstream_xchacha20poly1305_headerbytes(void)
{
  return crypto_secretstream_xchacha20poly1305_headerbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_headerbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_headerbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_headerbytes _cffi_d_crypto_secretstream_xchacha20poly1305_headerbytes
#endif

static int _cffi_d_crypto_secretstream_xchacha20poly1305_init_pull(void * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_secretstream_xchacha20poly1305_init_pull(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_init_pull(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_secretstream_xchacha20poly1305_init_pull", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_init_pull(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_init_pull _cffi_d_crypto_secretstream_xchacha20poly1305_init_pull
#endif

static int _cffi_d_crypto_secretstream_xchacha20poly1305_init_push(void * x0, unsigned char * x1, unsigned char const * x2)
{
  return crypto_secretstream_xchacha20poly1305_init_push(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_init_push(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_secretstream_xchacha20poly1305_init_push", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_init_push(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_init_push _cffi_d_crypto_secretstream_xchacha20poly1305_init_push
#endif

static size_t _cffi_d_crypto_secretstream_xchacha20poly1305_keybytes(void)
{
  return crypto_secretstream_xchacha20poly1305_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_keybytes _cffi_d_crypto_secretstream_xchacha20poly1305_keybytes
#endif

static void _cffi_d_crypto_secretstream_xchacha20poly1305_keygen(unsigned char * x0)
{
  crypto_secretstream_xchacha20poly1305_keygen(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_keygen(PyObject *self, PyObject *arg0)
{
  unsigned char * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { crypto_secretstream_xchacha20poly1305_keygen(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_keygen _cffi_d_crypto_secretstream_xchacha20poly1305_keygen
#endif

static size_t _cffi_d_crypto_secretstream_xchacha20poly1305_messagebytes_max(void)
{
  return crypto_secretstream_xchacha20poly1305_messagebytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_messagebytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_messagebytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_messagebytes_max _cffi_d_crypto_secretstream_xchacha20poly1305_messagebytes_max
#endif

static int _cffi_d_crypto_secretstream_xchacha20poly1305_pull(void * x0, unsigned char * x1, unsigned long long * x2, unsigned char * x3, unsigned char const * x4, unsigned long long x5, unsigned char const * x6, unsigned long long x7)
{
  return crypto_secretstream_xchacha20poly1305_pull(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_pull(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char * x1;
  unsigned long long * x2;
  unsigned char * x3;
  unsigned char const * x4;
  unsigned long long x5;
  unsigned char const * x6;
  unsigned long long x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "crypto_secretstream_xchacha20poly1305_pull", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned long long);
  if (x5 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, unsigned long long);
  if (x7 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_pull(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_pull _cffi_d_crypto_secretstream_xchacha20poly1305_pull
#endif

static int _cffi_d_crypto_secretstream_xchacha20poly1305_push(void * x0, unsigned char * x1, unsigned long long * x2, unsigned char const * x3, unsigned long long x4, unsigned char const * x5, unsigned long long x6, unsigned char x7)
{
  return crypto_secretstream_xchacha20poly1305_push(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_push(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char * x1;
  unsigned long long * x2;
  unsigned char const * x3;
  unsigned long long x4;
  unsigned char const * x5;
  unsigned long long x6;
  unsigned char x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "crypto_secretstream_xchacha20poly1305_push", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned long long);
  if (x4 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, unsigned long long);
  if (x6 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, unsigned char);
  if (x7 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_push(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_push _cffi_d_crypto_secretstream_xchacha20poly1305_push
#endif

static void _cffi_d_crypto_secretstream_xchacha20poly1305_rekey(void * x0)
{
  crypto_secretstream_xchacha20poly1305_rekey(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_rekey(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { crypto_secretstream_xchacha20poly1305_rekey(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_rekey _cffi_d_crypto_secretstream_xchacha20poly1305_rekey
#endif

static size_t _cffi_d_crypto_secretstream_xchacha20poly1305_statebytes(void)
{
  return crypto_secretstream_xchacha20poly1305_statebytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_statebytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_statebytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_statebytes _cffi_d_crypto_secretstream_xchacha20poly1305_statebytes
#endif

static unsigned char _cffi_d_crypto_secretstream_xchacha20poly1305_tag_final(void)
{
  return crypto_secretstream_xchacha20poly1305_tag_final();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_tag_final(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_tag_final(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_tag_final _cffi_d_crypto_secretstream_xchacha20poly1305_tag_final
#endif

static unsigned char _cffi_d_crypto_secretstream_xchacha20poly1305_tag_message(void)
{
  return crypto_secretstream_xchacha20poly1305_tag_message();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_tag_message(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_tag_message(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_tag_message _cffi_d_crypto_secretstream_xchacha20poly1305_tag_message
#endif

static unsigned char _cffi_d_crypto_secretstream_xchacha20poly1305_tag_push(void)
{
  return crypto_secretstream_xchacha20poly1305_tag_push();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_tag_push(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_tag_push(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_tag_push _cffi_d_crypto_secretstream_xchacha20poly1305_tag_push
#endif

static unsigned char _cffi_d_crypto_secretstream_xchacha20poly1305_tag_rekey(void)
{
  return crypto_secretstream_xchacha20poly1305_tag_rekey();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretstream_xchacha20poly1305_tag_rekey(PyObject *self, PyObject *noarg)
{
  unsigned char result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretstream_xchacha20poly1305_tag_rekey(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  return pyresult;
}
#else
#  define _cffi_f_crypto_secretstream_xchacha20poly1305_tag_rekey _cffi_d_crypto_secretstream_xchacha20poly1305_tag_rekey
#endif

static int _cffi_d_crypto_shorthash_siphash24(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3)
{
  return crypto_shorthash_siphash24(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphash24(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "crypto_shorthash_siphash24", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphash24(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_shorthash_siphash24 _cffi_d_crypto_shorthash_siphash24
#endif

static size_t _cffi_d_crypto_shorthash_siphash24_bytes(void)
{
  return crypto_shorthash_siphash24_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphash24_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphash24_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_shorthash_siphash24_bytes _cffi_d_crypto_shorthash_siphash24_bytes
#endif

static size_t _cffi_d_crypto_shorthash_siphash24_keybytes(void)
{
  return crypto_shorthash_siphash24_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphash24_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphash24_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_shorthash_siphash24_keybytes _cffi_d_crypto_shorthash_siphash24_keybytes
#endif

static int _cffi_d_crypto_shorthash_siphashx24(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3)
{
  return crypto_shorthash_siphashx24(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphashx24(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "crypto_shorthash_siphashx24", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphashx24(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_shorthash_siphashx24 _cffi_d_crypto_shorthash_siphashx24
#endif

static size_t _cffi_d_crypto_shorthash_siphashx24_bytes(void)
{
  return crypto_shorthash_siphashx24_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphashx24_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphashx24_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_shorthash_siphashx24_bytes _cffi_d_crypto_shorthash_siphashx24_bytes
#endif

static size_t _cffi_d_crypto_shorthash_siphashx24_keybytes(void)
{
  return crypto_shorthash_siphashx24_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphashx24_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphashx24_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_shorthash_siphashx24_keybytes _cffi_d_crypto_shorthash_siphashx24_keybytes
#endif

static int _cffi_d_crypto_sign(unsigned char * x0, unsigned long long * x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4)
{
  return crypto_sign(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_sign", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign _cffi_d_crypto_sign
#endif

static size_t _cffi_d_crypto_sign_bytes(void)
{
  return crypto_sign_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_bytes _cffi_d_crypto_sign_bytes
#endif

static int _cffi_d_crypto_sign_ed25519_pk_to_curve25519(unsigned char * x0, unsigned char const * x1)
{
  return crypto_sign_ed25519_pk_to_curve25519(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519_pk_to_curve25519(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_sign_ed25519_pk_to_curve25519", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519_pk_to_curve25519(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_ed25519_pk_to_curve25519 _cffi_d_crypto_sign_ed25519_pk_to_curve25519
#endif

static int _cffi_d_crypto_sign_ed25519_sk_to_curve25519(unsigned char * x0, unsigned char const * x1)
{
  return crypto_sign_ed25519_sk_to_curve25519(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519_sk_to_curve25519(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_sign_ed25519_sk_to_curve25519", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519_sk_to_curve25519(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_ed25519_sk_to_curve25519 _cffi_d_crypto_sign_ed25519_sk_to_curve25519
#endif

static int _cffi_d_crypto_sign_ed25519ph_final_create(void * x0, unsigned char * x1, unsigned long long * x2, unsigned char const * x3)
{
  return crypto_sign_ed25519ph_final_create(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519ph_final_create(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char * x1;
  unsigned long long * x2;
  unsigned char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "crypto_sign_ed25519ph_final_create", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519ph_final_create(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_ed25519ph_final_create _cffi_d_crypto_sign_ed25519ph_final_create
#endif

static int _cffi_d_crypto_sign_ed25519ph_final_verify(void * x0, unsigned char * x1, unsigned char const * x2)
{
  return crypto_sign_ed25519ph_final_verify(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519ph_final_verify(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_sign_ed25519ph_final_verify", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519ph_final_verify(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_ed25519ph_final_verify _cffi_d_crypto_sign_ed25519ph_final_verify
#endif

static int _cffi_d_crypto_sign_ed25519ph_init(void * x0)
{
  return crypto_sign_ed25519ph_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519ph_init(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519ph_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_ed25519ph_init _cffi_d_crypto_sign_ed25519ph_init
#endif

static size_t _cffi_d_crypto_sign_ed25519ph_statebytes(void)
{
  return crypto_sign_ed25519ph_statebytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519ph_statebytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519ph_statebytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_ed25519ph_statebytes _cffi_d_crypto_sign_ed25519ph_statebytes
#endif

static int _cffi_d_crypto_sign_ed25519ph_update(void * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_sign_ed25519ph_update(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519ph_update(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_sign_ed25519ph_update", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519ph_update(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_ed25519ph_update _cffi_d_crypto_sign_ed25519ph_update
#endif

static int _cffi_d_crypto_sign_keypair(unsigned char * x0, unsigned char * x1)
{
  return crypto_sign_keypair(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_sign_keypair", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_keypair(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_keypair _cffi_d_crypto_sign_keypair
#endif

static int _cffi_d_crypto_sign_open(unsigned char * x0, unsigned long long * x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4)
{
  return crypto_sign_open(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_open(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_sign_open", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(114), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned long long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(114), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_open(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_open _cffi_d_crypto_sign_open
#endif

static size_t _cffi_d_crypto_sign_publickeybytes(void)
{
  return crypto_sign_publickeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_publickeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_publickeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_publickeybytes _cffi_d_crypto_sign_publickeybytes
#endif

static size_t _cffi_d_crypto_sign_secretkeybytes(void)
{
  return crypto_sign_secretkeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_secretkeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_secretkeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_secretkeybytes _cffi_d_crypto_sign_secretkeybytes
#endif

static int _cffi_d_crypto_sign_seed_keypair(unsigned char * x0, unsigned char * x1, unsigned char const * x2)
{
  return crypto_sign_seed_keypair(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_seed_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_sign_seed_keypair", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_seed_keypair(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_crypto_sign_seed_keypair _cffi_d_crypto_sign_seed_keypair
#endif

static void _cffi_d_randombytes(unsigned char * x0, unsigned long long x1)
{
  randombytes(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_randombytes(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "randombytes", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { randombytes(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_randombytes _cffi_d_randombytes
#endif

static void _cffi_d_randombytes_buf_deterministic(void * x0, size_t x1, unsigned char const * x2)
{
  randombytes_buf_deterministic(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_randombytes_buf_deterministic(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "randombytes_buf_deterministic", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { randombytes_buf_deterministic(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_randombytes_buf_deterministic _cffi_d_randombytes_buf_deterministic
#endif

static size_t _cffi_d_randombytes_seedbytes(void)
{
  return randombytes_seedbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_randombytes_seedbytes(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = randombytes_seedbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_randombytes_seedbytes _cffi_d_randombytes_seedbytes
#endif

static void _cffi_d_sodium_add(unsigned char * x0, unsigned char * x1, size_t x2)
{
  sodium_add(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_add(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sodium_add", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sodium_add(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sodium_add _cffi_d_sodium_add
#endif

static void _cffi_d_sodium_increment(unsigned char * x0, size_t x1)
{
  sodium_increment(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_increment(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sodium_increment", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sodium_increment(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sodium_increment _cffi_d_sodium_increment
#endif

static int _cffi_d_sodium_init(void)
{
  return sodium_init();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_init(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_init(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_sodium_init _cffi_d_sodium_init
#endif

static int _cffi_d_sodium_memcmp(void const * x0, void const * x1, size_t x2)
{
  return sodium_memcmp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_memcmp(PyObject *self, PyObject *args)
{
  void const * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sodium_memcmp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(216), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(216), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(216), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(216), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_memcmp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sodium_memcmp _cffi_d_sodium_memcmp
#endif

static void _cffi_d_sodium_memzero(void * x0, size_t x1)
{
  sodium_memzero(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_memzero(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sodium_memzero", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sodium_memzero(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sodium_memzero _cffi_d_sodium_memzero
#endif

static int _cffi_d_sodium_mlock(void * x0, size_t x1)
{
  return sodium_mlock(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_mlock(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sodium_mlock", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_mlock(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sodium_mlock _cffi_d_sodium_mlock
#endif

static int _cffi_d_sodium_munlock(void * x0, size_t x1)
{
  return sodium_munlock(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_munlock(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sodium_munlock", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(155), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(155), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_munlock(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sodium_munlock _cffi_d_sodium_munlock
#endif

static int _cffi_d_sodium_pad(size_t * x0, unsigned char * x1, size_t x2, size_t x3, size_t x4)
{
  return sodium_pad(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_pad(PyObject *self, PyObject *args)
{
  size_t * x0;
  unsigned char * x1;
  size_t x2;
  size_t x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "sodium_pad", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(29), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(29), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_pad(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sodium_pad _cffi_d_sodium_pad
#endif

static int _cffi_d_sodium_unpad(size_t * x0, unsigned char const * x1, size_t x2, size_t x3)
{
  return sodium_unpad(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_unpad(PyObject *self, PyObject *args)
{
  size_t * x0;
  unsigned char const * x1;
  size_t x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "sodium_unpad", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(36), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(36), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_unpad(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sodium_unpad _cffi_d_sodium_unpad
#endif

static const struct _cffi_global_s _cffi_globals[] = {
  { "PYNACL_HAS_CRYPTO_CORE_ED25519", (void *)_cffi_const_PYNACL_HAS_CRYPTO_CORE_ED25519, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PYNACL_HAS_CRYPTO_PWHASH_SCRYPTSALSA208SHA256", (void *)_cffi_const_PYNACL_HAS_CRYPTO_PWHASH_SCRYPTSALSA208SHA256, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PYNACL_HAS_CRYPTO_SCALARMULT_ED25519", (void *)_cffi_const_PYNACL_HAS_CRYPTO_SCALARMULT_ED25519, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PYNACL_HAS_CRYPTO_SHORTHASH_SIPHASHX24", (void *)_cffi_const_PYNACL_HAS_CRYPTO_SHORTHASH_SIPHASHX24, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "crypto_aead_chacha20poly1305_abytes", (void *)_cffi_f_crypto_aead_chacha20poly1305_abytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_abytes },
  { "crypto_aead_chacha20poly1305_decrypt", (void *)_cffi_f_crypto_aead_chacha20poly1305_decrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 112), (void *)_cffi_d_crypto_aead_chacha20poly1305_decrypt },
  { "crypto_aead_chacha20poly1305_encrypt", (void *)_cffi_f_crypto_aead_chacha20poly1305_encrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 130), (void *)_cffi_d_crypto_aead_chacha20poly1305_encrypt },
  { "crypto_aead_chacha20poly1305_ietf_abytes", (void *)_cffi_f_crypto_aead_chacha20poly1305_ietf_abytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_ietf_abytes },
  { "crypto_aead_chacha20poly1305_ietf_decrypt", (void *)_cffi_f_crypto_aead_chacha20poly1305_ietf_decrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 112), (void *)_cffi_d_crypto_aead_chacha20poly1305_ietf_decrypt },
  { "crypto_aead_chacha20poly1305_ietf_encrypt", (void *)_cffi_f_crypto_aead_chacha20poly1305_ietf_encrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 130), (void *)_cffi_d_crypto_aead_chacha20poly1305_ietf_encrypt },
  { "crypto_aead_chacha20poly1305_ietf_keybytes", (void *)_cffi_f_crypto_aead_chacha20poly1305_ietf_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_ietf_keybytes },
  { "crypto_aead_chacha20poly1305_ietf_messagebytes_max", (void *)_cffi_f_crypto_aead_chacha20poly1305_ietf_messagebytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_ietf_messagebytes_max },
  { "crypto_aead_chacha20poly1305_ietf_npubbytes", (void *)_cffi_f_crypto_aead_chacha20poly1305_ietf_npubbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_ietf_npubbytes },
  { "crypto_aead_chacha20poly1305_ietf_nsecbytes", (void *)_cffi_f_crypto_aead_chacha20poly1305_ietf_nsecbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_ietf_nsecbytes },
  { "crypto_aead_chacha20poly1305_keybytes", (void *)_cffi_f_crypto_aead_chacha20poly1305_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_keybytes },
  { "crypto_aead_chacha20poly1305_messagebytes_max", (void *)_cffi_f_crypto_aead_chacha20poly1305_messagebytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_messagebytes_max },
  { "crypto_aead_chacha20poly1305_npubbytes", (void *)_cffi_f_crypto_aead_chacha20poly1305_npubbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_npubbytes },
  { "crypto_aead_chacha20poly1305_nsecbytes", (void *)_cffi_f_crypto_aead_chacha20poly1305_nsecbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_chacha20poly1305_nsecbytes },
  { "crypto_aead_xchacha20poly1305_ietf_abytes", (void *)_cffi_f_crypto_aead_xchacha20poly1305_ietf_abytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_xchacha20poly1305_ietf_abytes },
  { "crypto_aead_xchacha20poly1305_ietf_decrypt", (void *)_cffi_f_crypto_aead_xchacha20poly1305_ietf_decrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 112), (void *)_cffi_d_crypto_aead_xchacha20poly1305_ietf_decrypt },
  { "crypto_aead_xchacha20poly1305_ietf_encrypt", (void *)_cffi_f_crypto_aead_xchacha20poly1305_ietf_encrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 130), (void *)_cffi_d_crypto_aead_xchacha20poly1305_ietf_encrypt },
  { "crypto_aead_xchacha20poly1305_ietf_keybytes", (void *)_cffi_f_crypto_aead_xchacha20poly1305_ietf_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_xchacha20poly1305_ietf_keybytes },
  { "crypto_aead_xchacha20poly1305_ietf_messagebytes_max", (void *)_cffi_f_crypto_aead_xchacha20poly1305_ietf_messagebytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_xchacha20poly1305_ietf_messagebytes_max },
  { "crypto_aead_xchacha20poly1305_ietf_npubbytes", (void *)_cffi_f_crypto_aead_xchacha20poly1305_ietf_npubbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_xchacha20poly1305_ietf_npubbytes },
  { "crypto_aead_xchacha20poly1305_ietf_nsecbytes", (void *)_cffi_f_crypto_aead_xchacha20poly1305_ietf_nsecbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_aead_xchacha20poly1305_ietf_nsecbytes },
  { "crypto_box", (void *)_cffi_f_crypto_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 104), (void *)_cffi_d_crypto_box },
  { "crypto_box_afternm", (void *)_cffi_f_crypto_box_afternm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_crypto_box_afternm },
  { "crypto_box_beforenm", (void *)_cffi_f_crypto_box_beforenm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 81), (void *)_cffi_d_crypto_box_beforenm },
  { "crypto_box_beforenmbytes", (void *)_cffi_f_crypto_box_beforenmbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_box_beforenmbytes },
  { "crypto_box_boxzerobytes", (void *)_cffi_f_crypto_box_boxzerobytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_box_boxzerobytes },
  { "crypto_box_keypair", (void *)_cffi_f_crypto_box_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_crypto_box_keypair },
  { "crypto_box_noncebytes", (void *)_cffi_f_crypto_box_noncebytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_box_noncebytes },
  { "crypto_box_open", (void *)_cffi_f_crypto_box_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 104), (void *)_cffi_d_crypto_box_open },
  { "crypto_box_open_afternm", (void *)_cffi_f_crypto_box_open_afternm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_crypto_box_open_afternm },
  { "crypto_box_publickeybytes", (void *)_cffi_f_crypto_box_publickeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_box_publickeybytes },
  { "crypto_box_seal", (void *)_cffi_f_crypto_box_seal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_crypto_box_seal },
  { "crypto_box_seal_open", (void *)_cffi_f_crypto_box_seal_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_crypto_box_seal_open },
  { "crypto_box_sealbytes", (void *)_cffi_f_crypto_box_sealbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_box_sealbytes },
  { "crypto_box_secretkeybytes", (void *)_cffi_f_crypto_box_secretkeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_box_secretkeybytes },
  { "crypto_box_seed_keypair", (void *)_cffi_f_crypto_box_seed_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 65), (void *)_cffi_d_crypto_box_seed_keypair },
  { "crypto_box_seedbytes", (void *)_cffi_f_crypto_box_seedbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_box_seedbytes },
  { "crypto_box_zerobytes", (void *)_cffi_f_crypto_box_zerobytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_box_zerobytes },
  { "crypto_core_ed25519_add", (void *)_cffi_f_crypto_core_ed25519_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 81), (void *)_cffi_d_crypto_core_ed25519_add },
  { "crypto_core_ed25519_bytes", (void *)_cffi_f_crypto_core_ed25519_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_core_ed25519_bytes },
  { "crypto_core_ed25519_is_valid_point", (void *)_cffi_f_crypto_core_ed25519_is_valid_point, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 151), (void *)_cffi_d_crypto_core_ed25519_is_valid_point },
  { "crypto_core_ed25519_nonreducedscalarbytes", (void *)_cffi_f_crypto_core_ed25519_nonreducedscalarbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_core_ed25519_nonreducedscalarbytes },
  { "crypto_core_ed25519_scalar_add", (void *)_cffi_f_crypto_core_ed25519_scalar_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 242), (void *)_cffi_d_crypto_core_ed25519_scalar_add },
  { "crypto_core_ed25519_scalar_complement", (void *)_cffi_f_crypto_core_ed25519_scalar_complement, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 238), (void *)_cffi_d_crypto_core_ed25519_scalar_complement },
  { "crypto_core_ed25519_scalar_invert", (void *)_cffi_f_crypto_core_ed25519_scalar_invert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_core_ed25519_scalar_invert },
  { "crypto_core_ed25519_scalar_mul", (void *)_cffi_f_crypto_core_ed25519_scalar_mul, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 242), (void *)_cffi_d_crypto_core_ed25519_scalar_mul },
  { "crypto_core_ed25519_scalar_negate", (void *)_cffi_f_crypto_core_ed25519_scalar_negate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 238), (void *)_cffi_d_crypto_core_ed25519_scalar_negate },
  { "crypto_core_ed25519_scalar_reduce", (void *)_cffi_f_crypto_core_ed25519_scalar_reduce, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 238), (void *)_cffi_d_crypto_core_ed25519_scalar_reduce },
  { "crypto_core_ed25519_scalar_sub", (void *)_cffi_f_crypto_core_ed25519_scalar_sub, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 242), (void *)_cffi_d_crypto_core_ed25519_scalar_sub },
  { "crypto_core_ed25519_scalarbytes", (void *)_cffi_f_crypto_core_ed25519_scalarbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_core_ed25519_scalarbytes },
  { "crypto_core_ed25519_sub", (void *)_cffi_f_crypto_core_ed25519_sub, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 81), (void *)_cffi_d_crypto_core_ed25519_sub },
  { "crypto_generichash_blake2b_bytes", (void *)_cffi_f_crypto_generichash_blake2b_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_blake2b_bytes },
  { "crypto_generichash_blake2b_bytes_max", (void *)_cffi_f_crypto_generichash_blake2b_bytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_blake2b_bytes_max },
  { "crypto_generichash_blake2b_bytes_min", (void *)_cffi_f_crypto_generichash_blake2b_bytes_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_blake2b_bytes_min },
  { "crypto_generichash_blake2b_final", (void *)_cffi_f_crypto_generichash_blake2b_final, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 161), (void *)_cffi_d_crypto_generichash_blake2b_final },
  { "crypto_generichash_blake2b_init_salt_personal", (void *)_cffi_f_crypto_generichash_blake2b_init_salt_personal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 197), (void *)_cffi_d_crypto_generichash_blake2b_init_salt_personal },
  { "crypto_generichash_blake2b_keybytes", (void *)_cffi_f_crypto_generichash_blake2b_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_blake2b_keybytes },
  { "crypto_generichash_blake2b_keybytes_max", (void *)_cffi_f_crypto_generichash_blake2b_keybytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_blake2b_keybytes_max },
  { "crypto_generichash_blake2b_keybytes_min", (void *)_cffi_f_crypto_generichash_blake2b_keybytes_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_blake2b_keybytes_min },
  { "crypto_generichash_blake2b_personalbytes", (void *)_cffi_f_crypto_generichash_blake2b_personalbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_blake2b_personalbytes },
  { "crypto_generichash_blake2b_salt_personal", (void *)_cffi_f_crypto_generichash_blake2b_salt_personal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 51), (void *)_cffi_d_crypto_generichash_blake2b_salt_personal },
  { "crypto_generichash_blake2b_saltbytes", (void *)_cffi_f_crypto_generichash_blake2b_saltbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_blake2b_saltbytes },
  { "crypto_generichash_blake2b_update", (void *)_cffi_f_crypto_generichash_blake2b_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 210), (void *)_cffi_d_crypto_generichash_blake2b_update },
  { "crypto_generichash_statebytes", (void *)_cffi_f_crypto_generichash_statebytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_generichash_statebytes },
  { "crypto_hash", (void *)_cffi_f_crypto_hash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 86), (void *)_cffi_d_crypto_hash },
  { "crypto_hash_sha256", (void *)_cffi_f_crypto_hash_sha256, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 86), (void *)_cffi_d_crypto_hash_sha256 },
  { "crypto_hash_sha256_bytes", (void *)_cffi_f_crypto_hash_sha256_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_hash_sha256_bytes },
  { "crypto_hash_sha512", (void *)_cffi_f_crypto_hash_sha512, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 86), (void *)_cffi_d_crypto_hash_sha512 },
  { "crypto_hash_sha512_bytes", (void *)_cffi_f_crypto_hash_sha512_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_hash_sha512_bytes },
  { "crypto_kx_client_session_keys", (void *)_cffi_f_crypto_kx_client_session_keys, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 70), (void *)_cffi_d_crypto_kx_client_session_keys },
  { "crypto_kx_keypair", (void *)_cffi_f_crypto_kx_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_crypto_kx_keypair },
  { "crypto_kx_publickeybytes", (void *)_cffi_f_crypto_kx_publickeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_kx_publickeybytes },
  { "crypto_kx_secretkeybytes", (void *)_cffi_f_crypto_kx_secretkeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_kx_secretkeybytes },
  { "crypto_kx_seed_keypair", (void *)_cffi_f_crypto_kx_seed_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 65), (void *)_cffi_d_crypto_kx_seed_keypair },
  { "crypto_kx_seedbytes", (void *)_cffi_f_crypto_kx_seedbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_kx_seedbytes },
  { "crypto_kx_server_session_keys", (void *)_cffi_f_crypto_kx_server_session_keys, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 70), (void *)_cffi_d_crypto_kx_server_session_keys },
  { "crypto_kx_sessionkeybytes", (void *)_cffi_f_crypto_kx_sessionkeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_kx_sessionkeybytes },
  { "crypto_pwhash", (void *)_cffi_f_crypto_pwhash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 141), (void *)_cffi_d_crypto_pwhash },
  { "crypto_pwhash_alg_argon2i13", (void *)_cffi_f_crypto_pwhash_alg_argon2i13, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 220), (void *)_cffi_d_crypto_pwhash_alg_argon2i13 },
  { "crypto_pwhash_alg_argon2id13", (void *)_cffi_f_crypto_pwhash_alg_argon2id13, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 220), (void *)_cffi_d_crypto_pwhash_alg_argon2id13 },
  { "crypto_pwhash_alg_default", (void *)_cffi_f_crypto_pwhash_alg_default, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 220), (void *)_cffi_d_crypto_pwhash_alg_default },
  { "crypto_pwhash_argon2i_memlimit_interactive", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_interactive },
  { "crypto_pwhash_argon2i_memlimit_max", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_max },
  { "crypto_pwhash_argon2i_memlimit_min", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_min },
  { "crypto_pwhash_argon2i_memlimit_moderate", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_moderate },
  { "crypto_pwhash_argon2i_memlimit_sensitive", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_sensitive },
  { "crypto_pwhash_argon2i_opslimit_interactive", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_interactive },
  { "crypto_pwhash_argon2i_opslimit_max", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_max },
  { "crypto_pwhash_argon2i_opslimit_min", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_min },
  { "crypto_pwhash_argon2i_opslimit_moderate", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_moderate },
  { "crypto_pwhash_argon2i_opslimit_sensitive", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_sensitive },
  { "crypto_pwhash_argon2i_strprefix", (void *)_cffi_f_crypto_pwhash_argon2i_strprefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_crypto_pwhash_argon2i_strprefix },
  { "crypto_pwhash_argon2id_memlimit_interactive", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_interactive },
  { "crypto_pwhash_argon2id_memlimit_max", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_max },
  { "crypto_pwhash_argon2id_memlimit_min", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_min },
  { "crypto_pwhash_argon2id_memlimit_moderate", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_moderate },
  { "crypto_pwhash_argon2id_memlimit_sensitive", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_sensitive },
  { "crypto_pwhash_argon2id_opslimit_interactive", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_interactive },
  { "crypto_pwhash_argon2id_opslimit_max", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_max },
  { "crypto_pwhash_argon2id_opslimit_min", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_min },
  { "crypto_pwhash_argon2id_opslimit_moderate", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_moderate },
  { "crypto_pwhash_argon2id_opslimit_sensitive", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_sensitive },
  { "crypto_pwhash_argon2id_strprefix", (void *)_cffi_f_crypto_pwhash_argon2id_strprefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_crypto_pwhash_argon2id_strprefix },
  { "crypto_pwhash_bytes_max", (void *)_cffi_f_crypto_pwhash_bytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_bytes_max },
  { "crypto_pwhash_bytes_min", (void *)_cffi_f_crypto_pwhash_bytes_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_bytes_min },
  { "crypto_pwhash_memlimit_interactive", (void *)_cffi_f_crypto_pwhash_memlimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_memlimit_interactive },
  { "crypto_pwhash_memlimit_max", (void *)_cffi_f_crypto_pwhash_memlimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_memlimit_max },
  { "crypto_pwhash_memlimit_min", (void *)_cffi_f_crypto_pwhash_memlimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_memlimit_min },
  { "crypto_pwhash_memlimit_moderate", (void *)_cffi_f_crypto_pwhash_memlimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_memlimit_moderate },
  { "crypto_pwhash_memlimit_sensitive", (void *)_cffi_f_crypto_pwhash_memlimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_memlimit_sensitive },
  { "crypto_pwhash_opslimit_interactive", (void *)_cffi_f_crypto_pwhash_opslimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_opslimit_interactive },
  { "crypto_pwhash_opslimit_max", (void *)_cffi_f_crypto_pwhash_opslimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_opslimit_max },
  { "crypto_pwhash_opslimit_min", (void *)_cffi_f_crypto_pwhash_opslimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_opslimit_min },
  { "crypto_pwhash_opslimit_moderate", (void *)_cffi_f_crypto_pwhash_opslimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_opslimit_moderate },
  { "crypto_pwhash_opslimit_sensitive", (void *)_cffi_f_crypto_pwhash_opslimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_opslimit_sensitive },
  { "crypto_pwhash_passwd_max", (void *)_cffi_f_crypto_pwhash_passwd_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_passwd_max },
  { "crypto_pwhash_passwd_min", (void *)_cffi_f_crypto_pwhash_passwd_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_passwd_min },
  { "crypto_pwhash_saltbytes", (void *)_cffi_f_crypto_pwhash_saltbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_saltbytes },
  { "crypto_pwhash_scryptsalsa208sha256_bytes_max", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_max },
  { "crypto_pwhash_scryptsalsa208sha256_bytes_min", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_min },
  { "crypto_pwhash_scryptsalsa208sha256_ll", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_ll, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 40), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_ll },
  { "crypto_pwhash_scryptsalsa208sha256_memlimit_interactive", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive },
  { "crypto_pwhash_scryptsalsa208sha256_memlimit_max", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_max },
  { "crypto_pwhash_scryptsalsa208sha256_memlimit_min", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_min },
  { "crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive },
  { "crypto_pwhash_scryptsalsa208sha256_opslimit_interactive", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive },
  { "crypto_pwhash_scryptsalsa208sha256_opslimit_max", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_max },
  { "crypto_pwhash_scryptsalsa208sha256_opslimit_min", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_min },
  { "crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive },
  { "crypto_pwhash_scryptsalsa208sha256_passwd_max", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_max },
  { "crypto_pwhash_scryptsalsa208sha256_passwd_min", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_min },
  { "crypto_pwhash_scryptsalsa208sha256_saltbytes", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_saltbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_saltbytes },
  { "crypto_pwhash_scryptsalsa208sha256_str", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_str, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 2), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_str },
  { "crypto_pwhash_scryptsalsa208sha256_str_verify", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_str_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 17), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_str_verify },
  { "crypto_pwhash_scryptsalsa208sha256_strbytes", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_strbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_strbytes },
  { "crypto_pwhash_scryptsalsa208sha256_strprefix", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_strprefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_strprefix },
  { "crypto_pwhash_str_alg", (void *)_cffi_f_crypto_pwhash_str_alg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 9), (void *)_cffi_d_crypto_pwhash_str_alg },
  { "crypto_pwhash_str_needs_rehash", (void *)_cffi_f_crypto_pwhash_str_needs_rehash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 22), (void *)_cffi_d_crypto_pwhash_str_needs_rehash },
  { "crypto_pwhash_str_verify", (void *)_cffi_f_crypto_pwhash_str_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 17), (void *)_cffi_d_crypto_pwhash_str_verify },
  { "crypto_pwhash_strbytes", (void *)_cffi_f_crypto_pwhash_strbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_pwhash_strbytes },
  { "crypto_scalarmult", (void *)_cffi_f_crypto_scalarmult, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 81), (void *)_cffi_d_crypto_scalarmult },
  { "crypto_scalarmult_base", (void *)_cffi_f_crypto_scalarmult_base, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_scalarmult_base },
  { "crypto_scalarmult_bytes", (void *)_cffi_f_crypto_scalarmult_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_scalarmult_bytes },
  { "crypto_scalarmult_ed25519", (void *)_cffi_f_crypto_scalarmult_ed25519, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 81), (void *)_cffi_d_crypto_scalarmult_ed25519 },
  { "crypto_scalarmult_ed25519_base", (void *)_cffi_f_crypto_scalarmult_ed25519_base, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_scalarmult_ed25519_base },
  { "crypto_scalarmult_ed25519_base_noclamp", (void *)_cffi_f_crypto_scalarmult_ed25519_base_noclamp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_scalarmult_ed25519_base_noclamp },
  { "crypto_scalarmult_ed25519_bytes", (void *)_cffi_f_crypto_scalarmult_ed25519_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_scalarmult_ed25519_bytes },
  { "crypto_scalarmult_ed25519_noclamp", (void *)_cffi_f_crypto_scalarmult_ed25519_noclamp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 81), (void *)_cffi_d_crypto_scalarmult_ed25519_noclamp },
  { "crypto_scalarmult_ed25519_scalarbytes", (void *)_cffi_f_crypto_scalarmult_ed25519_scalarbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_scalarmult_ed25519_scalarbytes },
  { "crypto_scalarmult_scalarbytes", (void *)_cffi_f_crypto_scalarmult_scalarbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_scalarmult_scalarbytes },
  { "crypto_secretbox", (void *)_cffi_f_crypto_secretbox, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_crypto_secretbox },
  { "crypto_secretbox_boxzerobytes", (void *)_cffi_f_crypto_secretbox_boxzerobytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretbox_boxzerobytes },
  { "crypto_secretbox_keybytes", (void *)_cffi_f_crypto_secretbox_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretbox_keybytes },
  { "crypto_secretbox_macbytes", (void *)_cffi_f_crypto_secretbox_macbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretbox_macbytes },
  { "crypto_secretbox_messagebytes_max", (void *)_cffi_f_crypto_secretbox_messagebytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretbox_messagebytes_max },
  { "crypto_secretbox_noncebytes", (void *)_cffi_f_crypto_secretbox_noncebytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretbox_noncebytes },
  { "crypto_secretbox_open", (void *)_cffi_f_crypto_secretbox_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_crypto_secretbox_open },
  { "crypto_secretbox_zerobytes", (void *)_cffi_f_crypto_secretbox_zerobytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretbox_zerobytes },
  { "crypto_secretstream_xchacha20poly1305_abytes", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_abytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_abytes },
  { "crypto_secretstream_xchacha20poly1305_headerbytes", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_headerbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_headerbytes },
  { "crypto_secretstream_xchacha20poly1305_init_pull", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_init_pull, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 205), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_init_pull },
  { "crypto_secretstream_xchacha20poly1305_init_push", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_init_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 166), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_init_push },
  { "crypto_secretstream_xchacha20poly1305_keybytes", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_keybytes },
  { "crypto_secretstream_xchacha20poly1305_keygen", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_keygen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 226), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_keygen },
  { "crypto_secretstream_xchacha20poly1305_messagebytes_max", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_messagebytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_messagebytes_max },
  { "crypto_secretstream_xchacha20poly1305_pull", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_pull, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 171), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_pull },
  { "crypto_secretstream_xchacha20poly1305_push", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 187), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_push },
  { "crypto_secretstream_xchacha20poly1305_rekey", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_rekey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 251), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_rekey },
  { "crypto_secretstream_xchacha20poly1305_statebytes", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_statebytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_statebytes },
  { "crypto_secretstream_xchacha20poly1305_tag_final", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_tag_final, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 224), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_tag_final },
  { "crypto_secretstream_xchacha20poly1305_tag_message", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_tag_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 224), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_tag_message },
  { "crypto_secretstream_xchacha20poly1305_tag_push", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_tag_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 224), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_tag_push },
  { "crypto_secretstream_xchacha20poly1305_tag_rekey", (void *)_cffi_f_crypto_secretstream_xchacha20poly1305_tag_rekey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 224), (void *)_cffi_d_crypto_secretstream_xchacha20poly1305_tag_rekey },
  { "crypto_shorthash_siphash24", (void *)_cffi_f_crypto_shorthash_siphash24, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_crypto_shorthash_siphash24 },
  { "crypto_shorthash_siphash24_bytes", (void *)_cffi_f_crypto_shorthash_siphash24_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_shorthash_siphash24_bytes },
  { "crypto_shorthash_siphash24_keybytes", (void *)_cffi_f_crypto_shorthash_siphash24_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_shorthash_siphash24_keybytes },
  { "crypto_shorthash_siphashx24", (void *)_cffi_f_crypto_shorthash_siphashx24, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_crypto_shorthash_siphashx24 },
  { "crypto_shorthash_siphashx24_bytes", (void *)_cffi_f_crypto_shorthash_siphashx24_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_shorthash_siphashx24_bytes },
  { "crypto_shorthash_siphashx24_keybytes", (void *)_cffi_f_crypto_shorthash_siphashx24_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_shorthash_siphashx24_keybytes },
  { "crypto_sign", (void *)_cffi_f_crypto_sign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 123), (void *)_cffi_d_crypto_sign },
  { "crypto_sign_bytes", (void *)_cffi_f_crypto_sign_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_sign_bytes },
  { "crypto_sign_ed25519_pk_to_curve25519", (void *)_cffi_f_crypto_sign_ed25519_pk_to_curve25519, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_sign_ed25519_pk_to_curve25519 },
  { "crypto_sign_ed25519_sk_to_curve25519", (void *)_cffi_f_crypto_sign_ed25519_sk_to_curve25519, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_sign_ed25519_sk_to_curve25519 },
  { "crypto_sign_ed25519ph_final_create", (void *)_cffi_f_crypto_sign_ed25519ph_final_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 181), (void *)_cffi_d_crypto_sign_ed25519ph_final_create },
  { "crypto_sign_ed25519ph_final_verify", (void *)_cffi_f_crypto_sign_ed25519ph_final_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 166), (void *)_cffi_d_crypto_sign_ed25519ph_final_verify },
  { "crypto_sign_ed25519ph_init", (void *)_cffi_f_crypto_sign_ed25519ph_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 154), (void *)_cffi_d_crypto_sign_ed25519ph_init },
  { "crypto_sign_ed25519ph_statebytes", (void *)_cffi_f_crypto_sign_ed25519ph_statebytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_sign_ed25519ph_statebytes },
  { "crypto_sign_ed25519ph_update", (void *)_cffi_f_crypto_sign_ed25519ph_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 210), (void *)_cffi_d_crypto_sign_ed25519ph_update },
  { "crypto_sign_keypair", (void *)_cffi_f_crypto_sign_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_crypto_sign_keypair },
  { "crypto_sign_open", (void *)_cffi_f_crypto_sign_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 123), (void *)_cffi_d_crypto_sign_open },
  { "crypto_sign_publickeybytes", (void *)_cffi_f_crypto_sign_publickeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_sign_publickeybytes },
  { "crypto_sign_secretkeybytes", (void *)_cffi_f_crypto_sign_secretkeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_crypto_sign_secretkeybytes },
  { "crypto_sign_seed_keypair", (void *)_cffi_f_crypto_sign_seed_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 65), (void *)_cffi_d_crypto_sign_seed_keypair },
  { "randombytes", (void *)_cffi_f_randombytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 247), (void *)_cffi_d_randombytes },
  { "randombytes_buf_deterministic", (void *)_cffi_f_randombytes_buf_deterministic, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 258), (void *)_cffi_d_randombytes_buf_deterministic },
  { "randombytes_seedbytes", (void *)_cffi_f_randombytes_seedbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 222), (void *)_cffi_d_randombytes_seedbytes },
  { "sodium_add", (void *)_cffi_f_sodium_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 233), (void *)_cffi_d_sodium_add },
  { "sodium_increment", (void *)_cffi_f_sodium_increment, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 229), (void *)_cffi_d_sodium_increment },
  { "sodium_init", (void *)_cffi_f_sodium_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 220), (void *)_cffi_d_sodium_init },
  { "sodium_memcmp", (void *)_cffi_f_sodium_memcmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 215), (void *)_cffi_d_sodium_memcmp },
  { "sodium_memzero", (void *)_cffi_f_sodium_memzero, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 254), (void *)_cffi_d_sodium_memzero },
  { "sodium_mlock", (void *)_cffi_f_sodium_mlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 157), (void *)_cffi_d_sodium_mlock },
  { "sodium_munlock", (void *)_cffi_f_sodium_munlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 157), (void *)_cffi_d_sodium_munlock },
  { "sodium_pad", (void *)_cffi_f_sodium_pad, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_sodium_pad },
  { "sodium_unpad", (void *)_cffi_f_sodium_unpad, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 34), (void *)_cffi_d_sodium_unpad },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "crypto_generichash_blake2b_state", 265 },
  { "crypto_secretstream_xchacha20poly1305_state", 265 },
  { "crypto_sign_ed25519ph_state", 265 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  NULL,  /* no struct_unions */
  NULL,  /* no enums */
  _cffi_typenames,
  209,  /* num_globals */
  0,  /* num_struct_unions */
  0,  /* num_enums */
  3,  /* num_typenames */
  NULL,  /* no includes */
  266,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__sodium(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__sodium(void) { return NULL; }
#  else
     init_sodium(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__sodium(void)
{
  return _cffi_init("_sodium", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_sodium(void)
{
  _cffi_init("_sodium", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
