OCTAVE_CONFIG ?= octave-config
MKOCTFILE ?= mkoctfile 
GREP ?= /usr/bin/grep

all: $(OCT) archtests


ARCHDIR   := "$(shell $(OCTAVE_CONFIG) -p CANONICAL_HOST_TYPE)-$(shell $(OCTAVE_CONFIG) -p API_VERSION)"
CC_SOURCES  := $(wildcard *.cc)
CC_TST_SOURCES := $(shell $(GREP) --files-with-matches '^%!' $(CC_SOURCES))
TST_SOURCES := $(patsubst %.cc,../../inst/$(ARCHDIR)/%.cc-tst,$(CC_TST_SOURCES))

$(TST_SOURCES): ../../inst/$(ARCHDIR)/%.cc-tst: %.cc | ../../inst/$(ARCHDIR)
	@echo "Extracting tests from $< ..."
	@$(RM) -f "$@" "$@-t"
	@(      echo "## Generated from $<"; \
	        $(GREP) '^%!' "$<") > "$@"

PHONY: archtests
archtests: $(TST_SOURCES)

PHONY: cleanarchtests
cleanarchtests:
	rm -f $(TST_SOURCES)

../../inst/$(ARCHDIR):
	@mkdir -p "$@"

%.o: %.c
	$(MKOCTFILE) $(CFLAGS) -c $^
	
%.o: %.cc
	$(MKOCTFILE) $(CFLAGS) -c $^

%.oct: $(OBJ)
	$(MKOCTFILE) $^ $(LFLAGS) $(TCPLIBS) -o $@

clean: cleanarchtests
	rm -f $(OCT) *.o

distclean: clean
	rm Makefile

.PHONY: all clean
