/* map-file.c generated by valac 0.20.0.2-fd7ed, the Vala compiler
 * generated from map-file.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>


#define SKK_TYPE_MAP_FILE (skk_map_file_get_type ())
#define SKK_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MAP_FILE, SkkMapFile))
#define SKK_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MAP_FILE, SkkMapFileClass))
#define SKK_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MAP_FILE))
#define SKK_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MAP_FILE))
#define SKK_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MAP_FILE, SkkMapFileClass))

typedef struct _SkkMapFile SkkMapFile;
typedef struct _SkkMapFileClass SkkMapFileClass;
typedef struct _SkkMapFilePrivate SkkMapFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define SKK_TYPE_RULE_METADATA (skk_rule_metadata_get_type ())
typedef struct _SkkRuleMetadata SkkRuleMetadata;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))
#define __vala_JsonArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonArray_free (var), NULL)))
#define _skk_rule_metadata_free0(var) ((var == NULL) ? NULL : (var = (skk_rule_metadata_free (var), NULL)))

struct _SkkMapFile {
	GObject parent_instance;
	SkkMapFilePrivate * priv;
};

struct _SkkMapFileClass {
	GObjectClass parent_class;
};

struct _SkkMapFilePrivate {
	GeeMap* maps;
};

struct _SkkRuleMetadata {
	gchar* base_dir;
	gchar* name;
	gchar* label;
	gchar* description;
	gchar* filter;
};

typedef enum  {
	SKK_RULE_PARSE_ERROR_FAILED
} SkkRuleParseError;
#define SKK_RULE_PARSE_ERROR skk_rule_parse_error_quark ()

static gpointer skk_map_file_parent_class = NULL;

GType skk_map_file_get_type (void) G_GNUC_CONST;
#define SKK_MAP_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_MAP_FILE, SkkMapFilePrivate))
enum  {
	SKK_MAP_FILE_DUMMY_PROPERTY
};
static void skk_map_file_load_map (SkkMapFile* self, GeeMap* map, JsonObject* object);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
GType skk_rule_metadata_get_type (void) G_GNUC_CONST;
SkkRuleMetadata* skk_rule_metadata_dup (const SkkRuleMetadata* self);
void skk_rule_metadata_free (SkkRuleMetadata* self);
void skk_rule_metadata_copy (const SkkRuleMetadata* self, SkkRuleMetadata* dest);
void skk_rule_metadata_destroy (SkkRuleMetadata* self);
GQuark skk_rule_parse_error_quark (void);
static void skk_map_file_load (SkkMapFile* self, SkkRuleMetadata* metadata, const gchar* type, const gchar* name, GeeSet* included, GError** error);
gchar* skk_rule_metadata_locate_map_file (SkkRuleMetadata *self, const gchar* type, const gchar* name);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static void _vala_JsonObject_free (JsonObject* self);
static JsonArray* _vala_JsonArray_copy (JsonArray* self);
static void _vala_JsonArray_free (JsonArray* self);
SkkRuleMetadata* skk_rule_find_rule (const gchar* name);
SkkMapFile* skk_map_file_construct (GType object_type, SkkRuleMetadata* metadata, const gchar* type, const gchar* name, GError** error);
gboolean skk_map_file_has_map (SkkMapFile* self, const gchar* name);
GeeMap* skk_map_file_get (SkkMapFile* self, const gchar* name);
static void skk_map_file_finalize (GObject* obj);


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void skk_map_file_load_map (SkkMapFile* self, GeeMap* map, JsonObject* object) {
	JsonObject* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* keys;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = json_object_get_members (_tmp0_);
	keys = _tmp1_;
	_tmp2_ = keys;
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp2_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key = NULL;
			key = (const gchar*) key_it->data;
			{
				JsonObject* _tmp3_;
				const gchar* _tmp4_;
				JsonNode* _tmp5_ = NULL;
				JsonNode* _tmp6_;
				JsonNode* value;
				JsonNode* _tmp7_;
				JsonNodeType _tmp8_ = 0;
				_tmp3_ = object;
				_tmp4_ = key;
				_tmp5_ = json_object_get_member (_tmp3_, _tmp4_);
				_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
				value = _tmp6_;
				_tmp7_ = value;
				_tmp8_ = json_node_get_node_type (_tmp7_);
				if (_tmp8_ == JSON_NODE_NULL) {
					GeeMap* _tmp9_;
					const gchar* _tmp10_;
					_tmp9_ = map;
					_tmp10_ = key;
					gee_map_unset (_tmp9_, _tmp10_, NULL);
				} else {
					GeeMap* _tmp11_;
					const gchar* _tmp12_;
					JsonNode* _tmp13_;
					_tmp11_ = map;
					_tmp12_ = key;
					_tmp13_ = value;
					gee_map_set (_tmp11_, _tmp12_, _tmp13_);
				}
				__vala_JsonNode_free0 (value);
			}
		}
	}
	_g_list_free0 (keys);
}


static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
	return g_boxed_copy (json_object_get_type (), self);
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
	return self ? _vala_JsonObject_copy (self) : NULL;
}


static void _vala_JsonObject_free (JsonObject* self) {
	g_boxed_free (json_object_get_type (), self);
}


static JsonArray* _vala_JsonArray_copy (JsonArray* self) {
	return g_boxed_copy (json_array_get_type (), self);
}


static gpointer __vala_JsonArray_copy0 (gpointer self) {
	return self ? _vala_JsonArray_copy (self) : NULL;
}


static void _vala_JsonArray_free (JsonArray* self) {
	g_boxed_free (json_array_get_type (), self);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void skk_map_file_load (SkkMapFile* self, SkkRuleMetadata* metadata, const gchar* type, const gchar* name, GeeSet* included, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	JsonParser* _tmp4_;
	JsonParser* parser;
	JsonParser* _tmp15_;
	JsonNode* _tmp16_ = NULL;
	JsonNode* _tmp17_;
	JsonNode* root;
	JsonNode* _tmp18_;
	JsonNodeType _tmp19_ = 0;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_ = NULL;
	JsonObject* _tmp23_;
	JsonObject* object;
	JsonNode* member = NULL;
	JsonObject* _tmp24_;
	gboolean _tmp25_ = FALSE;
	JsonObject* _tmp75_;
	gboolean _tmp76_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (included != NULL);
	_tmp0_ = type;
	_tmp1_ = name;
	_tmp2_ = skk_rule_metadata_locate_map_file (metadata, _tmp0_, _tmp1_);
	filename = _tmp2_;
	if (filename == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "no such file %s", filename);
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		} else {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = json_parser_new ();
	parser = _tmp4_;
	{
		JsonParser* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		_tmp5_ = parser;
		_tmp6_ = json_parser_load_from_file (_tmp5_, filename, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
		if (!_tmp7_) {
			GError* _tmp8_;
			_tmp8_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "");
			_inner_error_ = _tmp8_;
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		GError* _tmp13_;
		GError* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		_tmp11_ = g_strdup_printf ("can't load %s: %s", filename, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_inner_error_ = _tmp14_;
		_g_error_free0 (e);
		goto __finally28;
	}
	__finally28:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = parser;
	_tmp16_ = json_parser_get_root (_tmp15_);
	_tmp17_ = __vala_JsonNode_copy0 (_tmp16_);
	root = _tmp17_;
	_tmp18_ = root;
	_tmp19_ = json_node_get_node_type (_tmp18_);
	if (_tmp19_ != JSON_NODE_OBJECT) {
		GError* _tmp20_;
		_tmp20_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "root element must be an object");
		_inner_error_ = _tmp20_;
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = root;
	_tmp22_ = json_node_get_object (_tmp21_);
	_tmp23_ = __vala_JsonObject_copy0 (_tmp22_);
	object = _tmp23_;
	_tmp24_ = object;
	_tmp25_ = json_object_has_member (_tmp24_, "include");
	if (_tmp25_) {
		JsonObject* _tmp26_;
		JsonNode* _tmp27_ = NULL;
		JsonNode* _tmp28_;
		JsonNode* _tmp29_;
		JsonNodeType _tmp30_ = 0;
		JsonNode* _tmp32_;
		JsonArray* _tmp33_ = NULL;
		JsonArray* _tmp34_;
		JsonArray* include;
		JsonArray* _tmp35_;
		GList* _tmp36_ = NULL;
		GList* elements;
		GList* _tmp37_;
		_tmp26_ = object;
		_tmp27_ = json_object_get_member (_tmp26_, "include");
		_tmp28_ = __vala_JsonNode_copy0 (_tmp27_);
		__vala_JsonNode_free0 (member);
		member = _tmp28_;
		_tmp29_ = member;
		_tmp30_ = json_node_get_node_type (_tmp29_);
		if (_tmp30_ != JSON_NODE_ARRAY) {
			GError* _tmp31_;
			_tmp31_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "\"include\" element must be an array");
			_inner_error_ = _tmp31_;
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_JsonNode_free0 (member);
				__vala_JsonObject_free0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				__vala_JsonObject_free0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp32_ = member;
		_tmp33_ = json_node_get_array (_tmp32_);
		_tmp34_ = __vala_JsonArray_copy0 (_tmp33_);
		include = _tmp34_;
		_tmp35_ = include;
		_tmp36_ = json_array_get_elements (_tmp35_);
		elements = _tmp36_;
		_tmp37_ = elements;
		{
			GList* element_collection = NULL;
			GList* element_it = NULL;
			element_collection = _tmp37_;
			for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
				JsonNode* element = NULL;
				element = (JsonNode*) element_it->data;
				{
					JsonNode* _tmp38_;
					const gchar* _tmp39_ = NULL;
					gchar* _tmp40_;
					gchar* parent;
					GeeSet* _tmp41_;
					const gchar* _tmp42_;
					gboolean _tmp43_ = FALSE;
					gchar* parent_rule = NULL;
					gchar* parent_name = NULL;
					const gchar* _tmp46_;
					gint _tmp47_ = 0;
					gint index;
					gint _tmp48_;
					const gchar* _tmp63_;
					SkkRuleMetadata* _tmp64_ = NULL;
					SkkRuleMetadata* parent_metadata;
					SkkRuleMetadata* _tmp65_;
					SkkRuleMetadata* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					GeeSet* _tmp71_;
					SkkRuleMetadata _tmp72_;
					GeeSet* _tmp73_;
					const gchar* _tmp74_;
					_tmp38_ = element;
					_tmp39_ = json_node_get_string (_tmp38_);
					_tmp40_ = g_strdup (_tmp39_);
					parent = _tmp40_;
					_tmp41_ = included;
					_tmp42_ = parent;
					_tmp43_ = gee_collection_contains ((GeeCollection*) _tmp41_, _tmp42_);
					if (_tmp43_) {
						const gchar* _tmp44_;
						GError* _tmp45_;
						_tmp44_ = parent;
						_tmp45_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "found circular include of %s", _tmp44_);
						_inner_error_ = _tmp45_;
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (parent);
							_g_list_free0 (elements);
							__vala_JsonArray_free0 (include);
							__vala_JsonNode_free0 (member);
							__vala_JsonObject_free0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_g_free0 (parent);
							_g_list_free0 (elements);
							__vala_JsonArray_free0 (include);
							__vala_JsonNode_free0 (member);
							__vala_JsonObject_free0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp46_ = parent;
					_tmp47_ = string_index_of (_tmp46_, "/", 0);
					index = _tmp47_;
					_tmp48_ = index;
					if (_tmp48_ < 0) {
						SkkRuleMetadata _tmp49_;
						const gchar* _tmp50_;
						gchar* _tmp51_;
						const gchar* _tmp52_;
						gchar* _tmp53_;
						_tmp49_ = *metadata;
						_tmp50_ = _tmp49_.name;
						_tmp51_ = g_strdup (_tmp50_);
						_g_free0 (parent_rule);
						parent_rule = _tmp51_;
						_tmp52_ = parent;
						_tmp53_ = g_strdup (_tmp52_);
						_g_free0 (parent_name);
						parent_name = _tmp53_;
					} else {
						const gchar* _tmp54_;
						gint _tmp55_;
						gchar* _tmp56_ = NULL;
						const gchar* _tmp57_;
						gint _tmp58_;
						const gchar* _tmp59_;
						gint _tmp60_;
						gint _tmp61_;
						gchar* _tmp62_ = NULL;
						_tmp54_ = parent;
						_tmp55_ = index;
						_tmp56_ = string_slice (_tmp54_, (glong) 0, (glong) _tmp55_);
						_g_free0 (parent_rule);
						parent_rule = _tmp56_;
						_tmp57_ = parent;
						_tmp58_ = index;
						_tmp59_ = parent;
						_tmp60_ = strlen (_tmp59_);
						_tmp61_ = _tmp60_;
						_tmp62_ = string_slice (_tmp57_, (glong) (_tmp58_ + 1), (glong) _tmp61_);
						_g_free0 (parent_name);
						parent_name = _tmp62_;
					}
					_tmp63_ = parent_rule;
					_tmp64_ = skk_rule_find_rule (_tmp63_);
					parent_metadata = _tmp64_;
					_tmp65_ = parent_metadata;
					if (_tmp65_ == NULL) {
						const gchar* _tmp66_;
						GError* _tmp67_;
						_tmp66_ = parent_rule;
						_tmp67_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "can't find rule %s", _tmp66_);
						_inner_error_ = _tmp67_;
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							__vala_JsonArray_free0 (include);
							__vala_JsonNode_free0 (member);
							__vala_JsonObject_free0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							__vala_JsonArray_free0 (include);
							__vala_JsonNode_free0 (member);
							__vala_JsonObject_free0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp68_ = parent_metadata;
					_tmp69_ = type;
					_tmp70_ = parent_name;
					_tmp71_ = included;
					_tmp72_ = *_tmp68_;
					skk_map_file_load (self, &_tmp72_, _tmp69_, _tmp70_, _tmp71_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							__vala_JsonArray_free0 (include);
							__vala_JsonNode_free0 (member);
							__vala_JsonObject_free0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							__vala_JsonArray_free0 (include);
							__vala_JsonNode_free0 (member);
							__vala_JsonObject_free0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp73_ = included;
					_tmp74_ = parent;
					gee_collection_add ((GeeCollection*) _tmp73_, _tmp74_);
					_skk_rule_metadata_free0 (parent_metadata);
					_g_free0 (parent_name);
					_g_free0 (parent_rule);
					_g_free0 (parent);
				}
			}
		}
		_g_list_free0 (elements);
		__vala_JsonArray_free0 (include);
	}
	_tmp75_ = object;
	_tmp76_ = json_object_has_member (_tmp75_, "define");
	if (_tmp76_) {
		JsonObject* _tmp77_;
		JsonNode* _tmp78_ = NULL;
		JsonNode* _tmp79_;
		JsonNode* _tmp80_;
		JsonNodeType _tmp81_ = 0;
		JsonNode* _tmp83_;
		JsonObject* _tmp84_ = NULL;
		JsonObject* _tmp85_;
		JsonObject* define;
		JsonObject* _tmp86_;
		GList* _tmp87_ = NULL;
		GList* keys;
		GList* _tmp88_;
		_tmp77_ = object;
		_tmp78_ = json_object_get_member (_tmp77_, "define");
		_tmp79_ = __vala_JsonNode_copy0 (_tmp78_);
		__vala_JsonNode_free0 (member);
		member = _tmp79_;
		_tmp80_ = member;
		_tmp81_ = json_node_get_node_type (_tmp80_);
		if (_tmp81_ != JSON_NODE_OBJECT) {
			GError* _tmp82_;
			_tmp82_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "\"define\" element must be an object");
			_inner_error_ = _tmp82_;
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_JsonNode_free0 (member);
				__vala_JsonObject_free0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				__vala_JsonObject_free0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp83_ = member;
		_tmp84_ = json_node_get_object (_tmp83_);
		_tmp85_ = __vala_JsonObject_copy0 (_tmp84_);
		define = _tmp85_;
		_tmp86_ = define;
		_tmp87_ = json_object_get_members (_tmp86_);
		keys = _tmp87_;
		_tmp88_ = keys;
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
			key_collection = _tmp88_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				const gchar* key = NULL;
				key = (const gchar*) key_it->data;
				{
					GeeMap* _tmp89_;
					const gchar* _tmp90_;
					gboolean _tmp91_ = FALSE;
					JsonObject* _tmp96_;
					const gchar* _tmp97_;
					JsonNode* _tmp98_ = NULL;
					JsonNode* _tmp99_;
					JsonNode* _tmp100_;
					JsonNodeType _tmp101_ = 0;
					GeeMap* _tmp103_;
					const gchar* _tmp104_;
					gpointer _tmp105_ = NULL;
					GeeMap* _tmp106_;
					JsonNode* _tmp107_;
					JsonObject* _tmp108_ = NULL;
					_tmp89_ = self->priv->maps;
					_tmp90_ = key;
					_tmp91_ = gee_map_has_key (_tmp89_, _tmp90_);
					if (!_tmp91_) {
						GeeHashMap* _tmp92_;
						GeeHashMap* map;
						GeeMap* _tmp93_;
						const gchar* _tmp94_;
						GeeHashMap* _tmp95_;
						_tmp92_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, json_node_get_type (), (GBoxedCopyFunc) _vala_JsonNode_copy, _vala_JsonNode_free, NULL, NULL, NULL);
						map = _tmp92_;
						_tmp93_ = self->priv->maps;
						_tmp94_ = key;
						_tmp95_ = map;
						gee_map_set (_tmp93_, _tmp94_, (GeeMap*) _tmp95_);
						_g_object_unref0 (map);
					}
					_tmp96_ = define;
					_tmp97_ = key;
					_tmp98_ = json_object_get_member (_tmp96_, _tmp97_);
					_tmp99_ = __vala_JsonNode_copy0 (_tmp98_);
					__vala_JsonNode_free0 (member);
					member = _tmp99_;
					_tmp100_ = member;
					_tmp101_ = json_node_get_node_type (_tmp100_);
					if (_tmp101_ != JSON_NODE_OBJECT) {
						GError* _tmp102_;
						_tmp102_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "map element must be an object");
						_inner_error_ = _tmp102_;
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_list_free0 (keys);
							__vala_JsonObject_free0 (define);
							__vala_JsonNode_free0 (member);
							__vala_JsonObject_free0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_g_list_free0 (keys);
							__vala_JsonObject_free0 (define);
							__vala_JsonNode_free0 (member);
							__vala_JsonObject_free0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp103_ = self->priv->maps;
					_tmp104_ = key;
					_tmp105_ = gee_map_get (_tmp103_, _tmp104_);
					_tmp106_ = (GeeMap*) _tmp105_;
					_tmp107_ = member;
					_tmp108_ = json_node_get_object (_tmp107_);
					skk_map_file_load_map (self, _tmp106_, _tmp108_);
					_g_object_unref0 (_tmp106_);
				}
			}
		}
		_g_list_free0 (keys);
		__vala_JsonObject_free0 (define);
	}
	__vala_JsonNode_free0 (member);
	__vala_JsonObject_free0 (object);
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (parser);
	_g_free0 (filename);
}


SkkMapFile* skk_map_file_construct (GType object_type, SkkRuleMetadata* metadata, const gchar* type, const gchar* name, GError** error) {
	SkkMapFile * self = NULL;
	GeeHashSet* _tmp0_;
	GeeSet* included;
	SkkRuleMetadata _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (SkkMapFile*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	included = (GeeSet*) _tmp0_;
	_tmp1_ = *metadata;
	_tmp2_ = type;
	_tmp3_ = name;
	skk_map_file_load (self, &_tmp1_, _tmp2_, _tmp3_, included, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (included);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (included);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (included);
	return self;
}


gboolean skk_map_file_has_map (SkkMapFile* self, const gchar* name) {
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->maps;
	_tmp1_ = name;
	_tmp2_ = gee_map_has_key (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


GeeMap* skk_map_file_get (SkkMapFile* self, const gchar* name) {
	GeeMap* result = NULL;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = name;
	_tmp2_ = gee_map_get (_tmp0_, _tmp1_);
	result = (GeeMap*) _tmp2_;
	return result;
}


static void skk_map_file_class_init (SkkMapFileClass * klass) {
	skk_map_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkMapFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = skk_map_file_finalize;
}


static void skk_map_file_instance_init (SkkMapFile * self) {
	GeeHashMap* _tmp0_;
	self->priv = SKK_MAP_FILE_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->maps = (GeeMap*) _tmp0_;
}


static void skk_map_file_finalize (GObject* obj) {
	SkkMapFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_MAP_FILE, SkkMapFile);
	_g_object_unref0 (self->priv->maps);
	G_OBJECT_CLASS (skk_map_file_parent_class)->finalize (obj);
}


GType skk_map_file_get_type (void) {
	static volatile gsize skk_map_file_type_id__volatile = 0;
	if (g_once_init_enter (&skk_map_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkMapFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_map_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkMapFile), 0, (GInstanceInitFunc) skk_map_file_instance_init, NULL };
		GType skk_map_file_type_id;
		skk_map_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkMapFile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&skk_map_file_type_id__volatile, skk_map_file_type_id);
	}
	return skk_map_file_type_id__volatile;
}



