/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include <cassert>

#include "EPUBManifest.h"
#include "EPUBPath.h"
#include "EPUBXMLSink.h"

namespace libepubgen
{

EPUBManifest::EPUBManifest()
  : m_map()
{
}

void EPUBManifest::insert(const EPUBPath &path, const std::string &mimetype, const std::string &id)
{
  if (!m_map.insert(MapType_t::value_type(path.relativeTo(EPUBPath("OEBPS/content.opf")).str(), ValueType_t(mimetype, id))).second)
  {
    assert(!"duplicate entry!");
  }
}

void EPUBManifest::writeTo(EPUBXMLSink &sink)
{
  for (MapType_t::const_iterator it = m_map.begin(); m_map.end() != it; ++it)
  {
    librevenge::RVNGPropertyList attrs;
    attrs.insert("href", it->first.c_str());
    attrs.insert("media-type", it->second.first.c_str());
    attrs.insert("id", it->second.second.c_str());
    sink.insertEmptyElement("item", attrs);
  }
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
