/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_EPUBHTMLGENERATOR_H
#define INCLUDED_EPUBHTMLGENERATOR_H

#include <librevenge/librevenge.h>

#include <boost/shared_ptr.hpp>

#include "EPUBXMLSink.h"

namespace libepubgen
{

struct EPUBHTMLGeneratorImpl;
class EPUBImageManager;
class EPUBListStyleManager;
class EPUBSpanStyleManager;
class EPUBParagraphStyleManager;
class EPUBTableStyleManager;
class EPUBPath;

class EPUBHTMLGenerator : public librevenge::RVNGTextInterface
{
public:
  EPUBHTMLGenerator(EPUBXMLSink &document, EPUBImageManager &imageManager, EPUBListStyleManager &listStyleManager, EPUBParagraphStyleManager &paragraphStyleManager, EPUBSpanStyleManager &spanStyleManager, EPUBTableStyleManager &tableStyleManager, const EPUBPath &path, const EPUBPath &stylesheetPath);
  ~EPUBHTMLGenerator();

  void setDocumentMetaData(const librevenge::RVNGPropertyList &propList);

  void startDocument(const librevenge::RVNGPropertyList &propList);
  void endDocument();

  void defineEmbeddedFont(const librevenge::RVNGPropertyList &propList);

  void definePageStyle(const librevenge::RVNGPropertyList &);
  void openPageSpan(const librevenge::RVNGPropertyList &propList);
  void closePageSpan();
  void openHeader(const librevenge::RVNGPropertyList &propList);
  void closeHeader();
  void openFooter(const librevenge::RVNGPropertyList &propList);
  void closeFooter();

  void defineSectionStyle(const librevenge::RVNGPropertyList &);
  void openSection(const librevenge::RVNGPropertyList &propList);
  void closeSection();

  void defineParagraphStyle(const librevenge::RVNGPropertyList &);
  void openParagraph(const librevenge::RVNGPropertyList &propList);
  void closeParagraph();

  void defineCharacterStyle(const librevenge::RVNGPropertyList &);
  void openSpan(const librevenge::RVNGPropertyList &propList);
  void closeSpan();

  void openLink(const librevenge::RVNGPropertyList &propList);
  void closeLink();

  void insertTab();
  void insertText(const librevenge::RVNGString &text);
  void insertSpace();
  void insertLineBreak();
  void insertField(const librevenge::RVNGPropertyList &propList);

  void openOrderedListLevel(const librevenge::RVNGPropertyList &propList);
  void openUnorderedListLevel(const librevenge::RVNGPropertyList &propList);
  void closeOrderedListLevel();
  void closeUnorderedListLevel();
  void openListElement(const librevenge::RVNGPropertyList &propList);
  void closeListElement();

  void openFootnote(const librevenge::RVNGPropertyList &propList);
  void closeFootnote();
  void openEndnote(const librevenge::RVNGPropertyList &propList);
  void closeEndnote();
  void openComment(const librevenge::RVNGPropertyList &propList);
  void closeComment();
  void openTextBox(const librevenge::RVNGPropertyList &propList);
  void closeTextBox();

  void openTable(const librevenge::RVNGPropertyList &propList);
  void openTableRow(const librevenge::RVNGPropertyList &propList);
  void closeTableRow();
  void openTableCell(const librevenge::RVNGPropertyList &propList);
  void closeTableCell();
  void insertCoveredTableCell(const librevenge::RVNGPropertyList &propList);
  void closeTable();

  void openFrame(const librevenge::RVNGPropertyList &propList);
  void closeFrame();

  void openGroup(const librevenge::RVNGPropertyList &propList);
  void closeGroup();

  void defineGraphicStyle(const librevenge::RVNGPropertyList &propList);
  void drawRectangle(const librevenge::RVNGPropertyList &propList);
  void drawEllipse(const librevenge::RVNGPropertyList &propList);
  void drawPolygon(const librevenge::RVNGPropertyList &propList);
  void drawPolyline(const librevenge::RVNGPropertyList &propList);
  void drawPath(const librevenge::RVNGPropertyList &propList);
  void drawConnector(const librevenge::RVNGPropertyList &propList);

  void insertBinaryObject(const librevenge::RVNGPropertyList &propList);
  void insertEquation(const librevenge::RVNGPropertyList &propList);

private:
  EPUBHTMLGeneratorImpl *m_impl;

  // Unimplemented to prevent compiler from creating crasher ones
  EPUBHTMLGenerator(const EPUBHTMLGenerator &);
  EPUBHTMLGenerator &operator=(const EPUBHTMLGenerator &);
};

typedef boost::shared_ptr<EPUBHTMLGenerator> EPUBHTMLGeneratorPtr_t;

}

#endif /* EPUBHTMLGENERATOR_H */

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
