.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtGet-GC XtRelease-GC wid-get
.na
.TH XtGetGC __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtGetGC, XtReleaseGC \- obtain and destroy a sharable GC
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
GC XtGetGC(Widget \fIw\fP, XtGCMask \fIvalue_mask\fP, XGCValues
*\fIvalues\fP);
.HP
void XtReleaseGC(Widget \fIw\fP, GC \fIgc\fP);
.SH ARGUMENTS
.IP \fIgc\fP 1i
Specifies the GC to be deallocated.
.IP \fIvalues\fP 1i
Specifies the actual values for this GC.
.IP \fIvalue_mask\fP 1i
Specifies which fields of the values are specified.
.IP \fIw\fP 1i
Specifies the widget.
.SH DESCRIPTION
The
.B XtGetGC
function returns a sharable, read-only GC.
The parameters to this function are the same as those for
.B XCreateGC
except that a widget is passed instead of a display.
.B XtGetGC
shares only GCs in which all values in the GC returned by
.B XCreateGC
are the same.
In particular, it does not use the value_mask provided to
determine which fields of the GC a widget considers relevant.
The value_mask is used only to tell the server which fields should be
filled in with widget data and which it should fill in with default values.
For further information about value_mask and values,
see
.B XCreateGC
in the \fI\*(xL\fP.
.LP
The
.B XtReleaseGC
function deallocate the specified shared GC.
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
