#ifndef lint
static const char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#endif

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20120115

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)


#ifndef yyparse
#define yyparse    itex2MML_yyparse
#endif /* yyparse */

#ifndef yylex
#define yylex      itex2MML_yylex
#endif /* yylex */

#ifndef yyerror
#define yyerror    itex2MML_yyerror
#endif /* yyerror */

#ifndef yychar
#define yychar     itex2MML_yychar
#endif /* yychar */

#ifndef yyval
#define yyval      itex2MML_yyval
#endif /* yyval */

#ifndef yylval
#define yylval     itex2MML_yylval
#endif /* yylval */

#ifndef yydebug
#define yydebug    itex2MML_yydebug
#endif /* yydebug */

#ifndef yynerrs
#define yynerrs    itex2MML_yynerrs
#endif /* yynerrs */

#ifndef yyerrflag
#define yyerrflag  itex2MML_yyerrflag
#endif /* yyerrflag */

#ifndef yylhs
#define yylhs      itex2MML_yylhs
#endif /* yylhs */

#ifndef yylen
#define yylen      itex2MML_yylen
#endif /* yylen */

#ifndef yydefred
#define yydefred   itex2MML_yydefred
#endif /* yydefred */

#ifndef yydgoto
#define yydgoto    itex2MML_yydgoto
#endif /* yydgoto */

#ifndef yysindex
#define yysindex   itex2MML_yysindex
#endif /* yysindex */

#ifndef yyrindex
#define yyrindex   itex2MML_yyrindex
#endif /* yyrindex */

#ifndef yygindex
#define yygindex   itex2MML_yygindex
#endif /* yygindex */

#ifndef yytable
#define yytable    itex2MML_yytable
#endif /* yytable */

#ifndef yycheck
#define yycheck    itex2MML_yycheck
#endif /* yycheck */

#ifndef yyname
#define yyname     itex2MML_yyname
#endif /* yyname */

#ifndef yyrule
#define yyrule     itex2MML_yyrule
#endif /* yyrule */
#define YYPREFIX "itex2MML_yy"

#define YYPURE 0

#line 6 "itex2MML.y"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "itex2MML.h"

#define YYSTYPE char *
#define YYPARSE_PARAM_TYPE char **
#define YYPARSE_PARAM ret_str

#define yytext itex2MML_yytext

 extern int yylex ();

 extern char * yytext;

 static void itex2MML_default_error (const char * msg)
   {
     if (msg)
       fprintf(stderr, "Line: %d Error: %s\n", itex2MML_lineno, msg);
   }

 void (*itex2MML_error) (const char * msg) = itex2MML_default_error;

 static void yyerror (char * s)
   {
     char * msg = itex2MML_copy3 (s, " at token ", yytext);
     if (itex2MML_error)
       (*itex2MML_error) (msg);
     itex2MML_free_string (msg);
   }

 /* Note: If length is 0, then buffer is treated like a string; otherwise only length bytes are written.
  */
 static void itex2MML_default_write (const char * buffer, unsigned long length)
   {
     if (buffer)
       {
	 if (length)
	   fwrite (buffer, 1, length, stdout);
	 else
	   fputs (buffer, stdout);
       }
   }

 static void itex2MML_default_write_mathml (const char * mathml)
   {
     if (itex2MML_write)
       (*itex2MML_write) (mathml, 0);
   }

#ifdef itex2MML_CAPTURE
    static char * itex2MML_output_string = "" ;

    const char * itex2MML_output ()
    {
        char * copy = (char *) malloc(strlen(itex2MML_output_string) +1);
        if (copy)
          {
           if (itex2MML_output_string)
             {
               strcpy(copy, itex2MML_output_string);
               if (itex2MML_output_string != "")
                   free(itex2MML_output_string);
             }
           else
             copy[0] = 0;
          }
        itex2MML_output_string = "";
        return copy;
    }

 static void itex2MML_capture (const char * buffer, unsigned long length)
    {
     if (buffer)
       {
         if (length)
           {
              unsigned long first_length = itex2MML_output_string ? strlen(itex2MML_output_string) : 0;
              char * copy  = (char *) malloc(first_length + length + 1);
              if (copy)
                {
                  if (itex2MML_output_string)
                    {
                       strcpy(copy, itex2MML_output_string);
                       if (itex2MML_output_string != "")
                          free(itex2MML_output_string);
                    }
                  else
                     copy[0] = 0;
                  strncat(copy, buffer, length);
                 }
              itex2MML_output_string = copy;
            }
         else
            {
              char * copy = itex2MML_copy2(itex2MML_output_string, buffer);
              if (itex2MML_output_string != "")
                 free(itex2MML_output_string);
              itex2MML_output_string = copy;
            }
        }
    }

    static void itex2MML_capture_mathml (const char * buffer)
    {
       char * temp = itex2MML_copy2(itex2MML_output_string, buffer);
       if (itex2MML_output_string != "")
         free(itex2MML_output_string);
       itex2MML_output_string = temp;
    }
    void (*itex2MML_write) (const char * buffer, unsigned long length) = itex2MML_capture;
    void (*itex2MML_write_mathml) (const char * mathml) = itex2MML_capture_mathml;
#else
    void (*itex2MML_write) (const char * buffer, unsigned long length) = itex2MML_default_write;
    void (*itex2MML_write_mathml) (const char * mathml) = itex2MML_default_write_mathml;
#endif 

 char * itex2MML_empty_string = "";

 /* Create a copy of a string, adding space for extra chars
  */
 char * itex2MML_copy_string_extra (const char * str, unsigned extra)
   {
     char * copy = (char *) malloc(extra + (str ? strlen (str) : 0) + 1);
     if (copy)
       {
	 if (str)
	   strcpy(copy, str);
	 else
	   copy[0] = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending two strings
  */
 char * itex2MML_copy3 (const char * first, const char * second, const char * third)
   {
     int  first_length =  first ? strlen( first) : 0;
     int second_length = second ? strlen(second) : 0;
     int  third_length =  third ? strlen( third) : 0;

     char * copy = (char *) malloc(first_length + second_length + third_length + 1);

     if (copy)
       {
	 if (first)
	   strcpy(copy, first);
	 else
	   copy[0] = 0;

	 if (second) strcat(copy, second);
	 if ( third) strcat(copy,  third);
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending a second string
  */
 char * itex2MML_copy2 (const char * first, const char * second)
   {
     return itex2MML_copy3(first, second, 0);
   }

 /* Create a copy of a string
  */
 char * itex2MML_copy_string (const char * str)
   {
     return itex2MML_copy3(str, 0, 0);
   }

 /* Create a copy of a string, escaping unsafe characters for XML
  */
 char * itex2MML_copy_escaped (const char * str)
   {
     unsigned long length = 0;

     const char * ptr1 = str;

     char * ptr2 = 0;
     char * copy = 0;

     if ( str == 0) return itex2MML_empty_string;
     if (*str == 0) return itex2MML_empty_string;

     while (*ptr1)
       {
	 switch (*ptr1)
	   {
	   case '<':  /* &lt;   */
	   case '>':  /* &gt;   */
	     length += 4;
	     break;
	   case '&':  /* &amp;  */
	     length += 5;
	     break;
	   case '\'': /* &apos; */
	   case '"':  /* &quot; */
	   case '-':  /* &#x2d; */
	     length += 6;
	     break;
	   default:
	     length += 1;
	     break;
	   }
	 ++ptr1;
       }

     copy = (char *) malloc (length + 1);

     if (copy)
       {
	 ptr1 = str;
	 ptr2 = copy;

	 while (*ptr1)
	   {
	     switch (*ptr1)
	       {
	       case '<':
		 strcpy (ptr2, "&lt;");
		 ptr2 += 4;
		 break;
	       case '>':
		 strcpy (ptr2, "&gt;");
		 ptr2 += 4;
		 break;
	       case '&':  /* &amp;  */
		 strcpy (ptr2, "&amp;");
		 ptr2 += 5;
		 break;
	       case '\'': /* &apos; */
		 strcpy (ptr2, "&apos;");
		 ptr2 += 6;
		 break;
	       case '"':  /* &quot; */
		 strcpy (ptr2, "&quot;");
		 ptr2 += 6;
		 break;
	       case '-':  /* &#x2d; */
		 strcpy (ptr2, "&#x2d;");
		 ptr2 += 6;
		 break;
	       default:
		 *ptr2++ = *ptr1;
		 break;
	       }
	     ++ptr1;
	   }
	 *ptr2 = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a hex character reference string corresponding to code
  */
 char * itex2MML_character_reference (unsigned long int code)
   {
#define ENTITY_LENGTH 10
     char * entity = (char *) malloc(ENTITY_LENGTH);
     sprintf(entity, "&#x%05lx;", code);
     return entity;
   }

 void itex2MML_free_string (char * str)
   {
     if (str && str != itex2MML_empty_string)
       free(str);
   }

#line 371 "y.tab.c"

#ifndef YYSTYPE
typedef int YYSTYPE;
#endif

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define TEXOVER 257
#define TEXATOP 258
#define CHAR 259
#define STARTMATH 260
#define STARTDMATH 261
#define ENDMATH 262
#define MI 263
#define MIB 264
#define MN 265
#define MO 266
#define SUP 267
#define SUB 268
#define MROWOPEN 269
#define MROWCLOSE 270
#define LEFT 271
#define RIGHT 272
#define BIG 273
#define BBIG 274
#define BIGG 275
#define BBIGG 276
#define BIGL 277
#define BBIGL 278
#define BIGGL 279
#define BBIGGL 280
#define FRAC 281
#define TFRAC 282
#define OPERATORNAME 283
#define MATHOP 284
#define MATHBIN 285
#define MATHREL 286
#define MOP 287
#define MOL 288
#define MOLL 289
#define MOF 290
#define MOR 291
#define PERIODDELIM 292
#define OTHERDELIM 293
#define LEFTDELIM 294
#define RIGHTDELIM 295
#define MOS 296
#define MOB 297
#define SQRT 298
#define ROOT 299
#define BINOM 300
#define TBINOM 301
#define UNDER 302
#define OVER 303
#define OVERBRACE 304
#define UNDERLINE 305
#define UNDERBRACE 306
#define UNDEROVER 307
#define TENSOR 308
#define MULTI 309
#define ARRAYALIGN 310
#define COLUMNALIGN 311
#define ARRAY 312
#define COLSEP 313
#define ROWSEP 314
#define ARRAYOPTS 315
#define COLLAYOUT 316
#define COLALIGN 317
#define ROWALIGN 318
#define ALIGN 319
#define EQROWS 320
#define EQCOLS 321
#define ROWLINES 322
#define COLLINES 323
#define FRAME 324
#define PADDING 325
#define ATTRLIST 326
#define ITALICS 327
#define BOLD 328
#define BOXED 329
#define SLASHED 330
#define RM 331
#define BB 332
#define ST 333
#define END 334
#define BBLOWERCHAR 335
#define BBUPPERCHAR 336
#define BBDIGIT 337
#define CALCHAR 338
#define FRAKCHAR 339
#define CAL 340
#define FRAK 341
#define CLAP 342
#define LLAP 343
#define RLAP 344
#define ROWOPTS 345
#define TEXTSIZE 346
#define SCSIZE 347
#define SCSCSIZE 348
#define DISPLAY 349
#define TEXTSTY 350
#define TEXTBOX 351
#define TEXTSTRING 352
#define XMLSTRING 353
#define CELLOPTS 354
#define ROWSPAN 355
#define COLSPAN 356
#define THINSPACE 357
#define MEDSPACE 358
#define THICKSPACE 359
#define QUAD 360
#define QQUAD 361
#define NEGSPACE 362
#define PHANTOM 363
#define HREF 364
#define UNKNOWNCHAR 365
#define EMPTYMROW 366
#define STATLINE 367
#define TOOLTIP 368
#define TOGGLE 369
#define FGHIGHLIGHT 370
#define BGHIGHLIGHT 371
#define SPACE 372
#define INTONE 373
#define INTTWO 374
#define INTTHREE 375
#define BAR 376
#define WIDEBAR 377
#define VEC 378
#define WIDEVEC 379
#define HAT 380
#define WIDEHAT 381
#define CHECK 382
#define WIDECHECK 383
#define TILDE 384
#define WIDETILDE 385
#define DOT 386
#define DDOT 387
#define DDDOT 388
#define DDDDOT 389
#define UNARYMINUS 390
#define UNARYPLUS 391
#define BEGINENV 392
#define ENDENV 393
#define MATRIX 394
#define PMATRIX 395
#define BMATRIX 396
#define BBMATRIX 397
#define VMATRIX 398
#define VVMATRIX 399
#define SVG 400
#define ENDSVG 401
#define SMALLMATRIX 402
#define CASES 403
#define ALIGNED 404
#define GATHERED 405
#define SUBSTACK 406
#define PMOD 407
#define RMCHAR 408
#define COLOR 409
#define BGCOLOR 410
#define XARROW 411
#define OPTARGOPEN 412
#define OPTARGCLOSE 413
#define YYERRCODE 256
static const short itex2MML_yylhs[] = {                  -1,
    0,    1,    1,    1,    1,    1,    2,    3,    3,    3,
    3,    4,    4,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,    5,    5,    5,    5,    5,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,   72,
   72,   72,   73,   73,   73,   78,   78,   78,   78,   78,
   78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
   78,   78,   78,   78,   78,   77,   10,   11,   12,    8,
   13,    6,   14,   14,   14,   14,   14,   14,   14,   14,
   14,   14,   14,   14,   14,   14,   14,   14,   14,   54,
   64,   65,   66,   67,   68,   69,   69,   39,   38,   37,
   55,   40,   41,   42,   43,   44,   45,   51,   52,   46,
   47,   48,   48,   49,   79,   79,   80,   80,   80,   50,
   81,   81,   82,   53,   83,   83,   84,   56,   57,   58,
   59,   60,   61,   62,   63,   15,   15,   16,   16,   16,
   85,   85,   86,   86,   86,   86,   17,   17,   76,   70,
   70,   71,   71,   18,   18,   33,   34,   32,   23,   23,
   24,   24,   26,   27,   28,   29,   31,   31,   30,   30,
   25,   25,   19,   20,   20,   21,   21,   22,   22,   35,
   35,   36,   74,   74,   74,   74,   74,   74,   74,   74,
   74,   74,   74,   74,   74,   74,   88,   88,   75,    9,
    9,   89,   89,   90,   90,   90,   90,   90,   90,   90,
   90,   90,   90,   91,   92,   93,   94,   95,   96,   97,
   98,   99,  100,   87,   87,  101,  101,  102,  102,  103,
  105,  105,  106,  106,  104,  104,  104,  107,  107,  108,
  108,  108,  108,  109,  110,
};
static const short itex2MML_yylen[] = {                   2,
    1,    0,    1,    1,    2,    2,    1,    2,    2,    3,
    3,    1,    2,    5,    3,    5,    3,    5,    3,    5,
    3,    5,    5,    3,    3,    2,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    3,    3,    3,    1,    1,    1,    1,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    2,    2,    2,    2,   10,
    3,    3,    3,    3,    3,    3,    3,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    4,    1,    2,    4,    1,    2,    1,    1,    1,    4,
    1,    2,    1,    4,    1,    2,    1,    1,    1,    1,
    1,    1,    1,    2,    3,    5,    3,    8,    6,    6,
    1,    2,    4,    2,    2,    3,    3,    3,    2,    5,
    5,    5,    5,    3,    3,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    5,    3,    5,    3,    2,    3,    5,
    4,    1,    5,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    9,    8,    4,    3,    2,    1,    4,    4,
    8,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    1,    3,    1,    1,    1,    3,    5,
    1,    2,    1,    1,    0,    1,    5,    1,    2,    1,
    1,    1,    1,    2,    2,
};
static const short itex2MML_yydefred[] = {                0,
    7,    0,    0,    0,    0,    3,    4,    8,  129,  130,
  131,  135,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  144,  136,  137,  141,  145,  142,  140,  139,  138,  143,
  132,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  188,  189,  190,  191,  192,  193,    0,    0,  126,
  242,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  127,  128,    0,    0,    0,  172,    0,    0,    0,
    0,   12,    0,    0,    0,   29,   30,   31,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
   65,   66,   67,   68,    0,   70,   71,   72,   73,   74,
   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,   88,   89,   90,   91,   92,    0,   96,
   97,   98,   99,  134,    9,    0,    5,    6,  133,   27,
   32,   26,    0,    0,  102,  101,  100,  108,  106,  107,
  111,  109,  110,  114,  112,  113,  117,  115,  116,  119,
  118,  121,  120,  123,  122,  125,  124,    0,    0,  146,
  147,  148,  149,    0,  233,    0,    0,    0,    0,    0,
  218,  217,  216,    0,    0,    0,    0,    0,  167,  170,
  169,  168,    0,    0,    0,    0,  160,  159,  158,  164,
  165,  166,  162,  163,  161,  194,    0,    0,    0,    0,
    0,    0,    0,  219,  220,  221,  222,  231,  232,  229,
  230,  227,  228,  223,  224,  225,  226,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  209,    0,    0,    0,  238,   10,   13,    0,    0,    0,
    0,    0,    0,  173,    0,   11,    0,    0,   94,   93,
  207,  208,    0,  235,  214,  215,  237,  239,    0,    0,
    0,    0,    0,  201,    0,    0,    0,    0,    0,    0,
    0,  284,    0,  287,  288,    0,  177,  178,  179,    0,
  175,  187,    0,  185,  183,    0,  181,  195,  151,  152,
  153,  154,  155,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  256,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,  241,  205,    0,    0,    0,
  202,    0,    0,    0,    0,    0,  260,    0,    0,  171,
  174,  176,  184,  186,  180,  182,    0,    0,  258,    0,
    0,    0,    0,    0,    0,    0,  255,    0,    0,    0,
    0,  259,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  105,  104,  103,  210,  212,  234,  206,    0,  196,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  262,  264,  265,  266,  267,  268,  269,
  270,  271,  272,  273,  293,  294,    0,  291,    0,    0,
  300,  301,    0,  298,  302,  303,  285,  289,    0,    0,
  257,    0,  243,  245,  246,  248,  247,  249,  250,  251,
  252,  244,  236,  240,   16,   14,   23,   22,   20,   18,
  211,  213,  203,    0,  199,  200,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,    0,  263,    0,  292,
  304,  305,    0,  299,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  198,  261,    0,    0,  254,    0,
  253,  150,
};
static const short itex2MML_yydgoto[] = {                 4,
    5,    6,    7,  330,  112,  189,  114,  191,  116,  117,
  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
  128,  129,  130,  131,  132,  133,  134,  135,  136,  137,
  138,  139,  140,  141,  142,  143,  144,  145,  146,  147,
  148,  149,  150,  151,  152,  153,  154,  155,  156,  157,
  158,  159,  160,  161,  162,  163,  164,  165,  166,  167,
  168,  169,  170,  171,  172,  173,  174,  175,  176,  177,
  178,  179,  382,  180,  181,  182,  183,  184,  340,  341,
  346,  347,  343,  344,  323,  324,  331,  410,  453,  454,
  455,  456,  457,  458,  459,  460,  461,  462,  463,  464,
  332,  333,  334,  335,  467,  468,  473,  474,  475,  476,
};
static const short itex2MML_yysindex[] = {              -49,
    0, 3351, 3501,    0,  -49,    0,    0,    0,    0,    0,
    0,    0, 5442, 5442, 5144,  -79,  -75,  -69,  -60,  -45,
 -201, -186, -148, -144, 5442, 5442, -322, -279, -251, -249,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3950, 5442, 5442, 5442, 5442, 5442, 5442, 5442, 5442,
 5442, 5442, -261, -141, 5442, 5442, 5442, 5442, -244, -198,
 -177, -173, 5442, 5442, 5442, 5442, 5442, 5442, 5442, 5442,
 -220,    0,    0,    0,    0,    0,    0, 5442, -214,    0,
    0, -211, -199, 5442, -160, -156, -157, 5442, 5442, 5442,
 5442, 5442, 5442, 5442, 5442, 5442, 5442, 5442, 5442, 5442,
 5442,    0,    0, -200,  -89, 5442,    0, -137, -133, 4100,
 3651,    0,  -40,  -12,   -8,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -207,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 5144,    0,
    0,    0,    0,    0,    0, 3801,    0,    0,    0,    0,
    0,    0, 2589,  -99,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 5442, 5442,    0,
    0,    0,    0, 5144,    0, 5442, 5442, 5442, 5442, 5442,
    0,    0,    0, 5442,  -16,   -1, 5442, 4250,    0,    0,
    0,    0, -191,  -73, -117, -107,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 5442, 5442, 5442, 5442,
 5442, 5442, -116,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -231, 4399, 4399,
 4399, 4399, 4399, 4399, -310, 4399, 4399, 4399, 4399, 4399,
    0, 5144, 5144, 5144,    0,    0,    0, 5442, 5442, 5442,
 5442, 5442, 5442,    0, 2744,    0, 5144, 5144,    0,    0,
    0,    0, 3048,    0,    0,    0,    0,    0, 5442, 5442,
 5293,   -1,   -1,    0,  -95,   -4,    4,    5,   14, 5144,
 -188,    0,  -37,    0,    0, -265,    0,    0,    0, -172,
    0,    0, -302,    0,    0, -195,    0,    0,    0,    0,
    0,    0,    0,  -36,  -44,  -14, -299, -289, -287, -280,
 -277, -273,  -97,    0, -272, -270, -269, -268, -183, 5144,
 5144, 3199,   41,   43,   44,   46,   54,   76, 5144, 5144,
 -114,    0, 4548, 4697, 5442,    0,    0, 5442,   79,  -85,
    0, 5442,   -1,   16,  -46, -219,    0, 4399, 4846,    0,
    0,    0,    0,    0,    0,    0,   15,  -14,    0, -216,
  -47,  -43,  -39,  -48,  -42,  -41,    0,  -51,  -50,  -38,
  -34,    0, 5591, 5442, 5442, 5442, 5442, 5442, 5442, 4995,
 4995,    0,    0,    0,    0,    0,    0,    0, 5442,    0,
 -255,  -80,   33,   34,   35,   36,   38,   39,   47,   48,
   49,   50,  -78,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -232,    0,   53,   57,
    0,    0, -241,    0,    0,    0,    0,    0,  -11, -192,
    0, 4399,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   -1,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 4399,    0, 4846,    0,
    0,    0, 5144,    0,   51, 4399, -260,  -61, -180,  -37,
 5144,   55, -236,   60,    0,    0,    9,   68,    0,   56,
    0,    0,
};
static const short itex2MML_yyrindex[] = {              389,
    0,    0,    0,    0,  391,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1961, 2118, 2275,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  705,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 2899,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -217,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -293, -293,
 -293, -293, -293, -293,    0, -293, -293, -293, -293, -217,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 2432,    0,    0,    0,    0,    0,    0, -266,
    0,    0, -263,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -246,
 -239,    0,  862, 1019, 1176, 1333, 1490, 1647,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1804,    0,
    0,    0,    0,    0,    0,    0,    0, -264, -264,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -293,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -217,    0, -264,    0,
    0,    0,    0,    0,    0, -293,    0,    0,    0, -253,
 -242,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,
};
static const short itex2MML_yygindex[] = {                0,
    0,  387,  388,    7,  -76,   -2,  527,   37,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  151,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -162,    0,    0,    0,    0,    0,    0,   58,
    0,   59,    0,   52, -234, -320, -224,   -9,    0,  -53,
    0, -315, -312,    0,    0,    0,    0,    0,    0,    0,
    3, -115,    0,   11,    0,  -65,    0,  -70,    0,    0,
};
#define YYTABLESIZE 6002
static const short itex2MML_yytable[] = {               113,
  113,  325,  391,  296,  391,  295,  286,  236,  111,  186,
  156,  156,  113,  504,  398,  156,  290,  157,  157,  295,
  295,  193,  157,  156,  398,  156,  398,  297,  523,  220,
  157,  403,  157,  398,  297,  342,  398,  519,  115,  115,
  398,  398,  363,  398,  398,  398,  296,  296,  295,  295,
  286,  115,  295,  398,  357,  358,  359,  360,  361,  362,
  290,  365,  366,  367,  368,  369,  156,  156,  400,  391,
  297,  297,  221,  157,  157,  444,  445,  398,  355,  465,
  471,  397,  466,  472,  444,  445,  422,  390,  243,  536,
  364,  210,  211,  411,  481,  295,  295,  444,  445,  295,
  222,  356,  223,  412,  237,  413,  212,  213,  113,  297,
  505,  278,  414,  469,  470,  415,  297,  482,  481,  416,
  418,  391,  419,  420,  421,  398,  296,  238,  295,  286,
  398,  255,  534,  398,  244,  469,  470,  257,  405,  290,
  258,  526,  304,  345,  214,  215,  156,  115,  216,  217,
  297,  465,  259,  157,  466,  245,  538,  471,  442,  246,
  472,  401,  337,  338,  339,  261,  156,  300,  301,  262,
  310,  320,  321,  157,  392,  263,  113,  432,  433,  290,
  434,  320,  321,  113,  440,  305,  320,  321,  292,  506,
  113,  517,  293,  279,  280,  281,  282,  283,  284,  285,
  304,  286,  287,  288,  289,  320,  321,  391,  535,    1,
    2,    3,  195,  196,  197,  115,  107,  198,  199,  200,
  342,  113,  115,  201,  202,  203,  298,  299,  297,  115,
  313,  345,  204,  205,  206,  113,  297,  443,  444,  445,
  446,  447,  448,  449,  450,  451,  452,  207,  208,  209,
  320,  321,  322,  297,  300,  301,  354,  527,  302,  303,
  115,  337,  338,  339,  393,  320,  321,  501,  502,  528,
  444,  445,  394,  395,  115,  399,  113,  113,  113,  113,
  113,  113,  396,  113,  113,  113,  113,  113,  408,  113,
  113,  113,  529,  297,  297,  297,  409,  407,  370,  371,
  372,  533,  113,  417,  113,  113,  297,  297,  424,  425,
  113,  426,  427,  383,  384,  115,  115,  115,  115,  115,
  115,  428,  115,  115,  115,  115,  115,  113,  115,  115,
  115,  443,  444,  445,  446,  447,  448,  449,  450,  451,
  452,  115,  429,  115,  115,  439,  483,  479,  486,  115,
  489,  484,  490,  297,  297,  487,  485,  488,  507,  508,
  509,  510,  525,  511,  512,  491,  115,  113,  113,  113,
  492,  539,  513,  514,  515,  516,  113,  113,  521,  541,
  113,  113,  522,  540,  532,  430,  431,  537,    2,  542,
    1,  187,  188,  336,  404,  113,  113,  402,  480,  518,
  477,  520,  524,  530,  406,    0,  115,  115,  115,  478,
    0,    0,    0,    0,    0,  115,  115,    0,    0,  115,
  115,    0,    0,    0,    0,    0,    0,  113,  113,    0,
    0,    0,    0,    0,  115,  115,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  297,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  115,  115,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  113,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  113,    0,  113,    0,  115,    0,
  113,    0,    0,  113,    0,    0,    0,    0,  113,  531,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  190,
  192,  194,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  218,  219,  115,    0,  115,    0,    0,    0,  115,
    0,    0,  115,    0,    0,    0,    0,  115,  225,  226,
  227,  228,  229,  230,  231,  232,  233,  234,  235,    0,
    0,  239,  240,  241,  242,    0,    0,    0,    0,  247,
  248,  249,  250,  251,  252,  253,  254,    0,    0,    0,
    0,    0,    0,    0,  256,    0,    0,    0,    0,    0,
  260,    0,    0,    0,  264,  265,  266,  267,  268,  269,
  270,  271,  272,  273,  274,  275,  276,  277,    0,    0,
    0,    0,  291,    0,    0,    0,  295,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  311,  312,    0,    0,    0,    0,
    0,    0,  314,  315,  316,  317,  318,    0,    0,    0,
  319,    0,    0,  326,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  348,  349,  350,  351,  352,  353,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  373,  374,  375,  376,  377,  378,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  386,  387,  389,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  437,    0,    0,  438,    0,    0,    0,  441,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  494,
  495,  496,  497,  498,  499,  500,    0,    0,    0,    0,
    0,   69,   69,    0,    0,  503,   69,   69,   69,   69,
   69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
   69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
   69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
   69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
   69,   69,   69,   69,    0,    0,   69,   69,   69,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   69,   69,   69,   69,   69,   69,    0,    0,    0,
    0,    0,    0,    0,   69,   69,   69,   69,   69,    0,
   69,   69,   69,   69,   69,   69,    0,    0,    0,    0,
    0,   69,   69,   69,   69,   69,   69,   69,   69,   69,
   69,   69,   69,   69,   69,   69,   69,    0,    0,    0,
   69,   69,   69,   69,   69,   69,   69,   69,   69,   69,
   69,   69,   69,   69,   69,   69,   69,   69,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   69,   69,    0,   69,   69,   69,    0,   69,   17,   17,
    0,    0,    0,   17,   17,   17,   17,   17,   17,    0,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,    0,    0,   17,   17,   17,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   17,   17,
   17,   17,   17,   17,    0,    0,    0,    0,    0,    0,
    0,   17,   17,   17,   17,   17,    0,   17,   17,   17,
   17,   17,   17,    0,    0,    0,    0,    0,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,    0,    0,    0,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   17,   17,   17,
   17,   17,   17,    0,   17,   15,   15,    0,    0,    0,
   15,   15,   15,   15,   15,    0,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,    0,    0,
   15,   15,   15,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   15,   15,   15,   15,   15,
   15,    0,    0,    0,    0,    0,    0,    0,   15,   15,
   15,   15,   15,    0,   15,   15,   15,   15,   15,   15,
    0,    0,    0,    0,    0,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,    0,    0,    0,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   15,   15,   15,   15,   15,   15,
    0,   15,   25,   25,    0,    0,    0,   25,   25,   25,
   25,   25,   25,    0,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,    0,    0,   25,   25,   25,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   25,   25,   25,   25,   25,   25,    0,    0,
    0,    0,    0,    0,    0,   25,   25,   25,   25,   25,
    0,   25,   25,   25,   25,   25,   25,    0,    0,    0,
    0,    0,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,    0,    0,
    0,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   25,   25,   25,   25,   25,   25,    0,   25,   24,
   24,    0,    0,    0,   24,   24,   24,   24,   24,    0,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,    0,    0,   24,   24,   24,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   24,
   24,   24,   24,   24,   24,    0,    0,    0,    0,    0,
    0,    0,   24,   24,   24,   24,   24,    0,   24,   24,
   24,   24,   24,   24,    0,    0,    0,    0,    0,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,    0,    0,    0,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   24,   24,
   24,   24,   24,   24,    0,   24,   21,   21,    0,    0,
    0,   21,   21,   21,   21,   21,   21,    0,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,    0,
    0,   21,   21,   21,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   21,   21,   21,   21,
   21,   21,    0,    0,    0,    0,    0,    0,    0,   21,
   21,   21,   21,   21,    0,   21,   21,   21,   21,   21,
   21,    0,    0,    0,    0,    0,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,    0,    0,    0,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   21,   21,   21,   21,   21,
   21,    0,   21,   19,   19,    0,    0,    0,   19,   19,
   19,   19,   19,    0,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,    0,    0,   19,   19,
   19,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   19,   19,   19,   19,   19,   19,    0,
    0,    0,    0,    0,    0,    0,   19,   19,   19,   19,
   19,    0,   19,   19,   19,   19,   19,   19,    0,    0,
    0,    0,    0,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,    0,
    0,    0,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   19,   19,   19,   19,   19,   19,    0,   19,
  204,  204,    0,    0,    0,  204,  204,  204,  204,  204,
    0,  204,  204,  204,  204,  204,  204,  204,  204,  204,
  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
  204,  204,  204,    0,    0,  204,  204,  204,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  204,  204,  204,  204,  204,  204,    0,    0,    0,    0,
    0,    0,    0,  204,  204,  204,  204,  204,    0,  204,
  204,  204,  204,  204,  204,    0,    0,    0,    0,    0,
  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
  204,  204,  204,  204,  204,  204,    0,    0,    0,  204,
  204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
  204,  204,  204,  204,  204,  204,  204,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  204,
  204,  204,  204,  204,  204,    0,  204,  133,  133,    0,
    0,    0,  133,  133,  133,  133,  133,    0,    0,  133,
  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,
  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,
  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,
  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,
    0,    0,  133,  133,  133,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  133,  133,  133,
  133,  133,  133,    0,    0,    0,    0,    0,    0,    0,
  133,  133,  133,  133,  133,    0,  133,  133,  133,  133,
  133,  133,    0,    0,    0,    0,    0,  133,  133,  133,
  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,
  133,  133,  133,    0,    0,    0,  133,  133,  133,  133,
  133,  133,  133,  133,  133,  133,  133,  133,  133,  133,
  133,  133,  133,  133,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  133,  133,  133,  133,
  133,  133,    0,  133,   28,   28,    0,    0,    0,   28,
   28,   28,   28,   28,    0,    0,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,    0,    0,   28,
   28,   28,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   28,   28,   28,   28,   28,   28,
    0,    0,    0,    0,    0,    0,    0,   28,   28,   28,
   28,   28,    0,   28,   28,   28,   28,   28,   28,    0,
    0,    0,    0,    0,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
    0,    0,    0,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   28,   28,   28,   28,   28,   28,    0,
   28,   32,   32,    0,    0,    0,   32,   32,   32,   32,
   32,    0,    0,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,    0,    0,   32,   32,   32,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   32,   32,   32,   32,   32,   32,    0,    0,    0,
    0,    0,    0,    0,   32,   32,   32,   32,   32,    0,
   32,   32,   32,   32,   32,   32,    0,    0,    0,    0,
    0,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,    0,    0,    0,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   32,   32,   32,   32,   32,   32,    0,   32,  197,  197,
    0,    0,    0,  197,  197,  197,  197,  197,    0,    0,
  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
  197,    0,    0,  197,  197,  197,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  197,  197,
  197,  197,  197,  197,    0,    0,    0,    0,    0,    0,
    0,  197,  197,  197,  197,  197,    0,  197,  197,  197,
  197,  197,  197,    0,    0,    0,    0,    0,  197,  197,
  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
  197,  197,  197,  197,    0,    0,    0,  197,  197,  197,
  197,  197,  197,  197,  197,  197,  197,  197,  197,  197,
  197,  197,  197,  197,  197,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  197,  197,  197,
  197,  197,  197,    0,  197,  307,  308,    0,    0,    0,
    0,    9,   10,   11,   12,   13,   14,   15,  309,   16,
    0,   17,   18,   19,   20,   21,   22,   23,   24,   25,
   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   53,    0,    0,
   54,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   55,   56,   57,   58,   59,
   60,    0,    0,    0,    0,    0,    0,    0,   61,   62,
   63,   64,   65,    0,   66,   67,   68,   69,   70,   71,
    0,    0,    0,    0,    0,   72,   73,   74,   75,   76,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,    0,    0,    0,   88,   89,   90,   91,   92,   93,
   94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  105,  106,  107,  108,  109,  110,
  379,  380,    0,    0,    0,    0,    9,   10,   11,   12,
   13,   14,   15,    0,   16,  381,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
   51,   52,   53,    0,    0,   54,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   55,   56,   57,   58,   59,   60,    0,    0,    0,    0,
    0,    0,    0,   61,   62,   63,   64,   65,    0,   66,
   67,   68,   69,   70,   71,    0,    0,    0,    0,    0,
   72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
   82,   83,   84,   85,   86,   87,    0,    0,    0,   88,
   89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
   99,  100,  101,  102,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  105,
  106,  107,  108,  109,  110,   28,   28,    0,    0,    0,
    0,   28,   28,   28,   28,    0,    0,   28,    0,   28,
    0,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,    0,    0,
   28,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   28,   28,   28,   28,   28,
   28,    0,    0,    0,    0,    0,    0,    0,   28,   28,
   28,   28,   28,    0,   28,   28,   28,   28,   28,   28,
    0,    0,    0,    0,    0,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,    0,    0,    0,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   28,   28,   28,   28,   28,   28,
    9,   10,   11,   12,   13,   14,   15,    0,   16,    0,
   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
   47,   48,   49,   50,   51,   52,   53,    0,    0,   54,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   55,   56,   57,   58,   59,   60,
    0,    0,    0,    0,    0,    0,    0,   61,   62,   63,
   64,   65,    0,   66,   67,   68,   69,   70,   71,    0,
    0,    0,    0,    0,   72,   73,   74,   75,   76,   77,
   78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
    0,    0,    0,   88,   89,   90,   91,   92,   93,   94,
   95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  105,  106,  107,  108,  109,  110,    0,
  385,    9,   10,   11,   12,   13,   14,   15,    0,   16,
    0,   17,   18,   19,   20,   21,   22,   23,   24,   25,
   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   53,    0,    0,
   54,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   55,   56,   57,   58,   59,
   60,    0,    0,    0,    0,    0,    0,    0,   61,   62,
   63,   64,   65,    0,   66,   67,   68,   69,   70,   71,
    0,    0,    0,    0,    0,   72,   73,   74,   75,   76,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,    0,    0,    0,   88,   89,   90,   91,   92,   93,
   94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  105,  106,  107,  108,  109,  110,
    0,  423,    8,    9,   10,   11,   12,   13,   14,   15,
    0,   16,    0,   17,   18,   19,   20,   21,   22,   23,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
    0,    0,   54,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   55,   56,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
   61,   62,   63,   64,   65,    0,   66,   67,   68,   69,
   70,   71,    0,    0,    0,    0,    0,   72,   73,   74,
   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,    0,    0,    0,   88,   89,   90,   91,
   92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
  102,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  105,  106,  107,  108,
  109,  110,  185,    9,   10,   11,   12,   13,   14,   15,
    0,   16,    0,   17,   18,   19,   20,   21,   22,   23,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
    0,    0,   54,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   55,   56,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
   61,   62,   63,   64,   65,    0,   66,   67,   68,   69,
   70,   71,    0,    0,    0,    0,    0,   72,   73,   74,
   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,    0,    0,    0,   88,   89,   90,   91,
   92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
  102,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  105,  106,  107,  108,
  109,  110,  296,    9,   10,   11,   12,   13,   14,   15,
    0,   16,    0,   17,   18,   19,   20,   21,   22,   23,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
    0,    0,   54,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   55,   56,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
   61,   62,   63,   64,   65,    0,   66,   67,   68,   69,
   70,   71,    0,    0,    0,    0,    0,   72,   73,   74,
   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,    0,    0,    0,   88,   89,   90,   91,
   92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
  102,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  105,  106,  107,  108,
  109,  110,  306,    9,   10,   11,   12,   13,   14,   15,
    0,   16,    0,   17,   18,   19,   20,   21,   22,   23,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
    0,    0,   54,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   55,   56,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
   61,   62,   63,   64,   65,    0,   66,   67,   68,   69,
   70,   71,    0,    0,    0,    0,    0,   72,   73,   74,
   75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,    0,    0,    0,   88,   89,   90,   91,
   92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
  102,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  105,  106,  107,  108,
  109,  110,    9,   10,   11,   12,    0,    0,   15,    0,
   16,    0,   17,   18,   19,   20,   21,   22,   23,   24,
   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   45,   46,   47,   48,   49,   50,   51,   52,   53,    0,
    0,   54,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   55,   56,   57,   58,
   59,   60,    0,    0,    0,    0,    0,    0,    0,   61,
   62,   63,   64,   65,    0,   66,   67,   68,   69,   70,
   71,    0,    0,    0,    0,    0,   72,   73,   74,   75,
   76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
   86,   87,    0,    0,    0,   88,   89,   90,   91,   92,
   93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  105,  106,  107,  108,  109,
  110,  224,    9,   10,   11,   12,    0,    0,   15,    0,
   16,    0,   17,   18,   19,   20,   21,   22,   23,   24,
   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   45,   46,   47,   48,   49,   50,   51,   52,   53,    0,
    0,   54,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   55,   56,   57,   58,
   59,   60,    0,    0,    0,    0,    0,    0,    0,   61,
   62,   63,   64,   65,    0,   66,   67,   68,   69,   70,
   71,    0,    0,    0,    0,    0,   72,   73,   74,   75,
   76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
   86,   87,    0,    0,    0,   88,   89,   90,   91,   92,
   93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  105,  106,  107,  108,  109,
  110,  294,    9,   10,   11,   12,   13,   14,   15,    0,
   16,    0,   17,   18,   19,   20,   21,   22,   23,   24,
   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   45,   46,   47,   48,   49,   50,   51,   52,   53,    0,
    0,   54,    0,    0,  327,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   55,   56,   57,   58,
   59,   60,    0,    0,    0,    0,    0,    0,    0,   61,
   62,   63,   64,   65,  328,   66,   67,   68,   69,   70,
   71,    0,    0,  329,    0,    0,   72,   73,   74,   75,
   76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
   86,   87,    0,    0,    0,   88,   89,   90,   91,   92,
   93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  105,  106,  107,  108,  109,
  110,    9,   10,   11,   12,   13,   14,   15,    0,   16,
    0,   17,   18,   19,   20,   21,   22,   23,   24,   25,
   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,   49,   50,   51,   52,   53,    0,    0,
   54,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   55,   56,   57,   58,   59,
   60,    0,    0,    0,    0,    0,    0,    0,   61,   62,
   63,   64,   65,  328,   66,   67,   68,   69,   70,   71,
    0,    0,  329,    0,    0,   72,   73,   74,   75,   76,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,    0,    0,    0,   88,   89,   90,   91,   92,   93,
   94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  105,  106,  107,  108,  109,  110,
    9,   10,   11,   12,   13,   14,   15,  435,   16,    0,
   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
   47,   48,   49,   50,   51,   52,   53,    0,    0,   54,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   55,   56,   57,   58,   59,   60,
    0,    0,    0,    0,    0,    0,    0,   61,   62,   63,
   64,   65,    0,   66,   67,   68,   69,   70,   71,    0,
    0,    0,    0,    0,   72,   73,   74,   75,   76,   77,
   78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
    0,    0,    0,   88,   89,   90,   91,   92,   93,   94,
   95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  105,  106,  107,  108,  109,  110,    9,
   10,   11,   12,   13,   14,   15,  436,   16,    0,   17,
   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,    0,    0,   54,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   55,   56,   57,   58,   59,   60,    0,
    0,    0,    0,    0,    0,    0,   61,   62,   63,   64,
   65,    0,   66,   67,   68,   69,   70,   71,    0,    0,
    0,    0,    0,   72,   73,   74,   75,   76,   77,   78,
   79,   80,   81,   82,   83,   84,   85,   86,   87,    0,
    0,    0,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,  100,  101,  102,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  105,  106,  107,  108,  109,  110,    9,   10,
   11,   12,   13,   14,   15,    0,   16,    0,   17,   18,
   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
   49,   50,   51,   52,   53,    0,    0,   54,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   55,   56,   57,   58,   59,   60,    0,    0,
    0,    0,    0,    0,    0,   61,   62,   63,   64,   65,
    0,   66,   67,   68,   69,   70,   71,    0,    0,  329,
    0,    0,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,    0,    0,
    0,   88,   89,   90,   91,   92,   93,   94,   95,   96,
   97,   98,   99,  100,  101,  102,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  105,  106,  107,  108,  109,  110,    9,   10,   11,
   12,   13,   14,   15,    0,   16,  381,   17,   18,   19,
   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
   50,   51,   52,   53,    0,    0,   54,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   55,   56,   57,   58,   59,   60,    0,    0,    0,
    0,    0,    0,    0,   61,   62,   63,   64,   65,    0,
   66,   67,   68,   69,   70,   71,    0,    0,    0,    0,
    0,   72,   73,   74,   75,   76,   77,   78,   79,   80,
   81,   82,   83,   84,   85,   86,   87,    0,    0,    0,
   88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
   98,   99,  100,  101,  102,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  105,  106,  107,  108,  109,  110,    9,   10,   11,   12,
   13,   14,   15,    0,   16,    0,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
   51,   52,   53,    0,    0,   54,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   55,   56,   57,   58,   59,   60,    0,    0,    0,    0,
    0,    0,    0,   61,   62,   63,   64,   65,    0,   66,
   67,   68,   69,   70,   71,    0,    0,    0,    0,    0,
   72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
   82,   83,   84,   85,   86,   87,    0,    0,    0,   88,
   89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
   99,  100,  101,  102,  103,  104,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  105,
  106,  107,  108,  109,  110,    9,   10,   11,   12,  388,
    0,   15,    0,   16,    0,   17,   18,   19,   20,   21,
   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
   52,   53,    0,    0,   54,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   55,
   56,   57,   58,   59,   60,    0,    0,    0,    0,    0,
    0,    0,   61,   62,   63,   64,   65,    0,   66,   67,
   68,   69,   70,   71,    0,    0,    0,    0,    0,   72,
   73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
   83,   84,   85,   86,   87,    0,    0,    0,   88,   89,
   90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
  100,  101,  102,  103,  104,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  105,  106,
  107,  108,  109,  110,    9,   10,   11,   12,    0,    0,
   15,    0,   16,    0,   17,   18,   19,   20,   21,   22,
   23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
   53,    0,    0,   54,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   55,   56,
   57,   58,   59,   60,    0,    0,    0,    0,    0,    0,
    0,   61,   62,   63,   64,   65,    0,   66,   67,   68,
   69,   70,   71,    0,    0,    0,    0,    0,   72,   73,
   74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
   84,   85,   86,   87,    0,    0,    0,   88,   89,   90,
   91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
  101,  102,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  105,  106,  107,
  108,  109,  110,    9,   10,   11,   12,    0,    0,   15,
    0,   16,    0,   17,   18,   19,   20,   21,   22,   23,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
    0,    0,   54,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   55,   56,   57,
   58,   59,   60,    0,    0,    0,    0,    0,    0,    0,
   61,   62,   63,   64,   65,    0,   66,   67,   68,   69,
   70,   71,    0,    0,    0,    0,    0,   72,   73,   74,
   75,   76,   77,   78,   79,   80,  493,   82,   83,   84,
   85,   86,   87,    0,    0,    0,   88,   89,   90,   91,
   92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
  102,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  105,  106,  107,  108,
  109,  110,
};
static const short itex2MML_yycheck[] = {                 2,
    3,  236,  323,  270,  325,  270,  270,  269,    2,    3,
  257,  258,   15,  269,  314,  262,  270,  257,  258,  313,
  314,   15,  262,  270,  314,  272,  314,  270,  270,  352,
  270,  334,  272,  314,  111,  338,  314,  270,    2,    3,
  314,  314,  353,  314,  314,  314,  313,  314,  313,  314,
  314,   15,  270,  314,  279,  280,  281,  282,  283,  284,
  314,  286,  287,  288,  289,  290,  313,  314,  334,  390,
  313,  314,  352,  313,  314,  317,  318,  314,  310,  395,
  396,  270,  395,  396,  317,  318,  270,  322,  333,  270,
  401,  293,  294,  393,  311,  313,  314,  317,  318,  393,
  352,  333,  352,  393,  366,  393,  293,  294,  111,  186,
  366,  312,  393,  355,  356,  393,  193,  334,  311,  393,
  393,  442,  393,  393,  393,  314,  393,  269,  393,  393,
  314,  352,  393,  314,  333,  355,  356,  352,  334,  393,
  352,  334,  408,  339,  293,  294,  393,  111,  293,  294,
  393,  467,  352,  393,  467,  333,  393,  473,  393,  333,
  473,  334,  335,  336,  337,  326,  413,  267,  268,  326,
  270,  267,  268,  413,  270,  333,  179,  292,  293,  269,
  295,  267,  268,  186,  270,  179,  267,  268,  326,  270,
  193,  270,  326,  394,  395,  396,  397,  398,  399,  400,
  408,  402,  403,  404,  405,  267,  268,  528,  270,  259,
  260,  261,  292,  293,  294,  179,  408,  293,  294,  295,
  338,  224,  186,  293,  294,  295,  267,  268,  305,  193,
  224,  339,  293,  294,  295,  238,  313,  316,  317,  318,
  319,  320,  321,  322,  323,  324,  325,  293,  294,  295,
  267,  268,  269,  330,  267,  268,  373,  482,  267,  268,
  224,  335,  336,  337,  269,  267,  268,  430,  431,  504,
  317,  318,  269,  269,  238,  313,  279,  280,  281,  282,
  283,  284,  269,  286,  287,  288,  289,  290,  333,  292,
  293,  294,  517,  370,  371,  372,  311,  334,  292,  293,
  294,  526,  305,  401,  307,  308,  383,  384,  268,  267,
  313,  268,  267,  307,  308,  279,  280,  281,  282,  283,
  284,  268,  286,  287,  288,  289,  290,  330,  292,  293,
  294,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  305,  267,  307,  308,  267,  394,  333,  397,  313,
  402,  395,  403,  430,  431,  398,  396,  399,  326,  326,
  326,  326,  374,  326,  326,  404,  330,  370,  371,  372,
  405,  312,  326,  326,  326,  326,  379,  380,  326,  312,
  383,  384,  326,  375,  334,  379,  380,  333,    0,  334,
    0,    5,    5,  243,  343,  398,  399,  340,  408,  453,
  398,  467,  473,  519,  346,   -1,  370,  371,  372,  399,
   -1,   -1,   -1,   -1,   -1,  379,  380,   -1,   -1,  383,
  384,   -1,   -1,   -1,   -1,   -1,   -1,  430,  431,   -1,
   -1,   -1,   -1,   -1,  398,  399,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  531,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  430,  431,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  482,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  517,   -1,  519,   -1,  482,   -1,
  523,   -1,   -1,  526,   -1,   -1,   -1,   -1,  531,  523,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   13,
   14,   15,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   25,   26,  517,   -1,  519,   -1,   -1,   -1,  523,
   -1,   -1,  526,   -1,   -1,   -1,   -1,  531,   42,   43,
   44,   45,   46,   47,   48,   49,   50,   51,   52,   -1,
   -1,   55,   56,   57,   58,   -1,   -1,   -1,   -1,   63,
   64,   65,   66,   67,   68,   69,   70,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   78,   -1,   -1,   -1,   -1,   -1,
   84,   -1,   -1,   -1,   88,   89,   90,   91,   92,   93,
   94,   95,   96,   97,   98,   99,  100,  101,   -1,   -1,
   -1,   -1,  106,   -1,   -1,   -1,  110,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  218,  219,   -1,   -1,   -1,   -1,
   -1,   -1,  226,  227,  228,  229,  230,   -1,   -1,   -1,
  234,   -1,   -1,  237,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  257,  258,  259,  260,  261,  262,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  319,  320,  321,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  385,   -1,   -1,  388,   -1,   -1,   -1,  392,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  423,
  424,  425,  426,  427,  428,  429,   -1,   -1,   -1,   -1,
   -1,  257,  258,   -1,   -1,  439,  262,  263,  264,  265,
  266,  267,  268,  269,  270,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,  307,  308,  309,   -1,   -1,  312,  313,  314,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,
  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,
   -1,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,
  376,  377,  378,  379,  380,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,  407,   -1,  409,  410,  411,   -1,  413,  257,  258,
   -1,   -1,   -1,  262,  263,  264,  265,  266,  267,   -1,
  269,  270,  271,  272,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,
  309,   -1,   -1,  312,  313,  314,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,
  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,  341,  342,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,
  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  391,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,
  409,  410,  411,   -1,  413,  257,  258,   -1,   -1,   -1,
  262,  263,  264,  265,  266,   -1,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,  313,  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
   -1,  413,  257,  258,   -1,   -1,   -1,  262,  263,  264,
  265,  266,  267,   -1,  269,  270,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,  307,  308,  309,   -1,   -1,  312,  313,  314,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,
   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,
   -1,   -1,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,   -1,   -1,
   -1,  376,  377,  378,  379,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,  391,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  406,  407,  408,  409,  410,  411,   -1,  413,  257,
  258,   -1,   -1,   -1,  262,  263,  264,  265,  266,   -1,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,  304,  305,  306,  307,
  308,  309,   -1,   -1,  312,  313,  314,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,
  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,  347,
  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,
  358,  359,  360,  361,  362,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,
  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,  391,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,
  408,  409,  410,  411,   -1,  413,  257,  258,   -1,   -1,
   -1,  262,  263,  264,  265,  266,  267,   -1,  269,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,  305,  306,  307,  308,  309,   -1,
   -1,  312,  313,  314,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,
  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,
  341,  342,  343,  344,   -1,  346,  347,  348,  349,  350,
  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,
  411,   -1,  413,  257,  258,   -1,   -1,   -1,  262,  263,
  264,  265,  266,   -1,  268,  269,  270,  271,  272,  273,
  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,  300,  301,  302,  303,
  304,  305,  306,  307,  308,  309,   -1,   -1,  312,  313,
  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,
  344,   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,
   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,   -1,
   -1,   -1,  376,  377,  378,  379,  380,  381,  382,  383,
  384,  385,  386,  387,  388,  389,  390,  391,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,  413,
  257,  258,   -1,   -1,   -1,  262,  263,  264,  265,  266,
   -1,  268,  269,  270,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,  309,   -1,   -1,  312,  313,  314,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,  408,  409,  410,  411,   -1,  413,  257,  258,   -1,
   -1,   -1,  262,  263,  264,  265,  266,   -1,   -1,  269,
  270,  271,  272,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,  313,  314,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,   -1,  413,  257,  258,   -1,   -1,   -1,  262,
  263,  264,  265,  266,   -1,   -1,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,  305,  306,  307,  308,  309,   -1,   -1,  312,
  313,  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,
  343,  344,   -1,  346,  347,  348,  349,  350,  351,   -1,
   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  391,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,
  413,  257,  258,   -1,   -1,   -1,  262,  263,  264,  265,
  266,   -1,   -1,  269,  270,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,  307,  308,  309,   -1,   -1,  312,  313,  314,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,
  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,
   -1,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,
  376,  377,  378,  379,  380,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,  407,  408,  409,  410,  411,   -1,  413,  257,  258,
   -1,   -1,   -1,  262,  263,  264,  265,  266,   -1,   -1,
  269,  270,  271,  272,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,
  309,   -1,   -1,  312,  313,  314,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,
  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,  341,  342,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,
  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  391,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,
  409,  410,  411,   -1,  413,  257,  258,   -1,   -1,   -1,
   -1,  263,  264,  265,  266,  267,  268,  269,  270,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
  257,  258,   -1,   -1,   -1,   -1,  263,  264,  265,  266,
  267,  268,  269,   -1,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,  408,  409,  410,  411,  257,  258,   -1,   -1,   -1,
   -1,  263,  264,  265,  266,   -1,   -1,  269,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
  263,  264,  265,  266,  267,  268,  269,   -1,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,  305,  306,  307,  308,  309,   -1,   -1,  312,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,
  343,  344,   -1,  346,  347,  348,  349,  350,  351,   -1,
   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  391,  392,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,   -1,
  413,  263,  264,  265,  266,  267,  268,  269,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,   -1,  346,  347,  348,  349,  350,  351,
   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
   -1,  413,  262,  263,  264,  265,  266,  267,  268,  269,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,  262,  263,  264,  265,  266,  267,  268,  269,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,  262,  263,  264,  265,  266,  267,  268,  269,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,  262,  263,  264,  265,  266,  267,  268,  269,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,  263,  264,  265,  266,   -1,   -1,  269,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,  305,  306,  307,  308,  309,   -1,
   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,
  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,
  341,  342,  343,  344,   -1,  346,  347,  348,  349,  350,
  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,
  411,  412,  263,  264,  265,  266,   -1,   -1,  269,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,  305,  306,  307,  308,  309,   -1,
   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,
  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,
  341,  342,  343,  344,   -1,  346,  347,  348,  349,  350,
  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,
  411,  412,  263,  264,  265,  266,  267,  268,  269,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,  305,  306,  307,  308,  309,   -1,
   -1,  312,   -1,   -1,  315,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,
  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,
  341,  342,  343,  344,  345,  346,  347,  348,  349,  350,
  351,   -1,   -1,  354,   -1,   -1,  357,  358,  359,  360,
  361,  362,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,
  411,  263,  264,  265,  266,  267,  268,  269,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,  307,  308,  309,   -1,   -1,
  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,
  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,
  342,  343,  344,  345,  346,  347,  348,  349,  350,  351,
   -1,   -1,  354,   -1,   -1,  357,  358,  359,  360,  361,
  362,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,
  263,  264,  265,  266,  267,  268,  269,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,  305,  306,  307,  308,  309,   -1,   -1,  312,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,
  343,  344,   -1,  346,  347,  348,  349,  350,  351,   -1,
   -1,   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
   -1,   -1,   -1,  376,  377,  378,  379,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  391,  392,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  406,  407,  408,  409,  410,  411,  263,
  264,  265,  266,  267,  268,  269,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,  300,  301,  302,  303,
  304,  305,  306,  307,  308,  309,   -1,   -1,  312,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,
  344,   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,
   -1,   -1,   -1,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,   -1,
   -1,   -1,  376,  377,  378,  379,  380,  381,  382,  383,
  384,  385,  386,  387,  388,  389,  390,  391,  392,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  406,  407,  408,  409,  410,  411,  263,  264,
  265,  266,  267,  268,  269,   -1,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,  307,  308,  309,   -1,   -1,  312,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,
   -1,  346,  347,  348,  349,  350,  351,   -1,   -1,  354,
   -1,   -1,  357,  358,  359,  360,  361,  362,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,   -1,   -1,
   -1,  376,  377,  378,  379,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  390,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  406,  407,  408,  409,  410,  411,  263,  264,  265,
  266,  267,  268,  269,   -1,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,
  346,  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,
   -1,  357,  358,  359,  360,  361,  362,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,
  376,  377,  378,  379,  380,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  406,  407,  408,  409,  410,  411,  263,  264,  265,  266,
  267,  268,  269,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  327,  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,
  357,  358,  359,  360,  361,  362,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,
  407,  408,  409,  410,  411,  263,  264,  265,  266,  267,
   -1,  269,   -1,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,  304,  305,  306,  307,
  308,  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,
  328,  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  340,  341,  342,  343,  344,   -1,  346,  347,
  348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,
  358,  359,  360,  361,  362,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,
  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,  391,  392,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,
  408,  409,  410,  411,  263,  264,  265,  266,   -1,   -1,
  269,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,
  309,   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,
  329,  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  340,  341,  342,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,
  359,  360,  361,  362,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,
  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,
  409,  410,  411,  263,  264,  265,  266,   -1,   -1,  269,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,
   -1,   -1,  312,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  327,  328,  329,
  330,  331,  332,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  340,  341,  342,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,   -1,   -1,   -1,   -1,   -1,  357,  358,  359,
  360,  361,  362,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,   -1,   -1,   -1,  376,  377,  378,  379,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  406,  407,  408,  409,
  410,  411,
};
#define YYFINAL 4
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 413
#if YYDEBUG
static const char *yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"TEXOVER","TEXATOP","CHAR",
"STARTMATH","STARTDMATH","ENDMATH","MI","MIB","MN","MO","SUP","SUB","MROWOPEN",
"MROWCLOSE","LEFT","RIGHT","BIG","BBIG","BIGG","BBIGG","BIGL","BBIGL","BIGGL",
"BBIGGL","FRAC","TFRAC","OPERATORNAME","MATHOP","MATHBIN","MATHREL","MOP","MOL",
"MOLL","MOF","MOR","PERIODDELIM","OTHERDELIM","LEFTDELIM","RIGHTDELIM","MOS",
"MOB","SQRT","ROOT","BINOM","TBINOM","UNDER","OVER","OVERBRACE","UNDERLINE",
"UNDERBRACE","UNDEROVER","TENSOR","MULTI","ARRAYALIGN","COLUMNALIGN","ARRAY",
"COLSEP","ROWSEP","ARRAYOPTS","COLLAYOUT","COLALIGN","ROWALIGN","ALIGN",
"EQROWS","EQCOLS","ROWLINES","COLLINES","FRAME","PADDING","ATTRLIST","ITALICS",
"BOLD","BOXED","SLASHED","RM","BB","ST","END","BBLOWERCHAR","BBUPPERCHAR",
"BBDIGIT","CALCHAR","FRAKCHAR","CAL","FRAK","CLAP","LLAP","RLAP","ROWOPTS",
"TEXTSIZE","SCSIZE","SCSCSIZE","DISPLAY","TEXTSTY","TEXTBOX","TEXTSTRING",
"XMLSTRING","CELLOPTS","ROWSPAN","COLSPAN","THINSPACE","MEDSPACE","THICKSPACE",
"QUAD","QQUAD","NEGSPACE","PHANTOM","HREF","UNKNOWNCHAR","EMPTYMROW","STATLINE",
"TOOLTIP","TOGGLE","FGHIGHLIGHT","BGHIGHLIGHT","SPACE","INTONE","INTTWO",
"INTTHREE","BAR","WIDEBAR","VEC","WIDEVEC","HAT","WIDEHAT","CHECK","WIDECHECK",
"TILDE","WIDETILDE","DOT","DDOT","DDDOT","DDDDOT","UNARYMINUS","UNARYPLUS",
"BEGINENV","ENDENV","MATRIX","PMATRIX","BMATRIX","BBMATRIX","VMATRIX",
"VVMATRIX","SVG","ENDSVG","SMALLMATRIX","CASES","ALIGNED","GATHERED","SUBSTACK",
"PMOD","RMCHAR","COLOR","BGCOLOR","XARROW","OPTARGOPEN","OPTARGCLOSE",
};
static const char *yyrule[] = {
"$accept : doc",
"doc : xmlmmlTermList",
"xmlmmlTermList :",
"xmlmmlTermList : char",
"xmlmmlTermList : expression",
"xmlmmlTermList : xmlmmlTermList char",
"xmlmmlTermList : xmlmmlTermList expression",
"char : CHAR",
"expression : STARTMATH ENDMATH",
"expression : STARTDMATH ENDMATH",
"expression : STARTMATH compoundTermList ENDMATH",
"expression : STARTDMATH compoundTermList ENDMATH",
"compoundTermList : compoundTerm",
"compoundTermList : compoundTermList compoundTerm",
"compoundTerm : mob SUB closedTerm SUP closedTerm",
"compoundTerm : mob SUB closedTerm",
"compoundTerm : mob SUP closedTerm SUB closedTerm",
"compoundTerm : mob SUP closedTerm",
"compoundTerm : mib SUB closedTerm SUP closedTerm",
"compoundTerm : mib SUB closedTerm",
"compoundTerm : mib SUP closedTerm SUB closedTerm",
"compoundTerm : mib SUP closedTerm",
"compoundTerm : closedTerm SUB closedTerm SUP closedTerm",
"compoundTerm : closedTerm SUP closedTerm SUB closedTerm",
"compoundTerm : closedTerm SUB closedTerm",
"compoundTerm : closedTerm SUP closedTerm",
"compoundTerm : SUB closedTerm",
"compoundTerm : SUP closedTerm",
"compoundTerm : closedTerm",
"closedTerm : array",
"closedTerm : unaryminus",
"closedTerm : unaryplus",
"closedTerm : mib",
"closedTerm : mi",
"closedTerm : mn",
"closedTerm : mo",
"closedTerm : tensor",
"closedTerm : multi",
"closedTerm : mfrac",
"closedTerm : binom",
"closedTerm : msqrt",
"closedTerm : mroot",
"closedTerm : munder",
"closedTerm : mover",
"closedTerm : bar",
"closedTerm : vec",
"closedTerm : hat",
"closedTerm : dot",
"closedTerm : ddot",
"closedTerm : dddot",
"closedTerm : ddddot",
"closedTerm : check",
"closedTerm : tilde",
"closedTerm : moverbrace",
"closedTerm : munderbrace",
"closedTerm : munderline",
"closedTerm : munderover",
"closedTerm : emptymrow",
"closedTerm : mathclap",
"closedTerm : mathllap",
"closedTerm : mathrlap",
"closedTerm : displaystyle",
"closedTerm : textstyle",
"closedTerm : textsize",
"closedTerm : scriptsize",
"closedTerm : scriptscriptsize",
"closedTerm : italics",
"closedTerm : bold",
"closedTerm : roman",
"closedTerm : rmchars",
"closedTerm : bbold",
"closedTerm : frak",
"closedTerm : slashed",
"closedTerm : boxed",
"closedTerm : cal",
"closedTerm : space",
"closedTerm : textstring",
"closedTerm : thinspace",
"closedTerm : medspace",
"closedTerm : thickspace",
"closedTerm : quad",
"closedTerm : qquad",
"closedTerm : negspace",
"closedTerm : phantom",
"closedTerm : href",
"closedTerm : statusline",
"closedTerm : tooltip",
"closedTerm : toggle",
"closedTerm : fghighlight",
"closedTerm : bghighlight",
"closedTerm : color",
"closedTerm : texover",
"closedTerm : texatop",
"closedTerm : MROWOPEN closedTerm MROWCLOSE",
"closedTerm : MROWOPEN compoundTermList MROWCLOSE",
"closedTerm : left compoundTermList right",
"closedTerm : mathenv",
"closedTerm : substack",
"closedTerm : pmod",
"closedTerm : unrecognized",
"left : LEFT LEFTDELIM",
"left : LEFT OTHERDELIM",
"left : LEFT PERIODDELIM",
"right : RIGHT RIGHTDELIM",
"right : RIGHT OTHERDELIM",
"right : RIGHT PERIODDELIM",
"bigdelim : BIG LEFTDELIM",
"bigdelim : BIG RIGHTDELIM",
"bigdelim : BIG OTHERDELIM",
"bigdelim : BBIG LEFTDELIM",
"bigdelim : BBIG RIGHTDELIM",
"bigdelim : BBIG OTHERDELIM",
"bigdelim : BIGG LEFTDELIM",
"bigdelim : BIGG RIGHTDELIM",
"bigdelim : BIGG OTHERDELIM",
"bigdelim : BBIGG LEFTDELIM",
"bigdelim : BBIGG RIGHTDELIM",
"bigdelim : BBIGG OTHERDELIM",
"bigdelim : BIGL LEFTDELIM",
"bigdelim : BIGL OTHERDELIM",
"bigdelim : BBIGL LEFTDELIM",
"bigdelim : BBIGL OTHERDELIM",
"bigdelim : BIGGL LEFTDELIM",
"bigdelim : BIGGL OTHERDELIM",
"bigdelim : BBIGGL LEFTDELIM",
"bigdelim : BBIGGL OTHERDELIM",
"unrecognized : UNKNOWNCHAR",
"unaryminus : UNARYMINUS",
"unaryplus : UNARYPLUS",
"mi : MI",
"mib : MIB",
"mn : MN",
"mob : MOB",
"mo : mob",
"mo : bigdelim",
"mo : MO",
"mo : MOL",
"mo : MOLL",
"mo : RIGHTDELIM",
"mo : LEFTDELIM",
"mo : OTHERDELIM",
"mo : MOF",
"mo : PERIODDELIM",
"mo : MOS",
"mo : MOP",
"mo : MOR",
"mo : OPERATORNAME TEXTSTRING",
"mo : MATHOP TEXTSTRING",
"mo : MATHBIN TEXTSTRING",
"mo : MATHREL TEXTSTRING",
"space : SPACE ST INTONE END ST INTTWO END ST INTTHREE END",
"statusline : STATLINE TEXTSTRING closedTerm",
"tooltip : TOOLTIP TEXTSTRING closedTerm",
"toggle : TOGGLE closedTerm closedTerm",
"fghighlight : FGHIGHLIGHT ATTRLIST closedTerm",
"bghighlight : BGHIGHLIGHT ATTRLIST closedTerm",
"color : COLOR ATTRLIST compoundTermList",
"color : BGCOLOR ATTRLIST compoundTermList",
"mathrlap : RLAP closedTerm",
"mathllap : LLAP closedTerm",
"mathclap : CLAP closedTerm",
"textstring : TEXTBOX TEXTSTRING",
"displaystyle : DISPLAY closedTerm",
"textstyle : TEXTSTY closedTerm",
"textsize : TEXTSIZE closedTerm",
"scriptsize : SCSIZE closedTerm",
"scriptscriptsize : SCSCSIZE closedTerm",
"italics : ITALICS closedTerm",
"slashed : SLASHED closedTerm",
"boxed : BOXED closedTerm",
"bold : BOLD closedTerm",
"roman : RM ST rmchars END",
"rmchars : RMCHAR",
"rmchars : rmchars RMCHAR",
"bbold : BB ST bbchars END",
"bbchars : bbchar",
"bbchars : bbchars bbchar",
"bbchar : BBLOWERCHAR",
"bbchar : BBUPPERCHAR",
"bbchar : BBDIGIT",
"frak : FRAK ST frakletters END",
"frakletters : frakletter",
"frakletters : frakletters frakletter",
"frakletter : FRAKCHAR",
"cal : CAL ST calletters END",
"calletters : calletter",
"calletters : calletters calletter",
"calletter : CALCHAR",
"thinspace : THINSPACE",
"medspace : MEDSPACE",
"thickspace : THICKSPACE",
"quad : QUAD",
"qquad : QQUAD",
"negspace : NEGSPACE",
"phantom : PHANTOM closedTerm",
"href : HREF TEXTSTRING closedTerm",
"tensor : TENSOR closedTerm MROWOPEN subsupList MROWCLOSE",
"tensor : TENSOR closedTerm subsupList",
"multi : MULTI MROWOPEN subsupList MROWCLOSE closedTerm MROWOPEN subsupList MROWCLOSE",
"multi : MULTI MROWOPEN subsupList MROWCLOSE closedTerm EMPTYMROW",
"multi : MULTI EMPTYMROW closedTerm MROWOPEN subsupList MROWCLOSE",
"subsupList : subsupTerm",
"subsupList : subsupList subsupTerm",
"subsupTerm : SUB closedTerm SUP closedTerm",
"subsupTerm : SUB closedTerm",
"subsupTerm : SUP closedTerm",
"subsupTerm : SUB SUP closedTerm",
"mfrac : FRAC closedTerm closedTerm",
"mfrac : TFRAC closedTerm closedTerm",
"pmod : PMOD closedTerm",
"texover : MROWOPEN compoundTermList TEXOVER compoundTermList MROWCLOSE",
"texover : left compoundTermList TEXOVER compoundTermList right",
"texatop : MROWOPEN compoundTermList TEXATOP compoundTermList MROWCLOSE",
"texatop : left compoundTermList TEXATOP compoundTermList right",
"binom : BINOM closedTerm closedTerm",
"binom : TBINOM closedTerm closedTerm",
"munderbrace : UNDERBRACE closedTerm",
"munderline : UNDERLINE closedTerm",
"moverbrace : OVERBRACE closedTerm",
"bar : BAR closedTerm",
"bar : WIDEBAR closedTerm",
"vec : VEC closedTerm",
"vec : WIDEVEC closedTerm",
"dot : DOT closedTerm",
"ddot : DDOT closedTerm",
"dddot : DDDOT closedTerm",
"ddddot : DDDDOT closedTerm",
"tilde : TILDE closedTerm",
"tilde : WIDETILDE closedTerm",
"check : CHECK closedTerm",
"check : WIDECHECK closedTerm",
"hat : HAT closedTerm",
"hat : WIDEHAT closedTerm",
"msqrt : SQRT closedTerm",
"mroot : SQRT OPTARGOPEN compoundTermList OPTARGCLOSE closedTerm",
"mroot : ROOT closedTerm closedTerm",
"munder : XARROW OPTARGOPEN compoundTermList OPTARGCLOSE EMPTYMROW",
"munder : UNDER closedTerm closedTerm",
"mover : XARROW closedTerm",
"mover : OVER closedTerm closedTerm",
"munderover : XARROW OPTARGOPEN compoundTermList OPTARGCLOSE closedTerm",
"munderover : UNDEROVER closedTerm closedTerm closedTerm",
"emptymrow : EMPTYMROW",
"mathenv : BEGINENV MATRIX tableRowList ENDENV MATRIX",
"mathenv : BEGINENV GATHERED tableRowList ENDENV GATHERED",
"mathenv : BEGINENV PMATRIX tableRowList ENDENV PMATRIX",
"mathenv : BEGINENV BMATRIX tableRowList ENDENV BMATRIX",
"mathenv : BEGINENV VMATRIX tableRowList ENDENV VMATRIX",
"mathenv : BEGINENV BBMATRIX tableRowList ENDENV BBMATRIX",
"mathenv : BEGINENV VVMATRIX tableRowList ENDENV VVMATRIX",
"mathenv : BEGINENV SMALLMATRIX tableRowList ENDENV SMALLMATRIX",
"mathenv : BEGINENV CASES tableRowList ENDENV CASES",
"mathenv : BEGINENV ALIGNED tableRowList ENDENV ALIGNED",
"mathenv : BEGINENV ARRAY ARRAYALIGN ST columnAlignList END tableRowList ENDENV ARRAY",
"mathenv : BEGINENV ARRAY ST columnAlignList END tableRowList ENDENV ARRAY",
"mathenv : BEGINENV SVG XMLSTRING ENDSVG",
"mathenv : BEGINENV SVG ENDSVG",
"columnAlignList : columnAlignList COLUMNALIGN",
"columnAlignList : COLUMNALIGN",
"substack : SUBSTACK MROWOPEN tableRowList MROWCLOSE",
"array : ARRAY MROWOPEN tableRowList MROWCLOSE",
"array : ARRAY MROWOPEN ARRAYOPTS MROWOPEN arrayopts MROWCLOSE tableRowList MROWCLOSE",
"arrayopts : anarrayopt",
"arrayopts : arrayopts anarrayopt",
"anarrayopt : collayout",
"anarrayopt : colalign",
"anarrayopt : rowalign",
"anarrayopt : align",
"anarrayopt : eqrows",
"anarrayopt : eqcols",
"anarrayopt : rowlines",
"anarrayopt : collines",
"anarrayopt : frame",
"anarrayopt : padding",
"collayout : COLLAYOUT ATTRLIST",
"colalign : COLALIGN ATTRLIST",
"rowalign : ROWALIGN ATTRLIST",
"align : ALIGN ATTRLIST",
"eqrows : EQROWS ATTRLIST",
"eqcols : EQCOLS ATTRLIST",
"rowlines : ROWLINES ATTRLIST",
"collines : COLLINES ATTRLIST",
"frame : FRAME ATTRLIST",
"padding : PADDING ATTRLIST",
"tableRowList : tableRow",
"tableRowList : tableRowList ROWSEP tableRow",
"tableRow : simpleTableRow",
"tableRow : optsTableRow",
"simpleTableRow : tableCell",
"simpleTableRow : simpleTableRow COLSEP tableCell",
"optsTableRow : ROWOPTS MROWOPEN rowopts MROWCLOSE simpleTableRow",
"rowopts : arowopt",
"rowopts : rowopts arowopt",
"arowopt : colalign",
"arowopt : rowalign",
"tableCell :",
"tableCell : compoundTermList",
"tableCell : CELLOPTS MROWOPEN cellopts MROWCLOSE compoundTermList",
"cellopts : acellopt",
"cellopts : cellopts acellopt",
"acellopt : colalign",
"acellopt : rowalign",
"acellopt : rowspan",
"acellopt : colspan",
"rowspan : ROWSPAN ATTRLIST",
"colspan : COLSPAN ATTRLIST",

};
#endif

int      yydebug;
int      yynerrs;

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  500
#endif
#endif

#define YYINITSTACKSIZE 500

typedef struct {
    unsigned stacksize;
    short    *s_base;
    short    *s_mark;
    short    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 1686 "itex2MML.y"

char * itex2MML_parse (const char * buffer, unsigned long length)
{
  char * mathml = 0;

  int result;

  itex2MML_setup (buffer, length);
  itex2MML_restart ();

  result = itex2MML_yyparse (&mathml);

  if (result && mathml) /* shouldn't happen? */
    {
      itex2MML_free_string (mathml);
      mathml = 0;
    }
  return mathml;
}

int itex2MML_filter (const char * buffer, unsigned long length)
{
  itex2MML_setup (buffer, length);
  itex2MML_restart ();

  return itex2MML_yyparse (0);
}

#define ITEX_DELIMITER_DOLLAR 0
#define ITEX_DELIMITER_DOUBLE 1
#define ITEX_DELIMITER_SQUARE 2

static char * itex2MML_last_error = 0;

static void itex2MML_keep_error (const char * msg)
{
  if (itex2MML_last_error)
    {
      itex2MML_free_string (itex2MML_last_error);
      itex2MML_last_error = 0;
    }
  itex2MML_last_error = itex2MML_copy_escaped (msg);
}

int itex2MML_html_filter (const char * buffer, unsigned long length)
{
  itex2MML_do_html_filter (buffer, length, 0);
}

int itex2MML_strict_html_filter (const char * buffer, unsigned long length)
{
  itex2MML_do_html_filter (buffer, length, 1);
}

int itex2MML_do_html_filter (const char * buffer, unsigned long length, const int forbid_markup)
{
  int result = 0;

  int type = 0;
  int skip = 0;
  int match = 0;

  const char * ptr1 = buffer;
  const char * ptr2 = 0;

  const char * end = buffer + length;

  char * mathml = 0;

  void (*save_error_fn) (const char * msg) = itex2MML_error;

  itex2MML_error = itex2MML_keep_error;

 _until_math:
  ptr2 = ptr1;

  while (ptr2 < end)
    {
      if (*ptr2 == '$') break;
      if ((*ptr2 == '\\') && (ptr2 + 1 < end))
	{
	  if (*(ptr2+1) == '[') break;
	}
      ++ptr2;
    }
  if (itex2MML_write && ptr2 > ptr1)
    (*itex2MML_write) (ptr1, ptr2 - ptr1);

  if (ptr2 == end) goto _finish;

 _until_html:
  ptr1 = ptr2;

  if (ptr2 + 1 < end)
    {
      if ((*ptr2 == '\\') && (*(ptr2+1) == '['))
	{
	  type = ITEX_DELIMITER_SQUARE;
	  ptr2 += 2;
	}
      else if ((*ptr2 == '$') && (*(ptr2+1) == '$'))
	{
	  type = ITEX_DELIMITER_DOUBLE;
	  ptr2 += 2;
	}
      else
	{
	  type = ITEX_DELIMITER_DOLLAR;
	  ptr2 += 2;
	}
    }
  else goto _finish;

  skip = 0;
  match = 0;

  while (ptr2 < end)
    {
      switch (*ptr2)
	{
	case '<':
	case '>':
	  if (forbid_markup == 1) skip = 1;
	  break;

	case '\\':
	  if (ptr2 + 1 < end)
	    {
	      if (*(ptr2 + 1) == '[')
		{
		  skip = 1;
		}
	      else if (*(ptr2 + 1) == ']')
		{
		  if (type == ITEX_DELIMITER_SQUARE)
		    {
		      ptr2 += 2;
		      match = 1;
		    }
		  else
		    {
		      skip = 1;
		    }
		}
	    }
	  break;

	case '$':
	  if (type == ITEX_DELIMITER_SQUARE)
	    {
	      skip = 1;
	    }
	  else if (ptr2 + 1 < end)
	    {
	      if (*(ptr2 + 1) == '$')
		{
		  if (type == ITEX_DELIMITER_DOLLAR)
		    {
		      ptr2++;
		      match = 1;
		    }
		  else
		    {
		      ptr2 += 2;
		      match = 1;
		    }
		}
	      else
		{
		  if (type == ITEX_DELIMITER_DOLLAR)
		    {
		      ptr2++;
		      match = 1;
		    }
		  else
		    {
		      skip = 1;
		    }
		}
	    }
	  else
	    {
	      if (type == ITEX_DELIMITER_DOLLAR)
		{
		  ptr2++;
		  match = 1;
		}
	      else
		{
		  skip = 1;
		}
	    }
	  break;

	default:
	  break;
	}
      if (skip || match) break;

      ++ptr2;
    }
  if (skip)
    {
      if (type == ITEX_DELIMITER_DOLLAR)
	{
	  if (itex2MML_write)
	    (*itex2MML_write) (ptr1, 1);
	  ptr1++;
	}
      else
	{
	  if (itex2MML_write)
	    (*itex2MML_write) (ptr1, 2);
	  ptr1 += 2;
	}
      goto _until_math;
    }
  if (match)
    {
      mathml = itex2MML_parse (ptr1, ptr2 - ptr1);

      if (mathml)
	{
	  if (itex2MML_write_mathml)
	    (*itex2MML_write_mathml) (mathml);
	  itex2MML_free_string (mathml);
	  mathml = 0;
	}
      else
	{
	  ++result;
	  if (itex2MML_write)
	    {
	      if (type == ITEX_DELIMITER_DOLLAR)
		(*itex2MML_write) ("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'><merror><mtext>", 0);
	      else
		(*itex2MML_write) ("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'><merror><mtext>", 0);

	      (*itex2MML_write) (itex2MML_last_error, 0);
	      (*itex2MML_write) ("</mtext></merror></math>", 0);
	    }
	}
      ptr1 = ptr2;

      goto _until_math;
    }
  if (itex2MML_write)
    (*itex2MML_write) (ptr1, ptr2 - ptr1);

 _finish:
  if (itex2MML_last_error)
    {
      itex2MML_free_string (itex2MML_last_error);
      itex2MML_last_error = 0;
    }
  itex2MML_error = save_error_fn;

  return result;
}
#line 2675 "y.tab.c"

#if YYDEBUG
#include <stdio.h>		/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = data->s_mark - data->s_base;
    newss = (short *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return -1;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return -1;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack)) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = YYLEX) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
        {
            goto yyoverflow;
        }
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;

    yyerror("syntax error");

    goto yyerrlab;

yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yystack.s_mark]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
                {
                    goto yyoverflow;
                }
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 1:
#line 284 "itex2MML.y"
	{/* all processing done in body*/}
break;
case 2:
#line 287 "itex2MML.y"
	{/* nothing - do nothing*/}
break;
case 3:
#line 288 "itex2MML.y"
	{/* proc done in body*/}
break;
case 4:
#line 289 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 5:
#line 290 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 6:
#line 291 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 7:
#line 293 "itex2MML.y"
	{}
break;
case 8:
#line 295 "itex2MML.y"
	{/* empty math group - ignore*/}
break;
case 9:
#line 296 "itex2MML.y"
	{/* ditto */}
break;
case 10:
#line 297 "itex2MML.y"
	{
  char ** r = (char **) ret_str;
  char * s = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>", yystack.l_mark[-1], "</math>");
  itex2MML_free_string(yystack.l_mark[-1]);
  if (r) {
    (*r) = (s == itex2MML_empty_string) ? 0 : s;
  }
  else {
    if (itex2MML_write_mathml)
      (*itex2MML_write_mathml) (s);
    itex2MML_free_string(s);
  }
}
break;
case 11:
#line 310 "itex2MML.y"
	{
  char ** r = (char **) ret_str;
  char * s = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'>", yystack.l_mark[-1], "</math>");
  itex2MML_free_string(yystack.l_mark[-1]);
  if (r) {
    (*r) = (s == itex2MML_empty_string) ? 0 : s;
  }
  else {
    if (itex2MML_write_mathml)
      (*itex2MML_write_mathml) (s);
    itex2MML_free_string(s);
  }
}
break;
case 12:
#line 324 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 13:
#line 328 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 14:
#line 334 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 15:
#line 353 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 16:
#line 367 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 17:
#line 386 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 18:
#line 400 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 19:
#line 419 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 20:
#line 433 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 21:
#line 452 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 22:
#line 466 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
  char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  yyval = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 23:
#line 476 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
  char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
  yyval = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 24:
#line 486 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 25:
#line 493 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 26:
#line 500 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msub><mo></mo>", yystack.l_mark[0], "</msub>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 27:
#line 504 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msup><mo></mo>", yystack.l_mark[0], "</msup>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 28:
#line 508 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 33:
#line 517 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[0], "</mi>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 34:
#line 521 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mn>", yystack.l_mark[0], "</mn>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 93:
#line 583 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 94:
#line 587 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow>", yystack.l_mark[-1], "</mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 95:
#line 591 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-2], yystack.l_mark[-1]);
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 100:
#line 604 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 101:
#line 609 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 102:
#line 614 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy_string("");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 103:
#line 620 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 104:
#line 624 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 105:
#line 628 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 106:
#line 633 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 107:
#line 638 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 108:
#line 642 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 109:
#line 646 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 110:
#line 651 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 111:
#line 655 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 112:
#line 659 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 113:
#line 664 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 114:
#line 668 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 115:
#line 672 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 116:
#line 677 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 117:
#line 681 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 118:
#line 685 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 119:
#line 690 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 120:
#line 695 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 121:
#line 700 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 122:
#line 705 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 123:
#line 710 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 124:
#line 715 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 125:
#line 720 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 126:
#line 726 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<merror><mtext>Unknown character</mtext></merror>");
}
break;
case 127:
#line 730 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mo lspace=\"verythinmathspace\" rspace=\"0em\">&minus;</mo>");
}
break;
case 128:
#line 734 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mo lspace=\"verythinmathspace\" rspace=\"0em\">+</mo>");
}
break;
case 130:
#line 740 "itex2MML.y"
	{
  itex2MML_rowposn=2;
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[0], "</mi>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 132:
#line 748 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"thinmathspace\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 135:
#line 756 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 136:
#line 761 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 137:
#line 766 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"0\"><mo>", yystack.l_mark[0], "</mo></mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 138:
#line 771 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 139:
#line 775 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 140:
#line 780 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 141:
#line 784 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 142:
#line 788 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 143:
#line 792 "itex2MML.y"
	{
  itex2MML_rowposn=2;
  yyval = itex2MML_copy3("<mo lspace=\"mediummathspace\" rspace=\"mediummathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 144:
#line 797 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 145:
#line 802 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"verythinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 146:
#line 807 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 147:
#line 812 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"thinmathspace\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 148:
#line 817 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"mediummathspace\" rspace=\"mediummathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 149:
#line 822 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"thickmathspace\" rspace=\"thickmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 150:
#line 828 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mspace height=\"", yystack.l_mark[-7], "ex\" depth=\"");
  char * s2 = itex2MML_copy3(yystack.l_mark[-4], "ex\" width=\"", yystack.l_mark[-1]);
  yyval = itex2MML_copy3(s1, s2, "em\"></mspace>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-7]);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 151:
#line 839 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"statusline\">", yystack.l_mark[0], "<mtext>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mtext></maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 152:
#line 847 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"tooltip\">", yystack.l_mark[0], "<mtext>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mtext></maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 153:
#line 855 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"toggle\" selection=\"2\">", yystack.l_mark[-1], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 154:
#line 863 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='color=", yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 155:
#line 871 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='background=", yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 156:
#line 879 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle mathcolor=", yystack.l_mark[-1], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 157:
#line 886 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle mathbackground=", yystack.l_mark[-1], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 158:
#line 894 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mpadded width=\"0\">", yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 159:
#line 899 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mpadded width=\"0\" lspace=\"-100%width\">", yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 160:
#line 904 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mpadded width=\"0\" lspace=\"-50%width\">", yystack.l_mark[0], "</mpadded>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 161:
#line 909 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtext>", yystack.l_mark[0], "</mtext>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 162:
#line 914 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle displaystyle=\"true\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 163:
#line 919 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle displaystyle=\"false\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 164:
#line 924 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"0\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 165:
#line 929 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"1\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 166:
#line 934 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"2\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 167:
#line 939 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle mathvariant=\"italic\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 168:
#line 944 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<menclose notation=\"updiagonalstrike\">", yystack.l_mark[0], "</menclose>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 169:
#line 949 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<menclose notation=\"box\">", yystack.l_mark[0], "</menclose>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 170:
#line 954 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle mathvariant=\"bold\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 171:
#line 959 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi mathvariant=\"normal\">", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 172:
#line 964 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 173:
#line 968 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 174:
#line 974 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 175:
#line 979 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 176:
#line 983 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 177:
#line 989 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "opf;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 178:
#line 993 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "opf;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 179:
#line 997 "itex2MML.y"
	{
  /* Blackboard digits 0-9 correspond to Unicode characters 0x1D7D8-0x1D7E1 */
  char * end = yystack.l_mark[0] + 1;
  int code = 0x1D7D8 + strtoul(yystack.l_mark[0], &end, 10);
  yyval = itex2MML_character_reference(code);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 180:
#line 1005 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 181:
#line 1010 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 182:
#line 1014 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 183:
#line 1020 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "fr;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 184:
#line 1025 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 185:
#line 1030 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 186:
#line 1034 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 187:
#line 1040 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "scr;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 188:
#line 1045 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"thinmathspace\"></mspace>");
}
break;
case 189:
#line 1049 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"mediummathspace\"></mspace>");
}
break;
case 190:
#line 1053 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"thickmathspace\"></mspace>");
}
break;
case 191:
#line 1057 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"1em\"></mspace>");
}
break;
case 192:
#line 1061 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"2em\"></mspace>");
}
break;
case 193:
#line 1065 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"-0.1667 em\"></mspace>");
}
break;
case 194:
#line 1069 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mphantom>", yystack.l_mark[0], "</mphantom>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 195:
#line 1074 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"", yystack.l_mark[-1], "\">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 196:
#line 1082 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 197:
#line 1089 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 198:
#line 1097 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  char * s2 = itex2MML_copy3("<mprescripts></mprescripts>", yystack.l_mark[-5], "</mmultiscripts>");
  yyval = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-5]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 199:
#line 1107 "itex2MML.y"
	{
  char * s1 = itex2MML_copy2("<mmultiscripts>", yystack.l_mark[-1]);
  char * s2 = itex2MML_copy3("<mprescripts></mprescripts>", yystack.l_mark[-3], "</mmultiscripts>");
  yyval = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 200:
#line 1116 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]); 
}
break;
case 201:
#line 1124 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 202:
#line 1128 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 203:
#line 1134 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 204:
#line 1139 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[0], " <none></none>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 205:
#line 1143 "itex2MML.y"
	{
  yyval = itex2MML_copy2("<none></none> ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 206:
#line 1147 "itex2MML.y"
	{
  yyval = itex2MML_copy2("<none></none> ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 207:
#line 1152 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 208:
#line 1159 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle displaystyle=\"false\"><mfrac>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac></mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 209:
#line 1167 "itex2MML.y"
	{
  yyval = itex2MML_copy3( "<mo lspace=\"mediummathspace\">(</mo><mo rspace=\"thinmathspace\">mod</mo>", yystack.l_mark[0], "<mo rspace=\"mediummathspace\">)</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 210:
#line 1172 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac><mrow>", yystack.l_mark[-3], "</mrow><mrow>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 211:
#line 1179 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-4], "<mfrac><mrow>");
  char * s2 = itex2MML_copy3(yystack.l_mark[-3], "</mrow><mrow>", yystack.l_mark[-1]);
  char * s3 = itex2MML_copy3("</mrow></mfrac>", yystack.l_mark[0], "</mrow>");
  yyval = itex2MML_copy3(s1, s2, s3);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 212:
#line 1193 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac linethickness=\"0\"><mrow>", yystack.l_mark[-3], "</mrow><mrow>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 213:
#line 1200 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-4], "<mfrac linethickness=\"0\"><mrow>");
  char * s2 = itex2MML_copy3(yystack.l_mark[-3], "</mrow><mrow>", yystack.l_mark[-1]);
  char * s3 = itex2MML_copy3("</mrow></mfrac>", yystack.l_mark[0], "</mrow>");
  yyval = itex2MML_copy3(s1, s2, s3);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 214:
#line 1214 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow><mo>(</mo><mfrac linethickness=\"0\">", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac><mo>)</mo></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 215:
#line 1221 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow><mo>(</mo><mstyle displaystyle=\"false\"><mfrac linethickness=\"0\">", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac></mstyle><mo>)</mo></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 216:
#line 1229 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<munder>", yystack.l_mark[0], "<mo>&UnderBrace;</mo></munder>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 217:
#line 1234 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<munder>", yystack.l_mark[0], "<mo>&#x00332;</mo></munder>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 218:
#line 1239 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&OverBrace;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 219:
#line 1244 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&#x000AF;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 220:
#line 1248 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&#x000AF;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 221:
#line 1253 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&RightVector;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 222:
#line 1257 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&RightVector;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 223:
#line 1262 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&dot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 224:
#line 1267 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&Dot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 225:
#line 1272 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&tdot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 226:
#line 1277 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&DotDot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 227:
#line 1282 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&tilde;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 228:
#line 1286 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&tilde;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 229:
#line 1291 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&#x2c7;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 230:
#line 1295 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&#x2c7;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 231:
#line 1300 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&#x5E;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 232:
#line 1304 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&#x5E;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 233:
#line 1309 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msqrt>", yystack.l_mark[0], "</msqrt>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 234:
#line 1314 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mroot>", yystack.l_mark[0], yystack.l_mark[-2]);
  yyval = itex2MML_copy2(s1, "</mroot>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 235:
#line 1321 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mroot>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mroot>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 236:
#line 1329 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munder><mo>", yystack.l_mark[-4], "</mo><mrow>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-2], "</mrow></munder>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 237:
#line 1336 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</munder>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 238:
#line 1344 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mover><mo>", yystack.l_mark[-1], "</mo>");
  yyval =  itex2MML_copy3(s1, yystack.l_mark[0], "</mover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 239:
#line 1351 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 240:
#line 1359 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munderover><mo>", yystack.l_mark[-4], "</mo><mrow>");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-2], "</mrow>");
  yyval = itex2MML_copy3(s2, yystack.l_mark[0], "</munderover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 241:
#line 1369 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[0], yystack.l_mark[-2]);
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</munderover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 242:
#line 1378 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mrow></mrow>");
}
break;
case 243:
#line 1382 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 244:
#line 1386 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable rowspacing=\"1.0ex\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 245:
#line 1390 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>(</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>)</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 246:
#line 1394 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>[</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>]</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 247:
#line 1398 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>&VerticalBar;</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>&VerticalBar;</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 248:
#line 1402 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>{</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>}</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 249:
#line 1406 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>&DoubleVerticalBar;</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>&DoubleVerticalBar;</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 250:
#line 1410 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"2\"><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow></mstyle>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 251:
#line 1414 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>{</mo><mrow><mtable columnalign=\"left left\">", yystack.l_mark[-2], "</mtable></mrow></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 252:
#line 1418 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable columnalign=\"right left right left right left right left right left\" columnspacing=\"0em\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 253:
#line 1422 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtable rowspacing=\"0.5ex\" align=\"", yystack.l_mark[-6], "\" columnalign=\"");
  char * s2 = itex2MML_copy3(s1, yystack.l_mark[-4], "\">");
  yyval = itex2MML_copy3(s2, yystack.l_mark[-2], "</mtable>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-6]);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 254:
#line 1432 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtable rowspacing=\"0.5ex\" columnalign=\"", yystack.l_mark[-4], "\">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-2], "</mtable>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 255:
#line 1439 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<semantics><annotation-xml encoding=\"SVG1.1\">", yystack.l_mark[-1], "</annotation-xml></semantics>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 256:
#line 1443 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(" ");
}
break;
case 257:
#line 1447 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 258:
#line 1452 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 259:
#line 1457 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable columnalign=\"center\" rowspacing=\"0.5ex\">", yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 260:
#line 1462 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable>", yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 261:
#line 1466 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow><mtable ", yystack.l_mark[-3], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 262:
#line 1474 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 263:
#line 1478 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 264:
#line 1484 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 265:
#line 1488 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 266:
#line 1492 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 267:
#line 1496 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 268:
#line 1500 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 269:
#line 1504 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 270:
#line 1508 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 271:
#line 1512 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 272:
#line 1516 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 273:
#line 1520 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 274:
#line 1525 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 275:
#line 1530 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 276:
#line 1535 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 277:
#line 1540 "itex2MML.y"
	{
  yyval = itex2MML_copy2("align=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 278:
#line 1545 "itex2MML.y"
	{
  yyval = itex2MML_copy2("equalrows=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 279:
#line 1550 "itex2MML.y"
	{
  yyval = itex2MML_copy2("equalcolumns=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 280:
#line 1555 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowlines=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 281:
#line 1560 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnlines=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 282:
#line 1565 "itex2MML.y"
	{
  yyval = itex2MML_copy2("frame=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 283:
#line 1570 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("rowspacing=", yystack.l_mark[0], " columnspacing=");
  yyval = itex2MML_copy2(s1, yystack.l_mark[0]);
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 284:
#line 1577 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 285:
#line 1581 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 286:
#line 1587 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtr>", yystack.l_mark[0], "</mtr>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 287:
#line 1591 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 288:
#line 1596 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 289:
#line 1600 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 290:
#line 1606 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtr ", yystack.l_mark[-2], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mtr>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 291:
#line 1614 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 292:
#line 1618 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 293:
#line 1624 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 294:
#line 1628 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 295:
#line 1633 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mtd></mtd>");
}
break;
case 296:
#line 1636 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtd>", yystack.l_mark[0], "</mtd>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 297:
#line 1640 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtd ", yystack.l_mark[-2], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mtd>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 298:
#line 1648 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 299:
#line 1652 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 300:
#line 1658 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 301:
#line 1662 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 302:
#line 1666 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 303:
#line 1670 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 304:
#line 1675 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowspan=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 305:
#line 1680 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnspan=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
#line 4805 "y.tab.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            if ((yychar = YYLEX) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
    {
        goto yyoverflow;
    }
    *++yystack.s_mark = (short) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    yyerror("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
