/* emojier.c generated by valac 0.34.6, the Vala compiler
 * generated from emojier.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright (c) 2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <ibus.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <atk/atk.h>
#include <config.h>
#include <pango/pango.h>


#define TYPE_IBUS_EMOJIER (ibus_emojier_get_type ())
#define IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IBUS_EMOJIER, IBusEmojier))
#define IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IBUS_EMOJIER, IBusEmojierClass))
#define IS_IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IBUS_EMOJIER))
#define IS_IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IBUS_EMOJIER))
#define IBUS_EMOJIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IBUS_EMOJIER, IBusEmojierClass))

typedef struct _IBusEmojier IBusEmojier;
typedef struct _IBusEmojierClass IBusEmojierClass;
typedef struct _IBusEmojierPrivate IBusEmojierPrivate;

#define IBUS_EMOJIER_TYPE_ETITLE_LABEL (ibus_emojier_etitle_label_get_type ())
#define IBUS_EMOJIER_ETITLE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_EMOJIER_TYPE_ETITLE_LABEL, IBusEmojierETitleLabel))
#define IBUS_EMOJIER_ETITLE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_EMOJIER_TYPE_ETITLE_LABEL, IBusEmojierETitleLabelClass))
#define IBUS_EMOJIER_IS_ETITLE_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_EMOJIER_TYPE_ETITLE_LABEL))
#define IBUS_EMOJIER_IS_ETITLE_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_EMOJIER_TYPE_ETITLE_LABEL))
#define IBUS_EMOJIER_ETITLE_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_EMOJIER_TYPE_ETITLE_LABEL, IBusEmojierETitleLabelClass))

typedef struct _IBusEmojierETitleLabel IBusEmojierETitleLabel;
typedef struct _IBusEmojierETitleLabelClass IBusEmojierETitleLabelClass;

#define IBUS_EMOJIER_TYPE_EENTRY (ibus_emojier_eentry_get_type ())
#define IBUS_EMOJIER_EENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_EMOJIER_TYPE_EENTRY, IBusEmojierEEntry))
#define IBUS_EMOJIER_EENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_EMOJIER_TYPE_EENTRY, IBusEmojierEEntryClass))
#define IBUS_EMOJIER_IS_EENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_EMOJIER_TYPE_EENTRY))
#define IBUS_EMOJIER_IS_EENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_EMOJIER_TYPE_EENTRY))
#define IBUS_EMOJIER_EENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_EMOJIER_TYPE_EENTRY, IBusEmojierEEntryClass))

typedef struct _IBusEmojierEEntry IBusEmojierEEntry;
typedef struct _IBusEmojierEEntryClass IBusEmojierEEntryClass;

#define IBUS_EMOJIER_TYPE_ESCROLLED_WINDOW (ibus_emojier_escrolled_window_get_type ())
#define IBUS_EMOJIER_ESCROLLED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_EMOJIER_TYPE_ESCROLLED_WINDOW, IBusEmojierEScrolledWindow))
#define IBUS_EMOJIER_ESCROLLED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_EMOJIER_TYPE_ESCROLLED_WINDOW, IBusEmojierEScrolledWindowClass))
#define IBUS_EMOJIER_IS_ESCROLLED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_EMOJIER_TYPE_ESCROLLED_WINDOW))
#define IBUS_EMOJIER_IS_ESCROLLED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_EMOJIER_TYPE_ESCROLLED_WINDOW))
#define IBUS_EMOJIER_ESCROLLED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_EMOJIER_TYPE_ESCROLLED_WINDOW, IBusEmojierEScrolledWindowClass))

typedef struct _IBusEmojierEScrolledWindow IBusEmojierEScrolledWindow;
typedef struct _IBusEmojierEScrolledWindowClass IBusEmojierEScrolledWindowClass;

#define IBUS_EMOJIER_TYPE_ELIST_BOX (ibus_emojier_elist_box_get_type ())
#define IBUS_EMOJIER_ELIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_EMOJIER_TYPE_ELIST_BOX, IBusEmojierEListBox))
#define IBUS_EMOJIER_ELIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_EMOJIER_TYPE_ELIST_BOX, IBusEmojierEListBoxClass))
#define IBUS_EMOJIER_IS_ELIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_EMOJIER_TYPE_ELIST_BOX))
#define IBUS_EMOJIER_IS_ELIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_EMOJIER_TYPE_ELIST_BOX))
#define IBUS_EMOJIER_ELIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_EMOJIER_TYPE_ELIST_BOX, IBusEmojierEListBoxClass))

typedef struct _IBusEmojierEListBox IBusEmojierEListBox;
typedef struct _IBusEmojierEListBoxClass IBusEmojierEListBoxClass;

#define IBUS_EMOJIER_TYPE_CATEGORY_TYPE (ibus_emojier_category_type_get_type ())

#define IBUS_EMOJIER_TYPE_TRAVEL_DIRECTION (ibus_emojier_travel_direction_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define IBUS_EMOJIER_TYPE_EPADDED_LABEL (ibus_emojier_epadded_label_get_type ())
#define IBUS_EMOJIER_EPADDED_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_EMOJIER_TYPE_EPADDED_LABEL, IBusEmojierEPaddedLabel))
#define IBUS_EMOJIER_EPADDED_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_EMOJIER_TYPE_EPADDED_LABEL, IBusEmojierEPaddedLabelClass))
#define IBUS_EMOJIER_IS_EPADDED_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_EMOJIER_TYPE_EPADDED_LABEL))
#define IBUS_EMOJIER_IS_EPADDED_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_EMOJIER_TYPE_EPADDED_LABEL))
#define IBUS_EMOJIER_EPADDED_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_EMOJIER_TYPE_EPADDED_LABEL, IBusEmojierEPaddedLabelClass))

typedef struct _IBusEmojierEPaddedLabel IBusEmojierEPaddedLabel;
typedef struct _IBusEmojierEPaddedLabelClass IBusEmojierEPaddedLabelClass;

#define IBUS_EMOJIER_TYPE_EBOX_ROW (ibus_emojier_ebox_row_get_type ())
#define IBUS_EMOJIER_EBOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_EMOJIER_TYPE_EBOX_ROW, IBusEmojierEBoxRow))
#define IBUS_EMOJIER_EBOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_EMOJIER_TYPE_EBOX_ROW, IBusEmojierEBoxRowClass))
#define IBUS_EMOJIER_IS_EBOX_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_EMOJIER_TYPE_EBOX_ROW))
#define IBUS_EMOJIER_IS_EBOX_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_EMOJIER_TYPE_EBOX_ROW))
#define IBUS_EMOJIER_EBOX_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_EMOJIER_TYPE_EBOX_ROW, IBusEmojierEBoxRowClass))

typedef struct _IBusEmojierEBoxRow IBusEmojierEBoxRow;
typedef struct _IBusEmojierEBoxRowClass IBusEmojierEBoxRowClass;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define IBUS_EMOJIER_TYPE_EGRID (ibus_emojier_egrid_get_type ())
#define IBUS_EMOJIER_EGRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_EMOJIER_TYPE_EGRID, IBusEmojierEGrid))
#define IBUS_EMOJIER_EGRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_EMOJIER_TYPE_EGRID, IBusEmojierEGridClass))
#define IBUS_EMOJIER_IS_EGRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_EMOJIER_TYPE_EGRID))
#define IBUS_EMOJIER_IS_EGRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_EMOJIER_TYPE_EGRID))
#define IBUS_EMOJIER_EGRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_EMOJIER_TYPE_EGRID, IBusEmojierEGridClass))

typedef struct _IBusEmojierEGrid IBusEmojierEGrid;
typedef struct _IBusEmojierEGridClass IBusEmojierEGridClass;
typedef struct _Block4Data Block4Data;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
typedef struct _IBusEmojierEEntryPrivate IBusEmojierEEntryPrivate;
typedef struct _IBusEmojierEListBoxPrivate IBusEmojierEListBoxPrivate;
typedef struct _IBusEmojierEBoxRowPrivate IBusEmojierEBoxRowPrivate;
typedef struct _IBusEmojierEScrolledWindowPrivate IBusEmojierEScrolledWindowPrivate;
typedef struct _IBusEmojierEGridPrivate IBusEmojierEGridPrivate;
typedef struct _IBusEmojierEPaddedLabelPrivate IBusEmojierEPaddedLabelPrivate;

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
typedef struct _IBusEmojierETitleLabelPrivate IBusEmojierETitleLabelPrivate;
typedef struct _Block5Data Block5Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _IBusEmojier {
	GtkWindow parent_instance;
	IBusEmojierPrivate * priv;
};

struct _IBusEmojierClass {
	GtkWindowClass parent_class;
};

typedef enum  {
	IBUS_EMOJIER_CATEGORY_TYPE_EMOJI,
	IBUS_EMOJIER_CATEGORY_TYPE_LANG
} IBusEmojierCategoryType;

struct _IBusEmojierPrivate {
	GtkBox* m_vbox;
	IBusEmojierETitleLabel* m_title;
	IBusEmojierEEntry* m_entry;
	gchar* m_backward;
	IBusEmojierEScrolledWindow* m_scrolled_window;
	IBusEmojierEListBox* m_list_box;
	IBusEmojierCategoryType m_current_category_type;
	gboolean m_is_running;
	gchar* m_input_context_path;
	GString* m_buffer_string;
	GMainLoop* m_loop;
	gchar* m_result;
	GSList* m_lang_list;
	gchar* m_current_lang;
	gchar* m_unicode_point;
	gboolean m_candidate_panel_is_visible;
	GHashTable* m_annotation_to_emojis_dict;
	GHashTable* m_emoji_to_data_dict;
	GHashTable* m_category_to_emojis_dict;
	gint m_category_active_index;
	gint m_emoji_max_seq_len;
	IBusLookupTable* m_lookup_table;
	GtkLabel** m_candidates;
	gint m_candidates_length1;
	gint _m_candidates_size_;
	gchar* m_emoji_font;
	gchar** m_favorites;
	gint m_favorites_length1;
	gint _m_favorites_size_;
	GdkRGBA m_selected_fg_color;
	GdkRGBA m_selected_bg_color;
};

typedef enum  {
	IBUS_EMOJIER_TRAVEL_DIRECTION_NONE,
	IBUS_EMOJIER_TRAVEL_DIRECTION_BACKWARD
} IBusEmojierTravelDirection;

struct _Block4Data {
	int _ref_count_;
	IBusEmojier* self;
	guint index;
};

struct _IBusEmojierEEntry {
	GtkSearchEntry parent_instance;
	IBusEmojierEEntryPrivate * priv;
};

struct _IBusEmojierEEntryClass {
	GtkSearchEntryClass parent_class;
};

struct _IBusEmojierEListBox {
	GtkListBox parent_instance;
	IBusEmojierEListBoxPrivate * priv;
};

struct _IBusEmojierEListBoxClass {
	GtkListBoxClass parent_class;
};

struct _IBusEmojierEBoxRow {
	GtkListBoxRow parent_instance;
	IBusEmojierEBoxRowPrivate * priv;
};

struct _IBusEmojierEBoxRowClass {
	GtkListBoxRowClass parent_class;
};

struct _IBusEmojierEBoxRowPrivate {
	gchar* _text;
	gchar* _id;
};

struct _IBusEmojierEScrolledWindow {
	GtkScrolledWindow parent_instance;
	IBusEmojierEScrolledWindowPrivate * priv;
};

struct _IBusEmojierEScrolledWindowClass {
	GtkScrolledWindowClass parent_class;
};

struct _IBusEmojierEGrid {
	GtkGrid parent_instance;
	IBusEmojierEGridPrivate * priv;
};

struct _IBusEmojierEGridClass {
	GtkGridClass parent_class;
};

struct _IBusEmojierEPaddedLabel {
	GtkBox parent_instance;
	IBusEmojierEPaddedLabelPrivate * priv;
};

struct _IBusEmojierEPaddedLabelClass {
	GtkBoxClass parent_class;
};

struct _IBusEmojierETitleLabel {
	GtkBox parent_instance;
	IBusEmojierETitleLabelPrivate * priv;
};

struct _IBusEmojierETitleLabelClass {
	GtkBoxClass parent_class;
};

struct _IBusEmojierETitleLabelPrivate {
	GtkButton* m_close_button;
	gulong m_close_handler;
};

struct _Block5Data {
	int _ref_count_;
	IBusEmojierETitleLabel* self;
	GMainLoop* loop;
};


static gpointer ibus_emojier_parent_class = NULL;
static gpointer ibus_emojier_eentry_parent_class = NULL;
static gpointer ibus_emojier_elist_box_parent_class = NULL;
static gpointer ibus_emojier_ebox_row_parent_class = NULL;
static gpointer ibus_emojier_escrolled_window_parent_class = NULL;
static gpointer ibus_emojier_egrid_parent_class = NULL;
static gpointer ibus_emojier_epadded_label_parent_class = NULL;
static gpointer ibus_emojier_etitle_label_parent_class = NULL;

GType ibus_emojier_get_type (void) G_GNUC_CONST;
static GType ibus_emojier_etitle_label_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType ibus_emojier_eentry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType ibus_emojier_escrolled_window_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType ibus_emojier_elist_box_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType ibus_emojier_category_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define IBUS_EMOJIER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IBUS_EMOJIER, IBusEmojierPrivate))
enum  {
	IBUS_EMOJIER_DUMMY_PROPERTY
};
static GType ibus_emojier_travel_direction_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
#define IBUS_EMOJIER_EMOJI_GRID_PAGE ((guint) 10)
IBusEmojier* ibus_emojier_new (void);
IBusEmojier* ibus_emojier_construct (GType object_type);
static IBusEmojierETitleLabel* ibus_emojier_etitle_label_new (const gchar* text, GtkAlign align);
static IBusEmojierETitleLabel* ibus_emojier_etitle_label_construct (GType object_type, const gchar* text, GtkAlign align);
static IBusEmojierEEntry* ibus_emojier_eentry_new (void);
static IBusEmojierEEntry* ibus_emojier_eentry_construct (GType object_type);
static void __lambda24_ (IBusEmojier* self);
void ibus_emojier_update_cadidate_window (IBusEmojier* self);
static void ___lambda24__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void __lambda32_ (IBusEmojier* self, GtkEntryIconPosition icon_pos, GdkEvent* event);
static void ibus_emojier_hide_candidate_panel (IBusEmojier* self);
static void ___lambda32__gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void __lambda33_ (IBusEmojier* self);
static void ___lambda33__gtk_widget_hide (GtkWidget* _sender, gpointer self);
static void __lambda34_ (IBusEmojier* self, guint i, guint b, guint s);
static void ___lambda34__ibus_emojier_candidate_clicked (IBusEmojier* _sender, guint index, guint button, guint state, gpointer self);
static gboolean __lambda35_ (IBusEmojier* self);
static GSList* ibus_emojier_read_lang_list (IBusEmojier* self);
static void ibus_emojier_reload_emoji_dict (IBusEmojier* self);
static gboolean ___lambda35__gsource_func (gpointer self);
static gint __lambda36_ (const gchar* a, const gchar* b);
static gint ___lambda36__gcompare_func (gconstpointer a, gconstpointer b);
static void ibus_emojier_init_emoji_dict (IBusEmojier* self);
static void ibus_emojier_make_emoji_dict (IBusEmojier* self, const gchar* lang);
static void _g_slist_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void ibus_emojier_update_annotation_to_emojis_dict (IBusEmojier* self, IBusEmojiData* data);
static void ibus_emojier_update_emoji_to_data_dict (IBusEmojier* self, IBusEmojiData* data, const gchar* lang);
static void ibus_emojier_update_category_to_emojis_dict (IBusEmojier* self, IBusEmojiData* data, const gchar* lang);
static gpointer _g_strdup_gcopy_func (gconstpointer src, gpointer self);
static void ibus_emojier_set_fixed_size (IBusEmojier* self);
static void ibus_emojier_remove_all_children (IBusEmojier* self);
static void ibus_emojier_show_category_list (IBusEmojier* self);
static IBusEmojierEScrolledWindow* ibus_emojier_escrolled_window_new (GtkAdjustment* hadjustment, GtkAdjustment* vadjustment);
static IBusEmojierEScrolledWindow* ibus_emojier_escrolled_window_construct (GType object_type, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment);
static GType ibus_emojier_epadded_label_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static IBusEmojierEPaddedLabel* ibus_emojier_epadded_label_new (const gchar* text, GtkAlign align, IBusEmojierTravelDirection direction);
static IBusEmojierEPaddedLabel* ibus_emojier_epadded_label_construct (GType object_type, const gchar* text, GtkAlign align, IBusEmojierTravelDirection direction);
static gboolean __lambda25_ (IBusEmojier* self, GdkEventButton* e);
static gboolean ___lambda25__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static IBusEmojierEListBox* ibus_emojier_elist_box_new (void);
static IBusEmojierEListBox* ibus_emojier_elist_box_construct (GType object_type);
static void ___lambda26_ (IBusEmojier* self, GtkListBox* box, GtkListBoxRow* gtkrow);
static GType ibus_emojier_ebox_row_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void ibus_emojier_show_emoji_for_category (IBusEmojier* self, IBusEmojierEBoxRow* row);
static void ____lambda26__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static IBusEmojierEBoxRow* ibus_emojier_ebox_row_new (const gchar* text, const gchar* id);
static IBusEmojierEBoxRow* ibus_emojier_ebox_row_construct (GType object_type, const gchar* text, const gchar* id);
static void ____lambda31_ (IBusEmojier* self, GtkListBox* box, GtkListBoxRow* gtkrow);
static const gchar* ibus_emojier_ebox_row_get_id (IBusEmojierEBoxRow* self);
static void _____lambda31__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static const gchar* ibus_emojier_ebox_row_get_text (IBusEmojierEBoxRow* self);
static void ibus_emojier_show_candidate_panel (IBusEmojier* self);
static void ibus_emojier_label_set_active_color (IBusEmojier* self, GtkLabel* label);
static void ibus_emojier_show_arrow_buttons (IBusEmojier* self);
static void __lambda29_ (IBusEmojier* self);
static void ___lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda30_ (IBusEmojier* self);
static void ___lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean ibus_emojier_check_unicode_point (IBusEmojier* self, gboolean check_xdigit_only);
static gboolean ___lambda27_ (IBusEmojier* self, GtkWidget* w, GdkEventButton* e);
static gboolean ____lambda27__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static GType ibus_emojier_egrid_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static IBusEmojierEGrid* ibus_emojier_egrid_new (void);
static IBusEmojierEGrid* ibus_emojier_egrid_construct (GType object_type);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static gboolean _____lambda28_ (Block4Data* _data4_, GtkWidget* w, GdkEventButton* e);
static gboolean ______lambda28__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_array_add10 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static gboolean ibus_emojier_if_in_range_of_lookup (IBusEmojier* self, guint keyval);
static void ibus_emojier_set_number_on_lookup (IBusEmojier* self, guint keyval);
static void ibus_emojier_candidate_panel_cursor_down (IBusEmojier* self);
static void ibus_emojier_candidate_panel_cursor_up (IBusEmojier* self);
static void ibus_emojier_category_list_cursor_move (IBusEmojier* self, guint keyval);
gchar* ibus_emojier_run (IBusEmojier* self, GdkEvent* event, const gchar* input_context_path);
static void ibus_emojier_etitle_label_set_loop (IBusEmojierETitleLabel* self, GMainLoop* loop);
static void ibus_emojier_etitle_label_unset_loop (IBusEmojierETitleLabel* self);
static void _vala_GdkEvent_free (GdkEvent* self);
static void ibus_emojier_real_show (GtkWidget* base);
static gboolean ibus_emojier_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean ibus_emojier_is_running (IBusEmojier* self);
gchar* ibus_emojier_get_input_context_path (IBusEmojier* self);
gchar* ibus_emojier_get_selected_string (IBusEmojier* self);
void ibus_emojier_reset (IBusEmojier* self);
void ibus_emojier_set_emoji_font (IBusEmojier* self, const gchar* emoji_font);
void ibus_emojier_set_favorites (IBusEmojier* self, gchar** unowned_favorites, int unowned_favorites_length1);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
gboolean ibus_emojier_has_loaded_emoji_dict (IBusEmojier* self);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
enum  {
	IBUS_EMOJIER_EENTRY_DUMMY_PROPERTY
};
enum  {
	IBUS_EMOJIER_ELIST_BOX_DUMMY_PROPERTY
};
#define IBUS_EMOJIER_EBOX_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_EMOJIER_TYPE_EBOX_ROW, IBusEmojierEBoxRowPrivate))
enum  {
	IBUS_EMOJIER_EBOX_ROW_DUMMY_PROPERTY,
	IBUS_EMOJIER_EBOX_ROW_TEXT,
	IBUS_EMOJIER_EBOX_ROW_ID
};
static void ibus_emojier_ebox_row_set_text (IBusEmojierEBoxRow* self, const gchar* value);
static void ibus_emojier_ebox_row_set_id (IBusEmojierEBoxRow* self, const gchar* value);
static void ibus_emojier_ebox_row_finalize (GObject* obj);
static void _vala_ibus_emojier_ebox_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_ibus_emojier_ebox_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	IBUS_EMOJIER_ESCROLLED_WINDOW_DUMMY_PROPERTY
};
enum  {
	IBUS_EMOJIER_EGRID_DUMMY_PROPERTY
};
enum  {
	IBUS_EMOJIER_EPADDED_LABEL_DUMMY_PROPERTY
};
GType icon_widget_get_type (void) G_GNUC_CONST;
IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size);
#define IBUS_EMOJIER_ETITLE_LABEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_EMOJIER_TYPE_ETITLE_LABEL, IBusEmojierETitleLabelPrivate))
enum  {
	IBUS_EMOJIER_ETITLE_LABEL_DUMMY_PROPERTY
};
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda23_ (Block5Data* _data5_, GdkEventButton* e);
static gboolean ___lambda23__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void ibus_emojier_etitle_label_finalize (GObject* obj);
static void ibus_emojier_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType ibus_emojier_travel_direction_get_type (void) {
	static volatile gsize ibus_emojier_travel_direction_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_travel_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{IBUS_EMOJIER_TRAVEL_DIRECTION_NONE, "IBUS_EMOJIER_TRAVEL_DIRECTION_NONE", "none"}, {IBUS_EMOJIER_TRAVEL_DIRECTION_BACKWARD, "IBUS_EMOJIER_TRAVEL_DIRECTION_BACKWARD", "backward"}, {0, NULL, NULL}};
		GType ibus_emojier_travel_direction_type_id;
		ibus_emojier_travel_direction_type_id = g_enum_register_static ("IBusEmojierTravelDirection", values);
		g_once_init_leave (&ibus_emojier_travel_direction_type_id__volatile, ibus_emojier_travel_direction_type_id);
	}
	return ibus_emojier_travel_direction_type_id__volatile;
}


static GType ibus_emojier_category_type_get_type (void) {
	static volatile gsize ibus_emojier_category_type_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_category_type_type_id__volatile)) {
		static const GEnumValue values[] = {{IBUS_EMOJIER_CATEGORY_TYPE_EMOJI, "IBUS_EMOJIER_CATEGORY_TYPE_EMOJI", "emoji"}, {IBUS_EMOJIER_CATEGORY_TYPE_LANG, "IBUS_EMOJIER_CATEGORY_TYPE_LANG", "lang"}, {0, NULL, NULL}};
		GType ibus_emojier_category_type_type_id;
		ibus_emojier_category_type_type_id = g_enum_register_static ("IBusEmojierCategoryType", values);
		g_once_init_leave (&ibus_emojier_category_type_type_id__volatile, ibus_emojier_category_type_type_id);
	}
	return ibus_emojier_category_type_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda24_ (IBusEmojier* self) {
	GString* _tmp0_ = NULL;
	IBusEmojierEEntry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = self->priv->m_buffer_string;
	_tmp1_ = self->priv->m_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	g_string_assign (_tmp0_, _tmp2_);
	ibus_emojier_update_cadidate_window (self);
}


static void ___lambda24__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda24_ ((IBusEmojier*) self);
}


static void __lambda32_ (IBusEmojier* self, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	GString* _tmp0_ = NULL;
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_buffer_string;
	g_string_erase (_tmp0_, (gssize) 0, (gssize) -1);
	ibus_emojier_hide_candidate_panel (self);
}


static void ___lambda32__gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda32_ ((IBusEmojier*) self, p0, p1);
}


static void __lambda33_ (IBusEmojier* self) {
	gboolean _tmp0_ = FALSE;
	GMainLoop* _tmp1_ = NULL;
	_tmp1_ = self->priv->m_loop;
	if (_tmp1_ != NULL) {
		GMainLoop* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->m_loop;
		_tmp3_ = g_main_loop_is_running (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GMainLoop* _tmp4_ = NULL;
		_tmp4_ = self->priv->m_loop;
		g_main_loop_quit (_tmp4_);
	}
}


static void ___lambda33__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	__lambda33_ ((IBusEmojier*) self);
}


static void __lambda34_ (IBusEmojier* self, guint i, guint b, guint s) {
	IBusText* candidate = NULL;
	IBusLookupTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	IBusText* _tmp2_ = NULL;
	IBusText* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	_tmp0_ = self->priv->m_lookup_table;
	_tmp1_ = i;
	_tmp2_ = ibus_lookup_table_get_candidate (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	candidate = _tmp3_;
	_tmp4_ = candidate->text;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->m_result);
	self->priv->m_result = _tmp5_;
	_tmp6_ = self->priv->m_loop;
	g_main_loop_quit (_tmp6_);
	ibus_emojier_hide_candidate_panel (self);
	_g_object_unref0 (candidate);
}


static void ___lambda34__ibus_emojier_candidate_clicked (IBusEmojier* _sender, guint index, guint button, guint state, gpointer self) {
	__lambda34_ ((IBusEmojier*) self, index, button, state);
}


static gboolean __lambda35_ (IBusEmojier* self) {
	gboolean result = FALSE;
	GSList* _tmp0_ = NULL;
	_tmp0_ = ibus_emojier_read_lang_list (self);
	__g_slist_free__g_free0_0 (self->priv->m_lang_list);
	self->priv->m_lang_list = _tmp0_;
	ibus_emojier_reload_emoji_dict (self);
	result = FALSE;
	return result;
}


static gboolean ___lambda35__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda35_ ((IBusEmojier*) self);
	return result;
}


IBusEmojier* ibus_emojier_construct (GType object_type) {
	IBusEmojier * self = NULL;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_ = NULL;
	GdkDisplay* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GdkDisplay* _tmp3_ = NULL;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp6_ = NULL;
	GdkScreen* _tmp7_ = NULL;
	gchar* data = NULL;
	gchar* _tmp8_ = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp9_ = NULL;
	GdkScreen* _tmp14_ = NULL;
	GtkCssProvider* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkBox* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	IBusEmojierETitleLabel* _tmp19_ = NULL;
	GtkBox* _tmp20_ = NULL;
	IBusEmojierETitleLabel* _tmp21_ = NULL;
	IBusEmojierEEntry* _tmp22_ = NULL;
	IBusEmojierEEntry* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GtkBox* _tmp25_ = NULL;
	IBusEmojierEEntry* _tmp26_ = NULL;
	IBusEmojierEEntry* _tmp27_ = NULL;
	IBusEmojierEEntry* _tmp28_ = NULL;
	AtkObject* obj = NULL;
	IBusEmojierEEntry* _tmp29_ = NULL;
	AtkObject* _tmp30_ = NULL;
	AtkObject* _tmp31_ = NULL;
	AtkObject* _tmp32_ = NULL;
	GString* _tmp33_ = NULL;
	IBusLookupTable* _tmp34_ = NULL;
	IBusLookupTable* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
	self = (IBusEmojier*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "events", (GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK) | GDK_BUTTON_PRESS_MASK, "window-position", GTK_WIN_POS_CENTER, "accept-focus", TRUE, "decorated", FALSE, "modal", TRUE, "resizable", TRUE, "focus-visible", TRUE, NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		GdkDisplay* _tmp4_ = NULL;
		GdkScreen* _tmp5_ = NULL;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp2_);
	screen = _tmp6_;
	_tmp7_ = screen;
	if (_tmp7_ == NULL) {
		g_warning ("emojier.vala:220: Could not open display.");
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return self;
	}
	_tmp8_ = g_strdup ("grid { background-color: #ffffff; }");
	data = _tmp8_;
	_tmp9_ = gtk_css_provider_new ();
	css_provider = _tmp9_;
	{
		GtkCssProvider* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp10_ = css_provider;
		_tmp11_ = data;
		gtk_css_provider_load_from_data (_tmp10_, _tmp11_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("emojier.vala:228: Failed css_provider_from_data: %s", _tmp13_);
		_g_error_free0 (e);
		_g_object_unref0 (css_provider);
		_g_free0 (data);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return self;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (css_provider);
		_g_free0 (data);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp14_ = screen;
	_tmp15_ = css_provider;
	gtk_style_context_add_provider_for_screen (_tmp14_, (GtkStyleProvider*) _tmp15_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->m_vbox);
	self->priv->m_vbox = _tmp16_;
	_tmp17_ = self->priv->m_vbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = _ ("Emoji Dialog");
	_tmp19_ = ibus_emojier_etitle_label_new (_tmp18_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->m_title);
	self->priv->m_title = _tmp19_;
	_tmp20_ = self->priv->m_vbox;
	_tmp21_ = self->priv->m_title;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = ibus_emojier_eentry_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->m_entry);
	self->priv->m_entry = _tmp22_;
	_tmp23_ = self->priv->m_entry;
	_tmp24_ = _ ("Type annotation or choose emoji");
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp23_, _tmp24_);
	_tmp25_ = self->priv->m_vbox;
	_tmp26_ = self->priv->m_entry;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->m_entry;
	g_signal_connect_object ((GtkEditable*) _tmp27_, "changed", (GCallback) ___lambda24__gtk_editable_changed, self, 0);
	_tmp28_ = self->priv->m_entry;
	g_signal_connect_object ((GtkEntry*) _tmp28_, "icon-release", (GCallback) ___lambda32__gtk_entry_icon_release, self, 0);
	_tmp29_ = self->priv->m_entry;
	_tmp30_ = gtk_widget_get_accessible ((GtkWidget*) _tmp29_);
	_tmp31_ = _g_object_ref0 (_tmp30_);
	obj = _tmp31_;
	_tmp32_ = obj;
	atk_object_set_role (_tmp32_, ATK_ROLE_STATUSBAR);
	_tmp33_ = g_string_new ("");
	_g_string_free0 (self->priv->m_buffer_string);
	self->priv->m_buffer_string = _tmp33_;
	gtk_widget_grab_focus ((GtkWidget*) self);
	_tmp34_ = ibus_lookup_table_new ((guint) 1, (guint) 0, TRUE, TRUE);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->m_lookup_table);
	self->priv->m_lookup_table = _tmp34_;
	_tmp35_ = self->priv->m_lookup_table;
	ibus_lookup_table_set_page_size (_tmp35_, IBUS_EMOJIER_EMOJI_GRID_PAGE * IBUS_EMOJIER_EMOJI_GRID_PAGE);
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) ___lambda33__gtk_widget_hide, self, 0);
	g_signal_connect_object (self, "candidate-clicked", (GCallback) ___lambda34__ibus_emojier_candidate_clicked, self, 0);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda35__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (obj);
	_g_object_unref0 (css_provider);
	_g_free0 (data);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
	return self;
}


IBusEmojier* ibus_emojier_new (void) {
	return ibus_emojier_construct (TYPE_IBUS_EMOJIER);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gint __lambda36_ (const gchar* a, const gchar* b) {
	gint result = 0;
	gchar* a_lang = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* b_lang = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GCompareFunc _tmp6_ = NULL;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = ibus_get_language_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	a_lang = _tmp2_;
	_tmp3_ = b;
	_tmp4_ = ibus_get_language_name (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	b_lang = _tmp5_;
	_tmp6_ = g_strcmp0;
	_tmp7_ = _tmp6_ (a_lang, b_lang);
	result = _tmp7_;
	_g_free0 (b_lang);
	_g_free0 (a_lang);
	return result;
}


static gint ___lambda36__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda36_ ((const gchar*) a, (const gchar*) b);
	return result;
}


static GSList* ibus_emojier_read_lang_list (IBusEmojier* self) {
	GSList* result = NULL;
	GSList* lang_list = NULL;
	static const char dict_path[] = PKGDATADIR "/dicts";
	GDir* dir = NULL;
	gchar* name = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	lang_list = NULL;
	dir = NULL;
	{
		GDir* _tmp0_ = NULL;
		GDir* _tmp1_ = NULL;
		GDir* _tmp2_ = NULL;
		_tmp1_ = g_dir_open (dict_path, (guint) 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_dir_close0 (dir);
			__g_slist_free__g_free0_0 (lang_list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp2_;
		_g_dir_close0 (_tmp0_);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("emojier.vala:296: Error loading %s: %s", dict_path, _tmp4_);
		result = lang_list;
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_dir_close0 (dir);
		__g_slist_free__g_free0_0 (lang_list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	while (TRUE) {
		GDir* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		static const char dict_suffix[] = ".dict";
		static const char dict_prefix[] = "emoji-";
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp5_ = dir;
		_tmp6_ = g_dir_read_name (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (name);
		name = _tmp7_;
		_tmp8_ = name;
		if (!(_tmp8_ != NULL)) {
			break;
		}
		_tmp9_ = name;
		_tmp10_ = g_str_has_suffix (_tmp9_, dict_suffix);
		if (_tmp10_) {
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			_tmp11_ = name;
			_tmp12_ = name;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = strlen (dict_suffix);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_slice (_tmp11_, (glong) 0, (glong) (_tmp14_ - _tmp16_));
			_g_free0 (name);
			name = _tmp17_;
			_tmp18_ = name;
			_tmp19_ = g_str_has_prefix (_tmp18_, dict_prefix);
			if (_tmp19_) {
				const gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				const gchar* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				_tmp20_ = name;
				_tmp21_ = strlen (dict_prefix);
				_tmp22_ = _tmp21_;
				_tmp23_ = name;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = string_slice (_tmp20_, (glong) _tmp22_, (glong) _tmp25_);
				_g_free0 (name);
				name = _tmp26_;
				_tmp27_ = name;
				_tmp28_ = g_strdup (_tmp27_);
				lang_list = g_slist_append (lang_list, _tmp28_);
			} else {
				const gchar* _tmp29_ = NULL;
				_tmp29_ = name;
				g_warning ("emojier.vala:309: Need %s prefix in the filename: %s/%s%s", dict_prefix, dict_path, _tmp29_, dict_suffix);
			}
		} else {
			const gchar* _tmp30_ = NULL;
			_tmp30_ = name;
			g_warning ("emojier.vala:313: Need %s extention in the filename: %s/%s", dict_suffix, dict_path, _tmp30_);
		}
	}
	lang_list = g_slist_sort (lang_list, ___lambda36__gcompare_func);
	result = lang_list;
	_g_free0 (name);
	_g_dir_close0 (dir);
	return result;
}


static void ibus_emojier_reload_emoji_dict (IBusEmojier* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	ibus_emojier_init_emoji_dict (self);
	ibus_emojier_make_emoji_dict (self, "en");
	_tmp0_ = self->priv->m_current_lang;
	if (g_strcmp0 (_tmp0_, "en") != 0) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = self->priv->m_current_lang;
		ibus_emojier_make_emoji_dict (self, _tmp1_);
	}
	g_signal_emit_by_name (self, "loaded-emoji-dict");
}


static void _g_slist_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_slist_free (var), NULL));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void ibus_emojier_init_emoji_dict (IBusEmojier* self) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashFunc _tmp6_ = NULL;
	GEqualFunc _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_slist_free0_);
	_g_hash_table_unref0 (self->priv->m_annotation_to_emojis_dict);
	self->priv->m_annotation_to_emojis_dict = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->m_emoji_to_data_dict);
	self->priv->m_emoji_to_data_dict = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_slist_free0_);
	_g_hash_table_unref0 (self->priv->m_category_to_emojis_dict);
	self->priv->m_category_to_emojis_dict = _tmp8_;
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static void ibus_emojier_make_emoji_dict (IBusEmojier* self, const gchar* lang) {
	GSList* emoji_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GSList* _tmp5_ = NULL;
	GSList* _tmp6_ = NULL;
	GSList* _tmp7_ = NULL;
	GSList* _tmp8_ = NULL;
	GList* annotations = NULL;
	GHashTable* _tmp15_ = NULL;
	GList* _tmp16_ = NULL;
	GList* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lang != NULL);
	_tmp0_ = lang;
	_tmp1_ = g_strconcat (PKGDATADIR "/dicts/emoji-", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ".dict", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = ibus_emoji_data_load (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	emoji_list = _tmp6_;
	_tmp7_ = emoji_list;
	if (_tmp7_ == NULL) {
		__g_slist_free__g_object_unref0_0 (emoji_list);
		return;
	}
	_tmp8_ = emoji_list;
	{
		GSList* data_collection = NULL;
		GSList* data_it = NULL;
		data_collection = _tmp8_;
		for (data_it = data_collection; data_it != NULL; data_it = data_it->next) {
			IBusEmojiData* _tmp9_ = NULL;
			IBusEmojiData* data = NULL;
			_tmp9_ = _g_object_ref0 ((IBusEmojiData*) data_it->data);
			data = _tmp9_;
			{
				IBusEmojiData* _tmp10_ = NULL;
				IBusEmojiData* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				IBusEmojiData* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				_tmp10_ = data;
				ibus_emojier_update_annotation_to_emojis_dict (self, _tmp10_);
				_tmp11_ = data;
				_tmp12_ = lang;
				ibus_emojier_update_emoji_to_data_dict (self, _tmp11_, _tmp12_);
				_tmp13_ = data;
				_tmp14_ = lang;
				ibus_emojier_update_category_to_emojis_dict (self, _tmp13_, _tmp14_);
				_g_object_unref0 (data);
			}
		}
	}
	_tmp15_ = self->priv->m_annotation_to_emojis_dict;
	_tmp16_ = g_hash_table_get_keys (_tmp15_);
	annotations = _tmp16_;
	_tmp17_ = annotations;
	{
		GList* annotation_collection = NULL;
		GList* annotation_it = NULL;
		annotation_collection = _tmp17_;
		for (annotation_it = annotation_collection; annotation_it != NULL; annotation_it = annotation_it->next) {
			const gchar* annotation = NULL;
			annotation = (const gchar*) annotation_it->data;
			{
				gint _tmp18_ = 0;
				const gchar* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				_tmp18_ = self->priv->m_emoji_max_seq_len;
				_tmp19_ = annotation;
				_tmp20_ = strlen (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp18_ < _tmp21_) {
					const gchar* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					_tmp22_ = annotation;
					_tmp23_ = strlen (_tmp22_);
					_tmp24_ = _tmp23_;
					self->priv->m_emoji_max_seq_len = _tmp24_;
				}
			}
		}
	}
	_g_list_free0 (annotations);
	__g_slist_free__g_object_unref0_0 (emoji_list);
}


static void ibus_emojier_update_annotation_to_emojis_dict (IBusEmojier* self, IBusEmojiData* data) {
	gchar* emoji = NULL;
	IBusEmojiData* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GSList* annotations = NULL;
	IBusEmojiData* _tmp3_ = NULL;
	GSList* _tmp4_ = NULL;
	GSList* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = data;
	_tmp1_ = ibus_emoji_data_get_emoji (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	emoji = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = ibus_emoji_data_get_annotations (_tmp3_);
	annotations = _tmp4_;
	_tmp5_ = annotations;
	{
		GSList* annotation_collection = NULL;
		GSList* annotation_it = NULL;
		annotation_collection = _tmp5_;
		for (annotation_it = annotation_collection; annotation_it != NULL; annotation_it = annotation_it->next) {
			gchar* _tmp6_ = NULL;
			gchar* annotation = NULL;
			_tmp6_ = g_strdup ((const gchar*) annotation_it->data);
			annotation = _tmp6_;
			{
				gboolean has_emoji = FALSE;
				GSList* hits = NULL;
				GHashTable* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gconstpointer _tmp9_ = NULL;
				GSList* _tmp10_ = NULL;
				gboolean _tmp14_ = FALSE;
				has_emoji = FALSE;
				_tmp7_ = self->priv->m_annotation_to_emojis_dict;
				_tmp8_ = annotation;
				_tmp9_ = g_hash_table_lookup (_tmp7_, _tmp8_);
				hits = (GSList*) _tmp9_;
				_tmp10_ = hits;
				{
					GSList* hit_emoji_collection = NULL;
					GSList* hit_emoji_it = NULL;
					hit_emoji_collection = _tmp10_;
					for (hit_emoji_it = hit_emoji_collection; hit_emoji_it != NULL; hit_emoji_it = hit_emoji_it->next) {
						gchar* _tmp11_ = NULL;
						gchar* hit_emoji = NULL;
						_tmp11_ = g_strdup ((const gchar*) hit_emoji_it->data);
						hit_emoji = _tmp11_;
						{
							const gchar* _tmp12_ = NULL;
							const gchar* _tmp13_ = NULL;
							_tmp12_ = hit_emoji;
							_tmp13_ = emoji;
							if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
								has_emoji = TRUE;
								_g_free0 (hit_emoji);
								break;
							}
							_g_free0 (hit_emoji);
						}
					}
				}
				_tmp14_ = has_emoji;
				if (!_tmp14_) {
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					GHashTable* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					GSList* _tmp20_ = NULL;
					GSList* _tmp21_ = NULL;
					_tmp15_ = emoji;
					_tmp16_ = g_strdup (_tmp15_);
					hits = g_slist_append (hits, _tmp16_);
					_tmp17_ = self->priv->m_annotation_to_emojis_dict;
					_tmp18_ = annotation;
					_tmp19_ = g_strdup (_tmp18_);
					_tmp20_ = hits;
					_tmp21_ = g_slist_copy (_tmp20_);
					g_hash_table_replace (_tmp17_, _tmp19_, _tmp21_);
				}
				_g_free0 (annotation);
			}
		}
	}
	_g_free0 (emoji);
}


static gpointer _g_strdup_gcopy_func (gconstpointer src, gpointer self) {
	gpointer result;
	result = g_strdup ((const gchar*) src);
	return result;
}


static void ibus_emojier_update_emoji_to_data_dict (IBusEmojier* self, IBusEmojiData* data, const gchar* lang) {
	gchar* emoji = NULL;
	IBusEmojiData* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	g_return_if_fail (lang != NULL);
	_tmp0_ = data;
	_tmp1_ = ibus_emoji_data_get_emoji (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	emoji = _tmp2_;
	_tmp3_ = lang;
	if (g_strcmp0 (_tmp3_, "en") == 0) {
		GHashTable* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		IBusEmojiData* _tmp7_ = NULL;
		IBusEmojiData* _tmp8_ = NULL;
		_tmp4_ = self->priv->m_emoji_to_data_dict;
		_tmp5_ = emoji;
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = data;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		g_hash_table_replace (_tmp4_, _tmp6_, _tmp8_);
	} else {
		IBusEmojiData* en_data = NULL;
		GHashTable* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		IBusEmojiData* _tmp12_ = NULL;
		GSList* annotations = NULL;
		IBusEmojiData* _tmp21_ = NULL;
		GSList* _tmp22_ = NULL;
		GSList* en_annotations = NULL;
		IBusEmojiData* _tmp23_ = NULL;
		GSList* _tmp24_ = NULL;
		GSList* _tmp25_ = NULL;
		IBusEmojiData* _tmp33_ = NULL;
		GSList* _tmp34_ = NULL;
		GSList* _tmp35_ = NULL;
		_tmp9_ = self->priv->m_emoji_to_data_dict;
		_tmp10_ = emoji;
		_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
		en_data = (IBusEmojiData*) _tmp11_;
		_tmp12_ = en_data;
		if (_tmp12_ == NULL) {
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			GHashTable* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			IBusEmojiData* _tmp19_ = NULL;
			IBusEmojiData* _tmp20_ = NULL;
			_tmp13_ = emoji;
			_tmp14_ = g_strdup_printf ("No IBusEmojiData for English: %s", _tmp13_);
			_tmp15_ = _tmp14_;
			g_warning ("emojier.vala:392: %s", _tmp15_);
			_g_free0 (_tmp15_);
			_tmp16_ = self->priv->m_emoji_to_data_dict;
			_tmp17_ = emoji;
			_tmp18_ = g_strdup (_tmp17_);
			_tmp19_ = data;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			g_hash_table_insert (_tmp16_, _tmp18_, _tmp20_);
			_g_free0 (emoji);
			return;
		}
		_tmp21_ = data;
		_tmp22_ = ibus_emoji_data_get_annotations (_tmp21_);
		annotations = _tmp22_;
		_tmp23_ = en_data;
		_tmp24_ = ibus_emoji_data_get_annotations (_tmp23_);
		en_annotations = _tmp24_;
		_tmp25_ = en_annotations;
		{
			GSList* annotation_collection = NULL;
			GSList* annotation_it = NULL;
			annotation_collection = _tmp25_;
			for (annotation_it = annotation_collection; annotation_it != NULL; annotation_it = annotation_it->next) {
				gchar* _tmp26_ = NULL;
				gchar* annotation = NULL;
				_tmp26_ = g_strdup ((const gchar*) annotation_it->data);
				annotation = _tmp26_;
				{
					GSList* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					GCompareFunc _tmp29_ = NULL;
					GSList* _tmp30_ = NULL;
					_tmp27_ = annotations;
					_tmp28_ = annotation;
					_tmp29_ = g_strcmp0;
					_tmp30_ = g_slist_find_custom (_tmp27_, _tmp28_, _tmp29_);
					if (_tmp30_ == NULL) {
						const gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						_tmp31_ = annotation;
						_tmp32_ = g_strdup (_tmp31_);
						annotations = g_slist_append (annotations, _tmp32_);
					}
					_g_free0 (annotation);
				}
			}
		}
		_tmp33_ = en_data;
		_tmp34_ = annotations;
		_tmp35_ = g_slist_copy_deep (_tmp34_, _g_strdup_gcopy_func, NULL);
		ibus_emoji_data_set_annotations (_tmp33_, _tmp35_);
	}
	_g_free0 (emoji);
}


static void ibus_emojier_update_category_to_emojis_dict (IBusEmojier* self, IBusEmojiData* data, const gchar* lang) {
	gchar* emoji = NULL;
	IBusEmojiData* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* category = NULL;
	IBusEmojiData* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	g_return_if_fail (lang != NULL);
	_tmp0_ = data;
	_tmp1_ = ibus_emoji_data_get_emoji (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	emoji = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = ibus_emoji_data_get_category (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	category = _tmp5_;
	_tmp7_ = lang;
	if (g_strcmp0 (_tmp7_, "en") == 0) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = category;
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean has_emoji = FALSE;
		GSList* hits = NULL;
		GHashTable* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		GSList* _tmp12_ = NULL;
		gboolean _tmp16_ = FALSE;
		has_emoji = FALSE;
		_tmp9_ = self->priv->m_category_to_emojis_dict;
		_tmp10_ = category;
		_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
		hits = (GSList*) _tmp11_;
		_tmp12_ = hits;
		{
			GSList* hit_emoji_collection = NULL;
			GSList* hit_emoji_it = NULL;
			hit_emoji_collection = _tmp12_;
			for (hit_emoji_it = hit_emoji_collection; hit_emoji_it != NULL; hit_emoji_it = hit_emoji_it->next) {
				gchar* _tmp13_ = NULL;
				gchar* hit_emoji = NULL;
				_tmp13_ = g_strdup ((const gchar*) hit_emoji_it->data);
				hit_emoji = _tmp13_;
				{
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					_tmp14_ = hit_emoji;
					_tmp15_ = emoji;
					if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
						has_emoji = TRUE;
						_g_free0 (hit_emoji);
						break;
					}
					_g_free0 (hit_emoji);
				}
			}
		}
		_tmp16_ = has_emoji;
		if (!_tmp16_) {
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			GHashTable* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			GSList* _tmp22_ = NULL;
			GSList* _tmp23_ = NULL;
			_tmp17_ = emoji;
			_tmp18_ = g_strdup (_tmp17_);
			hits = g_slist_append (hits, _tmp18_);
			_tmp19_ = self->priv->m_category_to_emojis_dict;
			_tmp20_ = category;
			_tmp21_ = g_strdup (_tmp20_);
			_tmp22_ = hits;
			_tmp23_ = g_slist_copy (_tmp22_);
			g_hash_table_replace (_tmp19_, _tmp21_, _tmp23_);
		}
	}
	_g_free0 (category);
	_g_free0 (emoji);
}


static void ibus_emojier_set_fixed_size (IBusEmojier* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->m_candidate_panel_is_visible;
	if (!_tmp1_) {
		IBusEmojierCategoryType _tmp2_ = 0;
		_tmp2_ = self->priv->m_current_category_type;
		_tmp0_ = _tmp2_ == IBUS_EMOJIER_CATEGORY_TYPE_LANG;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkPolicyType vpolicy = 0;
		IBusEmojierEScrolledWindow* _tmp3_ = NULL;
		GtkPolicyType _tmp4_ = 0;
		GtkPolicyType _tmp5_ = 0;
		gint width = 0;
		gint height = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		IBusEmojierEScrolledWindow* _tmp10_ = NULL;
		_tmp3_ = self->priv->m_scrolled_window;
		gtk_scrolled_window_get_policy ((GtkScrolledWindow*) _tmp3_, NULL, &_tmp4_);
		vpolicy = _tmp4_;
		_tmp5_ = vpolicy;
		if (_tmp5_ == GTK_POLICY_AUTOMATIC) {
			return;
		}
		gtk_window_get_size ((GtkWindow*) self, &_tmp6_, &_tmp7_);
		width = _tmp6_;
		height = _tmp7_;
		_tmp8_ = width;
		_tmp9_ = height;
		gtk_widget_set_size_request ((GtkWidget*) self, _tmp8_, _tmp9_);
		_tmp10_ = self->priv->m_scrolled_window;
		if (_tmp10_ != NULL) {
			IBusEmojierEScrolledWindow* _tmp11_ = NULL;
			_tmp11_ = self->priv->m_scrolled_window;
			gtk_scrolled_window_set_policy ((GtkScrolledWindow*) _tmp11_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		}
	} else {
		IBusEmojierEScrolledWindow* _tmp12_ = NULL;
		gtk_window_resize ((GtkWindow*) self, 20, 1);
		_tmp12_ = self->priv->m_scrolled_window;
		if (_tmp12_ != NULL) {
			IBusEmojierEScrolledWindow* _tmp13_ = NULL;
			_tmp13_ = self->priv->m_scrolled_window;
			gtk_scrolled_window_set_policy ((GtkScrolledWindow*) _tmp13_, GTK_POLICY_NEVER, GTK_POLICY_NEVER);
		}
	}
}


static void ibus_emojier_remove_all_children (IBusEmojier* self) {
	GtkBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_vbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp1_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp2_ = NULL;
			GtkWidget* w = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				GtkWidget* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				GtkWidget* _tmp10_ = NULL;
				_tmp4_ = w;
				_tmp5_ = gtk_widget_get_name (_tmp4_);
				_tmp6_ = _tmp5_;
				if (g_strcmp0 (_tmp6_, "IBusEmojierEntry") == 0) {
					_tmp3_ = TRUE;
				} else {
					GtkWidget* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					_tmp7_ = w;
					_tmp8_ = gtk_widget_get_name (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp3_ = g_strcmp0 (_tmp9_, "IBusEmojierTitleLabel") == 0;
				}
				if (_tmp3_) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp10_ = w;
				gtk_widget_destroy (_tmp10_);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
}


static gboolean __lambda25_ (IBusEmojier* self, GdkEventButton* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (e != NULL, FALSE);
	self->priv->m_category_active_index = 0;
	self->priv->m_current_category_type = IBUS_EMOJIER_CATEGORY_TYPE_LANG;
	ibus_emojier_show_category_list (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda25__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda25_ ((IBusEmojier*) self, event);
	return result;
}


static void ___lambda26_ (IBusEmojier* self, GtkListBox* box, GtkListBoxRow* gtkrow) {
	IBusEmojierEBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	IBusEmojierEBoxRow* _tmp1_ = NULL;
	g_return_if_fail (box != NULL);
	g_return_if_fail (gtkrow != NULL);
	self->priv->m_category_active_index = 0;
	_tmp0_ = gtkrow;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, IBUS_EMOJIER_TYPE_EBOX_ROW) ? ((IBusEmojierEBoxRow*) _tmp0_) : NULL);
	row = _tmp1_;
	ibus_emojier_show_emoji_for_category (self, row);
	_g_object_unref0 (row);
}


static void ____lambda26__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	___lambda26_ ((IBusEmojier*) self, _sender, row);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static void ____lambda31_ (IBusEmojier* self, GtkListBox* box, GtkListBoxRow* gtkrow) {
	IBusEmojierEBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	IBusEmojierEBoxRow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IBusEmojierEBoxRow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (box != NULL);
	g_return_if_fail (gtkrow != NULL);
	self->priv->m_category_active_index = 0;
	_tmp0_ = gtkrow;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, IBUS_EMOJIER_TYPE_EBOX_ROW) ? ((IBusEmojierEBoxRow*) _tmp0_) : NULL);
	row = _tmp1_;
	_tmp2_ = self->priv->m_current_lang;
	_tmp3_ = row;
	_tmp4_ = ibus_emojier_ebox_row_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp2_, _tmp5_) != 0) {
		IBusEmojierEBoxRow* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = row;
		_tmp7_ = ibus_emojier_ebox_row_get_id (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->m_current_lang);
		self->priv->m_current_lang = _tmp9_;
		ibus_emojier_reload_emoji_dict (self);
	}
	self->priv->m_current_category_type = IBUS_EMOJIER_CATEGORY_TYPE_EMOJI;
	ibus_emojier_show_category_list (self);
	_g_object_unref0 (row);
}


static void _____lambda31__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	____lambda31_ ((IBusEmojier*) self, _sender, row);
}


static void ibus_emojier_show_category_list (IBusEmojier* self) {
	IBusEmojierEScrolledWindow* _tmp0_ = NULL;
	gchar* language = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	IBusEmojierEPaddedLabel* label = NULL;
	const gchar* _tmp4_ = NULL;
	IBusEmojierEPaddedLabel* _tmp5_ = NULL;
	GtkButton* button = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	IBusEmojierEPaddedLabel* _tmp8_ = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	IBusEmojierEScrolledWindow* _tmp14_ = NULL;
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp15_ = NULL;
	IBusEmojierEScrolledWindow* _tmp16_ = NULL;
	GtkViewport* _tmp17_ = NULL;
	IBusEmojierEListBox* _tmp18_ = NULL;
	GtkViewport* _tmp19_ = NULL;
	IBusEmojierEListBox* _tmp20_ = NULL;
	GtkAdjustment* adjustment = NULL;
	IBusEmojierEScrolledWindow* _tmp21_ = NULL;
	GtkAdjustment* _tmp22_ = NULL;
	GtkAdjustment* _tmp23_ = NULL;
	IBusEmojierEListBox* _tmp24_ = NULL;
	GtkAdjustment* _tmp25_ = NULL;
	IBusEmojierCategoryType _tmp26_ = 0;
	IBusEmojierEScrolledWindow* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	IBusEmojierEListBox* _tmp95_ = NULL;
	IBusEmojierEListBox* _tmp96_ = NULL;
	g_return_if_fail (self != NULL);
	ibus_emojier_remove_all_children (self);
	_tmp0_ = ibus_emojier_escrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_scrolled_window);
	self->priv->m_scrolled_window = _tmp0_;
	ibus_emojier_set_fixed_size (self);
	_tmp1_ = self->priv->m_current_lang;
	_tmp2_ = ibus_get_language_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	language = _tmp3_;
	_tmp4_ = language;
	_tmp5_ = ibus_emojier_epadded_label_new (_tmp4_, GTK_ALIGN_CENTER, IBUS_EMOJIER_TRAVEL_DIRECTION_NONE);
	g_object_ref_sink (_tmp5_);
	label = _tmp5_;
	_tmp6_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp6_);
	button = _tmp6_;
	_tmp7_ = button;
	_tmp8_ = label;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->m_vbox;
	_tmp10_ = button;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = button;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_tmp12_ = button;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "button-press-event", (GCallback) ___lambda25__gtk_widget_button_press_event, self, 0);
	_tmp13_ = self->priv->m_vbox;
	_tmp14_ = self->priv->m_scrolled_window;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp15_);
	viewport = _tmp15_;
	_tmp16_ = self->priv->m_scrolled_window;
	_tmp17_ = viewport;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = ibus_emojier_elist_box_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->m_list_box);
	self->priv->m_list_box = _tmp18_;
	_tmp19_ = viewport;
	_tmp20_ = self->priv->m_list_box;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->m_scrolled_window;
	_tmp22_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) _tmp21_);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	adjustment = _tmp23_;
	_tmp24_ = self->priv->m_list_box;
	_tmp25_ = adjustment;
	gtk_list_box_set_adjustment ((GtkListBox*) _tmp24_, _tmp25_);
	_tmp26_ = self->priv->m_current_category_type;
	if (_tmp26_ == IBUS_EMOJIER_CATEGORY_TYPE_EMOJI) {
		IBusEmojierEListBox* _tmp27_ = NULL;
		guint n = 0U;
		gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		GList* categories = NULL;
		GHashTable* _tmp40_ = NULL;
		GList* _tmp41_ = NULL;
		GList* _tmp42_ = NULL;
		_tmp27_ = self->priv->m_list_box;
		g_signal_connect_object ((GtkListBox*) _tmp27_, "row-activated", (GCallback) ____lambda26__gtk_list_box_row_activated, self, 0);
		n = (guint) 1;
		_tmp28_ = self->priv->m_favorites;
		_tmp28__length1 = self->priv->m_favorites_length1;
		if (_tmp28__length1 > 0) {
			IBusEmojierEBoxRow* row = NULL;
			IBusEmojierEBoxRow* _tmp29_ = NULL;
			IBusEmojierEPaddedLabel* widget = NULL;
			const gchar* _tmp30_ = NULL;
			IBusEmojierEPaddedLabel* _tmp31_ = NULL;
			IBusEmojierEBoxRow* _tmp32_ = NULL;
			IBusEmojierEPaddedLabel* _tmp33_ = NULL;
			IBusEmojierEListBox* _tmp34_ = NULL;
			IBusEmojierEBoxRow* _tmp35_ = NULL;
			guint _tmp36_ = 0U;
			gint _tmp37_ = 0;
			_tmp29_ = ibus_emojier_ebox_row_new ("@favorites", "");
			g_object_ref_sink (_tmp29_);
			row = _tmp29_;
			_tmp30_ = _ ("Favorites");
			_tmp31_ = ibus_emojier_epadded_label_new (_tmp30_, GTK_ALIGN_CENTER, IBUS_EMOJIER_TRAVEL_DIRECTION_NONE);
			g_object_ref_sink (_tmp31_);
			widget = _tmp31_;
			_tmp32_ = row;
			_tmp33_ = widget;
			gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
			_tmp34_ = self->priv->m_list_box;
			_tmp35_ = row;
			gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
			_tmp36_ = n;
			n = _tmp36_ + 1;
			_tmp37_ = self->priv->m_category_active_index;
			if (_tmp36_ == ((guint) _tmp37_)) {
				IBusEmojierEListBox* _tmp38_ = NULL;
				IBusEmojierEBoxRow* _tmp39_ = NULL;
				_tmp38_ = self->priv->m_list_box;
				_tmp39_ = row;
				gtk_list_box_select_row ((GtkListBox*) _tmp38_, (GtkListBoxRow*) _tmp39_);
			}
			_g_object_unref0 (widget);
			_g_object_unref0 (row);
		}
		_tmp40_ = self->priv->m_category_to_emojis_dict;
		_tmp41_ = g_hash_table_get_keys (_tmp40_);
		categories = _tmp41_;
		_tmp42_ = categories;
		{
			GList* category_collection = NULL;
			GList* category_it = NULL;
			category_collection = _tmp42_;
			for (category_it = category_collection; category_it != NULL; category_it = category_it->next) {
				const gchar* category = NULL;
				category = (const gchar*) category_it->data;
				{
					IBusEmojierEBoxRow* row = NULL;
					const gchar* _tmp43_ = NULL;
					IBusEmojierEBoxRow* _tmp44_ = NULL;
					gchar* locale_category = NULL;
					const gchar* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					GString* capital_category = NULL;
					GString* _tmp48_ = NULL;
					IBusEmojierEPaddedLabel* widget = NULL;
					GString* _tmp63_ = NULL;
					const gchar* _tmp64_ = NULL;
					IBusEmojierEPaddedLabel* _tmp65_ = NULL;
					IBusEmojierEBoxRow* _tmp66_ = NULL;
					IBusEmojierEPaddedLabel* _tmp67_ = NULL;
					IBusEmojierEListBox* _tmp68_ = NULL;
					IBusEmojierEBoxRow* _tmp69_ = NULL;
					guint _tmp70_ = 0U;
					gint _tmp71_ = 0;
					_tmp43_ = category;
					_tmp44_ = ibus_emojier_ebox_row_new (_tmp43_, "");
					g_object_ref_sink (_tmp44_);
					row = _tmp44_;
					_tmp45_ = category;
					_tmp46_ = _ (_tmp45_);
					_tmp47_ = g_strdup (_tmp46_);
					locale_category = _tmp47_;
					_tmp48_ = g_string_new ("");
					capital_category = _tmp48_;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp49_ = FALSE;
							_tmp49_ = TRUE;
							while (TRUE) {
								gint _tmp51_ = 0;
								const gchar* _tmp52_ = NULL;
								gint _tmp53_ = 0;
								gunichar ch = 0U;
								const gchar* _tmp54_ = NULL;
								gint _tmp55_ = 0;
								gunichar _tmp56_ = 0U;
								gint _tmp57_ = 0;
								if (!_tmp49_) {
									gint _tmp50_ = 0;
									_tmp50_ = i;
									i = _tmp50_ + 1;
								}
								_tmp49_ = FALSE;
								_tmp51_ = i;
								_tmp52_ = locale_category;
								_tmp53_ = g_utf8_strlen (_tmp52_, (gssize) -1);
								if (!(_tmp51_ < _tmp53_)) {
									break;
								}
								_tmp54_ = locale_category;
								_tmp55_ = i;
								_tmp56_ = string_get_char (_tmp54_, (glong) _tmp55_);
								ch = _tmp56_;
								_tmp57_ = i;
								if (_tmp57_ == 0) {
									GString* _tmp58_ = NULL;
									gunichar _tmp59_ = 0U;
									gunichar _tmp60_ = 0U;
									_tmp58_ = capital_category;
									_tmp59_ = ch;
									_tmp60_ = g_unichar_toupper (_tmp59_);
									g_string_append_unichar (_tmp58_, _tmp60_);
								} else {
									GString* _tmp61_ = NULL;
									gunichar _tmp62_ = 0U;
									_tmp61_ = capital_category;
									_tmp62_ = ch;
									g_string_append_unichar (_tmp61_, _tmp62_);
								}
							}
						}
					}
					_tmp63_ = capital_category;
					_tmp64_ = _tmp63_->str;
					_tmp65_ = ibus_emojier_epadded_label_new (_tmp64_, GTK_ALIGN_CENTER, IBUS_EMOJIER_TRAVEL_DIRECTION_NONE);
					g_object_ref_sink (_tmp65_);
					widget = _tmp65_;
					_tmp66_ = row;
					_tmp67_ = widget;
					gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
					_tmp68_ = self->priv->m_list_box;
					_tmp69_ = row;
					gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
					_tmp70_ = n;
					n = _tmp70_ + 1;
					_tmp71_ = self->priv->m_category_active_index;
					if (_tmp70_ == ((guint) _tmp71_)) {
						IBusEmojierEListBox* _tmp72_ = NULL;
						IBusEmojierEBoxRow* _tmp73_ = NULL;
						_tmp72_ = self->priv->m_list_box;
						_tmp73_ = row;
						gtk_list_box_select_row ((GtkListBox*) _tmp72_, (GtkListBoxRow*) _tmp73_);
					}
					_g_object_unref0 (widget);
					_g_string_free0 (capital_category);
					_g_free0 (locale_category);
					_g_object_unref0 (row);
				}
			}
		}
		_g_list_free0 (categories);
	} else {
		IBusEmojierCategoryType _tmp74_ = 0;
		_tmp74_ = self->priv->m_current_category_type;
		if (_tmp74_ == IBUS_EMOJIER_CATEGORY_TYPE_LANG) {
			IBusEmojierEListBox* _tmp75_ = NULL;
			guint n = 0U;
			GSList* _tmp76_ = NULL;
			_tmp75_ = self->priv->m_list_box;
			g_signal_connect_object ((GtkListBox*) _tmp75_, "row-activated", (GCallback) _____lambda31__gtk_list_box_row_activated, self, 0);
			n = (guint) 1;
			_tmp76_ = self->priv->m_lang_list;
			{
				GSList* id_collection = NULL;
				GSList* id_it = NULL;
				id_collection = _tmp76_;
				for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
					const gchar* id = NULL;
					id = (const gchar*) id_it->data;
					{
						gchar* selected_language = NULL;
						const gchar* _tmp77_ = NULL;
						const gchar* _tmp78_ = NULL;
						gchar* _tmp79_ = NULL;
						IBusEmojierEBoxRow* row = NULL;
						const gchar* _tmp80_ = NULL;
						IBusEmojierEBoxRow* _tmp81_ = NULL;
						IBusEmojierEPaddedLabel* widget = NULL;
						const gchar* _tmp82_ = NULL;
						IBusEmojierEPaddedLabel* _tmp83_ = NULL;
						IBusEmojierEBoxRow* _tmp84_ = NULL;
						IBusEmojierEPaddedLabel* _tmp85_ = NULL;
						IBusEmojierEListBox* _tmp86_ = NULL;
						IBusEmojierEBoxRow* _tmp87_ = NULL;
						guint _tmp88_ = 0U;
						gint _tmp89_ = 0;
						_tmp77_ = id;
						_tmp78_ = ibus_get_language_name (_tmp77_);
						_tmp79_ = g_strdup (_tmp78_);
						selected_language = _tmp79_;
						_tmp80_ = id;
						_tmp81_ = ibus_emojier_ebox_row_new ("", _tmp80_);
						g_object_ref_sink (_tmp81_);
						row = _tmp81_;
						_tmp82_ = selected_language;
						_tmp83_ = ibus_emojier_epadded_label_new (_tmp82_, GTK_ALIGN_CENTER, IBUS_EMOJIER_TRAVEL_DIRECTION_NONE);
						g_object_ref_sink (_tmp83_);
						widget = _tmp83_;
						_tmp84_ = row;
						_tmp85_ = widget;
						gtk_container_add ((GtkContainer*) _tmp84_, (GtkWidget*) _tmp85_);
						_tmp86_ = self->priv->m_list_box;
						_tmp87_ = row;
						gtk_container_add ((GtkContainer*) _tmp86_, (GtkWidget*) _tmp87_);
						_tmp88_ = n;
						n = _tmp88_ + 1;
						_tmp89_ = self->priv->m_category_active_index;
						if (_tmp88_ == ((guint) _tmp89_)) {
							IBusEmojierEListBox* _tmp90_ = NULL;
							IBusEmojierEBoxRow* _tmp91_ = NULL;
							_tmp90_ = self->priv->m_list_box;
							_tmp91_ = row;
							gtk_list_box_select_row ((GtkListBox*) _tmp90_, (GtkListBoxRow*) _tmp91_);
						}
						_g_object_unref0 (widget);
						_g_object_unref0 (row);
						_g_free0 (selected_language);
					}
				}
			}
		}
	}
	_tmp92_ = self->priv->m_scrolled_window;
	gtk_widget_show_all ((GtkWidget*) _tmp92_);
	_tmp93_ = self->priv->m_category_active_index;
	if (_tmp93_ == 0) {
		IBusEmojierEListBox* _tmp94_ = NULL;
		_tmp94_ = self->priv->m_list_box;
		gtk_list_box_unselect_all ((GtkListBox*) _tmp94_);
	}
	_tmp95_ = self->priv->m_list_box;
	gtk_list_box_invalidate_filter ((GtkListBox*) _tmp95_);
	_tmp96_ = self->priv->m_list_box;
	gtk_list_box_set_selection_mode ((GtkListBox*) _tmp96_, GTK_SELECTION_SINGLE);
	_g_object_unref0 (adjustment);
	_g_object_unref0 (viewport);
	_g_object_unref0 (button);
	_g_object_unref0 (label);
	_g_free0 (language);
}


static void ibus_emojier_show_emoji_for_category (IBusEmojier* self, IBusEmojierEBoxRow* row) {
	IBusEmojierEBoxRow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = row;
	_tmp1_ = ibus_emojier_ebox_row_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "@favorites") == 0) {
		IBusLookupTable* _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp3_ = self->priv->m_lookup_table;
		ibus_lookup_table_clear (_tmp3_);
		_tmp4_ = self->priv->m_favorites;
		_tmp4__length1 = self->priv->m_favorites_length1;
		{
			gchar** favorate_collection = NULL;
			gint favorate_collection_length1 = 0;
			gint _favorate_collection_size_ = 0;
			gint favorate_it = 0;
			favorate_collection = _tmp4_;
			favorate_collection_length1 = _tmp4__length1;
			for (favorate_it = 0; favorate_it < _tmp4__length1; favorate_it = favorate_it + 1) {
				const gchar* favorate = NULL;
				favorate = favorate_collection[favorate_it];
				{
					IBusText* text = NULL;
					const gchar* _tmp5_ = NULL;
					IBusText* _tmp6_ = NULL;
					IBusLookupTable* _tmp7_ = NULL;
					IBusText* _tmp8_ = NULL;
					_tmp5_ = favorate;
					_tmp6_ = ibus_text_new_from_string (_tmp5_);
					g_object_ref_sink (_tmp6_);
					text = _tmp6_;
					_tmp7_ = self->priv->m_lookup_table;
					_tmp8_ = text;
					ibus_lookup_table_append_candidate (_tmp7_, _tmp8_);
					_g_object_unref0 (text);
				}
			}
		}
		_tmp9_ = _ ("Favorites");
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->m_backward);
		self->priv->m_backward = _tmp10_;
	} else {
		GSList* emojis = NULL;
		GHashTable* _tmp11_ = NULL;
		IBusEmojierEBoxRow* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gconstpointer _tmp15_ = NULL;
		IBusLookupTable* _tmp16_ = NULL;
		GSList* _tmp17_ = NULL;
		IBusEmojierEBoxRow* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp11_ = self->priv->m_category_to_emojis_dict;
		_tmp12_ = row;
		_tmp13_ = ibus_emojier_ebox_row_get_text (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_hash_table_lookup (_tmp11_, _tmp14_);
		emojis = (GSList*) _tmp15_;
		_tmp16_ = self->priv->m_lookup_table;
		ibus_lookup_table_clear (_tmp16_);
		_tmp17_ = emojis;
		{
			GSList* emoji_collection = NULL;
			GSList* emoji_it = NULL;
			emoji_collection = _tmp17_;
			for (emoji_it = emoji_collection; emoji_it != NULL; emoji_it = emoji_it->next) {
				const gchar* emoji = NULL;
				emoji = (const gchar*) emoji_it->data;
				{
					IBusText* text = NULL;
					const gchar* _tmp18_ = NULL;
					IBusText* _tmp19_ = NULL;
					IBusLookupTable* _tmp20_ = NULL;
					IBusText* _tmp21_ = NULL;
					_tmp18_ = emoji;
					_tmp19_ = ibus_text_new_from_string (_tmp18_);
					g_object_ref_sink (_tmp19_);
					text = _tmp19_;
					_tmp20_ = self->priv->m_lookup_table;
					_tmp21_ = text;
					ibus_lookup_table_append_candidate (_tmp20_, _tmp21_);
					_g_object_unref0 (text);
				}
			}
		}
		_tmp22_ = row;
		_tmp23_ = ibus_emojier_ebox_row_get_text (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (self->priv->m_backward);
		self->priv->m_backward = _tmp25_;
	}
	ibus_emojier_show_candidate_panel (self);
}


static void ibus_emojier_label_set_active_color (IBusEmojier* self, GtkLabel* label) {
	const gchar* text = NULL;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp2_ = NULL;
	PangoAttribute* pango_attr = NULL;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	GdkRGBA _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	GdkRGBA _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	PangoAttribute* _tmp9_ = NULL;
	PangoAttribute* _tmp10_ = NULL;
	PangoAttribute* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	PangoAttribute* _tmp13_ = NULL;
	GdkRGBA _tmp14_ = {0};
	gdouble _tmp15_ = 0.0;
	GdkRGBA _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	GdkRGBA _tmp18_ = {0};
	gdouble _tmp19_ = 0.0;
	PangoAttribute* _tmp20_ = NULL;
	PangoAttribute* _tmp21_ = NULL;
	PangoAttribute* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	PangoAttribute* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = label;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	text = _tmp1_;
	_tmp2_ = pango_attr_list_new ();
	attrs = _tmp2_;
	_tmp3_ = self->priv->m_selected_fg_color;
	_tmp4_ = _tmp3_.red;
	_tmp5_ = self->priv->m_selected_fg_color;
	_tmp6_ = _tmp5_.green;
	_tmp7_ = self->priv->m_selected_fg_color;
	_tmp8_ = _tmp7_.blue;
	_tmp9_ = pango_attr_foreground_new ((guint16) (_tmp4_ * G_MAXUINT16), (guint16) (_tmp6_ * G_MAXUINT16), (guint16) (_tmp8_ * G_MAXUINT16));
	pango_attr = _tmp9_;
	_tmp10_ = pango_attr;
	_tmp10_->start_index = (guint) 0;
	_tmp11_ = pango_attr;
	_tmp12_ = g_utf8_strlen (text, (gssize) -1);
	_tmp11_->end_index = (guint) _tmp12_;
	_tmp13_ = pango_attr;
	pango_attr = NULL;
	pango_attr_list_insert (attrs, _tmp13_);
	_tmp14_ = self->priv->m_selected_bg_color;
	_tmp15_ = _tmp14_.red;
	_tmp16_ = self->priv->m_selected_bg_color;
	_tmp17_ = _tmp16_.green;
	_tmp18_ = self->priv->m_selected_bg_color;
	_tmp19_ = _tmp18_.blue;
	_tmp20_ = pango_attr_background_new ((guint16) (_tmp15_ * G_MAXUINT16), (guint16) (_tmp17_ * G_MAXUINT16), (guint16) (_tmp19_ * G_MAXUINT16));
	_pango_attribute_destroy0 (pango_attr);
	pango_attr = _tmp20_;
	_tmp21_ = pango_attr;
	_tmp21_->start_index = (guint) 0;
	_tmp22_ = pango_attr;
	_tmp23_ = g_utf8_strlen (text, (gssize) -1);
	_tmp22_->end_index = (guint) _tmp23_;
	_tmp24_ = pango_attr;
	pango_attr = NULL;
	pango_attr_list_insert (attrs, _tmp24_);
	_tmp25_ = label;
	gtk_label_set_attributes (_tmp25_, attrs);
	_pango_attribute_destroy0 (pango_attr);
	_pango_attr_list_unref0 (attrs);
}


static void __lambda29_ (IBusEmojier* self) {
	IBusLookupTable* _tmp0_ = NULL;
	_tmp0_ = self->priv->m_lookup_table;
	ibus_lookup_table_page_down (_tmp0_);
	ibus_emojier_show_candidate_panel (self);
}


static void ___lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda29_ ((IBusEmojier*) self);
}


static void __lambda30_ (IBusEmojier* self) {
	IBusLookupTable* _tmp0_ = NULL;
	_tmp0_ = self->priv->m_lookup_table;
	ibus_lookup_table_page_up (_tmp0_);
	ibus_emojier_show_candidate_panel (self);
}


static void ___lambda30__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda30_ ((IBusEmojier*) self);
}


static void ibus_emojier_show_arrow_buttons (IBusEmojier* self) {
	GtkButton* next_button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkButton* prev_button = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkBox* buttons_hbox = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkLabel* state_label = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkBox* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	next_button = _tmp0_;
	g_signal_connect_object (next_button, "clicked", (GCallback) ___lambda29__gtk_button_clicked, self, 0);
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("go-down", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_button_set_image (next_button, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_button_set_relief (next_button, GTK_RELIEF_NONE);
	_tmp3_ = _ ("Page Down");
	gtk_widget_set_tooltip_text ((GtkWidget*) next_button, _tmp3_);
	_tmp4_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp4_);
	prev_button = _tmp4_;
	g_signal_connect_object (prev_button, "clicked", (GCallback) ___lambda30__gtk_button_clicked, self, 0);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("go-up", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_button_set_image (prev_button, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	gtk_button_set_relief (prev_button, GTK_RELIEF_NONE);
	_tmp7_ = _ ("Page Up");
	gtk_widget_set_tooltip_text ((GtkWidget*) prev_button, _tmp7_);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	buttons_hbox = _tmp8_;
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp9_);
	state_label = _tmp9_;
	gtk_widget_set_size_request ((GtkWidget*) state_label, 10, -1);
	gtk_widget_set_halign ((GtkWidget*) state_label, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) state_label, GTK_ALIGN_CENTER);
	gtk_box_pack_start (buttons_hbox, (GtkWidget*) state_label, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start (buttons_hbox, (GtkWidget*) prev_button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (buttons_hbox, (GtkWidget*) next_button, FALSE, FALSE, (guint) 0);
	_tmp10_ = self->priv->m_vbox;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) buttons_hbox, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) buttons_hbox);
	_g_object_unref0 (state_label);
	_g_object_unref0 (buttons_hbox);
	_g_object_unref0 (prev_button);
	_g_object_unref0 (next_button);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean ibus_emojier_check_unicode_point (IBusEmojier* self, gboolean check_xdigit_only) {
	gboolean result = FALSE;
	GString* buff = NULL;
	GString* _tmp0_ = NULL;
	gunichar code = 0U;
	GString* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gulong _tmp18_ = 0UL;
	gunichar _tmp19_ = 0U;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gunichar _tmp22_ = 0U;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	IBusText* text = NULL;
	const gchar* _tmp25_ = NULL;
	IBusText* _tmp26_ = NULL;
	IBusLookupTable* _tmp27_ = NULL;
	IBusText* _tmp28_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_g_free0 (self->priv->m_unicode_point);
	self->priv->m_unicode_point = NULL;
	_tmp0_ = g_string_new ("");
	buff = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				GString* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gunichar ch = 0U;
				GString* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gunichar _tmp10_ = 0U;
				gunichar _tmp11_ = 0U;
				gunichar _tmp12_ = 0U;
				gboolean _tmp13_ = FALSE;
				GString* _tmp14_ = NULL;
				gunichar _tmp15_ = 0U;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->m_buffer_string;
				_tmp5_ = _tmp4_->str;
				_tmp6_ = g_utf8_strlen (_tmp5_, (gssize) -1);
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->m_buffer_string;
				_tmp8_ = _tmp7_->str;
				_tmp9_ = i;
				_tmp10_ = string_get_char (_tmp8_, (glong) _tmp9_);
				ch = _tmp10_;
				_tmp11_ = ch;
				if (_tmp11_ == ((gunichar) 0)) {
					result = FALSE;
					_g_string_free0 (buff);
					return result;
				}
				_tmp12_ = ch;
				_tmp13_ = g_unichar_isxdigit (_tmp12_);
				if (!_tmp13_) {
					result = FALSE;
					_g_string_free0 (buff);
					return result;
				}
				_tmp14_ = buff;
				_tmp15_ = ch;
				g_string_append_unichar (_tmp14_, _tmp15_);
			}
		}
	}
	_tmp16_ = buff;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = strtoul (_tmp17_, NULL, 16);
	code = (gunichar) _tmp18_;
	_tmp19_ = code;
	_tmp20_ = g_unichar_validate (_tmp19_);
	if (!_tmp20_) {
		result = FALSE;
		_g_string_free0 (buff);
		return result;
	}
	_tmp21_ = check_xdigit_only;
	if (_tmp21_) {
		result = TRUE;
		_g_string_free0 (buff);
		return result;
	}
	_tmp22_ = code;
	_tmp23_ = g_unichar_to_string (_tmp22_);
	_g_free0 (self->priv->m_unicode_point);
	self->priv->m_unicode_point = _tmp23_;
	_tmp24_ = self->priv->m_unicode_point;
	if (_tmp24_ == NULL) {
		result = TRUE;
		_g_string_free0 (buff);
		return result;
	}
	_tmp25_ = self->priv->m_unicode_point;
	_tmp26_ = ibus_text_new_from_string (_tmp25_);
	g_object_ref_sink (_tmp26_);
	text = _tmp26_;
	_tmp27_ = self->priv->m_lookup_table;
	_tmp28_ = text;
	ibus_lookup_table_append_candidate (_tmp27_, _tmp28_);
	result = TRUE;
	_g_object_unref0 (text);
	_g_string_free0 (buff);
	return result;
}


void ibus_emojier_update_cadidate_window (IBusEmojier* self) {
	gchar* annotation = NULL;
	IBusEmojierEEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GSList* emojis = NULL;
	GHashTable* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GSList* _tmp14_ = NULL;
	IBusLookupTable* _tmp16_ = NULL;
	GSList* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	annotation = _tmp2_;
	_tmp3_ = annotation;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ibus_emojier_hide_candidate_panel (self);
		_g_free0 (self->priv->m_backward);
		self->priv->m_backward = NULL;
		_g_free0 (annotation);
		return;
	}
	_tmp6_ = annotation;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->m_emoji_max_seq_len;
	if (_tmp8_ > _tmp9_) {
		ibus_emojier_hide_candidate_panel (self);
		_g_free0 (annotation);
		return;
	}
	ibus_emojier_check_unicode_point (self, FALSE);
	_tmp10_ = self->priv->m_annotation_to_emojis_dict;
	_tmp11_ = annotation;
	_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
	emojis = (GSList*) _tmp12_;
	_tmp14_ = emojis;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_ = NULL;
		_tmp15_ = self->priv->m_unicode_point;
		_tmp13_ = _tmp15_ == NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ibus_emojier_hide_candidate_panel (self);
		_g_free0 (annotation);
		return;
	}
	_tmp16_ = self->priv->m_lookup_table;
	ibus_lookup_table_clear (_tmp16_);
	ibus_emojier_check_unicode_point (self, FALSE);
	_tmp17_ = emojis;
	{
		GSList* emoji_collection = NULL;
		GSList* emoji_it = NULL;
		emoji_collection = _tmp17_;
		for (emoji_it = emoji_collection; emoji_it != NULL; emoji_it = emoji_it->next) {
			const gchar* emoji = NULL;
			emoji = (const gchar*) emoji_it->data;
			{
				IBusText* text = NULL;
				const gchar* _tmp18_ = NULL;
				IBusText* _tmp19_ = NULL;
				IBusLookupTable* _tmp20_ = NULL;
				IBusText* _tmp21_ = NULL;
				_tmp18_ = emoji;
				_tmp19_ = ibus_text_new_from_string (_tmp18_);
				g_object_ref_sink (_tmp19_);
				text = _tmp19_;
				_tmp20_ = self->priv->m_lookup_table;
				_tmp21_ = text;
				ibus_lookup_table_append_candidate (_tmp20_, _tmp21_);
				_g_object_unref0 (text);
			}
		}
	}
	ibus_emojier_show_candidate_panel (self);
	_g_free0 (annotation);
}


static gboolean ___lambda27_ (IBusEmojier* self, GtkWidget* w, GdkEventButton* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	ibus_emojier_hide_candidate_panel (self);
	result = TRUE;
	return result;
}


static gboolean ____lambda27__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ___lambda27_ ((IBusEmojier*) self, _sender, event);
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		IBusEmojier* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static gboolean _____lambda28_ (Block4Data* _data4_, GtkWidget* w, GdkEventButton* e) {
	IBusEmojier* self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GdkEventButton* _tmp3_ = NULL;
	GdkModifierType _tmp4_ = 0;
	self = _data4_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data4_->index;
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = e;
	_tmp4_ = _tmp3_->state;
	g_signal_emit_by_name (self, "candidate-clicked", _tmp0_, _tmp2_, (guint) _tmp4_);
	result = TRUE;
	return result;
}


static gboolean ______lambda28__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _____lambda28_ (self, _sender, event);
	return result;
}


static void _vala_array_add10 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void ibus_emojier_show_candidate_panel (IBusEmojier* self) {
	guint page_size = 0U;
	IBusLookupTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint ncandidates = 0U;
	IBusLookupTable* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint cursor = 0U;
	IBusLookupTable* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint page_start_pos = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint page_end_pos = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	IBusEmojierEGrid* grid = NULL;
	IBusEmojierEGrid* _tmp29_ = NULL;
	gint n = 0;
	gint _tmp81_ = 0;
	g_return_if_fail (self != NULL);
	ibus_emojier_remove_all_children (self);
	ibus_emojier_set_fixed_size (self);
	_tmp0_ = self->priv->m_lookup_table;
	_tmp1_ = ibus_lookup_table_get_page_size (_tmp0_);
	page_size = _tmp1_;
	_tmp2_ = self->priv->m_lookup_table;
	_tmp3_ = ibus_lookup_table_get_number_of_candidates (_tmp2_);
	ncandidates = _tmp3_;
	_tmp4_ = self->priv->m_lookup_table;
	_tmp5_ = ibus_lookup_table_get_cursor_pos (_tmp4_);
	cursor = _tmp5_;
	_tmp6_ = cursor;
	_tmp7_ = page_size;
	_tmp8_ = page_size;
	page_start_pos = (_tmp6_ / _tmp7_) * _tmp8_;
	_tmp9_ = page_start_pos;
	_tmp10_ = page_size;
	_tmp11_ = ncandidates;
	_tmp12_ = MIN (_tmp9_ + _tmp10_, _tmp11_);
	page_end_pos = _tmp12_;
	_tmp13_ = self->priv->m_backward;
	if (_tmp13_ != NULL) {
		gchar* backward_desc = NULL;
		const gchar* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		guint _tmp18_ = 0U;
		gchar* _tmp19_ = NULL;
		IBusEmojierEPaddedLabel* label = NULL;
		const gchar* _tmp20_ = NULL;
		IBusEmojierEPaddedLabel* _tmp21_ = NULL;
		GtkButton* button = NULL;
		GtkButton* _tmp22_ = NULL;
		GtkButton* _tmp23_ = NULL;
		IBusEmojierEPaddedLabel* _tmp24_ = NULL;
		GtkBox* _tmp25_ = NULL;
		GtkButton* _tmp26_ = NULL;
		GtkButton* _tmp27_ = NULL;
		GtkButton* _tmp28_ = NULL;
		_tmp14_ = self->priv->m_backward;
		_tmp15_ = cursor;
		_tmp16_ = page_size;
		_tmp17_ = ncandidates;
		_tmp18_ = page_size;
		_tmp19_ = g_strdup_printf ("%s (%u / %u)", _tmp14_, (_tmp15_ / _tmp16_) + 1, (_tmp17_ / _tmp18_) + 1);
		backward_desc = _tmp19_;
		_tmp20_ = backward_desc;
		_tmp21_ = ibus_emojier_epadded_label_new (_tmp20_, GTK_ALIGN_CENTER, IBUS_EMOJIER_TRAVEL_DIRECTION_BACKWARD);
		g_object_ref_sink (_tmp21_);
		label = _tmp21_;
		_tmp22_ = (GtkButton*) gtk_button_new ();
		g_object_ref_sink (_tmp22_);
		button = _tmp22_;
		_tmp23_ = button;
		_tmp24_ = label;
		gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
		_tmp25_ = self->priv->m_vbox;
		_tmp26_ = button;
		gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
		_tmp27_ = button;
		gtk_widget_show_all ((GtkWidget*) _tmp27_);
		_tmp28_ = button;
		g_signal_connect_object ((GtkWidget*) _tmp28_, "button-press-event", (GCallback) ____lambda27__gtk_widget_button_press_event, self, 0);
		_g_object_unref0 (button);
		_g_object_unref0 (label);
		_g_free0 (backward_desc);
	}
	_tmp29_ = ibus_emojier_egrid_new ();
	g_object_ref_sink (_tmp29_);
	grid = _tmp29_;
	n = 0;
	{
		guint i = 0U;
		guint _tmp30_ = 0U;
		_tmp30_ = page_start_pos;
		i = _tmp30_;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				Block4Data* _data4_;
				guint _tmp33_ = 0U;
				guint _tmp34_ = 0U;
				IBusText* candidate = NULL;
				IBusLookupTable* _tmp35_ = NULL;
				guint _tmp36_ = 0U;
				IBusText* _tmp37_ = NULL;
				IBusText* _tmp38_ = NULL;
				GtkLabel* label = NULL;
				IBusText* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				GtkLabel* _tmp41_ = NULL;
				gchar* emoji_font = NULL;
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				IBusText* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				gchar* markup = NULL;
				const gchar* _tmp57_ = NULL;
				IBusText* _tmp58_ = NULL;
				const gchar* _tmp59_ = NULL;
				gchar* _tmp60_ = NULL;
				GtkLabel* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				GtkLabel* _tmp63_ = NULL;
				GtkLabel* _tmp64_ = NULL;
				guint _tmp65_ = 0U;
				guint _tmp66_ = 0U;
				GtkEventBox* candidate_ebox = NULL;
				GtkEventBox* _tmp68_ = NULL;
				GtkEventBox* _tmp69_ = NULL;
				GtkLabel* _tmp70_ = NULL;
				guint _tmp71_ = 0U;
				GtkEventBox* _tmp72_ = NULL;
				IBusEmojierEGrid* _tmp73_ = NULL;
				GtkEventBox* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				GtkLabel** _tmp78_ = NULL;
				gint _tmp78__length1 = 0;
				GtkLabel* _tmp79_ = NULL;
				GtkLabel* _tmp80_ = NULL;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->self = g_object_ref (self);
				if (!_tmp31_) {
					guint _tmp32_ = 0U;
					_tmp32_ = i;
					i = _tmp32_ + 1;
				}
				_tmp31_ = FALSE;
				_tmp33_ = i;
				_tmp34_ = page_end_pos;
				if (!(_tmp33_ < _tmp34_)) {
					block4_data_unref (_data4_);
					_data4_ = NULL;
					break;
				}
				_tmp35_ = self->priv->m_lookup_table;
				_tmp36_ = i;
				_tmp37_ = ibus_lookup_table_get_candidate (_tmp35_, _tmp36_);
				_tmp38_ = _g_object_ref0 (_tmp37_);
				candidate = _tmp38_;
				_tmp39_ = candidate;
				_tmp40_ = _tmp39_->text;
				_tmp41_ = (GtkLabel*) gtk_label_new (_tmp40_);
				g_object_ref_sink (_tmp41_);
				label = _tmp41_;
				_tmp42_ = self->priv->m_emoji_font;
				_tmp43_ = g_strdup (_tmp42_);
				emoji_font = _tmp43_;
				_tmp44_ = candidate;
				_tmp45_ = _tmp44_->text;
				_tmp46_ = g_utf8_strlen (_tmp45_, (gssize) -1);
				if (_tmp46_ > 2) {
					PangoFontDescription* font_desc = NULL;
					const gchar* _tmp47_ = NULL;
					PangoFontDescription* _tmp48_ = NULL;
					gchar* font_family = NULL;
					PangoFontDescription* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					gint font_size = 0;
					PangoFontDescription* _tmp52_ = NULL;
					gint _tmp53_ = 0;
					const gchar* _tmp54_ = NULL;
					gint _tmp55_ = 0;
					gchar* _tmp56_ = NULL;
					_tmp47_ = emoji_font;
					_tmp48_ = pango_font_description_from_string (_tmp47_);
					font_desc = _tmp48_;
					_tmp49_ = font_desc;
					_tmp50_ = pango_font_description_get_family (_tmp49_);
					_tmp51_ = g_strdup (_tmp50_);
					font_family = _tmp51_;
					_tmp52_ = font_desc;
					_tmp53_ = pango_font_description_get_size (_tmp52_);
					font_size = _tmp53_ / PANGO_SCALE;
					_tmp54_ = font_family;
					_tmp55_ = font_size;
					_tmp56_ = g_strdup_printf ("%s %d", _tmp54_, _tmp55_ - 2);
					_g_free0 (emoji_font);
					emoji_font = _tmp56_;
					_g_free0 (font_family);
					__vala_PangoFontDescription_free0 (font_desc);
				}
				_tmp57_ = emoji_font;
				_tmp58_ = candidate;
				_tmp59_ = ibus_text_get_text (_tmp58_);
				_tmp60_ = g_strdup_printf ("<span font=\"%s\">%s</span>", _tmp57_, _tmp59_);
				markup = _tmp60_;
				_tmp61_ = label;
				_tmp62_ = markup;
				gtk_label_set_markup (_tmp61_, _tmp62_);
				_tmp63_ = label;
				gtk_widget_set_halign ((GtkWidget*) _tmp63_, GTK_ALIGN_FILL);
				_tmp64_ = label;
				gtk_widget_set_valign ((GtkWidget*) _tmp64_, GTK_ALIGN_FILL);
				_tmp65_ = i;
				_tmp66_ = cursor;
				if (_tmp65_ == _tmp66_) {
					GtkLabel* _tmp67_ = NULL;
					_tmp67_ = label;
					ibus_emojier_label_set_active_color (self, _tmp67_);
				}
				_tmp68_ = (GtkEventBox*) gtk_event_box_new ();
				g_object_ref_sink (_tmp68_);
				candidate_ebox = _tmp68_;
				_tmp69_ = candidate_ebox;
				_tmp70_ = label;
				gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp70_);
				_tmp71_ = i;
				_data4_->index = _tmp71_;
				_tmp72_ = candidate_ebox;
				g_signal_connect_data ((GtkWidget*) _tmp72_, "button-press-event", (GCallback) ______lambda28__gtk_widget_button_press_event, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
				_tmp73_ = grid;
				_tmp74_ = candidate_ebox;
				_tmp75_ = n;
				_tmp76_ = n;
				gtk_grid_attach ((GtkGrid*) _tmp73_, (GtkWidget*) _tmp74_, _tmp75_ % ((gint) IBUS_EMOJIER_EMOJI_GRID_PAGE), _tmp76_ / ((gint) IBUS_EMOJIER_EMOJI_GRID_PAGE), 1, 1);
				_tmp77_ = n;
				n = _tmp77_ + 1;
				_tmp78_ = self->priv->m_candidates;
				_tmp78__length1 = self->priv->m_candidates_length1;
				_tmp79_ = label;
				_tmp80_ = _g_object_ref0 (_tmp79_);
				_vala_array_add10 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp80_);
				_g_object_unref0 (candidate_ebox);
				_g_free0 (markup);
				_g_free0 (emoji_font);
				_g_object_unref0 (label);
				_g_object_unref0 (candidate);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	_tmp81_ = n;
	if (_tmp81_ > 0) {
		GtkBox* _tmp82_ = NULL;
		IBusEmojierEGrid* _tmp83_ = NULL;
		IBusEmojierEGrid* _tmp84_ = NULL;
		IBusText* candidate = NULL;
		IBusLookupTable* _tmp85_ = NULL;
		guint _tmp86_ = 0U;
		IBusText* _tmp87_ = NULL;
		IBusText* _tmp88_ = NULL;
		gboolean _tmp89_ = FALSE;
		guint _tmp90_ = 0U;
		IBusEmojiData* data = NULL;
		GHashTable* _tmp104_ = NULL;
		IBusText* _tmp105_ = NULL;
		const gchar* _tmp106_ = NULL;
		gconstpointer _tmp107_ = NULL;
		const gchar* description = NULL;
		IBusEmojiData* _tmp108_ = NULL;
		const gchar* _tmp109_ = NULL;
		const gchar* _tmp110_ = NULL;
		GSList* annotations = NULL;
		IBusEmojiData* _tmp120_ = NULL;
		GSList* _tmp121_ = NULL;
		GString* buff = NULL;
		GString* _tmp122_ = NULL;
		gint i = 0;
		GSList* _tmp123_ = NULL;
		GString* _tmp140_ = NULL;
		const gchar* _tmp141_ = NULL;
		self->priv->m_candidate_panel_is_visible = TRUE;
		ibus_emojier_show_arrow_buttons (self);
		_tmp82_ = self->priv->m_vbox;
		_tmp83_ = grid;
		gtk_container_add ((GtkContainer*) _tmp82_, (GtkWidget*) _tmp83_);
		_tmp84_ = grid;
		gtk_widget_show_all ((GtkWidget*) _tmp84_);
		_tmp85_ = self->priv->m_lookup_table;
		_tmp86_ = cursor;
		_tmp87_ = ibus_lookup_table_get_candidate (_tmp85_, _tmp86_);
		_tmp88_ = _g_object_ref0 (_tmp87_);
		candidate = _tmp88_;
		_tmp90_ = cursor;
		if (_tmp90_ == ((guint) 0)) {
			IBusText* _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			const gchar* _tmp93_ = NULL;
			_tmp91_ = candidate;
			_tmp92_ = _tmp91_->text;
			_tmp93_ = self->priv->m_unicode_point;
			_tmp89_ = g_strcmp0 (_tmp92_, _tmp93_) == 0;
		} else {
			_tmp89_ = FALSE;
		}
		if (_tmp89_) {
			IBusEmojierEPaddedLabel* widget = NULL;
			const gchar* _tmp94_ = NULL;
			const gchar* _tmp95_ = NULL;
			gunichar _tmp96_ = 0U;
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_ = NULL;
			IBusEmojierEPaddedLabel* _tmp99_ = NULL;
			IBusEmojierEPaddedLabel* _tmp100_ = NULL;
			GtkBox* _tmp101_ = NULL;
			IBusEmojierEPaddedLabel* _tmp102_ = NULL;
			IBusEmojierEPaddedLabel* _tmp103_ = NULL;
			_tmp94_ = _ ("Description: Unicode point U+%04X");
			_tmp95_ = self->priv->m_unicode_point;
			_tmp96_ = string_get_char (_tmp95_, (glong) 0);
			_tmp97_ = g_strdup_printf (_tmp94_, _tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = ibus_emojier_epadded_label_new (_tmp98_, GTK_ALIGN_START, IBUS_EMOJIER_TRAVEL_DIRECTION_NONE);
			g_object_ref_sink (_tmp99_);
			_tmp100_ = _tmp99_;
			_g_free0 (_tmp98_);
			widget = _tmp100_;
			_tmp101_ = self->priv->m_vbox;
			_tmp102_ = widget;
			gtk_container_add ((GtkContainer*) _tmp101_, (GtkWidget*) _tmp102_);
			_tmp103_ = widget;
			gtk_widget_show_all ((GtkWidget*) _tmp103_);
			_g_object_unref0 (widget);
			_g_object_unref0 (candidate);
			_g_object_unref0 (grid);
			return;
		}
		_tmp104_ = self->priv->m_emoji_to_data_dict;
		_tmp105_ = candidate;
		_tmp106_ = _tmp105_->text;
		_tmp107_ = g_hash_table_lookup (_tmp104_, _tmp106_);
		data = (IBusEmojiData*) _tmp107_;
		_tmp108_ = data;
		_tmp109_ = ibus_emoji_data_get_description (_tmp108_);
		description = _tmp109_;
		_tmp110_ = description;
		if (g_strcmp0 (_tmp110_, "") != 0) {
			IBusEmojierEPaddedLabel* widget = NULL;
			const gchar* _tmp111_ = NULL;
			const gchar* _tmp112_ = NULL;
			gchar* _tmp113_ = NULL;
			gchar* _tmp114_ = NULL;
			IBusEmojierEPaddedLabel* _tmp115_ = NULL;
			IBusEmojierEPaddedLabel* _tmp116_ = NULL;
			GtkBox* _tmp117_ = NULL;
			IBusEmojierEPaddedLabel* _tmp118_ = NULL;
			IBusEmojierEPaddedLabel* _tmp119_ = NULL;
			_tmp111_ = _ ("Description: %s");
			_tmp112_ = description;
			_tmp113_ = g_strdup_printf (_tmp111_, _tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = ibus_emojier_epadded_label_new (_tmp114_, GTK_ALIGN_START, IBUS_EMOJIER_TRAVEL_DIRECTION_NONE);
			g_object_ref_sink (_tmp115_);
			_tmp116_ = _tmp115_;
			_g_free0 (_tmp114_);
			widget = _tmp116_;
			_tmp117_ = self->priv->m_vbox;
			_tmp118_ = widget;
			gtk_container_add ((GtkContainer*) _tmp117_, (GtkWidget*) _tmp118_);
			_tmp119_ = widget;
			gtk_widget_show_all ((GtkWidget*) _tmp119_);
			_g_object_unref0 (widget);
		}
		_tmp120_ = data;
		_tmp121_ = ibus_emoji_data_get_annotations (_tmp120_);
		annotations = _tmp121_;
		_tmp122_ = g_string_new ("");
		buff = _tmp122_;
		i = 0;
		_tmp123_ = annotations;
		{
			GSList* annotation_collection = NULL;
			GSList* annotation_it = NULL;
			annotation_collection = _tmp123_;
			for (annotation_it = annotation_collection; annotation_it != NULL; annotation_it = annotation_it->next) {
				const gchar* annotation = NULL;
				annotation = (const gchar*) annotation_it->data;
				{
					gint _tmp124_ = 0;
					GString* _tmp130_ = NULL;
					const gchar* _tmp131_ = NULL;
					gint _tmp132_ = 0;
					_tmp124_ = i;
					i = _tmp124_ + 1;
					if (_tmp124_ == 0) {
						GString* _tmp125_ = NULL;
						const gchar* _tmp126_ = NULL;
						const gchar* _tmp127_ = NULL;
						_tmp125_ = buff;
						_tmp126_ = _ ("Annotations: %s");
						_tmp127_ = annotation;
						g_string_append_printf (_tmp125_, _tmp126_, _tmp127_);
					} else {
						GString* _tmp128_ = NULL;
						const gchar* _tmp129_ = NULL;
						_tmp128_ = buff;
						_tmp129_ = annotation;
						g_string_append_printf (_tmp128_, " | %s", _tmp129_);
					}
					_tmp130_ = buff;
					_tmp131_ = _tmp130_->str;
					_tmp132_ = g_utf8_strlen (_tmp131_, (gssize) -1);
					if (_tmp132_ > 30) {
						IBusEmojierEPaddedLabel* widget = NULL;
						GString* _tmp133_ = NULL;
						const gchar* _tmp134_ = NULL;
						IBusEmojierEPaddedLabel* _tmp135_ = NULL;
						GtkBox* _tmp136_ = NULL;
						IBusEmojierEPaddedLabel* _tmp137_ = NULL;
						IBusEmojierEPaddedLabel* _tmp138_ = NULL;
						GString* _tmp139_ = NULL;
						_tmp133_ = buff;
						_tmp134_ = _tmp133_->str;
						_tmp135_ = ibus_emojier_epadded_label_new (_tmp134_, GTK_ALIGN_START, IBUS_EMOJIER_TRAVEL_DIRECTION_NONE);
						g_object_ref_sink (_tmp135_);
						widget = _tmp135_;
						_tmp136_ = self->priv->m_vbox;
						_tmp137_ = widget;
						gtk_container_add ((GtkContainer*) _tmp136_, (GtkWidget*) _tmp137_);
						_tmp138_ = widget;
						gtk_widget_show_all ((GtkWidget*) _tmp138_);
						_tmp139_ = buff;
						g_string_erase (_tmp139_, (gssize) 0, (gssize) -1);
						_g_object_unref0 (widget);
					}
				}
			}
		}
		_tmp140_ = buff;
		_tmp141_ = _tmp140_->str;
		if (g_strcmp0 (_tmp141_, "") != 0) {
			IBusEmojierEPaddedLabel* widget = NULL;
			GString* _tmp142_ = NULL;
			const gchar* _tmp143_ = NULL;
			IBusEmojierEPaddedLabel* _tmp144_ = NULL;
			GtkBox* _tmp145_ = NULL;
			IBusEmojierEPaddedLabel* _tmp146_ = NULL;
			IBusEmojierEPaddedLabel* _tmp147_ = NULL;
			_tmp142_ = buff;
			_tmp143_ = _tmp142_->str;
			_tmp144_ = ibus_emojier_epadded_label_new (_tmp143_, GTK_ALIGN_START, IBUS_EMOJIER_TRAVEL_DIRECTION_NONE);
			g_object_ref_sink (_tmp144_);
			widget = _tmp144_;
			_tmp145_ = self->priv->m_vbox;
			_tmp146_ = widget;
			gtk_container_add ((GtkContainer*) _tmp145_, (GtkWidget*) _tmp146_);
			_tmp147_ = widget;
			gtk_widget_show_all ((GtkWidget*) _tmp147_);
			_g_object_unref0 (widget);
		}
		_g_string_free0 (buff);
		_g_object_unref0 (candidate);
	}
	_g_object_unref0 (grid);
}


static void ibus_emojier_hide_candidate_panel (IBusEmojier* self) {
	GMainLoop* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->m_candidate_panel_is_visible = FALSE;
	_tmp0_ = self->priv->m_loop;
	_tmp1_ = g_main_loop_is_running (_tmp0_);
	if (_tmp1_) {
		ibus_emojier_show_category_list (self);
	}
}


static gboolean ibus_emojier_if_in_range_of_lookup (IBusEmojier* self, guint keyval) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* backup_annotation = NULL;
	GString* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gunichar ch = 0U;
	guint _tmp4_ = 0U;
	gunichar _tmp5_ = 0U;
	GString* _tmp6_ = NULL;
	gunichar _tmp7_ = 0U;
	gboolean _tmp8_ = FALSE;
	GString* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	guint _tmp14_ = 0U;
	guint _tmp16_ = 0U;
	guint index = 0U;
	guint _tmp17_ = 0U;
	guint candidates = 0U;
	IBusLookupTable* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint cursor_pos = 0U;
	IBusLookupTable* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	guint page_size = 0U;
	IBusLookupTable* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	guint _tmp29_ = 0U;
	guint _tmp30_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_candidate_panel_is_visible;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->m_buffer_string;
	_tmp2_ = _tmp1_->str;
	_tmp3_ = g_strdup (_tmp2_);
	backup_annotation = _tmp3_;
	_tmp4_ = keyval;
	_tmp5_ = ibus_keyval_to_unicode (_tmp4_);
	ch = _tmp5_;
	_tmp6_ = self->priv->m_buffer_string;
	_tmp7_ = ch;
	g_string_append_unichar (_tmp6_, _tmp7_);
	_tmp8_ = ibus_emojier_check_unicode_point (self, TRUE);
	if (_tmp8_) {
		GString* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = self->priv->m_buffer_string;
		_tmp10_ = backup_annotation;
		g_string_assign (_tmp9_, _tmp10_);
		result = FALSE;
		_g_free0 (backup_annotation);
		return result;
	}
	_tmp11_ = self->priv->m_buffer_string;
	_tmp12_ = backup_annotation;
	g_string_assign (_tmp11_, _tmp12_);
	_tmp14_ = keyval;
	if (_tmp14_ < ((guint) GDK_KEY_0)) {
		_tmp13_ = TRUE;
	} else {
		guint _tmp15_ = 0U;
		_tmp15_ = keyval;
		_tmp13_ = _tmp15_ > ((guint) GDK_KEY_9);
	}
	if (_tmp13_) {
		result = FALSE;
		_g_free0 (backup_annotation);
		return result;
	}
	_tmp16_ = keyval;
	if (_tmp16_ == ((guint) GDK_KEY_0)) {
		keyval = (guint) (GDK_KEY_9 + 1);
	}
	_tmp17_ = keyval;
	index = (_tmp17_ - GDK_KEY_1) + 1;
	_tmp18_ = self->priv->m_lookup_table;
	_tmp19_ = ibus_lookup_table_get_number_of_candidates (_tmp18_);
	candidates = _tmp19_;
	_tmp20_ = self->priv->m_lookup_table;
	_tmp21_ = ibus_lookup_table_get_cursor_pos (_tmp20_);
	cursor_pos = _tmp21_;
	_tmp22_ = self->priv->m_lookup_table;
	_tmp23_ = ibus_lookup_table_get_page_size (_tmp22_);
	page_size = _tmp23_;
	_tmp24_ = index;
	_tmp25_ = candidates;
	_tmp26_ = cursor_pos;
	_tmp27_ = page_size;
	_tmp28_ = page_size;
	_tmp29_ = page_size;
	_tmp30_ = MIN (_tmp25_ - ((_tmp26_ / _tmp27_) * _tmp28_), _tmp29_);
	if (_tmp24_ > _tmp30_) {
		result = FALSE;
		_g_free0 (backup_annotation);
		return result;
	}
	result = TRUE;
	_g_free0 (backup_annotation);
	return result;
}


static void ibus_emojier_set_number_on_lookup (IBusEmojier* self, guint keyval) {
	guint _tmp0_ = 0U;
	guint index = 0U;
	guint _tmp1_ = 0U;
	guint cursor_pos = 0U;
	IBusLookupTable* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint cursor_in_page = 0U;
	IBusLookupTable* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint real_index = 0U;
	IBusLookupTable* _tmp6_ = NULL;
	IBusText* text = NULL;
	IBusLookupTable* _tmp7_ = NULL;
	IBusText* _tmp8_ = NULL;
	IBusText* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = keyval;
	if (_tmp0_ == ((guint) GDK_KEY_0)) {
		keyval = (guint) (GDK_KEY_9 + 1);
	}
	_tmp1_ = keyval;
	index = _tmp1_ - GDK_KEY_1;
	_tmp2_ = self->priv->m_lookup_table;
	_tmp3_ = ibus_lookup_table_get_cursor_pos (_tmp2_);
	cursor_pos = _tmp3_;
	_tmp4_ = self->priv->m_lookup_table;
	_tmp5_ = ibus_lookup_table_get_cursor_in_page (_tmp4_);
	cursor_in_page = _tmp5_;
	real_index = (cursor_pos - cursor_in_page) + index;
	_tmp6_ = self->priv->m_lookup_table;
	ibus_lookup_table_set_cursor_pos (_tmp6_, real_index);
	_tmp7_ = self->priv->m_lookup_table;
	_tmp8_ = ibus_lookup_table_get_candidate (_tmp7_, real_index);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	text = _tmp9_;
	_tmp10_ = text->text;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->m_result);
	self->priv->m_result = _tmp11_;
	_g_object_unref0 (text);
}


static void ibus_emojier_candidate_panel_cursor_down (IBusEmojier* self) {
	guint ncandidates = 0U;
	IBusLookupTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint cursor = 0U;
	IBusLookupTable* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_lookup_table;
	_tmp1_ = ibus_lookup_table_get_number_of_candidates (_tmp0_);
	ncandidates = _tmp1_;
	_tmp2_ = self->priv->m_lookup_table;
	_tmp3_ = ibus_lookup_table_get_cursor_pos (_tmp2_);
	cursor = _tmp3_;
	_tmp4_ = cursor;
	_tmp5_ = ncandidates;
	if ((_tmp4_ + IBUS_EMOJIER_EMOJI_GRID_PAGE) < _tmp5_) {
		IBusLookupTable* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		_tmp6_ = self->priv->m_lookup_table;
		_tmp7_ = cursor;
		ibus_lookup_table_set_cursor_pos (_tmp6_, _tmp7_ + IBUS_EMOJIER_EMOJI_GRID_PAGE);
	} else {
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		_tmp8_ = cursor;
		_tmp9_ = ncandidates;
		if ((_tmp8_ % IBUS_EMOJIER_EMOJI_GRID_PAGE) < _tmp9_) {
			IBusLookupTable* _tmp10_ = NULL;
			guint _tmp11_ = 0U;
			_tmp10_ = self->priv->m_lookup_table;
			_tmp11_ = cursor;
			ibus_lookup_table_set_cursor_pos (_tmp10_, _tmp11_ % IBUS_EMOJIER_EMOJI_GRID_PAGE);
		} else {
			IBusLookupTable* _tmp12_ = NULL;
			_tmp12_ = self->priv->m_lookup_table;
			ibus_lookup_table_set_cursor_pos (_tmp12_, (guint) 0);
		}
	}
	ibus_emojier_show_candidate_panel (self);
}


static void ibus_emojier_candidate_panel_cursor_up (IBusEmojier* self) {
	gint ncandidates = 0;
	IBusLookupTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gint cursor = 0;
	IBusLookupTable* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gint highest_pos = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_lookup_table;
	_tmp1_ = ibus_lookup_table_get_number_of_candidates (_tmp0_);
	ncandidates = (gint) _tmp1_;
	_tmp2_ = self->priv->m_lookup_table;
	_tmp3_ = ibus_lookup_table_get_cursor_pos (_tmp2_);
	cursor = (gint) _tmp3_;
	_tmp4_ = ncandidates;
	_tmp5_ = cursor;
	highest_pos = ((_tmp4_ / ((gint) IBUS_EMOJIER_EMOJI_GRID_PAGE)) * ((gint) IBUS_EMOJIER_EMOJI_GRID_PAGE)) + (_tmp5_ % ((gint) IBUS_EMOJIER_EMOJI_GRID_PAGE));
	_tmp6_ = cursor;
	if ((_tmp6_ - ((gint) IBUS_EMOJIER_EMOJI_GRID_PAGE)) >= 0) {
		IBusLookupTable* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp7_ = self->priv->m_lookup_table;
		_tmp8_ = cursor;
		ibus_lookup_table_set_cursor_pos (_tmp7_, (guint) (_tmp8_ - ((gint) IBUS_EMOJIER_EMOJI_GRID_PAGE)));
	} else {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp9_ = highest_pos;
		_tmp10_ = ncandidates;
		if (_tmp9_ < _tmp10_) {
			IBusLookupTable* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp11_ = self->priv->m_lookup_table;
			_tmp12_ = highest_pos;
			ibus_lookup_table_set_cursor_pos (_tmp11_, (guint) _tmp12_);
		} else {
			IBusLookupTable* _tmp13_ = NULL;
			_tmp13_ = self->priv->m_lookup_table;
			ibus_lookup_table_set_cursor_pos (_tmp13_, (guint) 0);
		}
	}
	ibus_emojier_show_candidate_panel (self);
}


static void ibus_emojier_category_list_cursor_move (IBusEmojier* self, guint keyval) {
	GList* list = NULL;
	IBusEmojierEListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkAdjustment* adjustment = NULL;
	IBusEmojierEListBox* _tmp12_ = NULL;
	GtkAdjustment* _tmp13_ = NULL;
	GtkAdjustment* _tmp14_ = NULL;
	IBusEmojierEScrolledWindow* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_list_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	list = _tmp1_;
	_tmp2_ = keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Down)) {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GList* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		_tmp3_ = self->priv->m_category_active_index;
		self->priv->m_category_active_index = _tmp3_ + 1;
		_tmp4_ = self->priv->m_category_active_index;
		_tmp5_ = list;
		_tmp6_ = g_list_length (_tmp5_);
		self->priv->m_category_active_index = _tmp4_ % (((gint) _tmp6_) + 1);
	} else {
		guint _tmp7_ = 0U;
		_tmp7_ = keyval;
		if (_tmp7_ == ((guint) GDK_KEY_Up)) {
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			_tmp8_ = self->priv->m_category_active_index;
			self->priv->m_category_active_index = _tmp8_ - 1;
			_tmp9_ = self->priv->m_category_active_index;
			if (_tmp9_ < 0) {
				GList* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				_tmp10_ = list;
				_tmp11_ = g_list_length (_tmp10_);
				self->priv->m_category_active_index = (gint) _tmp11_;
			}
		}
	}
	_tmp12_ = self->priv->m_list_box;
	_tmp13_ = gtk_list_box_get_adjustment ((GtkListBox*) _tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	adjustment = _tmp14_;
	_tmp15_ = self->priv->m_scrolled_window;
	gtk_scrolled_window_set_vadjustment ((GtkScrolledWindow*) _tmp15_, adjustment);
	ibus_emojier_show_category_list (self);
	_g_object_unref0 (adjustment);
	_g_list_free0 (list);
}


static void _vala_GdkEvent_free (GdkEvent* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


gchar* ibus_emojier_run (IBusEmojier* self, GdkEvent* event, const gchar* input_context_path) {
	gchar* result = NULL;
	GMainLoop* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	IBusEmojierEEntry* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	GdkDevice* device = NULL;
	GdkEvent* _tmp5_ = NULL;
	GdkDevice* _tmp6_ = NULL;
	GdkDevice* _tmp7_ = NULL;
	GdkDevice* _tmp8_ = NULL;
	GdkDevice* keyboard = NULL;
	GdkDevice* pointer = NULL;
	GdkDevice* _tmp19_ = NULL;
	GdkInputSource _tmp20_ = 0;
	IBusEmojierEEntry* _tmp31_ = NULL;
	GdkGrabStatus status = 0;
	GdkDevice* _tmp32_ = NULL;
	GdkWindow* _tmp33_ = NULL;
	GdkGrabStatus _tmp34_ = 0;
	GdkGrabStatus _tmp35_ = 0;
	GdkDevice* _tmp37_ = NULL;
	GdkWindow* _tmp38_ = NULL;
	GdkGrabStatus _tmp39_ = 0;
	GdkGrabStatus _tmp40_ = 0;
	GMainLoop* _tmp42_ = NULL;
	IBusEmojierETitleLabel* _tmp43_ = NULL;
	GMainLoop* _tmp44_ = NULL;
	GMainLoop* _tmp45_ = NULL;
	IBusEmojierETitleLabel* _tmp46_ = NULL;
	GdkDevice* _tmp47_ = NULL;
	GdkDevice* _tmp48_ = NULL;
	GdkEvent* fevent = NULL;
	GdkEvent* _tmp49_ = NULL;
	GdkEvent* _tmp50_ = NULL;
	GdkEventFocus* _tmp51_ = NULL;
	GdkEventFocus* _tmp52_ = NULL;
	GdkEvent* _tmp53_ = NULL;
	GdkEventFocus* _tmp54_ = NULL;
	GdkEventFocus* _tmp55_ = NULL;
	GdkWindow* _tmp56_ = NULL;
	IBusEmojierEEntry* _tmp57_ = NULL;
	GdkEvent* _tmp58_ = NULL;
	const gchar* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	g_return_val_if_fail (input_context_path != NULL, NULL);
	_tmp0_ = self->priv->m_loop;
	_vala_assert (_tmp0_ == NULL, "m_loop == null");
	self->priv->m_is_running = TRUE;
	_tmp1_ = input_context_path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->m_input_context_path);
	self->priv->m_input_context_path = _tmp2_;
	self->priv->m_candidate_panel_is_visible = FALSE;
	_g_free0 (self->priv->m_result);
	self->priv->m_result = NULL;
	gtk_window_resize ((GtkWindow*) self, 1, 1);
	_tmp3_ = self->priv->m_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp3_, "");
	_tmp4_ = self->priv->m_buffer_string;
	g_string_erase (_tmp4_, (gssize) 0, (gssize) -1);
	_tmp5_ = event;
	_tmp6_ = gdk_event_get_device (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	device = _tmp7_;
	_tmp8_ = device;
	if (_tmp8_ == NULL) {
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp9_ = NULL;
		GdkDisplay* _tmp10_ = NULL;
		GdkDeviceManager* device_manager = NULL;
		GdkDisplay* _tmp11_ = NULL;
		GdkDeviceManager* _tmp12_ = NULL;
		GdkDeviceManager* _tmp13_ = NULL;
		GdkDeviceManager* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		GList* _tmp16_ = NULL;
		gconstpointer _tmp17_ = NULL;
		GdkDevice* _tmp18_ = NULL;
		_tmp9_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		display = _tmp10_;
		_tmp11_ = display;
		_tmp12_ = gdk_display_get_device_manager (_tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		device_manager = _tmp13_;
		_tmp14_ = device_manager;
		_tmp15_ = gdk_device_manager_list_devices (_tmp14_, GDK_DEVICE_TYPE_MASTER);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_->data;
		_tmp18_ = _g_object_ref0 ((GdkDevice*) _tmp17_);
		_g_object_unref0 (device);
		device = _tmp18_;
		_g_list_free0 (_tmp16_);
		_g_object_unref0 (device_manager);
		_g_object_unref0 (display);
	}
	_tmp19_ = device;
	_tmp20_ = gdk_device_get_source (_tmp19_);
	if (_tmp20_ == GDK_SOURCE_KEYBOARD) {
		GdkDevice* _tmp21_ = NULL;
		GdkDevice* _tmp22_ = NULL;
		GdkDevice* _tmp23_ = NULL;
		GdkDevice* _tmp24_ = NULL;
		GdkDevice* _tmp25_ = NULL;
		_tmp21_ = device;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_g_object_unref0 (keyboard);
		keyboard = _tmp22_;
		_tmp23_ = device;
		_tmp24_ = gdk_device_get_associated_device (_tmp23_);
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_g_object_unref0 (pointer);
		pointer = _tmp25_;
	} else {
		GdkDevice* _tmp26_ = NULL;
		GdkDevice* _tmp27_ = NULL;
		GdkDevice* _tmp28_ = NULL;
		GdkDevice* _tmp29_ = NULL;
		GdkDevice* _tmp30_ = NULL;
		_tmp26_ = device;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_g_object_unref0 (pointer);
		pointer = _tmp27_;
		_tmp28_ = device;
		_tmp29_ = gdk_device_get_associated_device (_tmp28_);
		_tmp30_ = _g_object_ref0 (_tmp29_);
		_g_object_unref0 (keyboard);
		keyboard = _tmp30_;
	}
	self->priv->m_current_category_type = IBUS_EMOJIER_CATEGORY_TYPE_EMOJI;
	ibus_emojier_show_category_list (self);
	_tmp31_ = self->priv->m_entry;
	gtk_entry_set_activates_default ((GtkEntry*) _tmp31_, TRUE);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp32_ = keyboard;
	_tmp33_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp34_ = gdk_device_grab (_tmp32_, _tmp33_, GDK_OWNERSHIP_NONE, TRUE, GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	status = _tmp34_;
	_tmp35_ = status;
	if (_tmp35_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp36_ = 0;
		_tmp36_ = status;
		g_warning ("emojier.vala:933: Grab keyboard failed! status = %d", (gint) _tmp36_);
	}
	_tmp37_ = pointer;
	_tmp38_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp39_ = gdk_device_grab (_tmp37_, _tmp38_, GDK_OWNERSHIP_NONE, TRUE, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	status = _tmp39_;
	_tmp40_ = status;
	if (_tmp40_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp41_ = 0;
		_tmp41_ = status;
		g_warning ("emojier.vala:943: Grab pointer failed! status = %d", (gint) _tmp41_);
	}
	_tmp42_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = _tmp42_;
	_tmp43_ = self->priv->m_title;
	_tmp44_ = self->priv->m_loop;
	ibus_emojier_etitle_label_set_loop (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->m_loop;
	g_main_loop_run (_tmp45_);
	_tmp46_ = self->priv->m_title;
	ibus_emojier_etitle_label_unset_loop (_tmp46_);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = NULL;
	_tmp47_ = keyboard;
	gdk_device_ungrab (_tmp47_, (guint32) GDK_CURRENT_TIME);
	_tmp48_ = pointer;
	gdk_device_ungrab (_tmp48_, (guint32) GDK_CURRENT_TIME);
	_tmp49_ = gdk_event_new (GDK_FOCUS_CHANGE);
	fevent = _tmp49_;
	_tmp50_ = fevent;
	_tmp51_ = (GdkEventFocus *) (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp52_->in = (gint16) 0;
	_tmp53_ = fevent;
	_tmp54_ = (GdkEventFocus *) (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp55_->window = _tmp56_;
	_tmp57_ = self->priv->m_entry;
	_tmp58_ = fevent;
	gtk_widget_send_focus_change ((GtkWidget*) _tmp57_, _tmp58_);
	gtk_widget_hide ((GtkWidget*) self);
	while (TRUE) {
		gboolean _tmp59_ = FALSE;
		_tmp59_ = gtk_events_pending ();
		if (!_tmp59_) {
			break;
		}
		gtk_main_iteration ();
	}
	self->priv->m_is_running = FALSE;
	_tmp60_ = self->priv->m_result;
	_tmp61_ = g_strdup (_tmp60_);
	result = _tmp61_;
	__vala_GdkEvent_free0 (fevent);
	_g_object_unref0 (pointer);
	_g_object_unref0 (keyboard);
	_g_object_unref0 (device);
	return result;
}


static void ibus_emojier_real_show (GtkWidget* base) {
	IBusEmojier * self;
	self = (IBusEmojier*) base;
	GTK_WIDGET_CLASS (ibus_emojier_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_window_set_focus_visible ((GtkWindow*) self, TRUE);
}


static gboolean ibus_emojier_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	IBusEmojier * self;
	gboolean result = FALSE;
	guint keyval = 0U;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint modifiers = 0U;
	GdkEventKey* _tmp2_ = NULL;
	GdkModifierType _tmp3_ = 0;
	guint _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	guint _tmp8_ = 0U;
	gchar* annotation = NULL;
	GString* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	IBusEmojierEEntry* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	self = (IBusEmojier*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	keyval = _tmp1_;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->state;
	modifiers = (guint) _tmp3_;
	_tmp4_ = keyval;
	_tmp5_ = ibus_emojier_if_in_range_of_lookup (self, _tmp4_);
	if (_tmp5_) {
		guint _tmp6_ = 0U;
		GMainLoop* _tmp7_ = NULL;
		_tmp6_ = keyval;
		ibus_emojier_set_number_on_lookup (self, _tmp6_);
		_tmp7_ = self->priv->m_loop;
		g_main_loop_quit (_tmp7_);
		result = TRUE;
		return result;
	}
	_tmp8_ = keyval;
	switch (_tmp8_) {
		case GDK_KEY_Escape:
		{
			gboolean _tmp9_ = FALSE;
			GString* _tmp16_ = NULL;
			_tmp9_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp9_) {
				ibus_emojier_hide_candidate_panel (self);
				result = TRUE;
				return result;
			} else {
				IBusEmojierCategoryType _tmp10_ = 0;
				_tmp10_ = self->priv->m_current_category_type;
				if (_tmp10_ == IBUS_EMOJIER_CATEGORY_TYPE_LANG) {
					self->priv->m_current_category_type = IBUS_EMOJIER_CATEGORY_TYPE_EMOJI;
					ibus_emojier_show_candidate_panel (self);
					result = TRUE;
					return result;
				} else {
					GString* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					_tmp11_ = self->priv->m_buffer_string;
					_tmp12_ = _tmp11_->str;
					_tmp13_ = strlen (_tmp12_);
					_tmp14_ = _tmp13_;
					if (_tmp14_ == 0) {
						GMainLoop* _tmp15_ = NULL;
						_tmp15_ = self->priv->m_loop;
						g_main_loop_quit (_tmp15_);
						ibus_emojier_hide_candidate_panel (self);
						result = TRUE;
						return result;
					}
				}
			}
			_tmp16_ = self->priv->m_buffer_string;
			g_string_erase (_tmp16_, (gssize) 0, (gssize) -1);
			break;
		}
		case GDK_KEY_Return:
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp17_) {
				guint index = 0U;
				IBusLookupTable* _tmp18_ = NULL;
				guint _tmp19_ = 0U;
				IBusText* text = NULL;
				IBusLookupTable* _tmp20_ = NULL;
				guint _tmp21_ = 0U;
				IBusText* _tmp22_ = NULL;
				IBusText* _tmp23_ = NULL;
				IBusText* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				GMainLoop* _tmp27_ = NULL;
				_tmp18_ = self->priv->m_lookup_table;
				_tmp19_ = ibus_lookup_table_get_cursor_pos (_tmp18_);
				index = _tmp19_;
				_tmp20_ = self->priv->m_lookup_table;
				_tmp21_ = index;
				_tmp22_ = ibus_lookup_table_get_candidate (_tmp20_, _tmp21_);
				_tmp23_ = _g_object_ref0 (_tmp22_);
				text = _tmp23_;
				_tmp24_ = text;
				_tmp25_ = _tmp24_->text;
				_tmp26_ = g_strdup (_tmp25_);
				_g_free0 (self->priv->m_result);
				self->priv->m_result = _tmp26_;
				_tmp27_ = self->priv->m_loop;
				g_main_loop_quit (_tmp27_);
				ibus_emojier_hide_candidate_panel (self);
				_g_object_unref0 (text);
			} else {
				gint _tmp28_ = 0;
				_tmp28_ = self->priv->m_category_active_index;
				if (_tmp28_ > 0) {
					GtkListBoxRow* gtkrow = NULL;
					IBusEmojierEListBox* _tmp29_ = NULL;
					GtkListBoxRow* _tmp30_ = NULL;
					GtkListBoxRow* _tmp31_ = NULL;
					IBusEmojierEBoxRow* row = NULL;
					GtkListBoxRow* _tmp32_ = NULL;
					IBusEmojierEBoxRow* _tmp33_ = NULL;
					IBusEmojierEBoxRow* _tmp34_ = NULL;
					_tmp29_ = self->priv->m_list_box;
					_tmp30_ = gtk_list_box_get_selected_row ((GtkListBox*) _tmp29_);
					_tmp31_ = _g_object_ref0 (_tmp30_);
					gtkrow = _tmp31_;
					_tmp32_ = gtkrow;
					_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, IBUS_EMOJIER_TYPE_EBOX_ROW) ? ((IBusEmojierEBoxRow*) _tmp32_) : NULL);
					row = _tmp33_;
					_tmp34_ = row;
					ibus_emojier_show_emoji_for_category (self, _tmp34_);
					_g_object_unref0 (row);
					_g_object_unref0 (gtkrow);
				}
			}
			result = TRUE;
			return result;
		}
		case GDK_KEY_BackSpace:
		{
			GString* _tmp35_ = NULL;
			gssize _tmp36_ = 0L;
			_tmp35_ = self->priv->m_buffer_string;
			_tmp36_ = _tmp35_->len;
			if (_tmp36_ > ((gssize) 0)) {
				GString* _tmp37_ = NULL;
				GString* _tmp38_ = NULL;
				gssize _tmp39_ = 0L;
				_tmp37_ = self->priv->m_buffer_string;
				_tmp38_ = self->priv->m_buffer_string;
				_tmp39_ = _tmp38_->len;
				g_string_erase (_tmp37_, _tmp39_ - 1, (gssize) -1);
			}
			break;
		}
		case GDK_KEY_space:
		case GDK_KEY_KP_Space:
		{
			guint _tmp40_ = 0U;
			gboolean _tmp45_ = FALSE;
			_tmp40_ = modifiers;
			if ((_tmp40_ & GDK_SHIFT_MASK) != ((guint) 0)) {
				gunichar ch = 0U;
				guint _tmp41_ = 0U;
				gunichar _tmp42_ = 0U;
				GString* _tmp43_ = NULL;
				gunichar _tmp44_ = 0U;
				_tmp41_ = keyval;
				_tmp42_ = ibus_keyval_to_unicode (_tmp41_);
				ch = _tmp42_;
				_tmp43_ = self->priv->m_buffer_string;
				_tmp44_ = ch;
				g_string_append_unichar (_tmp43_, _tmp44_);
				break;
			}
			_tmp45_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp45_) {
				IBusLookupTable* _tmp46_ = NULL;
				_tmp46_ = self->priv->m_lookup_table;
				ibus_lookup_table_cursor_down (_tmp46_);
				ibus_emojier_show_candidate_panel (self);
			} else {
				ibus_emojier_category_list_cursor_move (self, (guint) GDK_KEY_Down);
			}
			result = TRUE;
			return result;
		}
		case GDK_KEY_Right:
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp47_) {
				IBusLookupTable* _tmp48_ = NULL;
				_tmp48_ = self->priv->m_lookup_table;
				ibus_lookup_table_cursor_down (_tmp48_);
				ibus_emojier_show_candidate_panel (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Left:
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp49_) {
				IBusLookupTable* _tmp50_ = NULL;
				_tmp50_ = self->priv->m_lookup_table;
				ibus_lookup_table_cursor_up (_tmp50_);
				ibus_emojier_show_candidate_panel (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Down:
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp51_) {
				ibus_emojier_candidate_panel_cursor_down (self);
			} else {
				ibus_emojier_category_list_cursor_move (self, (guint) GDK_KEY_Down);
			}
			result = TRUE;
			return result;
		}
		case GDK_KEY_Up:
		{
			gboolean _tmp52_ = FALSE;
			_tmp52_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp52_) {
				ibus_emojier_candidate_panel_cursor_up (self);
			} else {
				ibus_emojier_category_list_cursor_move (self, (guint) GDK_KEY_Up);
			}
			result = TRUE;
			return result;
		}
		case GDK_KEY_Page_Down:
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp53_) {
				IBusLookupTable* _tmp54_ = NULL;
				_tmp54_ = self->priv->m_lookup_table;
				ibus_lookup_table_page_down (_tmp54_);
				ibus_emojier_show_candidate_panel (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Page_Up:
		{
			gboolean _tmp55_ = FALSE;
			_tmp55_ = self->priv->m_candidate_panel_is_visible;
			if (_tmp55_) {
				IBusLookupTable* _tmp56_ = NULL;
				_tmp56_ = self->priv->m_lookup_table;
				ibus_lookup_table_page_up (_tmp56_);
				ibus_emojier_show_candidate_panel (self);
				result = TRUE;
				return result;
			}
			break;
		}
		default:
		{
			gunichar ch = 0U;
			guint _tmp57_ = 0U;
			gunichar _tmp58_ = 0U;
			gunichar _tmp59_ = 0U;
			gboolean _tmp60_ = FALSE;
			GString* _tmp61_ = NULL;
			gunichar _tmp62_ = 0U;
			_tmp57_ = keyval;
			_tmp58_ = ibus_keyval_to_unicode (_tmp57_);
			ch = _tmp58_;
			_tmp59_ = ch;
			_tmp60_ = g_unichar_isgraph (_tmp59_);
			if (!_tmp60_) {
				result = TRUE;
				return result;
			}
			_tmp61_ = self->priv->m_buffer_string;
			_tmp62_ = ch;
			g_string_append_unichar (_tmp61_, _tmp62_);
			break;
		}
	}
	_tmp63_ = self->priv->m_buffer_string;
	_tmp64_ = _tmp63_->str;
	_tmp65_ = g_strdup (_tmp64_);
	annotation = _tmp65_;
	_tmp66_ = self->priv->m_entry;
	_tmp67_ = annotation;
	gtk_entry_set_text ((GtkEntry*) _tmp66_, _tmp67_);
	result = TRUE;
	_g_free0 (annotation);
	return result;
}


gboolean ibus_emojier_is_running (IBusEmojier* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_is_running;
	result = _tmp0_;
	return result;
}


gchar* ibus_emojier_get_input_context_path (IBusEmojier* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_input_context_path;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* ibus_emojier_get_selected_string (IBusEmojier* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_result;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void ibus_emojier_reset (IBusEmojier* self) {
	gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->m_input_context_path);
	self->priv->m_input_context_path = _tmp0_;
	_g_free0 (self->priv->m_result);
	self->priv->m_result = NULL;
}


void ibus_emojier_set_emoji_font (IBusEmojier* self, const gchar* emoji_font) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (emoji_font != NULL);
	_tmp0_ = emoji_font;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->m_emoji_font);
	self->priv->m_emoji_font = _tmp1_;
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void ibus_emojier_set_favorites (IBusEmojier* self, gchar** unowned_favorites, int unowned_favorites_length1) {
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_favorites = (_vala_array_free (self->priv->m_favorites, self->priv->m_favorites_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_favorites = _tmp0_;
	self->priv->m_favorites_length1 = 0;
	self->priv->_m_favorites_size_ = self->priv->m_favorites_length1;
	_tmp1_ = unowned_favorites;
	_tmp1__length1 = unowned_favorites_length1;
	{
		gchar** favorite_collection = NULL;
		gint favorite_collection_length1 = 0;
		gint _favorite_collection_size_ = 0;
		gint favorite_it = 0;
		favorite_collection = _tmp1_;
		favorite_collection_length1 = _tmp1__length1;
		for (favorite_it = 0; favorite_it < _tmp1__length1; favorite_it = favorite_it + 1) {
			gchar* _tmp2_ = NULL;
			gchar* favorite = NULL;
			_tmp2_ = g_strdup (favorite_collection[favorite_it]);
			favorite = _tmp2_;
			{
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				_tmp3_ = self->priv->m_favorites;
				_tmp3__length1 = self->priv->m_favorites_length1;
				_tmp4_ = favorite;
				_tmp5_ = g_strdup (_tmp4_);
				_vala_array_add11 (&self->priv->m_favorites, &self->priv->m_favorites_length1, &self->priv->_m_favorites_size_, _tmp5_);
				_g_free0 (favorite);
			}
		}
	}
}


gboolean ibus_emojier_has_loaded_emoji_dict (IBusEmojier* self) {
	gboolean result = FALSE;
	GHashTable* _tmp0_ = NULL;
	GList* keys = NULL;
	GHashTable* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_emoji_to_data_dict;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->m_emoji_to_data_dict;
	_tmp2_ = g_hash_table_get_keys (_tmp1_);
	keys = _tmp2_;
	_tmp3_ = keys;
	_tmp4_ = g_list_length (_tmp3_);
	if (_tmp4_ == ((guint) 0)) {
		result = FALSE;
		_g_list_free0 (keys);
		return result;
	}
	result = TRUE;
	_g_list_free0 (keys);
	return result;
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static IBusEmojierEEntry* ibus_emojier_eentry_construct (GType object_type) {
	IBusEmojierEEntry * self = NULL;
	self = (IBusEmojierEEntry*) g_object_new (object_type, "name", "IBusEmojierEntry", "margin-start", 6, "margin-end", 6, "margin-top", 6, "margin-bottom", 6, NULL);
	return self;
}


static IBusEmojierEEntry* ibus_emojier_eentry_new (void) {
	return ibus_emojier_eentry_construct (IBUS_EMOJIER_TYPE_EENTRY);
}


static void ibus_emojier_eentry_class_init (IBusEmojierEEntryClass * klass) {
	ibus_emojier_eentry_parent_class = g_type_class_peek_parent (klass);
}


static void ibus_emojier_eentry_instance_init (IBusEmojierEEntry * self) {
}


static GType ibus_emojier_eentry_get_type (void) {
	static volatile gsize ibus_emojier_eentry_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_eentry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusEmojierEEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_emojier_eentry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusEmojierEEntry), 0, (GInstanceInitFunc) ibus_emojier_eentry_instance_init, NULL };
		GType ibus_emojier_eentry_type_id;
		ibus_emojier_eentry_type_id = g_type_register_static (gtk_search_entry_get_type (), "IBusEmojierEEntry", &g_define_type_info, 0);
		g_once_init_leave (&ibus_emojier_eentry_type_id__volatile, ibus_emojier_eentry_type_id);
	}
	return ibus_emojier_eentry_type_id__volatile;
}


static IBusEmojierEListBox* ibus_emojier_elist_box_construct (GType object_type) {
	IBusEmojierEListBox * self = NULL;
	self = (IBusEmojierEListBox*) g_object_new (object_type, "vexpand", TRUE, "halign", GTK_ALIGN_FILL, "valign", GTK_ALIGN_FILL, NULL);
	return self;
}


static IBusEmojierEListBox* ibus_emojier_elist_box_new (void) {
	return ibus_emojier_elist_box_construct (IBUS_EMOJIER_TYPE_ELIST_BOX);
}


static void ibus_emojier_elist_box_class_init (IBusEmojierEListBoxClass * klass) {
	ibus_emojier_elist_box_parent_class = g_type_class_peek_parent (klass);
}


static void ibus_emojier_elist_box_instance_init (IBusEmojierEListBox * self) {
}


static GType ibus_emojier_elist_box_get_type (void) {
	static volatile gsize ibus_emojier_elist_box_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_elist_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusEmojierEListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_emojier_elist_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusEmojierEListBox), 0, (GInstanceInitFunc) ibus_emojier_elist_box_instance_init, NULL };
		GType ibus_emojier_elist_box_type_id;
		ibus_emojier_elist_box_type_id = g_type_register_static (gtk_list_box_get_type (), "IBusEmojierEListBox", &g_define_type_info, 0);
		g_once_init_leave (&ibus_emojier_elist_box_type_id__volatile, ibus_emojier_elist_box_type_id);
	}
	return ibus_emojier_elist_box_type_id__volatile;
}


static IBusEmojierEBoxRow* ibus_emojier_ebox_row_construct (GType object_type, const gchar* text, const gchar* id) {
	IBusEmojierEBoxRow * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	self = (IBusEmojierEBoxRow*) g_object_new (object_type, NULL);
	_tmp0_ = text;
	ibus_emojier_ebox_row_set_text (self, _tmp0_);
	_tmp1_ = id;
	ibus_emojier_ebox_row_set_id (self, _tmp1_);
	return self;
}


static IBusEmojierEBoxRow* ibus_emojier_ebox_row_new (const gchar* text, const gchar* id) {
	return ibus_emojier_ebox_row_construct (IBUS_EMOJIER_TYPE_EBOX_ROW, text, id);
}


static const gchar* ibus_emojier_ebox_row_get_text (IBusEmojierEBoxRow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}


static void ibus_emojier_ebox_row_set_text (IBusEmojierEBoxRow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	g_object_notify ((GObject *) self, "text");
}


static const gchar* ibus_emojier_ebox_row_get_id (IBusEmojierEBoxRow* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void ibus_emojier_ebox_row_set_id (IBusEmojierEBoxRow* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


static void ibus_emojier_ebox_row_class_init (IBusEmojierEBoxRowClass * klass) {
	ibus_emojier_ebox_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusEmojierEBoxRowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_ibus_emojier_ebox_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ibus_emojier_ebox_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = ibus_emojier_ebox_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), IBUS_EMOJIER_EBOX_ROW_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IBUS_EMOJIER_EBOX_ROW_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ibus_emojier_ebox_row_instance_init (IBusEmojierEBoxRow * self) {
	self->priv = IBUS_EMOJIER_EBOX_ROW_GET_PRIVATE (self);
}


static void ibus_emojier_ebox_row_finalize (GObject* obj) {
	IBusEmojierEBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IBUS_EMOJIER_TYPE_EBOX_ROW, IBusEmojierEBoxRow);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (ibus_emojier_ebox_row_parent_class)->finalize (obj);
}


static GType ibus_emojier_ebox_row_get_type (void) {
	static volatile gsize ibus_emojier_ebox_row_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_ebox_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusEmojierEBoxRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_emojier_ebox_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusEmojierEBoxRow), 0, (GInstanceInitFunc) ibus_emojier_ebox_row_instance_init, NULL };
		GType ibus_emojier_ebox_row_type_id;
		ibus_emojier_ebox_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "IBusEmojierEBoxRow", &g_define_type_info, 0);
		g_once_init_leave (&ibus_emojier_ebox_row_type_id__volatile, ibus_emojier_ebox_row_type_id);
	}
	return ibus_emojier_ebox_row_type_id__volatile;
}


static void _vala_ibus_emojier_ebox_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IBusEmojierEBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, IBUS_EMOJIER_TYPE_EBOX_ROW, IBusEmojierEBoxRow);
	switch (property_id) {
		case IBUS_EMOJIER_EBOX_ROW_TEXT:
		g_value_set_string (value, ibus_emojier_ebox_row_get_text (self));
		break;
		case IBUS_EMOJIER_EBOX_ROW_ID:
		g_value_set_string (value, ibus_emojier_ebox_row_get_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_ibus_emojier_ebox_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IBusEmojierEBoxRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, IBUS_EMOJIER_TYPE_EBOX_ROW, IBusEmojierEBoxRow);
	switch (property_id) {
		case IBUS_EMOJIER_EBOX_ROW_TEXT:
		ibus_emojier_ebox_row_set_text (self, g_value_get_string (value));
		break;
		case IBUS_EMOJIER_EBOX_ROW_ID:
		ibus_emojier_ebox_row_set_id (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static IBusEmojierEScrolledWindow* ibus_emojier_escrolled_window_construct (GType object_type, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment) {
	IBusEmojierEScrolledWindow * self = NULL;
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	self = (IBusEmojierEScrolledWindow*) g_object_new (object_type, "hscrollbar-policy", GTK_POLICY_NEVER, "vscrollbar-policy", GTK_POLICY_NEVER, "shadow-type", GTK_SHADOW_IN, "margin-start", 6, "margin-end", 6, "margin-top", 6, "margin-bottom", 6, NULL);
	_tmp0_ = hadjustment;
	if (_tmp0_ != NULL) {
		GtkAdjustment* _tmp1_ = NULL;
		_tmp1_ = hadjustment;
		gtk_scrolled_window_set_hadjustment ((GtkScrolledWindow*) self, _tmp1_);
	}
	_tmp2_ = vadjustment;
	if (_tmp2_ != NULL) {
		GtkAdjustment* _tmp3_ = NULL;
		_tmp3_ = vadjustment;
		gtk_scrolled_window_set_hadjustment ((GtkScrolledWindow*) self, _tmp3_);
	}
	return self;
}


static IBusEmojierEScrolledWindow* ibus_emojier_escrolled_window_new (GtkAdjustment* hadjustment, GtkAdjustment* vadjustment) {
	return ibus_emojier_escrolled_window_construct (IBUS_EMOJIER_TYPE_ESCROLLED_WINDOW, hadjustment, vadjustment);
}


static void ibus_emojier_escrolled_window_class_init (IBusEmojierEScrolledWindowClass * klass) {
	ibus_emojier_escrolled_window_parent_class = g_type_class_peek_parent (klass);
}


static void ibus_emojier_escrolled_window_instance_init (IBusEmojierEScrolledWindow * self) {
}


static GType ibus_emojier_escrolled_window_get_type (void) {
	static volatile gsize ibus_emojier_escrolled_window_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_escrolled_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusEmojierEScrolledWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_emojier_escrolled_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusEmojierEScrolledWindow), 0, (GInstanceInitFunc) ibus_emojier_escrolled_window_instance_init, NULL };
		GType ibus_emojier_escrolled_window_type_id;
		ibus_emojier_escrolled_window_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "IBusEmojierEScrolledWindow", &g_define_type_info, 0);
		g_once_init_leave (&ibus_emojier_escrolled_window_type_id__volatile, ibus_emojier_escrolled_window_type_id);
	}
	return ibus_emojier_escrolled_window_type_id__volatile;
}


static IBusEmojierEGrid* ibus_emojier_egrid_construct (GType object_type) {
	IBusEmojierEGrid * self = NULL;
	self = (IBusEmojierEGrid*) g_object_new (object_type, "vexpand", TRUE, "halign", GTK_ALIGN_FILL, "valign", GTK_ALIGN_FILL, NULL);
	return self;
}


static IBusEmojierEGrid* ibus_emojier_egrid_new (void) {
	return ibus_emojier_egrid_construct (IBUS_EMOJIER_TYPE_EGRID);
}


static void ibus_emojier_egrid_class_init (IBusEmojierEGridClass * klass) {
	ibus_emojier_egrid_parent_class = g_type_class_peek_parent (klass);
}


static void ibus_emojier_egrid_instance_init (IBusEmojierEGrid * self) {
}


static GType ibus_emojier_egrid_get_type (void) {
	static volatile gsize ibus_emojier_egrid_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_egrid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusEmojierEGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_emojier_egrid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusEmojierEGrid), 0, (GInstanceInitFunc) ibus_emojier_egrid_instance_init, NULL };
		GType ibus_emojier_egrid_type_id;
		ibus_emojier_egrid_type_id = g_type_register_static (gtk_grid_get_type (), "IBusEmojierEGrid", &g_define_type_info, 0);
		g_once_init_leave (&ibus_emojier_egrid_type_id__volatile, ibus_emojier_egrid_type_id);
	}
	return ibus_emojier_egrid_type_id__volatile;
}


static IBusEmojierEPaddedLabel* ibus_emojier_epadded_label_construct (GType object_type, const gchar* text, GtkAlign align, IBusEmojierTravelDirection direction) {
	IBusEmojierEPaddedLabel * self = NULL;
	IBusEmojierTravelDirection _tmp0_ = 0;
	GtkLabel* label = NULL;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkAlign _tmp7_ = 0;
	g_return_val_if_fail (text != NULL, NULL);
	self = (IBusEmojierEPaddedLabel*) g_object_new (object_type, "name", "IBusEmojierPaddedLabel", "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	_tmp0_ = direction;
	if (_tmp0_ == IBUS_EMOJIER_TRAVEL_DIRECTION_BACKWARD) {
		IconWidget* icon = NULL;
		GtkTextDirection _tmp1_ = 0;
		IconWidget* _tmp4_ = NULL;
		_tmp1_ = gtk_widget_get_default_direction ();
		if (_tmp1_ == GTK_TEXT_DIR_RTL) {
			IconWidget* _tmp2_ = NULL;
			_tmp2_ = icon_widget_new ("go-previous-rtl-symbolic", GTK_ICON_SIZE_MENU);
			g_object_ref_sink (_tmp2_);
			_g_object_unref0 (icon);
			icon = _tmp2_;
		} else {
			IconWidget* _tmp3_ = NULL;
			_tmp3_ = icon_widget_new ("go-previous-symbolic", GTK_ICON_SIZE_MENU);
			g_object_ref_sink (_tmp3_);
			_g_object_unref0 (icon);
			icon = _tmp3_;
		}
		_tmp4_ = icon;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp4_, FALSE, TRUE, (guint) 0);
		_g_object_unref0 (icon);
	}
	_tmp5_ = text;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	label = _tmp6_;
	_tmp7_ = align;
	gtk_widget_set_halign ((GtkWidget*) label, _tmp7_);
	gtk_widget_set_valign ((GtkWidget*) label, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_start ((GtkWidget*) label, 20);
	gtk_widget_set_margin_end ((GtkWidget*) label, 20);
	gtk_widget_set_margin_top ((GtkWidget*) label, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) label, 6);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (label);
	return self;
}


static IBusEmojierEPaddedLabel* ibus_emojier_epadded_label_new (const gchar* text, GtkAlign align, IBusEmojierTravelDirection direction) {
	return ibus_emojier_epadded_label_construct (IBUS_EMOJIER_TYPE_EPADDED_LABEL, text, align, direction);
}


static void ibus_emojier_epadded_label_class_init (IBusEmojierEPaddedLabelClass * klass) {
	ibus_emojier_epadded_label_parent_class = g_type_class_peek_parent (klass);
}


static void ibus_emojier_epadded_label_instance_init (IBusEmojierEPaddedLabel * self) {
}


static GType ibus_emojier_epadded_label_get_type (void) {
	static volatile gsize ibus_emojier_epadded_label_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_epadded_label_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusEmojierEPaddedLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_emojier_epadded_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusEmojierEPaddedLabel), 0, (GInstanceInitFunc) ibus_emojier_epadded_label_instance_init, NULL };
		GType ibus_emojier_epadded_label_type_id;
		ibus_emojier_epadded_label_type_id = g_type_register_static (gtk_box_get_type (), "IBusEmojierEPaddedLabel", &g_define_type_info, 0);
		g_once_init_leave (&ibus_emojier_epadded_label_type_id__volatile, ibus_emojier_epadded_label_type_id);
	}
	return ibus_emojier_epadded_label_type_id__volatile;
}


static IBusEmojierETitleLabel* ibus_emojier_etitle_label_construct (GType object_type, const gchar* text, GtkAlign align) {
	IBusEmojierETitleLabel * self = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkAlign _tmp2_ = 0;
	GtkAlign _tmp3_ = 0;
	IconWidget* icon = NULL;
	IconWidget* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	self = (IBusEmojierETitleLabel*) g_object_new (object_type, "name", "IBusEmojierTitleLabel", "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	_tmp0_ = text;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = align;
	gtk_widget_set_halign ((GtkWidget*) label, _tmp2_);
	_tmp3_ = align;
	gtk_widget_set_valign ((GtkWidget*) label, _tmp3_);
	gtk_widget_set_margin_start ((GtkWidget*) label, 20);
	gtk_widget_set_margin_end ((GtkWidget*) label, 20);
	gtk_widget_set_margin_top ((GtkWidget*) label, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) label, 6);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_tmp4_ = icon_widget_new ("window-close", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp4_);
	icon = _tmp4_;
	_tmp5_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_close_button);
	self->priv->m_close_button = _tmp5_;
	_tmp6_ = self->priv->m_close_button;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) icon);
	_tmp7_ = self->priv->m_close_button;
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) _tmp7_, FALSE, TRUE, (guint) 0);
	_g_object_unref0 (icon);
	_g_object_unref0 (label);
	return self;
}


static IBusEmojierETitleLabel* ibus_emojier_etitle_label_new (const gchar* text, GtkAlign align) {
	return ibus_emojier_etitle_label_construct (IBUS_EMOJIER_TYPE_ETITLE_LABEL, text, align);
}


static gpointer _g_main_loop_ref0 (gpointer self) {
	return self ? g_main_loop_ref (self) : NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		IBusEmojierETitleLabel* self;
		self = _data5_->self;
		_g_main_loop_unref0 (_data5_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean __lambda23_ (Block5Data* _data5_, GdkEventButton* e) {
	IBusEmojierETitleLabel* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GMainLoop* _tmp1_ = NULL;
	self = _data5_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1_ = _data5_->loop;
	if (_tmp1_ != NULL) {
		GMainLoop* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = _data5_->loop;
		_tmp3_ = g_main_loop_is_running (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GMainLoop* _tmp4_ = NULL;
		_tmp4_ = _data5_->loop;
		g_main_loop_quit (_tmp4_);
	}
	result = TRUE;
	return result;
}


static gboolean ___lambda23__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda23_ (self, event);
	return result;
}


static void ibus_emojier_etitle_label_set_loop (IBusEmojierETitleLabel* self, GMainLoop* loop) {
	Block5Data* _data5_;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GtkButton* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = loop;
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
	_g_main_loop_unref0 (_data5_->loop);
	_data5_->loop = _tmp1_;
	_tmp2_ = self->priv->m_close_handler;
	if (_tmp2_ > ((gulong) 0)) {
		GtkButton* _tmp3_ = NULL;
		gulong _tmp4_ = 0UL;
		_tmp3_ = self->priv->m_close_button;
		_tmp4_ = self->priv->m_close_handler;
		g_signal_handler_disconnect (_tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->m_close_button;
	_tmp6_ = g_signal_connect_data ((GtkWidget*) _tmp5_, "button-press-event", (GCallback) ___lambda23__gtk_widget_button_press_event, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	self->priv->m_close_handler = _tmp6_;
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void ibus_emojier_etitle_label_unset_loop (IBusEmojierETitleLabel* self) {
	gulong _tmp0_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_close_handler;
	if (_tmp0_ > ((gulong) 0)) {
		GtkButton* _tmp1_ = NULL;
		gulong _tmp2_ = 0UL;
		_tmp1_ = self->priv->m_close_button;
		_tmp2_ = self->priv->m_close_handler;
		g_signal_handler_disconnect (_tmp1_, _tmp2_);
		self->priv->m_close_handler = (gulong) 0;
	}
}


static void ibus_emojier_etitle_label_class_init (IBusEmojierETitleLabelClass * klass) {
	ibus_emojier_etitle_label_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusEmojierETitleLabelPrivate));
	G_OBJECT_CLASS (klass)->finalize = ibus_emojier_etitle_label_finalize;
}


static void ibus_emojier_etitle_label_instance_init (IBusEmojierETitleLabel * self) {
	self->priv = IBUS_EMOJIER_ETITLE_LABEL_GET_PRIVATE (self);
}


static void ibus_emojier_etitle_label_finalize (GObject* obj) {
	IBusEmojierETitleLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IBUS_EMOJIER_TYPE_ETITLE_LABEL, IBusEmojierETitleLabel);
	_g_object_unref0 (self->priv->m_close_button);
	G_OBJECT_CLASS (ibus_emojier_etitle_label_parent_class)->finalize (obj);
}


static GType ibus_emojier_etitle_label_get_type (void) {
	static volatile gsize ibus_emojier_etitle_label_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_etitle_label_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusEmojierETitleLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_emojier_etitle_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusEmojierETitleLabel), 0, (GInstanceInitFunc) ibus_emojier_etitle_label_instance_init, NULL };
		GType ibus_emojier_etitle_label_type_id;
		ibus_emojier_etitle_label_type_id = g_type_register_static (gtk_box_get_type (), "IBusEmojierETitleLabel", &g_define_type_info, 0);
		g_once_init_leave (&ibus_emojier_etitle_label_type_id__volatile, ibus_emojier_etitle_label_type_id);
	}
	return ibus_emojier_etitle_label_type_id__volatile;
}


static void ibus_emojier_class_init (IBusEmojierClass * klass) {
	ibus_emojier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusEmojierPrivate));
	((GtkWidgetClass *) klass)->show = (void (*)(GtkWidget*)) ibus_emojier_real_show;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*)(GtkWidget*, GdkEventKey*)) ibus_emojier_real_key_press_event;
	G_OBJECT_CLASS (klass)->finalize = ibus_emojier_finalize;
	g_signal_new ("candidate_clicked", TYPE_IBUS_EMOJIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("loaded_emoji_dict", TYPE_IBUS_EMOJIER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void ibus_emojier_instance_init (IBusEmojier * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	self->priv = IBUS_EMOJIER_GET_PRIVATE (self);
	self->priv->m_scrolled_window = NULL;
	self->priv->m_current_category_type = IBUS_EMOJIER_CATEGORY_TYPE_EMOJI;
	self->priv->m_is_running = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->m_input_context_path = _tmp0_;
	_tmp1_ = g_strdup ("en");
	self->priv->m_current_lang = _tmp1_;
	self->priv->m_unicode_point = NULL;
	self->priv->m_annotation_to_emojis_dict = NULL;
	self->priv->m_emoji_to_data_dict = NULL;
	self->priv->m_category_to_emojis_dict = NULL;
	self->priv->m_emoji_max_seq_len = 0;
	_tmp2_ = g_strdup ("Monospace 16");
	self->priv->m_emoji_font = _tmp2_;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_favorites = _tmp3_;
	self->priv->m_favorites_length1 = 0;
	self->priv->_m_favorites_size_ = self->priv->m_favorites_length1;
	memset (&_tmp4_, 0, sizeof (GdkRGBA));
	_tmp4_.red = 1.0;
	_tmp4_.green = 1.0;
	_tmp4_.blue = 1.0;
	_tmp4_.alpha = 1.0;
	self->priv->m_selected_fg_color = _tmp4_;
	memset (&_tmp5_, 0, sizeof (GdkRGBA));
	_tmp5_.red = 0.300;
	_tmp5_.green = 0.565;
	_tmp5_.blue = 0.851;
	_tmp5_.alpha = 1.0;
	self->priv->m_selected_bg_color = _tmp5_;
}


static void ibus_emojier_finalize (GObject* obj) {
	IBusEmojier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IBUS_EMOJIER, IBusEmojier);
	_g_object_unref0 (self->priv->m_vbox);
	_g_object_unref0 (self->priv->m_title);
	_g_object_unref0 (self->priv->m_entry);
	_g_free0 (self->priv->m_backward);
	_g_object_unref0 (self->priv->m_scrolled_window);
	_g_object_unref0 (self->priv->m_list_box);
	_g_free0 (self->priv->m_input_context_path);
	_g_string_free0 (self->priv->m_buffer_string);
	_g_main_loop_unref0 (self->priv->m_loop);
	_g_free0 (self->priv->m_result);
	__g_slist_free__g_free0_0 (self->priv->m_lang_list);
	_g_free0 (self->priv->m_current_lang);
	_g_free0 (self->priv->m_unicode_point);
	_g_hash_table_unref0 (self->priv->m_annotation_to_emojis_dict);
	_g_hash_table_unref0 (self->priv->m_emoji_to_data_dict);
	_g_hash_table_unref0 (self->priv->m_category_to_emojis_dict);
	_g_object_unref0 (self->priv->m_lookup_table);
	self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (self->priv->m_emoji_font);
	self->priv->m_favorites = (_vala_array_free (self->priv->m_favorites, self->priv->m_favorites_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (ibus_emojier_parent_class)->finalize (obj);
}


GType ibus_emojier_get_type (void) {
	static volatile gsize ibus_emojier_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_emojier_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusEmojierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_emojier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusEmojier), 0, (GInstanceInitFunc) ibus_emojier_instance_init, NULL };
		GType ibus_emojier_type_id;
		ibus_emojier_type_id = g_type_register_static (gtk_window_get_type (), "IBusEmojier", &g_define_type_info, 0);
		g_once_init_leave (&ibus_emojier_type_id__volatile, ibus_emojier_type_id);
	}
	return ibus_emojier_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



