// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_GUTTER_H
#define _GTKSOURCEVIEWMM_GUTTER_H


#include <glibmm.h>

/* gutter.h
 *
 * Copyright (C) 2009, 2010, 2011 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief Gutter class

#include <gdkmm/window.h>
#include <glibmm/object.h>
#include <glibmm/refptr.h>
#include <gtksourceviewmm/gutterrenderer.h>
#include <gtksourceviewmm/view.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceGutter GtkSourceGutter;
typedef struct _GtkSourceGutterClass GtkSourceGutterClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{ class Gutter_Class; } // namespace Gsv
namespace Gsv
{

class GutterRenderer;
class View;

// TODO: update docs.
/** Gutter object for View
 *
 * The Gutter object represents the left and right gutters of the text
 * view. It is used by View to draw the line numbers and category marks
 * that might be present on a line. By packing additional CellRenderer objects
 * in the gutter, you can extend the gutter with your own custom drawings.
 *
 * The gutter works very much the same way as cells rendered in a Gtk::TreeView.
 * The concept is similar, with the exception that the gutter does not have an
 * underlying Gtk::TreeModel. Instead, you should use set_cell_data_func() to
 * set a callback to fill in any of the cell renderers properties, given the
 * line for which the cell is to be rendered. Renderers are inserted into the
 * gutter at a certain position. The builtin line number renderer is at position
 * View::gutter_position_lines (-30) and the marks renderer is at
 * View::gutter_position_marks (-20). You can use these values to
 * position custom renderers accordingly. The width of a cell renderer can be
 * specified as either fixed (using Gtk::CellRenderer::set_fixed_size()) or
 * dynamic, in which case you @e must set set_cell_size_func(). This callback is
 * used to set the properties of the renderer such that
 * Gtk::CellRenderer::get_size() yields the maximum width of the cell.
 *
 * @newin{2,10}
 */

class Gutter : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Gutter CppObjectType;
  typedef Gutter_Class CppClassType;
  typedef GtkSourceGutter BaseObjectType;
  typedef GtkSourceGutterClass BaseClassType;

private:  friend class Gutter_Class;
  static CppClassType gutter_class_;

private:
  // noncopyable
  Gutter(const Gutter&);
  Gutter& operator=(const Gutter&);

protected:
  explicit Gutter(const Glib::ConstructParams& construct_params);
  explicit Gutter(GtkSourceGutter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Gutter();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceGutter*       gobj()       { return reinterpret_cast<GtkSourceGutter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceGutter* gobj() const { return reinterpret_cast<GtkSourceGutter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceGutter* gobj_copy();

private:


public:
// TODO: remove it later - it should take a conversion definition from gtkmm,
// but it fails with some strange casting to GtkWindowObject.
 

  /** Get the Gdk::Window of the gutter.
   *
   * The window will only be available when the gutter has at least one,
   * non-zero width, cell renderer packed.
   *
   * @return The Gdk::Window of the gutter, or empty Glib::RefPtr if the gutter
   * has no window.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<Gdk::Window> get_window();

  
  /** Get the Gdk::Window of the gutter.
   *
   * The window will only be available when the gutter has at least one,
   * non-zero width, cell renderer packed.
   *
   * @return The Gdk::Window of the gutter, or empty Glib::RefPtr if the gutter
   * has no window.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<const Gdk::Window> get_window() const;

  
  /** Insert @a renderer into the gutter. If @a renderer is yet unowned then gutter
   * claims its ownership. Otherwise just increases renderer's reference count.
   *  @a renderer cannot be already inserted to another gutter.
   * 
   * @newin{3,0}
   * @param renderer A gutter renderer (must inherit from Gtk::SourceGutterRenderer).
   * @param position The renderer position.
   * @return <tt>true</tt> if operation succeeded. Otherwise <tt>false</tt>.
   */
  void insert(GutterRenderer* renderer, int position);

  
  /** Removes @a renderer from @a gutter.
   * 
   * @newin{2,8}
   * @param renderer A Gtk::SourceGutterRenderer.
   */
  void remove(GutterRenderer* renderer);

  
  /** Reorders @a renderer in @a gutter to new @a position.
   * 
   * @newin{2,8}
   * @param renderer A Gtk::CellRenderer.
   * @param position The new renderer position.
   */
  void reorder(GutterRenderer* renderer, int position);

  
  /** Invalidates the drawable area of the gutter. You can use this to force a
   * redraw of the gutter if something has changed and needs to be redrawn.
   * 
   * @newin{2,8}
   */
  void queue_draw();

  
  void set_padding(int xpad, int ypad);

  // TODO: create a Padding class.

  
  void get_padding(int& xpad, int& ypad) const;

  
  /** Finds the Gtk::SourceGutterRenderer at (x, y).
   * @param x The x position to get identified.
   * @param y The y position to get identified.
   * @return The renderer at (x, y) or <tt>0</tt>.
   */
  GutterRenderer* get_renderer_at_pos(int x, int y);

  
  /** Finds the Gtk::SourceGutterRenderer at (x, y).
   * @param x The x position to get identified.
   * @param y The y position to get identified.
   * @return The renderer at (x, y) or <tt>0</tt>.
   */
  const GutterRenderer* get_renderer_at_pos(int x, int y) const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The gutters' GtkSourceView.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<View*> property_view() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The gutters text window type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::TextWindowType> property_window_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The x-padding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_xpad() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The x-padding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_xpad() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The y-padding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_ypad() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The y-padding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_ypad() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gsv


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::Gutter
   */
  Glib::RefPtr<Gsv::Gutter> wrap(GtkSourceGutter* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_GUTTER_H */

