//Original:/proj/frio/dv/testcases/seq/se_undefinedinstruction3/se_undefinedinstruction3.dsp
// Description: 32 bit special cases Undefined Instructions in Supervisor Mode
# mach: bfin
# sim: --environment operating
# xfail: "missing checks in A0/A1 macfunc" *-*

#include "test.h"
.include "testutils.inc"
start

//
// Constants and Defines
//

include(gen_int.inc)
include(selfcheck.inc)
include(std.inc)
include(mmrs.inc)
include(symtable.inc)

#ifndef STACKSIZE
#define STACKSIZE 0x10   // change for how much stack you need
#endif
#ifndef ITABLE
#define ITABLE 0xF0000000
#endif

GEN_INT_INIT(ITABLE) // set location for interrupt table

//
// Reset/Bootstrap Code
//   (Here we should set the processor operating modes, initialize registers,
//    etc.)
//

BOOT:
INIT_R_REGS(0);     // initialize general purpose regs

INIT_P_REGS(0);     // initialize the pointers

INIT_I_REGS(0);     // initialize the dsp address regs
INIT_M_REGS(0);
INIT_L_REGS(0);
INIT_B_REGS(0);

CLI R1;           // inhibit events during MMR writes

LD32_LABEL(sp, USTACK);   // setup the user stack pointer
USP = SP;

LD32_LABEL(sp, KSTACK);   // setup the kernel stack pointer
FP = SP;        // and frame pointer

LD32(p0, EVT0);      // Setup Event Vectors and Handlers

    P0 += 4;            // EVT0 not used (Emulation)

    P0 += 4;            // EVT1 not used (Reset)

LD32_LABEL(r0, NHANDLE);  // NMI Handler (Int2)
    [ P0 ++ ] = R0;

LD32_LABEL(r0, XHANDLE);  // Exception Handler (Int3)
    [ P0 ++ ] = R0;

    P0 += 4;            // EVT4 not used (Global Interrupt Enable)

LD32_LABEL(r0, HWHANDLE); // HW Error Handler (Int5)
    [ P0 ++ ] = R0;

LD32_LABEL(r0, THANDLE);  // Timer Handler (Int6)
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I7HANDLE); // IVG7 Handler
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I8HANDLE); // IVG8 Handler
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I9HANDLE); // IVG9 Handler
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I10HANDLE);// IVG10 Handler
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I11HANDLE);// IVG11 Handler
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I12HANDLE);// IVG12 Handler
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I13HANDLE);// IVG13 Handler
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I14HANDLE);// IVG14 Handler
    [ P0 ++ ] = R0;

LD32_LABEL(r0, I15HANDLE);// IVG15 Handler
    [ P0 ++ ] = R0;

LD32(p0, EVT_OVERRIDE);
    R0 = 0;
    [ P0 ++ ] = R0;

    R1 = -1;     // Change this to mask interrupts (*)
CSYNC;       // wait for MMR writes to finish
STI R1;      // sync and reenable events (implicit write to IMASK)

DUMMY:

    A0 = 0;         // reset accumulators
    A1 = 0;

    R0 = 0 (Z);

LT0 = r0;       // set loop counters to something deterministic
LB0 = r0;
LC0 = r0;
LT1 = r0;
LB1 = r0;
LC1 = r0;

ASTAT = r0;     // reset other internal regs
SYSCFG = r0;
RETS = r0;      // prevent X's breaking LINK instruction

// The following code sets up the test for running in USER mode

LD32_LABEL(r0, STARTUSER);// One gets to user mode by doing a
                        // ReturnFromInterrupt (RTI)
RETI = r0;      // We need to load the return address

// Comment the following line for a USER Mode test

JUMP    STARTSUP;   // jump to code start for SUPERVISOR mode

RTI;

STARTSUP:
LD32_LABEL(p1, BEGIN);

LD32(p0, EVT15);

CLI R1;   // inhibit events during write to MMR
    [ P0 ] = P1;  // IVG15 (General) handler (Int 15) load with start
CSYNC;      // wait for it
STI R1;     // reenable events with proper imask

RAISE 15;       // after we RTI, INT 15 should be taken

RTI;

//
// The Main Program
//

STARTUSER:

LINK 0;     // change for how much stack frame space you need.

JUMP BEGIN;

//*********************************************************************

BEGIN:

                // COMMENT the following line for USER MODE tests
    [ -- SP ] = RETI;  // enable interrupts in supervisor mode

                // **** YOUR CODE GOES HERE ****

    // count of UI's will be in r5, which was initialized to 0 by header

    .dw 0xE802 ;
    .dw 0xB3FD ;
    .dw 0xE803 ;
    .dw 0xD461 ;
    .dw 0xE804 ;
    .dw 0x36A1 ;
    .dw 0xE805 ;
    .dw 0x7FED ;
    .dw 0xE806 ;
    .dw 0xFEB3 ;
    .dw 0xE807 ;
    .dw 0x8785 ;
    .dw 0xE808 ;
    .dw 0x2F21 ;
    .dw 0xE809 ;
    .dw 0x2889 ;
    .dw 0xE80A ;
    .dw 0x96B7 ;
    .dw 0xE80B ;
    .dw 0x8357 ;
    .dw 0xE80C ;
    .dw 0x5D07 ;
    .dw 0xE80D ;
    .dw 0x13D5 ;
    .dw 0xE80E ;
    .dw 0x1C11 ;
    .dw 0xE80F ;
    .dw 0x19D3 ;
    .dw 0xE810 ;
    .dw 0xBF4B ;
    .dw 0xE811 ;
    .dw 0xEF89 ;
    .dw 0xE812 ;
    .dw 0x2BD ;
    .dw 0xE813 ;
    .dw 0x6FC5 ;
    .dw 0xE814 ;
    .dw 0x89F1 ;
    .dw 0xE815 ;
    .dw 0x1D13 ;
    .dw 0xE816 ;
    .dw 0xA03F ;
    .dw 0xE817 ;
    .dw 0x9681 ;
    .dw 0xE818 ;
    .dw 0x2961 ;
    .dw 0xE819 ;
    .dw 0xEE23 ;
    .dw 0xE81A ;
    .dw 0x7ABB ;
    .dw 0xE81B ;
    .dw 0x8927 ;
    .dw 0xE81C ;
    .dw 0x2343 ;
    .dw 0xE81D ;
    .dw 0x308F ;
    .dw 0xE81E ;
    .dw 0x718F ;
    .dw 0xE81F ;
    .dw 0xC549 ;
    .dw 0xE820 ;
    .dw 0x2CD3 ;
    .dw 0xE821 ;
    .dw 0x81D9 ;
    .dw 0xE822 ;
    .dw 0xD76B ;
    .dw 0xE823 ;
    .dw 0xB735 ;
    .dw 0xE824 ;
    .dw 0x4EBB ;
    .dw 0xE825 ;
    .dw 0x6223 ;
    .dw 0xE826 ;
    .dw 0x15EB ;
    .dw 0xE827 ;
    .dw 0xB19F ;
    .dw 0xE828 ;
    .dw 0x6E6B ;
    .dw 0xE829 ;
    .dw 0x7EA3 ;
    .dw 0xE82A ;
    .dw 0xF2A7 ;
    .dw 0xE82B ;
    .dw 0xA8E1 ;
    .dw 0xE82C ;
    .dw 0x14ED ;
    .dw 0xE82D ;
    .dw 0x2BA5 ;
    .dw 0xE82E ;
    .dw 0xDD5 ;
    .dw 0xE82F ;
    .dw 0x69AD ;
    .dw 0xE830 ;
    .dw 0xCB47 ;
    .dw 0xE831 ;
    .dw 0x85F7 ;
    .dw 0xE832 ;
    .dw 0xB25D ;
    .dw 0xE833 ;
    .dw 0x8351 ;
    .dw 0xE834 ;
    .dw 0xE445 ;
    .dw 0xE835 ;
    .dw 0x33E5 ;
    .dw 0xE836 ;
    .dw 0x8F6B ;
    .dw 0xE837 ;
    .dw 0x9D5B ;
    .dw 0xE838 ;
    .dw 0xBE1 ;
    .dw 0xE839 ;
    .dw 0x3DB9 ;
    .dw 0xE83A ;
    .dw 0x7391 ;
    .dw 0xE83B ;
    .dw 0x70E5 ;
    .dw 0xE83C ;
    .dw 0x7409 ;
    .dw 0xE83D ;
    .dw 0xF5A9 ;
    .dw 0xE83E ;
    .dw 0xA15B ;
    .dw 0xE83F ;
    .dw 0x1D3F ;
    .dw 0xE840 ;
    .dw 0xF709 ;
    .dw 0xE841 ;
    .dw 0x6751 ;
    .dw 0xE842 ;
    .dw 0xD565 ;
    .dw 0xE843 ;
    .dw 0x1035 ;
    .dw 0xE844 ;
    .dw 0x755 ;
    .dw 0xE845 ;
    .dw 0x46AD ;
    .dw 0xE846 ;
    .dw 0x95F3 ;
    .dw 0xE847 ;
    .dw 0x39B3 ;
    .dw 0xE848 ;
    .dw 0xC4EB ;
    .dw 0xE849 ;
    .dw 0xD693 ;
    .dw 0xE84A ;
    .dw 0xE40F ;
    .dw 0xE84B ;
    .dw 0xC30F ;
    .dw 0xE84C ;
    .dw 0x101F ;
    .dw 0xE84D ;
    .dw 0xBEA7 ;
    .dw 0xE84E ;
    .dw 0xE617 ;
    .dw 0xE84F ;
    .dw 0x1BD ;
    .dw 0xE850 ;
    .dw 0xF203 ;
    .dw 0xE851 ;
    .dw 0x48D5 ;
    .dw 0xE852 ;
    .dw 0xA3DD ;
    .dw 0xE853 ;
    .dw 0xDD7F ;
    .dw 0xE854 ;
    .dw 0x3233 ;
    .dw 0xE855 ;
    .dw 0xFE45 ;
    .dw 0xE856 ;
    .dw 0x6C3D ;
    .dw 0xE857 ;
    .dw 0x6225 ;
    .dw 0xE858 ;
    .dw 0x722F ;
    .dw 0xE859 ;
    .dw 0x1BDD ;
    .dw 0xE85A ;
    .dw 0xFC35 ;
    .dw 0xE85B ;
    .dw 0xB4C1 ;
    .dw 0xE85C ;
    .dw 0xA635 ;
    .dw 0xE85D ;
    .dw 0xD62D ;
    .dw 0xE85E ;
    .dw 0xFF7D ;
    .dw 0xE85F ;
    .dw 0x2463 ;
    .dw 0xE860 ;
    .dw 0x439B ;
    .dw 0xE861 ;
    .dw 0xE4EF ;
    .dw 0xE862 ;
    .dw 0x299 ;
    .dw 0xE863 ;
    .dw 0x8E4F ;
    .dw 0xE864 ;
    .dw 0xFCA1 ;
    .dw 0xE865 ;
    .dw 0x4DFD ;
    .dw 0xE866 ;
    .dw 0x6E7D ;
    .dw 0xE867 ;
    .dw 0xCDAF ;
    .dw 0xE868 ;
    .dw 0x61D1 ;
    .dw 0xE869 ;
    .dw 0xE7C7 ;
    .dw 0xE86A ;
    .dw 0xA59D ;
    .dw 0xE86B ;
    .dw 0x6ED7 ;
    .dw 0xE86C ;
    .dw 0x40CF ;
    .dw 0xE86D ;
    .dw 0x8B4B ;
    .dw 0xE86E ;
    .dw 0xDA83 ;
    .dw 0xE86F ;
    .dw 0x5DF1 ;
    .dw 0xE870 ;
    .dw 0x18B5 ;
    .dw 0xE871 ;
    .dw 0x6D91 ;
    .dw 0xE872 ;
    .dw 0xB7EF ;
    .dw 0xE873 ;
    .dw 0xC941 ;
    .dw 0xE874 ;
    .dw 0x7BE9 ;
    .dw 0xE875 ;
    .dw 0x98A3 ;
    .dw 0xE876 ;
    .dw 0x7269 ;
    .dw 0xE877 ;
    .dw 0xEECF ;
    .dw 0xE878 ;
    .dw 0xB77B ;
    .dw 0xE879 ;
    .dw 0xFBFD ;
    .dw 0xE87A ;
    .dw 0x5B59 ;
    .dw 0xE87B ;
    .dw 0xDAD ;
    .dw 0xE87C ;
    .dw 0x97F5 ;
    .dw 0xE87D ;
    .dw 0xC8B ;
    .dw 0xE87E ;
    .dw 0x8DA1 ;
    .dw 0xE87F ;
    .dw 0x32A5 ;
    .dw 0xE880 ;
    .dw 0xA3B7 ;
    .dw 0xE881 ;
    .dw 0x6C27 ;
    .dw 0xE882 ;
    .dw 0xCBB7 ;
    .dw 0xE883 ;
    .dw 0x1873 ;
    .dw 0xE884 ;
    .dw 0xA2CF ;
    .dw 0xE885 ;
    .dw 0x9083 ;
    .dw 0xE886 ;
    .dw 0x2737 ;
    .dw 0xE887 ;
    .dw 0xD383 ;
    .dw 0xE888 ;
    .dw 0xCC51 ;
    .dw 0xE889 ;
    .dw 0xE1AD ;
    .dw 0xE88A ;
    .dw 0x8A01 ;
    .dw 0xE88B ;
    .dw 0x8123 ;
    .dw 0xE88C ;
    .dw 0x712D ;
    .dw 0xE88D ;
    .dw 0x47FF ;
    .dw 0xE88E ;
    .dw 0xB8CD ;
    .dw 0xE88F ;
    .dw 0xB23B ;
    .dw 0xE890 ;
    .dw 0x7C89 ;
    .dw 0xE891 ;
    .dw 0xA19F ;
    .dw 0xE892 ;
    .dw 0xE745 ;
    .dw 0xE893 ;
    .dw 0xC985 ;
    .dw 0xE894 ;
    .dw 0xA199 ;
    .dw 0xE895 ;
    .dw 0x176F ;
    .dw 0xE896 ;
    .dw 0x759D ;
    .dw 0xE897 ;
    .dw 0x54B ;
    .dw 0xE898 ;
    .dw 0x8EF7 ;
    .dw 0xE899 ;
    .dw 0xC987 ;
    .dw 0xE89A ;
    .dw 0xEFAB ;
    .dw 0xE89B ;
    .dw 0x6C97 ;
    .dw 0xE89C ;
    .dw 0xFF7B ;
    .dw 0xE89D ;
    .dw 0xCB35 ;
    .dw 0xE89E ;
    .dw 0xE57B ;
    .dw 0xE89F ;
    .dw 0x57F1 ;
    .dw 0xE8A0 ;
    .dw 0x8F ;
    .dw 0xE8A1 ;
    .dw 0xE667 ;
    .dw 0xE8A2 ;
    .dw 0xB56F ;
    .dw 0xE8A3 ;
    .dw 0xCD93 ;
    .dw 0xE8A4 ;
    .dw 0x460F ;
    .dw 0xE8A5 ;
    .dw 0x1EAF ;
    .dw 0xE8A6 ;
    .dw 0xDFD1 ;
    .dw 0xE8A7 ;
    .dw 0x6921 ;
    .dw 0xE8A8 ;
    .dw 0xE397 ;
    .dw 0xE8A9 ;
    .dw 0x6BB9 ;
    .dw 0xE8AA ;
    .dw 0xFBEB ;
    .dw 0xE8AB ;
    .dw 0x6E7 ;
    .dw 0xE8AC ;
    .dw 0x4367 ;
    .dw 0xE8AD ;
    .dw 0xA337 ;
    .dw 0xE8AE ;
    .dw 0xE6A3 ;
    .dw 0xE8AF ;
    .dw 0xEA89 ;
    .dw 0xE8B0 ;
    .dw 0xB2B1 ;
    .dw 0xE8B1 ;
    .dw 0xA6D ;
    .dw 0xE8B2 ;
    .dw 0x428D ;
    .dw 0xE8B3 ;
    .dw 0x993D ;
    .dw 0xE8B4 ;
    .dw 0x5B73 ;
    .dw 0xE8B5 ;
    .dw 0x8717 ;
    .dw 0xE8B6 ;
    .dw 0xE189 ;
    .dw 0xE8B7 ;
    .dw 0x1F87 ;
    .dw 0xE8B8 ;
    .dw 0x3D3 ;
    .dw 0xE8B9 ;
    .dw 0xE7ED ;
    .dw 0xE8BA ;
    .dw 0x2FDB ;
    .dw 0xE8BB ;
    .dw 0xFA71 ;
    .dw 0xE8BC ;
    .dw 0x6AF7 ;
    .dw 0xE8BD ;
    .dw 0x3C97 ;
    .dw 0xE8BE ;
    .dw 0x38B9 ;
    .dw 0xE8BF ;
    .dw 0x5C3B ;
    .dw 0xE8C0 ;
    .dw 0x9B53 ;
    .dw 0xE8C1 ;
    .dw 0xB51F ;
    .dw 0xE8C2 ;
    .dw 0x5C73 ;
    .dw 0xE8C3 ;
    .dw 0x49D ;
    .dw 0xE8C4 ;
    .dw 0xA8F ;
    .dw 0xE8C5 ;
    .dw 0xF3 ;
    .dw 0xE8C6 ;
    .dw 0x4FFB ;
    .dw 0xE8C7 ;
    .dw 0x6479 ;
    .dw 0xE8C8 ;
    .dw 0xDED5 ;
    .dw 0xE8C9 ;
    .dw 0xA557 ;
    .dw 0xE8CA ;
    .dw 0x7E0D ;
    .dw 0xE8CB ;
    .dw 0x4513 ;
    .dw 0xE8CC ;
    .dw 0x31AF ;
    .dw 0xE8CD ;
    .dw 0x4361 ;
    .dw 0xE8CE ;
    .dw 0x61B5 ;
    .dw 0xE8CF ;
    .dw 0xAACB ;
    .dw 0xE8D0 ;
    .dw 0xA85B ;
    .dw 0xE8D1 ;
    .dw 0x4569 ;
    .dw 0xE8D2 ;
    .dw 0xF277 ;
    .dw 0xE8D3 ;
    .dw 0x2B57 ;
    .dw 0xE8D4 ;
    .dw 0x39A5 ;
    .dw 0xE8D5 ;
    .dw 0xEC0F ;
    .dw 0xE8D6 ;
    .dw 0xB9DF ;
    .dw 0xE8D7 ;
    .dw 0x6F75 ;
    .dw 0xE8D8 ;
    .dw 0x793F ;
    .dw 0xE8D9 ;
    .dw 0x32A1 ;
    .dw 0xE8DA ;
    .dw 0xAA99 ;
    .dw 0xE8DB ;
    .dw 0x1829 ;
    .dw 0xE8DC ;
    .dw 0x4097 ;
    .dw 0xE8DD ;
    .dw 0x8323 ;
    .dw 0xE8DE ;
    .dw 0x510B ;
    .dw 0xE8DF ;
    .dw 0xBF73 ;
    .dw 0xE8E0 ;
    .dw 0xD31 ;
    .dw 0xE8E1 ;
    .dw 0xB1BD ;
    .dw 0xE8E2 ;
    .dw 0x756F ;
    .dw 0xE8E3 ;
    .dw 0x4C83 ;
    .dw 0xE8E4 ;
    .dw 0xEC7F ;
    .dw 0xE8E5 ;
    .dw 0x37BB ;
    .dw 0xE8E6 ;
    .dw 0xC767 ;
    .dw 0xE8E7 ;
    .dw 0x5379 ;
    .dw 0xE8E8 ;
    .dw 0x4D39 ;
    .dw 0xE8E9 ;
    .dw 0x25F9 ;
    .dw 0xE8EA ;
    .dw 0xAB13 ;
    .dw 0xE8EB ;
    .dw 0xB895 ;
    .dw 0xE8EC ;
    .dw 0x8E35 ;
    .dw 0xE8ED ;
    .dw 0xC6EB ;
    .dw 0xE8EE ;
    .dw 0xBFB3 ;
    .dw 0xE8EF ;
    .dw 0x4EF3 ;
    .dw 0xE8F0 ;
    .dw 0xA2B9 ;
    .dw 0xE8F1 ;
    .dw 0x6807 ;
    .dw 0xE8F2 ;
    .dw 0x37B3 ;
    .dw 0xE8F3 ;
    .dw 0xAAC3 ;
    .dw 0xE8F4 ;
    .dw 0xA461 ;
    .dw 0xE8F5 ;
    .dw 0x42C3 ;
    .dw 0xE8F6 ;
    .dw 0x9A4B ;
    .dw 0xE8F7 ;
    .dw 0xDF03 ;
    .dw 0xE8F8 ;
    .dw 0xAA6B ;
    .dw 0xE8F9 ;
    .dw 0xFD0F ;
    .dw 0xE8FA ;
    .dw 0x695 ;
    .dw 0xE8FB ;
    .dw 0x5EB1 ;
    .dw 0xE8FC ;
    .dw 0xBE8D ;
    .dw 0xE8FD ;
    .dw 0xB949 ;
    .dw 0xE8FE ;
    .dw 0x9023 ;
    .dw 0xE8FF ;
    .dw 0xB987 ;
    .dw 0xE900 ;
    .dw 0x475B ;
    .dw 0xE901 ;
    .dw 0x2DB5 ;
    .dw 0xE902 ;
    .dw 0xCD17 ;
    .dw 0xE903 ;
    .dw 0x6C33 ;
    .dw 0xE904 ;
    .dw 0xC013 ;
    .dw 0xE905 ;
    .dw 0xBB77 ;
    .dw 0xE906 ;
    .dw 0x2DC3 ;
    .dw 0xE907 ;
    .dw 0x7C11 ;
    .dw 0xE908 ;
    .dw 0x15F7 ;
    .dw 0xE909 ;
    .dw 0xFD0F ;
    .dw 0xE90A ;
    .dw 0x35B1 ;
    .dw 0xE90B ;
    .dw 0x165D ;
    .dw 0xE90C ;
    .dw 0x8327 ;
    .dw 0xE90D ;
    .dw 0xC449 ;
    .dw 0xE90E ;
    .dw 0x2E4F ;
    .dw 0xE90F ;
    .dw 0xEAEF ;
    .dw 0xE910 ;
    .dw 0x3EFB ;
    .dw 0xE911 ;
    .dw 0xFFB3 ;
    .dw 0xE912 ;
    .dw 0x6AF3 ;
    .dw 0xE913 ;
    .dw 0x7A73 ;
    .dw 0xE914 ;
    .dw 0xDBD7 ;
    .dw 0xE915 ;
    .dw 0x7FA7 ;
    .dw 0xE916 ;
    .dw 0xB681 ;
    .dw 0xE917 ;
    .dw 0x1023 ;
    .dw 0xE918 ;
    .dw 0xAA85 ;
    .dw 0xE919 ;
    .dw 0x12A9 ;
    .dw 0xE91A ;
    .dw 0x27F ;
    .dw 0xE91B ;
    .dw 0x9EF7 ;
    .dw 0xE91C ;
    .dw 0xFB09 ;
    .dw 0xE91D ;
    .dw 0xF179 ;
    .dw 0xE91E ;
    .dw 0xEFAD ;
    .dw 0xE91F ;
    .dw 0x3A67 ;
    .dw 0xE920 ;
    .dw 0x9301 ;
    .dw 0xE921 ;
    .dw 0xF273 ;
    .dw 0xE922 ;
    .dw 0x4819 ;
    .dw 0xE923 ;
    .dw 0x629F ;
    .dw 0xE924 ;
    .dw 0x3177 ;
    .dw 0xE925 ;
    .dw 0x7C9B ;
    .dw 0xE926 ;
    .dw 0x2BD ;
    .dw 0xE927 ;
    .dw 0xDC33 ;
    .dw 0xE928 ;
    .dw 0x783B ;
    .dw 0xE929 ;
    .dw 0xB20B ;
    .dw 0xE92A ;
    .dw 0xE895 ;
    .dw 0xE92B ;
    .dw 0x4B5D ;
    .dw 0xE92C ;
    .dw 0x12B7 ;
    .dw 0xE92D ;
    .dw 0xC9E7 ;
    .dw 0xE92E ;
    .dw 0x7335 ;
    .dw 0xE92F ;
    .dw 0x4AB1 ;
    .dw 0xE930 ;
    .dw 0x7251 ;
    .dw 0xE931 ;
    .dw 0x11E1 ;
    .dw 0xE932 ;
    .dw 0xFCE3 ;
    .dw 0xE933 ;
    .dw 0x3557 ;
    .dw 0xE934 ;
    .dw 0xF837 ;
    .dw 0xE935 ;
    .dw 0x8F27 ;
    .dw 0xE936 ;
    .dw 0xDA2F ;
    .dw 0xE937 ;
    .dw 0x5CC3 ;
    .dw 0xE938 ;
    .dw 0xE4BD ;
    .dw 0xE939 ;
    .dw 0xB6DF ;
    .dw 0xE93A ;
    .dw 0x7509 ;
    .dw 0xE93B ;
    .dw 0xE1EB ;
    .dw 0xE93C ;
    .dw 0xE439 ;
    .dw 0xE93D ;
    .dw 0x3621 ;
    .dw 0xE93E ;
    .dw 0x15D ;
    .dw 0xE93F ;
    .dw 0xEA05 ;
    .dw 0xE940 ;
    .dw 0x9151 ;
    .dw 0xE941 ;
    .dw 0x4169 ;
    .dw 0xE942 ;
    .dw 0xE325 ;
    .dw 0xE943 ;
    .dw 0x66B5 ;
    .dw 0xE944 ;
    .dw 0xC4DD ;
    .dw 0xE945 ;
    .dw 0x6395 ;
    .dw 0xE946 ;
    .dw 0x5E09 ;
    .dw 0xE947 ;
    .dw 0x29CD ;
    .dw 0xE948 ;
    .dw 0xB35 ;
    .dw 0xE949 ;
    .dw 0x4459 ;
    .dw 0xE94A ;
    .dw 0xA671 ;
    .dw 0xE94B ;
    .dw 0x7C83 ;
    .dw 0xE94C ;
    .dw 0x1715 ;
    .dw 0xE94D ;
    .dw 0x5E37 ;
    .dw 0xE94E ;
    .dw 0xEC19 ;
    .dw 0xE94F ;
    .dw 0xF227 ;
    .dw 0xE950 ;
    .dw 0x89E9 ;
    .dw 0xE951 ;
    .dw 0x1BFD ;
    .dw 0xE952 ;
    .dw 0x7637 ;
    .dw 0xE953 ;
    .dw 0xAE5B ;
    .dw 0xE954 ;
    .dw 0xE9AF ;
    .dw 0xE955 ;
    .dw 0x55B5 ;
    .dw 0xE956 ;
    .dw 0x6905 ;
    .dw 0xE957 ;
    .dw 0xD6D3 ;
    .dw 0xE958 ;
    .dw 0x1C47 ;
    .dw 0xE959 ;
    .dw 0xA523 ;
    .dw 0xE95A ;
    .dw 0x4CE1 ;
    .dw 0xE95B ;
    .dw 0x687F ;
    .dw 0xE95C ;
    .dw 0x404F ;
    .dw 0xE95D ;
    .dw 0x89B5 ;
    .dw 0xE95E ;
    .dw 0xEEE1 ;
    .dw 0xE95F ;
    .dw 0x2851 ;
    .dw 0xE960 ;
    .dw 0x3B7D ;
    .dw 0xE961 ;
    .dw 0xD409 ;
    .dw 0xE962 ;
    .dw 0xB2ED ;
    .dw 0xE963 ;
    .dw 0xE767 ;
    .dw 0xE964 ;
    .dw 0xD673 ;
    .dw 0xE965 ;
    .dw 0x50D5 ;
    .dw 0xE966 ;
    .dw 0xEF57 ;
    .dw 0xE967 ;
    .dw 0xD2D1 ;
    .dw 0xE968 ;
    .dw 0xBE17 ;
    .dw 0xE969 ;
    .dw 0x2B6B ;
    .dw 0xE96A ;
    .dw 0x69F1 ;
    .dw 0xE96B ;
    .dw 0x6C1 ;
    .dw 0xE96C ;
    .dw 0x426F ;
    .dw 0xE96D ;
    .dw 0xFFA9 ;
    .dw 0xE96E ;
    .dw 0x8EA9 ;
    .dw 0xE96F ;
    .dw 0x1D41 ;
    .dw 0xE970 ;
    .dw 0x2AF5 ;
    .dw 0xE971 ;
    .dw 0x1379 ;
    .dw 0xE972 ;
    .dw 0x779D ;
    .dw 0xE973 ;
    .dw 0xF075 ;
    .dw 0xE974 ;
    .dw 0x7871 ;
    .dw 0xE975 ;
    .dw 0xAFC1 ;
    .dw 0xE976 ;
    .dw 0x5EB3 ;
    .dw 0xE977 ;
    .dw 0x4845 ;
    .dw 0xE978 ;
    .dw 0x6C4F ;
    .dw 0xE979 ;
    .dw 0x10E1 ;
    .dw 0xE97A ;
    .dw 0x90B7 ;
    .dw 0xE97B ;
    .dw 0xABA3 ;
    .dw 0xE97C ;
    .dw 0xAD7B ;
    .dw 0xE97D ;
    .dw 0xE6A3 ;
    .dw 0xE97E ;
    .dw 0x79E9 ;
    .dw 0xE97F ;
    .dw 0xD37 ;
    .dw 0xE980 ;
    .dw 0xE2B5 ;
    .dw 0xE981 ;
    .dw 0xDBBF ;
    .dw 0xE982 ;
    .dw 0xE41D ;
    .dw 0xE983 ;
    .dw 0x8BA3 ;
    .dw 0xE984 ;
    .dw 0x9A6B ;
    .dw 0xE985 ;
    .dw 0x1CCB ;
    .dw 0xE986 ;
    .dw 0xFE53 ;
    .dw 0xE987 ;
    .dw 0xFD2D ;
    .dw 0xE988 ;
    .dw 0xD811 ;
    .dw 0xE989 ;
    .dw 0x56B1 ;
    .dw 0xE98A ;
    .dw 0x45C9 ;
    .dw 0xE98B ;
    .dw 0x7F05 ;
    .dw 0xE98C ;
    .dw 0x1EF7 ;
    .dw 0xE98D ;
    .dw 0x24AF ;
    .dw 0xE98E ;
    .dw 0xE895 ;
    .dw 0xE98F ;
    .dw 0xBFF1 ;
    .dw 0xE990 ;
    .dw 0x52A5 ;
    .dw 0xE991 ;
    .dw 0x65C7 ;
    .dw 0xE992 ;
    .dw 0xB9C5 ;
    .dw 0xE993 ;
    .dw 0x3E8F ;
    .dw 0xE994 ;
    .dw 0x44AB ;
    .dw 0xE995 ;
    .dw 0x71BD ;
    .dw 0xE996 ;
    .dw 0x4EEB ;
    .dw 0xE997 ;
    .dw 0x3307 ;
    .dw 0xE998 ;
    .dw 0x4807 ;
    .dw 0xE999 ;
    .dw 0xA58B ;
    .dw 0xE99A ;
    .dw 0x5F3B ;
    .dw 0xE99B ;
    .dw 0x5C45 ;
    .dw 0xE99C ;
    .dw 0xA1EB ;
    .dw 0xE99D ;
    .dw 0x3F5B ;
    .dw 0xE99E ;
    .dw 0xFC25 ;
    .dw 0xE99F ;
    .dw 0x68AD ;
    .dw 0xE9A0 ;
    .dw 0x3029 ;
    .dw 0xE9A1 ;
    .dw 0x1FD ;
    .dw 0xE9A2 ;
    .dw 0xBB69 ;
    .dw 0xE9A3 ;
    .dw 0x3259 ;
    .dw 0xE9A4 ;
    .dw 0x1CF5 ;
    .dw 0xE9A5 ;
    .dw 0x97E5 ;
    .dw 0xE9A6 ;
    .dw 0x6AB1 ;
    .dw 0xE9A7 ;
    .dw 0x86D3 ;
    .dw 0xE9A8 ;
    .dw 0xF853 ;
    .dw 0xE9A9 ;
    .dw 0x2D9B ;
    .dw 0xE9AA ;
    .dw 0x64A5 ;
    .dw 0xE9AB ;
    .dw 0xB23F ;
    .dw 0xE9AC ;
    .dw 0xEDD ;
    .dw 0xE9AD ;
    .dw 0x3BB5 ;
    .dw 0xE9AE ;
    .dw 0x1F8F ;
    .dw 0xE9AF ;
    .dw 0x8627 ;
    .dw 0xE9B0 ;
    .dw 0x5627 ;
    .dw 0xE9B1 ;
    .dw 0xF853 ;
    .dw 0xE9B2 ;
    .dw 0xD5F ;
    .dw 0xE9B3 ;
    .dw 0x139F ;
    .dw 0xE9B4 ;
    .dw 0xC691 ;
    .dw 0xE9B5 ;
    .dw 0x6815 ;
    .dw 0xE9B6 ;
    .dw 0x655B ;
    .dw 0xE9B7 ;
    .dw 0xD10B ;
    .dw 0xE9B8 ;
    .dw 0x7A9D ;
    .dw 0xE9B9 ;
    .dw 0x868F ;
    .dw 0xE9BA ;
    .dw 0xEF1F ;
    .dw 0xE9BB ;
    .dw 0x6355 ;
    .dw 0xE9BC ;
    .dw 0x6BD3 ;
    .dw 0xE9BD ;
    .dw 0x7E4B ;
    .dw 0xE9BE ;
    .dw 0x6747 ;
    .dw 0xE9BF ;
    .dw 0xC29D ;
    .dw 0xE9C0 ;
    .dw 0x2507 ;
    .dw 0xE9C1 ;
    .dw 0x6833 ;
    .dw 0xE9C2 ;
    .dw 0x957F ;
    .dw 0xE9C3 ;
    .dw 0xF27B ;
    .dw 0xE9C4 ;
    .dw 0x4241 ;
    .dw 0xE9C5 ;
    .dw 0x8A97 ;
    .dw 0xE9C6 ;
    .dw 0xAC1D ;
    .dw 0xE9C7 ;
    .dw 0x5B1 ;
    .dw 0xE9C8 ;
    .dw 0x160B ;
    .dw 0xE9C9 ;
    .dw 0x8F99 ;
    .dw 0xE9CA ;
    .dw 0x939 ;
    .dw 0xE9CB ;
    .dw 0xA561 ;
    .dw 0xE9CC ;
    .dw 0x4C51 ;
    .dw 0xE9CD ;
    .dw 0xAB2D ;
    .dw 0xE9CE ;
    .dw 0xF143 ;
    .dw 0xE9CF ;
    .dw 0xD3CF ;
    .dw 0xE9D0 ;
    .dw 0xE2AD ;
    .dw 0xE9D1 ;
    .dw 0x288F ;
    .dw 0xE9D2 ;
    .dw 0x5B1D ;
    .dw 0xE9D3 ;
    .dw 0x228F ;
    .dw 0xE9D4 ;
    .dw 0x4E4D ;
    .dw 0xE9D5 ;
    .dw 0x573B ;
    .dw 0xE9D6 ;
    .dw 0x65B1 ;
    .dw 0xE9D7 ;
    .dw 0x143F ;
    .dw 0xE9D8 ;
    .dw 0x2743 ;
    .dw 0xE9D9 ;
    .dw 0x4F61 ;
    .dw 0xE9DA ;
    .dw 0x8F0F ;
    .dw 0xE9DB ;
    .dw 0xE1C5 ;
    .dw 0xE9DC ;
    .dw 0x315D ;
    .dw 0xE9DD ;
    .dw 0x85E7 ;
    .dw 0xE9DE ;
    .dw 0x44FB ;
    .dw 0xE9DF ;
    .dw 0x5AFB ;
    .dw 0xE9E0 ;
    .dw 0x1A81 ;
    .dw 0xE9E1 ;
    .dw 0xA7D3 ;
    .dw 0xE9E2 ;
    .dw 0xE70F ;
    .dw 0xE9E3 ;
    .dw 0x1AF7 ;
    .dw 0xE9E4 ;
    .dw 0xC67D ;
    .dw 0xE9E5 ;
    .dw 0xB54D ;
    .dw 0xE9E6 ;
    .dw 0xD24B ;
    .dw 0xE9E7 ;
    .dw 0xC7B7 ;
    .dw 0xE9E8 ;
    .dw 0x806B ;
    .dw 0xE9E9 ;
    .dw 0xD419 ;
    .dw 0xE9EA ;
    .dw 0x8E35 ;
    .dw 0xE9EB ;
    .dw 0x955B ;
    .dw 0xE9EC ;
    .dw 0xE981 ;
    .dw 0xE9ED ;
    .dw 0xD187 ;
    .dw 0xE9EE ;
    .dw 0xB365 ;
    .dw 0xE9EF ;
    .dw 0xC4DF ;
    .dw 0xE9F0 ;
    .dw 0xFD67 ;
    .dw 0xE9F1 ;
    .dw 0xCBEB ;
    .dw 0xE9F2 ;
    .dw 0xA3AD ;
    .dw 0xE9F3 ;
    .dw 0x5653 ;
    .dw 0xE9F4 ;
    .dw 0x415 ;
    .dw 0xE9F5 ;
    .dw 0xFB9F ;
    .dw 0xE9F6 ;
    .dw 0xABA3 ;
    .dw 0xE9F7 ;
    .dw 0xA695 ;
    .dw 0xE9F8 ;
    .dw 0xC929 ;
    .dw 0xE9F9 ;
    .dw 0x136F ;
    .dw 0xE9FA ;
    .dw 0xA5BF ;
    .dw 0xE9FB ;
    .dw 0x3083 ;
    .dw 0xE9FC ;
    .dw 0xF0BF ;
    .dw 0xE9FD ;
    .dw 0x309B ;
    .dw 0xE9FE ;
    .dw 0xB6F5 ;
    .dw 0xE9FF ;
    .dw 0x29B7 ;
    .dw 0xEA00 ;
    .dw 0xC1C5 ;
    .dw 0xEA01 ;
    .dw 0xD249 ;
    .dw 0xEA02 ;
    .dw 0x3CCB ;
    .dw 0xEA03 ;
    .dw 0x32BF ;
    .dw 0xEA04 ;
    .dw 0x3DDB ;
    .dw 0xEA05 ;
    .dw 0xD07B ;
    .dw 0xEA06 ;
    .dw 0x84EB ;
    .dw 0xEA07 ;
    .dw 0xD2D7 ;
    .dw 0xEA08 ;
    .dw 0xDEA3 ;
    .dw 0xEA09 ;
    .dw 0xCA8F ;
    .dw 0xEA0A ;
    .dw 0x6645 ;
    .dw 0xEA0B ;
    .dw 0xF71B ;
    .dw 0xEA0C ;
    .dw 0xD09F ;
    .dw 0xEA0D ;
    .dw 0x533 ;
    .dw 0xEA0E ;
    .dw 0x53A3 ;
    .dw 0xEA0F ;
    .dw 0x2D41 ;
    .dw 0xEA10 ;
    .dw 0x383 ;
    .dw 0xEA11 ;
    .dw 0x2FD7 ;
    .dw 0xEA12 ;
    .dw 0xFFBF ;
    .dw 0xEA13 ;
    .dw 0xD1DB ;
    .dw 0xEA14 ;
    .dw 0xE815 ;
    .dw 0xEA15 ;
    .dw 0x9B1 ;
    .dw 0xEA16 ;
    .dw 0x2ADB ;
    .dw 0xEA17 ;
    .dw 0xE9FB ;
    .dw 0xEA18 ;
    .dw 0x337F ;
    .dw 0xEA19 ;
    .dw 0x5E29 ;
    .dw 0xEA1A ;
    .dw 0xB1DD ;
    .dw 0xEA1B ;
    .dw 0xE07F ;
    .dw 0xEA1C ;
    .dw 0x8025 ;
    .dw 0xEA1D ;
    .dw 0x50DB ;
    .dw 0xEA1E ;
    .dw 0x76E3 ;
    .dw 0xEA1F ;
    .dw 0xDEBF ;
    .dw 0xEA20 ;
    .dw 0x2407 ;
    .dw 0xEA21 ;
    .dw 0x7107 ;
    .dw 0xEA22 ;
    .dw 0x3B5F ;
    .dw 0xEA23 ;
    .dw 0xF8C1 ;
    .dw 0xEA24 ;
    .dw 0x148B ;
    .dw 0xEA25 ;
    .dw 0x8C8D ;
    .dw 0xEA26 ;
    .dw 0x3A9 ;
    .dw 0xEA27 ;
    .dw 0xE4FF ;
    .dw 0xEA28 ;
    .dw 0x2FE3 ;
    .dw 0xEA29 ;
    .dw 0xBA69 ;
    .dw 0xEA2A ;
    .dw 0x1C1D ;
    .dw 0xEA2B ;
    .dw 0x7791 ;
    .dw 0xEA2C ;
    .dw 0xC3D9 ;
    .dw 0xEA2D ;
    .dw 0x94A1 ;
    .dw 0xEA2E ;
    .dw 0x57AD ;
    .dw 0xEA2F ;
    .dw 0x98EB ;
    .dw 0xEA30 ;
    .dw 0xAA33 ;
    .dw 0xEA31 ;
    .dw 0x19C3 ;
    .dw 0xEA32 ;
    .dw 0xA003 ;
    .dw 0xEA33 ;
    .dw 0xF015 ;
    .dw 0xEA34 ;
    .dw 0xD27F ;
    .dw 0xEA35 ;
    .dw 0x2DE1 ;
    .dw 0xEA36 ;
    .dw 0x6F0B ;
    .dw 0xEA37 ;
    .dw 0xF863 ;
    .dw 0xEA38 ;
    .dw 0x9173 ;
    .dw 0xEA39 ;
    .dw 0x32FD ;
    .dw 0xEA3A ;
    .dw 0x4A19 ;
    .dw 0xEA3B ;
    .dw 0xBAAB ;
    .dw 0xEA3C ;
    .dw 0x8DC1 ;
    .dw 0xEA3D ;
    .dw 0xB113 ;
    .dw 0xEA3E ;
    .dw 0xD677 ;
    .dw 0xEA3F ;
    .dw 0xE203 ;
    .dw 0xEA40 ;
    .dw 0xA271 ;
    .dw 0xEA41 ;
    .dw 0x857B ;
    .dw 0xEA42 ;
    .dw 0x9F7F ;
    .dw 0xEA43 ;
    .dw 0x63EF ;
    .dw 0xEA44 ;
    .dw 0x8EBB ;
    .dw 0xEA45 ;
    .dw 0x91F7 ;
    .dw 0xEA46 ;
    .dw 0x2639 ;
    .dw 0xEA47 ;
    .dw 0x7421 ;
    .dw 0xEA48 ;
    .dw 0xCB59 ;
    .dw 0xEA49 ;
    .dw 0x6317 ;
    .dw 0xEA4A ;
    .dw 0x5269 ;
    .dw 0xEA4B ;
    .dw 0xFBAF ;
    .dw 0xEA4C ;
    .dw 0x5D63 ;
    .dw 0xEA4D ;
    .dw 0xC63F ;
    .dw 0xEA4E ;
    .dw 0xDD33 ;
    .dw 0xEA4F ;
    .dw 0x4BC7 ;
    .dw 0xEA50 ;
    .dw 0xFEA7 ;
    .dw 0xEA51 ;
    .dw 0xC71F ;
    .dw 0xEA52 ;
    .dw 0xCD29 ;
    .dw 0xEA53 ;
    .dw 0x43F1 ;
    .dw 0xEA54 ;
    .dw 0x7383 ;
    .dw 0xEA55 ;
    .dw 0xC9D ;
    .dw 0xEA56 ;
    .dw 0x9BE5 ;
    .dw 0xEA57 ;
    .dw 0xA3BB ;
    .dw 0xEA58 ;
    .dw 0x6637 ;
    .dw 0xEA59 ;
    .dw 0xD5F ;
    .dw 0xEA5A ;
    .dw 0x1D23 ;
    .dw 0xEA5B ;
    .dw 0xBFF7 ;
    .dw 0xEA5C ;
    .dw 0x9FC3 ;
    .dw 0xEA5D ;
    .dw 0x13B5 ;
    .dw 0xEA5E ;
    .dw 0xBF5D ;
    .dw 0xEA5F ;
    .dw 0x5375 ;
    .dw 0xEA60 ;
    .dw 0xF639 ;
    .dw 0xEA61 ;
    .dw 0x8919 ;
    .dw 0xEA62 ;
    .dw 0x3DD9 ;
    .dw 0xEA63 ;
    .dw 0xA337 ;
    .dw 0xEA64 ;
    .dw 0xC89D ;
    .dw 0xEA65 ;
    .dw 0x8125 ;
    .dw 0xEA66 ;
    .dw 0x5C47 ;
    .dw 0xEA67 ;
    .dw 0xAE2B ;
    .dw 0xEA68 ;
    .dw 0x6035 ;
    .dw 0xEA69 ;
    .dw 0xFC07 ;
    .dw 0xEA6A ;
    .dw 0xC3DD ;
    .dw 0xEA6B ;
    .dw 0xA063 ;
    .dw 0xEA6C ;
    .dw 0xF69 ;
    .dw 0xEA6D ;
    .dw 0xD881 ;
    .dw 0xEA6E ;
    .dw 0x99E7 ;
    .dw 0xEA6F ;
    .dw 0x41C9 ;
    .dw 0xEA70 ;
    .dw 0x660F ;
    .dw 0xEA71 ;
    .dw 0xED5B ;
    .dw 0xEA72 ;
    .dw 0xE7E3 ;
    .dw 0xEA73 ;
    .dw 0x9861 ;
    .dw 0xEA74 ;
    .dw 0x534F ;
    .dw 0xEA75 ;
    .dw 0x4259 ;
    .dw 0xEA76 ;
    .dw 0x6D17 ;
    .dw 0xEA77 ;
    .dw 0x75F3 ;
    .dw 0xEA78 ;
    .dw 0x8CFB ;
    .dw 0xEA79 ;
    .dw 0xE0BD ;
    .dw 0xEA7A ;
    .dw 0xF1AD ;
    .dw 0xEA7B ;
    .dw 0x2951 ;
    .dw 0xEA7C ;
    .dw 0x1459 ;
    .dw 0xEA7D ;
    .dw 0x3331 ;
    .dw 0xEA7E ;
    .dw 0xB349 ;
    .dw 0xEA7F ;
    .dw 0xB03 ;
    .dw 0xEA80 ;
    .dw 0x308B ;
    .dw 0xEA81 ;
    .dw 0x6D4F ;
    .dw 0xEA82 ;
    .dw 0x31D ;
    .dw 0xEA83 ;
    .dw 0x1D8B ;
    .dw 0xEA84 ;
    .dw 0xB661 ;
    .dw 0xEA85 ;
    .dw 0xF289 ;
    .dw 0xEA86 ;
    .dw 0xAD87 ;
    .dw 0xEA87 ;
    .dw 0x790F ;
    .dw 0xEA88 ;
    .dw 0xF5AB ;
    .dw 0xEA89 ;
    .dw 0x34AD ;
    .dw 0xEA8A ;
    .dw 0x4327 ;
    .dw 0xEA8B ;
    .dw 0xBA9D ;
    .dw 0xEA8C ;
    .dw 0x241B ;
    .dw 0xEA8D ;
    .dw 0x1D5 ;
    .dw 0xEA8E ;
    .dw 0xDB77 ;
    .dw 0xEA8F ;
    .dw 0x2EE1 ;
    .dw 0xEA90 ;
    .dw 0x9D99 ;
    .dw 0xEA91 ;
    .dw 0xB9E5 ;
    .dw 0xEA92 ;
    .dw 0x68DD ;
    .dw 0xEA93 ;
    .dw 0xF053 ;
    .dw 0xEA94 ;
    .dw 0xD215 ;
    .dw 0xEA95 ;
    .dw 0x6383 ;
    .dw 0xEA96 ;
    .dw 0x3651 ;
    .dw 0xEA97 ;
    .dw 0xB0FD ;
    .dw 0xEA98 ;
    .dw 0x38ED ;
    .dw 0xEA99 ;
    .dw 0x1885 ;
    .dw 0xEA9A ;
    .dw 0xA665 ;
    .dw 0xEA9B ;
    .dw 0x67A9 ;
    .dw 0xEA9C ;
    .dw 0x21B5 ;
    .dw 0xEA9D ;
    .dw 0xC1F9 ;
    .dw 0xEA9E ;
    .dw 0xCBE7 ;
    .dw 0xEA9F ;
    .dw 0x989F ;
    .dw 0xEAA0 ;
    .dw 0xBA99 ;
    .dw 0xEAA1 ;
    .dw 0x9B8D ;
    .dw 0xEAA2 ;
    .dw 0xF3FB ;
    .dw 0xEAA3 ;
    .dw 0x71D9 ;
    .dw 0xEAA4 ;
    .dw 0x2435 ;
    .dw 0xEAA5 ;
    .dw 0x7693 ;
    .dw 0xEAA6 ;
    .dw 0xB9A7 ;
    .dw 0xEAA7 ;
    .dw 0x72BB ;
    .dw 0xEAA8 ;
    .dw 0xEAE7 ;
    .dw 0xEAA9 ;
    .dw 0x3475 ;
    .dw 0xEAAA ;
    .dw 0xBAF9 ;
    .dw 0xEAAB ;
    .dw 0xD74F ;
    .dw 0xEAAC ;
    .dw 0xBDAB ;
    .dw 0xEAAD ;
    .dw 0x70A9 ;
    .dw 0xEAAE ;
    .dw 0x8793 ;
    .dw 0xEAAF ;
    .dw 0x7EFD ;
    .dw 0xEAB0 ;
    .dw 0xBA75 ;
    .dw 0xEAB1 ;
    .dw 0xD231 ;
    .dw 0xEAB2 ;
    .dw 0xE0CB ;
    .dw 0xEAB3 ;
    .dw 0x86B9 ;
    .dw 0xEAB4 ;
    .dw 0x2805 ;
    .dw 0xEAB5 ;
    .dw 0xFC89 ;
    .dw 0xEAB6 ;
    .dw 0xE343 ;
    .dw 0xEAB7 ;
    .dw 0x4EC7 ;
    .dw 0xEAB8 ;
    .dw 0xF53F ;
    .dw 0xEAB9 ;
    .dw 0x982B ;
    .dw 0xEABA ;
    .dw 0x31FB ;
    .dw 0xEABB ;
    .dw 0x23F1 ;
    .dw 0xEABC ;
    .dw 0xD607 ;
    .dw 0xEABD ;
    .dw 0x6A79 ;
    .dw 0xEABE ;
    .dw 0xBAEB ;
    .dw 0xEABF ;
    .dw 0x4437 ;
    .dw 0xEAC0 ;
    .dw 0x5593 ;
    .dw 0xEAC1 ;
    .dw 0xF541 ;
    .dw 0xEAC2 ;
    .dw 0x2D23 ;
    .dw 0xEAC3 ;
    .dw 0x7711 ;
    .dw 0xEAC4 ;
    .dw 0xB64B ;
    .dw 0xEAC5 ;
    .dw 0x95B3 ;
    .dw 0xEAC6 ;
    .dw 0xB859 ;
    .dw 0xEAC7 ;
    .dw 0xF11F ;
    .dw 0xEAC8 ;
    .dw 0xF71B ;
    .dw 0xEAC9 ;
    .dw 0x9AD1 ;
    .dw 0xEACA ;
    .dw 0x2DFF ;
    .dw 0xEACB ;
    .dw 0xBB69 ;
    .dw 0xEACC ;
    .dw 0xD649 ;
    .dw 0xEACD ;
    .dw 0x4B71 ;
    .dw 0xEACE ;
    .dw 0x1BEB ;
    .dw 0xEACF ;
    .dw 0x560D ;
    .dw 0xEAD0 ;
    .dw 0x29D7 ;
    .dw 0xEAD1 ;
    .dw 0x53AD ;
    .dw 0xEAD2 ;
    .dw 0xF85B ;
    .dw 0xEAD3 ;
    .dw 0xCE81 ;
    .dw 0xEAD4 ;
    .dw 0x654F ;
    .dw 0xEAD5 ;
    .dw 0x91DF ;
    .dw 0xEAD6 ;
    .dw 0xF79D ;
    .dw 0xEAD7 ;
    .dw 0x143 ;
    .dw 0xEAD8 ;
    .dw 0xA521 ;
    .dw 0xEAD9 ;
    .dw 0xBB1B ;
    .dw 0xEADA ;
    .dw 0xA31F ;
    .dw 0xEADB ;
    .dw 0x3F17 ;
    .dw 0xEADC ;
    .dw 0x177D ;
    .dw 0xEADD ;
    .dw 0xCF23 ;
    .dw 0xEADE ;
    .dw 0xCA05 ;
    .dw 0xEADF ;
    .dw 0xDBD ;
    .dw 0xEAE0 ;
    .dw 0x1AA7 ;
    .dw 0xEAE1 ;
    .dw 0xD3DF ;
    .dw 0xEAE2 ;
    .dw 0xE347 ;
    .dw 0xEAE3 ;
    .dw 0x3C25 ;
    .dw 0xEAE4 ;
    .dw 0xE8D3 ;
    .dw 0xEAE5 ;
    .dw 0xD059 ;
    .dw 0xEAE6 ;
    .dw 0x7949 ;
    .dw 0xEAE7 ;
    .dw 0x22D ;
    .dw 0xEAE8 ;
    .dw 0x2975 ;
    .dw 0xEAE9 ;
    .dw 0x7F33 ;
    .dw 0xEAEA ;
    .dw 0xB6ED ;
    .dw 0xEAEB ;
    .dw 0x63D9 ;
    .dw 0xEAEC ;
    .dw 0x4025 ;
    .dw 0xEAED ;
    .dw 0xB09B ;
    .dw 0xEAEE ;
    .dw 0xAE2F ;
    .dw 0xEAEF ;
    .dw 0x9003 ;
    .dw 0xEAF0 ;
    .dw 0xB0EB ;
    .dw 0xEAF1 ;
    .dw 0xD3C7 ;
    .dw 0xEAF2 ;
    .dw 0x703D ;
    .dw 0xEAF3 ;
    .dw 0x729B ;
    .dw 0xEAF4 ;
    .dw 0x7221 ;
    .dw 0xEAF5 ;
    .dw 0x9FF1 ;
    .dw 0xEAF6 ;
    .dw 0x8F11 ;
    .dw 0xEAF7 ;
    .dw 0x325F ;
    .dw 0xEAF8 ;
    .dw 0x83C1 ;
    .dw 0xEAF9 ;
    .dw 0x54C7 ;
    .dw 0xEAFA ;
    .dw 0x2081 ;
    .dw 0xEAFB ;
    .dw 0xD20D ;
    .dw 0xEAFC ;
    .dw 0xA449 ;
    .dw 0xEAFD ;
    .dw 0x8A67 ;
    .dw 0xEAFE ;
    .dw 0xDAE1 ;
    .dw 0xEAFF ;
    .dw 0xAD1F ;
    .dw 0xEB00 ;
    .dw 0x7B07 ;
    .dw 0xEB01 ;
    .dw 0x8D3 ;
    .dw 0xEB02 ;
    .dw 0x6315 ;
    .dw 0xEB03 ;
    .dw 0x803 ;
    .dw 0xEB04 ;
    .dw 0xFFB ;
    .dw 0xEB05 ;
    .dw 0x9EF5 ;
    .dw 0xEB06 ;
    .dw 0x642B ;
    .dw 0xEB07 ;
    .dw 0x6BD5 ;
    .dw 0xEB08 ;
    .dw 0xE929 ;
    .dw 0xEB09 ;
    .dw 0x7107 ;
    .dw 0xEB0A ;
    .dw 0x8871 ;
    .dw 0xEB0B ;
    .dw 0x58F ;
    .dw 0xEB0C ;
    .dw 0xA56D ;
    .dw 0xEB0D ;
    .dw 0xB695 ;
    .dw 0xEB0E ;
    .dw 0xEC0F ;
    .dw 0xEB0F ;
    .dw 0xC0CD ;
    .dw 0xEB10 ;
    .dw 0x6CE3 ;
    .dw 0xEB11 ;
    .dw 0x5FF3 ;
    .dw 0xEB12 ;
    .dw 0x2123 ;
    .dw 0xEB13 ;
    .dw 0x55F9 ;
    .dw 0xEB14 ;
    .dw 0xEAB ;
    .dw 0xEB15 ;
    .dw 0x9B33 ;
    .dw 0xEB16 ;
    .dw 0x5D4D ;
    .dw 0xEB17 ;
    .dw 0x40D ;
    .dw 0xEB18 ;
    .dw 0x2451 ;
    .dw 0xEB19 ;
    .dw 0xB09F ;
    .dw 0xEB1A ;
    .dw 0xE8D1 ;
    .dw 0xEB1B ;
    .dw 0x2DC1 ;
    .dw 0xEB1C ;
    .dw 0x129B ;
    .dw 0xEB1D ;
    .dw 0x2EB5 ;
    .dw 0xEB1E ;
    .dw 0x6731 ;
    .dw 0xEB1F ;
    .dw 0x924D ;
    .dw 0xEB20 ;
    .dw 0x3FE3 ;
    .dw 0xEB21 ;
    .dw 0xDD91 ;
    .dw 0xEB22 ;
    .dw 0x113D ;
    .dw 0xEB23 ;
    .dw 0x599D ;
    .dw 0xEB24 ;
    .dw 0x57F7 ;
    .dw 0xEB25 ;
    .dw 0x71F7 ;
    .dw 0xEB26 ;
    .dw 0x78AD ;
    .dw 0xEB27 ;
    .dw 0xAC03 ;
    .dw 0xEB28 ;
    .dw 0xF563 ;
    .dw 0xEB29 ;
    .dw 0x77BF ;
    .dw 0xEB2A ;
    .dw 0xED3B ;
    .dw 0xEB2B ;
    .dw 0xD7D ;
    .dw 0xEB2C ;
    .dw 0x8855 ;
    .dw 0xEB2D ;
    .dw 0x6BD1 ;
    .dw 0xEB2E ;
    .dw 0x1B3D ;
    .dw 0xEB2F ;
    .dw 0x345D ;
    .dw 0xEB30 ;
    .dw 0xD2EF ;
    .dw 0xEB31 ;
    .dw 0x7D9D ;
    .dw 0xEB32 ;
    .dw 0xFBB9 ;
    .dw 0xEB33 ;
    .dw 0x938B ;
    .dw 0xEB34 ;
    .dw 0xD321 ;
    .dw 0xEB35 ;
    .dw 0xF011 ;
    .dw 0xEB36 ;
    .dw 0xAE01 ;
    .dw 0xEB37 ;
    .dw 0x503B ;
    .dw 0xEB38 ;
    .dw 0x7201 ;
    .dw 0xEB39 ;
    .dw 0x9215 ;
    .dw 0xEB3A ;
    .dw 0x52C1 ;
    .dw 0xEB3B ;
    .dw 0xDB23 ;
    .dw 0xEB3C ;
    .dw 0xD0A1 ;
    .dw 0xEB3D ;
    .dw 0x467B ;
    .dw 0xEB3E ;
    .dw 0x80A7 ;
    .dw 0xEB3F ;
    .dw 0xE539 ;
    .dw 0xEB40 ;
    .dw 0x8A6B ;
    .dw 0xEB41 ;
    .dw 0x1385 ;
    .dw 0xEB42 ;
    .dw 0x6A6F ;
    .dw 0xEB43 ;
    .dw 0xE7E1 ;
    .dw 0xEB44 ;
    .dw 0xC4F1 ;
    .dw 0xEB45 ;
    .dw 0xB1CF ;
    .dw 0xEB46 ;
    .dw 0x4E7F ;
    .dw 0xEB47 ;
    .dw 0xF8AD ;
    .dw 0xEB48 ;
    .dw 0x6553 ;
    .dw 0xEB49 ;
    .dw 0x12CB ;
    .dw 0xEB4A ;
    .dw 0x47FB ;
    .dw 0xEB4B ;
    .dw 0x2091 ;
    .dw 0xEB4C ;
    .dw 0x4307 ;
    .dw 0xEB4D ;
    .dw 0xD6C1 ;
    .dw 0xEB4E ;
    .dw 0x1967 ;
    .dw 0xEB4F ;
    .dw 0xEEA1 ;
    .dw 0xEB50 ;
    .dw 0xB03D ;
    .dw 0xEB51 ;
    .dw 0x2A37 ;
    .dw 0xEB52 ;
    .dw 0x8B3 ;
    .dw 0xEB53 ;
    .dw 0x7E3D ;
    .dw 0xEB54 ;
    .dw 0x2FAF ;
    .dw 0xEB55 ;
    .dw 0x2FD ;
    .dw 0xEB56 ;
    .dw 0x64DD ;
    .dw 0xEB57 ;
    .dw 0xA8D9 ;
    .dw 0xEB58 ;
    .dw 0xAFFF ;
    .dw 0xEB59 ;
    .dw 0x3495 ;
    .dw 0xEB5A ;
    .dw 0xCCFF ;
    .dw 0xEB5B ;
    .dw 0x9B25 ;
    .dw 0xEB5C ;
    .dw 0x248D ;
    .dw 0xEB5D ;
    .dw 0x542D ;
    .dw 0xEB5E ;
    .dw 0xD0F1 ;
    .dw 0xEB5F ;
    .dw 0x85D1 ;
    .dw 0xEB60 ;
    .dw 0xD3CD ;
    .dw 0xEB61 ;
    .dw 0xE423 ;
    .dw 0xEB62 ;
    .dw 0x35D ;
    .dw 0xEB63 ;
    .dw 0xA1BF ;
    .dw 0xEB64 ;
    .dw 0x331F ;
    .dw 0xEB65 ;
    .dw 0xBEED ;
    .dw 0xEB66 ;
    .dw 0x1551 ;
    .dw 0xEB67 ;
    .dw 0x3FBD ;
    .dw 0xEB68 ;
    .dw 0xA82B ;
    .dw 0xEB69 ;
    .dw 0x399B ;
    .dw 0xEB6A ;
    .dw 0x1361 ;
    .dw 0xEB6B ;
    .dw 0x1BBD ;
    .dw 0xEB6C ;
    .dw 0x7B9 ;
    .dw 0xEB6D ;
    .dw 0xF5D1 ;
    .dw 0xEB6E ;
    .dw 0x5C3D ;
    .dw 0xEB6F ;
    .dw 0xAB89 ;
    .dw 0xEB70 ;
    .dw 0x29FF ;
    .dw 0xEB71 ;
    .dw 0xDB33 ;
    .dw 0xEB72 ;
    .dw 0x68BF ;
    .dw 0xEB73 ;
    .dw 0xA105 ;
    .dw 0xEB74 ;
    .dw 0x6C87 ;
    .dw 0xEB75 ;
    .dw 0x3069 ;
    .dw 0xEB76 ;
    .dw 0xFD91 ;
    .dw 0xEB77 ;
    .dw 0x57D9 ;
    .dw 0xEB78 ;
    .dw 0x797D ;
    .dw 0xEB79 ;
    .dw 0x4B91 ;
    .dw 0xEB7A ;
    .dw 0xDE3B ;
    .dw 0xEB7B ;
    .dw 0x66B7 ;
    .dw 0xEB7C ;
    .dw 0x2C8F ;
    .dw 0xEB7D ;
    .dw 0xD239 ;
    .dw 0xEB7E ;
    .dw 0x99BF ;
    .dw 0xEB7F ;
    .dw 0xC07 ;
    .dw 0xEB80 ;
    .dw 0xED3B ;
    .dw 0xEB81 ;
    .dw 0xD7 ;
    .dw 0xEB82 ;
    .dw 0x88B3 ;
    .dw 0xEB83 ;
    .dw 0xAE29 ;
    .dw 0xEB84 ;
    .dw 0x56AD ;
    .dw 0xEB85 ;
    .dw 0xF1BF ;
    .dw 0xEB86 ;
    .dw 0x94D3 ;
    .dw 0xEB87 ;
    .dw 0x2727 ;
    .dw 0xEB88 ;
    .dw 0x851B ;
    .dw 0xEB89 ;
    .dw 0x5B9F ;
    .dw 0xEB8A ;
    .dw 0xE21F ;
    .dw 0xEB8B ;
    .dw 0x13EF ;
    .dw 0xEB8C ;
    .dw 0xE097 ;
    .dw 0xEB8D ;
    .dw 0xBF73 ;
    .dw 0xEB8E ;
    .dw 0xF16F ;
    .dw 0xEB8F ;
    .dw 0xDF07 ;
    .dw 0xEB90 ;
    .dw 0xBD65 ;
    .dw 0xEB91 ;
    .dw 0x7DFD ;
    .dw 0xEB92 ;
    .dw 0x548D ;
    .dw 0xEB93 ;
    .dw 0xBECD ;
    .dw 0xEB94 ;
    .dw 0xA9D7 ;
    .dw 0xEB95 ;
    .dw 0xCCC1 ;
    .dw 0xEB96 ;
    .dw 0x8BCD ;
    .dw 0xEB97 ;
    .dw 0x5F29 ;
    .dw 0xEB98 ;
    .dw 0xC1AB ;
    .dw 0xEB99 ;
    .dw 0x279 ;
    .dw 0xEB9A ;
    .dw 0x2525 ;
    .dw 0xEB9B ;
    .dw 0x6EC5 ;
    .dw 0xEB9C ;
    .dw 0xDED5 ;
    .dw 0xEB9D ;
    .dw 0x330D ;
    .dw 0xEB9E ;
    .dw 0xB4C3 ;
    .dw 0xEB9F ;
    .dw 0xC7C9 ;
    .dw 0xEBA0 ;
    .dw 0xFFE3 ;
    .dw 0xEBA1 ;
    .dw 0x9313 ;
    .dw 0xEBA2 ;
    .dw 0xBF25 ;
    .dw 0xEBA3 ;
    .dw 0x6C0F ;
    .dw 0xEBA4 ;
    .dw 0xBBCD ;
    .dw 0xEBA5 ;
    .dw 0x9AB9 ;
    .dw 0xEBA6 ;
    .dw 0x2CB7 ;
    .dw 0xEBA7 ;
    .dw 0xCDB ;
    .dw 0xEBA8 ;
    .dw 0x1B53 ;
    .dw 0xEBA9 ;
    .dw 0x6047 ;
    .dw 0xEBAA ;
    .dw 0x5EE3 ;
    .dw 0xEBAB ;
    .dw 0x5619 ;
    .dw 0xEBAC ;
    .dw 0xAFD3 ;
    .dw 0xEBAD ;
    .dw 0x2217 ;
    .dw 0xEBAE ;
    .dw 0x7EAF ;
    .dw 0xEBAF ;
    .dw 0xB50B ;
    .dw 0xEBB0 ;
    .dw 0x3F9D ;
    .dw 0xEBB1 ;
    .dw 0x7807 ;
    .dw 0xEBB2 ;
    .dw 0x1CCF ;
    .dw 0xEBB3 ;
    .dw 0xD28B ;
    .dw 0xEBB4 ;
    .dw 0xDFD3 ;
    .dw 0xEBB5 ;
    .dw 0x2477 ;
    .dw 0xEBB6 ;
    .dw 0xBB43 ;
    .dw 0xEBB7 ;
    .dw 0x78BB ;
    .dw 0xEBB8 ;
    .dw 0xD3B9 ;
    .dw 0xEBB9 ;
    .dw 0xFCBD ;
    .dw 0xEBBA ;
    .dw 0x586F ;
    .dw 0xEBBB ;
    .dw 0x1C45 ;
    .dw 0xEBBC ;
    .dw 0x993 ;
    .dw 0xEBBD ;
    .dw 0xE11D ;
    .dw 0xEBBE ;
    .dw 0x93A9 ;
    .dw 0xEBBF ;
    .dw 0xC109 ;
    .dw 0xEBC0 ;
    .dw 0x8CF7 ;
    .dw 0xEBC1 ;
    .dw 0x3C47 ;
    .dw 0xEBC2 ;
    .dw 0x8361 ;
    .dw 0xEBC3 ;
    .dw 0x725F ;
    .dw 0xEBC4 ;
    .dw 0xC6AF ;
    .dw 0xEBC5 ;
    .dw 0x249 ;
    .dw 0xEBC6 ;
    .dw 0xD4AB ;
    .dw 0xEBC7 ;
    .dw 0x6C7 ;
    .dw 0xEBC8 ;
    .dw 0xE201 ;
    .dw 0xEBC9 ;
    .dw 0xA703 ;
    .dw 0xEBCA ;
    .dw 0x4C5D ;
    .dw 0xEBCB ;
    .dw 0x6729 ;
    .dw 0xEBCC ;
    .dw 0x2F9B ;
    .dw 0xEBCD ;
    .dw 0x42D ;
    .dw 0xEBCE ;
    .dw 0x41A9 ;
    .dw 0xEBCF ;
    .dw 0x1183 ;
    .dw 0xEBD0 ;
    .dw 0xDDD9 ;
    .dw 0xEBD1 ;
    .dw 0xA6C1 ;
    .dw 0xEBD2 ;
    .dw 0x2A31 ;
    .dw 0xEBD3 ;
    .dw 0xF29 ;
    .dw 0xEBD4 ;
    .dw 0xDEA7 ;
    .dw 0xEBD5 ;
    .dw 0x7BFB ;
    .dw 0xEBD6 ;
    .dw 0xCFA1 ;
    .dw 0xEBD7 ;
    .dw 0x167D ;
    .dw 0xEBD8 ;
    .dw 0x52D5 ;
    .dw 0xEBD9 ;
    .dw 0x55CB ;
    .dw 0xEBDA ;
    .dw 0x46C5 ;
    .dw 0xEBDB ;
    .dw 0x1021 ;
    .dw 0xEBDC ;
    .dw 0x52F3 ;
    .dw 0xEBDD ;
    .dw 0x3ED7 ;
    .dw 0xEBDE ;
    .dw 0x4025 ;
    .dw 0xEBDF ;
    .dw 0xB7B5 ;
    .dw 0xEBE0 ;
    .dw 0x6DA7 ;
    .dw 0xEBE1 ;
    .dw 0x15E3 ;
    .dw 0xEBE2 ;
    .dw 0xCA17 ;
    .dw 0xEBE3 ;
    .dw 0x9009 ;
    .dw 0xEBE4 ;
    .dw 0xB381 ;
    .dw 0xEBE5 ;
    .dw 0x68DD ;
    .dw 0xEBE6 ;
    .dw 0x1C5F ;
    .dw 0xEBE7 ;
    .dw 0xE2DB ;
    .dw 0xEBE8 ;
    .dw 0xA857 ;
    .dw 0xEBE9 ;
    .dw 0x743 ;
    .dw 0xEBEA ;
    .dw 0x853D ;
    .dw 0xEBEB ;
    .dw 0x40F ;
    .dw 0xEBEC ;
    .dw 0xF221 ;
    .dw 0xEBED ;
    .dw 0x4425 ;
    .dw 0xEBEE ;
    .dw 0x1011 ;
    .dw 0xEBEF ;
    .dw 0x905F ;
    .dw 0xEBF0 ;
    .dw 0x1D49 ;
    .dw 0xEBF1 ;
    .dw 0x5F9B ;
    .dw 0xEBF2 ;
    .dw 0xFD67 ;
    .dw 0xEBF3 ;
    .dw 0xDF9B ;
    .dw 0xEBF4 ;
    .dw 0x4E83 ;
    .dw 0xEBF5 ;
    .dw 0xFBD ;
    .dw 0xEBF6 ;
    .dw 0xA497 ;
    .dw 0xEBF7 ;
    .dw 0x6261 ;
    .dw 0xEBF8 ;
    .dw 0x3A31 ;
    .dw 0xEBF9 ;
    .dw 0xA117 ;
    .dw 0xEBFA ;
    .dw 0xD6DB ;
    .dw 0xEBFB ;
    .dw 0x234D ;
    .dw 0xEBFC ;
    .dw 0x392B ;
    .dw 0xEBFD ;
    .dw 0xA6A9 ;
    .dw 0xEBFE ;
    .dw 0x5BE5 ;
    .dw 0xEBFF ;
    .dw 0x23BD ;
    .dw 0xEC00 ;
    .dw 0xD323 ;
    .dw 0xEC01 ;
    .dw 0xB157 ;
    .dw 0xEC02 ;
    .dw 0x9FF7 ;
    .dw 0xEC03 ;
    .dw 0xCBFF ;
    .dw 0xEC04 ;
    .dw 0x9675 ;
    .dw 0xEC05 ;
    .dw 0x6E9 ;
    .dw 0xEC06 ;
    .dw 0x2B83 ;
    .dw 0xEC07 ;
    .dw 0x2709 ;
    .dw 0xEC08 ;
    .dw 0x9585 ;
    .dw 0xEC09 ;
    .dw 0xD077 ;
    .dw 0xEC0A ;
    .dw 0xFC33 ;
    .dw 0xEC0B ;
    .dw 0x21BD ;
    .dw 0xEC0C ;
    .dw 0x6195 ;
    .dw 0xEC0D ;
    .dw 0xB86F ;
    .dw 0xEC0E ;
    .dw 0x5795 ;
    .dw 0xEC0F ;
    .dw 0x8591 ;
    .dw 0xEC10 ;
    .dw 0xDB1B ;
    .dw 0xEC11 ;
    .dw 0x7005 ;
    .dw 0xEC12 ;
    .dw 0x2F1F ;
    .dw 0xEC13 ;
    .dw 0xE6D1 ;
    .dw 0xEC14 ;
    .dw 0xAF9B ;
    .dw 0xEC15 ;
    .dw 0x142D ;
    .dw 0xEC16 ;
    .dw 0xADD5 ;
    .dw 0xEC17 ;
    .dw 0x3E55 ;
    .dw 0xEC18 ;
    .dw 0xDCFB ;
    .dw 0xEC19 ;
    .dw 0xEA0F ;
    .dw 0xEC1A ;
    .dw 0x75F ;
    .dw 0xEC1B ;
    .dw 0x66B9 ;
    .dw 0xEC1C ;
    .dw 0x1267 ;
    .dw 0xEC1D ;
    .dw 0x6B05 ;
    .dw 0xEC1E ;
    .dw 0x2099 ;
    .dw 0xEC1F ;
    .dw 0x3513 ;
    .dw 0xEC20 ;
    .dw 0x4699 ;
    .dw 0xEC21 ;
    .dw 0x1813 ;
    .dw 0xEC22 ;
    .dw 0x29B3 ;
    .dw 0xEC23 ;
    .dw 0x652F ;
    .dw 0xEC24 ;
    .dw 0x5BB9 ;
    .dw 0xEC25 ;
    .dw 0xCD9 ;
    .dw 0xEC26 ;
    .dw 0xC1C7 ;
    .dw 0xEC27 ;
    .dw 0x1141 ;
    .dw 0xEC28 ;
    .dw 0x28BB ;
    .dw 0xEC29 ;
    .dw 0xCA0D ;
    .dw 0xEC2A ;
    .dw 0xBBF1 ;
    .dw 0xEC2B ;
    .dw 0xED21 ;
    .dw 0xEC2C ;
    .dw 0xC027 ;
    .dw 0xEC2D ;
    .dw 0x2F7B ;
    .dw 0xEC2E ;
    .dw 0x1DE5 ;
    .dw 0xEC2F ;
    .dw 0xFD07 ;
    .dw 0xEC30 ;
    .dw 0x4C81 ;
    .dw 0xEC31 ;
    .dw 0x1D6F ;
    .dw 0xEC32 ;
    .dw 0x7009 ;
    .dw 0xEC33 ;
    .dw 0xFFB9 ;
    .dw 0xEC34 ;
    .dw 0x5A19 ;
    .dw 0xEC35 ;
    .dw 0xB5BB ;
    .dw 0xEC36 ;
    .dw 0xF70D ;
    .dw 0xEC37 ;
    .dw 0x4449 ;
    .dw 0xEC38 ;
    .dw 0xE667 ;
    .dw 0xEC39 ;
    .dw 0xB423 ;
    .dw 0xEC3A ;
    .dw 0xEF01 ;
    .dw 0xEC3B ;
    .dw 0x2353 ;
    .dw 0xEC3C ;
    .dw 0xCD9 ;
    .dw 0xEC3D ;
    .dw 0xD65D ;
    .dw 0xEC3E ;
    .dw 0x5FF1 ;
    .dw 0xEC3F ;
    .dw 0xD3A7 ;
    .dw 0xEC40 ;
    .dw 0xA93B ;
    .dw 0xEC41 ;
    .dw 0xCB87 ;
    .dw 0xEC42 ;
    .dw 0xA3F7 ;
    .dw 0xEC43 ;
    .dw 0xD28B ;
    .dw 0xEC44 ;
    .dw 0xC781 ;
    .dw 0xEC45 ;
    .dw 0xA31F ;
    .dw 0xEC46 ;
    .dw 0x36DD ;
    .dw 0xEC47 ;
    .dw 0x976F ;
    .dw 0xEC48 ;
    .dw 0x3927 ;
    .dw 0xEC49 ;
    .dw 0x3379 ;
    .dw 0xEC4A ;
    .dw 0xE725 ;
    .dw 0xEC4B ;
    .dw 0xCB2D ;
    .dw 0xEC4C ;
    .dw 0x2805 ;
    .dw 0xEC4D ;
    .dw 0x6FB9 ;
    .dw 0xEC4E ;
    .dw 0xB1 ;
    .dw 0xEC4F ;
    .dw 0xBAB1 ;
    .dw 0xEC50 ;
    .dw 0xFEAB ;
    .dw 0xEC51 ;
    .dw 0x2549 ;
    .dw 0xEC52 ;
    .dw 0x88D5 ;
    .dw 0xEC53 ;
    .dw 0x3D43 ;
    .dw 0xEC54 ;
    .dw 0x7E33 ;
    .dw 0xEC55 ;
    .dw 0x18D5 ;
    .dw 0xEC56 ;
    .dw 0x23EB ;
    .dw 0xEC57 ;
    .dw 0xC62F ;
    .dw 0xEC58 ;
    .dw 0x59A1 ;
    .dw 0xEC59 ;
    .dw 0xFAC1 ;
    .dw 0xEC5A ;
    .dw 0xBC71 ;
    .dw 0xEC5B ;
    .dw 0xDA0D ;
    .dw 0xEC5C ;
    .dw 0x2EB1 ;
    .dw 0xEC5D ;
    .dw 0x2B1D ;
    .dw 0xEC5E ;
    .dw 0x839D ;
    .dw 0xEC5F ;
    .dw 0x9F67 ;
    .dw 0xEC60 ;
    .dw 0x3437 ;
    .dw 0xEC61 ;
    .dw 0xC523 ;
    .dw 0xEC62 ;
    .dw 0x6377 ;
    .dw 0xEC63 ;
    .dw 0xC301 ;
    .dw 0xEC64 ;
    .dw 0x75F9 ;
    .dw 0xEC65 ;
    .dw 0xEA2B ;
    .dw 0xEC66 ;
    .dw 0x7A71 ;
    .dw 0xEC67 ;
    .dw 0x6789 ;
    .dw 0xEC68 ;
    .dw 0xF5F9 ;
    .dw 0xEC69 ;
    .dw 0xC429 ;
    .dw 0xEC6A ;
    .dw 0xB87F ;
    .dw 0xEC6B ;
    .dw 0x58CF ;
    .dw 0xEC6C ;
    .dw 0x8B61 ;
    .dw 0xEC6D ;
    .dw 0x3799 ;
    .dw 0xEC6E ;
    .dw 0x35AB ;
    .dw 0xEC6F ;
    .dw 0x3A81 ;
    .dw 0xEC70 ;
    .dw 0xD6C7 ;
    .dw 0xEC71 ;
    .dw 0xBD03 ;
    .dw 0xEC72 ;
    .dw 0x5A35 ;
    .dw 0xEC73 ;
    .dw 0xEA61 ;
    .dw 0xEC74 ;
    .dw 0x2415 ;
    .dw 0xEC75 ;
    .dw 0x59EF ;
    .dw 0xEC76 ;
    .dw 0x7023 ;
    .dw 0xEC77 ;
    .dw 0xCDF7 ;
    .dw 0xEC78 ;
    .dw 0x91D9 ;
    .dw 0xEC79 ;
    .dw 0x315D ;
    .dw 0xEC7A ;
    .dw 0xB661 ;
    .dw 0xEC7B ;
    .dw 0x43D3 ;
    .dw 0xEC7C ;
    .dw 0x561D ;
    .dw 0xEC7D ;
    .dw 0xA3B7 ;
    .dw 0xEC7E ;
    .dw 0x8D4F ;
    .dw 0xEC7F ;
    .dw 0xF043 ;
    .dw 0xEC80 ;
    .dw 0x78C1 ;
    .dw 0xEC81 ;
    .dw 0x7657 ;
    .dw 0xEC82 ;
    .dw 0xD4E1 ;
    .dw 0xEC83 ;
    .dw 0x1D81 ;
    .dw 0xEC84 ;
    .dw 0xDB51 ;
    .dw 0xEC85 ;
    .dw 0xFA6F ;
    .dw 0xEC86 ;
    .dw 0x1437 ;
    .dw 0xEC87 ;
    .dw 0xE779 ;
    .dw 0xEC88 ;
    .dw 0xE665 ;
    .dw 0xEC89 ;
    .dw 0xAB8B ;
    .dw 0xEC8A ;
    .dw 0x82AF ;
    .dw 0xEC8B ;
    .dw 0x6AF9 ;
    .dw 0xEC8C ;
    .dw 0xB46B ;
    .dw 0xEC8D ;
    .dw 0x3D89 ;
    .dw 0xEC8E ;
    .dw 0x8A81 ;
    .dw 0xEC8F ;
    .dw 0xB067 ;
    .dw 0xEC90 ;
    .dw 0x1207 ;
    .dw 0xEC91 ;
    .dw 0x920D ;
    .dw 0xEC92 ;
    .dw 0xDCD5 ;
    .dw 0xEC93 ;
    .dw 0x8A01 ;
    .dw 0xEC94 ;
    .dw 0x2BF3 ;
    .dw 0xEC95 ;
    .dw 0x8D77 ;
    .dw 0xEC96 ;
    .dw 0xAF63 ;
    .dw 0xEC97 ;
    .dw 0x1D8F ;
    .dw 0xEC98 ;
    .dw 0x4243 ;
    .dw 0xEC99 ;
    .dw 0x4363 ;
    .dw 0xEC9A ;
    .dw 0x3B7F ;
    .dw 0xEC9B ;
    .dw 0x519B ;
    .dw 0xEC9C ;
    .dw 0x394F ;
    .dw 0xEC9D ;
    .dw 0x729B ;
    .dw 0xEC9E ;
    .dw 0x16B5 ;
    .dw 0xEC9F ;
    .dw 0xD62B ;
    .dw 0xECA0 ;
    .dw 0x6005 ;
    .dw 0xECA1 ;
    .dw 0xC893 ;
    .dw 0xECA2 ;
    .dw 0x7CE7 ;
    .dw 0xECA3 ;
    .dw 0xFD ;
    .dw 0xECA4 ;
    .dw 0x43BD ;
    .dw 0xECA5 ;
    .dw 0xE457 ;
    .dw 0xECA6 ;
    .dw 0x23DD ;
    .dw 0xECA7 ;
    .dw 0x3533 ;
    .dw 0xECA8 ;
    .dw 0xE997 ;
    .dw 0xECA9 ;
    .dw 0x9113 ;
    .dw 0xECAA ;
    .dw 0xB065 ;
    .dw 0xECAB ;
    .dw 0xE99 ;
    .dw 0xECAC ;
    .dw 0x4551 ;
    .dw 0xECAD ;
    .dw 0x2FFD ;
    .dw 0xECAE ;
    .dw 0x64E1 ;
    .dw 0xECAF ;
    .dw 0x851 ;
    .dw 0xECB0 ;
    .dw 0x459B ;
    .dw 0xECB1 ;
    .dw 0xC9D5 ;
    .dw 0xECB2 ;
    .dw 0x2169 ;
    .dw 0xECB3 ;
    .dw 0xD715 ;
    .dw 0xECB4 ;
    .dw 0x4DF7 ;
    .dw 0xECB5 ;
    .dw 0xBFDB ;
    .dw 0xECB6 ;
    .dw 0x4D5B ;
    .dw 0xECB7 ;
    .dw 0x2EE7 ;
    .dw 0xECB8 ;
    .dw 0x760B ;
    .dw 0xECB9 ;
    .dw 0x9447 ;
    .dw 0xECBA ;
    .dw 0xC279 ;
    .dw 0xECBB ;
    .dw 0x2C4F ;
    .dw 0xECBC ;
    .dw 0x6675 ;
    .dw 0xECBD ;
    .dw 0xC23B ;
    .dw 0xECBE ;
    .dw 0x517F ;
    .dw 0xECBF ;
    .dw 0x1913 ;
    .dw 0xECC0 ;
    .dw 0x2B33 ;
    .dw 0xECC1 ;
    .dw 0x1D45 ;
    .dw 0xECC2 ;
    .dw 0xF835 ;
    .dw 0xECC3 ;
    .dw 0xC463 ;
    .dw 0xECC4 ;
    .dw 0xD369 ;
    .dw 0xECC5 ;
    .dw 0xB055 ;
    .dw 0xECC6 ;
    .dw 0x6115 ;
    .dw 0xECC7 ;
    .dw 0x26A7 ;
    .dw 0xECC8 ;
    .dw 0x36C1 ;
    .dw 0xECC9 ;
    .dw 0x942D ;
    .dw 0xECCA ;
    .dw 0xC453 ;
    .dw 0xECCB ;
    .dw 0x889F ;
    .dw 0xECCC ;
    .dw 0xB845 ;
    .dw 0xECCD ;
    .dw 0xB561 ;
    .dw 0xECCE ;
    .dw 0xC281 ;
    .dw 0xECCF ;
    .dw 0xE62F ;
    .dw 0xECD0 ;
    .dw 0x5EB3 ;
    .dw 0xECD1 ;
    .dw 0x1CF ;
    .dw 0xECD2 ;
    .dw 0x509F ;
    .dw 0xECD3 ;
    .dw 0xC48B ;
    .dw 0xECD4 ;
    .dw 0x1A57 ;
    .dw 0xECD5 ;
    .dw 0xF58F ;
    .dw 0xECD6 ;
    .dw 0x4DBD ;
    .dw 0xECD7 ;
    .dw 0x33F1 ;
    .dw 0xECD8 ;
    .dw 0x9061 ;
    .dw 0xECD9 ;
    .dw 0xFF75 ;
    .dw 0xECDA ;
    .dw 0xDA05 ;
    .dw 0xECDB ;
    .dw 0x34E5 ;
    .dw 0xECDC ;
    .dw 0x43C3 ;
    .dw 0xECDD ;
    .dw 0xB503 ;
    .dw 0xECDE ;
    .dw 0x75D ;
    .dw 0xECDF ;
    .dw 0x38E5 ;
    .dw 0xECE0 ;
    .dw 0x737F ;
    .dw 0xECE1 ;
    .dw 0x4DE1 ;
    .dw 0xECE2 ;
    .dw 0xFB7F ;
    .dw 0xECE3 ;
    .dw 0xF6A5 ;
    .dw 0xECE4 ;
    .dw 0x8687 ;
    .dw 0xECE5 ;
    .dw 0x5ED9 ;
    .dw 0xECE6 ;
    .dw 0x1B8B ;
    .dw 0xECE7 ;
    .dw 0x49C3 ;
    .dw 0xECE8 ;
    .dw 0x5D11 ;
    .dw 0xECE9 ;
    .dw 0x4C4B ;
    .dw 0xECEA ;
    .dw 0x5925 ;
    .dw 0xECEB ;
    .dw 0x55FD ;
    .dw 0xECEC ;
    .dw 0x5F77 ;
    .dw 0xECED ;
    .dw 0x6C29 ;
    .dw 0xECEE ;
    .dw 0x390B ;
    .dw 0xECEF ;
    .dw 0xA5F3 ;
    .dw 0xECF0 ;
    .dw 0xA27D ;
    .dw 0xECF1 ;
    .dw 0x4F69 ;
    .dw 0xECF2 ;
    .dw 0xAB29 ;
    .dw 0xECF3 ;
    .dw 0x7D53 ;
    .dw 0xECF4 ;
    .dw 0xF93F ;
    .dw 0xECF5 ;
    .dw 0x2B01 ;
    .dw 0xECF6 ;
    .dw 0x4C35 ;
    .dw 0xECF7 ;
    .dw 0x169B ;
    .dw 0xECF8 ;
    .dw 0x4C79 ;
    .dw 0xECF9 ;
    .dw 0xD85F ;
    .dw 0xECFA ;
    .dw 0x28CD ;
    .dw 0xECFB ;
    .dw 0x447 ;
    .dw 0xECFC ;
    .dw 0xF65 ;
    .dw 0xECFD ;
    .dw 0x6565 ;
    .dw 0xECFE ;
    .dw 0x99FF ;
    .dw 0xECFF ;
    .dw 0x6D95 ;
    .dw 0xED00 ;
    .dw 0x2A15 ;
    .dw 0xED01 ;
    .dw 0xABD3 ;
    .dw 0xED02 ;
    .dw 0x5373 ;
    .dw 0xED03 ;
    .dw 0x5EB1 ;
    .dw 0xED04 ;
    .dw 0x3145 ;
    .dw 0xED05 ;
    .dw 0xE853 ;
    .dw 0xED06 ;
    .dw 0x3AF3 ;
    .dw 0xED07 ;
    .dw 0xE477 ;
    .dw 0xED08 ;
    .dw 0x43BB ;
    .dw 0xED09 ;
    .dw 0xC8DF ;
    .dw 0xED0A ;
    .dw 0x218F ;
    .dw 0xED0B ;
    .dw 0x2BA1 ;
    .dw 0xED0C ;
    .dw 0x6515 ;
    .dw 0xED0D ;
    .dw 0xEAC1 ;
    .dw 0xED0E ;
    .dw 0xF631 ;
    .dw 0xED0F ;
    .dw 0x5B8B ;
    .dw 0xED10 ;
    .dw 0xAE2B ;
    .dw 0xED11 ;
    .dw 0x4011 ;
    .dw 0xED12 ;
    .dw 0x89B3 ;
    .dw 0xED13 ;
    .dw 0x645F ;
    .dw 0xED14 ;
    .dw 0x2AE1 ;
    .dw 0xED15 ;
    .dw 0x549F ;
    .dw 0xED16 ;
    .dw 0x7C77 ;
    .dw 0xED17 ;
    .dw 0x78D5 ;
    .dw 0xED18 ;
    .dw 0xBD7F ;
    .dw 0xED19 ;
    .dw 0xEA75 ;
    .dw 0xED1A ;
    .dw 0x6D83 ;
    .dw 0xED1B ;
    .dw 0x6B69 ;
    .dw 0xED1C ;
    .dw 0xDF8D ;
    .dw 0xED1D ;
    .dw 0xE5CF ;
    .dw 0xED1E ;
    .dw 0x317 ;
    .dw 0xED1F ;
    .dw 0xA713 ;
    .dw 0xED20 ;
    .dw 0x9825 ;
    .dw 0xED21 ;
    .dw 0x8F ;
    .dw 0xED22 ;
    .dw 0xE4C1 ;
    .dw 0xED23 ;
    .dw 0xFB79 ;
    .dw 0xED24 ;
    .dw 0x7FD5 ;
    .dw 0xED25 ;
    .dw 0x3D33 ;
    .dw 0xED26 ;
    .dw 0x3EFB ;
    .dw 0xED27 ;
    .dw 0xF4B5 ;
    .dw 0xED28 ;
    .dw 0x29EB ;
    .dw 0xED29 ;
    .dw 0x9155 ;
    .dw 0xED2A ;
    .dw 0xE83F ;
    .dw 0xED2B ;
    .dw 0xF67D ;
    .dw 0xED2C ;
    .dw 0xCB51 ;
    .dw 0xED2D ;
    .dw 0xBF9D ;
    .dw 0xED2E ;
    .dw 0xBFA5 ;
    .dw 0xED2F ;
    .dw 0xD2E9 ;
    .dw 0xED30 ;
    .dw 0x76EB ;
    .dw 0xED31 ;
    .dw 0xD939 ;
    .dw 0xED32 ;
    .dw 0x5CF1 ;
    .dw 0xED33 ;
    .dw 0x149F ;
    .dw 0xED34 ;
    .dw 0xC76B ;
    .dw 0xED35 ;
    .dw 0x5EDB ;
    .dw 0xED36 ;
    .dw 0xAA31 ;
    .dw 0xED37 ;
    .dw 0xB491 ;
    .dw 0xED38 ;
    .dw 0x4EA3 ;
    .dw 0xED39 ;
    .dw 0x7929 ;
    .dw 0xED3A ;
    .dw 0x7ED9 ;
    .dw 0xED3B ;
    .dw 0x733B ;
    .dw 0xED3C ;
    .dw 0xA269 ;
    .dw 0xED3D ;
    .dw 0x40B5 ;
    .dw 0xED3E ;
    .dw 0xD453 ;
    .dw 0xED3F ;
    .dw 0x8D4D ;
    .dw 0xED40 ;
    .dw 0x5EE3 ;
    .dw 0xED41 ;
    .dw 0x8D81 ;
    .dw 0xED42 ;
    .dw 0xAC19 ;
    .dw 0xED43 ;
    .dw 0x3EB ;
    .dw 0xED44 ;
    .dw 0xF667 ;
    .dw 0xED45 ;
    .dw 0x45E9 ;
    .dw 0xED46 ;
    .dw 0x3F53 ;
    .dw 0xED47 ;
    .dw 0x306B ;
    .dw 0xED48 ;
    .dw 0xA6D1 ;
    .dw 0xED49 ;
    .dw 0xA51F ;
    .dw 0xED4A ;
    .dw 0x8FE7 ;
    .dw 0xED4B ;
    .dw 0xDB7F ;
    .dw 0xED4C ;
    .dw 0x6C5B ;
    .dw 0xED4D ;
    .dw 0x7129 ;
    .dw 0xED4E ;
    .dw 0xF315 ;
    .dw 0xED4F ;
    .dw 0x8FFB ;
    .dw 0xED50 ;
    .dw 0x49F1 ;
    .dw 0xED51 ;
    .dw 0x9853 ;
    .dw 0xED52 ;
    .dw 0xAD8F ;
    .dw 0xED53 ;
    .dw 0x60FF ;
    .dw 0xED54 ;
    .dw 0xBF0F ;
    .dw 0xED55 ;
    .dw 0x2E27 ;
    .dw 0xED56 ;
    .dw 0x3913 ;
    .dw 0xED57 ;
    .dw 0xDBBF ;
    .dw 0xED58 ;
    .dw 0xC319 ;
    .dw 0xED59 ;
    .dw 0x3FE7 ;
    .dw 0xED5A ;
    .dw 0x4B7D ;
    .dw 0xED5B ;
    .dw 0x5CAB ;
    .dw 0xED5C ;
    .dw 0x1E2B ;
    .dw 0xED5D ;
    .dw 0x7885 ;
    .dw 0xED5E ;
    .dw 0x3761 ;
    .dw 0xED5F ;
    .dw 0x8033 ;
    .dw 0xED60 ;
    .dw 0x777B ;
    .dw 0xED61 ;
    .dw 0xC1B ;
    .dw 0xED62 ;
    .dw 0xBE2B ;
    .dw 0xED63 ;
    .dw 0xE6F9 ;
    .dw 0xED64 ;
    .dw 0xF12B ;
    .dw 0xED65 ;
    .dw 0xE2E3 ;
    .dw 0xED66 ;
    .dw 0xEBAB ;
    .dw 0xED67 ;
    .dw 0x58B ;
    .dw 0xED68 ;
    .dw 0xA99F ;
    .dw 0xED69 ;
    .dw 0x7BAD ;
    .dw 0xED6A ;
    .dw 0x1333 ;
    .dw 0xED6B ;
    .dw 0x3799 ;
    .dw 0xED6C ;
    .dw 0xFA61 ;
    .dw 0xED6D ;
    .dw 0x7DD7 ;
    .dw 0xED6E ;
    .dw 0x8631 ;
    .dw 0xED6F ;
    .dw 0xCEB1 ;
    .dw 0xED70 ;
    .dw 0xCC69 ;
    .dw 0xED71 ;
    .dw 0x72CB ;
    .dw 0xED72 ;
    .dw 0x1C41 ;
    .dw 0xED73 ;
    .dw 0x5475 ;
    .dw 0xED74 ;
    .dw 0xD9FD ;
    .dw 0xED75 ;
    .dw 0x9EEF ;
    .dw 0xED76 ;
    .dw 0x24CF ;
    .dw 0xED77 ;
    .dw 0xB84D ;
    .dw 0xED78 ;
    .dw 0x360D ;
    .dw 0xED79 ;
    .dw 0x7221 ;
    .dw 0xED7A ;
    .dw 0xDA1F ;
    .dw 0xED7B ;
    .dw 0xA0A9 ;
    .dw 0xED7C ;
    .dw 0xF103 ;
    .dw 0xED7D ;
    .dw 0x87AF ;
    .dw 0xED7E ;
    .dw 0xEDF7 ;
    .dw 0xED7F ;
    .dw 0x97B7 ;
    .dw 0xED80 ;
    .dw 0x331F ;
    .dw 0xED81 ;
    .dw 0xADCF ;
    .dw 0xED82 ;
    .dw 0x47A9 ;
    .dw 0xED83 ;
    .dw 0x4B91 ;
    .dw 0xED84 ;
    .dw 0xA44F ;
    .dw 0xED85 ;
    .dw 0xEC95 ;
    .dw 0xED86 ;
    .dw 0x8BB3 ;
    .dw 0xED87 ;
    .dw 0x9A03 ;
    .dw 0xED88 ;
    .dw 0x7985 ;
    .dw 0xED89 ;
    .dw 0x46F ;
    .dw 0xED8A ;
    .dw 0x84D7 ;
    .dw 0xED8B ;
    .dw 0x9FB9 ;
    .dw 0xED8C ;
    .dw 0xFF95 ;
    .dw 0xED8D ;
    .dw 0x5C17 ;
    .dw 0xED8E ;
    .dw 0x6A9 ;
    .dw 0xED8F ;
    .dw 0x82FD ;
    .dw 0xED90 ;
    .dw 0xFB83 ;
    .dw 0xED91 ;
    .dw 0xD613 ;
    .dw 0xED92 ;
    .dw 0x61B7 ;
    .dw 0xED93 ;
    .dw 0x31EB ;
    .dw 0xED94 ;
    .dw 0xB865 ;
    .dw 0xED95 ;
    .dw 0x85A5 ;
    .dw 0xED96 ;
    .dw 0x111 ;
    .dw 0xED97 ;
    .dw 0xCC2B ;
    .dw 0xED98 ;
    .dw 0x1AB1 ;
    .dw 0xED99 ;
    .dw 0xBB47 ;
    .dw 0xED9A ;
    .dw 0x496F ;
    .dw 0xED9B ;
    .dw 0xF027 ;
    .dw 0xED9C ;
    .dw 0x911F ;
    .dw 0xED9D ;
    .dw 0x60A1 ;
    .dw 0xED9E ;
    .dw 0x51BF ;
    .dw 0xED9F ;
    .dw 0xA3C7 ;
    .dw 0xEDA0 ;
    .dw 0x3AFD ;
    .dw 0xEDA1 ;
    .dw 0x1C09 ;
    .dw 0xEDA2 ;
    .dw 0x8D41 ;
    .dw 0xEDA3 ;
    .dw 0x10A3 ;
    .dw 0xEDA4 ;
    .dw 0x1C05 ;
    .dw 0xEDA5 ;
    .dw 0x336D ;
    .dw 0xEDA6 ;
    .dw 0xFF1D ;
    .dw 0xEDA7 ;
    .dw 0xCBC3 ;
    .dw 0xEDA8 ;
    .dw 0xB5B3 ;
    .dw 0xEDA9 ;
    .dw 0xA6D5 ;
    .dw 0xEDAA ;
    .dw 0xF7F ;
    .dw 0xEDAB ;
    .dw 0xE0D1 ;
    .dw 0xEDAC ;
    .dw 0xDE27 ;
    .dw 0xEDAD ;
    .dw 0x7A5B ;
    .dw 0xEDAE ;
    .dw 0x9A2D ;
    .dw 0xEDAF ;
    .dw 0x58CF ;
    .dw 0xEDB0 ;
    .dw 0x2C73 ;
    .dw 0xEDB1 ;
    .dw 0xA79B ;
    .dw 0xEDB2 ;
    .dw 0x4E9D ;
    .dw 0xEDB3 ;
    .dw 0x7457 ;
    .dw 0xEDB4 ;
    .dw 0xD275 ;
    .dw 0xEDB5 ;
    .dw 0xAEB9 ;
    .dw 0xEDB6 ;
    .dw 0xF98D ;
    .dw 0xEDB7 ;
    .dw 0x514B ;
    .dw 0xEDB8 ;
    .dw 0x3C33 ;
    .dw 0xEDB9 ;
    .dw 0x3EC9 ;
    .dw 0xEDBA ;
    .dw 0xD01D ;
    .dw 0xEDBB ;
    .dw 0x3413 ;
    .dw 0xEDBC ;
    .dw 0x4CB1 ;
    .dw 0xEDBD ;
    .dw 0xEDCF ;
    .dw 0xEDBE ;
    .dw 0x546B ;
    .dw 0xEDBF ;
    .dw 0x2C53 ;
    .dw 0xEDC0 ;
    .dw 0x9047 ;
    .dw 0xEDC1 ;
    .dw 0x783B ;
    .dw 0xEDC2 ;
    .dw 0xEBA3 ;
    .dw 0xEDC3 ;
    .dw 0x4D21 ;
    .dw 0xEDC4 ;
    .dw 0x3C7B ;
    .dw 0xEDC5 ;
    .dw 0x7FD9 ;
    .dw 0xEDC6 ;
    .dw 0xBD97 ;
    .dw 0xEDC7 ;
    .dw 0x30BD ;
    .dw 0xEDC8 ;
    .dw 0x5557 ;
    .dw 0xEDC9 ;
    .dw 0x424F ;
    .dw 0xEDCA ;
    .dw 0xF5DF ;
    .dw 0xEDCB ;
    .dw 0xFFCF ;
    .dw 0xEDCC ;
    .dw 0xD047 ;
    .dw 0xEDCD ;
    .dw 0x3F0F ;
    .dw 0xEDCE ;
    .dw 0xFE6F ;
    .dw 0xEDCF ;
    .dw 0xB415 ;
    .dw 0xEDD0 ;
    .dw 0xC65 ;
    .dw 0xEDD1 ;
    .dw 0x44D5 ;
    .dw 0xEDD2 ;
    .dw 0xCBA5 ;
    .dw 0xEDD3 ;
    .dw 0xCEA3 ;
    .dw 0xEDD4 ;
    .dw 0x785F ;
    .dw 0xEDD5 ;
    .dw 0xDE9B ;
    .dw 0xEDD6 ;
    .dw 0xD1F1 ;
    .dw 0xEDD7 ;
    .dw 0x399B ;
    .dw 0xEDD8 ;
    .dw 0xBDC5 ;
    .dw 0xEDD9 ;
    .dw 0x9815 ;
    .dw 0xEDDA ;
    .dw 0xBCDB ;
    .dw 0xEDDB ;
    .dw 0x8D5F ;
    .dw 0xEDDC ;
    .dw 0x49E9 ;
    .dw 0xEDDD ;
    .dw 0x11A7 ;
    .dw 0xEDDE ;
    .dw 0x7FAD ;
    .dw 0xEDDF ;
    .dw 0x714F ;
    .dw 0xEDE0 ;
    .dw 0x8C2D ;
    .dw 0xEDE1 ;
    .dw 0x5BD5 ;
    .dw 0xEDE2 ;
    .dw 0xD77F ;
    .dw 0xEDE3 ;
    .dw 0x4FF9 ;
    .dw 0xEDE4 ;
    .dw 0xC1E3 ;
    .dw 0xEDE5 ;
    .dw 0x924D ;
    .dw 0xEDE6 ;
    .dw 0xD6D1 ;
    .dw 0xEDE7 ;
    .dw 0x16E1 ;
    .dw 0xEDE8 ;
    .dw 0xA7A3 ;
    .dw 0xEDE9 ;
    .dw 0x2E4D ;
    .dw 0xEDEA ;
    .dw 0x92A7 ;
    .dw 0xEDEB ;
    .dw 0x39A3 ;
    .dw 0xEDEC ;
    .dw 0xE823 ;
    .dw 0xEDED ;
    .dw 0x8A5 ;
    .dw 0xEDEE ;
    .dw 0x891D ;
    .dw 0xEDEF ;
    .dw 0xB0BF ;
    .dw 0xEDF0 ;
    .dw 0xA089 ;
    .dw 0xEDF1 ;
    .dw 0x832D ;
    .dw 0xEDF2 ;
    .dw 0xD981 ;
    .dw 0xEDF3 ;
    .dw 0x2BC3 ;
    .dw 0xEDF4 ;
    .dw 0xD251 ;
    .dw 0xEDF5 ;
    .dw 0xD1BB ;
    .dw 0xEDF6 ;
    .dw 0xE5ED ;
    .dw 0xEDF7 ;
    .dw 0x2F0D ;
    .dw 0xEDF8 ;
    .dw 0x1A97 ;
    .dw 0xEDF9 ;
    .dw 0xDA9F ;
    .dw 0xEDFA ;
    .dw 0x7657 ;
    .dw 0xEDFB ;
    .dw 0x54F9 ;
    .dw 0xEDFC ;
    .dw 0x86F7 ;
    .dw 0xEDFD ;
    .dw 0xA697 ;
    .dw 0xEDFE ;
    .dw 0xF533 ;
    .dw 0xEDFF ;
    .dw 0x6AA5 ;
    .dw 0xEE00 ;
    .dw 0xDFDF ;
    .dw 0xEE01 ;
    .dw 0xD847 ;
    .dw 0xEE02 ;
    .dw 0xDD85 ;
    .dw 0xEE03 ;
    .dw 0xA01D ;
    .dw 0xEE04 ;
    .dw 0x406D ;
    .dw 0xEE05 ;
    .dw 0x2335 ;
    .dw 0xEE06 ;
    .dw 0xF27B ;
    .dw 0xEE07 ;
    .dw 0x841D ;
    .dw 0xEE08 ;
    .dw 0x53C7 ;
    .dw 0xEE09 ;
    .dw 0x3A3D ;
    .dw 0xEE0A ;
    .dw 0x5883 ;
    .dw 0xEE0B ;
    .dw 0x33F ;
    .dw 0xEE0C ;
    .dw 0xFED ;
    .dw 0xEE0D ;
    .dw 0x2D8D ;
    .dw 0xEE0E ;
    .dw 0x27E7 ;
    .dw 0xEE0F ;
    .dw 0x22BF ;
    .dw 0xEE10 ;
    .dw 0x4613 ;
    .dw 0xEE11 ;
    .dw 0xB015 ;
    .dw 0xEE12 ;
    .dw 0x90DF ;
    .dw 0xEE13 ;
    .dw 0xAEA7 ;
    .dw 0xEE14 ;
    .dw 0xE07F ;
    .dw 0xEE15 ;
    .dw 0x3C89 ;
    .dw 0xEE16 ;
    .dw 0x2931 ;
    .dw 0xEE17 ;
    .dw 0x938F ;
    .dw 0xEE18 ;
    .dw 0x25D9 ;
    .dw 0xEE19 ;
    .dw 0x91D5 ;
    .dw 0xEE1A ;
    .dw 0x7B41 ;
    .dw 0xEE1B ;
    .dw 0x1BD3 ;
    .dw 0xEE1C ;
    .dw 0xDA09 ;
    .dw 0xEE1D ;
    .dw 0x7F11 ;
    .dw 0xEE1E ;
    .dw 0x6EAD ;
    .dw 0xEE1F ;
    .dw 0xC849 ;
    .dw 0xEE20 ;
    .dw 0x948B ;
    .dw 0xEE21 ;
    .dw 0x7701 ;
    .dw 0xEE22 ;
    .dw 0xA265 ;
    .dw 0xEE23 ;
    .dw 0xFC7B ;
    .dw 0xEE24 ;
    .dw 0x2449 ;
    .dw 0xEE25 ;
    .dw 0xE305 ;
    .dw 0xEE26 ;
    .dw 0x5045 ;
    .dw 0xEE27 ;
    .dw 0x3661 ;
    .dw 0xEE28 ;
    .dw 0x58F3 ;
    .dw 0xEE29 ;
    .dw 0xAD93 ;
    .dw 0xEE2A ;
    .dw 0xD225 ;
    .dw 0xEE2B ;
    .dw 0x991 ;
    .dw 0xEE2C ;
    .dw 0x9D3 ;
    .dw 0xEE2D ;
    .dw 0xFC35 ;
    .dw 0xEE2E ;
    .dw 0x607D ;
    .dw 0xEE2F ;
    .dw 0x9603 ;
    .dw 0xEE30 ;
    .dw 0xB22F ;
    .dw 0xEE31 ;
    .dw 0x90FD ;
    .dw 0xEE32 ;
    .dw 0x226F ;
    .dw 0xEE33 ;
    .dw 0xB23D ;
    .dw 0xEE34 ;
    .dw 0x7B15 ;
    .dw 0xEE35 ;
    .dw 0xCB75 ;
    .dw 0xEE36 ;
    .dw 0x276D ;
    .dw 0xEE37 ;
    .dw 0x8111 ;
    .dw 0xEE38 ;
    .dw 0xAB9 ;
    .dw 0xEE39 ;
    .dw 0xC127 ;
    .dw 0xEE3A ;
    .dw 0x6249 ;
    .dw 0xEE3B ;
    .dw 0xAADB ;
    .dw 0xEE3C ;
    .dw 0xF151 ;
    .dw 0xEE3D ;
    .dw 0x6587 ;
    .dw 0xEE3E ;
    .dw 0x3DCB ;
    .dw 0xEE3F ;
    .dw 0xF229 ;
    .dw 0xEE40 ;
    .dw 0xB63 ;
    .dw 0xEE41 ;
    .dw 0x3973 ;
    .dw 0xEE42 ;
    .dw 0xE2D1 ;
    .dw 0xEE43 ;
    .dw 0x5C05 ;
    .dw 0xEE44 ;
    .dw 0xB1A5 ;
    .dw 0xEE45 ;
    .dw 0x7A29 ;
    .dw 0xEE46 ;
    .dw 0xC7E1 ;
    .dw 0xEE47 ;
    .dw 0xA39F ;
    .dw 0xEE48 ;
    .dw 0xE55 ;
    .dw 0xEE49 ;
    .dw 0x47BD ;
    .dw 0xEE4A ;
    .dw 0xA23F ;
    .dw 0xEE4B ;
    .dw 0x318B ;
    .dw 0xEE4C ;
    .dw 0x7007 ;
    .dw 0xEE4D ;
    .dw 0xBB11 ;
    .dw 0xEE4E ;
    .dw 0x508F ;
    .dw 0xEE4F ;
    .dw 0x4E7B ;
    .dw 0xEE50 ;
    .dw 0xF20F ;
    .dw 0xEE51 ;
    .dw 0x6353 ;
    .dw 0xEE52 ;
    .dw 0xD6E1 ;
    .dw 0xEE53 ;
    .dw 0xC975 ;
    .dw 0xEE54 ;
    .dw 0x5243 ;
    .dw 0xEE55 ;
    .dw 0x22EF ;
    .dw 0xEE56 ;
    .dw 0x453 ;
    .dw 0xEE57 ;
    .dw 0xC985 ;
    .dw 0xEE58 ;
    .dw 0x4C69 ;
    .dw 0xEE59 ;
    .dw 0xE403 ;
    .dw 0xEE5A ;
    .dw 0xDA1F ;
    .dw 0xEE5B ;
    .dw 0x301 ;
    .dw 0xEE5C ;
    .dw 0x52FF ;
    .dw 0xEE5D ;
    .dw 0x1C65 ;
    .dw 0xEE5E ;
    .dw 0x4C3F ;
    .dw 0xEE5F ;
    .dw 0x837 ;
    .dw 0xEE60 ;
    .dw 0xFD97 ;
    .dw 0xEE61 ;
    .dw 0x990D ;
    .dw 0xEE62 ;
    .dw 0x7377 ;
    .dw 0xEE63 ;
    .dw 0xEDA9 ;
    .dw 0xEE64 ;
    .dw 0x4B3 ;
    .dw 0xEE65 ;
    .dw 0x8913 ;
    .dw 0xEE66 ;
    .dw 0xC8FB ;
    .dw 0xEE67 ;
    .dw 0xF9C5 ;
    .dw 0xEE68 ;
    .dw 0x231D ;
    .dw 0xEE69 ;
    .dw 0x4029 ;
    .dw 0xEE6A ;
    .dw 0x837F ;
    .dw 0xEE6B ;
    .dw 0x981B ;
    .dw 0xEE6C ;
    .dw 0xB4B9 ;
    .dw 0xEE6D ;
    .dw 0xA88F ;
    .dw 0xEE6E ;
    .dw 0xADCF ;
    .dw 0xEE6F ;
    .dw 0x4819 ;
    .dw 0xEE70 ;
    .dw 0x6AE1 ;
    .dw 0xEE71 ;
    .dw 0xDC8B ;
    .dw 0xEE72 ;
    .dw 0xEE7 ;
    .dw 0xEE73 ;
    .dw 0xBF41 ;
    .dw 0xEE74 ;
    .dw 0xEE3D ;
    .dw 0xEE75 ;
    .dw 0xDF65 ;
    .dw 0xEE76 ;
    .dw 0x7B91 ;
    .dw 0xEE77 ;
    .dw 0xF6DB ;
    .dw 0xEE78 ;
    .dw 0xC619 ;
    .dw 0xEE79 ;
    .dw 0xEDDD ;
    .dw 0xEE7A ;
    .dw 0xA975 ;
    .dw 0xEE7B ;
    .dw 0x5D37 ;
    .dw 0xEE7C ;
    .dw 0x5D41 ;
    .dw 0xEE7D ;
    .dw 0x5E1D ;
    .dw 0xEE7E ;
    .dw 0x1BB5 ;
    .dw 0xEE7F ;
    .dw 0xE261 ;
    .dw 0xEE80 ;
    .dw 0x7C55 ;
    .dw 0xEE81 ;
    .dw 0x873F ;
    .dw 0xEE82 ;
    .dw 0x4107 ;
    .dw 0xEE83 ;
    .dw 0x1859 ;
    .dw 0xEE84 ;
    .dw 0x11A3 ;
    .dw 0xEE85 ;
    .dw 0xA833 ;
    .dw 0xEE86 ;
    .dw 0x5B47 ;
    .dw 0xEE87 ;
    .dw 0x1EC5 ;
    .dw 0xEE88 ;
    .dw 0x9E7F ;
    .dw 0xEE89 ;
    .dw 0x464B ;
    .dw 0xEE8A ;
    .dw 0x4895 ;
    .dw 0xEE8B ;
    .dw 0x9233 ;
    .dw 0xEE8C ;
    .dw 0x2219 ;
    .dw 0xEE8D ;
    .dw 0xFB1F ;
    .dw 0xEE8E ;
    .dw 0xC5E9 ;
    .dw 0xEE8F ;
    .dw 0x36CD ;
    .dw 0xEE90 ;
    .dw 0xD9D7 ;
    .dw 0xEE91 ;
    .dw 0x2A13 ;
    .dw 0xEE92 ;
    .dw 0x432F ;
    .dw 0xEE93 ;
    .dw 0x968F ;
    .dw 0xEE94 ;
    .dw 0xAF2F ;
    .dw 0xEE95 ;
    .dw 0x954B ;
    .dw 0xEE96 ;
    .dw 0xE0D7 ;
    .dw 0xEE97 ;
    .dw 0x4B01 ;
    .dw 0xEE98 ;
    .dw 0xAAF7 ;
    .dw 0xEE99 ;
    .dw 0x4A21 ;
    .dw 0xEE9A ;
    .dw 0xAEF9 ;
    .dw 0xEE9B ;
    .dw 0x2A6B ;
    .dw 0xEE9C ;
    .dw 0x4649 ;
    .dw 0xEE9D ;
    .dw 0xDD1F ;
    .dw 0xEE9E ;
    .dw 0xC5E1 ;
    .dw 0xEE9F ;
    .dw 0x1099 ;
    .dw 0xEEA0 ;
    .dw 0xF0CF ;
    .dw 0xEEA1 ;
    .dw 0x6D77 ;
    .dw 0xEEA2 ;
    .dw 0x5031 ;
    .dw 0xEEA3 ;
    .dw 0x7B03 ;
    .dw 0xEEA4 ;
    .dw 0xA4A3 ;
    .dw 0xEEA5 ;
    .dw 0x67FB ;
    .dw 0xEEA6 ;
    .dw 0x1E73 ;
    .dw 0xEEA7 ;
    .dw 0xB08D ;
    .dw 0xEEA8 ;
    .dw 0xDFA7 ;
    .dw 0xEEA9 ;
    .dw 0x818F ;
    .dw 0xEEAA ;
    .dw 0xDC33 ;
    .dw 0xEEAB ;
    .dw 0xACC1 ;
    .dw 0xEEAC ;
    .dw 0xDA55 ;
    .dw 0xEEAD ;
    .dw 0xE12F ;
    .dw 0xEEAE ;
    .dw 0x7E91 ;
    .dw 0xEEAF ;
    .dw 0x8685 ;
    .dw 0xEEB0 ;
    .dw 0x5421 ;
    .dw 0xEEB1 ;
    .dw 0xF15B ;
    .dw 0xEEB2 ;
    .dw 0x467 ;
    .dw 0xEEB3 ;
    .dw 0x8A51 ;
    .dw 0xEEB4 ;
    .dw 0xCD49 ;
    .dw 0xEEB5 ;
    .dw 0xD10F ;
    .dw 0xEEB6 ;
    .dw 0x1FD5 ;
    .dw 0xEEB7 ;
    .dw 0xBFE7 ;
    .dw 0xEEB8 ;
    .dw 0x8635 ;
    .dw 0xEEB9 ;
    .dw 0xDC43 ;
    .dw 0xEEBA ;
    .dw 0xE159 ;
    .dw 0xEEBB ;
    .dw 0x138F ;
    .dw 0xEEBC ;
    .dw 0x1C45 ;
    .dw 0xEEBD ;
    .dw 0x43DB ;
    .dw 0xEEBE ;
    .dw 0xFC71 ;
    .dw 0xEEBF ;
    .dw 0xDACD ;
    .dw 0xEEC0 ;
    .dw 0x1C35 ;
    .dw 0xEEC1 ;
    .dw 0x2D29 ;
    .dw 0xEEC2 ;
    .dw 0xBDA7 ;
    .dw 0xEEC3 ;
    .dw 0xEC97 ;
    .dw 0xEEC4 ;
    .dw 0x61E7 ;
    .dw 0xEEC5 ;
    .dw 0x50D7 ;
    .dw 0xEEC6 ;
    .dw 0x4A31 ;
    .dw 0xEEC7 ;
    .dw 0x50D ;
    .dw 0xEEC8 ;
    .dw 0x9DC7 ;
    .dw 0xEEC9 ;
    .dw 0x9169 ;
    .dw 0xEECA ;
    .dw 0x4105 ;
    .dw 0xEECB ;
    .dw 0xACB5 ;
    .dw 0xEECC ;
    .dw 0xD79F ;
    .dw 0xEECD ;
    .dw 0x8133 ;
    .dw 0xEECE ;
    .dw 0x5575 ;
    .dw 0xEECF ;
    .dw 0x5B31 ;
    .dw 0xEED0 ;
    .dw 0x46EF ;
    .dw 0xEED1 ;
    .dw 0x4FD1 ;
    .dw 0xEED2 ;
    .dw 0xFB45 ;
    .dw 0xEED3 ;
    .dw 0xD75 ;
    .dw 0xEED4 ;
    .dw 0x58BF ;
    .dw 0xEED5 ;
    .dw 0x171F ;
    .dw 0xEED6 ;
    .dw 0xBC3B ;
    .dw 0xEED7 ;
    .dw 0x77F ;
    .dw 0xEED8 ;
    .dw 0x3B03 ;
    .dw 0xEED9 ;
    .dw 0xFFAF ;
    .dw 0xEEDA ;
    .dw 0x4F4B ;
    .dw 0xEEDB ;
    .dw 0xF991 ;
    .dw 0xEEDC ;
    .dw 0xC569 ;
    .dw 0xEEDD ;
    .dw 0x34C1 ;
    .dw 0xEEDE ;
    .dw 0x915 ;
    .dw 0xEEDF ;
    .dw 0x40EF ;
    .dw 0xEEE0 ;
    .dw 0x17B5 ;
    .dw 0xEEE1 ;
    .dw 0x1FC3 ;
    .dw 0xEEE2 ;
    .dw 0xBE17 ;
    .dw 0xEEE3 ;
    .dw 0x7C07 ;
    .dw 0xEEE4 ;
    .dw 0xC599 ;
    .dw 0xEEE5 ;
    .dw 0xE339 ;
    .dw 0xEEE6 ;
    .dw 0xAE2D ;
    .dw 0xEEE7 ;
    .dw 0x2A37 ;
    .dw 0xEEE8 ;
    .dw 0xE80D ;
    .dw 0xEEE9 ;
    .dw 0x8D45 ;
    .dw 0xEEEA ;
    .dw 0x91BF ;
    .dw 0xEEEB ;
    .dw 0x8F01 ;
    .dw 0xEEEC ;
    .dw 0xEC27 ;
    .dw 0xEEED ;
    .dw 0xF997 ;
    .dw 0xEEEE ;
    .dw 0x6047 ;
    .dw 0xEEEF ;
    .dw 0x90C3 ;
    .dw 0xEEF0 ;
    .dw 0x776F ;
    .dw 0xEEF1 ;
    .dw 0xDAE9 ;
    .dw 0xEEF2 ;
    .dw 0xE873 ;
    .dw 0xEEF3 ;
    .dw 0xCAEB ;
    .dw 0xEEF4 ;
    .dw 0x39BD ;
    .dw 0xEEF5 ;
    .dw 0xE3EF ;
    .dw 0xEEF6 ;
    .dw 0xD1BB ;
    .dw 0xEEF7 ;
    .dw 0x8BB7 ;
    .dw 0xEEF8 ;
    .dw 0x48F ;
    .dw 0xEEF9 ;
    .dw 0x87D7 ;
    .dw 0xEEFA ;
    .dw 0x1F79 ;
    .dw 0xEEFB ;
    .dw 0xF563 ;
    .dw 0xEEFC ;
    .dw 0xFFE1 ;
    .dw 0xEEFD ;
    .dw 0x4A41 ;
    .dw 0xEEFE ;
    .dw 0xCD7F ;
    .dw 0xEEFF ;
    .dw 0xFAED ;
    .dw 0xEF00 ;
    .dw 0x5481 ;
    .dw 0xEF01 ;
    .dw 0x16B3 ;
    .dw 0xEF02 ;
    .dw 0x9E2F ;
    .dw 0xEF03 ;
    .dw 0x7041 ;
    .dw 0xEF04 ;
    .dw 0x23EF ;
    .dw 0xEF05 ;
    .dw 0x9791 ;
    .dw 0xEF06 ;
    .dw 0xB21B ;
    .dw 0xEF07 ;
    .dw 0xE5F9 ;
    .dw 0xEF08 ;
    .dw 0x25AD ;
    .dw 0xEF09 ;
    .dw 0x495 ;
    .dw 0xEF0A ;
    .dw 0x10F ;
    .dw 0xEF0B ;
    .dw 0x8895 ;
    .dw 0xEF0C ;
    .dw 0xC21B ;
    .dw 0xEF0D ;
    .dw 0x60CF ;
    .dw 0xEF0E ;
    .dw 0x4CB3 ;
    .dw 0xEF0F ;
    .dw 0xBB29 ;
    .dw 0xEF10 ;
    .dw 0x2D3 ;
    .dw 0xEF11 ;
    .dw 0xA00F ;
    .dw 0xEF12 ;
    .dw 0xA4A3 ;
    .dw 0xEF13 ;
    .dw 0xA5A5 ;
    .dw 0xEF14 ;
    .dw 0x3075 ;
    .dw 0xEF15 ;
    .dw 0xABEB ;
    .dw 0xEF16 ;
    .dw 0x1403 ;
    .dw 0xEF17 ;
    .dw 0x6E7F ;
    .dw 0xEF18 ;
    .dw 0x760B ;
    .dw 0xEF19 ;
    .dw 0xC02B ;
    .dw 0xEF1A ;
    .dw 0x9095 ;
    .dw 0xEF1B ;
    .dw 0x57F3 ;
    .dw 0xEF1C ;
    .dw 0x61DD ;
    .dw 0xEF1D ;
    .dw 0x16CB ;
    .dw 0xEF1E ;
    .dw 0xC35B ;
    .dw 0xEF1F ;
    .dw 0x78B7 ;
    .dw 0xEF20 ;
    .dw 0x9BC9 ;
    .dw 0xEF21 ;
    .dw 0x5B6D ;
    .dw 0xEF22 ;
    .dw 0xC2A3 ;
    .dw 0xEF23 ;
    .dw 0x4837 ;
    .dw 0xEF24 ;
    .dw 0xA915 ;
    .dw 0xEF25 ;
    .dw 0xDE4D ;
    .dw 0xEF26 ;
    .dw 0x55A9 ;
    .dw 0xEF27 ;
    .dw 0xB645 ;
    .dw 0xEF28 ;
    .dw 0x15D3 ;
    .dw 0xEF29 ;
    .dw 0xFEC9 ;
    .dw 0xEF2A ;
    .dw 0xD9A5 ;
    .dw 0xEF2B ;
    .dw 0x65D ;
    .dw 0xEF2C ;
    .dw 0xDBAD ;
    .dw 0xEF2D ;
    .dw 0xC547 ;
    .dw 0xEF2E ;
    .dw 0x606D ;
    .dw 0xEF2F ;
    .dw 0x2655 ;
    .dw 0xEF30 ;
    .dw 0x5E49 ;
    .dw 0xEF31 ;
    .dw 0x24B7 ;
    .dw 0xEF32 ;
    .dw 0x2087 ;
    .dw 0xEF33 ;
    .dw 0xB893 ;
    .dw 0xEF34 ;
    .dw 0xD515 ;
    .dw 0xEF35 ;
    .dw 0xDB85 ;
    .dw 0xEF36 ;
    .dw 0xCEC3 ;
    .dw 0xEF37 ;
    .dw 0x89C9 ;
    .dw 0xEF38 ;
    .dw 0x7AA7 ;
    .dw 0xEF39 ;
    .dw 0x6C1D ;
    .dw 0xEF3A ;
    .dw 0xF951 ;
    .dw 0xEF3B ;
    .dw 0xAA33 ;
    .dw 0xEF3C ;
    .dw 0x5991 ;
    .dw 0xEF3D ;
    .dw 0x24CF ;
    .dw 0xEF3E ;
    .dw 0xFC5D ;
    .dw 0xEF3F ;
    .dw 0xE23F ;
    .dw 0xEF40 ;
    .dw 0xEBB ;
    .dw 0xEF41 ;
    .dw 0xAF5D ;
    .dw 0xEF42 ;
    .dw 0xA823 ;
    .dw 0xEF43 ;
    .dw 0xBAD7 ;
    .dw 0xEF44 ;
    .dw 0x593D ;
    .dw 0xEF45 ;
    .dw 0x1FE1 ;
    .dw 0xEF46 ;
    .dw 0x3087 ;
    .dw 0xEF47 ;
    .dw 0xD109 ;
    .dw 0xEF48 ;
    .dw 0xCFAF ;
    .dw 0xEF49 ;
    .dw 0xFB51 ;
    .dw 0xEF4A ;
    .dw 0x7E31 ;
    .dw 0xEF4B ;
    .dw 0xAD4F ;
    .dw 0xEF4C ;
    .dw 0x930D ;
    .dw 0xEF4D ;
    .dw 0x2D71 ;
    .dw 0xEF4E ;
    .dw 0x7923 ;
    .dw 0xEF4F ;
    .dw 0xD635 ;
    .dw 0xEF50 ;
    .dw 0x5703 ;
    .dw 0xEF51 ;
    .dw 0x664D ;
    .dw 0xEF52 ;
    .dw 0x64CD ;
    .dw 0xEF53 ;
    .dw 0x56A1 ;
    .dw 0xEF54 ;
    .dw 0x97CF ;
    .dw 0xEF55 ;
    .dw 0xD72F ;
    .dw 0xEF56 ;
    .dw 0xE5AB ;
    .dw 0xEF57 ;
    .dw 0x6F85 ;
    .dw 0xEF58 ;
    .dw 0x5591 ;
    .dw 0xEF59 ;
    .dw 0xC719 ;
    .dw 0xEF5A ;
    .dw 0xC85B ;
    .dw 0xEF5B ;
    .dw 0xAD11 ;
    .dw 0xEF5C ;
    .dw 0x2D29 ;
    .dw 0xEF5D ;
    .dw 0xF6BD ;
    .dw 0xEF5E ;
    .dw 0x2233 ;
    .dw 0xEF5F ;
    .dw 0x1773 ;
    .dw 0xEF60 ;
    .dw 0x2689 ;
    .dw 0xEF61 ;
    .dw 0x4BF5 ;
    .dw 0xEF62 ;
    .dw 0xE35B ;
    .dw 0xEF63 ;
    .dw 0xB711 ;
    .dw 0xEF64 ;
    .dw 0x1095 ;
    .dw 0xEF65 ;
    .dw 0xBCBB ;
    .dw 0xEF66 ;
    .dw 0x7265 ;
    .dw 0xEF67 ;
    .dw 0x2437 ;
    .dw 0xEF68 ;
    .dw 0xC273 ;
    .dw 0xEF69 ;
    .dw 0xF19F ;
    .dw 0xEF6A ;
    .dw 0x6963 ;
    .dw 0xEF6B ;
    .dw 0x5A55 ;
    .dw 0xEF6C ;
    .dw 0x1A6B ;
    .dw 0xEF6D ;
    .dw 0x97BF ;
    .dw 0xEF6E ;
    .dw 0xC85 ;
    .dw 0xEF6F ;
    .dw 0x86BB ;
    .dw 0xEF70 ;
    .dw 0x1231 ;
    .dw 0xEF71 ;
    .dw 0xDA43 ;
    .dw 0xEF72 ;
    .dw 0x9225 ;
    .dw 0xEF73 ;
    .dw 0xAC5 ;
    .dw 0xEF74 ;
    .dw 0xC0D3 ;
    .dw 0xEF75 ;
    .dw 0xFB55 ;
    .dw 0xEF76 ;
    .dw 0xD46B ;
    .dw 0xEF77 ;
    .dw 0x69A1 ;
    .dw 0xEF78 ;
    .dw 0xA1FD ;
    .dw 0xEF79 ;
    .dw 0x8491 ;
    .dw 0xEF7A ;
    .dw 0x8463 ;
    .dw 0xEF7B ;
    .dw 0x597D ;
    .dw 0xEF7C ;
    .dw 0xFAD7 ;
    .dw 0xEF7D ;
    .dw 0x705 ;
    .dw 0xEF7E ;
    .dw 0x768D ;
    .dw 0xEF7F ;
    .dw 0xB045 ;
    .dw 0xEF80 ;
    .dw 0xB463 ;
    .dw 0xEF81 ;
    .dw 0xE2A7 ;
    .dw 0xEF82 ;
    .dw 0x20FF ;
    .dw 0xEF83 ;
    .dw 0x63D7 ;
    .dw 0xEF84 ;
    .dw 0x834F ;
    .dw 0xEF85 ;
    .dw 0xD4B ;
    .dw 0xEF86 ;
    .dw 0xE2F3 ;
    .dw 0xEF87 ;
    .dw 0x55BD ;
    .dw 0xEF88 ;
    .dw 0xB54F ;
    .dw 0xEF89 ;
    .dw 0x511F ;
    .dw 0xEF8A ;
    .dw 0x2DED ;
    .dw 0xEF8B ;
    .dw 0x2265 ;
    .dw 0xEF8C ;
    .dw 0x7BF5 ;
    .dw 0xEF8D ;
    .dw 0xFA9D ;
    .dw 0xEF8E ;
    .dw 0x2843 ;
    .dw 0xEF8F ;
    .dw 0xABD5 ;
    .dw 0xEF90 ;
    .dw 0xD03 ;
    .dw 0xEF91 ;
    .dw 0x6E0B ;
    .dw 0xEF92 ;
    .dw 0xE13F ;
    .dw 0xEF93 ;
    .dw 0x97E9 ;
    .dw 0xEF94 ;
    .dw 0x7051 ;
    .dw 0xEF95 ;
    .dw 0x9C69 ;
    .dw 0xEF96 ;
    .dw 0xAEB5 ;
    .dw 0xEF97 ;
    .dw 0x7A0D ;
    .dw 0xEF98 ;
    .dw 0x5315 ;
    .dw 0xEF99 ;
    .dw 0xCFF5 ;
    .dw 0xEF9A ;
    .dw 0xCC19 ;
    .dw 0xEF9B ;
    .dw 0xE069 ;
    .dw 0xEF9C ;
    .dw 0xB8C9 ;
    .dw 0xEF9D ;
    .dw 0xC815 ;
    .dw 0xEF9E ;
    .dw 0xD31B ;
    .dw 0xEF9F ;
    .dw 0xFCA3 ;
    .dw 0xEFA0 ;
    .dw 0xE179 ;
    .dw 0xEFA1 ;
    .dw 0x9CDF ;
    .dw 0xEFA2 ;
    .dw 0x25BB ;
    .dw 0xEFA3 ;
    .dw 0x2019 ;
    .dw 0xEFA4 ;
    .dw 0x3D9B ;
    .dw 0xEFA5 ;
    .dw 0x61FF ;
    .dw 0xEFA6 ;
    .dw 0xE1E3 ;
    .dw 0xEFA7 ;
    .dw 0xC38D ;
    .dw 0xEFA8 ;
    .dw 0xC773 ;
    .dw 0xEFA9 ;
    .dw 0x141 ;
    .dw 0xEFAA ;
    .dw 0x767D ;
    .dw 0xEFAB ;
    .dw 0x5269 ;
    .dw 0xEFAC ;
    .dw 0x99DB ;
    .dw 0xEFAD ;
    .dw 0x447D ;
    .dw 0xEFAE ;
    .dw 0x720D ;
    .dw 0xEFAF ;
    .dw 0x7173 ;
    .dw 0xEFB0 ;
    .dw 0x1CA7 ;
    .dw 0xEFB1 ;
    .dw 0x8711 ;
    .dw 0xEFB2 ;
    .dw 0xA2CB ;
    .dw 0xEFB3 ;
    .dw 0xF903 ;
    .dw 0xEFB4 ;
    .dw 0x9E77 ;
    .dw 0xEFB5 ;
    .dw 0x6DB ;
    .dw 0xEFB6 ;
    .dw 0x2035 ;
    .dw 0xEFB7 ;
    .dw 0x5ABB ;
    .dw 0xEFB8 ;
    .dw 0xB40F ;
    .dw 0xEFB9 ;
    .dw 0x4CB5 ;
    .dw 0xEFBA ;
    .dw 0x562D ;
    .dw 0xEFBB ;
    .dw 0xAAC3 ;
    .dw 0xEFBC ;
    .dw 0x3531 ;
    .dw 0xEFBD ;
    .dw 0xA461 ;
    .dw 0xEFBE ;
    .dw 0xA98F ;
    .dw 0xEFBF ;
    .dw 0x47F ;
    .dw 0xEFC0 ;
    .dw 0x2EF9 ;
    .dw 0xEFC1 ;
    .dw 0x1C0F ;
    .dw 0xEFC2 ;
    .dw 0xCE43 ;
    .dw 0xEFC3 ;
    .dw 0x82C5 ;
    .dw 0xEFC4 ;
    .dw 0xA3A9 ;
    .dw 0xEFC5 ;
    .dw 0x34B ;
    .dw 0xEFC6 ;
    .dw 0x66E3 ;
    .dw 0xEFC7 ;
    .dw 0x8395 ;
    .dw 0xEFC8 ;
    .dw 0x700D ;
    .dw 0xEFC9 ;
    .dw 0x6179 ;
    .dw 0xEFCA ;
    .dw 0x5C3 ;
    .dw 0xEFCB ;
    .dw 0x6F55 ;
    .dw 0xEFCC ;
    .dw 0x2E51 ;
    .dw 0xEFCD ;
    .dw 0x5BCF ;
    .dw 0xEFCE ;
    .dw 0x2795 ;
    .dw 0xEFCF ;
    .dw 0xBB87 ;
    .dw 0xEFD0 ;
    .dw 0x6E4F ;
    .dw 0xEFD1 ;
    .dw 0x2C7 ;
    .dw 0xEFD2 ;
    .dw 0x3F7B ;
    .dw 0xEFD3 ;
    .dw 0x60FD ;
    .dw 0xEFD4 ;
    .dw 0x1B77 ;
    .dw 0xEFD5 ;
    .dw 0x7F1B ;
    .dw 0xEFD6 ;
    .dw 0x6C9F ;
    .dw 0xEFD7 ;
    .dw 0x7D99 ;
    .dw 0xEFD8 ;
    .dw 0x6817 ;
    .dw 0xEFD9 ;
    .dw 0x163F ;
    .dw 0xEFDA ;
    .dw 0xF151 ;
    .dw 0xEFDB ;
    .dw 0x597D ;
    .dw 0xEFDC ;
    .dw 0x163F ;
    .dw 0xEFDD ;
    .dw 0xFE55 ;
    .dw 0xEFDE ;
    .dw 0x395 ;
    .dw 0xEFDF ;
    .dw 0x87C7 ;
    .dw 0xEFE0 ;
    .dw 0x7615 ;
    .dw 0xEFE1 ;
    .dw 0x79A7 ;
    .dw 0xEFE2 ;
    .dw 0xF45 ;
    .dw 0xEFE3 ;
    .dw 0x5ACB ;
    .dw 0xEFE4 ;
    .dw 0xF1A7 ;
    .dw 0xEFE5 ;
    .dw 0x319B ;
    .dw 0xEFE6 ;
    .dw 0x1A3 ;
    .dw 0xEFE7 ;
    .dw 0x63C5 ;
    .dw 0xEFE8 ;
    .dw 0x7E4F ;
    .dw 0xEFE9 ;
    .dw 0x4935 ;
    .dw 0xEFEA ;
    .dw 0xB66F ;
    .dw 0xEFEB ;
    .dw 0x3617 ;
    .dw 0xEFEC ;
    .dw 0xCB83 ;
    .dw 0xEFED ;
    .dw 0x1F03 ;
    .dw 0xEFEE ;
    .dw 0x1E89 ;
    .dw 0xEFEF ;
    .dw 0x25FF ;
    .dw 0xEFF0 ;
    .dw 0x872B ;
    .dw 0xEFF1 ;
    .dw 0x369D ;
    .dw 0xEFF2 ;
    .dw 0x37FB ;
    .dw 0xEFF3 ;
    .dw 0x3ACB ;
    .dw 0xEFF4 ;
    .dw 0x8F81 ;
    .dw 0xEFF5 ;
    .dw 0x4199 ;
    .dw 0xEFF6 ;
    .dw 0x6FA1 ;
    .dw 0xEFF7 ;
    .dw 0xC99 ;
    .dw 0xEFF8 ;
    .dw 0x6A5F ;
    .dw 0xEFF9 ;
    .dw 0xC007 ;
    .dw 0xEFFA ;
    .dw 0x8433 ;
    .dw 0xEFFB ;
    .dw 0xC585 ;
    .dw 0xEFFC ;
    .dw 0xDA23 ;
    .dw 0xEFFD ;
    .dw 0x3065 ;
    .dw 0xEFFE ;
    .dw 0x82E1 ;
    .dw 0xEFFF ;
    .dw 0xFE6D ;
    .dw 0xC700 ;
    .dw 0xE7FB ;
    .dw 0xC701 ;
    .dw 0x4717 ;
    .dw 0xC702 ;
    .dw 0xF573 ;
    .dw 0xC703 ;
    .dw 0xAF1D ;
    .dw 0xC704 ;
    .dw 0x3BC7 ;
    .dw 0xC705 ;
    .dw 0x2563 ;
    .dw 0xC706 ;
    .dw 0xD9D3 ;
    .dw 0xC707 ;
    .dw 0xEA0F ;
    .dw 0xC708 ;
    .dw 0x1969 ;
    .dw 0xC709 ;
    .dw 0x7E5 ;
    .dw 0xC70A ;
    .dw 0x7B31 ;
    .dw 0xC70B ;
    .dw 0x9BA1 ;
    .dw 0xC70C ;
    .dw 0xDBA3 ;
    .dw 0xC70D ;
    .dw 0x6489 ;
    .dw 0xC70E ;
    .dw 0xC499 ;
    .dw 0xC70F ;
    .dw 0x4CD ;
    .dw 0xC710 ;
    .dw 0x446B ;
    .dw 0xC711 ;
    .dw 0xF003 ;
    .dw 0xC712 ;
    .dw 0x24FF ;
    .dw 0xC713 ;
    .dw 0x295D ;
    .dw 0xC714 ;
    .dw 0x7AC3 ;
    .dw 0xC715 ;
    .dw 0x82C5 ;
    .dw 0xC716 ;
    .dw 0x9CED ;
    .dw 0xC717 ;
    .dw 0xE9A9 ;
    .dw 0xC718 ;
    .dw 0xE15 ;
    .dw 0xC719 ;
    .dw 0x557B ;
    .dw 0xC71A ;
    .dw 0xD83 ;
    .dw 0xC71B ;
    .dw 0xFFCD ;
    .dw 0xC71C ;
    .dw 0xD70B ;
    .dw 0xC71D ;
    .dw 0x8CFD ;
    .dw 0xC71E ;
    .dw 0x6121 ;
    .dw 0xC71F ;
    .dw 0x985F ;
    .dw 0xC720 ;
    .dw 0xDDD ;
    .dw 0xC721 ;
    .dw 0x8DCF ;
    .dw 0xC722 ;
    .dw 0xA579 ;
    .dw 0xC723 ;
    .dw 0xBEA9 ;
    .dw 0xC724 ;
    .dw 0x6E39 ;
    .dw 0xC725 ;
    .dw 0xF0F ;
    .dw 0xC726 ;
    .dw 0xAF23 ;
    .dw 0xC727 ;
    .dw 0x5461 ;
    .dw 0xC728 ;
    .dw 0xC08B ;
    .dw 0xC729 ;
    .dw 0x64F9 ;
    .dw 0xC72A ;
    .dw 0x5EBB ;
    .dw 0xC72B ;
    .dw 0xCCE3 ;
    .dw 0xC72C ;
    .dw 0xA0E1 ;
    .dw 0xC72D ;
    .dw 0xFAD1 ;
    .dw 0xC72E ;
    .dw 0x1F75 ;
    .dw 0xC72F ;
    .dw 0x63DF ;
    .dw 0xC730 ;
    .dw 0xDB3D ;
    .dw 0xC731 ;
    .dw 0x7469 ;
    .dw 0xC732 ;
    .dw 0xB735 ;
    .dw 0xC733 ;
    .dw 0x7A1 ;
    .dw 0xC734 ;
    .dw 0x356F ;
    .dw 0xC735 ;
    .dw 0x6F0F ;
    .dw 0xC736 ;
    .dw 0x2F ;
    .dw 0xC737 ;
    .dw 0xAEB9 ;
    .dw 0xC738 ;
    .dw 0xFE6D ;
    .dw 0xC739 ;
    .dw 0x5A0B ;
    .dw 0xC73A ;
    .dw 0xA3F1 ;
    .dw 0xC73B ;
    .dw 0x5143 ;
    .dw 0xC73C ;
    .dw 0x3B29 ;
    .dw 0xC73D ;
    .dw 0x5E91 ;
    .dw 0xC73E ;
    .dw 0x7007 ;
    .dw 0xC73F ;
    .dw 0x3D8D ;
    .dw 0xC740 ;
    .dw 0xC8EB ;
    .dw 0xC741 ;
    .dw 0xCF3F ;
    .dw 0xC742 ;
    .dw 0x5C0B ;
    .dw 0xC743 ;
    .dw 0x61 ;
    .dw 0xC744 ;
    .dw 0x4D2B ;
    .dw 0xC745 ;
    .dw 0x1713 ;
    .dw 0xC746 ;
    .dw 0xD945 ;
    .dw 0xC747 ;
    .dw 0x98AD ;
    .dw 0xC748 ;
    .dw 0x4AE3 ;
    .dw 0xC749 ;
    .dw 0x9FDF ;
    .dw 0xC74A ;
    .dw 0x83BB ;
    .dw 0xC74B ;
    .dw 0x2EC9 ;
    .dw 0xC74C ;
    .dw 0x356B ;
    .dw 0xC74D ;
    .dw 0xA84B ;
    .dw 0xC74E ;
    .dw 0xCCCD ;
    .dw 0xC74F ;
    .dw 0x727 ;
    .dw 0xC750 ;
    .dw 0xD8D1 ;
    .dw 0xC751 ;
    .dw 0x813F ;
    .dw 0xC752 ;
    .dw 0xB74F ;
    .dw 0xC753 ;
    .dw 0xE887 ;
    .dw 0xC754 ;
    .dw 0xEFB3 ;
    .dw 0xC755 ;
    .dw 0x2AE7 ;
    .dw 0xC756 ;
    .dw 0x3D1B ;
    .dw 0xC757 ;
    .dw 0xADBB ;
    .dw 0xC758 ;
    .dw 0x3E93 ;
    .dw 0xC759 ;
    .dw 0xC925 ;
    .dw 0xC75A ;
    .dw 0x762D ;
    .dw 0xC75B ;
    .dw 0x3AD7 ;
    .dw 0xC75C ;
    .dw 0xCAB ;
    .dw 0xC75D ;
    .dw 0xE78D ;
    .dw 0xC75E ;
    .dw 0x193F ;
    .dw 0xC75F ;
    .dw 0x8DE9 ;
    .dw 0xC760 ;
    .dw 0x5255 ;
    .dw 0xC761 ;
    .dw 0x4D7 ;
    .dw 0xC762 ;
    .dw 0x6DD7 ;
    .dw 0xC763 ;
    .dw 0x2333 ;
    .dw 0xC764 ;
    .dw 0x74CF ;
    .dw 0xC765 ;
    .dw 0x5DDB ;
    .dw 0xC766 ;
    .dw 0x47E5 ;
    .dw 0xC767 ;
    .dw 0x64E1 ;
    .dw 0xC768 ;
    .dw 0xE7A1 ;
    .dw 0xC769 ;
    .dw 0x700B ;
    .dw 0xC76A ;
    .dw 0x24E1 ;
    .dw 0xC76B ;
    .dw 0x5E49 ;
    .dw 0xC76C ;
    .dw 0x8B73 ;
    .dw 0xC76D ;
    .dw 0x2B65 ;
    .dw 0xC76E ;
    .dw 0x253 ;
    .dw 0xC76F ;
    .dw 0x6A93 ;
    .dw 0xC770 ;
    .dw 0x225B ;
    .dw 0xC771 ;
    .dw 0x4BF5 ;
    .dw 0xC772 ;
    .dw 0x5F9 ;
    .dw 0xC773 ;
    .dw 0x1701 ;
    .dw 0xC774 ;
    .dw 0xB1C3 ;
    .dw 0xC775 ;
    .dw 0xD2BD ;
    .dw 0xC776 ;
    .dw 0x8F5D ;
    .dw 0xC777 ;
    .dw 0xF09F ;
    .dw 0xC778 ;
    .dw 0x29B7 ;
    .dw 0xC779 ;
    .dw 0x163D ;
    .dw 0xC77A ;
    .dw 0xCAE9 ;
    .dw 0xC77B ;
    .dw 0x757B ;
    .dw 0xC77C ;
    .dw 0x29C5 ;
    .dw 0xC77D ;
    .dw 0x6263 ;
    .dw 0xC77E ;
    .dw 0x5E7D ;
    .dw 0xC77F ;
    .dw 0xE161 ;
    .dw 0xC780 ;
    .dw 0x3B49 ;
    .dw 0xC781 ;
    .dw 0xA005 ;
    .dw 0xC782 ;
    .dw 0x478D ;
    .dw 0xC783 ;
    .dw 0xE0F ;
    .dw 0xC784 ;
    .dw 0x5955 ;
    .dw 0xC785 ;
    .dw 0xFBD9 ;
    .dw 0xC786 ;
    .dw 0x82B7 ;
    .dw 0xC787 ;
    .dw 0x1EEF ;
    .dw 0xC788 ;
    .dw 0x1DF9 ;
    .dw 0xC789 ;
    .dw 0x4E9 ;
    .dw 0xC78A ;
    .dw 0x94DD ;
    .dw 0xC78B ;
    .dw 0x304D ;
    .dw 0xC78C ;
    .dw 0x6D27 ;
    .dw 0xC78D ;
    .dw 0x3A93 ;
    .dw 0xC78E ;
    .dw 0x8DB3 ;
    .dw 0xC78F ;
    .dw 0xC213 ;
    .dw 0xC790 ;
    .dw 0xF507 ;
    .dw 0xC791 ;
    .dw 0x81F9 ;
    .dw 0xC792 ;
    .dw 0x9BE7 ;
    .dw 0xC793 ;
    .dw 0x15FD ;
    .dw 0xC794 ;
    .dw 0x5BCB ;
    .dw 0xC795 ;
    .dw 0x7AFF ;
    .dw 0xC796 ;
    .dw 0xCAA9 ;
    .dw 0xC797 ;
    .dw 0x3951 ;
    .dw 0xC798 ;
    .dw 0x730D ;
    .dw 0xC799 ;
    .dw 0x2CBF ;
    .dw 0xC79A ;
    .dw 0xD3 ;
    .dw 0xC79B ;
    .dw 0xF21D ;
    .dw 0xC79C ;
    .dw 0x48A3 ;
    .dw 0xC79D ;
    .dw 0x183 ;
    .dw 0xC79E ;
    .dw 0xD96D ;
    .dw 0xC79F ;
    .dw 0x47E7 ;
    .dw 0xC7A0 ;
    .dw 0x6CF9 ;
    .dw 0xC7A1 ;
    .dw 0x8A3D ;
    .dw 0xC7A2 ;
    .dw 0x6DDD ;
    .dw 0xC7A3 ;
    .dw 0xDFE7 ;
    .dw 0xC7A4 ;
    .dw 0x46EB ;
    .dw 0xC7A5 ;
    .dw 0x17D ;
    .dw 0xC7A6 ;
    .dw 0xA96B ;
    .dw 0xC7A7 ;
    .dw 0xE4C5 ;
    .dw 0xC7A8 ;
    .dw 0xCD17 ;
    .dw 0xC7A9 ;
    .dw 0x5ED ;
    .dw 0xC7AA ;
    .dw 0x3E5F ;
    .dw 0xC7AB ;
    .dw 0xB1C9 ;
    .dw 0xC7AC ;
    .dw 0x7CBB ;
    .dw 0xC7AD ;
    .dw 0x8443 ;
    .dw 0xC7AE ;
    .dw 0xD4A1 ;
    .dw 0xC7AF ;
    .dw 0xF999 ;
    .dw 0xC7B0 ;
    .dw 0xE607 ;
    .dw 0xC7B1 ;
    .dw 0x48BF ;
    .dw 0xC7B2 ;
    .dw 0x89C7 ;
    .dw 0xC7B3 ;
    .dw 0xA06D ;
    .dw 0xC7B4 ;
    .dw 0xA5FD ;
    .dw 0xC7B5 ;
    .dw 0x3021 ;
    .dw 0xC7B6 ;
    .dw 0x5AAF ;
    .dw 0xC7B7 ;
    .dw 0x1C7 ;
    .dw 0xC7B8 ;
    .dw 0x25C1 ;
    .dw 0xC7B9 ;
    .dw 0x701F ;
    .dw 0xC7BA ;
    .dw 0x8E99 ;
    .dw 0xC7BB ;
    .dw 0xD9AF ;
    .dw 0xC7BC ;
    .dw 0xF775 ;
    .dw 0xC7BD ;
    .dw 0xEF5D ;
    .dw 0xC7BE ;
    .dw 0xBBC3 ;
    .dw 0xC7BF ;
    .dw 0x8969 ;
    .dw 0xC7C0 ;
    .dw 0x2895 ;
    .dw 0xC7C1 ;
    .dw 0x24ED ;
    .dw 0xC7C2 ;
    .dw 0x7D79 ;
    .dw 0xC7C3 ;
    .dw 0xEFA9 ;
    .dw 0xC7C4 ;
    .dw 0x61C3 ;
    .dw 0xC7C5 ;
    .dw 0x7737 ;
    .dw 0xC7C6 ;
    .dw 0x73AD ;
    .dw 0xC7C7 ;
    .dw 0x8C53 ;
    .dw 0xC7C8 ;
    .dw 0x2C2D ;
    .dw 0xC7C9 ;
    .dw 0x9283 ;
    .dw 0xC7CA ;
    .dw 0xA419 ;
    .dw 0xC7CB ;
    .dw 0x27AD ;
    .dw 0xC7CC ;
    .dw 0x345B ;
    .dw 0xC7CD ;
    .dw 0xAEE3 ;
    .dw 0xC7CE ;
    .dw 0xD4CB ;
    .dw 0xC7CF ;
    .dw 0xB513 ;
    .dw 0xC7D0 ;
    .dw 0xE289 ;
    .dw 0xC7D1 ;
    .dw 0x3DB5 ;
    .dw 0xC7D2 ;
    .dw 0xF849 ;
    .dw 0xC7D3 ;
    .dw 0xA93F ;
    .dw 0xC7D4 ;
    .dw 0x2087 ;
    .dw 0xC7D5 ;
    .dw 0xF68F ;
    .dw 0xC7D6 ;
    .dw 0x431B ;
    .dw 0xC7D7 ;
    .dw 0x7BEB ;
    .dw 0xC7D8 ;
    .dw 0xA503 ;
    .dw 0xC7D9 ;
    .dw 0xBBC9 ;
    .dw 0xC7DA ;
    .dw 0x2F1 ;
    .dw 0xC7DB ;
    .dw 0x8D1F ;
    .dw 0xC7DC ;
    .dw 0x9C6F ;
    .dw 0xC7DD ;
    .dw 0x4E61 ;
    .dw 0xC7DE ;
    .dw 0xCF2F ;
    .dw 0xC7DF ;
    .dw 0x25D7 ;
    .dw 0xC7E0 ;
    .dw 0x74B ;
    .dw 0xC7E1 ;
    .dw 0x4983 ;
    .dw 0xC7E2 ;
    .dw 0x2B0D ;
    .dw 0xC7E3 ;
    .dw 0xCC47 ;
    .dw 0xC7E4 ;
    .dw 0xA60D ;
    .dw 0xC7E5 ;
    .dw 0x5D77 ;
    .dw 0xC7E6 ;
    .dw 0x312F ;
    .dw 0xC7E7 ;
    .dw 0xA38B ;
    .dw 0xC7E8 ;
    .dw 0xCA6B ;
    .dw 0xC7E9 ;
    .dw 0x421D ;
    .dw 0xC7EA ;
    .dw 0x60B7 ;
    .dw 0xC7EB ;
    .dw 0xEE7 ;
    .dw 0xC7EC ;
    .dw 0xE637 ;
    .dw 0xC7ED ;
    .dw 0x58E7 ;
    .dw 0xC7EE ;
    .dw 0x23E1 ;
    .dw 0xC7EF ;
    .dw 0x5073 ;
    .dw 0xC7F0 ;
    .dw 0x2FC1 ;
    .dw 0xC7F1 ;
    .dw 0x7649 ;
    .dw 0xC7F2 ;
    .dw 0x281D ;
    .dw 0xC7F3 ;
    .dw 0x5B63 ;
    .dw 0xC7F4 ;
    .dw 0x339B ;
    .dw 0xC7F5 ;
    .dw 0xCABD ;
    .dw 0xC7F6 ;
    .dw 0x1FA1 ;
    .dw 0xC7F7 ;
    .dw 0x91B3 ;
    .dw 0xC7F8 ;
    .dw 0xAC07 ;
    .dw 0xC7F9 ;
    .dw 0x632F ;
    .dw 0xC7FA ;
    .dw 0x485 ;
    .dw 0xC7FB ;
    .dw 0xA55F ;
    .dw 0xC7FC ;
    .dw 0x75BD ;
    .dw 0xC7FD ;
    .dw 0x38FF ;
    .dw 0xC7FE ;
    .dw 0x755D ;
    .dw 0xC7FF ;
    .dw 0x5523 ;
    .dw 0xE0C0 ;
    .dw 0x0000 ;
    .dw 0xE0A0 ;
    .dw 0x8000 ;
    .dw 0xE1A0 ;
    .dw 0x0 ;
    .dw 0xC401 ;
    .dw 0x4000 ;
    .dw 0xC404 ;
    .dw 0xC000 ;
    .dw 0xC406 ;
    .dw 0xC000 ;
    .dw 0xC407 ;
    .dw 0xC000 ;
    .dw 0xC40A ;
    .dw 0x8000 ;
    .dw 0xC40A ;
    .dw 0xC000 ;
    .dw 0xC40C ;
    .dw 0x8000 ;
    .dw 0xC40E ;
    .dw 0x8000 ;
    .dw 0xC40F ;
    .dw 0x0 ;
    .dw 0xC40F ;
    .dw 0x4000 ;
    .dw 0xC40F ;
    .dw 0x8000 ;
    .dw 0xC410 ;
    .dw 0x8000 ;
    .dw 0xC411 ;
    .dw 0x8000 ;
    .dw 0xC411 ;
    .dw 0xC000 ;
    .dw 0xC412 ;
    .dw 0x4000 ;
    .dw 0xC412 ;
    .dw 0x8000 ;
    .dw 0xC413 ;
    .dw 0x0 ;
    .dw 0xC413 ;
    .dw 0x4000 ;
    .dw 0xC413 ;
    .dw 0x8000 ;
    .dw 0xC413 ;
    .dw 0xC000 ;
    .dw 0xC414 ;
    .dw 0x8000 ;
    .dw 0xC414 ;
    .dw 0xC000 ;
    .dw 0xC415 ;
    .dw 0x8000 ;
    .dw 0xC415 ;
    .dw 0xC000 ;
    .dw 0xC418 ;
    .dw 0x8000 ;
    .dw 0xC418 ;
    .dw 0xC000 ;
    .dw 0xC417 ;
    .dw 0x4000 ;
    .dw 0xC417 ;
    .dw 0x8000 ;
    .dw 0xC417 ;
    .dw 0xC000 ;
    .dw 0xC419 ;
    .dw 0x0 ;
    .dw 0xC419 ;
    .dw 0x4000 ;
    .dw 0xC419 ;
    .dw 0x8000 ;
    .dw 0xC419 ;
    .dw 0xC000 ;
    .dw 0xC41A ;
    .dw 0x0 ;
    .dw 0xC41A ;
    .dw 0x4000 ;
    .dw 0xC41A ;
    .dw 0x8000 ;
    .dw 0xC41A ;
    .dw 0xC000 ;
    .dw 0xC41B ;
    .dw 0x0 ;
    .dw 0xC41B ;
    .dw 0x4000 ;
    .dw 0xC41B ;
    .dw 0x8000 ;
    .dw 0xC41B ;
    .dw 0xC000 ;
    .dw 0xC41C ;
    .dw 0x0 ;
    .dw 0xC41C ;
    .dw 0x4000 ;
    .dw 0xC41C ;
    .dw 0x8000 ;
    .dw 0xC41C ;
    .dw 0xC000 ;
    .dw 0xC41D ;
    .dw 0x0 ;
    .dw 0xC41D ;
    .dw 0x4000 ;
    .dw 0xC41D ;
    .dw 0x8000 ;
    .dw 0xC41D ;
    .dw 0xC000 ;
    .dw 0xC41E ;
    .dw 0x0 ;
    .dw 0xC41E ;
    .dw 0x4000 ;
    .dw 0xC41E ;
    .dw 0x8000 ;
    .dw 0xC41E ;
    .dw 0xC000 ;
    .dw 0xC41F ;
    .dw 0x0 ;
    .dw 0xC41F ;
    .dw 0x4000 ;
    .dw 0xC41F ;
    .dw 0x8000 ;
    .dw 0xC41F ;
    .dw 0xC000 ;
    .dw 0xC401 ;
    .dw 0x0 ;
    .dw 0xC401 ;
    .dw 0x240 ;
    .dw 0xC401 ;
    .dw 0x480 ;
    .dw 0xC401 ;
    .dw 0x6C0 ;
    .dw 0xC401 ;
    .dw 0x900 ;
    .dw 0xC401 ;
    .dw 0xB40 ;
    .dw 0xC401 ;
    .dw 0xD80 ;
    .dw 0xC401 ;
    .dw 0xFC0 ;
    .dw 0xC401 ;
    .dw 0x8000 ;
    .dw 0xC401 ;
    .dw 0x8240 ;
    .dw 0xC401 ;
    .dw 0x8480 ;
    .dw 0xC401 ;
    .dw 0x86C0 ;
    .dw 0xC401 ;
    .dw 0x8900 ;
    .dw 0xC401 ;
    .dw 0x8B40 ;
    .dw 0xC401 ;
    .dw 0x8D80 ;
    .dw 0xC401 ;
    .dw 0x8FC0 ;
    .dw 0xC401 ;
    .dw 0xC000 ;
    .dw 0xC401 ;
    .dw 0xC240 ;
    .dw 0xC401 ;
    .dw 0xC480 ;
    .dw 0xC401 ;
    .dw 0xC6C0 ;
    .dw 0xC401 ;
    .dw 0xC900 ;
    .dw 0xC401 ;
    .dw 0xCB40 ;
    .dw 0xC401 ;
    .dw 0xCD80 ;
    .dw 0xC401 ;
    .dw 0xCFC0 ;
    .dw 0xC404 ;
    .dw 0x8000 ;
    .dw 0xC404 ;
    .dw 0x8240 ;
    .dw 0xC404 ;
    .dw 0x8480 ;
    .dw 0xC404 ;
    .dw 0x86C0 ;
    .dw 0xC404 ;
    .dw 0x8900 ;
    .dw 0xC404 ;
    .dw 0x8B40 ;
    .dw 0xC404 ;
    .dw 0x8D80 ;
    .dw 0xC404 ;
    .dw 0x8FC0 ;
    .dw 0xC40C ;
    .dw 0x4000 ;
    .dw 0xC40C ;
    .dw 0x4240 ;
    .dw 0xC40C ;
    .dw 0x4480 ;
    .dw 0xC40C ;
    .dw 0x46C0 ;
    .dw 0xC40C ;
    .dw 0x4900 ;
    .dw 0xC40C ;
    .dw 0x4B40 ;
    .dw 0xC40C ;
    .dw 0x4D80 ;
    .dw 0xC40C ;
    .dw 0x4FC0 ;
    .dw 0xC40D ;
    .dw 0x0 ;
    .dw 0xC40D ;
    .dw 0x240 ;
    .dw 0xC40D ;
    .dw 0x480 ;
    .dw 0xC40D ;
    .dw 0x6C0 ;
    .dw 0xC40D ;
    .dw 0x900 ;
    .dw 0xC40D ;
    .dw 0xB40 ;
    .dw 0xC40D ;
    .dw 0xD80 ;
    .dw 0xC40D ;
    .dw 0xFC0 ;
    .dw 0xC40D ;
    .dw 0x4000 ;
    .dw 0xC40D ;
    .dw 0x4240 ;
    .dw 0xC40D ;
    .dw 0x4480 ;
    .dw 0xC40D ;
    .dw 0x46C0 ;
    .dw 0xC40D ;
    .dw 0x4900 ;
    .dw 0xC40D ;
    .dw 0x4B40 ;
    .dw 0xC40D ;
    .dw 0x4D80 ;
    .dw 0xC40D ;
    .dw 0x4FC0 ;
    .dw 0xC40D ;
    .dw 0x8000 ;
    .dw 0xC40D ;
    .dw 0x8240 ;
    .dw 0xC40D ;
    .dw 0x8480 ;
    .dw 0xC40D ;
    .dw 0x86C0 ;
    .dw 0xC40D ;
    .dw 0x8900 ;
    .dw 0xC40D ;
    .dw 0x8B40 ;
    .dw 0xC40D ;
    .dw 0x8D80 ;
    .dw 0xC40D ;
    .dw 0x8FC0 ;
    .dw 0xC40D ;
    .dw 0xC000 ;
    .dw 0xC40D ;
    .dw 0xC240 ;
    .dw 0xC40D ;
    .dw 0xC480 ;
    .dw 0xC40D ;
    .dw 0xC6C0 ;
    .dw 0xC40D ;
    .dw 0xC900 ;
    .dw 0xC40D ;
    .dw 0xCB40 ;
    .dw 0xC40D ;
    .dw 0xCD80 ;
    .dw 0xC40D ;
    .dw 0xCFC0 ;
    .dw 0xC411 ;
    .dw 0x0 ;
    .dw 0xC411 ;
    .dw 0x240 ;
    .dw 0xC411 ;
    .dw 0x480 ;
    .dw 0xC411 ;
    .dw 0x6C0 ;
    .dw 0xC411 ;
    .dw 0x900 ;
    .dw 0xC411 ;
    .dw 0xB40 ;
    .dw 0xC411 ;
    .dw 0xD80 ;
    .dw 0xC411 ;
    .dw 0xFC0 ;
    .dw 0xC411 ;
    .dw 0x4000 ;
    .dw 0xC411 ;
    .dw 0x4240 ;
    .dw 0xC411 ;
    .dw 0x4480 ;
    .dw 0xC411 ;
    .dw 0x46C0 ;
    .dw 0xC411 ;
    .dw 0x4900 ;
    .dw 0xC411 ;
    .dw 0x4B40 ;
    .dw 0xC411 ;
    .dw 0x4D80 ;
    .dw 0xC411 ;
    .dw 0x4FC0 ;
    .dw 0xC415 ;
    .dw 0x0 ;
    .dw 0xC415 ;
    .dw 0x240 ;
    .dw 0xC415 ;
    .dw 0x480 ;
    .dw 0xC415 ;
    .dw 0x6C0 ;
    .dw 0xC415 ;
    .dw 0x900 ;
    .dw 0xC415 ;
    .dw 0xB40 ;
    .dw 0xC415 ;
    .dw 0xD80 ;
    .dw 0xC415 ;
    .dw 0xFC0 ;
    .dw 0xC415 ;
    .dw 0x4000 ;
    .dw 0xC415 ;
    .dw 0x4240 ;
    .dw 0xC415 ;
    .dw 0x4480 ;
    .dw 0xC415 ;
    .dw 0x46C0 ;
    .dw 0xC415 ;
    .dw 0x4900 ;
    .dw 0xC415 ;
    .dw 0x4B40 ;
    .dw 0xC415 ;
    .dw 0x4D80 ;
    .dw 0xC415 ;
    .dw 0x4FC0 ;
    .dw 0xC418 ;
    .dw 0x4000 ;
    .dw 0xC418 ;
    .dw 0x4240 ;
    .dw 0xC418 ;
    .dw 0x4480 ;
    .dw 0xC418 ;
    .dw 0x46C0 ;
    .dw 0xC418 ;
    .dw 0x4900 ;
    .dw 0xC418 ;
    .dw 0x4B40 ;
    .dw 0xC418 ;
    .dw 0x4D80 ;
    .dw 0xC418 ;
    .dw 0x4FC0 ;
    .dw 0xC412 ;
    .dw 0x9 ;
    .dw 0xC412 ;
    .dw 0x1B ;
    .dw 0xC412 ;
    .dw 0x24 ;
    .dw 0xC412 ;
    .dw 0x2D ;
    .dw 0xC412 ;
    .dw 0x36 ;
    .dw 0xC412 ;
    .dw 0x3F ;
    .dw 0xC414 ;
    .dw 0x9 ;
    .dw 0xC414 ;
    .dw 0x1B ;
    .dw 0xC414 ;
    .dw 0x24 ;
    .dw 0xC414 ;
    .dw 0x2D ;
    .dw 0xC414 ;
    .dw 0x36 ;
    .dw 0xC414 ;
    .dw 0x3F ;
    .dw 0xC414 ;
    .dw 0x4009 ;
    .dw 0xC414 ;
    .dw 0x401B ;
    .dw 0xC414 ;
    .dw 0x4024 ;
    .dw 0xC414 ;
    .dw 0x402D ;
    .dw 0xC414 ;
    .dw 0x4036 ;
    .dw 0xC414 ;
    .dw 0x403F ;
    .dw 0xC415 ;
    .dw 0x9 ;
    .dw 0xC415 ;
    .dw 0x1B ;
    .dw 0xC415 ;
    .dw 0x24 ;
    .dw 0xC415 ;
    .dw 0x2D ;
    .dw 0xC415 ;
    .dw 0x36 ;
    .dw 0xC415 ;
    .dw 0x3F ;
    .dw 0xC415 ;
    .dw 0x4009 ;
    .dw 0xC415 ;
    .dw 0x401B ;
    .dw 0xC415 ;
    .dw 0x4024 ;
    .dw 0xC415 ;
    .dw 0x402D ;
    .dw 0xC415 ;
    .dw 0x4036 ;
    .dw 0xC415 ;
    .dw 0x403F ;
    .dw 0xC416 ;
    .dw 0x9 ;
    .dw 0xC416 ;
    .dw 0x1B ;
    .dw 0xC416 ;
    .dw 0x24 ;
    .dw 0xC416 ;
    .dw 0x2D ;
    .dw 0xC416 ;
    .dw 0x36 ;
    .dw 0xC416 ;
    .dw 0x3F ;
    .dw 0xC416 ;
    .dw 0x4009 ;
    .dw 0xC416 ;
    .dw 0x401B ;
    .dw 0xC416 ;
    .dw 0x4024 ;
    .dw 0xC416 ;
    .dw 0x402D ;
    .dw 0xC416 ;
    .dw 0x4036 ;
    .dw 0xC416 ;
    .dw 0x403F ;
    .dw 0xC416 ;
    .dw 0x8009 ;
    .dw 0xC416 ;
    .dw 0x801B ;
    .dw 0xC416 ;
    .dw 0x8024 ;
    .dw 0xC416 ;
    .dw 0x802D ;
    .dw 0xC416 ;
    .dw 0x8036 ;
    .dw 0xC416 ;
    .dw 0x803F ;
    .dw 0xC416 ;
    .dw 0xC009 ;
    .dw 0xC416 ;
    .dw 0xC01B ;
    .dw 0xC416 ;
    .dw 0xC024 ;
    .dw 0xC416 ;
    .dw 0xC02D ;
    .dw 0xC416 ;
    .dw 0xC036 ;
    .dw 0xC416 ;
    .dw 0xC03F ;
    .dw 0xC417 ;
    .dw 0x9 ;
    .dw 0xC417 ;
    .dw 0x1B ;
    .dw 0xC417 ;
    .dw 0x24 ;
    .dw 0xC417 ;
    .dw 0x2D ;
    .dw 0xC417 ;
    .dw 0x36 ;
    .dw 0xC417 ;
    .dw 0x3F ;
    .dw 0xC418 ;
    .dw 0x4009 ;
    .dw 0xC418 ;
    .dw 0x401B ;
    .dw 0xC418 ;
    .dw 0x4024 ;
    .dw 0xC418 ;
    .dw 0x402D ;
    .dw 0xC418 ;
    .dw 0x4036 ;
    .dw 0xC418 ;
    .dw 0x403F ;
    .dw 0xC600 ;
    .dw 0xC000 ;
    .dw 0xC601 ;
    .dw 0xC000 ;
    .dw 0xC603 ;
    .dw 0xC000 ;
    .dw 0xC605 ;
    .dw 0xC000 ;
    .dw 0xC608 ;
    .dw 0xC000 ;
    .dw 0xC60B ;
    .dw 0xC000 ;
    .dw 0xC60C ;
    .dw 0xC000 ;
    .dw 0xC60D ;
    .dw 0xC000 ;
    .dw 0xC606 ;
    .dw 0x8000 ;
    .dw 0xC608 ;
    .dw 0x8000 ;
    .dw 0xC60B ;
    .dw 0x8000 ;
    .dw 0xC60C ;
    .dw 0x8000 ;
    .dw 0xC60E ;
    .dw 0x0 ;
    .dw 0xC60E ;
    .dw 0x4000 ;
    .dw 0xC60E ;
    .dw 0x8000 ;
    .dw 0xC60E ;
    .dw 0xC000 ;
    .dw 0xC60F ;
    .dw 0x0 ;
    .dw 0xC60F ;
    .dw 0x4000 ;
    .dw 0xC60F ;
    .dw 0x8000 ;
    .dw 0xC60F ;
    .dw 0xC000 ;
    .dw 0xC610 ;
    .dw 0x0 ;
    .dw 0xC610 ;
    .dw 0x4000 ;
    .dw 0xC610 ;
    .dw 0x8000 ;
    .dw 0xC610 ;
    .dw 0xC000 ;
    .dw 0xC611 ;
    .dw 0x0 ;
    .dw 0xC611 ;
    .dw 0x4000 ;
    .dw 0xC611 ;
    .dw 0x8000 ;
    .dw 0xC611 ;
    .dw 0xC000 ;
    .dw 0xC612 ;
    .dw 0x0 ;
    .dw 0xC612 ;
    .dw 0x4000 ;
    .dw 0xC612 ;
    .dw 0x8000 ;
    .dw 0xC612 ;
    .dw 0xC000 ;
    .dw 0xC613 ;
    .dw 0x0 ;
    .dw 0xC613 ;
    .dw 0x4000 ;
    .dw 0xC613 ;
    .dw 0x8000 ;
    .dw 0xC613 ;
    .dw 0xC000 ;
    .dw 0xC614 ;
    .dw 0x0 ;
    .dw 0xC614 ;
    .dw 0x4000 ;
    .dw 0xC614 ;
    .dw 0x8000 ;
    .dw 0xC614 ;
    .dw 0xC000 ;
    .dw 0xC615 ;
    .dw 0x0 ;
    .dw 0xC615 ;
    .dw 0x4000 ;
    .dw 0xC615 ;
    .dw 0x8000 ;
    .dw 0xC615 ;
    .dw 0xC000 ;
    .dw 0xC616 ;
    .dw 0x0 ;
    .dw 0xC616 ;
    .dw 0x4000 ;
    .dw 0xC616 ;
    .dw 0x8000 ;
    .dw 0xC616 ;
    .dw 0xC000 ;
    .dw 0xC617 ;
    .dw 0x0 ;
    .dw 0xC617 ;
    .dw 0x4000 ;
    .dw 0xC617 ;
    .dw 0x8000 ;
    .dw 0xC617 ;
    .dw 0xC000 ;
    .dw 0xC618 ;
    .dw 0x0 ;
    .dw 0xC618 ;
    .dw 0x4000 ;
    .dw 0xC618 ;
    .dw 0x8000 ;
    .dw 0xC618 ;
    .dw 0xC000 ;
    .dw 0xC619 ;
    .dw 0x0 ;
    .dw 0xC619 ;
    .dw 0x4000 ;
    .dw 0xC619 ;
    .dw 0x8000 ;
    .dw 0xC619 ;
    .dw 0xC000 ;
    .dw 0xC61A ;
    .dw 0x0 ;
    .dw 0xC61A ;
    .dw 0x4000 ;
    .dw 0xC61A ;
    .dw 0x8000 ;
    .dw 0xC61A ;
    .dw 0xC000 ;
    .dw 0xC61B ;
    .dw 0x0 ;
    .dw 0xC61B ;
    .dw 0x4000 ;
    .dw 0xC61B ;
    .dw 0x8000 ;
    .dw 0xC61B ;
    .dw 0xC000 ;
    .dw 0xC61C ;
    .dw 0x0 ;
    .dw 0xC61C ;
    .dw 0x4000 ;
    .dw 0xC61C ;
    .dw 0x8000 ;
    .dw 0xC61C ;
    .dw 0xC000 ;
    .dw 0xC61D ;
    .dw 0x0 ;
    .dw 0xC61D ;
    .dw 0x4000 ;
    .dw 0xC61D ;
    .dw 0x8000 ;
    .dw 0xC61D ;
    .dw 0xC000 ;
    .dw 0xC61E ;
    .dw 0x0 ;
    .dw 0xC61E ;
    .dw 0x4000 ;
    .dw 0xC61E ;
    .dw 0x8000 ;
    .dw 0xC61E ;
    .dw 0xC000 ;
    .dw 0xC61F ;
    .dw 0x0 ;
    .dw 0xC61F ;
    .dw 0x4000 ;
    .dw 0xC61F ;
    .dw 0x8000 ;
    .dw 0xC61F ;
    .dw 0xC000 ;
    .dw 0xC608 ;
    .dw 0x0 ;
    .dw 0xC608 ;
    .dw 0x9 ;
    .dw 0xC608 ;
    .dw 0x12 ;
    .dw 0xC608 ;
    .dw 0x1B ;
    .dw 0xC608 ;
    .dw 0x24 ;
    .dw 0xC608 ;
    .dw 0x2D ;
    .dw 0xC608 ;
    .dw 0x36 ;
    .dw 0xC608 ;
    .dw 0x3F ;
    .dw 0xC608 ;
    .dw 0x4000 ;
    .dw 0xC608 ;
    .dw 0x4009 ;
    .dw 0xC608 ;
    .dw 0x4012 ;
    .dw 0xC608 ;
    .dw 0x401B ;
    .dw 0xC608 ;
    .dw 0x4024 ;
    .dw 0xC608 ;
    .dw 0x402D ;
    .dw 0xC608 ;
    .dw 0x4036 ;
    .dw 0xC608 ;
    .dw 0x403F ;
    .dw 0xC680 ;
    .dw 0xC000 ;
    .dw 0xC681 ;
    .dw 0xC000 ;
    .dw 0xC683 ;
    .dw 0xC000 ;
    .dw 0xC684 ;
    .dw 0x0 ;
    .dw 0xC684 ;
    .dw 0x4000 ;
    .dw 0xC684 ;
    .dw 0x8000 ;
    .dw 0xC684 ;
    .dw 0xC000 ;
    .dw 0xC685 ;
    .dw 0x0 ;
    .dw 0xC685 ;
    .dw 0x4000 ;
    .dw 0xC685 ;
    .dw 0x8000 ;
    .dw 0xC685 ;
    .dw 0xC000 ;
    .dw 0xC686 ;
    .dw 0x0 ;
    .dw 0xC686 ;
    .dw 0x4000 ;
    .dw 0xC686 ;
    .dw 0x8000 ;
    .dw 0xC686 ;
    .dw 0xC000 ;
    .dw 0xC687 ;
    .dw 0x0 ;
    .dw 0xC687 ;
    .dw 0x4000 ;
    .dw 0xC687 ;
    .dw 0x8000 ;
    .dw 0xC687 ;
    .dw 0xC000 ;
    .dw 0xC688 ;
    .dw 0x0 ;
    .dw 0xC688 ;
    .dw 0x4000 ;
    .dw 0xC688 ;
    .dw 0x8000 ;
    .dw 0xC688 ;
    .dw 0xC000 ;
    .dw 0xC689 ;
    .dw 0x0 ;
    .dw 0xC689 ;
    .dw 0x4000 ;
    .dw 0xC689 ;
    .dw 0x8000 ;
    .dw 0xC689 ;
    .dw 0xC000 ;
    .dw 0xC68A ;
    .dw 0x0 ;
    .dw 0xC68A ;
    .dw 0x4000 ;
    .dw 0xC68A ;
    .dw 0x8000 ;
    .dw 0xC68A ;
    .dw 0xC000 ;
    .dw 0xC68B ;
    .dw 0x0 ;
    .dw 0xC68B ;
    .dw 0x4000 ;
    .dw 0xC68B ;
    .dw 0x8000 ;
    .dw 0xC68B ;
    .dw 0xC000 ;
    .dw 0xC68C ;
    .dw 0x0 ;
    .dw 0xC68C ;
    .dw 0x4000 ;
    .dw 0xC68C ;
    .dw 0x8000 ;
    .dw 0xC68C ;
    .dw 0xC000 ;
    .dw 0xC68D ;
    .dw 0x0 ;
    .dw 0xC68D ;
    .dw 0x4000 ;
    .dw 0xC68D ;
    .dw 0x8000 ;
    .dw 0xC68D ;
    .dw 0xC000 ;
    .dw 0xC68E ;
    .dw 0x0 ;
    .dw 0xC68E ;
    .dw 0x4000 ;
    .dw 0xC68E ;
    .dw 0x8000 ;
    .dw 0xC68E ;
    .dw 0xC000 ;
    .dw 0xC68F ;
    .dw 0x0 ;
    .dw 0xC68F ;
    .dw 0x4000 ;
    .dw 0xC68F ;
    .dw 0x8000 ;
    .dw 0xC68F ;
    .dw 0xC000 ;
    .dw 0xC690 ;
    .dw 0x0 ;
    .dw 0xC690 ;
    .dw 0x4000 ;
    .dw 0xC690 ;
    .dw 0x8000 ;
    .dw 0xC690 ;
    .dw 0xC000 ;
    .dw 0xC691 ;
    .dw 0x0 ;
    .dw 0xC691 ;
    .dw 0x4000 ;
    .dw 0xC691 ;
    .dw 0x8000 ;
    .dw 0xC691 ;
    .dw 0xC000 ;
    .dw 0xC692 ;
    .dw 0x0 ;
    .dw 0xC692 ;
    .dw 0x4000 ;
    .dw 0xC692 ;
    .dw 0x8000 ;
    .dw 0xC692 ;
    .dw 0xC000 ;
    .dw 0xC693 ;
    .dw 0x0 ;
    .dw 0xC693 ;
    .dw 0x4000 ;
    .dw 0xC693 ;
    .dw 0x8000 ;
    .dw 0xC693 ;
    .dw 0xC000 ;
    .dw 0xC694 ;
    .dw 0x0 ;
    .dw 0xC694 ;
    .dw 0x4000 ;
    .dw 0xC694 ;
    .dw 0x8000 ;
    .dw 0xC694 ;
    .dw 0xC000 ;
    .dw 0xC695 ;
    .dw 0x0 ;
    .dw 0xC695 ;
    .dw 0x4000 ;
    .dw 0xC695 ;
    .dw 0x8000 ;
    .dw 0xC695 ;
    .dw 0xC000 ;
    .dw 0xC696 ;
    .dw 0x0 ;
    .dw 0xC696 ;
    .dw 0x4000 ;
    .dw 0xC696 ;
    .dw 0x8000 ;
    .dw 0xC696 ;
    .dw 0xC000 ;
    .dw 0xC697 ;
    .dw 0x0 ;
    .dw 0xC697 ;
    .dw 0x4000 ;
    .dw 0xC697 ;
    .dw 0x8000 ;
    .dw 0xC697 ;
    .dw 0xC000 ;
    .dw 0xC698 ;
    .dw 0x0 ;
    .dw 0xC698 ;
    .dw 0x4000 ;
    .dw 0xC698 ;
    .dw 0x8000 ;
    .dw 0xC698 ;
    .dw 0xC000 ;
    .dw 0xC699 ;
    .dw 0x0 ;
    .dw 0xC699 ;
    .dw 0x4000 ;
    .dw 0xC699 ;
    .dw 0x8000 ;
    .dw 0xC699 ;
    .dw 0xC000 ;
    .dw 0xC69A ;
    .dw 0x0 ;
    .dw 0xC69A ;
    .dw 0x4000 ;
    .dw 0xC69A ;
    .dw 0x8000 ;
    .dw 0xC69A ;
    .dw 0xC000 ;
    .dw 0xC69B ;
    .dw 0x0 ;
    .dw 0xC69B ;
    .dw 0x4000 ;
    .dw 0xC69B ;
    .dw 0x8000 ;
    .dw 0xC69B ;
    .dw 0xC000 ;
    .dw 0xC69C ;
    .dw 0x0 ;
    .dw 0xC69C ;
    .dw 0x4000 ;
    .dw 0xC69C ;
    .dw 0x8000 ;
    .dw 0xC69C ;
    .dw 0xC000 ;
    .dw 0xC69D ;
    .dw 0x0 ;
    .dw 0xC69D ;
    .dw 0x4000 ;
    .dw 0xC69D ;
    .dw 0x8000 ;
    .dw 0xC69D ;
    .dw 0xC000 ;
    .dw 0xC69E ;
    .dw 0x0 ;
    .dw 0xC69E ;
    .dw 0x4000 ;
    .dw 0xC69E ;
    .dw 0x8000 ;
    .dw 0xC69E ;
    .dw 0xC000 ;
    .dw 0xC69F ;
    .dw 0x0 ;
    .dw 0xC69F ;
    .dw 0x4000 ;
    .dw 0xC69F ;
    .dw 0x8000 ;
    .dw 0xC69F ;
    .dw 0xC000 ;
    .dw 0xC008 ;
    .dw 0x0 ;
    .dw 0xC008 ;
    .dw 0x40 ;
    .dw 0xC008 ;
    .dw 0xC0 ;
    .dw 0xC008 ;
    .dw 0x140 ;
    .dw 0xC008 ;
    .dw 0x1C0 ;
    .dw 0xC020 ;
    .dw 0x0 ;
    .dw 0xC040 ;
    .dw 0x0 ;
    .dw 0xC0A0 ;
    .dw 0x0 ;
    .dw 0xC0C0 ;
    .dw 0x0 ;
    .dw 0xC0E0 ;
    .dw 0x0 ;
    .dw 0xC120 ;
    .dw 0x0 ;
    .dw 0xC140 ;
    .dw 0x0 ;
    .dw 0xC160 ;
    .dw 0x0 ;
    .dw 0xC180 ;
    .dw 0x0 ;
    .dw 0xC1A0 ;
    .dw 0x0 ;
    .dw 0xC1C0 ;
    .dw 0x0 ;
    .dw 0xC1E0 ;
    .dw 0x0 ;
    .dw 0xC060 ;
    .dw 0x2000 ;
    .dw 0xC0E0 ;
    .dw 0x2000 ;
    .dw 0xC140 ;
    .dw 0x2000 ;
    .dw 0xC1A0 ;
    .dw 0x2000 ;
    .dw 0xC1C0 ;
    .dw 0x2000 ;
    .dw 0xC1E0 ;
    .dw 0x2000 ;
    .dw 0xC064 ;
    .dw 0x0 ;
    .dw 0xC0E4 ;
    .dw 0x0 ;
    .dw 0xC144 ;
    .dw 0x0 ;
    .dw 0xC1A4 ;
    .dw 0x0 ;
    .dw 0xC1C4 ;
    .dw 0x0 ;
    .dw 0xC1E4 ;
    .dw 0x0 ;
    .dw 0xC064 ;
    .dw 0x2000 ;
    .dw 0xC0E4 ;
    .dw 0x2000 ;
    .dw 0xC144 ;
    .dw 0x2000 ;
    .dw 0xC1A4 ;
    .dw 0x2000 ;
    .dw 0xC1C4 ;
    .dw 0x2000 ;
    .dw 0xC1E4 ;
    .dw 0x2000 ;
    .dw 0xC048 ;
    .dw 0x2000 ;
    .dw 0xC068 ;
    .dw 0x2000 ;
    .dw 0xC0A8 ;
    .dw 0x2000 ;
    .dw 0xC0C8 ;
    .dw 0x2000 ;
    .dw 0xC0E8 ;
    .dw 0x2000 ;
    .dw 0xC148 ;
    .dw 0x2000 ;
    .dw 0xC168 ;
    .dw 0x2000 ;
    .dw 0xC188 ;
    .dw 0x2000 ;
    .dw 0xC1A8 ;
    .dw 0x2000 ;
    .dw 0xC1C8 ;
    .dw 0x2000 ;
    .dw 0xC1E8 ;
    .dw 0x2000 ;
    .dw 0xC04C ;
    .dw 0x0 ;
    .dw 0xC06C ;
    .dw 0x0 ;
    .dw 0xC0AC ;
    .dw 0x0 ;
    .dw 0xC0CC ;
    .dw 0x0 ;
    .dw 0xC0EC ;
    .dw 0x0 ;
    .dw 0xC14C ;
    .dw 0x0 ;
    .dw 0xC16C ;
    .dw 0x0 ;
    .dw 0xC18C ;
    .dw 0x0 ;
    .dw 0xC1AC ;
    .dw 0x0 ;
    .dw 0xC1CC ;
    .dw 0x0 ;
    .dw 0xC1EC ;
    .dw 0x0 ;
    .dw 0xC04C ;
    .dw 0x2000 ;
    .dw 0xC06C ;
    .dw 0x2000 ;
    .dw 0xC0AC ;
    .dw 0x2000 ;
    .dw 0xC0CC ;
    .dw 0x2000 ;
    .dw 0xC0EC ;
    .dw 0x2000 ;
    .dw 0xC14C ;
    .dw 0x2000 ;
    .dw 0xC16C ;
    .dw 0x2000 ;
    .dw 0xC18C ;
    .dw 0x2000 ;
    .dw 0xC1AC ;
    .dw 0x2000 ;
    .dw 0xC1CC ;
    .dw 0x2000 ;
    .dw 0xC1EC ;
    .dw 0x2000 ;
    .dw 0xC20C ;
    .dw 0x2040 ;
    .dw 0xC20C ;
    .dw 0x20C0 ;
    .dw 0xC20C ;
    .dw 0x2140 ;
    .dw 0xC20C ;
    .dw 0x21C0 ;
    .dw 0xC248 ;
    .dw 0x2000 ;
    .dw 0xC268 ;
    .dw 0x2000 ;
    .dw 0xC2A8 ;
    .dw 0x2000 ;
    .dw 0xC2C8 ;
    .dw 0x2000 ;
    .dw 0xC2E8 ;
    .dw 0x2000 ;
    .dw 0xC348 ;
    .dw 0x2000 ;
    .dw 0xC368 ;
    .dw 0x2000 ;
    .dw 0xC388 ;
    .dw 0x2000 ;
    .dw 0xC3A8 ;
    .dw 0x2000 ;
    .dw 0xC3C8 ;
    .dw 0x2000 ;
    .dw 0xC3E8 ;
    .dw 0x2000 ;
    .dw 0xC24C ;
    .dw 0x0 ;
    .dw 0xC26C ;
    .dw 0x0 ;
    .dw 0xC2AC ;
    .dw 0x0 ;
    .dw 0xC2CC ;
    .dw 0x0 ;
    .dw 0xC2EC ;
    .dw 0x0 ;
    .dw 0xC34C ;
    .dw 0x0 ;
    .dw 0xC36C ;
    .dw 0x0 ;
    .dw 0xC38C ;
    .dw 0x0 ;
    .dw 0xC3AC ;
    .dw 0x0 ;
    .dw 0xC3CC ;
    .dw 0x0 ;
    .dw 0xC3EC ;
    .dw 0x0 ;
    .dw 0xC24C ;
    .dw 0x2000 ;
    .dw 0xC26C ;
    .dw 0x2000 ;
    .dw 0xC2AC ;
    .dw 0x2000 ;
    .dw 0xC2CC ;
    .dw 0x2000 ;
    .dw 0xC2EC ;
    .dw 0x2000 ;
    .dw 0xC34C ;
    .dw 0x2000 ;
    .dw 0xC36C ;
    .dw 0x2000 ;
    .dw 0xC38C ;
    .dw 0x2000 ;
    .dw 0xC3AC ;
    .dw 0x2000 ;
    .dw 0xC3CC ;
    .dw 0x2000 ;
    .dw 0xC3EC ;
    .dw 0x2000 ;
    .dw 0xC20D ;
    .dw 0x2800 ;
    .dw 0xC20E ;
    .dw 0x2800 ;
    .dw 0xC20F ;
    .dw 0x2800 ;
    .dw 0xC20D ;
    .dw 0x3000 ;
    .dw 0xC20E ;
    .dw 0x3000 ;
    .dw 0xC20F ;
    .dw 0x3000 ;
    .dw 0xC20D ;
    .dw 0x3800 ;
    .dw 0xC20E ;
    .dw 0x3800 ;
    .dw 0xC20F ;
    .dw 0x3800 ;
    .dw 0xC200 ;
    .dw 0x0 ;
    .dw 0xC264 ;
    .dw 0x2000 ;

CHECK_INIT_DEF(p0);  //CHECK_INIT(p0, 0xFF7FFFFC);
                    // Xhandler counts all EXCAUSE = 0x21;
CHECKREG(r5, 2871); // count of all 16 bit UI's.

END:
dbg_pass;            // End the test

//*********************************************************************

//
// Handlers for Events
//

NHANDLE:            // NMI Handler 2
RTN;

XHANDLE:            // Exception Handler 3
                    // 32 bit illegal opcode handler - skips bad instruction

    // handler MADE LEAN and destructive so test runs more quckly
    //   se_undefinedinstruction1.dsp tests using a "nice" handler

//    [--sp] = ASTAT; // save what we damage
//    [--sp] = (r7 - r6);
    R7 = SEQSTAT;
    R7 <<= 26;
    R7 >>= 26;      // only want EXCAUSE
    R6 = 0x21;      // EXCAUSE 0x21 means I-Fetch Undefined Instruction
CC = r7 == r6;
IF CC JUMP UNDEFINEDINSTRUCTION;   // If EXCAUSE != 0x21 then leave

    // Also allow 0x22 for illegal instruction combinations (parallel)
R6 = 0x22;
CC = r7 == r6;
IF CC JUMP UNDEFINEDINSTRUCTION;

dbg_fail;

UNDEFINEDINSTRUCTION:
    R7 = RETX;      // Fix up return address

    R7 += 4;        // skip offending 32 bit instruction

RETX = r7;      // and put back in RETX

    R5 += 1;        // Increment global counter

OUT:
//    (r7 - r6) = [sp++];
//    ASTAT = [sp++];

RTX;

HWHANDLE:           // HW Error Handler 5
RTI;

THANDLE:            // Timer Handler 6
RTI;

I7HANDLE:           // IVG 7 Handler
RTI;

I8HANDLE:           // IVG 8 Handler
RTI;

I9HANDLE:           // IVG 9 Handler
RTI;

I10HANDLE:          // IVG 10 Handler
RTI;

I11HANDLE:          // IVG 11 Handler
RTI;

I12HANDLE:          // IVG 12 Handler
RTI;

I13HANDLE:          // IVG 13 Handler
RTI;

I14HANDLE:          // IVG 14 Handler
RTI;

I15HANDLE:          // IVG 15 Handler
RTI;


    // padding for the icache

EXCPT 0; EXCPT 0; EXCPT 0; EXCPT 0; EXCPT 0; EXCPT 0; EXCPT 0;

//
// Data Segment
//

.data
DATA:
    .space (0x10);

// Stack Segments (Both Kernel and User)

    .space (STACKSIZE);
KSTACK:

    .space (STACKSIZE);
USTACK:
