/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumCommand;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.FileFormatType;
import java.io.IOException;
import java.io.PrintWriter;

public class DatumElement
extends AbstractTeXObject
implements DataNumericElement,
Expandable {
    private TeXObject content;
    private TeXObject currencySymbol;
    private TeXNumber number;
    private DatumType datumType;

    public DatumElement() {
        this(new TeXObjectList(), null, null, DatumType.UNKNOWN);
    }

    public DatumElement(TeXObject teXObject) {
        this(teXObject, null, null, DatumType.STRING);
    }

    public DatumElement(TeXObject teXObject, TeXNumber teXNumber, TeXObject teXObject2, DatumType datumType) {
        this.content = teXObject;
        this.number = teXNumber;
        this.currencySymbol = teXObject2;
        this.datumType = datumType;
    }

    @Override
    public Object clone() {
        DatumElement datumElement = new DatumElement((TeXObject)this.content.clone());
        if (this.number != null) {
            datumElement.number = (TeXNumber)this.number.clone();
        }
        if (this.currencySymbol != null) {
            datumElement.currencySymbol = (TeXObject)this.currencySymbol.clone();
        }
        datumElement.datumType = this.datumType;
        return datumElement;
    }

    @Override
    public byte getDataType() {
        return (byte)this.datumType.getValue();
    }

    @Override
    public DatumType getDatumType() {
        return this.datumType;
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public double doubleValue() {
        return this.number == null ? 0.0 : this.number.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return this.number == null ? 0 : this.number.getValue();
    }

    public Number getNumber() {
        if (this.number == null) {
            return null;
        }
        if (this.datumType == DatumType.INTEGER) {
            return this.number.getValue();
        }
        return this.number.doubleValue();
    }

    public TeXObject getCurrencySymbol() {
        return this.currencySymbol;
    }

    public TeXObject getOriginal() {
        return this.content;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.intValue();
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (this.number == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", this.content.toString(teXParser));
        }
        this.number.advance(teXParser, numerical);
        this.content = this.number;
    }

    @Override
    public void divide(int n) {
        if (this.number != null) {
            this.number.divide(n);
            this.content = this.number;
        }
    }

    @Override
    public void multiply(int n) {
        if (this.number != null) {
            this.number.multiply(n);
            this.content = this.number;
        }
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        teXObjectList2.add(this.content, true);
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.content.canExpand()) {
            return TeXParserUtils.toList(TeXParserUtils.expandFully(this.content, teXParser, teXObjectList), teXParser);
        }
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public ControlSequence createControlSequence(String string) {
        return new DatumCommand(string, this.content, this.getNumber(), this.currencySymbol, this.datumType);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.content.process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.content.process(teXParser);
    }

    public void write(TeXParser teXParser, PrintWriter printWriter, FileFormatType fileFormatType, String string) throws IOException {
        if (fileFormatType == FileFormatType.DBTEX && string.equals("3.0")) {
            printWriter.print("\\dtldbdatumreconstruct{");
            printWriter.print(this.content.toString(teXParser));
            printWriter.print("}{");
            if (this.number != null) {
                printWriter.print(this.number);
            }
            printWriter.print("}{");
            if (this.currencySymbol != null) {
                printWriter.print(this.currencySymbol.toString(teXParser));
            }
            printWriter.print("}{");
            printWriter.print(this.datumType.getValue());
            printWriter.print("}");
        } else {
            printWriter.print(this.content.toString(teXParser));
        }
    }

    public TeXObject getContent(TeXParser teXParser) {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList = teXParserListener.createStack();
        teXObjectList.add(teXParserListener.getControlSequence("__datatool_datum:nnnn"));
        Group group = teXParserListener.createGroup();
        teXObjectList.add(group);
        group.add(this.content, true);
        group = teXParserListener.createGroup();
        teXObjectList.add(group);
        if (this.number != null) {
            group.add(this.number);
        }
        group = teXParserListener.createGroup();
        teXObjectList.add(group);
        if (this.currencySymbol != null) {
            group.add(this.currencySymbol);
        }
        teXObjectList.add(new UserNumber(this.datumType.getValue()));
        return teXObjectList;
    }

    @Override
    public String format() {
        return this.content.format();
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.content.toString(teXParser);
    }

    public String toString() {
        return String.format("%s[content=%s,number=%s,symbol=%s,type=%s]", new Object[]{this.getClass().getSimpleName(), this.content, this.number, this.currencySymbol, this.datumType});
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.content.string(teXParser);
    }
}

