/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataCurrencyElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.io.IOException;

public class DatumCommand
extends Command {
    protected TeXObject original;
    protected TeXObject currencySym;
    protected Number numValue;
    protected DatumType type;

    public DatumCommand(String string, TeXObject teXObject, Number number, TeXObject teXObject2, DatumType datumType) {
        super(string);
        this.original = teXObject;
        this.numValue = number;
        this.currencySym = teXObject2;
        this.type = datumType;
    }

    @Override
    public Object clone() {
        return new DatumCommand(this.getName(), (TeXObject)this.original.clone(), this.numValue, this.currencySym == null ? null : (TeXObject)this.currencySym.clone(), this.type);
    }

    public static DatumCommand createString(String string, TeXObject teXObject) {
        return new DatumCommand(string, teXObject, null, null, DatumType.STRING);
    }

    public static DatumCommand createInteger(String string, TeXObject teXObject, int n) {
        return new DatumCommand(string, teXObject, n, null, DatumType.INTEGER);
    }

    public static DatumCommand createDecimal(String string, TeXObject teXObject, double d) {
        return new DatumCommand(string, teXObject, d, null, DatumType.DECIMAL);
    }

    public static DatumCommand createCurrency(String string, TeXObject teXObject, double d, TeXObject teXObject2) {
        return new DatumCommand(string, teXObject, d, teXObject2, DatumType.CURRENCY);
    }

    public static DatumCommand create(String string, DataElement dataElement) {
        DatumType datumType = dataElement.getDatumType();
        switch (datumType) {
            case INTEGER: {
                return new DatumCommand(string, dataElement, ((DataNumericElement)dataElement).intValue(), null, datumType);
            }
            case DECIMAL: {
                return new DatumCommand(string, dataElement, ((DataNumericElement)dataElement).doubleValue(), null, datumType);
            }
            case CURRENCY: {
                DataCurrencyElement dataCurrencyElement = (DataCurrencyElement)dataElement;
                return new DatumCommand(string, dataElement, dataCurrencyElement.doubleValue(), dataCurrencyElement.getSymbol(), datumType);
            }
        }
        return new DatumCommand(string, dataElement, null, null, datumType);
    }

    public static DatumCommand create(DataToolSty dataToolSty, String string, TeXObject teXObject) throws IOException {
        if (teXObject instanceof DataElement) {
            return DatumCommand.create(string, (DataElement)teXObject);
        }
        if (teXObject.isEmpty()) {
            return new DatumCommand(string, teXObject, null, null, DatumType.UNKNOWN);
        }
        return DatumCommand.create(string, dataToolSty.getElement(teXObject));
    }

    public static DatumCommand create(DataToolBaseSty dataToolBaseSty, String string, TeXObject teXObject) throws IOException {
        if (teXObject instanceof DataElement) {
            return DatumCommand.create(string, (DataElement)teXObject);
        }
        if (teXObject.isEmpty()) {
            return new DatumCommand(string, teXObject, null, null, DatumType.UNKNOWN);
        }
        return DatumCommand.create(string, dataToolBaseSty.getElement(teXObject));
    }

    public TeXObject getOriginal() {
        return this.original;
    }

    public TeXObject getCurrencySymbol() {
        return this.currencySym;
    }

    public Number getNumericValue() {
        return this.numValue;
    }

    public DatumType getType() {
        return this.type;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string;
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        teXObjectList2.add(teXParserListener.getControlSequence("__datatool_datum:nnnn"));
        Group group = teXParserListener.createGroup();
        teXObjectList2.add(group);
        if (teXParser.isStack(this.original)) {
            group.addAll((TeXObjectList)this.original.clone());
        } else {
            group.add((TeXObject)this.original.clone());
        }
        group = teXParserListener.createGroup();
        if (this.numValue != null) {
            switch (this.type) {
                case INTEGER: {
                    group.add(new UserNumber(this.numValue.intValue()));
                    break;
                }
                default: {
                    group.add(new TeXFloatingPoint(this.numValue.doubleValue()));
                }
            }
        }
        teXObjectList2.add(group);
        group = teXParserListener.createGroup();
        teXObjectList2.add(group);
        if (this.currencySym != null) {
            if (teXParser.isStack(this.currencySym)) {
                group.addAll((TeXObjectList)this.currencySym.clone());
            } else {
                group.add((TeXObject)this.currencySym.clone());
            }
        }
        switch (this.type) {
            case STRING: {
                string = "c_datatool_string_int";
                break;
            }
            case INTEGER: {
                string = "c_datatool_integer_int";
                break;
            }
            case DECIMAL: {
                string = "c_datatool_decimal_int";
                break;
            }
            case CURRENCY: {
                string = "c_datatool_currency_int";
                break;
            }
            default: {
                string = "c_datatool_unknown_int";
            }
        }
        teXObjectList2.add(teXParserListener.getControlSequence(string));
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.toList((TeXObject)this.original.clone(), teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserUtils.process((TeXObject)this.original.clone(), teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

