/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Conditional;
import com.dickimawbooks.bib2gls.FieldEvaluation;
import com.dickimawbooks.bib2gls.FieldValueList;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class FieldAssignment {
    private String destField;
    private FieldEvaluation fieldEvaluation;
    private Boolean override;

    public FieldAssignment(String string, FieldValueList fieldValueList, Conditional conditional, Boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.destField = string;
        this.fieldEvaluation = new FieldEvaluation(fieldValueList, conditional);
        this.override = bl;
    }

    public String getDestinationField() {
        return this.destField;
    }

    public boolean isFieldOverrideOn(GlsResource glsResource) {
        if (this.override == null) {
            return glsResource.isAssignOverrideOn();
        }
        return this.override;
    }

    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        return this.fieldEvaluation.getValue(bib2GlsEntry);
    }

    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        return this.fieldEvaluation.getStringValue(bib2GlsEntry);
    }

    public String toString() {
        if (this.override == null) {
            return String.format("%s = %s", this.destField, this.fieldEvaluation);
        }
        if (this.override.booleanValue()) {
            return String.format("%s =[o] %s", this.destField, this.fieldEvaluation);
        }
        return String.format("%s =[n] %s", this.destField, this.fieldEvaluation);
    }
}

