/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0xAF, 0x12, 0xDF, 0x46, 0x71, 0x57, 0x6F, 0x06, 0xDD, 0xC6,
        0x6F, 0x01, 0xED, 0x2F, 0x10, 0x46, 0xF6, 0xB5, 0x38, 0x2B,
        0x58, 0xC0, 0xA5, 0x0A, 0x8D, 0x93, 0xD7, 0x7D, 0x55, 0xEC,
        0xEB, 0xC2, 0x24, 0xAB, 0x62, 0xA7, 0xE9, 0x79, 0xC1, 0x9C,
        0xB7, 0x80, 0xBF, 0xAB, 0xD5, 0x93, 0x82, 0xAB, 0xA3, 0xEE,
        0x0F, 0x70, 0x9F, 0x7F, 0xBE, 0x77, 0x33, 0xA2, 0x4D, 0x31,
        0x92, 0xC5, 0x0C, 0x42, 0x4C, 0x2F, 0x84, 0x96, 0x44, 0xB9,
        0x15, 0x53, 0xEC, 0xA1, 0x89, 0xAC, 0xAD, 0x0D, 0x31, 0xBC,
        0x9B, 0x40, 0x7E, 0xBB, 0x09, 0xC9, 0xF4, 0xC8, 0x4B, 0x97,
        0x3B, 0xDF, 0xE5, 0x29, 0x7B, 0xB8, 0x37, 0xFF, 0xD3, 0xAA,
        0x3D, 0x70, 0xA9, 0x2B, 0x2C, 0xC5, 0xAE, 0xD4, 0x03, 0xFC,
        0xA3, 0xDF, 0x30, 0x17, 0x1A, 0xCF, 0x37, 0xCE, 0xFB, 0xBA,
        0x4F, 0x73, 0x10, 0x6F, 0xB0, 0x8E, 0xC3, 0x43, 0x49, 0xFB,
        0x49, 0x3C, 0x98, 0x7C, 0xA4, 0x61, 0x71, 0xB1, 0xD7, 0x53,
        0xE5, 0x2F, 0x4B, 0xE2, 0x75, 0x86, 0x5C, 0x29, 0xBA, 0x81,
        0x5E, 0xDE, 0xB2, 0xA3, 0x02, 0x63, 0x98, 0x64, 0x14, 0x9F,
        0xFB, 0x0A, 0x85, 0x7D, 0xF6, 0x40, 0xA7, 0x3C, 0xBF, 0x9D,
        0x06, 0x71, 0x76, 0x70, 0x8F, 0x17, 0x41, 0x19, 0x02, 0x3B,
        0xDB, 0xD0, 0x6A, 0x3B, 0x33, 0xFD, 0x49, 0x40, 0x8B, 0x28,
        0x83, 0xEB, 0xA0, 0x71, 0x0B, 0xD9, 0xC8, 0xB9, 0x04, 0xEE,
        0x53, 0xDA, 0x59, 0x7A, 0x85, 0x34, 0xAD, 0xE6, 0xB1, 0x31,
        0x93, 0x23, 0x5D, 0xC5, 0xDE, 0xC8, 0x20, 0xA9, 0x06, 0x6F,
        0x12, 0x1F, 0x88, 0x15, 0x74, 0xDE, 0x98, 0xA2, 0xBC, 0xB5,
        0xEA, 0x11, 0xD9, 0xB0, 0x43, 0x4C, 0x4F, 0xA3, 0x0B, 0x20,
        0x80, 0x84, 0xC4, 0xDF, 0x00, 0xAF, 0x73, 0x66, 0x9D, 0xA0,
        0xAF, 0x05, 0xFE, 0x67, 0x5E, 0xAB
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.64 */
