/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNodeList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "Node.h"
#include "NodeList.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNodeListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNodeListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNodeListTable = { 5, 3, JSNodeListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSNodeListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNodeListConstructorTable = { 1, 0, JSNodeListConstructorTableValues, 0 };
const ClassInfo JSNodeListConstructor::s_info = { "NodeListConstructor", &Base::s_info, &JSNodeListConstructorTable, 0, CREATE_METHOD_TABLE(JSNodeListConstructor) };

JSNodeListConstructor::JSNodeListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSNodeListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSNodeListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSNodeListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeListConstructor, JSDOMWrapper>(exec, &JSNodeListConstructorTable, jsCast<JSNodeListConstructor*>(cell), propertyName, slot);
}

bool JSNodeListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNodeListConstructor, JSDOMWrapper>(exec, &JSNodeListConstructorTable, jsCast<JSNodeListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSNodeListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNodeListPrototypeFunctionItem), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNodeListPrototypeTable = { 2, 1, JSNodeListPrototypeTableValues, 0 };
const ClassInfo JSNodeListPrototype::s_info = { "NodeListPrototype", &Base::s_info, &JSNodeListPrototypeTable, 0, CREATE_METHOD_TABLE(JSNodeListPrototype) };

JSObject* JSNodeListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNodeList>(exec, globalObject);
}

bool JSNodeListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNodeListPrototype* thisObject = jsCast<JSNodeListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSNodeListPrototypeTable, thisObject, propertyName, slot);
}

bool JSNodeListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNodeListPrototype* thisObject = jsCast<JSNodeListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNodeListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSNodeList::s_info = { "NodeList", &Base::s_info, &JSNodeListTable, 0 , CREATE_METHOD_TABLE(JSNodeList) };

JSNodeList::JSNodeList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<NodeList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSNodeList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSNodeList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNodeListPrototype::create(exec->vm(), globalObject, JSNodeListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSNodeList::destroy(JSC::JSCell* cell)
{
    JSNodeList* thisObject = static_cast<JSNodeList*>(cell);
    thisObject->JSNodeList::~JSNodeList();
}

JSNodeList::~JSNodeList()
{
    releaseImplIfNotNull();
}

bool JSNodeList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNodeList* thisObject = jsCast<JSNodeList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSNodeList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<NodeList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<NodeList*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSNodeList, Base>(exec, &JSNodeListTable, thisObject, propertyName, slot);
}

bool JSNodeList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNodeList* thisObject = jsCast<JSNodeList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSNodeListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<NodeList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<NodeList*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSNodeList, Base>(exec, &JSNodeListTable, thisObject, propertyName, descriptor);
}

bool JSNodeList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSNodeList* thisObject = jsCast<JSNodeList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<NodeList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<NodeList*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsNodeListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNodeList* castedThis = jsCast<JSNodeList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    NodeList* impl = static_cast<NodeList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsNodeListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNodeList* domObject = jsCast<JSNodeList*>(asObject(slotBase));
    return JSNodeList::getConstructor(exec, domObject->globalObject());
}

void JSNodeList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSNodeList* thisObject = jsCast<JSNodeList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<NodeList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSNodeList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNodeListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNodeList::s_info))
        return throwVMTypeError(exec);
    JSNodeList* castedThis = jsCast<JSNodeList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNodeList::s_info);
    NodeList* impl = static_cast<NodeList*>(castedThis->impl());
    int index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSNodeList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSNodeList* thisObj = jsCast<JSNodeList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<NodeList*>(thisObj->impl())->item(index));
}

void JSNodeListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSNodeList* jsNodeList = jsCast<JSNodeList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNodeList->impl(), jsNodeList);
    jsNodeList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, NodeList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSNodeList>(exec, impl))
        return result;
    ReportMemoryCost<NodeList>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSNodeList>(exec, globalObject, impl);
}

NodeList* toNodeList(JSC::JSValue value)
{
    return value.inherits(&JSNodeList::s_info) ? jsCast<JSNodeList*>(asObject(value))->impl() : 0;
}

}
