/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTableElement.h"

#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLNames.h"
#include "HTMLTableCaptionElement.h"
#include "HTMLTableElement.h"
#include "HTMLTableSectionElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLTableCaptionElement.h"
#include "JSHTMLTableSectionElement.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTableElementTableValues[] =
{
    { "caption", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementCaption), (intptr_t)setJSHTMLTableElementCaption, NoIntrinsic },
    { "tHead", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementTHead), (intptr_t)setJSHTMLTableElementTHead, NoIntrinsic },
    { "tFoot", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementTFoot), (intptr_t)setJSHTMLTableElementTFoot, NoIntrinsic },
    { "rows", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementRows), (intptr_t)0, NoIntrinsic },
    { "tBodies", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementTBodies), (intptr_t)0, NoIntrinsic },
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementAlign), (intptr_t)setJSHTMLTableElementAlign, NoIntrinsic },
    { "bgColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementBgColor), (intptr_t)setJSHTMLTableElementBgColor, NoIntrinsic },
    { "border", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementBorder), (intptr_t)setJSHTMLTableElementBorder, NoIntrinsic },
    { "cellPadding", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementCellPadding), (intptr_t)setJSHTMLTableElementCellPadding, NoIntrinsic },
    { "cellSpacing", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementCellSpacing), (intptr_t)setJSHTMLTableElementCellSpacing, NoIntrinsic },
    { "frame", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementFrame), (intptr_t)setJSHTMLTableElementFrame, NoIntrinsic },
    { "rules", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementRules), (intptr_t)setJSHTMLTableElementRules, NoIntrinsic },
    { "summary", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementSummary), (intptr_t)setJSHTMLTableElementSummary, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementWidth), (intptr_t)setJSHTMLTableElementWidth, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableElementTable = { 35, 31, JSHTMLTableElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTableElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableElementConstructorTable = { 1, 0, JSHTMLTableElementConstructorTableValues, 0 };
const ClassInfo JSHTMLTableElementConstructor::s_info = { "HTMLTableElementConstructor", &Base::s_info, &JSHTMLTableElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTableElementConstructor) };

JSHTMLTableElementConstructor::JSHTMLTableElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTableElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLTableElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLTableElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableElementConstructorTable, jsCast<JSHTMLTableElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTableElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTableElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableElementConstructorTable, jsCast<JSHTMLTableElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableElementPrototypeTableValues[] =
{
    { "createTHead", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionCreateTHead), (intptr_t)0, NoIntrinsic },
    { "deleteTHead", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionDeleteTHead), (intptr_t)0, NoIntrinsic },
    { "createTFoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionCreateTFoot), (intptr_t)0, NoIntrinsic },
    { "deleteTFoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionDeleteTFoot), (intptr_t)0, NoIntrinsic },
    { "createTBody", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionCreateTBody), (intptr_t)0, NoIntrinsic },
    { "createCaption", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionCreateCaption), (intptr_t)0, NoIntrinsic },
    { "deleteCaption", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionDeleteCaption), (intptr_t)0, NoIntrinsic },
    { "insertRow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionInsertRow), (intptr_t)0, NoIntrinsic },
    { "deleteRow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableElementPrototypeFunctionDeleteRow), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableElementPrototypeTable = { 34, 31, JSHTMLTableElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTableElementPrototype::s_info = { "HTMLTableElementPrototype", &Base::s_info, &JSHTMLTableElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTableElementPrototype) };

JSObject* JSHTMLTableElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTableElement>(exec, globalObject);
}

bool JSHTMLTableElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTableElementPrototype* thisObject = jsCast<JSHTMLTableElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLTableElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLTableElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTableElementPrototype* thisObject = jsCast<JSHTMLTableElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLTableElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLTableElement::s_info = { "HTMLTableElement", &Base::s_info, &JSHTMLTableElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLTableElement) };

JSHTMLTableElement::JSHTMLTableElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTableElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTableElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTableElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTableElementPrototype::create(exec->vm(), globalObject, JSHTMLTableElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTableElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTableElement* thisObject = jsCast<JSHTMLTableElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTableElement, Base>(exec, &JSHTMLTableElementTable, thisObject, propertyName, slot);
}

bool JSHTMLTableElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTableElement* thisObject = jsCast<JSHTMLTableElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTableElement, Base>(exec, &JSHTMLTableElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTableElementCaption(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->caption()));
    return result;
}


JSValue jsHTMLTableElementTHead(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->tHead()));
    return result;
}


JSValue jsHTMLTableElementTFoot(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->tFoot()));
    return result;
}


JSValue jsHTMLTableElementRows(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->rows()));
    return result;
}


JSValue jsHTMLTableElementTBodies(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->tBodies()));
    return result;
}


JSValue jsHTMLTableElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLTableElementBgColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}


JSValue jsHTMLTableElementBorder(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::borderAttr));
    return result;
}


JSValue jsHTMLTableElementCellPadding(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::cellpaddingAttr));
    return result;
}


JSValue jsHTMLTableElementCellSpacing(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::cellspacingAttr));
    return result;
}


JSValue jsHTMLTableElementFrame(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::frameAttr));
    return result;
}


JSValue jsHTMLTableElementRules(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::rulesAttr));
    return result;
}


JSValue jsHTMLTableElementSummary(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::summaryAttr));
    return result;
}


JSValue jsHTMLTableElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}


JSValue jsHTMLTableElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableElement* domObject = jsCast<JSHTMLTableElement*>(asObject(slotBase));
    return JSHTMLTableElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTableElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLTableElement* thisObject = jsCast<JSHTMLTableElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLTableElement, Base>(exec, propertyName, value, &JSHTMLTableElementTable, thisObject, slot);
}

void setJSHTMLTableElementCaption(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    HTMLTableCaptionElement* nativeValue(toHTMLTableCaptionElement(value));
    if (exec->hadException())
        return;
    impl->setCaption(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSHTMLTableElementTHead(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    HTMLTableSectionElement* nativeValue(toHTMLTableSectionElement(value));
    if (exec->hadException())
        return;
    impl->setTHead(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSHTMLTableElementTFoot(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    HTMLTableSectionElement* nativeValue(toHTMLTableSectionElement(value));
    if (exec->hadException())
        return;
    impl->setTFoot(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSHTMLTableElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::alignAttr, nativeValue);
}


void setJSHTMLTableElementBgColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::bgcolorAttr, nativeValue);
}


void setJSHTMLTableElementBorder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::borderAttr, nativeValue);
}


void setJSHTMLTableElementCellPadding(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::cellpaddingAttr, nativeValue);
}


void setJSHTMLTableElementCellSpacing(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::cellspacingAttr, nativeValue);
}


void setJSHTMLTableElementFrame(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::frameAttr, nativeValue);
}


void setJSHTMLTableElementRules(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::rulesAttr, nativeValue);
}


void setJSHTMLTableElementSummary(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::summaryAttr, nativeValue);
}


void setJSHTMLTableElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(thisObject);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::widthAttr, nativeValue);
}


JSValue JSHTMLTableElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTableElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionCreateTHead(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createTHead()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionDeleteTHead(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    impl->deleteTHead();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionCreateTFoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createTFoot()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionDeleteTFoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    impl->deleteTFoot();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionCreateTBody(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createTBody()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionCreateCaption(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createCaption()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionDeleteCaption(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    impl->deleteCaption();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionInsertRow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int index(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->insertRow(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableElementPrototypeFunctionDeleteRow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableElement* castedThis = jsCast<JSHTMLTableElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableElement::s_info);
    HTMLTableElement* impl = static_cast<HTMLTableElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int index(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->deleteRow(index, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


}
