/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEventException.h"

#include "EventException.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEventExceptionTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventExceptionCode), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventExceptionName), (intptr_t)0, NoIntrinsic },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventExceptionMessage), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventExceptionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEventExceptionTable = { 10, 7, JSEventExceptionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSEventExceptionConstructorTableValues[] =
{
    { "UNSPECIFIED_EVENT_TYPE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventExceptionUNSPECIFIED_EVENT_TYPE_ERR), (intptr_t)0, NoIntrinsic },
    { "DISPATCH_REQUEST_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventExceptionDISPATCH_REQUEST_ERR), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEventExceptionConstructorTable = { 4, 3, JSEventExceptionConstructorTableValues, 0 };
static const HashTable* getJSEventExceptionConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEventExceptionConstructorTable);
}

const ClassInfo JSEventExceptionConstructor::s_info = { "EventExceptionConstructor", &Base::s_info, 0, getJSEventExceptionConstructorTable, CREATE_METHOD_TABLE(JSEventExceptionConstructor) };

JSEventExceptionConstructor::JSEventExceptionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSEventExceptionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSEventExceptionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSEventExceptionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventExceptionConstructor, JSDOMWrapper>(exec, getJSEventExceptionConstructorTable(exec), jsCast<JSEventExceptionConstructor*>(cell), propertyName, slot);
}

bool JSEventExceptionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEventExceptionConstructor, JSDOMWrapper>(exec, getJSEventExceptionConstructorTable(exec), jsCast<JSEventExceptionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSEventExceptionPrototypeTableValues[] =
{
    { "UNSPECIFIED_EVENT_TYPE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventExceptionUNSPECIFIED_EVENT_TYPE_ERR), (intptr_t)0, NoIntrinsic },
    { "DISPATCH_REQUEST_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventExceptionDISPATCH_REQUEST_ERR), (intptr_t)0, NoIntrinsic },
    { "toString", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEventExceptionPrototypeFunctionToString), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEventExceptionPrototypeTable = { 8, 7, JSEventExceptionPrototypeTableValues, 0 };
static const HashTable* getJSEventExceptionPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEventExceptionPrototypeTable);
}

const ClassInfo JSEventExceptionPrototype::s_info = { "EventExceptionPrototype", &Base::s_info, 0, getJSEventExceptionPrototypeTable, CREATE_METHOD_TABLE(JSEventExceptionPrototype) };

JSObject* JSEventExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEventException>(exec, globalObject);
}

bool JSEventExceptionPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEventExceptionPrototype* thisObject = jsCast<JSEventExceptionPrototype*>(cell);
    return getStaticPropertySlot<JSEventExceptionPrototype, JSObject>(exec, getJSEventExceptionPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSEventExceptionPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEventExceptionPrototype* thisObject = jsCast<JSEventExceptionPrototype*>(object);
    return getStaticPropertyDescriptor<JSEventExceptionPrototype, JSObject>(exec, getJSEventExceptionPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSEventExceptionTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEventExceptionTable);
}

const ClassInfo JSEventException::s_info = { "EventException", &Base::s_info, 0, getJSEventExceptionTable , CREATE_METHOD_TABLE(JSEventException) };

JSEventException::JSEventException(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<EventException> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSEventException::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSEventException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEventExceptionPrototype::create(exec->vm(), globalObject, JSEventExceptionPrototype::createStructure(globalObject->vm(), globalObject, globalObject->errorPrototype()));
}

void JSEventException::destroy(JSC::JSCell* cell)
{
    JSEventException* thisObject = static_cast<JSEventException*>(cell);
    thisObject->JSEventException::~JSEventException();
}

JSEventException::~JSEventException()
{
    releaseImplIfNotNull();
}

bool JSEventException::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEventException* thisObject = jsCast<JSEventException*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSEventException, Base>(exec, getJSEventExceptionTable(exec), thisObject, propertyName, slot);
}

bool JSEventException::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEventException* thisObject = jsCast<JSEventException*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSEventException, Base>(exec, getJSEventExceptionTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsEventExceptionCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEventException* castedThis = jsCast<JSEventException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EventException* impl = static_cast<EventException*>(castedThis->impl());
    JSValue result = jsNumber(impl->code());
    return result;
}


JSValue jsEventExceptionName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEventException* castedThis = jsCast<JSEventException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EventException* impl = static_cast<EventException*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsEventExceptionMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEventException* castedThis = jsCast<JSEventException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EventException* impl = static_cast<EventException*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->message());
    return result;
}


JSValue jsEventExceptionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEventException* domObject = jsCast<JSEventException*>(asObject(slotBase));
    return JSEventException::getConstructor(exec, domObject->globalObject());
}

JSValue JSEventException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEventExceptionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsEventExceptionPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEventException::s_info))
        return throwVMTypeError(exec);
    JSEventException* castedThis = jsCast<JSEventException*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEventException::s_info);
    EventException* impl = static_cast<EventException*>(castedThis->impl());

    JSC::JSValue result = jsStringWithCache(exec, impl->toString());
    return JSValue::encode(result);
}

// Constant getters

JSValue jsEventExceptionUNSPECIFIED_EVENT_TYPE_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsEventExceptionDISPATCH_REQUEST_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

static inline bool isObservable(JSEventException* jsEventException)
{
    if (jsEventException->hasCustomProperties())
        return true;
    return false;
}

bool JSEventExceptionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSEventException* jsEventException = jsCast<JSEventException*>(handle.get().asCell());
    if (!isObservable(jsEventException))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSEventExceptionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSEventException* jsEventException = jsCast<JSEventException*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEventException->impl(), jsEventException);
    jsEventException->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, EventException* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSEventException>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to EventException.
    COMPILE_ASSERT(!__is_polymorphic(EventException), EventException_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<EventException>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSEventException>(exec, globalObject, impl);
}

EventException* toEventException(JSC::JSValue value)
{
    return value.inherits(&JSEventException::s_info) ? jsCast<JSEventException*>(asObject(value))->impl() : 0;
}

}
