/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMouseEvent.h"

#include "Clipboard.h"
#include "EventTarget.h"
#include "ExceptionCode.h"
#include "JSClipboard.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "JSDictionary.h"
#include "JSEventTarget.h"
#include "JSNode.h"
#include "MouseEvent.h"
#include "Node.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMouseEventTableValues[] =
{
    { "screenX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventScreenX), (intptr_t)0, NoIntrinsic },
    { "screenY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventScreenY), (intptr_t)0, NoIntrinsic },
    { "clientX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventClientX), (intptr_t)0, NoIntrinsic },
    { "clientY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventClientY), (intptr_t)0, NoIntrinsic },
    { "ctrlKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventCtrlKey), (intptr_t)0, NoIntrinsic },
    { "shiftKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventShiftKey), (intptr_t)0, NoIntrinsic },
    { "altKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventAltKey), (intptr_t)0, NoIntrinsic },
    { "metaKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventMetaKey), (intptr_t)0, NoIntrinsic },
    { "button", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventButton), (intptr_t)0, NoIntrinsic },
    { "relatedTarget", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventRelatedTarget), (intptr_t)0, NoIntrinsic },
#if ENABLE(POINTER_LOCK)
    { "webkitMovementX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventWebkitMovementX), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(POINTER_LOCK)
    { "webkitMovementY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventWebkitMovementY), (intptr_t)0, NoIntrinsic },
#endif
    { "offsetX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventOffsetX), (intptr_t)0, NoIntrinsic },
    { "offsetY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventOffsetY), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventY), (intptr_t)0, NoIntrinsic },
    { "fromElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventFromElement), (intptr_t)0, NoIntrinsic },
    { "toElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventToElement), (intptr_t)0, NoIntrinsic },
    { "dataTransfer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventDataTransfer), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMouseEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMouseEventTable = { 65, 63, JSMouseEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMouseEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMouseEventConstructorTable = { 1, 0, JSMouseEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSMouseEventConstructor::constructJSMouseEvent(ExecState* exec)
{
    JSMouseEventConstructor* jsConstructor = jsCast<JSMouseEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    MouseEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillMouseEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<MouseEvent> event = MouseEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillMouseEventInit(MouseEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillUIEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("screenX", eventInit.screenX))
        return false;
    if (!dictionary.tryGetProperty("screenY", eventInit.screenY))
        return false;
    if (!dictionary.tryGetProperty("clientX", eventInit.clientX))
        return false;
    if (!dictionary.tryGetProperty("clientY", eventInit.clientY))
        return false;
    if (!dictionary.tryGetProperty("ctrlKey", eventInit.ctrlKey))
        return false;
    if (!dictionary.tryGetProperty("shiftKey", eventInit.shiftKey))
        return false;
    if (!dictionary.tryGetProperty("altKey", eventInit.altKey))
        return false;
    if (!dictionary.tryGetProperty("metaKey", eventInit.metaKey))
        return false;
    if (!dictionary.tryGetProperty("button", eventInit.button))
        return false;
    if (!dictionary.tryGetProperty("relatedTarget", eventInit.relatedTarget))
        return false;
    return true;
}

const ClassInfo JSMouseEventConstructor::s_info = { "MouseEventConstructor", &Base::s_info, &JSMouseEventConstructorTable, 0, CREATE_METHOD_TABLE(JSMouseEventConstructor) };

JSMouseEventConstructor::JSMouseEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMouseEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSMouseEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSMouseEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMouseEventConstructor, JSDOMWrapper>(exec, &JSMouseEventConstructorTable, jsCast<JSMouseEventConstructor*>(cell), propertyName, slot);
}

bool JSMouseEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMouseEventConstructor, JSDOMWrapper>(exec, &JSMouseEventConstructorTable, jsCast<JSMouseEventConstructor*>(object), propertyName, descriptor);
}

#if ENABLE(DOM4_EVENTS_CONSTRUCTOR)
ConstructType JSMouseEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSMouseEvent;
    return ConstructTypeHost;
}
#endif // ENABLE(DOM4_EVENTS_CONSTRUCTOR)

/* Hash table for prototype */

static const HashTableValue JSMouseEventPrototypeTableValues[] =
{
    { "initMouseEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMouseEventPrototypeFunctionInitMouseEvent), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMouseEventPrototypeTable = { 2, 1, JSMouseEventPrototypeTableValues, 0 };
const ClassInfo JSMouseEventPrototype::s_info = { "MouseEventPrototype", &Base::s_info, &JSMouseEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSMouseEventPrototype) };

JSObject* JSMouseEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMouseEvent>(exec, globalObject);
}

bool JSMouseEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMouseEventPrototype* thisObject = jsCast<JSMouseEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSMouseEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSMouseEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMouseEventPrototype* thisObject = jsCast<JSMouseEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSMouseEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSMouseEvent::s_info = { "MouseEvent", &Base::s_info, &JSMouseEventTable, 0 , CREATE_METHOD_TABLE(JSMouseEvent) };

JSMouseEvent::JSMouseEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MouseEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

void JSMouseEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSMouseEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMouseEventPrototype::create(exec->vm(), globalObject, JSMouseEventPrototype::createStructure(exec->vm(), globalObject, JSUIEventPrototype::self(exec, globalObject)));
}

bool JSMouseEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMouseEvent* thisObject = jsCast<JSMouseEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMouseEvent, Base>(exec, &JSMouseEventTable, thisObject, propertyName, slot);
}

bool JSMouseEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMouseEvent* thisObject = jsCast<JSMouseEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMouseEvent, Base>(exec, &JSMouseEventTable, thisObject, propertyName, descriptor);
}

JSValue jsMouseEventScreenX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenX());
    return result;
}


JSValue jsMouseEventScreenY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenY());
    return result;
}


JSValue jsMouseEventClientX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientX());
    return result;
}


JSValue jsMouseEventClientY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->clientY());
    return result;
}


JSValue jsMouseEventCtrlKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->ctrlKey());
    return result;
}


JSValue jsMouseEventShiftKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->shiftKey());
    return result;
}


JSValue jsMouseEventAltKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->altKey());
    return result;
}


JSValue jsMouseEventMetaKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->metaKey());
    return result;
}


JSValue jsMouseEventButton(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->button());
    return result;
}


JSValue jsMouseEventRelatedTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->relatedTarget()));
    return result;
}


#if ENABLE(POINTER_LOCK)
JSValue jsMouseEventWebkitMovementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitMovementX());
    return result;
}

#endif

#if ENABLE(POINTER_LOCK)
JSValue jsMouseEventWebkitMovementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitMovementY());
    return result;
}

#endif

JSValue jsMouseEventOffsetX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->offsetX());
    return result;
}


JSValue jsMouseEventOffsetY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->offsetY());
    return result;
}


JSValue jsMouseEventX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->x());
    return result;
}


JSValue jsMouseEventY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->y());
    return result;
}


JSValue jsMouseEventFromElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->fromElement()));
    return result;
}


JSValue jsMouseEventToElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->toElement()));
    return result;
}


JSValue jsMouseEventDataTransfer(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->dataTransfer()));
    return result;
}


JSValue jsMouseEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMouseEvent* domObject = jsCast<JSMouseEvent*>(asObject(slotBase));
    return JSMouseEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSMouseEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMouseEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMouseEventPrototypeFunctionInitMouseEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMouseEvent::s_info))
        return throwVMTypeError(exec);
    JSMouseEvent* castedThis = jsCast<JSMouseEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMouseEvent::s_info);
    MouseEvent* impl = static_cast<MouseEvent*>(castedThis->impl());
    const String& type(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubble(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelable(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* view(toDOMWindow(exec->argument(3)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int detail(toInt32(exec, exec->argument(4), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenX(toInt32(exec, exec->argument(5), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenY(toInt32(exec, exec->argument(6), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientX(toInt32(exec, exec->argument(7), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int clientY(toInt32(exec, exec->argument(8), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ctrlKey(exec->argument(9).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altKey(exec->argument(10).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool shiftKey(exec->argument(11).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool metaKey(exec->argument(12).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned short button(toUInt32(exec, exec->argument(13), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    EventTarget* relatedTarget(toEventTarget(exec->argument(14)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initMouseEvent(type, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedTarget);
    return JSValue::encode(jsUndefined());
}


}
