/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBVersionChangeEvent.h"

#include "IDBAny.h"
#include "IDBVersionChangeEvent.h"
#include "JSIDBAny.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSIDBVersionChangeEventTableValues[] =
{
    { "oldVersion", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBVersionChangeEventOldVersion), (intptr_t)0, NoIntrinsic },
    { "newVersion", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBVersionChangeEventNewVersion), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBVersionChangeEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBVersionChangeEventTable = { 8, 7, JSIDBVersionChangeEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSIDBVersionChangeEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBVersionChangeEventConstructorTable = { 1, 0, JSIDBVersionChangeEventConstructorTableValues, 0 };
static const HashTable* getJSIDBVersionChangeEventConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBVersionChangeEventConstructorTable);
}

const ClassInfo JSIDBVersionChangeEventConstructor::s_info = { "IDBVersionChangeEventConstructor", &Base::s_info, 0, getJSIDBVersionChangeEventConstructorTable, CREATE_METHOD_TABLE(JSIDBVersionChangeEventConstructor) };

JSIDBVersionChangeEventConstructor::JSIDBVersionChangeEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBVersionChangeEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSIDBVersionChangeEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSIDBVersionChangeEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBVersionChangeEventConstructor, JSDOMWrapper>(exec, getJSIDBVersionChangeEventConstructorTable(exec), jsCast<JSIDBVersionChangeEventConstructor*>(cell), propertyName, slot);
}

bool JSIDBVersionChangeEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBVersionChangeEventConstructor, JSDOMWrapper>(exec, getJSIDBVersionChangeEventConstructorTable(exec), jsCast<JSIDBVersionChangeEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSIDBVersionChangeEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBVersionChangeEventPrototypeTable = { 1, 0, JSIDBVersionChangeEventPrototypeTableValues, 0 };
static const HashTable* getJSIDBVersionChangeEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBVersionChangeEventPrototypeTable);
}

const ClassInfo JSIDBVersionChangeEventPrototype::s_info = { "IDBVersionChangeEventPrototype", &Base::s_info, 0, getJSIDBVersionChangeEventPrototypeTable, CREATE_METHOD_TABLE(JSIDBVersionChangeEventPrototype) };

JSObject* JSIDBVersionChangeEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBVersionChangeEvent>(exec, globalObject);
}

static const HashTable* getJSIDBVersionChangeEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBVersionChangeEventTable);
}

const ClassInfo JSIDBVersionChangeEvent::s_info = { "IDBVersionChangeEvent", &Base::s_info, 0, getJSIDBVersionChangeEventTable , CREATE_METHOD_TABLE(JSIDBVersionChangeEvent) };

JSIDBVersionChangeEvent::JSIDBVersionChangeEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBVersionChangeEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSIDBVersionChangeEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBVersionChangeEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBVersionChangeEventPrototype::create(exec->vm(), globalObject, JSIDBVersionChangeEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSIDBVersionChangeEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBVersionChangeEvent* thisObject = jsCast<JSIDBVersionChangeEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSIDBVersionChangeEvent, Base>(exec, getJSIDBVersionChangeEventTable(exec), thisObject, propertyName, slot);
}

bool JSIDBVersionChangeEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBVersionChangeEvent* thisObject = jsCast<JSIDBVersionChangeEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSIDBVersionChangeEvent, Base>(exec, getJSIDBVersionChangeEventTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsIDBVersionChangeEventOldVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBVersionChangeEvent* castedThis = jsCast<JSIDBVersionChangeEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBVersionChangeEvent* impl = static_cast<IDBVersionChangeEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->oldVersion()));
    return result;
}


JSValue jsIDBVersionChangeEventNewVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBVersionChangeEvent* castedThis = jsCast<JSIDBVersionChangeEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBVersionChangeEvent* impl = static_cast<IDBVersionChangeEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->newVersion()));
    return result;
}


JSValue jsIDBVersionChangeEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBVersionChangeEvent* domObject = jsCast<JSIDBVersionChangeEvent*>(asObject(slotBase));
    return JSIDBVersionChangeEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSIDBVersionChangeEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBVersionChangeEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(INDEXED_DATABASE)
