/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSErrorEvent.h"

#include "ErrorEvent.h"
#include "JSDictionary.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSErrorEventTableValues[] =
{
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventMessage), (intptr_t)0, NoIntrinsic },
    { "filename", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventFilename), (intptr_t)0, NoIntrinsic },
    { "lineno", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventLineno), (intptr_t)0, NoIntrinsic },
    { "colno", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventColno), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsErrorEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSErrorEventTable = { 16, 15, JSErrorEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSErrorEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSErrorEventConstructorTable = { 1, 0, JSErrorEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSErrorEventConstructor::constructJSErrorEvent(ExecState* exec)
{
    JSErrorEventConstructor* jsConstructor = jsCast<JSErrorEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    ErrorEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillErrorEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<ErrorEvent> event = ErrorEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillErrorEventInit(ErrorEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("message", eventInit.message))
        return false;
    if (!dictionary.tryGetProperty("filename", eventInit.filename))
        return false;
    if (!dictionary.tryGetProperty("lineno", eventInit.lineno))
        return false;
    if (!dictionary.tryGetProperty("colno", eventInit.colno))
        return false;
    return true;
}

static const HashTable* getJSErrorEventConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSErrorEventConstructorTable);
}

const ClassInfo JSErrorEventConstructor::s_info = { "ErrorEventConstructor", &Base::s_info, 0, getJSErrorEventConstructorTable, CREATE_METHOD_TABLE(JSErrorEventConstructor) };

JSErrorEventConstructor::JSErrorEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSErrorEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSErrorEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSErrorEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSErrorEventConstructor, JSDOMWrapper>(exec, getJSErrorEventConstructorTable(exec), jsCast<JSErrorEventConstructor*>(cell), propertyName, slot);
}

bool JSErrorEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSErrorEventConstructor, JSDOMWrapper>(exec, getJSErrorEventConstructorTable(exec), jsCast<JSErrorEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSErrorEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSErrorEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSErrorEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSErrorEventPrototypeTable = { 1, 0, JSErrorEventPrototypeTableValues, 0 };
static const HashTable* getJSErrorEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSErrorEventPrototypeTable);
}

const ClassInfo JSErrorEventPrototype::s_info = { "ErrorEventPrototype", &Base::s_info, 0, getJSErrorEventPrototypeTable, CREATE_METHOD_TABLE(JSErrorEventPrototype) };

JSObject* JSErrorEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSErrorEvent>(exec, globalObject);
}

static const HashTable* getJSErrorEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSErrorEventTable);
}

const ClassInfo JSErrorEvent::s_info = { "ErrorEvent", &Base::s_info, 0, getJSErrorEventTable , CREATE_METHOD_TABLE(JSErrorEvent) };

JSErrorEvent::JSErrorEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ErrorEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSErrorEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSErrorEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSErrorEventPrototype::create(exec->vm(), globalObject, JSErrorEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSErrorEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSErrorEvent* thisObject = jsCast<JSErrorEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSErrorEvent, Base>(exec, getJSErrorEventTable(exec), thisObject, propertyName, slot);
}

bool JSErrorEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSErrorEvent* thisObject = jsCast<JSErrorEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSErrorEvent, Base>(exec, getJSErrorEventTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsErrorEventMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSErrorEvent* castedThis = jsCast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* impl = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->message());
    return result;
}


JSValue jsErrorEventFilename(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSErrorEvent* castedThis = jsCast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* impl = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->filename());
    return result;
}


JSValue jsErrorEventLineno(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSErrorEvent* castedThis = jsCast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* impl = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->lineno());
    return result;
}


JSValue jsErrorEventColno(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSErrorEvent* castedThis = jsCast<JSErrorEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ErrorEvent* impl = static_cast<ErrorEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->colno());
    return result;
}


JSValue jsErrorEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSErrorEvent* domObject = jsCast<JSErrorEvent*>(asObject(slotBase));
    return JSErrorEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSErrorEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSErrorEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
